# Batch file for sample java files
#
# If not installed in ORACLE_HOME, set ORACLE_HOME to installation root
#
# ======================================================================

set ALL=FALSE
set MAKE_CLASSPATH=.;%ORACLE_HOME%\lib\xmlparserv2.jar;%ORACLE_HOME%\lib\xschema.jar;%ORACLE_HOME%\lib\classgen.jar;%CLASSPATH%

if (%1) == ()  set ALL=TRUE& goto :WIDL
if (%1) == (widl) goto :WIDL
if (%1) == (checkbook) goto :CHECKBOOK
if (%1) == (trade) goto :TRADE
if (%1) == (node) goto :NODE
if (%1) == (car) goto :CAR
if (%1) == (book) goto :BOOK
if (%1) == (po) goto :PO
if (%1) == (clean) goto :CLEAN
goto :EOF

:WIDL
cd .\Widl & javac -classpath %MAKE_CLASSPATH% SampleMain.java
java -classpath %MAKE_CLASSPATH% SampleMain Widl.xml
javac -classpath %MAKE_CLASSPATH% BINDING.java CONDITION.java REGION.java SERVICE.java VARIABLE.java WIDL.java
javac -classpath %MAKE_CLASSPATH% TestWidl.java
java  -classpath %MAKE_CLASSPATH% TestWidl
cd ..
if (%ALL%) == (TRUE) goto :CHECKBOOK
goto :EOF

:CHECKBOOK
cd .\Checkbook & java -classpath %MAKE_CLASSPATH% oracle.xml.classgen.oracg -comment -dtd -root checkbook checkbook.dtd
javac -classpath %MAKE_CLASSPATH% CheckbookApp.java
java -classpath %MAKE_CLASSPATH% CheckbookApp checkbook.xml > checkbook_out.xml
cd ..
if (%ALL%) == (TRUE) goto :TRADE
goto :EOF

:TRADE
cd .\Trade& java -classpath %MAKE_CLASSPATH% oracle.xml.classgen.oracg -comment -dtd -root trade trade.dtd
javac -classpath %MAKE_CLASSPATH% TradeLister.java
java -classpath %MAKE_CLASSPATH% TradeLister trade.xml > trade_out.xml
cd ..
if (%ALL%) == (TRUE) goto :NODE
goto :EOF

:NODE
cd .\Node& java -classpath %MAKE_CLASSPATH% oracle.xml.classgen.oracg -cooment -dtd -root node node.dtd
javac -classpath %MAKE_CLASSPATH% NodeLister.java
java -classpath %MAKE_CLASSPATH% NodeLister node.xml > node_out.xml
cd ..
if (%ALL%) == (TRUE) goto :CAR
goto :EOF

:CAR
cd .\Car& java -classpath %MAKE_CLASSPATH% oracle.xml.classgen.oracg -comment -schema car.xsd -package package1
javac -classpath %MAKE_CLASSPATH% CarDealer.java package1\*.java
java -classpath %MAKE_CLASSPATH% CarDealer > car_out.txt
cd ..
if (%ALL%) == (TRUE) goto :BOOK
goto :EOF

:BOOK
cd .\Book& java -classpath %MAKE_CLASSPATH% oracle.xml.classgen.oracg -comment -schema book.xsd -package package2
javac -classpath %MAKE_CLASSPATH% BookCatalogue.java package2\*.java
java -classpath %MAKE_CLASSPATH% BookCatalogue > book_out.txt
cd ..
if (%ALL%) == (TRUE) goto :PO
goto :EOF

:PO
cd .\Po& java -classpath %MAKE_CLASSPATH% oracle.xml.classgen.oracg -comment -schema po.xsd -package package3
javac -classpath %MAKE_CLASSPATH% TestPo.java package3\*.java
java -classpath %MAKE_CLASSPATH% TestPo > po_out.txt
cd ..
goto :EOF


:CLEAN
del *.class
cd .\Widl& del *.class& del Widl_out.xml
del BINDING.java CONDITION.java REGION.java SERVICE.java VARIABLE.jav a WIDL.java
cd ..\Checkbook& del *.class checkbook_out.xml Checkbook_dtd.txt xml.ser
del Amount.java Balance.java Check.java Checkbook.java Cleared.java Date.java Deposit.java Memo.java Name.java Pending.java Transactions.java Void.java Withdrawal.java
cd ..\Trade& del *.class trade_out.xml Trade_dtd.txt xml.ser
del Date.java Limit.java Quantity.java Stop.java Symbol.java Trade.java
cd ..\Node& del *.class node_out.xml Node_dtd.txt Node.java xml.ser
cd ..\Car& del *.class car_out.xml & rmdir /s /q package1
cd ..\Book& del *.class book_out.xml & rmdir /s /q package2
cd ..\Po& del *.class po_out.xml & rmdir /s /q package3
cd ..

:EOF
