set scan off
set echo off
REM
REM $Author: kkarun $
REM $Date: 20-apr-00.23:37:15 $
REM $Source: /vobs/oracore3/demo/xdk/java/xsql/demo/airport/airport.sql.mkelem $
REM $Revision: /main/0 $
REM

drop table Ticket ;
drop table Passenger ;
drop table Flight ;
drop table Aircraft ;
drop table Flight_Crew ;
drop table Employee  ;
drop table Airport;

create table airport( tla varchar2(3), 
                      description varchar2(80), 
                      primary key (tla));

insert into airport values('SFO','San Francisco, California, Usa');
insert into airport values('JFK','New York Ny/Newark, Nj-Kennedy');

create table Aircraft (
  Make                  VARCHAR2(20),
  Model                 VARCHAR2(20),
  Capacity              NUMBER,
  Serial_Number         NUMBER primary key
);

INSERT INTO Aircraft VALUES(
 'Boeing','747',350,12312231);

INSERT INTO Aircraft VALUES(
 'Airbus','320A',280, 5534222);

  
create table Employee  (
  Name                  VARCHAR2(40),
  SSNUM                   NUMBER primary key
);

INSERT INTO Employee VALUES(
 'Steve Smith', 234223432
);

INSERT INTO Employee VALUES(
 'Kim Barnes', 893923334
);

INSERT INTO Employee VALUES(
 'Jack Unger', 983433342
);


create table Flight_Crew (
  CrewID     NUMBER PRIMARY KEY,
  Pilot      NUMBER,
  CoPilot   NUMBER,
  Purser     NUMBER,
  foreign key (pilot) references employee,
  foreign key (copilot) references employee,
  foreign key (purser) references employee
);

insert into flight_crew values( 8001, 893923334, 234223432, 983433342 );
insert into flight_crew values( 8002, 234223432, 983433342, 893923334 );


create table Flight (
  FlightID              NUMBER primary key,
  FlightNumber          VARCHAR2(6),
  Depart_From           VARCHAR2(3),
  Arrive_To             VARCHAR2(3),
  Scheduled_Date        DATE,
  Scheduled_Time        VARCHAR2(5),
  Equipment             NUMBER,
  Crew                  NUMBER,
  foreign key (depart_from) references airport,
  foreign key (arrive_to)  references airport,
  foreign key (equipment) references aircraft,
  foreign key (crew) references flight_crew
);

INSERT INTO Flight VALUES(
  190021,
  'UA85',
  'SFO',
  'JFK',
  '18-NOV-98',
  '17:05',
  12312231,
  8001
);

INSERT INTO Flight VALUES(
  19828,
  'UA86',
  'JFK',
  'SFO',
  '18-NOV-98',
  '21:00',
  5534222,
  8002
);


create table Passenger (
  FullName              VARCHAR2(30) primary key,
  Last_Flight           NUMBER,
  WorkPhone             VARCHAR2(30),
  CreditCard            VARCHAR2(30),
  Expiration            VARCHAR2(30),
  Photo                 VARCHAR2(80)
);

INSERT INTO Passenger (
  FullName , 
  WorkPhone ,
  CreditCard ,
  Expiration,
  Photo )
VALUES (
  'Jane Rucker',
  '(412) 456-1765',
  '5689 076 544 988',
  '10/98',
  'rucker.gif'
);
INSERT INTO Passenger (
  FullName , 
  WorkPhone ,
  CreditCard ,
  Expiration,
  Photo )
VALUES (
  'Peter Crux',
  '(313) 201-9987',
  '1287 099 445 101',
  '8/97',
  'crux.gif'
);
INSERT INTO Passenger (
  FullName , 
  WorkPhone ,
  CreditCard ,
  Expiration,
  Photo )
VALUES (
  'Pat Hayward',
  '(415) 516-9799',
  '3344 011 223 704',
  '7/99',
  'hayward.gif'
);


create table Ticket (
  customer              VARCHAR2(30),
  Class                 VARCHAR2(1),
  Seat                  VARCHAR2(3),
  Outbound              NUMBER,
  Return                NUMBER,
  Confirmed             VARCHAR2(3), /* YES, NO */
  Paid                  VARCHAR2(3), /* YES, NO */
  Ticket_Issued         VARCHAR2(3), /* YEs, No */    
  Locator               VARCHAR2(6) primary key,
  foreign key (outbound) references flight,
  foreign key (return) references flight,
  foreign key (customer) references passenger
);

INSERT INTO Ticket Values (
 'Pat Hayward', 'Y','6F', 190021, 19828,
	'Yes', 'No',
	'No','XYZ001');
INSERT INTO Ticket Values (
'Peter Crux', 'Y','5A', 190021, 19828,
	'Yes', 'Yes',
	'No','QRS67P');
INSERT INTO Ticket Values (
 'Jane Rucker', 'Y','22C', 190021, 19828,
	'Yes', 'Yes',
	'Yes','UYY890');



commit;

set echo off
insert into airport values('AAA','Anaa, French Polynesia');
insert into airport values('AAB','Arrabury, Qld, Australia');
insert into airport values('AAC','Al Arish, Arab Rep. Of Egypt');
insert into airport values('AAE','Annaba, Algeria');
insert into airport values('AAF','Apalachicola, Florida, Usa');
insert into airport values('AAI','Arraias, To, Brazil');
insert into airport values('AAK','Aranuka, Rep. Of Kiribati');
insert into airport values('AAL','Aalborg, Denmark');
insert into airport values('AAM','Mala Mala, South Africa');
insert into airport values('AAN','Al Ain, U. A. Emirates');
insert into airport values('AAO','Anaco, Venezuela');
insert into airport values('AAQ','Anapa, Ussr');
insert into airport values('AAR','Aarhus, Denmark');
insert into airport values('AAS','Apalapsili, Indonesia');
insert into airport values('AAT','Altay, P. R. China');
insert into airport values('AAU','Asau, Western Samoa');
insert into airport values('AAV','Alah, Philippines');
insert into airport values('AAX','Araxa, Mg, Brazil');
insert into airport values('AAY','Al Ghaydah, Yemen, Republic Of');
insert into airport values('ABA','Abakan, Ussr');
insert into airport values('ABD','Abadan, Iran, Islamic Rep. Of');
insert into airport values('ABE','Allentown, Pennsylvania, Usa');
insert into airport values('ABF','Abaiang, Rep. Of Kiribati');
insert into airport values('ABG','Abingdon, Qld, Australia');
insert into airport values('ABH','Alpha, Qld, Australia');
insert into airport values('ABI','Abilene, Texas, Usa');
insert into airport values('ABJ','Abidjan, Cote D''Ivoire');
commit;
insert into airport values('ABK','Kabri Dar, Ethiopia');
insert into airport values('ABL','Ambler, Alaska, Usa');
insert into airport values('ABM','Bamaga, Qld, Australia');
insert into airport values('ABN','Albina, Republic Of Suriname');
insert into airport values('ABO','Aboisso, Cote D''Ivoire');
insert into airport values('ABP','Atkamba, Papua New Guinea');
insert into airport values('ABQ','Albuquerque, New Mexico, Usa');
insert into airport values('ABR','Aberdeen, South Dakota, Usa');
insert into airport values('ABS','Abu Simbel, Arab Rep. Of Egypt');
insert into airport values('ABT','Al-Baha, Saudi Arabia');
insert into airport values('ABU','Atambua, Indonesia');
insert into airport values('ABV','Abuja, Nigeria');
insert into airport values('ABW','Abau, Papua New Guinea');
insert into airport values('ABX','Albury, Nsw, Australia');
insert into airport values('ABY','Albany, Georgia, Usa');
insert into airport values('ABZ','Aberdeen, Scotland Uk');
insert into airport values('ACA','Acapulco, Mexico');
insert into airport values('ACB','Bellaire, Michigan, Usa');
insert into airport values('ACC','Accra, Ghana');
insert into airport values('ACD','Acandi, Colombia');
insert into airport values('ACE','Lanzarote, Canary Islands');
insert into airport values('ACH','Altenrhein, Switzerland');
insert into airport values('ACI','Alderney, Channel Islands Uk');
insert into airport values('ACK','Nantucket, Massachusetts, Usa');
insert into airport values('ACL','Aguaclara, Colombia');
insert into airport values('ACM','Arica, Colombia');
insert into airport values('ACN','Ciudad Acuna, Mexico');
insert into airport values('ACO','Ascona, Switzerland');
insert into airport values('ACR','Araracuara, Colombia');
insert into airport values('ACS','Achinsk, Ussr');
commit;
insert into airport values('ACT','Waco, Texas, Usa');
insert into airport values('ACU','Achutupo, Panama Republic');
insert into airport values('ACV','Eureka/Arcata, California,-Acv');
insert into airport values('ACY','Atlantic City, New Jer-Intl');
insert into airport values('ADA','Adana, Turkey');
insert into airport values('ADB','Izmir, Turkey-Adnan Mend');
insert into airport values('ADD','Addis Ababa, Ethiopia');
insert into airport values('ADE','Aden, Yemen, Republic Of');
insert into airport values('ADG','Adrian, Michigan, Usa');
insert into airport values('ADH','Aldan, Ussr');
insert into airport values('ADI','Arandis, Namibia');
insert into airport values('ADK','Adak Island, Alaska, Usa');
insert into airport values('ADL','Adelaide, Sa, Australia');
insert into airport values('ADM','Ardmore, Oklahoma, Usa-Municip');
insert into airport values('ADN','Andes, Colombia');
insert into airport values('ADO','Andamooka, Sa, Australia');
insert into airport values('ADP','Anuradhapura, Sri Lanka');
insert into airport values('ADQ','Kodiak, Alaska, Usa-Adq');
insert into airport values('ADR','Andrews, South Carolina, Usa');
insert into airport values('ADV','Andover, England Uk');
insert into airport values('ADW','Camp Springs, Maryland, Usa');
insert into airport values('ADX','St. Andrews, Scotland Uk');
insert into airport values('ADY','Alldays, South Africa');
insert into airport values('ADZ','San Andres Island, Colombia');
insert into airport values('AEA','Abemama, Rep. Of Kiribati');
insert into airport values('AEG','Aek Godang, Indonesia');
insert into airport values('AEH','Abecher, Chad');
insert into airport values('AEK','Aseki, Papua New Guinea');
insert into airport values('AEL','Albert Lea, Minnesota, Usa');
insert into airport values('AEO','Aioun El Atrouss, Mauritania');
commit;
insert into airport values('AEP','Buenos Aires, Ba, Arge-Newbery');
insert into airport values('AER','Adler/Sochi, Ussr');
insert into airport values('AES','Aalesund, Norway');
insert into airport values('AET','Allakaket, Alaska, Usa');
insert into airport values('AEY','Akureyri, Iceland');
insert into airport values('AFA','San Rafael, Md, Argentina');
insert into airport values('AFD','Port Alfred, South Africa');
insert into airport values('AFI','Amalfi, Colombia');
insert into airport values('AFL','Alta Floresta, Mt, Brazil');
insert into airport values('AFN','Jaffrey, New Hampshire, Usa');
insert into airport values('AFO','Afton, Wyoming, Usa');
insert into airport values('AFR','Afore, Papua New Guinea');
insert into airport values('AFY','Afyon, Turkey');
insert into airport values('AGA','Agadir, Morocco');
insert into airport values('AGB','Augsburg, Fed. Rep. Of Germany');
insert into airport values('AGC','Pittsburgh, Pennsylvan-Alleghe');
insert into airport values('AGD','Anggi, Indonesia');
insert into airport values('AGE','Wangerooge, Fed. Rep. Of Germa');
insert into airport values('AGF','Agen, France');
insert into airport values('AGG','Angoram, Papua New Guinea');
insert into airport values('AGH','Helsingborg, Sweden-Angelholm');
insert into airport values('AGI','Wageningen, Republic Of Surina');
insert into airport values('AGJ','Aguni, Japan');
insert into airport values('AGK','Kagua, Papua New Guinea');
insert into airport values('AGL','Wanigela, Papua New Guinea');
insert into airport values('AGM','Angmagssalik, Greenland');
insert into airport values('AGN','Angoon, Alaska, Usa');
insert into airport values('AGO','Magnolia, Arkansas, Usa');
insert into airport values('AGP','Malaga, Spain');
insert into airport values('AGQ','Agrinion, Greece');
commit;
insert into airport values('AGR','Agra, India');
insert into airport values('AGS','Augusta, Georgia, Usa');
insert into airport values('AGT','Ciudad Del Este, Paraguay');
insert into airport values('AGU','Aguascalientes, Mexico');
insert into airport values('AGV','Acarigua, Venezuela');
insert into airport values('AGW','Agnew, Qld, Australia');
insert into airport values('AGX','Agatti Island, India');
insert into airport values('AGY','Argyle Downs, Wa, Australia');
insert into airport values('AGZ','Aggeneys, South Africa');
insert into airport values('AHB','Abha, Saudi Arabia');
insert into airport values('AHD','Ardmore, Oklahoma, Usa-Downtow');
insert into airport values('AHH','Amery, Wisconsin, Usa');
insert into airport values('AHI','Amahai, Indonesia');
insert into airport values('AHL','Aishalton, Guyana');
insert into airport values('AHN','Athens, Georgia, Usa');
insert into airport values('AHO','Alghero, Italy');
insert into airport values('AHS','Ahuas, Honduras');
insert into airport values('AHT','Amchitka, Alaska, Usa');
insert into airport values('AHU','Al Hoceima, Morocco');
insert into airport values('AHY','Ambatolahy, Dem. Rep. Madagasc');
insert into airport values('AHZ','Alpe D''Huez, France');
insert into airport values('AIA','Alliance, Nebraska, Usa');
insert into airport values('AIB','Anita Bay, Alaska, Usa');
insert into airport values('AIC','Airok, Marshall Islands');
insert into airport values('AIE','Aiome, Papua New Guinea');
insert into airport values('AIF','Assis, Sp, Brazil');
insert into airport values('AIG','Yalinga, Cen. African Republic');
insert into airport values('AII','Ali Sabieh, Djibouti');
insert into airport values('AIK','Aiken, South Carolina, Usa');
insert into airport values('AIL','Ailigandi, Panama Republic');
commit;
insert into airport values('AIM','Ailuk, Marshall Islands');
insert into airport values('AIN','Wainwright, Alaska, Usa');
insert into airport values('AIO','Atlantic, Iowa, Usa');
insert into airport values('AIP','Ailinglapalap, Marshall Island');
insert into airport values('AIS','Arorae Island, Rep. Of Kiribat');
insert into airport values('AIT','Aitutaki, Cook Islands, S. Pac');
insert into airport values('AIU','Atiu, Cook Islands, S. Pacific');
insert into airport values('AIV','Aliceville, Alabama, Usa');
insert into airport values('AIY','Atlantic City, New Jer-Bader');
insert into airport values('AIZ','Lake Of The Ozarks, Missouri,');
insert into airport values('AJA','Ajaccio, Corsica, France');
insert into airport values('AJF','Jouf, Saudi Arabia');
insert into airport values('AJJ','Akjoujt, Mauritania');
insert into airport values('AJL','Aizawl, India');
insert into airport values('AJN','Anjouan, Comoros');
insert into airport values('AJO','Aljouf, Yemen, Republic Of');
insert into airport values('AJR','Arvidsjaur, Sweden');
insert into airport values('AJS','Abreojos, Mexico');
insert into airport values('AJU','Aracaju, Se, Brazil');
insert into airport values('AJY','Agades, Niger');
insert into airport values('AKA','Ankang, P. R. China');
insert into airport values('AKB','Atka, Alaska, Usa');
insert into airport values('AKD','Akola, India');
insert into airport values('AKE','Akieni, Gabon');
insert into airport values('AKF','Kufrah, Libyan A Jamahiriya');
insert into airport values('AKG','Anguganak, Papua New Guinea');
insert into airport values('AKI','Akiak, Alaska, Usa');
insert into airport values('AKJ','Asahikawa, Japan');
insert into airport values('AKK','Akhiok, Alaska, Usa');
insert into airport values('AKL','Auckland, New Zealand-Intl');
commit;
insert into airport values('AKM','Zakouma, Chad');
insert into airport values('AKN','King Salmon, Alaska, Usa');
insert into airport values('AKO','Akron, Colorado, Usa');
insert into airport values('AKP','Anaktuvuk Pass, Alaska, Usa');
insert into airport values('AKQ','Astraksetra, Indonesia');
insert into airport values('AKR','Akure, Nigeria');
insert into airport values('AKS','Auki, Solomon Islands');
insert into airport values('AKU','Aksu, P. R. China');
insert into airport values('AKV','Akulivik, Quebec, Canada');
insert into airport values('AKX','Aktyubinsk, Ussr');
insert into airport values('AKY','Sittwe, Myanmar');
insert into airport values('ALB','Albany, New York, Usa');
insert into airport values('ALC','Alicante, Spain');
insert into airport values('ALD','Alerta, Peru');
insert into airport values('ALE','Alpine, Texas, Usa');
insert into airport values('ALF','Alta, Norway');
insert into airport values('ALG','Algiers, Algeria');
insert into airport values('ALH','Albany, Wa, Australia');
insert into airport values('ALI','Alice, Texas, Usa');
insert into airport values('ALJ','Alexander Bay, South Africa');
insert into airport values('ALK','Asela, Ethiopia');
insert into airport values('ALL','Albenga, Italy');
insert into airport values('ALM','Alamogordo, New Mexico, Usa');
insert into airport values('ALN','Alton, Illinois, Usa');
insert into airport values('ALO','Waterloo, Iowa, Usa');
insert into airport values('ALP','Aleppo, Syria');
insert into airport values('ALQ','Alegrete, Rs, Brazil');
insert into airport values('ALR','Alexandra, New Zealand');
insert into airport values('ALS','Alamosa, Colorado, Usa');
insert into airport values('ALT','Alenquer, Pa, Brazil');
commit;
insert into airport values('ALU','Alula, Somalia');
insert into airport values('ALV','Andorra La Vella, Andorra');
insert into airport values('ALW','Walla Walla, Washington, Usa');
insert into airport values('ALX','Alexander City, Alabama, Usa');
insert into airport values('ALY','Alexandria, Arab Rep. Of Egypt');
insert into airport values('ALZ','Alitak, Alaska, Usa');
insert into airport values('AMA','Amarillo, Texas, Usa-Intl');
insert into airport values('AMB','Ambilobe, Dem. Rep. Madagascar');
insert into airport values('AMC','Am Timan, Chad');
insert into airport values('AMD','Ahmedabad, India');
insert into airport values('AME','Alto Molocue, Mozambique');
insert into airport values('AMF','Ama, Papua New Guinea');
insert into airport values('AMG','Amboin, Papua New Guinea');
insert into airport values('AMH','Arba Mintch, Ethiopia');
insert into airport values('AMI','Mataram, Indonesia');
insert into airport values('AMJ','Almenara, Mg, Brazil');
insert into airport values('AML','Puerto Armuelles, Panama Repub');
insert into airport values('AMM','Amman, Jordan');
insert into airport values('AMN','Alma, Michigan, Usa');
insert into airport values('AMO','Mao, Chad');
insert into airport values('AMP','Ampanihy, Dem. Rep. Madagascar');
insert into airport values('AMQ','Ambon, Indonesia');
insert into airport values('AMR','Arno, Marshall Islands');
insert into airport values('AMS','Amsterdam, Netherlands');
insert into airport values('AMT','Amata, Nt, Australia');
insert into airport values('AMU','Amanab, Papua New Guinea');
insert into airport values('AMV','Amderma, Ussr');
insert into airport values('AMW','Ames, Iowa, Usa');
insert into airport values('AMX','Ammaroo, Nt, Australia');
insert into airport values('AMY','Ambatomainty, Dem. Rep. Madaga');
commit;
insert into airport values('AMZ','Ardmore, New Zealand');
insert into airport values('ANB','Anniston, Alabama, Usa');
insert into airport values('ANC','Anchorage, Alaska, Usa-Intl');
insert into airport values('AND','Anderson, South Carolina, Usa');
insert into airport values('ANE','Angers, France');
insert into airport values('ANF','Antofagasta, Chile');
insert into airport values('ANG','Angouleme, France');
insert into airport values('ANH','Anuha Island Resort, Solomon I');
insert into airport values('ANI','Aniak, Alaska, Usa');
insert into airport values('ANJ','Zanaga, Peop. Rep. Of The Cong');
insert into airport values('ANK','Ankara, Turkey');
insert into airport values('ANL','Andulo, Angola');
insert into airport values('ANM','Antalaha, Dem. Rep. Madagascar');
insert into airport values('ANN','Annette Island, Alaska, Usa');
insert into airport values('ANO','Angoche, Mozambique');
insert into airport values('ANP','Annapolis, Maryland, Usa');
insert into airport values('ANQ','Angola, Indiana, Usa');
insert into airport values('ANR','Antwerp, Belgium');
insert into airport values('ANS','Andahuaylas, Peru');
insert into airport values('ANU','Antigua, West Indies');
insert into airport values('ANV','Anvik, Alaska, Usa');
insert into airport values('ANW','Ainsworth, Nebraska, Usa');
insert into airport values('ANX','Andenes, Norway');
insert into airport values('ANY','Anthony, Kansas, Usa');
insert into airport values('ANZ','Angas Downs, Nt, Australia');
insert into airport values('AOA','Aroa, Papua New Guinea');
insert into airport values('AOB','Annanberg, Papua New Guinea');
insert into airport values('AOD','Abou Deia, Chad');
insert into airport values('AOH','Lima, Ohio, Usa');
insert into airport values('AOI','Ancona, Italy');
commit;
insert into airport values('AOJ','Aomori, Japan');
insert into airport values('AOK','Karpathos, Greece');
insert into airport values('AOL','Paso De Los Libres, Cr, Argent');
insert into airport values('AON','Arona, Papua New Guinea');
insert into airport values('AOO','Altoona, Pennsylvania, Usa');
insert into airport values('AOR','Alor Setar, Malaysia');
insert into airport values('AOS','Amook, Alaska, Usa');
insert into airport values('AOU','Attopeu, Laos');
insert into airport values('APA','Denver, Colorado, Usa-Arapahoe');
insert into airport values('APB','Apolo, Bolivia');
insert into airport values('APC','Napa, California, Usa');
insert into airport values('APE','San Juan Aposento, Peru');
insert into airport values('APF','Naples, Florida, Usa');
insert into airport values('APH','Bowling Green, Virginia, Usa');
insert into airport values('API','Apiay, Colombia');
insert into airport values('APK','Apataki, French Polynesia');
insert into airport values('APL','Nampula, Mozambique');
insert into airport values('APN','Alpena, Michigan, Usa');
insert into airport values('APO','Apartado, Colombia');
insert into airport values('APP','Asapa, Papua New Guinea');
insert into airport values('APQ','Arapiraca, Al, Brazil');
insert into airport values('APR','April River, Papua New Guinea');
insert into airport values('APS','Anapolis, Go, Brazil');
insert into airport values('APT','Jasper, Tennessee, Usa');
insert into airport values('APU','Apucarana, Pr, Brazil');
insert into airport values('APV','Apple Valley, California, Usa');
insert into airport values('APW','Apia, Western Samoa-Faleolo');
insert into airport values('APX','Arapongas, Pr, Brazil');
insert into airport values('APY','Alto Parnaiba, Ma, Brazil');
insert into airport values('APZ','Zapala, Ne, Argentina');
commit;
insert into airport values('AQA','Araraquara, Sp, Brazil');
insert into airport values('AQG','Anqing, P. R. China');
insert into airport values('AQI','Qaisumah, Saudi Arabia');
insert into airport values('AQJ','Aqaba, Jordan');
insert into airport values('AQM','Ariquemes, Ro, Brazil');
insert into airport values('AQP','Arequipa, Peru');
insert into airport values('AQS','Saqani, Fiji');
insert into airport values('AQY','Alyeska, Alaska, Usa');
insert into airport values('ARB','Ann Arbor, Michigan, Usa');
insert into airport values('ARC','Arctic Village, Alaska, Usa');
insert into airport values('ARD','Alor, Indonesia');
insert into airport values('ARE','Arecibo, Puerto Rico');
insert into airport values('ARF','Acaricuara, Colombia');
insert into airport values('ARG','Walnut Ridge, Arkansas, Usa');
insert into airport values('ARH','Arkhangelsk, Ussr');
insert into airport values('ARI','Arica, Chile');
insert into airport values('ARJ','Arso, Indonesia');
insert into airport values('ARL','Arly, Burkina Faso');
insert into airport values('ARM','Armidale, Nsw, Australia');
insert into airport values('ARN','Stockholm, Sweden-Arlanda');
insert into airport values('ARO','Arboletas, Colombia');
insert into airport values('ARP','Aragip, Papua New Guinea');
insert into airport values('ARQ','Arauquita, Colombia');
insert into airport values('ARR','Alto Rio Senguerr, Cb, Argenti');
insert into airport values('ARS','Aragarcas, Go, Brazil');
insert into airport values('ART','Watertown, New York, Usa');
insert into airport values('ARU','Aracatuba, Sp, Brazil');
insert into airport values('ARV','Minocqua, Wisconsin, Usa');
insert into airport values('ARW','Arad, Romania');
insert into airport values('ARX','Asbury Pk/Monmouth Co, Nj, Usa');
commit;
insert into airport values('ARY','Ararat, Vic, Australia');
insert into airport values('ARZ','N''Zeto, Angola');
insert into airport values('ASA','Assab, Ethiopia');
insert into airport values('ASB','Ashkhabad, Ussr');
insert into airport values('ASC','Ascension, Bolivia');
insert into airport values('ASD','Andros Town, Bahamas');
insert into airport values('ASE','Aspen, Colorado, Usa');
insert into airport values('ASF','Astrakhan, Ussr');
insert into airport values('ASG','Ashburton, New Zealand');
insert into airport values('ASH','Nashua, New Hampshire, Usa');
insert into airport values('ASJ','Amami O Shima, Japan');
insert into airport values('ASK','Yamoussoukro, Cote D''Ivoire');
insert into airport values('ASM','Asmara, Ethiopia');
insert into airport values('ASN','Talladega, Alabama, Usa');
insert into airport values('ASO','Asosa, Ethiopia');
insert into airport values('ASP','Alice Springs, Nt, Australia');
insert into airport values('ASQ','Austin, Nevada, Usa');
insert into airport values('ASR','Kayseri, Turkey');
insert into airport values('AST','Astoria, Oregon, Usa');
insert into airport values('ASU','Asuncion, Paraguay');
insert into airport values('ASV','Amboseli, Kenya');
insert into airport values('ASW','Aswan, Arab Rep. Of Egypt');
insert into airport values('ASX','Ashland, Wisconsin, Usa');
insert into airport values('ASY','Ashley, North Dakota, Usa');
insert into airport values('ATA','Anta, Peru');
insert into airport values('ATB','Atbara, Sudan');
insert into airport values('ATC','Arthur''S Town, Bahamas');
insert into airport values('ATD','Atoifi, Solomon Islands');
insert into airport values('ATE','Antlers, Oklahoma, Usa');
insert into airport values('ATF','Ambato, Ecuador');
commit;
insert into airport values('ATH','Athens, Greece');
insert into airport values('ATI','Artigas, Uruguay');
insert into airport values('ATJ','Antsirabe, Dem. Rep. Madagasca');
insert into airport values('ATK','Atqasuk, Alaska, Usa');
insert into airport values('ATL','Atlanta, Georgia, Usa-Hartsfie');
insert into airport values('ATM','Altamira, Pa, Brazil');
insert into airport values('ATN','Namatanai, Papua New Guinea');
insert into airport values('ATO','Athens, Ohio, Usa');
insert into airport values('ATP','Aitape, Papua New Guinea');
insert into airport values('ATQ','Amritsar, India');
insert into airport values('ATR','Atar, Mauritania');
insert into airport values('ATS','Artesia, New Mexico, Usa');
insert into airport values('ATT','Atmautluak, Alaska, Usa');
insert into airport values('ATU','Attu Is., Alaska, Usa');
insert into airport values('ATV','Ati, Chad');
insert into airport values('ATW','Appleton, Wisconsin, Usa');
insert into airport values('ATX','Atbasar, Ussr');
insert into airport values('ATY','Watertown, South Dakota, Usa');
insert into airport values('ATZ','Assiut, Arab Rep. Of Egypt');
insert into airport values('AUA','Aruba, Aruba');
insert into airport values('AUC','Arauca, Colombia');
insert into airport values('AUD','Augustus Downs, Qld, Australia');
insert into airport values('AUE','Abu Ruedis, Arab Rep. Of Egypt');
insert into airport values('AUG','Augusta, Maine, Usa');
insert into airport values('AUH','Abu Dhabi, U. A. Emirates');
insert into airport values('AUI','Aua, Papua New Guinea');
insert into airport values('AUJ','Ambunti, Papua New Guinea');
insert into airport values('AUK','Alakanuk, Alaska, Usa');
insert into airport values('AUL','Aur, Marshall Islands');
insert into airport values('AUM','Austin, Minnesota, Usa');
commit;
insert into airport values('AUN','Auburn, California, Usa');
insert into airport values('AUO','Auburn/Opelika, Alabama, Usa');
insert into airport values('AUP','Agaun, Papua New Guinea');
insert into airport values('AUQ','Atuona, French Polynesia');
insert into airport values('AUR','Aurillac, France');
insert into airport values('AUS','Austin, Texas, Usa');
insert into airport values('AUT','Atauro, Indonesia');
insert into airport values('AUU','Aurukun Mission, Qld, Australi');
insert into airport values('AUW','Wausau, Wisconsin, Usa-Municip');
insert into airport values('AUX','Araguaina, To, Brazil');
insert into airport values('AUY','Aneityum, Vanuatu');
insert into airport values('AUZ','Aurora, Illinois, Usa');
insert into airport values('AVB','Aviano, Italy');
insert into airport values('AVG','Auvergne, Nt, Australia');
insert into airport values('AVI','Ciego De Avila, Cuba');
insert into airport values('AVK','Arvaikheer, Mongolia');
insert into airport values('AVL','Asheville, North Carolina, Usa');
insert into airport values('AVN','Avignon, France');
insert into airport values('AVO','Avon Park, Florida, Usa');
insert into airport values('AVP','Wilkes-Barre/Scranton, Pa, Usa');
insert into airport values('AVU','Avu Avu, Solomon Islands');
insert into airport values('AVV','Avalon, Vic, Australia');
insert into airport values('AVW','Tucson, Arizona, Usa-Avra');
insert into airport values('AVX','Catalina Is., Californ-Avalon');
insert into airport values('AWA','Awassa, Ethiopia');
insert into airport values('AWB','Awaba, Papua New Guinea');
insert into airport values('AWD','Aniwa, Vanuatu');
insert into airport values('AWE','Alowe, Gabon');
insert into airport values('AWH','Awareh, Ethiopia');
insert into airport values('AWK','Wake Island, Pacific Ocean');
commit;
insert into airport values('AWM','West Memphis, Arkansas, Usa');
insert into airport values('AWN','Alton Downs, Sa, Australia');
insert into airport values('AWP','Austral Downs, Qld, Australia');
insert into airport values('AWR','Awar, Papua New Guinea');
insert into airport values('AWZ','Ahwaz, Iran, Islamic Rep. Of');
insert into airport values('AXA','Anguilla, West Indies');
insert into airport values('AXB','Alexandria Bay, New York, Usa');
insert into airport values('AXC','Aramac, Qld, Australia');
insert into airport values('AXD','Alexandroupolis, Greece');
insert into airport values('AXG','Algona, Iowa, Usa');
insert into airport values('AXK','Ataq, Yemen, Republic Of');
insert into airport values('AXL','Alexandria, Nt, Australia');
insert into airport values('AXM','Armenia, Colombia');
insert into airport values('AXN','Alexandria, Minnesota, Usa');
insert into airport values('AXP','Spring Point, Bahamas');
insert into airport values('AXR','Arutua, French Polynesia');
insert into airport values('AXS','Altus, Oklahoma, Usa');
insert into airport values('AXT','Akita, Japan');
insert into airport values('AXU','Axum, Ethiopia');
insert into airport values('AXV','Wapakoneta, Ohio, Usa');
insert into airport values('AXX','Angel Fire, New Mexico, Usa');
insert into airport values('AYA','Ayapel, Colombia');
insert into airport values('AYC','Ayacucho, Colombia');
insert into airport values('AYD','Alroy Downs, Nt, Australia');
insert into airport values('AYG','Yaguara, Colombia');
insert into airport values('AYI','Yari, Colombia');
insert into airport values('AYK','Arkalyk, Ussr');
insert into airport values('AYL','Anthony Lagoon, Nt, Australia');
insert into airport values('AYN','Anyang, P. R. China');
insert into airport values('AYP','Ayacucho, Peru');
commit;
insert into airport values('AYQ','Ayers Rock, Nt, Australia');
insert into airport values('AYR','Ayr, Qld, Australia');
insert into airport values('AYS','Waycross, Georgia, Usa');
insert into airport values('AYT','Antalya, Turkey');
insert into airport values('AYU','Aiyura, Papua New Guinea');
insert into airport values('AYW','Ayawasi, Indonesia');
insert into airport values('AYZ','Amityville, New York, Usa');
insert into airport values('AZB','Amazon Bay, Papua New Guinea');
insert into airport values('AZD','Yazd, Iran, Islamic Rep. Of');
insert into airport values('AZG','Apatzingan, Mexico');
insert into airport values('AZN','Andizhan, Ussr');
insert into airport values('AZO','Kalamazoo, Michigan, Usa');
insert into airport values('AZR','Adrar, Algeria');
insert into airport values('AZT','Zapatoca, Colombia');
insert into airport values('AZZ','Ambriz, Angola');
insert into airport values('BAC','Barranca De Upia, Colombia');
insert into airport values('BAE','Barcelonnette, France');
insert into airport values('BAG','Baguio, Philippines');
insert into airport values('BAH','Bahrain, Bahrain');
insert into airport values('BAI','Buenos Aires, Costa Rica');
insert into airport values('BAJ','Bali, Papua New Guinea');
insert into airport values('BAK','Baku, Ussr');
insert into airport values('BAL','Batman, Turkey');
insert into airport values('BAM','Battle Mountain, Nevada, Usa');
insert into airport values('BAN','Basongo, Zaire');
insert into airport values('BAO','Ban Mak Khaeng, Thailand');
insert into airport values('BAP','Baibara, Papua New Guinea');
insert into airport values('BAQ','Barranquilla, Colombia');
insert into airport values('BAS','Balalae, Solomon Islands');
insert into airport values('BAT','Barretos, Sp, Brazil');
commit;
insert into airport values('BAU','Bauru, Sp, Brazil');
insert into airport values('BAV','Baotou, P. R. China');
insert into airport values('BAW','Biawonque, Gabon');
insert into airport values('BAX','Barnaul, Ussr');
insert into airport values('BAY','Baia Mare, Romania');
insert into airport values('BAZ','Barcelos, Am, Brazil');
insert into airport values('BBA','Balmaceda, Chile');
insert into airport values('BBB','Benson, Minnesota, Usa');
insert into airport values('BBC','Bay City, Texas, Usa');
insert into airport values('BBD','Brady, Texas, Usa');
insert into airport values('BBE','Big Bell, Wa, Australia');
insert into airport values('BBF','Burlington, Massachusetts, Usa');
insert into airport values('BBG','Butaritari, Rep. Of Kiribati');
insert into airport values('BBH','Barth, Fed. Rep. Of Germany');
insert into airport values('BBI','Bhubaneswar, India');
insert into airport values('BBK','Kasane, Botswana');
insert into airport values('BBL','Babol Sar, Iran, Islamic Rep.');
insert into airport values('BBM','Battambang, Cambodia');
insert into airport values('BBN','Bario, Sarawak, Malaysia');
insert into airport values('BBO','Berbera, Somalia');
insert into airport values('BBP','Bembridge, England Uk');
insert into airport values('BBQ','Barbuda, West Indies');
insert into airport values('BBR','Basse-Terre, Guadeloupe');
insert into airport values('BBS','Blackbush, England Uk');
insert into airport values('BBT','Berberati, Cen. African Republ');
insert into airport values('BBU','Bucharest, Romania-Baneasa');
insert into airport values('BBV','Bereby, Cote D''Ivoire');
insert into airport values('BBW','Broken Bow, Nebraska, Usa');
insert into airport values('BBX','Blue Bell, Pennsylvania, Usa');
insert into airport values('BBY','Bambari, Cen. African Republic');
commit;
insert into airport values('BBZ','Zambezi, Zambia');
insert into airport values('BCA','Baracoa, Cuba');
insert into airport values('BCB','Blacksburg, Virginia, Usa');
insert into airport values('BCC','Bear Creek, Alaska, Usa');
insert into airport values('BCD','Bacolod, Philippines');
insert into airport values('BCE','Bryce Canyon, Utah, Usa');
insert into airport values('BCF','Bouca, Cen. African Republic');
insert into airport values('BCG','Bemichi, Guyana');
insert into airport values('BCH','Baucau, Indonesia');
insert into airport values('BCI','Barcaldine, Qld, Australia');
insert into airport values('BCJ','Baca Grande, Colorado, Usa');
insert into airport values('BCK','Bolwarra, Qld, Australia');
insert into airport values('BCL','Barra Colorado, Costa Rica');
insert into airport values('BCM','Bacau, Romania');
insert into airport values('BCN','Barcelona, Spain');
insert into airport values('BCO','Jinka, Ethiopia');
insert into airport values('BCR','Boca Do Acre, Am, Brazil');
insert into airport values('BCS','Belle Chasse, Louisiana, Usa');
insert into airport values('BCT','Boca Raton, Florida, Usa');
insert into airport values('BCU','Bauchi, Nigeria');
insert into airport values('BCX','Beloreck, Ussr');
insert into airport values('BCY','Bulchi, Ethiopia');
insert into airport values('BCZ','Bickerton Island, Nt, Australi');
insert into airport values('BDA','Bermuda, Atlantic Ocean');
insert into airport values('BDB','Bundaberg, Qld, Australia');
insert into airport values('BDC','Barra Do Corda, Ma, Brazil');
insert into airport values('BDD','Badu Island, Qld, Australia');
insert into airport values('BDF','Bradford, Illinois, Usa');
insert into airport values('BDG','Blanding, Utah, Usa');
insert into airport values('BDH','Bandar Lengeh, Iran, Islamic R');
commit;
insert into airport values('BDI','Bird Is., Seychelles Is. India');
insert into airport values('BDJ','Banjarmasin, Indonesia');
insert into airport values('BDK','Bondoukou, Cote D''Ivoire');
insert into airport values('BDL','Hartford, Connecticut-Bradley');
insert into airport values('BDM','Bandirma, Turkey');
insert into airport values('BDN','Badin, Pakistan');
insert into airport values('BDO','Bandung, Indonesia');
insert into airport values('BDP','Bhadrapur, Nepal');
insert into airport values('BDQ','Vadodara, India');
insert into airport values('BDR','Bridgeport, Connecticut, Usa');
insert into airport values('BDS','Brindisi, Italy');
insert into airport values('BDT','Gbadolite, Zaire');
insert into airport values('BDU','Bardufoss, Norway');
insert into airport values('BDV','Moba, Zaire');
insert into airport values('BDW','Bedford Downs, Wa, Australia');
insert into airport values('BDX','Broadus, Montana, Usa');
insert into airport values('BDY','Bandon, Oregon, Usa');
insert into airport values('BDZ','Baindoung, Papua New Guinea');
insert into airport values('BEA','Bereina, Papua New Guinea');
insert into airport values('BEB','Benbecula, Hebrides Is., Scotl');
insert into airport values('BED','Bedford, Massachusetts, Usa');
insert into airport values('BEE','Beagle Bay, Wa, Australia');
insert into airport values('BEF','Bluefields, Nicaragua');
insert into airport values('BEG','Belgrade, Yugoslavia');
insert into airport values('BEH','Benton Harbor, Michigan, Usa');
insert into airport values('BEI','Beica, Ethiopia');
insert into airport values('BEJ','Berau, Indonesia');
insert into airport values('BEK','Rae Bareli, India');
insert into airport values('BEL','Belem, Pa, Brazil');
insert into airport values('BEM','Bossembele, Cen. African Repub');
commit;
insert into airport values('BEN','Benghazi, Libyan A Jamahiriya');
insert into airport values('BEO','Newcastle, Nsw, Austra-Belmont');
insert into airport values('BEP','Bellary, India');
insert into airport values('BEQ','Bury St. Edmunds, England Uk');
insert into airport values('BER','Berlin, Fed. Rep. Of G-Tegel');
insert into airport values('BES','Brest, France');
insert into airport values('BET','Bethel, Alaska, Usa-Bet');
insert into airport values('BEU','Bedourie, Qld, Australia');
insert into airport values('BEV','Beersheba, Israel');
insert into airport values('BEW','Beira, Mozambique');
insert into airport values('BEY','Beirut, Lebanon');
insert into airport values('BEZ','Beru, Rep. Of Kiribati');
insert into airport values('BFB','Blue Fox Bay, Alaska, Usa');
insert into airport values('BFC','Bloomfield, Qld, Australia');
insert into airport values('BFD','Bradford, Pennsylvania, Usa');
insert into airport values('BFF','Scottsbluff, Nebraska, Usa');
insert into airport values('BFG','Bullfrog Basin, Utah, Usa');
insert into airport values('BFI','Seattle/Tacoma, Washin-Boeing');
insert into airport values('BFJ','Ba, Fiji');
insert into airport values('BFL','Bakersfield, California, Usa');
insert into airport values('BFN','Bloemfontein, South Africa');
insert into airport values('BFO','Buffalo Range, Zimbabwe');
insert into airport values('BFP','Beaver Falls, Pennsylvania, Us');
insert into airport values('BFR','Bedford, Indiana, Usa');
insert into airport values('BFS','Belfast, N. Ireland Uk-Intl');
insert into airport values('BFT','Beaufort, South Carolina, Usa');
insert into airport values('BFX','Bafoussam, Republic Of Cameroo');
insert into airport values('BGA','Bucaramanga, Colombia');
insert into airport values('BGB','Booue, Gabon');
insert into airport values('BGC','Braganca, Portugal');
commit;
insert into airport values('BGD','Borger, Texas, Usa');
insert into airport values('BGE','Bainbridge, Georgia, Usa');
insert into airport values('BGF','Bangui, Cen. African Republic');
insert into airport values('BGG','Bongouanou, Cote D''Ivoire');
insert into airport values('BGH','Boghe, Mauritania');
insert into airport values('BGI','Barbados, Barbados');
insert into airport values('BGJ','Borgarfjordur Eystri, Iceland');
insert into airport values('BGK','Big Creek, Belize');
insert into airport values('BGL','Baglung, Nepal');
insert into airport values('BGM','Binghamton, New York, Usa');
insert into airport values('BGN','Bruggen, Fed. Rep. Of Germany');
insert into airport values('BGO','Bergen, Norway');
insert into airport values('BGP','Bongo, Gabon');
insert into airport values('BGQ','Big Lake, Alaska, Usa');
insert into airport values('BGR','Bangor, Maine, Usa');
insert into airport values('BGT','Bagdad, Arizona, Usa');
insert into airport values('BGU','Bangassou, Cen. African Republ');
insert into airport values('BGV','Bento Goncalves, Rs, Brazil');
insert into airport values('BGW','Baghdad, Iraq-Al Muthana');
insert into airport values('BGX','Bage, Rs, Brazil');
insert into airport values('BGY','Milan, Italy-Orio Serio');
insert into airport values('BGZ','Braga, Portugal');
insert into airport values('BHA','Bahia De Caraquez, Ecuador');
insert into airport values('BHB','Bar Harbor, Maine, Usa');
insert into airport values('BHC','Bullhead City Az/Laughlin, Nv,');
insert into airport values('BHD','Belfast, N. Ireland Uk-City');
insert into airport values('BHE','Blenheim, New Zealand');
insert into airport values('BHF','Bahia Cupica, Colombia');
insert into airport values('BHG','Brus Laguna, Honduras');
insert into airport values('BHH','Bisha, Saudi Arabia');
commit;
insert into airport values('BHI','Bahia Blanca, Ba, Argentina');
insert into airport values('BHJ','Bhuj, India');
insert into airport values('BHK','Bukhara, Ussr');
insert into airport values('BHL','Bahia De Los Angeles, Mexico');
insert into airport values('BHM','Birmingham, Alabama, Usa');
insert into airport values('BHN','Beihan, Yemen, Republic Of');
insert into airport values('BHO','Bhopal, India');
insert into airport values('BHP','Bhojpur, Nepal');
insert into airport values('BHQ','Broken Hill, Nsw, Australia');
insert into airport values('BHR','Bharatpur, Nepal');
insert into airport values('BHS','Bathurst, Nsw, Australia');
insert into airport values('BHT','Brighton Downs, Qld, Australia');
insert into airport values('BHU','Bhavnagar, India');
insert into airport values('BHV','Bahawalpur, Pakistan');
insert into airport values('BHX','Birmingham, England Uk');
insert into airport values('BHY','Beihai, P. R. China');
insert into airport values('BHZ','Belo Horizonte, Mg, Br-Confins');
insert into airport values('BIA','Bastia, Corsica, France');
insert into airport values('BIB','Baidoa, Somalia');
insert into airport values('BIC','Big Creek, Alaska, Usa');
insert into airport values('BID','Block Island, Rhode Island, Us');
insert into airport values('BIE','Beatrice, Nebraska, Usa');
insert into airport values('BIG','Big Delta, Alaska, Usa');
insert into airport values('BIH','Bishop, California, Usa');
insert into airport values('BII','Bikini Atoll, Marshall Islands');
insert into airport values('BIJ','Biliau, Papua New Guinea');
insert into airport values('BIK','Biak, Indonesia');
insert into airport values('BIL','Billings, Montana, Usa');
insert into airport values('BIM','Bimini, Bahamas-Intl');
insert into airport values('BIN','Bamiyan, Dem. Rep. Of Afghanis');
commit;
insert into airport values('BIO','Bilbao, Spain');
insert into airport values('BIP','Bulimba, Qld, Australia');
insert into airport values('BIQ','Biarritz, France');
insert into airport values('BIR','Biratnagar, Nepal');
insert into airport values('BIS','Bismarck, North Dakota, Usa');
insert into airport values('BIT','Baitadi, Nepal');
insert into airport values('BIU','Bildudalur, Iceland');
insert into airport values('BIV','Bria, Cen. African Republic');
insert into airport values('BIW','Billiluna, Wa, Australia');
insert into airport values('BIY','Bisho, South Africa');
insert into airport values('BIZ','Bimin, Papua New Guinea');
insert into airport values('BJA','Bejaia, Algeria');
insert into airport values('BJC','Broomfield, Colorado, Usa');
insert into airport values('BJD','Bakkafjordur, Iceland');
insert into airport values('BJF','Batsfjord, Norway');
insert into airport values('BJH','Bajhang, Nepal');
insert into airport values('BJI','Bemidji, Minnesota, Usa');
insert into airport values('BJJ','Wooster, Ohio, Usa');
insert into airport values('BJK','Benjina, Indonesia');
insert into airport values('BJL','Banjul, Gambia');
insert into airport values('BJM','Bujumbura, Burundi');
insert into airport values('BJN','Bajone, Mozambique');
insert into airport values('BJO','Bermejo, Bolivia');
insert into airport values('BJR','Bahar Dar, Ethiopia');
insert into airport values('BJS','Beijing, P. R. China');
insert into airport values('BJU','Bajura, Nepal');
insert into airport values('BJW','Bajawa, Indonesia');
insert into airport values('BJX','Leon-Guanajuato, Mexico');
insert into airport values('BJZ','Badajoz, Spain');
insert into airport values('BKA','Moscow, Ussr-Bykovo');
commit;
insert into airport values('BKB','Bikaner, India');
insert into airport values('BKC','Buckland, Alaska, Usa');
insert into airport values('BKD','Breckenridge, Texas, Usa');
insert into airport values('BKE','Baker, Oregon, Usa');
insert into airport values('BKF','Brooks Lake, Alaska, Usa');
insert into airport values('BKH','Kekaha, Kauai; Hawaii, Usa');
insert into airport values('BKI','Kota Kinabalu, Sabah, Malaysia');
insert into airport values('BKJ','Boke, Guinea');
insert into airport values('BKK','Bangkok, Thailand');
insert into airport values('BKL','Cleveland, Ohio, Usa-Burke');
insert into airport values('BKM','Bakalalan, Sarawak, Malaysia');
insert into airport values('BKN','Birni Nkoni, Nigeria');
insert into airport values('BKO','Bamako, Mali');
insert into airport values('BKP','Barkly Downs, Qld, Australia');
insert into airport values('BKQ','Blackall, Qld, Australia');
insert into airport values('BKR','Bokoro, Chad');
insert into airport values('BKS','Bengkulu, Indonesia');
insert into airport values('BKT','Blackstone, Virginia, Usa');
insert into airport values('BKU','Betioky, Dem. Rep. Madagascar');
insert into airport values('BKW','Beckley, West Virginia, Usa');
insert into airport values('BKX','Brookings, South Dakota, Usa');
insert into airport values('BKY','Bukavu, Zaire');
insert into airport values('BKZ','Bukoba, Tanzania');
insert into airport values('BLA','Barcelona, Venezuela');
insert into airport values('BLB','Balboa, Panama Republic');
insert into airport values('BLC','Bali, Republic Of Cameroon');
insert into airport values('BLE','Borlange, Sweden');
insert into airport values('BLF','Bluefield, West Virginia, Usa');
insert into airport values('BLG','Belaga, Sarawak, Malaysia');
insert into airport values('BLH','Blythe, California, Usa');
commit;
insert into airport values('BLI','Bellingham, Washington, Usa');
insert into airport values('BLJ','Batna, Algeria');
insert into airport values('BLK','Blackpool, England Uk');
insert into airport values('BLL','Billund, Denmark');
insert into airport values('BLM','Belmar, New Jersey, Usa');
insert into airport values('BLN','Benalla, Victoria, Australia');
insert into airport values('BLO','Blonduos, Iceland');
insert into airport values('BLP','Bellavista, Peru');
insert into airport values('BLQ','Bologna, Italy');
insert into airport values('BLR','Bangalore, India');
insert into airport values('BLS','Bollon, Qld, Australia');
insert into airport values('BLT','Blackwater, Qld, Australia');
insert into airport values('BLW','Waimanalo, Oahu; Hawaii, Usa');
insert into airport values('BLX','Belluno, Italy');
insert into airport values('BLY','Belmullet, Republic Of Ireland');
insert into airport values('BLZ','Blantyre, Malawi');
insert into airport values('BMA','Stockholm, Sweden-Bromma');
insert into airport values('BMB','Bumba, Zaire');
insert into airport values('BMC','Brigham City, Utah, Usa');
insert into airport values('BMD','Belo, Dem. Rep. Madagascar');
insert into airport values('BME','Broome, Wa, Australia');
insert into airport values('BMF','Bakouma, Cen. African Republic');
insert into airport values('BMG','Bloomington, Indiana, Usa');
insert into airport values('BMH','Bomai, Papua New Guinea');
insert into airport values('BMI','Bloomington, Illinois, Usa');
insert into airport values('BMJ','Baramita, Guyana');
insert into airport values('BMK','Borkum, Fed. Rep. Of Germany');
insert into airport values('BML','Berlin, New Hampshire, Usa');
insert into airport values('BMM','Bitam, Gabon');
insert into airport values('BMN','Bamerny, Iraq');
commit;
insert into airport values('BMO','Bhamo, Myanmar');
insert into airport values('BMP','Brampton Island, Qld, Australi');
insert into airport values('BMQ','Bamburi, Kenya');
insert into airport values('BMR','Baltrum, Fed. Rep. Of Germany');
insert into airport values('BMS','Brumado, Ba, Brazil');
insert into airport values('BMU','Bima, Indonesia');
insert into airport values('BMV','Ban Me Thuot, Soc. Rep. Of Vie');
insert into airport values('BMW','Bordj Badji Mokhtar, Algeria');
insert into airport values('BMX','Big Mountain, Alaska, Usa');
insert into airport values('BMY','Belep, New Caledonia');
insert into airport values('BMZ','Bamu, Papua New Guinea');
insert into airport values('BNA','Nashville, Tennessee, Usa');
insert into airport values('BNB','Boende, Zaire');
insert into airport values('BNC','Beni, Zaire');
insert into airport values('BND','Bandar Abbas, Iran, Islamic Re');
insert into airport values('BNE','Brisbane, Qld, Australia');
insert into airport values('BNF','Baranof, Alaska, Usa');
insert into airport values('BNG','Banning, California, Usa');
insert into airport values('BNI','Benin City, Nigeria');
insert into airport values('BNJ','Bonn, Fed. Rep. Of Germany');
insert into airport values('BNK','Ballina, Nsw, Australia');
insert into airport values('BNL','Barnwell, South Carolina, Usa');
insert into airport values('BNM','Bodinumu, Papua New Guinea');
insert into airport values('BNN','Bronnoysund, Norway');
insert into airport values('BNO','Burns, Oregon, Usa');
insert into airport values('BNP','Bannu, Pakistan');
insert into airport values('BNQ','Baganga, Philippines');
insert into airport values('BNR','Banfora, Burkina Faso');
insert into airport values('BNS','Barinas, Venezuela');
insert into airport values('BNT','Bundi, Papua New Guinea');
commit;
insert into airport values('BNU','Blumenau, Sc, Brazil');
insert into airport values('BNV','Boana, Papua New Guinea');
insert into airport values('BNW','Boone, Iowa, Usa');
insert into airport values('BNX','Banja Luka, Yugoslavia');
insert into airport values('BNY','Bellona Island, Solomon Island');
insert into airport values('BNZ','Banz, Papua New Guinea');
insert into airport values('BOA','Boma, Zaire');
insert into airport values('BOB','Bora Bora, French Polynesia');
insert into airport values('BOC','Bocas Del Toro, Panama Republi');
insert into airport values('BOD','Bordeaux, France');
insert into airport values('BOE','Boundji, Peop. Rep. Of The Con');
insert into airport values('BOG','Bogota, Colombia');
insert into airport values('BOH','Bournemouth, England Uk');
insert into airport values('BOI','Boise, Idaho, Usa');
insert into airport values('BOJ','Bourgas, Bulgaria');
insert into airport values('BOK','Brookings, Oregon, Usa');
insert into airport values('BOM','Bombay, India');
insert into airport values('BON','Bonaire, Neth. Antilles');
insert into airport values('BOO','Bodo, Norway');
insert into airport values('BOP','Bouar, Cen. African Republic');
insert into airport values('BOQ','Boku, Papua New Guinea');
insert into airport values('BOR','Belfort, France');
insert into airport values('BOS','Boston, Massachusetts-Logan');
insert into airport values('BOU','Bourges, France');
insert into airport values('BOV','Boang, Papua New Guinea');
insert into airport values('BOW','Bartow, Florida, Usa');
insert into airport values('BOX','Borroloola, Nt, Australia');
insert into airport values('BOY','Bobo Dioulasso, Burkina Faso');
insert into airport values('BOZ','Bozoum, Cen. African Republic');
insert into airport values('BPA','Bethpage, New York, Usa');
commit;
insert into airport values('BPB','Boridi, Papua New Guinea');
insert into airport values('BPC','Bamenda, Republic Of Cameroon');
insert into airport values('BPD','Bapi, Papua New Guinea');
insert into airport values('BPG','Barra Do Garcas, Mt, Brazil');
insert into airport values('BPH','Bislig, Philippines');
insert into airport values('BPI','Big Piney, Wyoming, Usa');
insert into airport values('BPN','Balikpapan, Indonesia');
insert into airport values('BPS','Porto Seguro, Ba, Brazil');
insert into airport values('BPT','Beaumont/Pt. Arthur, Texas, Us');
insert into airport values('BPU','Beppu, Japan');
insert into airport values('BPY','Besalampy, Dem. Rep. Madagasca');
insert into airport values('BQA','Baler, Philippines');
insert into airport values('BQE','Bubaque, Guinea Bissau');
insert into airport values('BQK','Brunswick, Georgia, Us-Glynco');
insert into airport values('BQL','Boulia, Qld, Australia');
insert into airport values('BQN','Aguadilla, Puerto Rico');
insert into airport values('BQO','Bouna, Cote D''Ivoire');
insert into airport values('BQQ','Barra, Ba, Brazil');
insert into airport values('BQS','Blagoveschensk, Ussr');
insert into airport values('BQT','Brest, Ussr');
insert into airport values('BQV','Bartlett Cove, Alaska, Usa');
insert into airport values('BQW','Balgo Hills, Wa, Australia');
insert into airport values('BRA','Barreiras, Ba, Brazil');
insert into airport values('BRB','Barreirinhas, Ma, Brazil');
insert into airport values('BRC','San Carlos Debariloche, Rn, Ar');
insert into airport values('BRD','Brainerd, Minnesota, Usa');
insert into airport values('BRE','Bremen, Fed. Rep. Of Germany');
insert into airport values('BRG','Whitesburg, Kentucky, Usa');
insert into airport values('BRH','Brahman, Papua New Guinea');
insert into airport values('BRI','Bari, Italy');
commit;
insert into airport values('BRJ','Bright, Vic, Australia');
insert into airport values('BRK','Bourke, Nsw, Australia');
insert into airport values('BRL','Burlington, Iowa, Usa');
insert into airport values('BRM','Barquisimeto, Venezuela');
insert into airport values('BRN','Berne, Switzerland-Belp');
insert into airport values('BRO','Brownsville, Texas, Usa');
insert into airport values('BRP','Biaru, Papua New Guinea');
insert into airport values('BRQ','Brno, Czechoslovakia');
insert into airport values('BRR','Barra, Hebrides Is., Scotland');
insert into airport values('BRS','Bristol, England Uk');
insert into airport values('BRT','Bathurst Island, Nt, Australia');
insert into airport values('BRU','Brussels, Belgium');
insert into airport values('BRV','Bremerhaven, Fed. Rep. Of Germ');
insert into airport values('BRW','Barrow, Alaska, Usa');
insert into airport values('BRX','Barahona, Dominican Rep.');
insert into airport values('BRY','Bardstown, Kentucky, Usa');
insert into airport values('BRZ','Borotou, Cote D''Ivoire');
insert into airport values('BSA','Bossaso, Somalia');
insert into airport values('BSB','Brasilia, Df, Brazil');
insert into airport values('BSC','Bahia Solano, Colombia');
insert into airport values('BSD','Baoshan, P. R. China');
insert into airport values('BSE','Sematan, Malaysia');
insert into airport values('BSG','Bata, Equatorial Guinea');
insert into airport values('BSH','Brighton, England Uk');
insert into airport values('BSI','Blairsville, Pennsylvania, Usa');
insert into airport values('BSJ','Bairnsdale, Vic, Australia');
insert into airport values('BSK','Biskra, Algeria');
insert into airport values('BSL','Basel/Mulhouse, Switzerland');
insert into airport values('BSN','Bossangoa, Cen. African Republ');
insert into airport values('BSO','Basco, Philippines');
commit;
insert into airport values('BSP','Bensbach, Papua New Guinea');
insert into airport values('BSQ','Bisbee, Arizona, Usa');
insert into airport values('BSR','Basra, Iraq');
insert into airport values('BSS','Balsas, Ma, Brazil');
insert into airport values('BST','Bost, Dem Rep Of Afghanistan');
insert into airport values('BSU','Basankusu, Zaire');
insert into airport values('BSV','Bosset, Papua New Guinea');
insert into airport values('BSW','Boswell Bay, Alaska, Usa');
insert into airport values('BSX','Bassein, Myanmar');
insert into airport values('BSY','Bardera, Somalia');
insert into airport values('BSZ','Bartletts, Alaska, Usa');
insert into airport values('BTA','Bertoua, Republic Of Cameroon');
insert into airport values('BTB','Betou, Peop. Rep. Of The Congo');
insert into airport values('BTC','Batticaloa, Sri Lanka');
insert into airport values('BTD','Brunette Downs, Nt, Australia');
insert into airport values('BTE','Bonthe, Sierra Leone');
insert into airport values('BTF','Bountiful, Utah, Usa');
insert into airport values('BTG','Batangafo, Cen. African Republ');
insert into airport values('BTH','Batam/Batu Besar, Indonesia');
insert into airport values('BTI','Barter Island, Alaska, Usa');
insert into airport values('BTJ','Banda Aceh, Indonesia');
insert into airport values('BTK','Bratsk, Ussr');
insert into airport values('BTL','Battle Creek, Michigan, Usa');
insert into airport values('BTM','Butte, Montana, Usa');
insert into airport values('BTN','Bennettsville, South Carolina,');
insert into airport values('BTO','Botopasie, Republic Of Surinam');
insert into airport values('BTP','Butler, Pennsylvania, Usa');
insert into airport values('BTQ','Butare, Rwanda');
insert into airport values('BTR','Baton Rouge, Louisiana, Usa');
insert into airport values('BTS','Bratislava, Czechoslovakia');
commit;
insert into airport values('BTT','Bettles, Alaska, Usa');
insert into airport values('BTU','Bintulu, Sarawak, Malaysia');
insert into airport values('BTV','Burlington, Vermont, Usa');
insert into airport values('BTW','Batu Licin, Indonesia');
insert into airport values('BTX','Betoota, Qld, Australia');
insert into airport values('BTZ','Bursa, Turkey');
insert into airport values('BUA','Buka Is., Papua New Guinea');
insert into airport values('BUB','Burwell, Nebraska, Usa');
insert into airport values('BUC','Burketown, Qld, Australia');
insert into airport values('BUD','Budapest, Hungary');
insert into airport values('BUE','Buenos Aires, Ba, Arge-Pistari');
insert into airport values('BUF','Buffalo, New York, Usa');
insert into airport values('BUG','Benguela, Angola');
insert into airport values('BUH','Bucharest, Romania-Otopeni');
insert into airport values('BUI','Bokondini, Indonesia');
insert into airport values('BUJ','Boussaada, Algeria');
insert into airport values('BUK','Albuq, Yemen, Republic Of');
insert into airport values('BUL','Bulolo, Papua New Guinea');
insert into airport values('BUM','Butler, Missouri, Usa');
insert into airport values('BUN','Buenaventura, Colombia');
insert into airport values('BUO','Burao, Somalia');
insert into airport values('BUP','Bhatinda, India');
insert into airport values('BUQ','Bulawayo, Zimbabwe');
insert into airport values('BUR','Burbank, California, Usa');
insert into airport values('BUS','Batumi, Ussr');
insert into airport values('BUT','Burtonwood, England Uk');
insert into airport values('BUV','Bella Union, Uruguay');
insert into airport values('BUW','Buton/Babau, Indonesia');
insert into airport values('BUX','Bunia, Zaire');
insert into airport values('BUY','Bunbury, Wa, Australia');
commit;
insert into airport values('BUZ','Bushehr, Iran, Islamic Rep. Of');
insert into airport values('BVA','Beauvais, France');
insert into airport values('BVB','Boa Vista, Rr, Brazil');
insert into airport values('BVC','Boa Vista, Cape Verde Islands');
insert into airport values('BVD','Beaver Inlet, Alaska, Usa');
insert into airport values('BVE','Brive-La-Gaillarde, France');
insert into airport values('BVF','Bua, Fiji');
insert into airport values('BVG','Berlevag, Norway');
insert into airport values('BVH','Vilhena, Ro, Brazil');
insert into airport values('BVI','Birdsville, Qld, Australia');
insert into airport values('BVM','Belmonte, Ba, Brazil');
insert into airport values('BVO','Bartlesville, Oklahoma, Usa');
insert into airport values('BVP','Bolovip, Papua New Guinea');
insert into airport values('BVS','Breves, Pa, Brazil');
insert into airport values('BVW','Batavia Downs, Qld, Australia');
insert into airport values('BVX','Batesville, Arkansas, Usa');
insert into airport values('BVY','Beverly, Massachusetts, Usa');
insert into airport values('BVZ','Beverley Springs, Wa, Australi');
insert into airport values('BWA','Bhairawa, Nepal');
insert into airport values('BWB','Barrow Island, Wa, Australia');
insert into airport values('BWC','Brawley, California, Usa');
insert into airport values('BWD','Brownwood, Texas, Usa');
insert into airport values('BWE','Braunschweig, Fed. Rep. Of Ger');
insert into airport values('BWF','Barrow-In-Furness, England Uk');
insert into airport values('BWG','Bowling Green, Kentucky, Usa');
insert into airport values('BWH','Butterworth, Malaysia');
insert into airport values('BWI','Baltimore, Maryland, U-Intl');
insert into airport values('BWJ','Bawan, Papua New Guinea');
insert into airport values('BWL','Blackwell, Oklahoma, Usa');
insert into airport values('BWM','Bowman, North Dakota, Usa');
commit;
insert into airport values('BWN','B. Seri Begawan, Brunei Daruss');
insert into airport values('BWO','Balakovo, Ussr');
insert into airport values('BWP','Bewani, Papua New Guinea');
insert into airport values('BWQ','Brewarrina, Nsw, Australia');
insert into airport values('BWS','Blaine, Washington, Usa');
insert into airport values('BWT','Burnie, Tasmania, Australia');
insert into airport values('BWU','Bankstown, Nsw, Australia');
insert into airport values('BWY','Woodbridge, England Uk');
insert into airport values('BXA','Bogalusa, Louisiana, Usa');
insert into airport values('BXB','Babo, Indonesia');
insert into airport values('BXC','Boxborough, Massachusetts, Usa');
insert into airport values('BXD','Bade, Indonesia');
insert into airport values('BXE','Bakel, Senegal');
insert into airport values('BXH','Balhash, Ussr');
insert into airport values('BXI','Boundiali, Cote D''Ivoire');
insert into airport values('BXK','Buckeye, Arizona, Usa');
insert into airport values('BXL','Blue Lagoon, Fiji');
insert into airport values('BXM','Batom, Indonesia');
insert into airport values('BXN','Bodrum, Turkey');
insert into airport values('BXO','Bissau, Guinea Bissau');
insert into airport values('BXS','Borrego Springs, California, U');
insert into airport values('BXT','Bontang, Indonesia');
insert into airport values('BXU','Butuan, Philippines');
insert into airport values('BXV','Breiddalsvik, Iceland');
insert into airport values('BXX','Borama, Somalia');
insert into airport values('BYA','Boundary, Alaska, Usa');
insert into airport values('BYB','Dibaa, Oman');
insert into airport values('BYC','Yacuiba, Bolivia');
insert into airport values('BYD','Beidah, Yemen, Republic Of');
insert into airport values('BYG','Buffalo, Wyoming, Usa');
commit;
insert into airport values('BYI','Burley, Idaho, Usa');
insert into airport values('BYK','Bouake, Cote D''Ivoire');
insert into airport values('BYL','Belle Yella, Liberia');
insert into airport values('BYM','Bayamo, Cuba');
insert into airport values('BYN','Bayankhongor, Mongolia');
insert into airport values('BYQ','Bunyu, Indonesia');
insert into airport values('BYT','Bantry, Republic Of Ireland');
insert into airport values('BYU','Bayreuth, Fed. Rep. Of Germany');
insert into airport values('BYW','Blakely Island, Washington, Us');
insert into airport values('BYX','Baniyala, Nt, Australia');
insert into airport values('BZA','Bonanza, Nicaragua');

insert into airport values('BZC','Buzios, Rj, Brazil');
insert into airport values('BZD','Balranald, Nsw, Australia');
insert into airport values('BZE','Belize City, Belize-Gldsn Intl');
insert into airport values('BZG','Bydgoszcz, Poland');
insert into airport values('BZI','Balikesir, Turkey');
insert into airport values('BZK','Briansk, Ussr');
insert into airport values('BZL','Barisal, Bangladesh');
insert into airport values('BZM','Bergen Op Zoom, Netherlands');
insert into airport values('BZN','Bozeman, Montana, Usa');
insert into airport values('BZO','Bolzano, Italy');
insert into airport values('BZP','Bizant, Qld, Australia');
insert into airport values('BZR','Beziers, France');
insert into airport values('BZT','Brazoria, Texas, Usa');
insert into airport values('BZU','Buta, Zaire');
insert into airport values('BZV','Brazzaville, Peop. Rep. Of Con');
insert into airport values('BZY','Beltsy, Ussr');
insert into airport values('BZZ','Brize Norton, England Uk');
insert into airport values('CAA','Catacamas, Honduras');
commit;
insert into airport values('CAB','Cabinda, Angola');
insert into airport values('CAC','Cascavel, Pr, Brazil');
insert into airport values('CAD','Cadillac, Michigan, Usa');
insert into airport values('CAE','Columbia, South Carolina, Usa');
insert into airport values('CAF','Carauari, Am, Brazil');
insert into airport values('CAG','Cagliari, Italy');
insert into airport values('CAH','Ca Mau, Soc. Rep. Of Viet Nam');
insert into airport values('CAI','Cairo, Arab Rep. Of Egypt');
insert into airport values('CAJ','Canaima, Venezuela');
insert into airport values('CAK','Akron/Canton, Ohio, Usa');
insert into airport values('CAL','Campbeltown, Scotland Uk');
insert into airport values('CAM','Camiri, Bolivia');
insert into airport values('CAN','Guangzhou, P. R. China');
insert into airport values('CAO','Clayton, New Mexico, Usa');
insert into airport values('CAP','Cap Haitien, Haiti');
insert into airport values('CAQ','Caucasia, Colombia');
insert into airport values('CAR','Caribou, Maine, Usa');
insert into airport values('CAS','Casablanca, Morocco-Anfa');
insert into airport values('CAT','Cat Island, Bahamas');
insert into airport values('CAU','Caruaru, Pe, Brazil');
insert into airport values('CAV','Cazombo, Angola');
insert into airport values('CAW','Campos, Rj, Brazil');
insert into airport values('CAX','Carlisle, England Uk');
insert into airport values('CAY','Cayenne, Fr. Guiana');
insert into airport values('CAZ','Cobar, Nsw, Australia');
insert into airport values('CBA','Corner Bay, Alaska, Usa');
insert into airport values('CBB','Cochabamba, Bolivia');
insert into airport values('CBC','Cherrabun, Wa, Australia');
insert into airport values('CBD','Car Nicobar, India');
insert into airport values('CBE','Cumberland, Maryland, Usa');
commit;
insert into airport values('CBF','Council Bluffs, Iowa, Usa');
insert into airport values('CBG','Cambridge, England Uk');
insert into airport values('CBH','Bechar, Algeria');
insert into airport values('CBJ','Cabo Rojo, Dominican Rep.');
insert into airport values('CBK','Colby, Kansas, Usa');
insert into airport values('CBL','Ciudad Bolivar, Venezuela');
insert into airport values('CBN','Cirebon, Indonesia');
insert into airport values('CBO','Cotabato, Philippines');
insert into airport values('CBP','Coimbra, Portugal');
insert into airport values('CBQ','Calabar, Nigeria');
insert into airport values('CBR','Canberra, Act, Australia');
insert into airport values('CBS','Cabimas, Venezuela');
insert into airport values('CBT','Catumbela, Angola');
insert into airport values('CBV','Coban, Guatemala');
insert into airport values('CBX','Condobolin, Nsw, Australia');
insert into airport values('CBY','Canobie, Qld, Australia');
insert into airport values('CBZ','Cabin Creek, Alaska, Usa');
insert into airport values('CCB','Upland, California, Usa');
insert into airport values('CCF','Carcassonne, France');
insert into airport values('CCG','Crane, Texas, Usa');
insert into airport values('CCH','Chile Chico, Chile');
insert into airport values('CCI','Concordia, Sc, Brazil');
insert into airport values('CCJ','Calicut, India');
insert into airport values('CCK','Cocos-Keeling Is., Indian Ocea');
insert into airport values('CCL','Chinchilla, Qld, Australia');
insert into airport values('CCM','Crisciuma, Sc, Brazil');
insert into airport values('CCN','Chakcharan, Dem Rep Of Afghani');
insert into airport values('CCO','Carimagua, Colombia');
insert into airport values('CCP','Concepcion, Chile');
insert into airport values('CCQ','Cachoeira, Ba, Brazil');
commit;
insert into airport values('CCR','Concord, California, Usa');
insert into airport values('CCS','Caracas, Venezuela');
insert into airport values('CCT','Colonia Catriel, Rn, Argentina');
insert into airport values('CCU','Calcutta, India');
insert into airport values('CCV','Craig Cove, Vanuatu');
insert into airport values('CCW','Cowell, Sa, Australia');
insert into airport values('CCX','Caceres, Mt, Brazil');
insert into airport values('CCY','Charles City, Iowa, Usa');
insert into airport values('CCZ','Chub Cay, Bahamas');
insert into airport values('CDA','Cooinda, Nt, Australia');
insert into airport values('CDB','Cold Bay, Alaska, Usa');
insert into airport values('CDC','Cedar City, Utah, Usa');
insert into airport values('CDE','Caledonia, Panama Republic');
insert into airport values('CDF','Cortina D''Ampezzo, Italy');
insert into airport values('CDG','Paris, France-De Gaulle');
insert into airport values('CDH','Camden, Arkansas, Usa');
insert into airport values('CDJ','Conceicao Do Araguaia, Pa, Bra');
insert into airport values('CDK','Cedar Key, Florida, Usa');
insert into airport values('CDL','Candle, Alaska, Usa');
insert into airport values('CDN','Camden, South Carolina, Usa');
insert into airport values('CDO','Cradock, South Africa');
insert into airport values('CDP','Cuddapah, India');
insert into airport values('CDQ','Croydon, Qld, Australia');
insert into airport values('CDR','Chadron, Nebraska, Usa');
insert into airport values('CDS','Childress, Texas, Usa');
insert into airport values('CDU','Camden, Nsw, Australia');
insert into airport values('CDV','Cordova, Alaska, Usa');
insert into airport values('CDW','Caldwell, New Jersey, Usa');
insert into airport values('CDY','Cagayan De Sulu, Philippines');
insert into airport values('CEB','Cebu, Philippines');
commit;
insert into airport values('CEC','Crescent City, California, Usa');
insert into airport values('CED','Ceduna, Sa, Australia');
insert into airport values('CEE','Cherepovets, Ussr');
insert into airport values('CEG','Chester, England Uk');
insert into airport values('CEI','Chiang Rai, Thailand');
insert into airport values('CEJ','Chernigov, Ussr');
insert into airport values('CEK','Chelyabinsk, Ussr');
insert into airport values('CEL','Cape Eleuthera, Bahamas');
insert into airport values('CEM','Central, Alaska, Usa');
insert into airport values('CEN','Ciudad Obregon, Mexico');
insert into airport values('CEO','Waco Kungo, Angola');
insert into airport values('CEP','Concepcion, Bolivia');
insert into airport values('CEQ','Cannes, France-Mandelieu');
insert into airport values('CER','Cherbourg, France');
insert into airport values('CES','Cessnock, Nsw, Australia');
insert into airport values('CET','Cholet, France');
insert into airport values('CEU','Clemson, South Carolina, Usa');
insert into airport values('CEV','Connersville, Indiana, Usa');
insert into airport values('CEW','Crestview, Florida, Usa');
insert into airport values('CEX','Chena Hot Spgs., Alaska, Usa');
insert into airport values('CEY','Murray, Kentucky, Usa');
insert into airport values('CEZ','Cortez, Colorado, Usa');
insert into airport values('CFA','Coffee Point, Alaska, Usa');
insert into airport values('CFE','Clermont-Ferrand, France');
insert into airport values('CFF','Cafunfo, Angola');
insert into airport values('CFG','Cienfuegos, Cuba');
insert into airport values('CFH','Clifton Hills, Sa, Australia');
insert into airport values('CFI','Camfield, Nt, Australia');
insert into airport values('CFN','Donegal, Republic Of Ireland');
insert into airport values('CFO','Confreza, Mt, Brazil');
commit;
insert into airport values('CFP','Carpentaria Downs, Qld, Austra');
insert into airport values('CFR','Caen, France');
insert into airport values('CFS','Coffs Harbour, Nsw, Australia');
insert into airport values('CFT','Clifton, Arizona, Usa');
insert into airport values('CFU','Corfu, Greece');
insert into airport values('CGA','Craig, Alaska, Usa');
insert into airport values('CGB','Cuiaba, Mt, Brazil');
insert into airport values('CGC','Cape Gloucester, Papua New Gui');
insert into airport values('CGD','Changde, P. R. China');
insert into airport values('CGE','Cambridge, Maryland, Usa');
insert into airport values('CGF','Cleveland, Ohio, Usa-Cuyahoga');
insert into airport values('CGH','Sao Paulo, Sp, Brazil-Congonha');
insert into airport values('CGI','Cape Girardeau, Missouri, Usa');
insert into airport values('CGJ','Chingola, Zambia');
insert into airport values('CGK','Jakarta, Indonesia-Soekarno');
insert into airport values('CGM','Camiguin, Philippines');
insert into airport values('CGN','Cologne/Bonn, Fed. Rep-Koeln');
insert into airport values('CGO','Zhengzhou, P. R. China');
insert into airport values('CGP','Chittagong, Bangladesh');
insert into airport values('CGQ','Changchun, P. R. China');
insert into airport values('CGR','Campo Grande, Ms, Brazil');
insert into airport values('CGS','College Park, Maryland, Usa');
insert into airport values('CGT','Chinguitti, Mauritania');
insert into airport values('CGU','Ciudad Guayana, Venezuela');
insert into airport values('CGV','Caiguna, Wa, Australia');
insert into airport values('CGX','Chicago, Illinois, Usa-Meigs');
insert into airport values('CGY','Cagayan De Oro, Philippines');
insert into airport values('CGZ','Casa Grande, Arizona, Usa');
insert into airport values('CHA','Chattanooga, Tennessee, Usa');
insert into airport values('CHB','Chilas, Pakistan');
commit;
insert into airport values('CHC','Christchurch, New Zealand');
insert into airport values('CHD','Chandler, Arizona, Usa-William');
insert into airport values('CHE','Caherciveen, Republic Of Irela');
insert into airport values('CHF','Chinhae, Republic Of Korea');
insert into airport values('CHG','Chaoyang, P. R. China');
insert into airport values('CHH','Chachapoyas, Peru');
insert into airport values('CHI','Chicago, Illinois, Usa-O''Hare');
insert into airport values('CHJ','Chipinge, Zimbabwe');
insert into airport values('CHK','Chickasha, Oklahoma, Usa');
insert into airport values('CHL','Challis, Idaho, Usa');
insert into airport values('CHM','Chimbote, Peru');
insert into airport values('CHN','Chonju, Republic Of Korea');
insert into airport values('CHO','Charlottesville, Virginia, Usa');
insert into airport values('CHP','Circle Hot Spgs., Alaska, Usa');
insert into airport values('CHQ','Chania, Crete, Greece');
insert into airport values('CHR','Chateauroux, France');
insert into airport values('CHS','Charleston, South Carolina, Us');
insert into airport values('CHT','Chatham Island, New Zealand');
insert into airport values('CHU','Chuathbaluk, Alaska, Usa');
insert into airport values('CHV','Chaves, Portugal');
insert into airport values('CHW','Jiuquan, P. R. China');
insert into airport values('CHX','Changuinola, Panama Republic');
insert into airport values('CHY','Choiseul Bay, Solomon Islands');
insert into airport values('CHZ','Chiloquin, Oregon, Usa');
insert into airport values('CIA','Rome, Italy-Ciampino');
insert into airport values('CIB','Catalina Is., Californ-Sky');
insert into airport values('CIC','Chico, California, Usa');
insert into airport values('CID','Cedar Rapids/Iowa City, Iowa,');
insert into airport values('CIE','Collie, Wa, Australia');
insert into airport values('CIF','Chifeng, P. R. China');
commit;
insert into airport values('CIG','Craig, Colorado, Usa');
insert into airport values('CIH','Changzhi, P. R. China');
insert into airport values('CIJ','Cobija, Bolivia');
insert into airport values('CIK','Chalkyitsik, Alaska, Usa');
insert into airport values('CIL','Council, Alaska, Usa');
insert into airport values('CIM','Cimitarra, Colombia');
insert into airport values('CIN','Carroll, Iowa, Usa');
insert into airport values('CIP','Chipata, Zambia');
insert into airport values('CIQ','Chiquimula, Guatemala');
insert into airport values('CIS','Canton Island, Rep. Of Kiribat');
insert into airport values('CIT','Chimkent, Ussr');
insert into airport values('CIU','Sault Ste. Marie, Mich-Chippew');
insert into airport values('CIV','Chomley, Alaska, Usa');
insert into airport values('CIW','Canouan Island, Windward Islan');
insert into airport values('CIX','Chiclayo, Peru');
insert into airport values('CIY','Comiso, Italy');
insert into airport values('CIZ','Coari, Am, Brazil');
insert into airport values('CJA','Cajamarca, Peru');
insert into airport values('CJB','Coimbatore, India');
insert into airport values('CJC','Calama, Chile');
insert into airport values('CJD','Candilejas, Colombia');
insert into airport values('CJL','Chitral, Pakistan');
insert into airport values('CJS','Ciudad Juarez, Mexico');
insert into airport values('CJU','Cheju, Republic Of Korea');
insert into airport values('CKB','Clarksburg, West Virginia, Usa');
insert into airport values('CKC','Cherkassy, Ussr');
insert into airport values('CKD','Crooked Creek, Alaska, Usa');
insert into airport values('CKE','Clear Lake, California, Usa');
insert into airport values('CKG','Chongqing, P. R. China');
insert into airport values('CKH','Chokurdah, Ussr');
commit;
insert into airport values('CKI','Croker Island, Nt, Australia');
insert into airport values('CKK','Cherokee, Arkansas, Usa');
insert into airport values('CKM','Clarksdale, Mississippi, Usa');
insert into airport values('CKN','Crookston, Minnesota, Usa');
insert into airport values('CKO','Cornelio Procopio, Pr, Brazil');
insert into airport values('CKR','Crane Island, Washington, Usa');
insert into airport values('CKS','Carajas, Pa, Brazil');
insert into airport values('CKV','Clarksville, Tennessee, Usa');
insert into airport values('CKX','Chicken, Alaska, Usa');
insert into airport values('CKY','Conakry, Guinea');
insert into airport values('CKZ','Canakkale, Turkey');
insert into airport values('CLA','Comilla, Bangladesh');
insert into airport values('CLC','Clear Lake City, Texas, Usa');
insert into airport values('CLD','Carlsbad, California, Usa');
insert into airport values('CLE','Cleveland, Ohio, Usa-Hopkins');
insert into airport values('CLG','Coalinga, California, Usa');
insert into airport values('CLH','Coolah, Nsw, Australia');
insert into airport values('CLJ','Cluj-Napoca, Romania');
insert into airport values('CLL','College Station, Texas, Usa');
insert into airport values('CLM','Port Angeles, Washington, Usa');
insert into airport values('CLN','Carolina, Ma, Brazil');
insert into airport values('CLO','Cali, Colombia');
insert into airport values('CLP','Clarks Point, Alaska, Usa');
insert into airport values('CLQ','Colima, Mexico');
insert into airport values('CLR','Calipatria, California, Usa');
insert into airport values('CLS','Chehalis, Washington, Usa');
insert into airport values('CLT','Charlotte, North Carolina, Usa');
insert into airport values('CLU','Columbus, Indiana, Usa');
insert into airport values('CLV','Caldas Novas, Go, Brazil');
insert into airport values('CLX','Clorinda, Fo, Argentina');
commit;
insert into airport values('CLY','Calvi, Corsica, France');
insert into airport values('CLZ','Calabozo, Venezuela');
insert into airport values('CMA','Cunnamulla, Qld, Australia');
insert into airport values('CMB','Colombo, Sri Lanka');
insert into airport values('CMC','Camocim, Ce, Brazil');
insert into airport values('CMD','Cootamundra, Nsw, Australia');
insert into airport values('CME','Ciudad Del Carmen, Mexico');
insert into airport values('CMF','Chambery, France');
insert into airport values('CMG','Corumba, Ms, Brazil');
insert into airport values('CMH','Columbus, Ohio, Usa-Intl');
insert into airport values('CMI','Champaign, Illinois, Usa');
insert into airport values('CMJ','Chi Mei, Taiwan');
insert into airport values('CMK','Club Makokola, Malawi');
insert into airport values('CML','Camooweal, Qld, Australia');
insert into airport values('CMM','Carmelita, Guatemala');
insert into airport values('CMN','Casablanca, Morocco-Mohamed V.');
insert into airport values('CMO','Obbia, Somalia');
insert into airport values('CMP','Santana Do Araguaia, Pa, Brazi');
insert into airport values('CMQ','Clermont, Qld, Australia');
insert into airport values('CMR','Colmar, France');
insert into airport values('CMS','Scusciuban, Somalia');
insert into airport values('CMT','Cameta, Pa, Brazil');
insert into airport values('CMU','Kundiawa, Papua New Guinea');
insert into airport values('CMV','Coromandel, New Zealand');
insert into airport values('CMW','Camaguey, Cuba');
insert into airport values('CMX','Hancock, Michigan, Usa');
insert into airport values('CMY','Sparta, Wisconsin, Usa');
insert into airport values('CNA','Cananea, Mexico');
insert into airport values('CNB','Coonamble, Nsw, Australia');
insert into airport values('CNC','Coconut Island, Qld, Australia');
commit;
insert into airport values('CND','Constanta, Romania');
insert into airport values('CNE','Canon City, Colorado, Usa');
insert into airport values('CNF','Belo Horizonte, Mg, Br-Confins');
insert into airport values('CNG','Cognac, France');
insert into airport values('CNH','Claremont, New Hampshire, Usa');
insert into airport values('CNI','Changhai, P. R. China');
insert into airport values('CNJ','Cloncurry, Qld, Australia');
insert into airport values('CNK','Concordia, Kansas, Usa');
insert into airport values('CNL','Sindal, Denmark');
insert into airport values('CNM','Carlsbad, New Mexico, Usa');
insert into airport values('CNO','Chino, California, Usa');
insert into airport values('CNP','Eastgreenland, Greenland');
insert into airport values('CNQ','Corrientes, Cr, Argentina');
insert into airport values('CNR','Chanaral, Chile');
insert into airport values('CNS','Cairns, Qld, Australia');
insert into airport values('CNT','Charata, Ch, Argentina');
insert into airport values('CNU','Chanute, Kansas, Usa');
insert into airport values('CNV','Canavieiras, Ba, Brazil');
insert into airport values('CNX','Chiang Mai, Thailand');
insert into airport values('CNY','Moab, Utah, Usa');
insert into airport values('CNZ','Cangamba, Angola');
insert into airport values('COA','Columbia, California, Usa');
insert into airport values('COB','Coolibah, Nt, Australia');
insert into airport values('COC','Concordia, Er, Argentina');
insert into airport values('COD','Cody, Wyoming, Usa');
insert into airport values('COE','Coeur D''Alene, Idaho, Usa');
insert into airport values('COG','Condoto, Colombia');
insert into airport values('COH','Cooch Behar, India');
insert into airport values('COI','Cocoa, Florida, Usa');
insert into airport values('COJ','Coonabarabran, Nsw, Australia');
commit;
insert into airport values('COK','Cochin, India');
insert into airport values('COL','Coll Island, Scotland Uk');
insert into airport values('COM','Coleman, Texas, Usa');
insert into airport values('COO','Cotonou, Benin');
insert into airport values('COQ','Choibalsan, Mongolia');
insert into airport values('COR','Cordoba, Cd, Argentina');
insert into airport values('COS','Colorado Springs, Colorado, Us');
insert into airport values('COT','Cotulla, Texas, Usa');
insert into airport values('COU','Columbia, Missouri, Usa');
insert into airport values('COV','Covilha, Portugal');
insert into airport values('COX','Congo Town, Andros Is., Bahama');
insert into airport values('COY','Coolawanyah, Wa, Australia');
insert into airport values('COZ','Constanza, Dominican Rep.');
insert into airport values('CPA','Cape Palmas, Liberia');
insert into airport values('CPB','Capurgana, Colombia');
insert into airport values('CPC','San Martin De Los Andes, Ne, A');
insert into airport values('CPD','Coober Pedy, Sa, Australia');
insert into airport values('CPE','Campeche, Mexico');
insert into airport values('CPF','Cepu, Indonesia');
insert into airport values('CPG','Carmen De Patagones, Ba, Argen');
insert into airport values('CPH','Copenhagen, Denmark-Cph');
insert into airport values('CPL','Chaparral, Colombia');
insert into airport values('CPM','Compton, California, Usa');
insert into airport values('CPN','Cape Rodney, Papua New Guinea');
insert into airport values('CPO','Copiapo, Chile');
insert into airport values('CPQ','Campinas, Sp, Brazil');
insert into airport values('CPR','Casper, Wyoming, Usa');
insert into airport values('CPS','St. Louis, Missouri, U-Bi Stat');
insert into airport values('CPT','Cape Town, South Africa');
insert into airport values('CPU','Cururupu, Ma, Brazil');
commit;
insert into airport values('CPV','Campina Grande, Pb, Brazil');
insert into airport values('CPX','Culebra, Puerto Rico');
insert into airport values('CQF','Calais, France');
insert into airport values('CQP','Cape Flattery, Qld, Australia');
insert into airport values('CQT','Caquetania, Colombia');
insert into airport values('CRA','Craiova, Romania');
insert into airport values('CRB','Collarenebri, Nsw, Australia');
insert into airport values('CRC','Cartago, Colombia');
insert into airport values('CRD','Comodoro Rivadavia, Cb, Argent');
insert into airport values('CRF','Carnot, Cen. African Republic');
insert into airport values('CRG','Jacksonville, Florida-Craig');
insert into airport values('CRH','Cherribah, Qld, Australia');
insert into airport values('CRI','Crooked Island, Bahamas');
insert into airport values('CRJ','Coorabie, Sa, Australia');
insert into airport values('CRK','Luzon Is, Philippines-Clark Fl');
insert into airport values('CRL','Charleroi, Belgium');
insert into airport values('CRM','Catarman, Philippines');
insert into airport values('CRN','Cromarty, Scotland Uk');
insert into airport values('CRO','Corcoran, California, Usa');
insert into airport values('CRP','Corpus Christi, Texas-Intl');
insert into airport values('CRQ','Caravelas, Ba, Brazil');
insert into airport values('CRR','Ceres, Sf, Argentina');
insert into airport values('CRS','Corsicana, Texas, Usa');
insert into airport values('CRT','Crossett, Arkansas, Usa');
insert into airport values('CRU','Carriacou, Windward Island');
insert into airport values('CRV','Crotone, Italy');
insert into airport values('CRW','Charleston, West Virginia, Usa');
insert into airport values('CRX','Corinth, Mississippi, Usa');
insert into airport values('CRY','Carlton Hill, Wa, Australia');
insert into airport values('CRZ','Chardzhou, Ussr');
commit;
insert into airport values('CSB','Caransebes, Romania');
insert into airport values('CSC','Canas, Costa Rica');
insert into airport values('CSD','Cresswell Downs, Nt, Australia');
insert into airport values('CSF','Creil, France');
insert into airport values('CSG','Columbus, Georgia, Usa-Metro');
insert into airport values('CSH','Cape Sarichef, Alaska, Usa');
insert into airport values('CSI','Casino, Nsw, Australia');
insert into airport values('CSJ','Cape St Jacques, Soc Rep Viet');
insert into airport values('CSK','Cap Skirring, Senegal');
insert into airport values('CSM','Clinton, Oklahoma, Usa');
insert into airport values('CSN','Carson City, Nevada, Usa');
insert into airport values('CSQ','Creston, Iowa, Usa');
insert into airport values('CSR','Casuarito, Colombia');
insert into airport values('CSS','Cassilandia, Ms, Brazil');
insert into airport values('CST','Castaway, Fiji');
insert into airport values('CSV','Crossville, Tennessee, Usa');
insert into airport values('CSX','Changsha, P. R. China');
insert into airport values('CSY','Cheboksary, Ussr');
insert into airport values('CTA','Catania, Italy');
insert into airport values('CTB','Cut Bank, Montana, Usa');
insert into airport values('CTC','Catamarca, Ca, Argentina');
insert into airport values('CTE','Carti, Panama Republic');
insert into airport values('CTG','Cartagena, Colombia');
insert into airport values('CTH','Coatesville, Pennsylvania, Usa');
insert into airport values('CTI','Cuito-Cuanavale, Angola');
insert into airport values('CTK','Canton, South Dakota, Usa');
insert into airport values('CTL','Charleville, Qld, Australia');
insert into airport values('CTM','Chetumal, Mexico');
insert into airport values('CTN','Cooktown, Qld, Australia');
insert into airport values('CTO','Calverton, New York, Usa');
commit;
insert into airport values('CTP','Carutapera, Ma, Brazil');
insert into airport values('CTQ','Santa Vitoria, Mg, Brazil');
insert into airport values('CTR','Cattle Creek, Nt, Australia');
insert into airport values('CTS','Sapporo, Japan-Chitose');
insert into airport values('CTT','Le Castellet, France');
insert into airport values('CTU','Chengdu, P. R. China');
insert into airport values('CTW','Cottonwood, Arizona, Usa');
insert into airport values('CTY','Cross City, Florida, Usa');
insert into airport values('CTZ','Clinton, North Carolina, Usa');
insert into airport values('CUA','Ciudad Constitucion, Mexico');
insert into airport values('CUC','Cucuta, Colombia');
insert into airport values('CUD','Caloundra, Qld, Australia');
insert into airport values('CUE','Cuenca, Ecuador');
insert into airport values('CUF','Cuneo, Italy');
insert into airport values('CUG','Orange, Nsw, Australia-Cudal');
insert into airport values('CUH','Cushing, Oklahoma, Usa');
insert into airport values('CUI','Currillo, Colombia');
insert into airport values('CUJ','Culion, Philippines');
insert into airport values('CUL','Culiacan, Mexico');
insert into airport values('CUM','Cumana, Venezuela');
insert into airport values('CUN','Cancun, Mexico');
insert into airport values('CUO','Caruru, Colombia');
insert into airport values('CUP','Carupano, Venezuela');
insert into airport values('CUQ','Coen, Qld, Australia');
insert into airport values('CUR','Curacao, Neth. Antilles');
insert into airport values('CUS','Columbus, New Mexico, Usa');
insert into airport values('CUT','Cutral, Ne, Argentina');
insert into airport values('CUU','Chihuahua, Mexico');
insert into airport values('CUV','Casigua, Venezuela');
insert into airport values('CUW','Cube Cove, Alaska, Usa');
commit;
insert into airport values('CUY','Cue, Wa, Australia');
insert into airport values('CUZ','Cusco, Peru');
insert into airport values('CVC','Cleve, Sa, Australia');
insert into airport values('CVE','Covenas, Colombia');
insert into airport values('CVF','Courchevel, France');
insert into airport values('CVG','Cincinnati, Ohio, Usa-Great Ci');
insert into airport values('CVH','Caviahue, Ne, Argentina');
insert into airport values('CVI','Caleta Olivia, Sc, Argentina');
insert into airport values('CVL','Cape Vogel, Papua New Guinea');
insert into airport values('CVM','Ciudad Victoria, Mexico');
insert into airport values('CVN','Clovis, New Mexico, Usa');
insert into airport values('CVO','Corvallis, Oregon, Usa');
insert into airport values('CVQ','Carnarvon, Wa, Australia');
insert into airport values('CVR','Culver City, California, Usa');
insert into airport values('CVT','Coventry, England Uk');
insert into airport values('CWA','Wausau, Wisconsin, Usa-Central');
insert into airport values('CWB','Curitiba, Pr, Brazil');
insert into airport values('CWC','Chernovtsy, Ussr');
insert into airport values('CWG','Callaway Gardens, Georgia, Usa');
insert into airport values('CWI','Clinton, Iowa, Usa');
insert into airport values('CWL','Cardiff, Wales Uk');
insert into airport values('CWP','Campbellpore, Pakistan');
insert into airport values('CWR','Cowarie, Sa, Australia');
insert into airport values('CWT','Cowra, Nsw, Australia');
insert into airport values('CWW','Corowa, Nsw, Australia');
insert into airport values('CXA','Caicara, Venezuela');
insert into airport values('CXB','Cox''S Bazar, Bangladesh');
insert into airport values('CXC','Chitina, Alaska, Usa');
insert into airport values('CXF','Coldfoot, Alaska, Usa');
insert into airport values('CXH','Vancouver, Bc, Canada-Harbour');
commit;
insert into airport values('CXI','Christmas Island, Rep. Of Kiri');
insert into airport values('CXJ','Caxias Do Sul, Rs, Brazil');
insert into airport values('CXL','Calexico, California, Usa');
insert into airport values('CXN','Candala, Somalia');
insert into airport values('CXO','Conroe, Texas, Usa');
insert into airport values('CXP','Cilacap, Indonesia');
insert into airport values('CXQ','Christmas Creek, Wa, Australia');
insert into airport values('CXT','Charters Towers, Qld, Australi');
insert into airport values('CXY','Cat Cay, Bahamas');
insert into airport values('CYA','Les Cayes, Haiti');
insert into airport values('CYB','Cayman Brac, West Indies');
insert into airport values('CYC','Caye Chapel, Belize');
insert into airport values('CYE','Crystal Lake, Pennsylvania, Us');
insert into airport values('CYF','Chefornak, Alaska, Usa');
insert into airport values('CYG','Corryong, Vic, Australia');
insert into airport values('CYI','Chiayi, Taiwan');
insert into airport values('CYL','Coyoles, Honduras');
insert into airport values('CYM','Chatham, Alaska, Usa');
insert into airport values('CYO','Cayo Largo Del Sur, Cuba');
insert into airport values('CYP','Calbayog, Philippines');
insert into airport values('CYR','Colonia, Uruguay');
insert into airport values('CYS','Cheyenne, Wyoming, Usa');
insert into airport values('CYT','Cape Yakataga, Alaska, Usa');
insert into airport values('CYU','Cuyo, Philippines');
insert into airport values('CYX','Cherskiy, Ussr');
insert into airport values('CYZ','Cauayan, Philippines');
insert into airport values('CZA','Chichen Itza, Mexico');
insert into airport values('CZB','Cruz Alta, Rs, Brazil');
insert into airport values('CZE','Coro, Venezuela');
insert into airport values('CZF','Cape Romanzof, Alaska, Usa');
commit;
insert into airport values('CZH','Corozal, Belize');
insert into airport values('CZJ','Corazon De Jesus, Panama Repub');
insert into airport values('CZK','Cascade Locks, Oregon, Usa');
insert into airport values('CZL','Constantine, Algeria');
insert into airport values('CZM','Cozumel, Mexico');
insert into airport values('CZN','Chisana, Alaska, Usa');
insert into airport values('CZO','Chistochina, Alaska, Usa');
insert into airport values('CZP','Cape Pole, Alaska, Usa');
insert into airport values('CZS','Cruzeiro Do Sul, Ac, Brazil');
insert into airport values('CZT','Carrizo Springs, Texas, Usa');
insert into airport values('CZU','Corozal, Colombia');
insert into airport values('CZW','Czestochowa, Poland');
insert into airport values('CZX','Changzhou, P. R. China');
insert into airport values('CZY','Cluny, Qld, Australia');
insert into airport values('DAB','Daytona Beach, Florida, Usa');
insert into airport values('DAC','Dhaka, Bangladesh');
insert into airport values('DAD','Da Nang, Soc. Rep. Of Viet Nam');
insert into airport values('DAE','Daparizo, India');
insert into airport values('DAF','Daup, Papua New Guinea');
insert into airport values('DAG','Daggett, California, Usa');
insert into airport values('DAH','Dathina, Yemen, Republic Of');
insert into airport values('DAJ','Dauan Island, Qld, Australia');
insert into airport values('DAL','Dallas/Ft. Worth, Texas-Love');
insert into airport values('DAM','Damascus, Syria');
insert into airport values('DAN','Danville, Virginia, Usa');
insert into airport values('DAP','Darchula, Nepal');
insert into airport values('DAR','Dar Es Salaam, Tanzania');
insert into airport values('DAU','Daru, Papua New Guinea');
insert into airport values('DAV','David, Panama Republic');
insert into airport values('DAX','Daxian, P. R. China');
commit;
insert into airport values('DAY','Dayton, Ohio, Usa-Intl');
insert into airport values('DAZ','Darwaz, Dem Rep Of Afghanistan');
insert into airport values('DBA','Dalbandin, Pakistan');
insert into airport values('DBD','Dhanbad, India');
insert into airport values('DBM','Debra Marcos, Ethiopia');
insert into airport values('DBN','Dublin, Georgia, Usa');
insert into airport values('DBO','Dubbo, Nsw, Australia');
insert into airport values('DBP','Debepare, Papua New Guinea');
insert into airport values('DBQ','Dubuque, Iowa, Usa');
insert into airport values('DBS','Dubois, Idaho, Usa');
insert into airport values('DBT','Debra Tabor, Ethiopia');
insert into airport values('DBV','Dubrovnik, Yugoslavia');
insert into airport values('DBY','Dalby, Qld, Australia');
insert into airport values('DCA','Ronald Reagan National, Washington, Dc, Usa');
insert into airport values('DCF','Dominica, West Indies-Cane');
insert into airport values('DCI','Decimomannu, Italy');
insert into airport values('DCK','Dahl Creek, Alaska, Usa');
insert into airport values('DCM','Castres, France');
insert into airport values('DCR','Decatur, Indiana, Usa');
insert into airport values('DCS','Doncaster, England Uk');
insert into airport values('DCT','Duncan Town, Ragged Island, Ba');
insert into airport values('DDC','Dodge City, Kansas, Usa');
insert into airport values('DDG','Dandong, P. R. China');
insert into airport values('DDI','Daydream Island, Qld, Australi');
insert into airport values('DDM','Dodoima, Papua New Guinea');
insert into airport values('DDN','Delta Downs, Qld, Australia');
insert into airport values('DDP','Dorado, Puerto Rico');
insert into airport values('DEB','Debrecen, Hungary');
insert into airport values('DEC','Decatur, Illinois, Usa');
insert into airport values('DED','Dehradun, India');
commit;
insert into airport values('DEH','Decorah, Iowa, Usa');
insert into airport values('DEI','Denis Is., Seychelles Is., Ind');
insert into airport values('DEL','Delhi, India');
insert into airport values('DEM','Dembidollo, Ethiopia');
insert into airport values('DEN','Denver, Colorado, Usa-Stapleto');
insert into airport values('DEO','Dearborn, Michigan, Usa');
insert into airport values('DER','Derim, Papua New Guinea');
insert into airport values('DES','Desroches, Seychelles Is. Ind.');
insert into airport values('DET','Detroit, Michigan, Usa-City');
insert into airport values('DEZ','Deirezzor, Syria');
insert into airport values('DFB','Driftwood Bay, Alaska, Usa');
insert into airport values('DFI','Defiance, Ohio, Usa');
insert into airport values('DFP','Drumduff, Qld, Australia');
insert into airport values('DFW','Dallas/Ft. Worth, Texas-Intl');
insert into airport values('DGA','Dangriga, Belize');
insert into airport values('DGB','Danger Bay, Alaska, Usa');
insert into airport values('DGC','Degahbur, Ethiopia');
insert into airport values('DGE','Mudgee, Nsw, Australia');
insert into airport values('DGL','Douglas, Arizona, Usa-Municipa');
insert into airport values('DGO','Durango, Mexico');
insert into airport values('DGP','Daugavpils, Ussr');
insert into airport values('DGR','Dargaville, New Zealand');
insert into airport values('DGT','Dumaguete, Philippines');
insert into airport values('DGU','Dedougou, Burkina Faso');
insert into airport values('DGW','Douglas, Wyoming, Usa');
insert into airport values('DHA','Dhahran, Saudi Arabia');
insert into airport values('DHD','Durham Downs, Qld, Australia');
insert into airport values('DHI','Dhangarhi, Nepal');
insert into airport values('DHL','Dhala, Yemen, Republic Of');
insert into airport values('DHM','Dharamsala, India');
commit;
insert into airport values('DHN','Dothan, Alabama, Usa');
insert into airport values('DHR','Den Helder, Netherlands');
insert into airport values('DIB','Dibrugarh, India');
insert into airport values('DIE','Antsiranana, Dem. Rep. Madagas');
insert into airport values('DIJ','Dijon, France');
insert into airport values('DIK','Dickinson, North Dakota, Usa');
insert into airport values('DIL','Dili, Indonesia');
insert into airport values('DIM','Dimbokro, Cote D''Ivoire');
insert into airport values('DIO','Little Diomede Island, Alaska,');
insert into airport values('DIP','Diapaga, Burkina Faso');
insert into airport values('DIR','Dire Dawa, Ethiopia');
insert into airport values('DIS','Loubomo, Peop. Rep. Of The Con');
insert into airport values('DIV','Divo, Cote D''Ivoire');
insert into airport values('DIY','Diyarbakir, Turkey');
insert into airport values('DJA','Djougou, Benin');
insert into airport values('DJB','Jambi, Indonesia');
insert into airport values('DJE','Djerba, Tunisia');
insert into airport values('DJG','Djanet, Algeria');
insert into airport values('DJJ','Jayapura, Indonesia');
insert into airport values('DJM','Djambala, Peop. Rep. Of The Co');
insert into airport values('DJN','Delta Junction, Alaska, Usa');
insert into airport values('DJO','Daloa, Cote D''Ivoire');
insert into airport values('DJU','Djupivogur, Iceland');
insert into airport values('DKI','Dunk Island, Qld, Australia');
insert into airport values('DKK','Dunkirk, New York, Usa');
insert into airport values('DKR','Dakar, Senegal');
insert into airport values('DKS','Dikson, Ussr');
insert into airport values('DKV','Docker River, Nt, Australia');
insert into airport values('DLA','Douala, Republic Of Cameroon');
insert into airport values('DLC','Dalian, P. R. China');
commit;
insert into airport values('DLD','Geilo, Norway');
insert into airport values('DLE','Dole, France');
insert into airport values('DLG','Dillingham, Alaska, Usa');
insert into airport values('DLH','Duluth Mn/Superior, Wi-Intl');
insert into airport values('DLI','Dalat, Soc. Rep. Of Viet Nam');
insert into airport values('DLK','Dulkaninna, Sa, Australia');
insert into airport values('DLL','Dillon, South Carolina, Usa');
insert into airport values('DLM','Dalaman, Turkey');
insert into airport values('DLN','Dillon, Montana, Usa');
insert into airport values('DLO','Dolomi, Alaska, Usa');
insert into airport values('DLS','The Dalles, Oregon, Usa');
insert into airport values('DLV','Delissaville, Nt, Australia');
insert into airport values('DLY','Dillons Bay, Vanuatu');
insert into airport values('DLZ','Dalanzadgad, Mongolia');
insert into airport values('DMB','Dzhambul, Ussr');
insert into airport values('DMD','Doomadgee Mission, Qld, Austra');
insert into airport values('DME','Moscow, Ussr-Domodedovo');
insert into airport values('DMO','Sedalia, Missouri, Usa');
insert into airport values('DMR','Dhamar, Yemen, Republic Of');
insert into airport values('DMT','Diamantino, Mt, Brazil');
insert into airport values('DMU','Dimapur, India');
insert into airport values('DNB','Dunbar, Qld, Australia');
insert into airport values('DND','Dundee, Angus, Scotland Uk');
insert into airport values('DNF','Derna, Libyan A Jamahiriya');
insert into airport values('DNH','Dunhuang, P. R. China');
insert into airport values('DNI','Wad Medani, Sudan');
insert into airport values('DNK','Dnepropetrovsk, Ussr');
insert into airport values('DNM','Denham, Wa, Australia');
insert into airport values('DNN','Dalton, Georgia, Usa');
insert into airport values('DNO','Dianopolis, To, Brazil');
commit;
insert into airport values('DNP','Dang, Nepal');
insert into airport values('DNQ','Deniliquin, Nsw, Australia');
insert into airport values('DNR','Dinard, France');
insert into airport values('DNS','Denison, Iowa, Usa');
insert into airport values('DNU','Dinangat, Papua New Guinea');
insert into airport values('DNV','Danville, Illinois, Usa');
insert into airport values('DNX','Dinder, Sudan');
insert into airport values('DNZ','Denizli, Turkey');
insert into airport values('DOA','Doany, Dem. Rep. Madagascar');
insert into airport values('DOC','Dornoch, Scotland Uk');
insert into airport values('DOD','Dodoma, Tanzania');
insert into airport values('DOE','Djoemoe, Republic Of Suriname');
insert into airport values('DOF','Dora Bay, Alaska, Usa');
insert into airport values('DOG','Dongola, Sudan');
insert into airport values('DOH','Doha, Qatar');
insert into airport values('DOI','Doini, Papua New Guinea');
insert into airport values('DOK','Donetsk, Ussr');
insert into airport values('DOL','Deauville, France');
insert into airport values('DOM','Dominica, West Indies-Melvl Ha');
insert into airport values('DON','Dos Lagunas, Guatemala');
insert into airport values('DOO','Dorobisoro, Papua New Guinea');
insert into airport values('DOP','Dolpa, Nepal');
insert into airport values('DOR','Dori, Burkina Faso');
insert into airport values('DOS','Dios, Papua New Guinea');
insert into airport values('DOU','Dourados, Ms, Brazil');
insert into airport values('DOV','Dover-Cheswold, Delaware, Usa');
insert into airport values('DOX','Dongara, Wa, Australia');
insert into airport values('DPA','West Chicago, Illinois, Usa');
insert into airport values('DPE','Dieppe, France');
insert into airport values('DPK','Deer Park, New York, Usa');
commit;
insert into airport values('DPL','Dipolog, Philippines');
insert into airport values('DPO','Devonport, Tasmania, Australia');
insert into airport values('DPS','Denpasar Bali, Indonesia');
insert into airport values('DPU','Dumpu, Papua New Guinea');
insert into airport values('DRB','Derby, Wa, Australia');
insert into airport values('DRC','Dirico, Angola');
insert into airport values('DRD','Dorunda Station, Qld, Australi');
insert into airport values('DRE','Drummond Island, Michigan, Usa');
insert into airport values('DRF','Drift River, Alaska, Usa');
insert into airport values('DRG','Deering, Alaska, Usa');
insert into airport values('DRM','Drama, Greece');
insert into airport values('DRN','Dirranbandi, Qld, Australia');
insert into airport values('DRO','Durango, Colorado, Usa');
insert into airport values('DRR','Durrie, Qld, Australia');
insert into airport values('DRS','Dresden, Fed. Rep. Of Germany');
insert into airport values('DRT','Del Rio, Texas, Usa');
insert into airport values('DRU','Drummond, Montana, Usa');
insert into airport values('DRW','Darwin, Nt, Australia');
insert into airport values('DSC','Dschang, Republic Of Cameroon');
insert into airport values('DSD','La Desirade, Guadeloupe');
insert into airport values('DSE','Dessie, Ethiopia');
insert into airport values('DSI','Destin, Florida, Usa');
insert into airport values('DSK','Dera Ismail Khan, Pakistan');
insert into airport values('DSL','Daru, Sierra Leone');
insert into airport values('DSM','Des Moines, Iowa, Usa');
insert into airport values('DSN','Dongsheng, P. R. China');
insert into airport values('DTA','Delta, Utah, Usa');
insert into airport values('DTD','Datadawai, Indonesia');
insert into airport values('DTE','Daet, Philippines');
insert into airport values('DTH','Death Valley, California, Usa');
commit;
insert into airport values('DTL','Detroit Lakes, Minnesota, Usa');
insert into airport values('DTM','Dortmund, Fed. Rep. Of Germany');
insert into airport values('DTT','Detroit, Michigan, Usa-Wayne C');
insert into airport values('DTW','Detroit, Michigan, Usa-Wayne C');
insert into airport values('DUB','Dublin, Republic Of Ireland');
insert into airport values('DUC','Duncan, Oklahoma, Usa');
insert into airport values('DUD','Dunedin, New Zealand');
insert into airport values('DUE','Dundo, Angola');
insert into airport values('DUG','Douglas, Arizona, Usa-Bis/Doug');
insert into airport values('DUJ','Du Bois, Pennsylvania, Usa');
insert into airport values('DUK','Dukuduk, South Africa');
insert into airport values('DUM','Dumai, Indonesia');
insert into airport values('DUN','Dundas, Greenland');
insert into airport values('DUQ','Duncan/Quamichan Lake, Bc, Can');
insert into airport values('DUR','Durban, South Africa');
insert into airport values('DUS','Duesseldorf, Fed. Rep. Of-Dus');
insert into airport values('DUT','Dutch Harbor, Alaska, Usa');
insert into airport values('DVA','Deva, Romania');
insert into airport values('DVL','Devils Lake, North Dakota, Usa');
insert into airport values('DVO','Davao, Philippines');
insert into airport values('DVP','Davenport Downs, Qld, Australi');
insert into airport values('DVR','Daly River, Nt, Australia');
insert into airport values('DVT','Phoenix, Arizona, Usa-Deer Val');
insert into airport values('DWA','Dwangwa, Malawi');
insert into airport values('DWB','Soalala, Dem. Rep. Madagascar');
insert into airport values('DXB','Dubai, U. A. Emirates');
insert into airport values('DXD','Dixie, Qld, Australia');
insert into airport values('DXR','Danbury, Connecticut, Usa');
insert into airport values('DYA','Dysart, Qld, Australia');
insert into airport values('DYG','Dayong, P. R. China');
commit;
insert into airport values('DYL','Doylestown, Pennsylvania, Usa');
insert into airport values('DYM','Diamantina Lakes, Qld, Austral');
insert into airport values('DYR','Anadyr, Ussr');
insert into airport values('DYU','Dushanbe, Ussr');
insert into airport values('DYW','Daly Waters, Nt, Australia');
insert into airport values('DZA','Dzaoudzi, Comoros');
insert into airport values('DZI','Codazzi, Colombia');
insert into airport values('DZN','Dzezkazgan, Ussr');
insert into airport values('DZO','Durazno, Uruguay');
insert into airport values('DZU','Dazu, P. R. China');
insert into airport values('EAA','Eagle, Alaska, Usa');
insert into airport values('EAB','Abbse, Yemen, Republic Of');
insert into airport values('EAE','Emae, Vanuatu');
insert into airport values('EAM','Nejran, Saudi Arabia');
insert into airport values('EAN','Wheatland, Wyoming, Usa');
insert into airport values('EAR','Kearney, Nebraska, Usa');
insert into airport values('EAS','San Sebastian, Spain');
insert into airport values('EAT','Wenatchee, Washington, Usa');
insert into airport values('EAU','Eau Claire, Wisconsin, Usa');
insert into airport values('EBA','Elba Island, Italy');
insert into airport values('EBB','Entebbe/Kampala, Uganda');
insert into airport values('EBD','El Obeid, Sudan');
insert into airport values('EBG','El Bagre, Colombia');
insert into airport values('EBJ','Esbjerg, Denmark');
insert into airport values('EBM','El Borma, Tunisia');
insert into airport values('EBN','Ebadon, Marshall Islands');
insert into airport values('EBS','Webster City, Iowa, Usa');
insert into airport values('EBU','St. Etienne, France');
insert into airport values('EBW','Ebolowa, Republic Of Cameroon');
insert into airport values('ECA','East Tawas, Michigan, Usa');
commit;
insert into airport values('ECG','Elizabeth City, North Carolina');
insert into airport values('ECH','Echuca, Vic, Australia');
insert into airport values('ECN','Ercan, Cyprus');
insert into airport values('ECO','El Encanto, Colombia');
insert into airport values('ECR','El Charco, Colombia');
insert into airport values('ECS','Newcastle, Wyoming, Usa');
insert into airport values('EDA','Edna Bay, Alaska, Usa');
insert into airport values('EDB','Eldebba, Sudan');
insert into airport values('EDD','Erldunda, Nt, Australia');
insert into airport values('EDE','Edenton, North Carolina, Usa');
insert into airport values('EDI','Edinburgh, Scotland Uk');
insert into airport values('EDK','El Dorado, Kansas, Usa');
insert into airport values('EDL','Eldoret, Kenya');
insert into airport values('EDM','La Roche, France');
insert into airport values('EDQ','Erandique, Honduras');
insert into airport values('EDR','Edward River, Qld, Australia');
insert into airport values('EDW','Edwards, California, Usa');
insert into airport values('EED','Needles, California, Usa');
insert into airport values('EEK','Eek, Alaska, Usa');
insert into airport values('EEN','Keene, New Hampshire, Usa');
insert into airport values('EFB','Eight Fathom Bight, Alaska, Us');
insert into airport values('EFD','Houston, Texas, Usa-Ellington');
insert into airport values('EFG','Efogi, Papua New Guinea');
insert into airport values('EFK','Newport, Vermont, Usa');
insert into airport values('EFL','Kefalonia, Greece');
insert into airport values('EFW','Jefferson, Iowa, Usa');
insert into airport values('EGA','Engati, Papua New Guinea');
insert into airport values('EGC','Bergerac, France');
insert into airport values('EGE','Vail/Eagle, Colorado-Eagle Cnt');
insert into airport values('EGL','Neghelli, Ethiopia');
commit;
insert into airport values('EGM','Sege, Solomon Islands');
insert into airport values('EGN','El Geneina, Sudan');
insert into airport values('EGO','Belgorod, Ussr');
insert into airport values('EGP','Eagle Pass, Texas, Usa');
insert into airport values('EGS','Egilsstadir, Iceland');
insert into airport values('EGV','Eagle River, Wisconsin, Usa');
insert into airport values('EGX','Egegik, Alaska, Usa');
insert into airport values('EHL','El Bolson, Rn, Argentina');
insert into airport values('EHM','Cape Newenham, Alaska, Usa');
insert into airport values('EHT','East Hartford, Connecticut, Us');
insert into airport values('EIA','Eia, Papua New Guinea');
insert into airport values('EIE','Eniseysk, Ussr');
insert into airport values('EIH','Einasleigh, Qld, Australia');
insert into airport values('EIN','Eindhoven, Netherlands');
insert into airport values('EIS','Tortola, Brit. Virgin-Beef Is');
insert into airport values('EIY','Ein Yahav, Israel');
insert into airport values('EJA','Barrancabermeja, Colombia');
insert into airport values('EJH','Wedjh, Saudi Arabia');
insert into airport values('EKA','Eureka/Arcata, Califor-Murray');
insert into airport values('EKB','Ekibastuz, Ussr');
insert into airport values('EKD','Elkedra, Nt, Australia');
insert into airport values('EKE','Ekereku, Guyana');
insert into airport values('EKI','Elkhart, Indiana, Usa');
insert into airport values('EKN','Elkins, West Virginia, Usa');
insert into airport values('EKO','Elko, Nevada, Usa');
insert into airport values('EKT','Eskilstuna, Sweden');
insert into airport values('EKX','Elizabethtown/Ft. Knox, Ky, Us');
insert into airport values('ELA','Eagle Lake, Texas, Usa');
insert into airport values('ELB','El Banco, Colombia');
insert into airport values('ELC','Elcho Island, Nt, Australia');
commit;
insert into airport values('ELD','El Dorado, Arkansas, Usa');
insert into airport values('ELE','El Real, Panama Republic');
insert into airport values('ELF','El Fasher, Sudan');
insert into airport values('ELG','El Golea, Algeria');
insert into airport values('ELH','North Eleuthera, Bahamas');
insert into airport values('ELI','Elim, Alaska, Usa');
insert into airport values('ELJ','El Recreo, Colombia');
insert into airport values('ELK','Elk City, Oklahoma, Usa');
insert into airport values('ELL','Ellisras, South Africa');
insert into airport values('ELM','Elmira, New York, Usa');
insert into airport values('ELN','Ellensburg, Washington, Usa');
insert into airport values('ELO','Eldorado, Mi, Argentina');
insert into airport values('ELP','El Paso, Texas, Usa');
insert into airport values('ELQ','Gassim, Saudi Arabia');
insert into airport values('ELS','East London, South Africa');
insert into airport values('ELT','Tour Sinai City, Arab Rep. Of');
insert into airport values('ELU','El Oued, Algeria');
insert into airport values('ELV','Elfin Cove, Alaska, Usa');
insert into airport values('ELW','Ellamar, Alaska, Usa');
insert into airport values('ELY','Ely, Nevada, Usa');
insert into airport values('ELZ','Wellsville, New York, Usa');
insert into airport values('EMA','East Midlands, England Uk');
insert into airport values('EMD','Emerald, Qld, Australia');
insert into airport values('EME','Emden, Fed. Rep. Of Germany');
insert into airport values('EMG','Empangeni, Namibia');
insert into airport values('EMI','Emirau, Papua New Guinea');
insert into airport values('EMK','Emmonak, Alaska, Usa');
insert into airport values('EMM','Kemmerer, Wyoming, Usa');
insert into airport values('EMN','Nema, Mauritania');
insert into airport values('EMO','Emo, Papua New Guinea');
commit;
insert into airport values('EMP','Emporia, Kansas, Usa');
insert into airport values('EMS','Embessa, Papua New Guinea');
insert into airport values('EMT','El Monte, California, Usa');
insert into airport values('EMX','El Maiten, Cb, Argentina');
insert into airport values('EMY','El Minya, Arab Rep. Of Egypt');
insert into airport values('ENA','Kenai, Alaska, Usa');
insert into airport values('ENB','Eneabba, Wa, Australia');
insert into airport values('ENC','Nancy, France');
insert into airport values('ENE','Ende, Indonesia');
insert into airport values('ENF','Enontekio, Finland');
insert into airport values('ENH','Enshi, P. R. China');
insert into airport values('ENI','El Nido, Philippines');
insert into airport values('ENJ','El Naranjo, Guatemala');
insert into airport values('ENK','Enniskillen, N. Ireland Uk');
insert into airport values('ENL','Centralia, Illinois, Usa');
insert into airport values('ENN','Nenana, Alaska, Usa');
insert into airport values('ENO','Encarnacion, Paraguay');
insert into airport values('ENQ','Coronel E. Soto Cano Ab, Hondu');
insert into airport values('ENS','Enschede, Netherlands');
insert into airport values('ENT','Eniwetok, Marshall Islands');
insert into airport values('ENU','Enugu, Nigeria');
insert into airport values('ENV','Wendover, Utah, Usa');
insert into airport values('ENW','Kenosha, Wisconsin, Usa');
insert into airport values('ENY','Yan''An, P. R. China');
insert into airport values('EOI','Eday, Orkney Island, Scotland');
insert into airport values('EOK','Keokuk, Iowa, Usa');
insert into airport values('EOR','El Dorado, Venezuela');
insert into airport values('EOS','Neosho, Missouri, Usa');
insert into airport values('EOZ','Elorza, Venezuela');
insert into airport values('EPG','Weeping Water, Nebraska, Usa');
commit;
insert into airport values('EPH','Ephrata, Washington, Usa');
insert into airport values('EPI','Epi, Vanuatu');
insert into airport values('EPK','Episkopi, Cyprus');
insert into airport values('EPL','Epinal, France');
insert into airport values('EPN','Epena, Peop. Rep. Of The Congo');
insert into airport values('EPR','Esperance, Wa, Australia');
insert into airport values('EPT','Eliptamin, Papua New Guinea');
insert into airport values('EQS','Esquel, Cb, Argentina');
insert into airport values('ERA','Erigavo, Somalia');
insert into airport values('ERB','Ernabella, Sa, Australia');
insert into airport values('ERC','Erzincan, Turkey');
insert into airport values('ERD','Berdyansk, Ussr');
insert into airport values('ERE','Erave, Papua New Guinea');
insert into airport values('ERF','Erfurt, Fed. Rep. Of Germany');
insert into airport values('ERH','Errachidia, Morocco');
insert into airport values('ERI','Erie, Pennsylvania, Usa');
insert into airport values('ERM','Erechim, Rs, Brazil');
insert into airport values('ERN','Eirunepe, Am, Brazil');
insert into airport values('ERR','Errol, New Hampshire, Usa');
insert into airport values('ERS','Windhoek, Namibia-Eros');
insert into airport values('ERT','Erdenet, Mongolia');
insert into airport values('ERU','Erume, Papua New Guinea');
insert into airport values('ERV','Kerrville, Texas, Usa');
insert into airport values('ERZ','Erzurum, Turkey');
insert into airport values('ESA','Esa''Ala, Papua New Guinea');
insert into airport values('ESB','Ankara, Turkey');
insert into airport values('ESC','Escanaba, Michigan, Usa');
insert into airport values('ESD','Eastsound, Washington, Usa');
insert into airport values('ESE','Ensenada, Mexico');
insert into airport values('ESF','Alexandria, Louisiana, Usa');
commit;
insert into airport values('ESG','Mariscal Estigarribia, Paragua');
insert into airport values('ESH','Shoreham-By-Sea, England Uk');
insert into airport values('ESI','Espinosa, Mg, Brazil');
insert into airport values('ESK','Eskisehir, Turkey');
insert into airport values('ESL','Elista, Ussr');
insert into airport values('ESM','Esmeraldas, Ecuador');
insert into airport values('ESN','Easton, Maryland, Usa');
insert into airport values('ESO','Espanola, New Mexico, Usa');
insert into airport values('ESP','East Stroudsburg, Pennsylvania');
insert into airport values('ESR','El Salvador, Chile');
insert into airport values('ESS','Essen, Fed. Rep. Of Germany');
insert into airport values('EST','Estherville, Iowa, Usa');
insert into airport values('ESW','Easton, Washington, Usa');
insert into airport values('ETB','West Bend, Wisconsin, Usa');
insert into airport values('ETD','Etadunna, Sa, Australia');
insert into airport values('ETE','Genda Wuha, Ethiopia');
insert into airport values('ETH','Elat, Israel');
insert into airport values('ETN','Eastland, Texas, Usa');
insert into airport values('ETS','Enterprise, Alabama, Usa');
insert into airport values('ETZ','Metz-Nancy, France');
insert into airport values('EUA','Eua, Tonga Island, S. Pacific');
insert into airport values('EUC','Eucla, Wa, Australia');
insert into airport values('EUE','Eureka, Nevada, Usa');
insert into airport values('EUF','Eufaula, Alabama, Usa');
insert into airport values('EUG','Eugene, Oregon, Usa');
insert into airport values('EUM','Neumuenster, Fed. Rep. Of Germ');
insert into airport values('EUN','Laayoune, Morocco');
insert into airport values('EUX','St. Eustatius, Neth. Antilles');
insert into airport values('EVA','Evadale, Texas, Usa');
insert into airport values('EVD','Eva Downs, Nt, Australia');
commit;
insert into airport values('EVE','Evenes, Norway');
insert into airport values('EVG','Sveg, Sweden');
insert into airport values('EVH','Evans Head, Nsw, Australia');
insert into airport values('EVM','Eveleth, Minnesota, Usa');
insert into airport values('EVN','Yerevan, Ussr');
insert into airport values('EVV','Evansville, Indiana, Usa');
insert into airport values('EVW','Evanston, Wyoming, Usa');
insert into airport values('EVX','Evreux, France');
insert into airport values('EWB','New Bedford, Massachusetts, Us');
insert into airport values('EWE','Ewer, Indonesia');
insert into airport values('EWI','Enarotali, Indonesia');
insert into airport values('EWK','Newton, Kansas, Usa');
insert into airport values('EWN','New Bern, North Carolina, Usa');
insert into airport values('EWO','Ewo, Peop. Rep. Of The Congo');
insert into airport values('EWR','New York Ny/Newark, Nj-Newark');
insert into airport values('EXI','Excursion Inlet, Alaska, Usa');
insert into airport values('EXM','Exmouth Gulf, Wa, Australia');
insert into airport values('EXT','Exeter, England Uk');
insert into airport values('EYL','Yelimane, Mali');
insert into airport values('EYP','El Yopal, Colombia');
insert into airport values('EYR','Yerington, Nevada, Usa');
insert into airport values('EYS','Eliye Springs, Kenya');
insert into airport values('EYW','Key West, Florida, Usa');
insert into airport values('EZE','Buenos Aires, Ba, Arge-Pistari');
insert into airport values('EZS','Elazig, Turkey');
insert into airport values('FAA','Faranah, Guinea');
insert into airport values('FAE','Faroe Islands, Denmark');
insert into airport values('FAG','Fagurholsmyri, Iceland');
insert into airport values('FAH','Farah, Dem Rep Of Afghanistan');
insert into airport values('FAI','Fairbanks, Alaska, Usa-Intl');
commit;
insert into airport values('FAJ','Fajardo, Puerto Rico');
insert into airport values('FAK','False Island, Alaska, Usa');
insert into airport values('FAL','Roma, Texas, Usa');
insert into airport values('FAM','Farmington, Missouri, Usa');
insert into airport values('FAN','Farsund, Norway');
insert into airport values('FAO','Faro, Portugal');
insert into airport values('FAR','Fargo, North Dakota, Usa');
insert into airport values('FAS','Faskrudsfjordur, Iceland');
insert into airport values('FAT','Fresno, California, Usa');
insert into airport values('FAV','Fakarava, French Polynesia');
insert into airport values('FAY','Fayetteville, North Carolina,');
insert into airport values('FBD','Faizabad, Dem Rep Of Afghanist');
insert into airport values('FBE','Francisco Beltrao, Pr, Brazil');
insert into airport values('FBL','Faribault, Minnesota, Usa');
insert into airport values('FBM','Lubumbashi, Zaire');
insert into airport values('FBR','Fort Bridger, Wyoming, Usa');
insert into airport values('FBU','Oslo, Norway-Fornebu');
insert into airport values('FBY','Fairbury, Nebraska, Usa');
insert into airport values('FCA','Kalispell/Glacier Natl Pk, Mt,');
insert into airport values('FCB','Ficksburg, South Africa');

insert into airport values('FCO','Rome, Italy-Da Vinci');
insert into airport values('FCY','Forrest City, Arkansas, Usa');
insert into airport values('FDE','Forde, Norway');
insert into airport values('FDF','Fort De France, Martinique');
insert into airport values('FDH','Friedrichshafen, Fed Rep Of Ge');
insert into airport values('FDK','Frederick, Maryland, Usa');
insert into airport values('FDR','Frederick, Oklahoma, Usa');
insert into airport values('FDU','Bandundu, Zaire');
insert into airport values('FDY','Findlay, Ohio, Usa');
commit;
insert into airport values('FEA','Fetlar, Shetland Is., Scotland');
insert into airport values('FEB','Sanfebagar, Nepal');
insert into airport values('FEG','Fergana, Ussr');
insert into airport values('FEL','Furstenfeldbruck, Fed Rep Of G');
insert into airport values('FEN','Fernando De Noronha, Fn, Brazi');
insert into airport values('FEP','Freeport, Illinois, Usa');
insert into airport values('FET','Fremont, Nebraska, Usa');
insert into airport values('FEZ','Fez, Morocco');
insert into airport values('FFA','Kill Devil Hills, Nc, Usa');
insert into airport values('FFL','Fairfield, Iowa, Usa');
insert into airport values('FFM','Fergus Falls, Minnesota, Usa');
insert into airport values('FFT','Frankfort, Kentucky, Usa');
insert into airport values('FFU','Futaleufu, Chile');
insert into airport values('FGD','F''Derik, Mauritania');
insert into airport values('FGI','Apia, Western Samoa-Fagali I');
insert into airport values('FGL','Fox Glacier, New Zealand');
insert into airport values('FGU','Fangatau, French Polynesia');
insert into airport values('FHU','Fort Huachuca/Sr. Vista, Az, U');
insert into airport values('FHZ','Fakahina, French Polynesia');
insert into airport values('FIC','Fire Cove, Alaska, Usa');
insert into airport values('FID','Fishers Island, New York, Usa');
insert into airport values('FIE','Fair Isle, Scotland Uk');
insert into airport values('FIG','Fria, Guinea');
insert into airport values('FIH','Kinshasa, Zaire');
insert into airport values('FIK','Finke, Nt, Australia');
insert into airport values('FIL','Fillmore, Utah, Usa');
insert into airport values('FIN','Finschhafen, Papua New Guinea');
insert into airport values('FIV','Five Finger, Alaska, Usa');
insert into airport values('FIZ','Fitzroy Crossing, Wa, Australi');
insert into airport values('FJR','Al-Fujairah, U. A. Emirates');
commit;
insert into airport values('FKI','Kisangani, Zaire');
insert into airport values('FKJ','Fukui, Japan');
insert into airport values('FKL','Franklin, Pennsylvania, Usa');
insert into airport values('FKN','Franklin, Virginia, Usa');
insert into airport values('FKQ','Fak-Fak, Indonesia');
insert into airport values('FLA','Florencia, Colombia');
insert into airport values('FLB','Floriano, Pi, Brazil');
insert into airport values('FLC','Falls Creek, Victoria, Austral');
insert into airport values('FLD','Fond Du Lac, Wisconsin, Usa');
insert into airport values('FLF','Flensburg, Fed. Rep. Of German');
insert into airport values('FLG','Flagstaff, Arizona, Usa');
insert into airport values('FLH','Flotta Isle, Scotland Uk');
insert into airport values('FLI','Flateyri, Iceland');
insert into airport values('FLJ','Falls Bay, Alaska, Usa');
insert into airport values('FLL','Ft. Lauderdale, Florid-Intl');
insert into airport values('FLM','Filadelfia, Paraguay');
insert into airport values('FLN','Florianopolis, Sc, Brazil');
insert into airport values('FLO','Florence, South Carolina, Usa');
insert into airport values('FLP','Flippin, Arkansas, Usa');
insert into airport values('FLR','Florence, Italy');
insert into airport values('FLS','Flinders Is., Tasmania, Austra');
insert into airport values('FLT','Flat, Alaska, Usa');
insert into airport values('FLW','Santa Cruz, Flores, Port. (Azo');
insert into airport values('FLX','Fallon, Nevada, Usa');
insert into airport values('FLY','Finley, Nsw, Australia');
insert into airport values('FMA','Formosa, Fo, Argentina');
insert into airport values('FMC','Five Mile, Alaska, Usa');
insert into airport values('FMG','Flamingo, Costa Rica');
insert into airport values('FMH','Falmouth, Massachusetts, Usa');
insert into airport values('FMI','Kalemie, Zaire');
commit;
insert into airport values('FMN','Farmington, New Mexico, Usa');
insert into airport values('FMO','Muenster, Fed. Rep. Of Germany');
insert into airport values('FMS','Fort Madison, Iowa, Usa');
insert into airport values('FMY','Fort Myers, Florida, U-Page');
insert into airport values('FNA','Freetown, Sierra Leone-Lungi I');
insert into airport values('FNC','Funchal, Portugal (Madeira)');
insert into airport values('FNE','Fane, Papua New Guinea');
insert into airport values('FNG','Fada Ngourma, Burkina Faso');
insert into airport values('FNI','Nimes, France');
insert into airport values('FNJ','Pyongyang, Dem. Peop''S Rep. Ko');
insert into airport values('FNK','Fin Creek, Alaska, Usa');
insert into airport values('FNL','Fort Collins/Loveland, Colorad');
insert into airport values('FNR','Funter Bay, Alaska, Usa');
insert into airport values('FNT','Flint, Michigan, Usa');
insert into airport values('FOB','Fort Bragg, California, Usa');
insert into airport values('FOC','Fuzhou, P. R. China');
insert into airport values('FOD','Fort Dodge, Iowa, Usa');
insert into airport values('FOE','Topeka, Kansas, Usa-Forbes');
insert into airport values('FOG','Foggia, Italy');
insert into airport values('FOK','Westhampton, New York, Usa');
insert into airport values('FOM','Foumban, Republic Of Cameroon');
insert into airport values('FOO','Numfoor, Indonesia');
insert into airport values('FOR','Fortaleza, Ce, Brazil');
insert into airport values('FOS','Forrest, Wa, Australia');
insert into airport values('FOT','Forster, Nsw, Australia');
insert into airport values('FOU','Fougamou, Gabon');
insert into airport values('FOX','Fox, Alaska, Usa');
insert into airport values('FOY','Foya, Liberia');
insert into airport values('FPO','Freeport, Bahamas');
insert into airport values('FPR','Fort Pierce, Florida, Usa');
commit;
insert into airport values('FPY','Perry, Florida, Usa');
insert into airport values('FRA','Frankfurt, Fed. Rep. Of German');
insert into airport values('FRB','Forbes, Nsw, Australia');
insert into airport values('FRC','Franca, Sp, Brazil');
insert into airport values('FRD','Friday Harbor, Washington, Usa');
insert into airport values('FRE','Fera Island, Solomon Islands');
insert into airport values('FRG','Long Island Republic, New York');
insert into airport values('FRH','French Lick, Indiana, Usa');
insert into airport values('FRJ','Frejus, France');
insert into airport values('FRK','Fregate Is., Seychelles Is. In');
insert into airport values('FRL','Forli, Italy');
insert into airport values('FRM','Fairmont, Minnesota, Usa');
insert into airport values('FRO','Floro, Norway');
insert into airport values('FRP','Fresh Water Bay, Alaska, Usa');
insert into airport values('FRQ','Feramin, Papua New Guinea');
insert into airport values('FRR','Front Royal, Virginia, Usa');
insert into airport values('FRS','Flores, Guatemala');
insert into airport values('FRU','Bishkek, Ussr');
insert into airport values('FRW','Francistown, Botswana');
insert into airport values('FRY','Fryeburg, Maine, Usa');
insert into airport values('FSC','Figari, Corsica, France');
insert into airport values('FSD','Sioux Falls, South Dakota, Usa');
insert into airport values('FSK','Fort Scott, Kansas, Usa');
insert into airport values('FSL','Fossil Downs, Wa, Australia');
insert into airport values('FSM','Ft. Smith, Arkansas, Usa');
insert into airport values('FSP','St. Pierre, St. Pierre & Mique');
insert into airport values('FSS','Forres, Scotland Uk');
insert into airport values('FST','Ft. Stockton, Texas, Usa');
insert into airport values('FSU','Fort Sumner, New Mexico, Usa');
insert into airport values('FTA','Futuna Island, Vanuatu');
commit;
insert into airport values('FTI','Fitiuta, American Samoa');
insert into airport values('FTL','Fortuna Ledge, Alaska, Usa');
insert into airport values('FTU','Ft. Dauphin, Dem. Rep. Madagas');
insert into airport values('FTW','Dallas/Ft. Worth, Texas-Meacham');
insert into airport values('FTX','Owando, Peop. Rep. Of The Cong');
insert into airport values('FUB','Fulleborn, Papua New Guinea');
insert into airport values('FUE','Fuerteventura, Canary Islands');
insert into airport values('FUG','Fuyang, P. R. China');
insert into airport values('FUJ','Fukue, Japan');
insert into airport values('FUK','Fukuoka, Japan');
insert into airport values('FUL','Fullerton, California, Usa');
insert into airport values('FUM','Fuma, Papua New Guinea');
insert into airport values('FUN','Funafuti Atol, Tuvalu');
insert into airport values('FUT','Futuna, Wallis & Futuna Island');
insert into airport values('FWA','Fort Wayne, Indiana, Usa');
insert into airport values('FWL','Farewell, Alaska, Usa');
insert into airport values('FWM','Fort William, Scotland Uk');
insert into airport values('FXE','Ft. Lauderdale, Florid-Executi');
insert into airport values('FXM','Flaxman Island, Alaska, Usa');
insert into airport values('FXO','Cuamba, Mozambique');
insert into airport values('FXY','Forest City, Iowa, Usa');
insert into airport values('FYM','Fayetteville, Tennessee, Usa');
insert into airport values('FYN','Fuyun, P. R. China');
insert into airport values('FYT','Faya, Chad');
insert into airport values('FYU','Ft. Yukon, Alaska, Usa');
insert into airport values('FYV','Fayetteville, Arkansas, Usa');
insert into airport values('FZO','Filton, England Uk');
insert into airport values('GAA','Guamal, Colombia');
insert into airport values('GAB','Gabbs, Nevada, Usa');
insert into airport values('GAC','Gracias, Honduras');
commit;
insert into airport values('GAD','Gadsden, Alabama, Usa');
insert into airport values('GAE','Gabes, Tunisia');
insert into airport values('GAF','Gafsa, Tunisia');
insert into airport values('GAG','Gage, Oklahoma, Usa');
insert into airport values('GAH','Gayndah, Qld, Australia');
insert into airport values('GAI','Gaithersburg, Maryland, Usa');
insert into airport values('GAJ','Yamagata, Honshu, Japan');
insert into airport values('GAK','Gakona, Alaska, Usa');
insert into airport values('GAL','Galena, Alaska, Usa');
insert into airport values('GAM','Gambell, Alaska, Usa');
insert into airport values('GAO','Guantanamo, Cuba');
insert into airport values('GAP','Gusap, Papua New Guinea');
insert into airport values('GAQ','Gao, Mali');
insert into airport values('GAR','Garaina, Papua New Guinea');
insert into airport values('GAS','Garissa, Kenya');
insert into airport values('GAT','Gap, France');
insert into airport values('GAU','Gauhati, India');
insert into airport values('GAV','Gag Island, Indonesia');
insert into airport values('GAW','Gangaw, Myanmar');
insert into airport values('GAX','Gamba, Gabon');
insert into airport values('GAY','Gaya, India');
insert into airport values('GAZ','Guasopa, Papua New Guinea');
insert into airport values('GBA','Big Bay, Vanuatu');
insert into airport values('GBB','Gara Djebilet, Algeria');
insert into airport values('GBC','Gasuke, Papua New Guinea');
insert into airport values('GBD','Great Bend, Kansas, Usa');
insert into airport values('GBE','Gaborone, Botswana');
insert into airport values('GBF','Negarbo, Papua New Guinea');
insert into airport values('GBG','Galesburg, Illinois, Usa');
insert into airport values('GBH','Galbraith Lake, Alaska, Usa');
commit;
insert into airport values('GBJ','Marie Galante, French Antilles');
insert into airport values('GBK','Gbangbatok, Sierra Leone');
insert into airport values('GBL','Goulburn Island, Nt, Australia');
insert into airport values('GBM','Garbaharey, Somalia');
insert into airport values('GBO','Baltimore, Maryland, U-Greenbe');
insert into airport values('GBP','Gamboola, Qld, Australia');
insert into airport values('GBR','Great Barrington, Massachusett');
insert into airport values('GBU','Khashm El Girba, Sudan');
insert into airport values('GBV','Gibb River, Wa, Australia');
insert into airport values('GBZ','Great Barrier Island, New Zeal');
insert into airport values('GCA','Guacamayas, Colombia');
insert into airport values('GCC','Gillette, Wyoming, Usa');
insert into airport values('GCI','Guernsey, Channel Is. Uk');
insert into airport values('GCK','Garden City, Kansas, Usa');
insert into airport values('GCM','Grand Cayman, West Indies');
insert into airport values('GCN','Grand Canyon, Arizona, Usa-Gcn');
insert into airport values('GCY','Greenville, Tennessee, Usa');
insert into airport values('GDA','Gounda, Cen. African Republic');
insert into airport values('GDD','Gordon Downs, Wa, Australia');
insert into airport values('GDE','Gode, Ethiopia');
insert into airport values('GDG','Magdagachi, Ussr');
insert into airport values('GDH','Golden Horn, Alaska, Usa');
insert into airport values('GDI','Gordil, Cen. African Republic');
insert into airport values('GDJ','Gandajika, Zaire');
insert into airport values('GDL','Guadalajara, Mexico');
insert into airport values('GDM','Gardner, Massachusetts, Usa');
insert into airport values('GDN','Gdansk, Poland');
insert into airport values('GDO','Guasdualito, Venezuela');
insert into airport values('GDP','Guadalupe, Pi, Brazil');
insert into airport values('GDQ','Gondar, Ethiopia');
commit;
insert into airport values('GDT','Grand Turk, Turks & Caicos Is');
insert into airport values('GDV','Glendive, Montana, Usa');
insert into airport values('GDW','Gladwin, Michigan, Usa');
insert into airport values('GDX','Magadan, Ussr');
insert into airport values('GDZ','Gelendzik, Ussr');
insert into airport values('GEA','Noumea, New Caledonia-Magenta');
insert into airport values('GEB','Gebe, Indonesia');
insert into airport values('GEC','Gecitkale, Cyprus');
insert into airport values('GED','Georgetown, Delaware, Usa');
insert into airport values('GEG','Spokane, Washington, U-Intl');
insert into airport values('GEI','Green Islands, Papua New Guine');
insert into airport values('GEK','Ganes Creek, Alaska, Usa');
insert into airport values('GEL','Santo Angelo, Rs, Brazil');
insert into airport values('GEN','Oslo, Norway-Gardermoen');
insert into airport values('GEO','Georgetown, Guyana');
insert into airport values('GER','Nueva Gerona, Cuba');
insert into airport values('GES','General Santos, Philippines');
insert into airport values('GET','Geraldton, Wa, Australia');
insert into airport values('GEV','Gallivare, Sweden');
insert into airport values('GEW','Gewoya, Papua New Guinea');
insert into airport values('GEX','Geelong, Victoria, Australia');
insert into airport values('GEY','Greybull, Wyoming, Usa');
insert into airport values('GFB','Togiak Fish, Alaska, Usa');
insert into airport values('GFE','Grenfell, Nsw, Australia');
insert into airport values('GFF','Griffith, Nsw, Australia');
insert into airport values('GFK','Grand Forks, North Dakota, Usa');
insert into airport values('GFL','Glens Falls, New York, Usa');
insert into airport values('GFN','Grafton, Nsw, Australia');
insert into airport values('GFO','Bartica, Guyana');
insert into airport values('GFR','Granville, France');
commit;
insert into airport values('GFY','Grootfontein, Namibia');
insert into airport values('GGC','Lumbala, Angola');
insert into airport values('GGD','Gregory Downs, Qld, Australia');
insert into airport values('GGE','Georgetown, South Carolina, Us');
insert into airport values('GGG','Longview, Texas, Usa');
insert into airport values('GGL','Gilgal, Colombia');
insert into airport values('GGN','Gagnoa, Cote D''Ivoire');
insert into airport values('GGO','Guiglo, Cote D''Ivoire');
insert into airport values('GGR','Garoe, Somalia');
insert into airport values('GGS','Gobernador Gregores, Sc, Argen');
insert into airport values('GGT','George Town, Bahamas');
insert into airport values('GGW','Glasgow, Montana, Usa');
insert into airport values('GHA','Ghardaia, Algeria');
insert into airport values('GHB','Governors Harbour, Bahamas');
insert into airport values('GHC','Great Harbour Cay, Bahamas');
insert into airport values('GHE','Garachine, Panama Republic');
insert into airport values('GHM','Centerville, Tennessee, Usa');
insert into airport values('GHN','Guanghan, P. R. China');
insert into airport values('GHT','Ghat, Libyan A Jamahiriya');
insert into airport values('GHU','Gualeguaychu, Er, Argentina');
insert into airport values('GIB','Gibraltar, Gibraltar');
insert into airport values('GIC','Boigu Island, Qld, Australia');
insert into airport values('GID','Gitega, Burundi');
insert into airport values('GIF','Winter Haven, Florida, Usa');
insert into airport values('GIG','Rio De Janeiro, Rj, Br-Intl');
insert into airport values('GII','Siguiri, Guinea');
insert into airport values('GIL','Gilgit, Pakistan');
insert into airport values('GIM','Miele, Gabon');
insert into airport values('GIR','Girardot, Colombia');
insert into airport values('GIS','Gisborne, New Zealand');
commit;
insert into airport values('GIT','Geita, Tanzania');
insert into airport values('GIZ','Gizan, Saudi Arabia');
insert into airport values('GJA','Guanaja Island, Honduras');
insert into airport values('GJL','Jijel, Algeria');
insert into airport values('GJM','Guajara-Mirim, Ro, Brazil');
insert into airport values('GJR','Gjogur, Iceland');
insert into airport values('GJT','Grand Junction, Colorado, Usa');
insert into airport values('GKA','Goroka, Papua New Guinea');
insert into airport values('GKE','Geilenkirchen, Fed. Rep. Of Ge');
insert into airport values('GKH','Gorkha, Nepal');
insert into airport values('GKL','Great Keppel Island, Qld, Aust');
insert into airport values('GKN','Gulkana, Alaska, Usa');
insert into airport values('GKO','Kongo-Boumba, Gabon');
insert into airport values('GLA','Glasgow, Scotland Uk-Gla');
insert into airport values('GLC','Geladi, Ethiopia');
insert into airport values('GLD','Goodland, Kansas, Usa');
insert into airport values('GLF','Golfito, Costa Rica');
insert into airport values('GLG','Glengyle, Qld, Australia');
insert into airport values('GLH','Greenville, Mississippi, Usa');
insert into airport values('GLI','Glen Innes, Nsw, Australia');
insert into airport values('GLK','Galcaio, Somalia');
insert into airport values('GLL','Gol, Norway');
insert into airport values('GLM','Glenormiston, Qld, Australia');
insert into airport values('GLN','Goulimime, Morocco');
insert into airport values('GLO','Gloucester/Cheltenham, England');
insert into airport values('GLP','Gulgubip, Papua New Guinea');
insert into airport values('GLQ','Glennallen, Alaska, Usa');
insert into airport values('GLR','Gaylord, Michigan, Usa');
insert into airport values('GLS','Galveston, Texas, Usa');
insert into airport values('GLT','Gladstone, Qld, Australia');
commit;
insert into airport values('GLV','Golovin, Alaska, Usa');
insert into airport values('GLW','Glasgow, Kentucky, Usa');
insert into airport values('GLX','Galela, Indonesia');
insert into airport values('GLY','Mt. Goldsworthy, Wa, Australia');
insert into airport values('GLZ','Breda, Netherlands');
insert into airport values('GMA','Gemena, Zaire');
insert into airport values('GMB','Gambela, Ethiopia');
insert into airport values('GMC','Guerima, Colombia');
insert into airport values('GME','Gomel, Ussr');
insert into airport values('GMI','Gasmata, Papua New Guinea');
insert into airport values('GMM','Gamboma, Peop. Rep. Of The Con');
insert into airport values('GMN','Greymouth, New Zealand');
insert into airport values('GMR','Gambier Is., French Polynesia');
insert into airport values('GMS','Guimaraes, Ma, Brazil');
insert into airport values('GMT','Granite Mountain, Alaska, Usa');
insert into airport values('GNA','Grodno, Ussr');
insert into airport values('GNB','Grenoble, France');
insert into airport values('GND','Grenada, Windward Islands');
insert into airport values('GNE','Ghent, Belgium');
insert into airport values('GNG','Gooding, Idaho, Usa');
insert into airport values('GNI','Green Island, Taiwan');
insert into airport values('GNM','Guanambi, Ba, Brazil');
insert into airport values('GNN','Ghinnir, Ethiopia');
insert into airport values('GNR','General Roca, Rn, Argentina');
insert into airport values('GNS','Gunungsitoli, Indonesia');
insert into airport values('GNT','Grants, New Mexico, Usa');
insert into airport values('GNU','Goodnews Bay, Alaska, Usa');
insert into airport values('GNV','Gainesville, Florida, Usa');
insert into airport values('GNY','Granby, Colorado, Usa');
insert into airport values('GNZ','Ghanzi, Botswana');
commit;
insert into airport values('GOA','Genoa, Italy');
insert into airport values('GOB','Goba, Ethiopia');
insert into airport values('GOC','Gora, Papua New Guinea');
insert into airport values('GOE','Gonalia, Papua New Guinea');
insert into airport values('GOH','Nuuk, Greenland');
insert into airport values('GOI','Goa, India');
insert into airport values('GOJ','Nizhniy Novgorod, Ussr');
insert into airport values('GOK','Guthrie, Oklahoma, Usa');
insert into airport values('GOL','Gold Beach, Oregon, Usa');
insert into airport values('GOM','Goma, Zaire');
insert into airport values('GON','New London/Groton, Connecticut');
insert into airport values('GOO','Goondiwindi, Qld, Australia');
insert into airport values('GOP','Gorakhpur, India');
insert into airport values('GOQ','Golmud, P. R. China');
insert into airport values('GOR','Gore, Ethiopia');
insert into airport values('GOS','Gosford, Nsw, Australia');
insert into airport values('GOT','Gothenburg, Sweden-Landvetter');
insert into airport values('GOU','Garoua, Republic Of Cameroon');
insert into airport values('GOV','Gove, Nt, Australia');
insert into airport values('GOY','Gal Oya, Sri Lanka');
insert into airport values('GOZ','Gorna Orechovitsa, Bulgaria');
insert into airport values('GPA','Patras, Greece');
insert into airport values('GPB','Guarapuava, Pr, Brazil');
insert into airport values('GPI','Guapi, Colombia');
insert into airport values('GPL','Guapiles, Costa Rica');
insert into airport values('GPN','Garden Point, Nt, Australia');
insert into airport values('GPO','General Pico, Lp, Argentina');
insert into airport values('GPS','Galapagos Islands, Ecuador');
insert into airport values('GPT','Gulfport/Biloxi, Mississippi,');
insert into airport values('GPZ','Grand Rapids, Minnesota, Usa');
commit;
insert into airport values('GQQ','Galion, Ohio, Usa');
insert into airport values('GRA','Gamarra, Colombia');
insert into airport values('GRB','Green Bay, Wisconsin, Usa');
insert into airport values('GRC','Grand Cess, Liberia');
insert into airport values('GRD','Greenwood, South Carolina, Usa');
insert into airport values('GRE','Greenville, Illinois, Usa');
insert into airport values('GRG','Gardez, Dem Rep Of Afghanistan');
insert into airport values('GRH','Garuahi, Papua New Guinea');
insert into airport values('GRI','Grand Island, Nebraska, Usa');
insert into airport values('GRJ','George, South Africa');
insert into airport values('GRL','Garasa, Papua New Guinea');
insert into airport values('GRM','Grand Marais, Minnesota, Usa');
insert into airport values('GRN','Gordon, Nebraska, Usa');
insert into airport values('GRO','Gerona, Spain');
insert into airport values('GRP','Gurupi, To, Brazil');
insert into airport values('GRQ','Groningen, Netherlands');
insert into airport values('GRR','Grand Rapids, Michigan, Usa');
insert into airport values('GRS','Grosseto, Italy');
insert into airport values('GRT','Gujrat, Pakistan');
insert into airport values('GRU','Sao Paulo, Sp, Brazil-Guarulho');
insert into airport values('GRV','Groznyj, Ussr');
insert into airport values('GRW','Graciosa Island, Portugal (Azo');
insert into airport values('GRX','Granada, Spain');
insert into airport values('GRY','Grimsey, Iceland');
insert into airport values('GRZ','Graz, Austria');
insert into airport values('GSA','Long Pasia, Sabah, Malaysia');
insert into airport values('GSC','Gascoyne Junction, Wa, Austral');
insert into airport values('GSE','Gothenburg, Sweden-Saeve');
insert into airport values('GSH','Goshen, Indiana, Usa');
insert into airport values('GSN','Mount Gunson, Sa, Australia');
commit;
insert into airport values('GSO','Greensboro/H.Pt/Win-Sa-P.T. In');
insert into airport values('GSP','Greenville/Spartanburg, Sc, Us');
insert into airport values('GSR','Gardo, Somalia');
insert into airport values('GSS','Sabi Sabi, South Africa');
insert into airport values('GST','Gustavus, Alaska, Usa');
insert into airport values('GSU','Gedaref, Sudan');
insert into airport values('GSY','Grimsby, England Uk');
insert into airport values('GTB','Genting, Malaysia');
insert into airport values('GTC','Green Turtle, Bahamas');
insert into airport values('GTE','Groote Island, Nt, Australia');
insert into airport values('GTF','Great Falls, Montana, Usa');
insert into airport values('GTG','Grantsburg, Wisconsin, Usa');
insert into airport values('GTK','Sungei Tekai, Malaysia');
insert into airport values('GTN','Mount Cook, New Zealan-Glentan');
insert into airport values('GTO','Gorontalo, Indonesia');
insert into airport values('GTR','Columbus/Starkville/West Pt,Ms');
insert into airport values('GTS','Granites, Nt, Australia');
insert into airport values('GTT','Georgetown, Qld, Australia');
insert into airport values('GTW','Zlin, Czechoslovakia');
insert into airport values('GTY','Gettysburg, Pennsylvania, Usa');
insert into airport values('GUA','Guatemala City, Guatemala');
insert into airport values('GUB','Guerrero Negro, Mexico');
insert into airport values('GUC','Gunnison, Colorado, Usa');
insert into airport values('GUD','Goundam, Mali');
insert into airport values('GUE','Guriaso, Papua New Guinea');
insert into airport values('GUF','Gulf Shores, Alabama, Usa');
insert into airport values('GUG','Guari, Papua New Guinea');
insert into airport values('GUH','Gunnedah, Nsw, Australia');
insert into airport values('GUI','Guiria, Venezuela');
insert into airport values('GUJ','Guaratingueta, Sp, Brazil');
commit;
insert into airport values('GUL','Goulburn, Nsw, Australia');
insert into airport values('GUM','Guam, Guam');
insert into airport values('GUO','Gualaco, Honduras');
insert into airport values('GUP','Gallup, New Mexico, Usa');
insert into airport values('GUQ','Guanare, Venezuela');
insert into airport values('GUR','Alotau, Papua New Guinea');
insert into airport values('GUT','Gutersloh, Fed. Rep. Of German');
insert into airport values('GUU','Grundarfjordur, Iceland');
insert into airport values('GUV','Mougulu, Papua New Guinea');
insert into airport values('GUW','Guryev, Ussr');
insert into airport values('GUX','Guna, India');
insert into airport values('GUY','Guymon, Oklahoma, Usa');
insert into airport values('GVA','Geneva, Switzerland');
insert into airport values('GVE','Gordonsville, Virginia, Usa');
insert into airport values('GVI','Green River, Papua New Guinea');
insert into airport values('GVL','Gainesville, Georgia, Usa');
insert into airport values('GVP','Greenvale, Qld, Australia');
insert into airport values('GVR','Governador Valadares, Mg, Braz');
insert into airport values('GVT','Greenville, Texas, Usa');
insert into airport values('GVW','Grandview, Missouri, Usa');
insert into airport values('GVX','Gavle, Sweden');
insert into airport values('GWA','Gwa, Myanmar');
insert into airport values('GWD','Gwadar, Pakistan');
insert into airport values('GWE','Gweru, Zimbabwe');
insert into airport values('GWL','Gwalior, India');
insert into airport values('GWN','Gnarowein, Papua New Guinea');
insert into airport values('GWO','Greenwood, Mississippi, Usa');
insert into airport values('GWT','Westerland, Fed. Rep. Of Germa');
insert into airport values('GWY','Galway, Republic Of Ireland');
insert into airport values('GXF','Seiyun, Yemen, Republic Of');
commit;
insert into airport values('GXG','Negage, Angola');
insert into airport values('GXQ','Coyhaique, Chile');
insert into airport values('GXX','Yagoua, Republic Of Cameroon');
insert into airport values('GXY','Greeley, Colorado, Usa');
insert into airport values('GYA','Guayaramerin, Bolivia');
insert into airport values('GYE','Guayaquil, Ecuador');
insert into airport values('GYI','Gisenyi, Rwanda');
insert into airport values('GYL','Argyle, Wa, Australia');
insert into airport values('GYM','Guaymas, Mexico');
insert into airport values('GYN','Goiania, Go, Brazil');
insert into airport values('GYP','Gympie, Qld, Australia');
insert into airport values('GYR','Goodyear, Arizona, Usa');
insert into airport values('GYY','Gary, Indiana, Usa');
insert into airport values('GZI','Ghazni, Dem Rep Of Afghanistan');
insert into airport values('GZM','Gozo, Malta');
insert into airport values('GZO','Gizo, Solomon Islands');
insert into airport values('GZT','Gaziantep, Turkey');
insert into airport values('HAA','Hasvik, Norway');
insert into airport values('HAB','Hamilton, Alabama, Usa');
insert into airport values('HAC','Hachijo Jima Island, Japan');
insert into airport values('HAD','Halmstad, Sweden');
insert into airport values('HAE','Havasupai, Arizona, Usa');
insert into airport values('HAF','Half Moon, California, Usa');
insert into airport values('HAG','The Hague, Netherlands');
insert into airport values('HAH','Moroni, Comoros-Hahaya');
insert into airport values('HAJ','Hanover, Fed. Rep. Of Germany');
insert into airport values('HAK','Haikou, P. R. China');
insert into airport values('HAL','Halali, Namibia');
insert into airport values('HAM','Hamburg, Fed. Rep. Of Germany');
insert into airport values('HAN','Hanoi, Soc. Rep. Of Viet Nam');
commit;
insert into airport values('HAO','Hamilton, Ohio, Usa');
insert into airport values('HAP','Kontiki Rst Whitsunday, Qld, A');
insert into airport values('HAR','Harrisburg, Pennsylvania, Usa');
insert into airport values('HAS','Hail, Saudi Arabia');
insert into airport values('HAT','Heathlands, Qld, Australia');
insert into airport values('HAU','Haugesund, Norway');
insert into airport values('HAV','Havana, Cuba');
insert into airport values('HAW','Haverfordwest, Wales Uk');
insert into airport values('HAY','Haycock, Alaska, Usa');
insert into airport values('HAZ','Hatzfeldthaven, Papua New Guin');
insert into airport values('HBA','Hobart, Tasmania, Australia');
insert into airport values('HBB','Hobbs, New Mexico, Usa-Industr');
insert into airport values('HBH','Hobart Bay, Alaska, Usa');
insert into airport values('HBN','Phubon, Soc. Rep. Of Viet Nam');
insert into airport values('HBO','Humboldt, Nebraska, Usa');
insert into airport values('HBT','Hafr Albatin, Saudi Arabia');
insert into airport values('HBX','Hubli, India');
insert into airport values('HCA','Big Spring, Texas, Usa');
insert into airport values('HCB','Shoal Cove, Alaska, Usa');
insert into airport values('HCM','Eil, Somalia');
insert into airport values('HCQ','Halls Creek, Wa, Australia');
insert into airport values('HCR','Holy Cross, Alaska, Usa');
insert into airport values('HCW','Cheraw, South Carolina, Usa');
insert into airport values('HDA','Hidden Falls, Alaska, Usa');
insert into airport values('HDB','Heidelberg, Fed. Rep. Of Germa');
insert into airport values('HDD','Hyderabad, Pakistan');
insert into airport values('HDE','Holdrege, Nebraska, Usa');
insert into airport values('HDM','Hamadan, Iran, Islamic Rep. Of');
insert into airport values('HDN','Steamboat Springs, Col-Hayden');
insert into airport values('HDY','Hat Yai, Thailand');
commit;
insert into airport values('HEA','Herat, Dem. Rep. Of Afghanista');
insert into airport values('HEB','Henzada, Myanmar');
insert into airport values('HED','Herendeen, Alaska, Usa');
insert into airport values('HEE','Helena, Arkansas, Usa');
insert into airport values('HEH','Heho, Myanmar');
insert into airport values('HEI','Heide/Buesum, Fed. Rep. Of Ger');
insert into airport values('HEK','Heihe, P. R. China');
insert into airport values('HEL','Helsinki, Finland');
insert into airport values('HEN','Hendon, England Uk');
insert into airport values('HEO','Haelogo, Papua New Guinea');
insert into airport values('HER','Heraklion, Greece');
insert into airport values('HES','Hermiston, Oregon, Usa');
insert into airport values('HET','Hohhot, P. R. China');
insert into airport values('HEZ','Natchez, Mississippi, Usa');
insert into airport values('HFA','Haifa, Israel');
insert into airport values('HFD','Hartford, Connecticut-Brainard');
insert into airport values('HFE','Hefei, P. R. China');
insert into airport values('HFN','Hofn, Iceland');
insert into airport values('HFS','Hagfors, Sweden');
insert into airport values('HFT','Hammerfest, Norway');
insert into airport values('HGA','Hargeisa, Somalia');
insert into airport values('HGD','Hughenden, Qld, Australia');
insert into airport values('HGH','Hangzhou, P. R. China');
insert into airport values('HGL','Helgoland, Fed. Rep. Of German');
insert into airport values('HGN','Mae Hong Son, Thailand');
insert into airport values('HGO','Korhogo, Cote D''Ivoire');
insert into airport values('HGR','Hagerstown, Maryland, Usa');
insert into airport values('HGS','Freetown, Sierra Leone-Hasting');
insert into airport values('HGU','Mt. Hagen, Papua New Guinea');
insert into airport values('HGZ','Hogatza, Alaska, Usa');
commit;
insert into airport values('HHA','Huanghua, P. R. China');
insert into airport values('HHE','Hachinohe, Japan');
insert into airport values('HHH','Hilton Head Island, Sc, Usa');
insert into airport values('HHQ','Hua Hin, Thailand');
insert into airport values('HHR','Hawthorne, California, Usa');
insert into airport values('HHZ','Hikueru, French Polynesia');
insert into airport values('HIB','Hibbing, Minnesota, Usa');
insert into airport values('HID','Horn Island, Qld, Australia');
insert into airport values('HIE','Whitefield, New Hampshire, Usa');
insert into airport values('HIG','Highbury, Qld, Australia');
insert into airport values('HIH','Hook Island, Qld, Australia');
insert into airport values('HII','Lake Havasu City, Arizona, Usa');
insert into airport values('HIJ','Hiroshima, Japan');
insert into airport values('HIN','Chinju, Republic Of Korea');
insert into airport values('HIO','Hillsboro, Oregon, Usa');
insert into airport values('HIP','Headingly, Qld, Australia');
insert into airport values('HIR','Honiara, Guadalcanal, Solomon');
insert into airport values('HIS','Hayman Island, Qld, Australia');
insert into airport values('HIX','Hiva Oa, French Polynesia');
insert into airport values('HJR','Khajuraho, India');
insert into airport values('HJT','Khujirt, Mongolia');
insert into airport values('HKA','Blytheville, Arkansas, Usa');
insert into airport values('HKB','Healy Lake, Alaska, Usa');
insert into airport values('HKD','Hakodate, Japan');
insert into airport values('HKG','Hong Kong, Hong Kong');
insert into airport values('HKK','Hokitika, New Zealand');
insert into airport values('HKN','Hoskins, Papua New Guinea');
insert into airport values('HKS','Jackson, Mississippi-Hawkins');
insert into airport values('HKT','Phuket, Thailand');
insert into airport values('HKV','Haskovo, Bulgaria');
commit;
insert into airport values('HKY','Hickory, North Carolina, Usa');
insert into airport values('HLA','Lanseria, South Africa');
insert into airport values('HLB','Batesville, Indiana, Usa');
insert into airport values('HLC','Hill City, Kansas, Usa');
insert into airport values('HLD','Hailar, P. R. China');
insert into airport values('HLF','Hultsfred, Sweden');
insert into airport values('HLH','Ulanhot, P. R. China');
insert into airport values('HLI','Hollister, California, Usa');
insert into airport values('HLJ','Shauliaj, Ussr');
insert into airport values('HLL','Hillside, Wa, Australia');
insert into airport values('HLM','Holland, Michigan, Usa');
insert into airport values('HLN','Helena, Montana, Usa');
insert into airport values('HLP','Jakarta, Indonesia-Halim');
insert into airport values('HLS','St. Helens, Tasmania, Australi');
insert into airport values('HLT','Hamilton, Vic, Australia');
insert into airport values('HLU','Houailou, New Caledonia');
insert into airport values('HLV','Helenvale, Qld, Australia');
insert into airport values('HLW','Hluhluwe, South Africa');
insert into airport values('HLY','Holyhead, Wales Uk');
insert into airport values('HLZ','Hamilton, New Zealand');
insert into airport values('HMA','Malmo, Sweden-City Hvc');
insert into airport values('HME','Hassi Messaoud, Algeria');
insert into airport values('HMG','Hermannsburg, Nt, Australia');
insert into airport values('HMI','Hami, P. R. China');
insert into airport values('HMJ','Khmelnitskiy, Ussr');
insert into airport values('HMO','Hermosillo, Mexico');
insert into airport values('HMR','Hamar, Norway');
insert into airport values('HMS','Homeshore, Alaska, Usa');
insert into airport values('HMT','Hemet, California, Usa');
insert into airport values('HNA','Morioka, Japan');
commit;
insert into airport values('HNB','Huntingburg, Indiana, Usa');
insert into airport values('HNC','Hatteras, North Carolina, Usa');
insert into airport values('HND','Tokyo, Japan-Haneda');
insert into airport values('HNE','Tahneta Pass Lodge, Alaska, Us');
insert into airport values('HNG','Hienghene, New Caledonia');
insert into airport values('HNH','Hoonah, Alaska, Usa');
insert into airport values('HNI','Heiweni, Papua New Guinea');
insert into airport values('HNK','Hinchinbrook Island, Qld, Aust');
insert into airport values('HNL','Honolulu, Oahu; Hawaii, Usa');
insert into airport values('HNM','Hana, Maui; Hawaii, Usa');
insert into airport values('HNN','Honinabi, Papua New Guinea');
insert into airport values('HNS','Haines, Alaska, Usa');
insert into airport values('HNX','Hanna, Wyoming, Usa');
insert into airport values('HNY','Hengyang, P. R. China');
insert into airport values('HOA','Hola, Kenya');
insert into airport values('HOB','Hobbs, New Mexico, Usa-Lea Cou');
insert into airport values('HOC','Komako, Papua New Guinea');
insert into airport values('HOD','Hodeidah, Yemen, Republic Of');
insert into airport values('HOE','Houeisay, Laos');
insert into airport values('HOF','Hofuf, Saudi Arabia');
insert into airport values('HOG','Holguin, Cuba');
insert into airport values('HOH','Hohenems, Austria');
insert into airport values('HOI','Hao Island, French Polynesia');
insert into airport values('HOK','Hooker Creek, Nt, Australia');
insert into airport values('HOL','Holikachuk, Alaska, Usa');
insert into airport values('HOM','Homer, Alaska, Usa');
insert into airport values('HON','Huron, South Dakota, Usa');
insert into airport values('HOO','Quang Duc, Soc. Rep. Of Viet N');
insert into airport values('HOQ','Hof, Fed. Rep. Of Germany');
insert into airport values('HOR','Horta, Faial Is., Portugal (Az');
commit;
insert into airport values('HOT','Hot Springs, Arkansas, Usa');
insert into airport values('HOU','Houston, Texas, Usa-Hobby');
insert into airport values('HOV','Orsta/Volda, Norway');
insert into airport values('HOX','Homalin, Myanmar');
insert into airport values('HOY','Hoy Island, Scotland Uk');
insert into airport values('HPA','Ha''Apai, Tonga Island, S. Paci');
insert into airport values('HPB','Hooper Bay, Alaska, Usa');
insert into airport values('HPE','Hope Vale, Qld, Australia');
insert into airport values('HPN','Westchester County, New York,');
insert into airport values('HPT','Hampton, Iowa, Usa');
insert into airport values('HPV','Princeville, Kauai; Hawaii, Us');
insert into airport values('HPY','Baytown, Texas, Usa');
insert into airport values('HQM','Hoquiam, Washington, Usa');
insert into airport values('HRA','Mansehra, Pakistan');
insert into airport values('HRB','Harbin, Manchuria, P. R. China');
insert into airport values('HRE','Harare, Zimbabwe');
insert into airport values('HRG','Hurghada, Arab Rep. Of Egypt');
insert into airport values('HRJ','Chaurjhari, Nepal');
insert into airport values('HRK','Kharkov, Ussr');
insert into airport values('HRL','Harlingen, Texas, Usa');
insert into airport values('HRM','Hassi R Mel, Algeria');
insert into airport values('HRN','Heron Island, Qld, Australia');
insert into airport values('HRO','Harrison, Arkansas, Usa');
insert into airport values('HRR','Herrera, Colombia');
insert into airport values('HRS','Harrismith, South Africa');
insert into airport values('HRT','Harrogate, England Uk');
insert into airport values('HRY','Henbury, Nt, Australia');
insert into airport values('HSB','Harrisburg, Illinois, Usa');
insert into airport values('HSC','Shaoguan, P. R. China');
insert into airport values('HSH','Las Vegas, Nevada, Usa-Henders');
commit;
insert into airport values('HSI','Hastings, Nebraska, Usa');
insert into airport values('HSL','Huslia, Alaska, Usa');
insert into airport values('HSM','Horsham, Vic, Australia');
insert into airport values('HSP','Hot Springs, Virginia, Usa');
insert into airport values('HSS','Hissar, India');
insert into airport values('HST','Homestead, Florida, Usa');
insert into airport values('HSV','Huntsville/Decatur, Alabama, U');
insert into airport values('HTA','Chita, Ussr');
insert into airport values('HTB','Terre-De-Bas, Guadeloupe');
insert into airport values('HTF','Hatfield, England Uk');
insert into airport values('HTG','Hatanga, Ussr');
insert into airport values('HTH','Hawthorne, Nevada, Usa');
insert into airport values('HTI','Hamilton Island, Qld, Australi');
insert into airport values('HTN','Hotan, P. R. China');
insert into airport values('HTO','East Hampton, New York, Usa');
insert into airport values('HTR','Hateruma, Japan');
insert into airport values('HTS','Huntington, West Virginia, Usa');
insert into airport values('HTU','Hopetoun, Vic, Australia');
insert into airport values('HTV','Huntsville, Texas, Usa');
insert into airport values('HTZ','Hato Corozal, Colombia');
insert into airport values('HUB','Humbert River, Nt, Australia');
insert into airport values('HUC','Humacao, Puerto Rico');
insert into airport values('HUD','Humboldt, Iowa, Usa');
insert into airport values('HUE','Humera, Ethiopia');
insert into airport values('HUF','Terre Haute, Indiana, Usa');
insert into airport values('HUG','Huehuetenango, Guatemala');
insert into airport values('HUH','Huahine Island, French Polynes');
insert into airport values('HUI','Hue, Soc. Rep. Of Viet Nam');
insert into airport values('HUJ','Hugo, Oklahoma, Usa');
insert into airport values('HUK','Hukuntsi, Botswana');
commit;
insert into airport values('HUL','Houlton, Maine, Usa');
insert into airport values('HUM','Houma, Louisiana, Usa');
insert into airport values('HUN','Hualien, Taiwan');
insert into airport values('HUQ','Houn, Libyan A Jamahiriya');
insert into airport values('HUS','Hughes, Alaska, Usa');
insert into airport values('HUT','Hutchinson, Kansas, Usa');
insert into airport values('HUU','Huanuco, Peru');
insert into airport values('HUV','Hudiksvall, Sweden');
insert into airport values('HUX','Huatulco, Mexico');
insert into airport values('HUY','Humberside, England Uk');
insert into airport values('HVA','Analalava, Dem. Rep. Madagasca');
insert into airport values('HVB','Hervey Bay, Qld, Australia');
insert into airport values('HVD','Khovd, Mongolia');
insert into airport values('HVE','Hanksville, Utah, Usa');
insert into airport values('HVG','Honningsvag, Norway');
insert into airport values('HVK','Holmavik, Iceland');
insert into airport values('HVM','Hvammstangi, Iceland');
insert into airport values('HVN','New Haven, Connecticut, Usa');
insert into airport values('HVR','Havre, Montana, Usa');
insert into airport values('HVS','Hartsville, South Carolina, Us');
insert into airport values('HWA','Hawabango, Papua New Guinea');
insert into airport values('HWD','Hayward, California, Usa');
insert into airport values('HWI','Hawk Inlet, Alaska, Usa');
insert into airport values('HWK','Hawker, Sa, Australia');
insert into airport values('HWN','Hwange National Park, Zimbabwe');
insert into airport values('HXX','Hay, Nsw, Australia');
insert into airport values('HYA','Hyannis, Massachusetts, Usa');
insert into airport values('HYC','High Wycombe, England Uk');
insert into airport values('HYD','Hyderabad, India');
insert into airport values('HYF','Hayfields, Papua New Guinea');
commit;
insert into airport values('HYG','Hydaburg, Alaska, Usa');
insert into airport values('HYL','Hollis, Alaska, Usa');
insert into airport values('HYN','Huangyan, P. R. China');
insert into airport values('HYR','Hayward, Wisconsin, Usa');
insert into airport values('HYS','Hays, Kansas, Usa');
insert into airport values('HZB','Hazebrouck, France');
insert into airport values('HZG','Hanzhong, P. R. China');
insert into airport values('HZK','Husavik, Iceland');
insert into airport values('HZL','Hazleton, Pennsylvania, Usa');
insert into airport values('IAA','Igarka, Ussr');
insert into airport values('IAD','Washington, Dc, Usa-Dulles');
insert into airport values('IAG','Niagara Falls, New York, Usa');
insert into airport values('IAH','Houston, Texas, Usa-Intercont');
insert into airport values('IAM','In Amenas, Algeria');
insert into airport values('IAN','Kiana, Alaska, Usa');
insert into airport values('IAQ','Bahregan, Iran, Islamic Rep. O');
insert into airport values('IAR','Yaroslavl, Ussr');
insert into airport values('IAS','Iasi, Romania');
insert into airport values('IAU','Iaura, Papua New Guinea');
insert into airport values('IBA','Ibadan, Nigeria');
insert into airport values('IBE','Ibague, Colombia');
insert into airport values('IBO','Ibo, Mozambique');
insert into airport values('IBP','Iberia, Peru');
insert into airport values('IBZ','Ibiza, Spain');
insert into airport values('ICA','Icabaru, Venezuela');
insert into airport values('ICI','Cicia, Fiji');
insert into airport values('ICK','Nieuw Nickerie, Rep. Of Surina');
insert into airport values('ICL','Clarinda, Iowa, Usa');
insert into airport values('ICO','Sicogon Island, Philippines');
insert into airport values('ICR','Nicaro, Cuba');
commit;
insert into airport values('ICT','Wichita, Kansas, Usa');
insert into airport values('ICY','Icy Bay, Alaska, Usa');
insert into airport values('IDA','Idaho Falls, Idaho, Usa');
insert into airport values('IDF','Idiofa, Zaire');
insert into airport values('IDG','Ida Grove, Iowa, Usa');
insert into airport values('IDI','Indiana, Pennsylvania, Usa');
insert into airport values('IDK','Indulkana, Sa, Australia');
insert into airport values('IDN','Indagen, Papua New Guinea');
insert into airport values('IDO','Santa Isabel Do Morro, To, Bra');
insert into airport values('IDR','Indore, India');
insert into airport values('IDY','Ile D''Yeu, France');
insert into airport values('IEG','Zielona Gora, Poland');
insert into airport values('IEJ','Iejima, Japan');
insert into airport values('IEV','Kiev, Ussr-Zhulhany');
insert into airport values('IFA','Iowa Falls, Iowa, Usa');
insert into airport values('IFF','Iffley, Qld, Australia');
insert into airport values('IFJ','Isafjordur, Iceland');
insert into airport values('IFL','Innisfail, Qld, Australia');
insert into airport values('IFN','Isfahan, Iran, Islamic Rep. Of');
insert into airport values('IFO','Ivano-Frankovsk, Ussr');
insert into airport values('IGA','Inagua, Bahamas');
insert into airport values('IGB','Ingeniero Jacobacci, Rn, Argen');
insert into airport values('IGE','Iguela, Gabon');
insert into airport values('IGG','Igiugig, Alaska, Usa');
insert into airport values('IGH','Ingham, Qld, Australia');
insert into airport values('IGL','Izmir, Turkey-Cigli');
insert into airport values('IGM','Kingman, Arizona, Usa');
insert into airport values('IGN','Iligan, Philippines');
insert into airport values('IGO','Chigorodo, Colombia');
insert into airport values('IGR','Iguazu, Mi, Argentina');
commit;
insert into airport values('IGU','Iguassu Falls, Pr, Brazil');
insert into airport values('IHA','Niihama, Japan');
insert into airport values('IHN','Qishn, Yemen, Republic Of');
insert into airport values('IHO','Ihosy, Dem. Rep. Madagascar');
insert into airport values('IHU','Ihu, Papua New Guinea');
insert into airport values('IIA','Inishmaan, Republic Of Ireland');
insert into airport values('IIN','Nishinoomote, Japan');
insert into airport values('IIS','Nissan Island, Papua New Guine');
insert into airport values('IJK','Izhevsk, Ussr');
insert into airport values('IJU','Ijui, Rs, Brazil');
insert into airport values('IJX','Jacksonville, Illinois, Usa');
insert into airport values('IKB','Wilkesboro, North Carolina, Us');
insert into airport values('IKI','Iki, Japan');
insert into airport values('IKK','Kankakee, Illinois, Usa');
insert into airport values('IKL','Ikela, Zaire');
insert into airport values('IKO','Nikolski, Alaska, Usa');
insert into airport values('IKP','Inkerman, Qld, Australia');
insert into airport values('IKS','Tiksi, Ussr');
insert into airport values('IKT','Irkutsk, Ussr');
insert into airport values('ILA','Illaga, Indonesia');
insert into airport values('ILE','Killeen, Texas, Usa');
insert into airport values('ILF','Ilford, Manitoba, Canada');
insert into airport values('ILG','Philadelphia Pa/Wilm''T-Grt Wil');
insert into airport values('ILI','Iliamna, Alaska, Usa');
insert into airport values('ILK','Ilaka, Dem. Rep. Madagascar');
insert into airport values('ILL','Willmar, Minnesota, Usa');
insert into airport values('ILM','Wilmington, North Carolina, Us');
insert into airport values('ILN','Wilmington, Ohio, Usa');
insert into airport values('ILO','Iloilo, Philippines');
insert into airport values('ILP','Ile Des Pins, New Caledonia');
commit;
insert into airport values('ILR','Ilorin, Nigeria');
insert into airport values('ILU','Kilaguni, Kenya');
insert into airport values('ILX','Ileg, Papua New Guinea');
insert into airport values('ILY','Islay, Scotland Uk');
insert into airport values('ILZ','Zilina, Czechoslovakia');
insert into airport values('IMA','Iamalele, Papua New Guinea');
insert into airport values('IMB','Imbaimadai, Guyana');
insert into airport values('IMD','Imonda, Papua New Guinea');
insert into airport values('IMF','Imphal, India');
insert into airport values('IMG','Inhaminga, Mozambique');
insert into airport values('IMI','Ine, Marshall Islands');
insert into airport values('IMK','Simikot, Nepal');
insert into airport values('IML','Imperial, Nebraska, Usa');
insert into airport values('IMM','Immokalee, Florida, Usa');
insert into airport values('IMN','Imane, Papua New Guinea');
insert into airport values('IMO','Zemio, Cen. African Republic');
insert into airport values('IMP','Imperatriz, Ma, Brazil');
insert into airport values('IMT','Iron Mountain, Michigan, Usa');
insert into airport values('IMZ','Nimroz, Dem Rep Of Afghanistan');
insert into airport values('INA','Inta, Ussr');
insert into airport values('INB','Independence, Belize');
insert into airport values('INC','Yinchuan, P. R. China');
insert into airport values('IND','Indianapolis, Indiana, Usa');
insert into airport values('INE','Chinde, Mozambique');
insert into airport values('INF','In Guezzam, Algeria');
insert into airport values('ING','Lago Argentino, Sc, Argentina');
insert into airport values('INH','Inhambane, Mozambique');
insert into airport values('INI','Nis, Yugoslavia');
insert into airport values('INJ','Injune, Qld, Australia');
insert into airport values('INK','Wink, Texas, Usa');
commit;
insert into airport values('INL','Intl Falls, Minnesota, Usa');
insert into airport values('INM','Innamincka, Sa, Australia');
insert into airport values('INN','Innsbruck, Austria');
insert into airport values('INO','Inongo, Zaire');
insert into airport values('INQ','Inisheer, Republic Of Ireland');
insert into airport values('INT','Greensboro/H.Pt/Win-Sa-Reynold');
insert into airport values('INU','Nauru, Rep. Of Nauru');
insert into airport values('INV','Inverness, Scotland Uk');
insert into airport values('INW','Winslow, Arizona, Usa');
insert into airport values('INX','Inanwatan, Indonesia');
insert into airport values('INY','Inyati, South Africa');
insert into airport values('INZ','In Salah, Algeria');
insert into airport values('IOA','Ioannina, Greece');
insert into airport values('IOK','Iokea, Papua New Guinea');
insert into airport values('IOM','Isle Of Man, Uk');
insert into airport values('ION','Impfondo, Peop. Rep. Of The Co');
insert into airport values('IOP','Ioma, Papua New Guinea');
insert into airport values('IOR','Inishmore, Republic Of Ireland');
insert into airport values('IOS','Ilheus, Ba, Brazil');
insert into airport values('IOU','Ile Ouen, New Caledonia');
insert into airport values('IPA','Ipota, Vanuatu');
insert into airport values('IPC','Easter Island, Pacific Ocean');
insert into airport values('IPE','Ipil, Philippines');
insert into airport values('IPG','Ipiranga, Am, Brazil');
insert into airport values('IPH','Ipoh, Malaysia');
insert into airport values('IPI','Ipiales, Colombia');
insert into airport values('IPL','El Centro/Imperial, Ca, Usa');
insert into airport values('IPN','Ipatinga, Mg, Brazil');
insert into airport values('IPT','Williamsport, Pennsylvania, Us');
insert into airport values('IPU','Ipiau, Ba, Brazil');
commit;
insert into airport values('IPW','Ipswich, England Uk');
insert into airport values('IQM','Qiemo, P. R. China');
insert into airport values('IQN','Qingyang, P. R. China');
insert into airport values('IQQ','Iquique, Chile');
insert into airport values('IQT','Iquitos, Peru');
insert into airport values('IRA','Kirakira, Solomon Islands');
insert into airport values('IRB','Iraan, Texas, Usa');
insert into airport values('IRC','Circle, Alaska, Usa');
insert into airport values('IRD','Ishurdi, Bangladesh');
insert into airport values('IRE','Irece, Ba, Brazil');
insert into airport values('IRG','Lockhart Rivers, Qld, Australi');
insert into airport values('IRI','Iringa, Tanzania');
insert into airport values('IRJ','La Rioja, Lr, Argentina');
insert into airport values('IRK','Kirksville, Missouri, Usa');
insert into airport values('IRN','Iriona, Honduras');
insert into airport values('IRO','Birao, Cen. African Republic');
insert into airport values('IRP','Isiro, Zaire');
insert into airport values('IRS','Sturgis, Michigan, Usa');
insert into airport values('ISA','Mount Isa, Qld, Australia');
insert into airport values('ISB','Islamabad/Rawalpindi, Pakistan');
insert into airport values('ISC','Isles Of Scilly, Uk-St Marys');
insert into airport values('ISD','Iscuande, Colombia');
insert into airport values('ISG','Ishigaki, Japan');
insert into airport values('ISH','Ischia, Italy');
insert into airport values('ISI','Isisford, Qld, Australia');
insert into airport values('ISJ','Isla Mujeres, Mexico');
insert into airport values('ISK','Nasik, India');
insert into airport values('ISL','Isabel Pass, Alaska, Usa');
insert into airport values('ISM','Kissimmee, Florida, Usa');
insert into airport values('ISN','Williston, North Dakota, Usa');
commit;
insert into airport values('ISO','Kinston, North Carolina, Usa');
insert into airport values('ISP','Long Island Macarthur, Ny, Usa');
insert into airport values('ISS','Wiscasset, Maine, Usa');
insert into airport values('IST','Istanbul, Turkey');
insert into airport values('ISW','Wisconsin Rapids, Wisconsin, U');
insert into airport values('ITA','Itacoatiara, Am, Brazil');
insert into airport values('ITB','Itaituba, Pa, Brazil');
insert into airport values('ITE','Itubera, Ba, Brazil');
insert into airport values('ITH','Ithaca, New York, Usa');
insert into airport values('ITI','Itambacuri, Mg, Brazil');
insert into airport values('ITK','Itokama, Papua New Guinea');
insert into airport values('ITN','Itabuna, Ba, Brazil');
insert into airport values('ITO','Hilo, Hawaii; Hawaii, Usa');
insert into airport values('ITQ','Itaqui, Rs, Brazil');
insert into airport values('IUE','Niue Island, Niue');
insert into airport values('IUL','Ilu, Indonesia');
insert into airport values('IUM','Summit Lake, Bc, Canada');
insert into airport values('IUS','Inus, Papua New Guinea');
insert into airport values('IVA','Ambanja, Dem. Rep. Madagascar');
insert into airport values('IVC','Invercargill, New Zealand');
insert into airport values('IVG','Ivangrad, Yugoslavia');
insert into airport values('IVH','Ivishak, Alaska, Usa');
insert into airport values('IVL','Ivalo, Finland');
insert into airport values('IVO','Chivolo, Colombia');
insert into airport values('IVR','Inverell, Nsw, Australia');
insert into airport values('IVW','Inverway, Nt, Australia');
insert into airport values('IWA','Ivanovo, Ussr');
insert into airport values('IWD','Ironwood, Michigan, Usa');
insert into airport values('IWS','Houston, Texas, Usa-W. Houston');
insert into airport values('IXA','Agartala, India');
commit;
insert into airport values('IXB','Bagdogra, India');
insert into airport values('IXC','Chandigarh, India');
insert into airport values('IXD','Allahabad, India');
insert into airport values('IXE','Mangalore, India');
insert into airport values('IXG','Belgaum, India');
insert into airport values('IXH','Kailashahar, India');
insert into airport values('IXI','Lilabari, India');
insert into airport values('IXJ','Jammu, India');
insert into airport values('IXK','Keshod, India');
insert into airport values('IXL','Leh, India');
insert into airport values('IXM','Madurai, India');
insert into airport values('IXN','Khowai, India');
insert into airport values('IXP','Pathankot, India');
insert into airport values('IXQ','Kamalpur, India');
insert into airport values('IXR','Ranchi, India');
insert into airport values('IXS','Silchar, India');
insert into airport values('IXT','Passighat, India');
insert into airport values('IXU','Aurangabad, India');
insert into airport values('IXV','Along, India');
insert into airport values('IXW','Jamshedpur, India');
insert into airport values('IXY','Kandla, India');
insert into airport values('IXZ','Port Blair, Andaman Island, In');
insert into airport values('IYK','Inyokern, California, Usa');
insert into airport values('IZM','Izmir, Turkey-Cigli');
insert into airport values('IZO','Izumo, Japan');
insert into airport values('IZT','Ixtepec, Mexico');
insert into airport values('JAA','Jalalabad, Dem Rep Of Afghanis');
insert into airport values('JAB','Jabiru, Nt, Australia');
insert into airport values('JAC','Jackson Hole, Wyoming, Usa');
insert into airport values('JAD','Jandakot, Wa, Australia');
commit;
insert into airport values('JAF','Jaffna, Sri Lanka');
insert into airport values('JAG','Jacobabad, Pakistan');
insert into airport values('JAH','Aubagne, France');
insert into airport values('JAI','Jaipur, India');
insert into airport values('JAK','Jacmel, Haiti');
insert into airport values('JAL','Jalapa, Mexico');
insert into airport values('JAM','Jambol, Bulgaria');
insert into airport values('JAN','Jackson, Mississippi-Intl');
insert into airport values('JAO','Atlanta, Georgia, Usa-Beavr Ru');
insert into airport values('JAQ','Jacquinot Bay, Papua New Guine');
insert into airport values('JAR','Arcadia, California, Usa');
insert into airport values('JAS','Jasper, Texas, Usa');
insert into airport values('JAT','Jabat, Marshall Islands');
insert into airport values('JAU','Jauja, Peru');
insert into airport values('JAV','Jakobshavn, Greenland');
insert into airport values('JAX','Jacksonville, Florida-Intl');
insert into airport values('JBC','Boston, Massachusetts-City Hlp');
insert into airport values('JBK','Berkeley, California, Usa');
insert into airport values('JBP','Los Angeles, Californi-Commerc');
insert into airport values('JBR','Jonesboro, Arkansas, Usa');
insert into airport values('JBS','Pleasanton, California, Usa');
insert into airport values('JBT','Bethel, Alaska, Usa-City Land');
insert into airport values('JCA','Cannes, France-Croisette');
insert into airport values('JCB','Joacaba, Sc, Brazil');
insert into airport values('JCD','St. Croix, Virgin Isla-Downtow');
insert into airport values('JCH','Christianshab, Greenland');
insert into airport values('JCI','Kansas City, Missouri-Industri');
insert into airport values('JCK','Julia Creek, Qld, Australia');
insert into airport values('JCM','Jacobina, Ba, Brazil');

commit;
insert into airport values('JCN','Incheon, Republic Of Korea');
insert into airport values('JCO','Comino, Malta');
insert into airport values('JCR','Jacareacanga, Pa, Brazil');
insert into airport values('JCT','Junction, Texas, Usa');
insert into airport values('JCY','Johnson, Texas, Usa');
insert into airport values('JDA','John Day, Oregon, Usa');
insert into airport values('JDB','Dallas/Ft. Worth, Texas-Downtow');
insert into airport values('JDF','Juiz De Fora, Mg, Brazil');
insert into airport values('JDH','Jodhpur, India');
insert into airport values('JDM','Miami, Florida, Usa-Downtown');
insert into airport values('JDN','Jordan, Montana, Usa');
insert into airport values('JDO','Juazeiro Do Norte, Ce, Brazil');
insert into airport values('JDP','Paris, France-De Paris');
insert into airport values('JDX','Houston, Texas, Usa-Cntrl B.D.');
insert into airport values('JDY','Downey, California, Usa');
insert into airport values('JDZ','Jingdezhen, P. R. China');
insert into airport values('JED','Jeddah, Saudi Arabia');
insert into airport values('JEE','Jeremie, Haiti');
insert into airport values('JEG','Egedesminde, Greenland');
insert into airport values('JEJ','Jeh, Marshall Islands');
insert into airport values('JEM','Emeryville, California, Usa');
insert into airport values('JEQ','Jequie, Ba, Brazil');
insert into airport values('JER','Jersey, Channel Islands Uk');
insert into airport values('JEV','Evry, France');
insert into airport values('JFM','Fremantle, Wa, Australia');
insert into airport values('JFN','Jefferson, Ohio, Usa');
insert into airport values('JFR','Frederikshab, Greenland');
insert into airport values('JGA','Jamnagar, India');
insert into airport values('JGB','Jagdalpur, India');
commit;
insert into airport values('JGC','Grand Canyon, Arizona-Hlpt');
insert into airport values('JGE','Geoje, Republic Of Korea');
insert into airport values('JGL','Atlanta, Georgia, Usa-Galleria');
insert into airport values('JGN','Jiayuguan, P. R. China');
insert into airport values('JGO','Godhavn, Greenland');
insert into airport values('JGQ','Houston, Texas, Usa-Transco');
insert into airport values('JGR','Gronnedal/Ivigtut, Greenland');
insert into airport values('JGX','Glendale, California, Usa');
insert into airport values('JHB','Johor Bahru, Malaysia');
insert into airport values('JHC','Garden City, New York, Usa');
insert into airport values('JHE','Helsingborg, Sweden-Hlpt');
insert into airport values('JHG','Jinghong, P. R. China');
insert into airport values('JHM','Kapalua, Maui; Hawaii, Usa');
insert into airport values('JHQ','Shute Harbour, Qld, Australia');
insert into airport values('JHS','Holsteinsborg, Greenland');
insert into airport values('JHW','Jamestown, New York, Usa');
insert into airport values('JHY','Cambridge, Massachusetts, Usa');
insert into airport values('JIA','Juina, Mt, Brazil');
insert into airport values('JIB','Djibouti, Djibouti');
insert into airport values('JID','Los Angeles, Californi-Industr');
insert into airport values('JIL','Jilin, P. R. China');
insert into airport values('JIM','Jimma, Ethiopia');
insert into airport values('JIN','Jinja, Uganda');
insert into airport values('JIP','Jipijapa, Ecuador');
insert into airport values('JIR','Jiri, Nepal');
insert into airport values('JIW','Jiwani, Pakistan');
insert into airport values('JJI','Juanjui, Peru');
insert into airport values('JJN','Jinjiang, P. R. China');
insert into airport values('JJU','Julianehab, Greenland');
insert into airport values('JKG','Jonkoping, Sweden');
commit;
insert into airport values('JKH','Chios, Greece');
insert into airport values('JKR','Janakpur, Nepal');
insert into airport values('JKT','Jakarta, Indonesia-Soekarno');
insert into airport values('JLA','Cooper Lodge, Alaska, Usa');
insert into airport values('JLD','Landskrona, Sweden');
insert into airport values('JLN','Joplin, Missouri, Usa');
insert into airport values('JLO','Jesolo, Italy');
insert into airport values('JLP','Juan Les Pins, France');
insert into airport values('JLR','Jabalpur, India');
insert into airport values('JMB','Jamba, Angola');
insert into airport values('JMC','Sausalito, California, Usa');
insert into airport values('JMH','Schaumburg, Illinois, Usa');
insert into airport values('JMK','Mikonos, Greece');
insert into airport values('JMM','Malmo, Sweden-Harbour');
insert into airport values('JMO','Jomsom, Nepal');
insert into airport values('JMS','Jamestown, North Dakota, Usa');
insert into airport values('JMU','Jiamusi, P. R. China');
insert into airport values('JMY','Freetown, Sierra Leone-Mammy Y');
insert into airport values('JNA','Januaria, Mg, Brazil');
insert into airport values('JNB','Johannesburg, South Africa');
insert into airport values('JNI','Junin, Ba, Argentina');
insert into airport values('JNN','Nanortalik, Greenland');
insert into airport values('JNP','Newport Beach, California, Usa');
insert into airport values('JNS','Narssaq, Greenland');
insert into airport values('JNU','Juneau, Alaska, Usa');
insert into airport values('JOC','Orange County, Califor-Centr H');
insert into airport values('JOE','Joensuu, Finland');
insert into airport values('JOG','Yogyakarta, Indonesia');
insert into airport values('JOH','Port Saint Johns, South Africa');
insert into airport values('JOI','Joinville, Sc, Brazil');
commit;
insert into airport values('JOK','Joshkar-Ola, Ussr');
insert into airport values('JOL','Jolo, Philippines');
insert into airport values('JOM','Njombe, Tanzania');
insert into airport values('JON','Johnston Island, Pacific Ocean');
insert into airport values('JOP','Josephstaal, Papua New Guinea');
insert into airport values('JOR','Disneyland/Orange, California,');
insert into airport values('JOS','Jos, Nigeria');
insert into airport values('JOT','Joliet, Illinois, Usa');
insert into airport values('JPA','Joao Pessoa, Pb, Brazil');
insert into airport values('JPD','Pasadena, California, Usa');
insert into airport values('JPJ','Paterson, New Jersey, Usa');
insert into airport values('JPR','Ji-Parana, Ro, Brazil');
insert into airport values('JPT','Houston, Texas, Usa-Park Ten');
insert into airport values('JPU','Paris, France-La Defense');
insert into airport values('JQE','Jaque, Panama Republic');
insert into airport values('JRA','New York Ny/Newark, Nj-W 30th');
insert into airport values('JRE','New York Ny/Newark, Nj-E 60th');
insert into airport values('JRH','Jorhat, India');
insert into airport values('JRK','Arsuk, Greenland');
insert into airport values('JRN','Juruena, Mt, Brazil');
insert into airport values('JRO','Kilimanjaro, Tanzania');
insert into airport values('JRS','Jerusalem');
insert into airport values('JSA','Jaisalmer, India');
insert into airport values('JSD','Stratford, Connecticut, Usa');
insert into airport values('JSH','Sitia, Greece');
insert into airport values('JSI','Skiathos, Greece');
insert into airport values('JSL','Atlantic City, New Jer-Steel P');
insert into airport values('JSM','Jose De San Martin, Cb, Argent');
insert into airport values('JSO','Sodertalje, Sweden');
insert into airport values('JSR','Jessore, Bangladesh');
commit;
insert into airport values('JSS','Spetsai, Greece');
insert into airport values('JST','Johnstown, Pennsylvania, Usa');
insert into airport values('JSU','Sukkertoppen, Greenland');
insert into airport values('JSY','Syros Island, Greece');
insert into airport values('JSZ','St. Tropez, France');
insert into airport values('JTO','Thousand Oaks, California, Usa');
insert into airport values('JTR','Santorini, Thira Is., Greece');
insert into airport values('JUB','Juba, Sudan');
insert into airport values('JUI','Juist, Fed. Rep. Of Germany');
insert into airport values('JUJ','Jujuy, Pj, Argentina');
insert into airport values('JUL','Juliaca, Peru');
insert into airport values('JUM','Jumla, Nepal');
insert into airport values('JUN','Jundah, Qld, Australia');
insert into airport values('JUO','Jurado, Colombia');
insert into airport values('JUR','Jurien Bay, Wa, Australia');
insert into airport values('JUT','Justicalpa, Honduras');
insert into airport values('JUV','Upernavik, Greenland');
insert into airport values('JVA','Ankavandra, Dem. Rep. Madagasc');
insert into airport values('JVL','Janesville, Wisconsin, Usa');
insert into airport values('JWA','Jwaneng, Botswana');
insert into airport values('JWH','Houston, Texas, Usa-Westchase');
insert into airport values('JXN','Jackson, Michigan, Usa');
insert into airport values('JYV','Jyvaskyla, Finland');
insert into airport values('KAB','Kariba, Zimbabwe');
insert into airport values('KAC','Kameshli, Syria');
insert into airport values('KAD','Kaduna, Nigeria');
insert into airport values('KAE','Kake, Alaska, Usa');
insert into airport values('KAF','Karato, Papua New Guinea');
insert into airport values('KAG','Kangnung, Republic Of Korea');
insert into airport values('KAH','Melbourne, Victoria, A-City Hl');
commit;
insert into airport values('KAI','Kaieteur, Guyana');
insert into airport values('KAJ','Kajaani, Finland');
insert into airport values('KAK','Kar, Papua New Guinea');
insert into airport values('KAL','Kaltag, Alaska, Usa');
insert into airport values('KAM','Kamaran Is., Yemen, Republic O');
insert into airport values('KAN','Kano, Nigeria');
insert into airport values('KAO','Kuusamo, Finland');
insert into airport values('KAP','Kapanga, Zaire');
insert into airport values('KAQ','Kamulai, Papua New Guinea');
insert into airport values('KAR','Kamarang, Guyana');
insert into airport values('KAS','Karasburg, Namibia');
insert into airport values('KAT','Kaitaia, New Zealand');
insert into airport values('KAU','Kauhava, Finland');
insert into airport values('KAV','Kavanayen, Venezuela');
insert into airport values('KAW','Kawthaung, Myanmar');
insert into airport values('KAX','Kalbarri, Wa, Australia');
insert into airport values('KAY','Wakaya Island, Fiji');
insert into airport values('KAZ','Kau, Indonesia');
insert into airport values('KBA','Kabala, Sierra Leone');
insert into airport values('KBB','Kirkimbie, Nt, Australia');
insert into airport values('KBC','Birch Creek, Alaska, Usa');
insert into airport values('KBD','Kimberly Downs, Wa, Australia');
insert into airport values('KBE','Bell Island, Alaska, Usa');
insert into airport values('KBF','Karubaga, Indonesia');
insert into airport values('KBG','Kabalega Falls, Uganda');
insert into airport values('KBH','Kalat, Pakistan');
insert into airport values('KBI','Kribi, Republic Of Cameroon');
insert into airport values('KBK','Klag Bay, Alaska, Usa');
insert into airport values('KBL','Kabul, Dem. Rep. Of Afghanista');
insert into airport values('KBM','Kabwum, Papua New Guinea');
commit;
insert into airport values('KBN','Kabinda, Zaire');
insert into airport values('KBO','Kabalo, Zaire');
insert into airport values('KBP','Kiev, Ussr-Borispol');
insert into airport values('KBR','Kota Bharu, Malaysia');
insert into airport values('KBS','Bo, Sierra Leone');
insert into airport values('KBT','Kaben, Marshall Islands');
insert into airport values('KBW','Chignik, Alaska, Usa-Chignik B');
insert into airport values('KBX','Kambuaya, Indonesia');
insert into airport values('KBY','Streaky Bay, Sa, Australia');
insert into airport values('KCA','Kuqa, P. R. China');
insert into airport values('KCC','Coffman Cove, Alaska, Usa');
insert into airport values('KCE','Collinsville, Qld, Australia');
insert into airport values('KCG','Chignik, Alaska, Usa-Fisheries');
insert into airport values('KCH','Kuching, Sarawak, Malaysia');
insert into airport values('KCK','Kansas City, Kansas, Usa');
insert into airport values('KCL','Chignik, Alaska, Usa-Lagoon');
insert into airport values('KCN','Chernofski, Alaska, Usa');
insert into airport values('KCP','Kamenets-Podolsk, Ussr');
insert into airport values('KCQ','Chignik, Alaska, Usa-Chignik L');
insert into airport values('KCS','Kings Creek Station, Nt, Austr');
insert into airport values('KCU','Masindi, Uganda');
insert into airport values('KCZ','Kochi, Japan');
insert into airport values('KDA','Kolda, Senegal');
insert into airport values('KDB','Kambalda, Wa, Australia');
insert into airport values('KDC','Kandi, Benin');
insert into airport values('KDD','Khuzdar, Pakistan');
insert into airport values('KDE','Koroba, Papua New Guinea');
insert into airport values('KDG','Kardjali, Bulgaria');
insert into airport values('KDH','Kandahar, Dem Rep Of Afghanist');
insert into airport values('KDI','Kendari, Indonesia');
commit;
insert into airport values('KDJ','N Djole, Gabon');
insert into airport values('KDK','Kodiak, Alaska, Usa-Municipal');
insert into airport values('KDN','N''Dende, Gabon');
insert into airport values('KDP','Kandep, Papua New Guinea');
insert into airport values('KDR','Kandrian, Papua New Guinea');
insert into airport values('KDS','Kamaran Downs, Qld, Australia');
insert into airport values('KDU','Skardu, Pakistan');
insert into airport values('KDV','Kandavu, Fiji');
insert into airport values('KEA','Keisah, Indonesia');
insert into airport values('KEB','English Bay, Alaska, Usa');
insert into airport values('KEC','Kasenga, Zaire');
insert into airport values('KED','Kaedi, Mauritania');
insert into airport values('KEE','Kelle, Peop. Rep. Of The Congo');
insert into airport values('KEF','Reykjavik, Iceland-Kflvk Intl');
insert into airport values('KEG','Keglsugl, Papua New Guinea');
insert into airport values('KEH','Seattle/Tacoma, Washin-Kenmore');
insert into airport values('KEI','Kepi, Indonesia');
insert into airport values('KEJ','Kemerovo, Ussr');
insert into airport values('KEK','Ekwok, Alaska, Usa');
insert into airport values('KEL','Kiel, Fed. Rep. Of Germany');
insert into airport values('KEM','Kemi/Tornio, Finland');
insert into airport values('KEN','Kenema, Sierra Leone');
insert into airport values('KEO','Odienne, Cote D''Ivoire');
insert into airport values('KEP','Nepalganj, Nepal');
insert into airport values('KEQ','Kebar, Indonesia');
insert into airport values('KER','Kerman, Iran, Islamic Rep. Of');
insert into airport values('KES','Kelsey, Manitoba, Canada');
insert into airport values('KET','Kengtung, Myanmar');
insert into airport values('KEV','Kuorevesi, Finland');
insert into airport values('KEX','Kanabea, Papua New Guinea');
commit;
insert into airport values('KEY','Kericho, Kenya');
insert into airport values('KFA','Kiffa, Mauritania');
insert into airport values('KFF','Farranfore, Republic Of Irelan');
insert into airport values('KFG','Kalkurung, Nt, Australia');
insert into airport values('KFP','False Pass, Alaska, Usa');
insert into airport values('KGA','Kananga, Zaire');
insert into airport values('KGB','Konge, Papua New Guinea');
insert into airport values('KGC','Kingscote, Sa, Australia');
insert into airport values('KGD','Kaliningrad, Ussr');
insert into airport values('KGF','Karaganda, Ussr');
insert into airport values('KGG','Kedougou, Senegal');
insert into airport values('KGH','Yongai, Papua New Guinea');
insert into airport values('KGI','Kalgoorlie, Wa, Australia');
insert into airport values('KGJ','Karonga, Malawi');
insert into airport values('KGK','Koliganek, Alaska, Usa');
insert into airport values('KGL','Kigali, Rwanda');
insert into airport values('KGN','Kasongo/Lunda, Zaire');
insert into airport values('KGO','Kirovograd, Ussr');
insert into airport values('KGR','Kulgera, Nt, Australia');
insert into airport values('KGS','Kos, Greece');
insert into airport values('KGU','Keningau, Sabah, Malaysia');
insert into airport values('KGW','Kagi, Papua New Guinea');
insert into airport values('KGX','Grayling, Alaska, Usa');
insert into airport values('KGY','Kingaroy, Qld, Australia');
insert into airport values('KGZ','Glacier Creek, Alaska, Usa');
insert into airport values('KHA','Khanek, Iran, Islamic Rep. Of');
insert into airport values('KHC','Kerch, Ussr');
insert into airport values('KHE','Kherson, Ussr');
insert into airport values('KHG','Kashi, P. R. China');
insert into airport values('KHH','Kaohsiung, Taiwan');
commit;
insert into airport values('KHI','Karachi, Pakistan');
insert into airport values('KHJ','Kauhajoki, Finland');
insert into airport values('KHK','Khark, Iran, Islamic Rep. Of');
insert into airport values('KHL','Khulna, Bangladesh');
insert into airport values('KHM','Khamti, Myanmar');
insert into airport values('KHN','Nanchang, Kiangsi, P. R. China');
insert into airport values('KHO','Khoka Moya, South Africa');
insert into airport values('KHR','Kharkhorin, Mongolia');
insert into airport values('KHS','Khasab, Oman');
insert into airport values('KHT','Khost, Dem. Rep. Of Afghanista');
insert into airport values('KHU','Kremenchug, Ussr');
insert into airport values('KHV','Khabarovsk, Ussr');
insert into airport values('KHW','Khwai River Lodge, Botswana');
insert into airport values('KIA','Kaiapit, Papua New Guinea');
insert into airport values('KIB','Ivanoff Bay, Alaska, Usa');
insert into airport values('KIC','King City, California, Usa');
insert into airport values('KID','Kristianstad, Sweden');
insert into airport values('KIE','Kieta, Papua New Guinea');
insert into airport values('KIF','Kingfisher Lake, Ontario, Cana');
insert into airport values('KIG','Koingnaas, South Africa');
insert into airport values('KIH','Kish Island, Iran, Islamic Rep');
insert into airport values('KIJ','Niigata, Japan');
insert into airport values('KIK','Kirkuk, Iraq');
insert into airport values('KIL','Kilwa, Zaire');
insert into airport values('KIM','Kimberley, South Africa');
insert into airport values('KIN','Kingston, Jamaica-Manley');
insert into airport values('KIO','Kili, Marshall Islands');
insert into airport values('KIP','Wichita Falls, Texas-Kickapoo');
insert into airport values('KIQ','Kira, Papua New Guinea');
insert into airport values('KIR','Kerry County, Republic Of Irel');
commit;
insert into airport values('KIS','Kisumu, Kenya');
insert into airport values('KIT','Kithira, Greece');
insert into airport values('KIU','Kiunga, Kenya');
insert into airport values('KIV','Kishinev, Ussr');
insert into airport values('KIW','Kitwe, Zambia');
insert into airport values('KIX','Kansai International Airport, Japan');
insert into airport values('KIY','Kilwa, Tanzania');
insert into airport values('KIZ','Kikinonda, Papua New Guinea');
insert into airport values('KJA','Krasnojarsk, Ussr');
insert into airport values('KJU','Kamiraba, Papua New Guinea');
insert into airport values('KKA','Koyuk, Alaska, Usa');
insert into airport values('KKB','Kitoi, Alaska, Usa');
insert into airport values('KKC','Khon Kaen, Thailand');
insert into airport values('KKD','Kokoda, Papua New Guinea');
insert into airport values('KKE','Kerikeri, New Zealand');
insert into airport values('KKG','Konawaruk, Guyana');
insert into airport values('KKH','Kongiganak, Alaska, Usa');
insert into airport values('KKI','Akiachak, Alaska, Usa');
insert into airport values('KKJ','Kita Kyushu, Japan');
insert into airport values('KKK','Kalakaket Creek, Alaska, Usa');
insert into airport values('KKM','Lop Buri, Thailand');
insert into airport values('KKN','Kirkenes, Norway');
insert into airport values('KKO','Kaikohe, New Zealand');
insert into airport values('KKP','Koolburra, Qld, Australia');
insert into airport values('KKR','Kaukura Atoll, French Polynesi');
insert into airport values('KKT','Kentland, Indiana, Usa');
insert into airport values('KKU','Ekuk, Alaska, Usa');
insert into airport values('KKW','Kikwit, Zaire');
insert into airport values('KKX','Kikaiga Shima, Japan');
insert into airport values('KKY','Kilkenny, Republic Of Ireland');
commit;
insert into airport values('KKZ','Koh Kong, Cambodia');
insert into airport values('KLB','Kalabo, Zambia');
insert into airport values('KLC','Kaolack, Senegal');
insert into airport values('KLE','Kaele, Republic Of Cameroon');
insert into airport values('KLF','Kaluga, Ussr');
insert into airport values('KLG','Kalskag, Alaska, Usa');
insert into airport values('KLH','Kolhapur, India');
insert into airport values('KLI','Kotakoli, Zaire');
insert into airport values('KLJ','Klaipeda, Ussr');
insert into airport values('KLK','Kalokol, Kenya');
insert into airport values('KLL','Levelock, Alaska, Usa');
insert into airport values('KLN','Larsen Bay, Alaska, Usa');
insert into airport values('KLO','Kalibo, Philippines');
insert into airport values('KLP','Kelp Bay, Alaska, Usa');
insert into airport values('KLQ','Keluang, Indonesia');
insert into airport values('KLR','Kalmar, Sweden');
insert into airport values('KLS','Kelso, Washington, Usa');
insert into airport values('KLU','Klagenfurt, Austria');
insert into airport values('KLV','Karlovy Vary, Czechoslovakia');
insert into airport values('KLW','Klawock, Alaska, Usa');
insert into airport values('KLX','Kalamata, Greece');
insert into airport values('KLY','Kalima, Zaire');
insert into airport values('KLZ','Kleinzee, South Africa');
insert into airport values('KMA','Kerema, Papua New Guinea');
insert into airport values('KMB','Koinambe, Papua New Guinea');
insert into airport values('KMC','Mc Cord, Alaska, Usa');
insert into airport values('KMD','Mandji, Gabon');
insert into airport values('KME','Kamembe, Rwanda');
insert into airport values('KMF','Kamina, Papua New Guinea');
insert into airport values('KMG','Kunming, P. R. China');
commit;
insert into airport values('KMH','Kuruman, South Africa');
insert into airport values('KMI','Miyazaki, Japan');
insert into airport values('KMJ','Kumamoto, Japan');
insert into airport values('KMK','Makabana, Peop. Rep. Of The Co');
insert into airport values('KML','Kamileroi, Qld, Australia');
insert into airport values('KMM','Kimam, Indonesia');
insert into airport values('KMN','Kamina, Zaire');
insert into airport values('KMO','Manokotak, Alaska, Usa');
insert into airport values('KMP','Keetmanshoop, Namibia');
insert into airport values('KMQ','Komatsu, Japan');
insert into airport values('KMR','Karimui, Papua New Guinea');
insert into airport values('KMS','Kumasi, Ghana');
insert into airport values('KMT','Kampot, Cambodia');
insert into airport values('KMU','Kismayu, Somalia');
insert into airport values('KMV','Kalemyo, Myanmar');
insert into airport values('KMW','Kostroma, Ussr');
insert into airport values('KMX','Khamis Mushait, Saudi Arabia');
insert into airport values('KMY','Moser Bay, Alaska, Usa');
insert into airport values('KMZ','Kaoma, Zambia');
insert into airport values('KNB','Kanab, Utah, Usa');
insert into airport values('KND','Kindu, Zaire');
insert into airport values('KNE','Kanainj, Papua New Guinea');
insert into airport values('KNG','Kaimana, Indonesia');
insert into airport values('KNH','Kinmen, Taiwan');
insert into airport values('KNI','Katanning, Wa, Australia');
insert into airport values('KNJ','Kindamba, Peop. Rep. Of The Co');
insert into airport values('KNK','Kakhonak, Alaska, Usa');
insert into airport values('KNL','Kelanoa, Papua New Guinea');
insert into airport values('KNM','Kaniama, Zaire');
insert into airport values('KNN','Kankan, Guinea');
commit;
insert into airport values('KNO','Knocke Le-Zoute, Belgium');
insert into airport values('KNP','Capanda, Angola');
insert into airport values('KNQ','Kone, New Caledonia');
insert into airport values('KNS','King Island, Tasmania, Austral');
insert into airport values('KNT','Kennett, Missouri, Usa');
insert into airport values('KNU','Kanpur, India');
insert into airport values('KNW','New Stuyahok, Alaska, Usa');
insert into airport values('KNX','Kununurra, Wa, Australia');
insert into airport values('KNZ','Kenieba, Mali');
insert into airport values('KOA','Kona, Hawaii; Hawaii, Usa');
insert into airport values('KOB','Koutaba, Republic Of Cameroon');
insert into airport values('KOC','Koumac, New Caledonia');
insert into airport values('KOD','Kotabangun, Indonesia');
insert into airport values('KOE','Kupang, Indonesia');
insert into airport values('KOG','Khong, Laos');
insert into airport values('KOH','Koolatah, Qld, Australia');
insert into airport values('KOI','Kirkwall, Orkney Is., Scotland');
insert into airport values('KOJ','Kagoshima, Japan');
insert into airport values('KOK','Kokkola/Pietarsaari, Finland');
insert into airport values('KOL','Koumala, Cen. African Republic');
insert into airport values('KOM','Komo-Manda, Papua New Guinea');
insert into airport values('KON','Kontum, Soc. Rep. Of Viet Nam');
insert into airport values('KOO','Kongolo, Zaire');
insert into airport values('KOP','Nakhon Phanom, Thailand');
insert into airport values('KOR','Kokoro, Papua New Guinea');
insert into airport values('KOS','Kompong Som, Cambodia');
insert into airport values('KOT','Kotlik, Alaska, Usa');
insert into airport values('KOU','Koulamoutou, Gabon');
insert into airport values('KOV','Kokchetav, Ussr');
insert into airport values('KOW','Ganzhou, P. R. China');
commit;
insert into airport values('KOX','Kokonao, Indonesia');
insert into airport values('KOY','Olga Bay, Alaska, Usa');
insert into airport values('KOZ','Ouzinkie, Alaska, Usa');
insert into airport values('KPA','Kopiago, Papua New Guinea');
insert into airport values('KPB','Point Baker, Alaska, Usa');
insert into airport values('KPC','Port Clarence, Alaska, Usa');
insert into airport values('KPD','King Of Prussia, Pennsylvania,');
insert into airport values('KPE','Yapsiei, Papua New Guinea');
insert into airport values('KPG','Kurupung, Guyana');
insert into airport values('KPH','Pauloff Harbor, Alaska, Usa');
insert into airport values('KPI','Kapit, Sarawak, Malaysia');
insert into airport values('KPK','Parks, Alaska, Usa');
insert into airport values('KPM','Kompiam, Papua New Guinea');
insert into airport values('KPN','Kipnuk, Alaska, Usa');
insert into airport values('KPO','Pohang, Republic Of Korea');
insert into airport values('KPP','Kalpowar, Qld, Australia');
insert into airport values('KPR','Port Williams, Alaska, Usa');
insert into airport values('KPS','Kempsey, Nsw, Australia');
insert into airport values('KPT','Jackpot, Nevada, Usa');
insert into airport values('KPV','Perryville, Alaska, Usa');
insert into airport values('KPY','Port Bailey, Alaska, Usa');
insert into airport values('KQA','Akutan, Alaska, Usa');
insert into airport values('KQL','Kol, Papua New Guinea');
insert into airport values('KRA','Kerang, Vic, Australia');
insert into airport values('KRB','Karumba, Qld, Australia');
insert into airport values('KRC','Kerinci, Indonesia');
insert into airport values('KRD','Kurundi, Nt, Australia');
insert into airport values('KRE','Kirundo, Burundi');
insert into airport values('KRF','Kramfors, Sweden');
insert into airport values('KRG','Karasabai, Guyana');
commit;
insert into airport values('KRI','Kikori, Papua New Guinea');
insert into airport values('KRJ','Karawari, Papua New Guinea');
insert into airport values('KRK','Krakow, Poland');
insert into airport values('KRL','Korla, P. R. China');
insert into airport values('KRM','Karanambo, Guyana');
insert into airport values('KRN','Kiruna, Sweden');
insert into airport values('KRO','Kurgan, Ussr');
insert into airport values('KRP','Karup, Denmark');
insert into airport values('KRQ','Kramatorsk, Ussr');
insert into airport values('KRR','Krasnodar, Ussr');
insert into airport values('KRS','Kristiansand, Norway');
insert into airport values('KRT','Khartoum, Sudan');
insert into airport values('KRU','Kerau, Papua New Guinea');
insert into airport values('KRV','Kerio Valley, Kenya');
insert into airport values('KRW','Krasnowodsk, Ussr');
insert into airport values('KRX','Kar Kar, Papua New Guinea');
insert into airport values('KRY','Karamay, P. R. China');
insert into airport values('KRZ','Kiri, Zaire');
insert into airport values('KSA','Kosrae, Caroline Is., Pacific');
insert into airport values('KSB','Kasanombe, Papua New Guinea');
insert into airport values('KSC','Kosice, Czechoslovakia');
insert into airport values('KSD','Karlstad, Sweden');
insert into airport values('KSE','Kasese, Uganda');
insert into airport values('KSF','Kassel, Fed. Rep. Of Germany');
insert into airport values('KSG','Kisengan, Papua New Guinea');
insert into airport values('KSH','Bakhtaran, Iran, Islamic Rep.');
insert into airport values('KSI','Kissidougou, Guinea');
insert into airport values('KSJ','Kasos Island, Greece');
insert into airport values('KSK','Karlskoga, Sweden');
insert into airport values('KSL','Kassala, Sudan');
commit;
insert into airport values('KSM','St. Mary''S, Alaska, Usa');
insert into airport values('KSN','Kustanay, Ussr');
insert into airport values('KSO','Kastoria, Greece');
insert into airport values('KSP','Kosipe, Papua New Guinea');
insert into airport values('KSQ','Karshi, Ussr');
insert into airport values('KSS','Sikasso, Mali');
insert into airport values('KST','Kosti, Sudan');
insert into airport values('KSU','Kristiansund, Norway');
insert into airport values('KSV','Springvale, Qld, Australia');
insert into airport values('KSX','Yasuru, Papua New Guinea');
insert into airport values('KSY','Kars, Turkey');
insert into airport values('KSZ','Kotlas, Ussr');
insert into airport values('KTA','Karratha, Wa, Australia');
insert into airport values('KTB','Thorne Bay, Alaska, Usa');
insert into airport values('KTC','Katiola, Cote D''Ivoire');
insert into airport values('KTD','Kita-Daito, Japan');
insert into airport values('KTE','Kerteh, Malaysia');
insert into airport values('KTF','Takaka, New Zealand');
insert into airport values('KTG','Ketapang, Indonesia');
insert into airport values('KTH','Tikchik, Alaska, Usa');
insert into airport values('KTI','Kratie, Cambodia');
insert into airport values('KTK','Kanua, Papua New Guinea');
insert into airport values('KTL','Kitale, Kenya');
insert into airport values('KTM','Kathmandu, Nepal');
insert into airport values('KTN','Ketchikan, Alaska, Usa-Ktn');
insert into airport values('KTO','Kato, Guyana');
insert into airport values('KTP','Kingston, Jamaica-Tinson');
insert into airport values('KTR','Katherine, Nt, Australia');
insert into airport values('KTS','Brevig Mission, Alaska, Usa');
insert into airport values('KTT','Kittila, Finland');
commit;
insert into airport values('KTU','Kota, India');
insert into airport values('KTV','Kamarata, Venezuela');
insert into airport values('KTW','Katowice, Poland');
insert into airport values('KTX','Koutiala, Mali');
insert into airport values('KTY','Terror Bay, Alaska, Usa');
insert into airport values('KUA','Kuantan, Malaysia');
insert into airport values('KUC','Kuria, Rep. Of Kiribati');
insert into airport values('KUD','Kudat, Sabah, Malaysia');
insert into airport values('KUE','Kukundu, Solomon Islands');
insert into airport values('KUF','Samara, Ussr');
insert into airport values('KUG','Kubin Island, Qld, Australia');
insert into airport values('KUH','Kushiro, Japan');
insert into airport values('KUI','Kawau Island, New Zealand');
insert into airport values('KUJ','Kushimoto-Katsuura, Japan');
insert into airport values('KUK','Kasigluk, Alaska, Usa');
insert into airport values('KUL','Kuala Lumpur, Malaysia');
insert into airport values('KUM','Yaku Shima, Japan');
insert into airport values('KUN','Kaunas, Ussr');
insert into airport values('KUO','Kuopio, Finland');
insert into airport values('KUP','Kupiano, Papua New Guinea');
insert into airport values('KUQ','Kuri, Papua New Guinea');
insert into airport values('KUR','Kuran O Munjan, Dem Rep Afghan');
insert into airport values('KUS','Kulusuk, Greenland');
insert into airport values('KUT','Kutaisi, Ussr');
insert into airport values('KUU','Kulu, India');
insert into airport values('KUV','Kunsan, Republic Of Korea');
insert into airport values('KUW','Kamusi, Papua New Guinea');
insert into airport values('KUY','Uyak, Alaska, Usa');
insert into airport values('KVA','Kavala, Greece');
insert into airport values('KVB','Skovde, Sweden');
commit;
insert into airport values('KVC','King Cove, Alaska, Usa');
insert into airport values('KVD','Kirovobad, Ussr');
insert into airport values('KVG','Kavieng, Papua New Guinea');
insert into airport values('KVK','Kirovsk, Ussr');
insert into airport values('KVL','Kivalina, Alaska, Usa');
insert into airport values('KVU','Korolevu, Fiji');
insert into airport values('KVX','Kirov, Ussr');
insert into airport values('KWA','Kwajalein, Marshall Islands');
insert into airport values('KWE','Guiyang, P. R. China');
insert into airport values('KWF','Waterfall, Alaska, Usa');
insert into airport values('KWG','Krivoy Rog, Ussr');
insert into airport values('KWH','Khwahan, Dem. Rep. Of Afghanis');
insert into airport values('KWI','Kuwait, Kuwait');
insert into airport values('KWJ','Kwangju, Republic Of Korea');
insert into airport values('KWK','Kwigillingok, Alaska, Usa');
insert into airport values('KWL','Guilin, P. R. China');
insert into airport values('KWM','Kowanyama, Qld, Australia');
insert into airport values('KWN','Quinhagak, Alaska, Usa');
insert into airport values('KWO','Kawito, Papua New Guinea');
insert into airport values('KWP','West Point, Alaska, Usa');
insert into airport values('KWR','Kwai Harbour, Solomon Islands');
insert into airport values('KWT','Kwethluk, Alaska, Usa');
insert into airport values('KWV','Kurwina, Papua New Guinea');
insert into airport values('KWX','Kiwai Island, Papua New Guinea');
insert into airport values('KWY','Kiwayu, Kenya');
insert into airport values('KWZ','Kolwezi, Zaire');
insert into airport values('KXA','Kasaan, Alaska, Usa');
insert into airport values('KXE','Klerksdorp, South Africa');
insert into airport values('KXF','Koro, Fiji');
insert into airport values('KXK','Komsomolxk Na Amure, Ussr');
commit;
insert into airport values('KXR','Karoola, Papua New Guinea');
insert into airport values('KYA','Konya, Turkey');
insert into airport values('KYD','Orchid Island, Taiwan');
insert into airport values('KYE','Tripoli, Lebanon');
insert into airport values('KYF','Yeelirrie, Wa, Australia');
insert into airport values('KYI','Yalata Mission, Sa, Australia');
insert into airport values('KYK','Karluk, Alaska, Usa');
insert into airport values('KYL','Key Largo, Florida, Usa');
insert into airport values('KYP','Kyaukpyu, Myanmar');
insert into airport values('KYS','Kayes, Mali');
insert into airport values('KYT','Kyauktaw, Myanmar');
insert into airport values('KYU','Koyukuk, Alaska, Usa');
insert into airport values('KYX','Yalumet, Papua New Guinea');
insert into airport values('KYZ','Kyzyl, Ussr');
insert into airport values('KZB','Zachar Bay, Alaska, Usa');
insert into airport values('KZC','Kompong-Chhnang, Cambodia');
insert into airport values('KZD','Krakor, Cambodia');
insert into airport values('KZF','Kaintiba, Papua New Guinea');
insert into airport values('KZH','Kizhuyak, Alaska, Usa');
insert into airport values('KZI','Kozani, Greece');
insert into airport values('KZK','Kompong Thom, Cambodia');
insert into airport values('KZN','Kazan, Ussr');
insert into airport values('KZS','Kastelorizo, Greece');
insert into airport values('LAA','Lamar, Colorado, Usa');
insert into airport values('LAB','Lablab, Papua New Guinea');
insert into airport values('LAD','Luanda, Angola');
insert into airport values('LAE','Lae, Papua New Guinea');
insert into airport values('LAF','Lafayette, Indiana, Usa');
insert into airport values('LAG','La Guaira, Venezuela');
insert into airport values('LAH','Labuha, Indonesia');
commit;
insert into airport values('LAI','Lannion, France');
insert into airport values('LAJ','Lages, Sc, Brazil');
insert into airport values('LAK','Aklavik, Nwt, Canada');
insert into airport values('LAL','Lakeland, Florida, Usa');
insert into airport values('LAM','Los Alamos, New Mexico, Usa');
insert into airport values('LAN','Lansing, Michigan, Usa');
insert into airport values('LAO','Laoag, Philippines');
insert into airport values('LAP','La Paz, Mexico');
insert into airport values('LAQ','Beida, Libyan A Jamahiriya');
insert into airport values('LAR','Laramie, Wyoming, Usa');
insert into airport values('LAS','Las Vegas, Nevada, Usa-Mccarra');
insert into airport values('LAU','Lamu, Kenya');
insert into airport values('LAV','Lalomalava, West Samoa');
insert into airport values('LAW','Lawton, Oklahoma, Usa');
insert into airport values('LAX','Los Angeles, Californi-Intl');
insert into airport values('LAY','Ladysmith, South Africa');
insert into airport values('LAZ','Bom Jesus Da Lapa, Ba, Brazil');
insert into airport values('LBA','Leeds/Bradford, England Uk');
insert into airport values('LBB','Lubbock, Texas, Usa');
insert into airport values('LBC','Luebeck, Fed. Rep. Of Germany');
insert into airport values('LBD','Leninabad, Ussr');
insert into airport values('LBE','Latrobe, Pennsylvania, Usa');
insert into airport values('LBF','North Platte, Nebraska, Usa');
insert into airport values('LBG','Paris, France-Le Bourget');
insert into airport values('LBH','Sydney, Nsw, Australia-Palm Be');
insert into airport values('LBI','Albi, France');
insert into airport values('LBJ','Labuan Bajo, Indonesia');
insert into airport values('LBK','Liboi, Kenya');
insert into airport values('LBL','Liberal, Kansas, Usa');
insert into airport values('LBM','Luabo, Mozambique');
commit;
insert into airport values('LBN','Lake Baringo, Kenya');
insert into airport values('LBO','Lusambo, Zaire');
insert into airport values('LBQ','Lambarene, Gabon');
insert into airport values('LBR','Labrea, Am, Brazil');
insert into airport values('LBS','Labasa, Fiji');
insert into airport values('LBT','Lumberton, North Carolina, Usa');
insert into airport values('LBU','Labuan, Sabah, Malaysia');
insert into airport values('LBV','Libreville, Gabon');
insert into airport values('LBW','Longbawan, Indonesia');
insert into airport values('LBX','Lubang, Philippines');
insert into airport values('LBY','La Baule, France');
insert into airport values('LCA','Larnaca, Cyprus');
insert into airport values('LCC','Lecce, Italy');
insert into airport values('LCD','Louis Trichardt, South Africa');
insert into airport values('LCE','La Ceiba, Honduras');
insert into airport values('LCG','La Coruna, Spain');
insert into airport values('LCH','Lake Charles, Louisiana, Usa');
insert into airport values('LCI','Laconia, New Hampshire, Usa');
insert into airport values('LCK','Columbus, Ohio, Usa-Ricknbackr');
insert into airport values('LCL','La Coloma, Cuba');
insert into airport values('LCM','La Cumbre, Cd, Argentina');
insert into airport values('LCN','Balcanoona, Sa, Australia');
insert into airport values('LCO','Lague, Peop. Rep. Of The Congo');
insert into airport values('LCR','La Chorrera, Colombia');
insert into airport values('LCS','Las Canas, Costa Rica');
insert into airport values('LCV','Lucca, Italy');
insert into airport values('LCY','London, England Uk-City');
insert into airport values('LDA','Malda, India');
insert into airport values('LDB','Londrina, Pr, Brazil');
insert into airport values('LDC','Lindeman Island, Qld, Australi');
commit;
insert into airport values('LDE','Lourdes/Tarbes, France');
insert into airport values('LDH','Lord Howe Island, Nsw, Austral');
insert into airport values('LDI','Lindi, Tanzania');
insert into airport values('LDJ','Linden, New Jersey, Usa');
insert into airport values('LDK','Lidkoping, Sweden');
insert into airport values('LDN','Lamidanda, Nepal');
insert into airport values('LDO','Ladouanie, Republic Of Surinam');
insert into airport values('LDR','Lawdar, Yemen, Republic Of');
insert into airport values('LDU','Lahad Datu, Sabah, Malaysia');
insert into airport values('LDW','Lansdowne, Wa, Australia');
insert into airport values('LDX','Saint-Laurent Du Maroni, Fr. G');
insert into airport values('LDY','Londonderry, N. Ireland Uk');
insert into airport values('LDZ','Londolozi, South Africa');
insert into airport values('LEA','Learmonth, Wa, Australia');
insert into airport values('LEB','Lebanon, New Hampshire, Usa');
insert into airport values('LED','St. Petersburg, Ussr');
insert into airport values('LEE','Leesburg, Florida, Usa');
insert into airport values('LEF','Lebakeng, Lesotho');
insert into airport values('LEG','Aleg, Mauritania');
insert into airport values('LEH','Le Havre, France');
insert into airport values('LEI','Almeria, Spain');
insert into airport values('LEJ','Leipzig, Fed. Rep. Of Germany');
insert into airport values('LEK','Labe, Guinea');
insert into airport values('LEL','Lake Evella, Nt, Australia');
insert into airport values('LEM','Lemmon, South Dakota, Usa');
insert into airport values('LEO','Leconi, Gabon');
insert into airport values('LEP','Leopoldina, Mg, Brazil');
insert into airport values('LEQ','Lands End, England Uk');
insert into airport values('LER','Leinster, Wa, Australia');
insert into airport values('LES','Lesobeng, Lesotho');
commit;
insert into airport values('LET','Leticia, Colombia');
insert into airport values('LEU','Seo De Urgel, Spain');
insert into airport values('LEV','Bureta, Fiji');
insert into airport values('LEW','Lewiston, Maine, Usa');
insert into airport values('LEX','Lexington, Kentucky, Usa');
insert into airport values('LEZ','La Esperanza, Honduras');
insert into airport values('LFK','Lufkin/Nacogdoches, Texas, Usa');
insert into airport values('LFN','Louisburg, North Carolina, Usa');
insert into airport values('LFO','Kelafo, Ethiopia');
insert into airport values('LFP','Lakefield, Qld, Australia');
insert into airport values('LFR','La Fria, Venezuela');
insert into airport values('LFT','Lafayette, Louisiana, Usa');
insert into airport values('LFW','Lome, Togo');
insert into airport values('LGA','New York Ny/Newark, Nj-La Guar');
insert into airport values('LGB','Long Beach, California, Usa');
insert into airport values('LGC','La Grange, Georgia, Usa');
insert into airport values('LGD','La Grande, Oregon, Usa');
insert into airport values('LGG','Liege, Belgium');
insert into airport values('LGH','Leigh Creek, Sa, Australia');
insert into airport values('LGI','Deadman''S Cay, Long Island, Ba');
insert into airport values('LGK','Langkawi, Malaysia');
insert into airport values('LGL','Long Lellang, Sarawak, Malaysi');
insert into airport values('LGM','Laiagam, Papua New Guinea');
insert into airport values('LGN','Linga Linga, Papua New Guinea');
insert into airport values('LGO','Langeoog, Fed. Rep. Of Germany');
insert into airport values('LGP','Legaspi, Philippines');
insert into airport values('LGQ','Lago Agrio, Ecuador');
insert into airport values('LGR','Cochrane, Chile');
insert into airport values('LGS','Malargue, Md, Argentina');
insert into airport values('LGT','Las Gaviotas, Colombia');
commit;
insert into airport values('LGU','Logan, Utah, Usa');
insert into airport values('LGW','London, England Uk-Gatwick');
insert into airport values('LGX','Lugh Ganane, Somalia');
insert into airport values('LGY','Lagunillas, Venezuela');
insert into airport values('LGZ','Leguizamo, Colombia');
insert into airport values('LHA','Lahr, Fed. Rep. Of Germany');
insert into airport values('LHB','Lost Harbor, Alaska, Usa');
insert into airport values('LHE','Lahore, Pakistan');
insert into airport values('LHG','Lightning Ridge, Nsw, Australi');
insert into airport values('LHI','Lereh, Indonesia');
insert into airport values('LHK','Guanghua, P. R. China');
insert into airport values('LHN','Lishan, Taiwan');
insert into airport values('LHP','Lehu, Papua New Guinea');
insert into airport values('LHR','London, England Uk-Heathrow');
insert into airport values('LHS','Las Heras, Sc, Argentina');
insert into airport values('LHV','Lock Haven, Pennsylvania, Usa');
insert into airport values('LHW','Lanzhou, P. R. China-Lhw');
insert into airport values('LIA','Liangping, P. R. China');
insert into airport values('LIB','Limbunya, Nt, Australia');
insert into airport values('LIC','Limon, Colorado, Usa');
insert into airport values('LID','Leiden, Netherlands');
insert into airport values('LIE','Libenge, Zaire');
insert into airport values('LIF','Lifou, Loyalty Is., Pacific Oc');
insert into airport values('LIG','Limoges, France');
insert into airport values('LIH','Lihue, Kauai; Hawaii, Usa');
insert into airport values('LII','Mulia, Indonesia');
insert into airport values('LIJ','Long Island, Alaska, Usa');
insert into airport values('LIK','Likiep, Marshall Islands');
insert into airport values('LIL','Lille, France');
insert into airport values('LIM','Lima, Peru');
commit;
insert into airport values('LIN','Milan, Italy-Linate');
insert into airport values('LIO','Limon, Costa Rica');
insert into airport values('LIP','Lins, Sp, Brazil');
insert into airport values('LIQ','Lisala, Zaire');
insert into airport values('LIR','Liberia, Costa Rica');
insert into airport values('LIS','Lisbon, Portugal');
insert into airport values('LIT','Little Rock, Arkansas, Usa');
insert into airport values('LIV','Livengood, Alaska, Usa');
insert into airport values('LIW','Loikaw, Myanmar');
insert into airport values('LJA','Lodja, Zaire');
insert into airport values('LJN','Lake Jackson, Texas, Usa');
insert into airport values('LJU','Ljubljana, Yugoslavia');
insert into airport values('LKA','Larantuka, Indonesia');
insert into airport values('LKB','Lakeba, Fiji');
insert into airport values('LKC','Lekana, Peop. Rep. Of The Cong');
insert into airport values('LKD','Lakeland Downs, Qld, Australia');
insert into airport values('LKE','Seattle/Tacoma, Washin-Lake Un');
insert into airport values('LKK','Kulik Lake, Alaska, Usa');
insert into airport values('LKL','Lakselv, Norway');
insert into airport values('LKN','Leknes, Norway');
insert into airport values('LKO','Lucknow, India');
insert into airport values('LKR','Las Korei, Somalia');
insert into airport values('LKS','Lakeside, Texas, Usa');
insert into airport values('LKT','Lakota, Cote D''Ivoire');
insert into airport values('LKU','Lake Rudolf, Kenya');
insert into airport values('LKV','Lakeview, Oregon, Usa');
insert into airport values('LKY','Lake Manyara, Tanzania');
insert into airport values('LLA','Lulea, Sweden');
insert into airport values('LLE','Malelane, South Africa');
insert into airport values('LLG','Chillagoe, Qld, Australia');
commit;
insert into airport values('LLH','Las Limas, Honduras');
insert into airport values('LLI','Lalibela, Ethiopia');
insert into airport values('LLL','Lissadel, Wa, Australia');
insert into airport values('LLM','Long Lama, Malaysia');
insert into airport values('LLN','Kelila, Indonesia');
insert into airport values('LLP','Linda Downs, Qld, Australia');
insert into airport values('LLS','Las Lomitas, Fo, Argentina');
insert into airport values('LLW','Lilongwe, Malawi');
insert into airport values('LLX','Lyndonville, Vermont, Usa');
insert into airport values('LLY','Mount Holly, New Jersey, Usa');
insert into airport values('LMA','Lake Minchumina, Alaska, Usa');
insert into airport values('LMB','Salima, Malawi');
insert into airport values('LMC','Lamacarena, Colombia');
insert into airport values('LMD','Los Menucos, Rn, Argentina');
insert into airport values('LME','Le Mans, France');
insert into airport values('LMG','Lamassa, Papua New Guinea');
insert into airport values('LMH','Limon, Honduras');
insert into airport values('LMI','Lumi, Papua New Guinea');
insert into airport values('LML','Lae, Marshall Islands');
insert into airport values('LMM','Los Mochis, Mexico');
insert into airport values('LMN','Limbang, Sarawak, Malaysia');
insert into airport values('LMP','Lampedusa, Italy');
insert into airport values('LMQ','Marsa El Brega, Libyan A Jamah');
insert into airport values('LMR','Lime Acres, South Africa');
insert into airport values('LMS','Louisville, Mississippi, Usa');
insert into airport values('LMT','Klamath Falls, Oregon, Usa');
insert into airport values('LMX','Lopez De Micay, Colombia');
insert into airport values('LMY','Lake Murray, Papua New Guinea');
insert into airport values('LMZ','Palma, Mozambique');
insert into airport values('LNB','Lamen Bay, Vanuatu');
commit;
insert into airport values('LNC','Lengbati, Papua New Guinea');
insert into airport values('LND','Lander, Wyoming, Usa');
insert into airport values('LNE','Lonorore, Vanuatu');
insert into airport values('LNF','Munbil, Papua New Guinea');
insert into airport values('LNG','Lese, Papua New Guinea');
insert into airport values('LNH','Lake Nash, Nt, Australia');
insert into airport values('LNI','Lonely, Alaska, Usa');
insert into airport values('LNK','Lincoln, Nebraska, Usa');
insert into airport values('LNM','Langimar, Papua New Guinea');
insert into airport values('LNN','Willoughby, Ohio, Usa');
insert into airport values('LNO','Leonora, Wa, Australia');
insert into airport values('LNP','Wise, Virginia, Usa');
insert into airport values('LNQ','Loani, Papua New Guinea');
insert into airport values('LNR','Lone Rock, Wisconsin, Usa');
insert into airport values('LNS','Lancaster, Pennsylvania, Usa');
insert into airport values('LNV','Londolovit, Papua New Guinea');
insert into airport values('LNX','Smolensk, Ussr');
insert into airport values('LNY','Lanai City, Lanai; Hawaii, Usa');
insert into airport values('LNZ','Linz, Austria');
insert into airport values('LOA','Lorraine, Qld, Australia');
insert into airport values('LOC','Lock, Sa, Australia');
insert into airport values('LOD','Longana, Vanuatu');
insert into airport values('LOE','Loei, Thailand');
insert into airport values('LOF','Loen, Marshall Islands');
insert into airport values('LOG','Longview, Washington, Usa');
insert into airport values('LOH','Loja, Ecuador');
insert into airport values('LOK','Lodwar, Kenya');
insert into airport values('LOL','Lovelock, Nevada, Usa');
insert into airport values('LON','London, England Uk-Heathrow');
insert into airport values('LOO','Laghouat, Algeria');
commit;
insert into airport values('LOQ','Lobatse, Botswana');
insert into airport values('LOS','Lagos, Nigeria');
insert into airport values('LOT','Lockport, Illinois, Usa');
insert into airport values('LOV','Monclova, Mexico');
insert into airport values('LOY','Loyangalani, Kenya');
insert into airport values('LOZ','London, Kentucky, Usa');
insert into airport values('LPA','Gran Canaria, Canary Islands');
insert into airport values('LPB','La Paz, Bolivia');
insert into airport values('LPC','Lompoc, California, Usa');
insert into airport values('LPD','La Pedrera, Colombia');
insert into airport values('LPE','La Primavera, Colombia');
insert into airport values('LPG','La Plata, Ba, Argentina');
insert into airport values('LPH','Lochgilphead, Scotland Uk');
insert into airport values('LPI','Linkoping, Sweden');
insert into airport values('LPJ','Pijiguaos, Venezuela');
insert into airport values('LPK','Lipetsk, Ussr');
insert into airport values('LPL','Liverpool, England Uk');
insert into airport values('LPM','Lamap, Vanuatu');
insert into airport values('LPO','La Porte, Indiana, Usa');
insert into airport values('LPP','Lappeenranta, Finland');
insert into airport values('LPQ','Luang Prabang, Laos');
insert into airport values('LPS','Lopez Island, Washington, Usa');
insert into airport values('LPT','Lampang, Thailand');
insert into airport values('LPU','Longapung, Indonesia');
insert into airport values('LPW','Little Port Walter, Alaska, Us');
insert into airport values('LPX','Liepaya, Ussr');
insert into airport values('LPY','Le Puy, France');
insert into airport values('LQK','Pickens, South Carolina, Usa');
insert into airport values('LQM','Puerto Leguizamo, Colombia');
insert into airport values('LQN','Qala Nau, Dem. Rep. Of Afghani');
commit;
insert into airport values('LRA','Larisa, Greece');
insert into airport values('LRB','Leribe, Lesotho');
insert into airport values('LRD','Laredo, Texas, Usa');
insert into airport values('LRE','Longreach, Qld, Australia');
insert into airport values('LRG','Lora Lai, Pakistan');
insert into airport values('LRH','La Rochelle, France');
insert into airport values('LRI','Lorica, Colombia');
insert into airport values('LRJ','Lemars, Iowa, Usa');
insert into airport values('LRL','Lama-Kara, Togo');
insert into airport values('LRM','La Romana, Dominican Rep.');
insert into airport values('LRQ','Laurie River, Manitoba, Canada');
insert into airport values('LRS','Leros, Greece');
insert into airport values('LRT','Lorient, France');
insert into airport values('LRU','Las Cruces, New Mexico, Usa');
insert into airport values('LRV','Los Roques, Venezuela');
insert into airport values('LSA','Losuia, Papua New Guinea');
insert into airport values('LSB','Lordsburg, New Mexico, Usa');
insert into airport values('LSC','La Serena, Chile');
insert into airport values('LSE','La Crosse Wi/Winona, Mn, Usa');
insert into airport values('LSH','Lashio, Myanmar');
insert into airport values('LSI','Shetland Islands, Scot-Sumburg');
insert into airport values('LSJ','Long Island, Papua New Guinea');
insert into airport values('LSL','Los Chiles, Costa Rica');
insert into airport values('LSM','Long Semado, Sarawak, Malaysia');
insert into airport values('LSN','Los Banos, California, Usa');
insert into airport values('LSO','Les Sables, France');
insert into airport values('LSP','Las Piedras, Venezuela');
insert into airport values('LSQ','Los Angeles, Chile');
insert into airport values('LSR','Lost River, Alaska, Usa');
insert into airport values('LSS','Terre De Haut, Guadeloupe');
commit;
insert into airport values('LST','Launceston, Tasmania, Australi');
insert into airport values('LSU','Long Sukang, Sarawak, Malaysia');
insert into airport values('LSW','Lhokseumawe, Indonesia');
insert into airport values('LSX','Lhok Sukon, Indonesia');
insert into airport values('LSY','Lismore, Nsw, Australia');
insert into airport values('LSZ','Mali Losinj, Yugoslavia');
insert into airport values('LTA','Tzaneen, South Africa');
insert into airport values('LTB','Latrobe, Tasmania, Australia');
insert into airport values('LTC','Lai, Chad');
insert into airport values('LTD','Ghadames, Libyan A Jamahiriya');
insert into airport values('LTF','Leitre, Papua New Guinea');
insert into airport values('LTH','Lathrop Wells, Nevada, Usa');
insert into airport values('LTI','Altai, Mongolia');
insert into airport values('LTK','Latakia, Syria');
insert into airport values('LTL','Lastourville, Gabon');
insert into airport values('LTM','Lethem, Guyana');
insert into airport values('LTN','London, England Uk-Luton Intl');
insert into airport values('LTO','Loreto, Mexico');
insert into airport values('LTP','Lyndhurst, Qld, Australia');
insert into airport values('LTQ','Le Touquet, France');
insert into airport values('LTR','Letterkenny, Republic Of Irela');
insert into airport values('LTS','Altus, Oklahoma, Usa');
insert into airport values('LTV','Lotus Vale, Qld, Australia');
insert into airport values('LTW','Patuxent/Leonardtown, Maryland');
insert into airport values('LUA','Lukla, Nepal');
insert into airport values('LUB','Lumid Pau, Guyana');
insert into airport values('LUC','Laucala Island, Fiji');
insert into airport values('LUD','Luderitz, Namibia');
insert into airport values('LUE','Lucenec, Czechoslovakia');
insert into airport values('LUG','Lugano, Switzerland');
commit;
insert into airport values('LUH','Ludhiana, India');
insert into airport values('LUI','La Union, Honduras');
insert into airport values('LUJ','Lusikisiki, South Africa');
insert into airport values('LUK','Cincinnati, Ohio, Usa-Lunken F');
insert into airport values('LUM','Luxi, P. R. China');
insert into airport values('LUN','Lusaka, Zambia');
insert into airport values('LUO','Luena, Angola');
insert into airport values('LUP','Kalaupapa, Molokai; Hawaii, Us');
insert into airport values('LUQ','San Luis, Sl, Argentina');
insert into airport values('LUR','Cape Lisburne, Alaska, Usa');
insert into airport values('LUS','Lusanga, Zaire');
insert into airport values('LUT','Laura Station, Qld, Australia');
insert into airport values('LUU','Laura, Qld, Australia');
insert into airport values('LUV','Langgur, Indonesia');
insert into airport values('LUW','Luwuk, Indonesia');
insert into airport values('LUX','Luxembourg, Luxembourg');
insert into airport values('LUY','Lushoto, Tanzania');
insert into airport values('LUZ','Lushan, P. R. China');
insert into airport values('LVA','Laval, France');
insert into airport values('LVB','Livramento, Rs, Brazil');
insert into airport values('LVD','Lime Village, Alaska, Usa');
insert into airport values('LVI','Livingstone, Zambia');
insert into airport values('LVK','Livermore, California, Usa');
insert into airport values('LVL','Lawrenceville, Virginia, Usa');
insert into airport values('LVM','Livingston, Montana, Usa');
insert into airport values('LVO','Laverton, Wa, Australia');
insert into airport values('LVP','Lavan, Iran, Islamic Rep. Of');
insert into airport values('LVS','Las Vegas, New Mexico, Usa');
insert into airport values('LWB','Greenbrier, West Virginia, Usa');
insert into airport values('LWC','Lawrence, Kansas, Usa');
commit;
insert into airport values('LWE','Lewoleba, Indonesia');
insert into airport values('LWH','Lawn Hill, Qld, Australia');
insert into airport values('LWI','Lowai, Papua New Guinea');
insert into airport values('LWK','Shetland Islands, Scot-Lerwick');
insert into airport values('LWL','Wells, Nevada, Usa');
insert into airport values('LWM','Lawrence, Massachusetts, Usa');
insert into airport values('LWN','Leninakan, Ussr');
insert into airport values('LWO','Lvov, Ussr');
insert into airport values('LWR','Leeuwarden, Netherlands');
insert into airport values('LWS','Lewiston, Idaho, Usa');
insert into airport values('LWT','Lewistown, Montana, Usa');
insert into airport values('LWV','Lawrenceville, Illinois, Usa');
insert into airport values('LWY','Lawas, Sarawak, Malaysia');
insert into airport values('LXA','Lhasa, P. R. China');
insert into airport values('LXG','Luang Namtha, Laos');
insert into airport values('LXN','Lexington, Nebraska, Usa');
insert into airport values('LXR','Luxor, Arab Rep. Of Egypt');
insert into airport values('LXS','Lemnos, Greece');
insert into airport values('LXU','Lukulu, Zambia');
insert into airport values('LXV','Leadville, Colorado, Usa');
insert into airport values('LYA','Luoyang, P. R. China');
insert into airport values('LYB','Little Cayman, West Indies');
insert into airport values('LYC','Lycksele, Sweden');
insert into airport values('LYG','Lianyungang, P. R. China');
insert into airport values('LYH','Lynchburg, Virginia, Usa');
insert into airport values('LYK','Lunyuk, Indonesia');
insert into airport values('LYP','Faisalabad, Pakistan');
insert into airport values('LYR','Longyearbyen, Norway');
insert into airport values('LYS','Lyon, France');
insert into airport values('LYT','Lady Elliot Island, Qld, Austr');
commit;
insert into airport values('LYU','Ely, Minnesota, Usa');
insert into airport values('LYX','Lydd, Kent, England Uk');
insert into airport values('LZA','Luiza, Zaire');
insert into airport values('LZC','Lazaro Cardenas, Mexico');
insert into airport values('LZD','Lanzhou, P. R. China-Lanzhoudo');
insert into airport values('LZH','Liuzhou, P. R. China');
insert into airport values('LZI','Luozi, Zaire');
insert into airport values('LZO','Luzhou, P. R. China');

insert into airport values('LZR','Lizard Island, Qld, Australia');
insert into airport values('MAA','Madras, India');
insert into airport values('MAB','Maraba, Pa, Brazil');
insert into airport values('MAD','Madrid, Spain');
insert into airport values('MAF','Midland/Odessa, Texas, Usa');
insert into airport values('MAG','Madang, Papua New Guinea');
insert into airport values('MAH','Menorca, Spain');
insert into airport values('MAI','Mangochi, Malawi');
insert into airport values('MAJ','Majuro, Marshall Islands');
insert into airport values('MAK','Malakal, Sudan');
insert into airport values('MAL','Mangole, Indonesia');
insert into airport values('MAM','Matamoros, Mexico');
insert into airport values('MAN','Manchester, England Uk');
insert into airport values('MAO','Manaus, Am, Brazil');
insert into airport values('MAP','Mamai, Papua New Guinea');
insert into airport values('MAQ','Mae Sot, Thailand');
insert into airport values('MAR','Maracaibo, Venezuela');
insert into airport values('MAS','Manus Island, Papua New Guinea');
insert into airport values('MAT','Matadi, Zaire');
insert into airport values('MAU','Maupiti, French Polynesia');
insert into airport values('MAV','Maloelap, Marshall Islands');
commit;
insert into airport values('MAW','Malden, Missouri, Usa');
insert into airport values('MAX','Matam, Senegal');
insert into airport values('MAY','Mangrove Cay, Bahamas');
insert into airport values('MAZ','Mayaguez, Puerto Rico');
insert into airport values('MBA','Mombasa, Kenya');
insert into airport values('MBB','Marble Bar, Wa, Australia');
insert into airport values('MBC','M''Bigou, Gabon');
insert into airport values('MBD','Mmabatho, South Africa');
insert into airport values('MBE','Monbetsu, Japan');
insert into airport values('MBH','Maryborough, Qld, Australia');
insert into airport values('MBI','Mbeya, Tanzania');
insert into airport values('MBJ','Montego Bay, Jamaica');
insert into airport values('MBK','Matupa, Mt, Brazil');
insert into airport values('MBL','Manistee, Michigan, Usa');
insert into airport values('MBM','Mkambati, South Africa');
insert into airport values('MBN','Mt. Barnett, Wa, Australia');
insert into airport values('MBO','Mamburao, Philippines');
insert into airport values('MBP','Moyobamba, Peru');
insert into airport values('MBQ','Mbarara, Uganda');
insert into airport values('MBR','Mbout, Mauritania');
insert into airport values('MBS','Saginaw, Michigan, Usa');
insert into airport values('MBT','Masbate, Philippines');
insert into airport values('MBU','Mbambanakira, Solomon Islands');
insert into airport values('MBV','Masa, Papua New Guinea');
insert into airport values('MBW','Moorabbin, Vic, Australia');
insert into airport values('MBX','Maribor, Yugoslavia');
insert into airport values('MBY','Moberly, Missouri, Usa');
insert into airport values('MBZ','Maues, Am, Brazil');
insert into airport values('MCA','Macenta, Guinea');
insert into airport values('MCB','Mc Comb, Mississippi, Usa');
commit;
insert into airport values('MCE','Merced, California, Usa');
insert into airport values('MCG','Mc Grath, Alaska, Usa');
insert into airport values('MCH','Machala, Ecuador');
insert into airport values('MCI','Kansas City, Missouri-Intl');
insert into airport values('MCJ','Maicao, Colombia');
insert into airport values('MCK','Mc Cook, Nebraska, Usa');
insert into airport values('MCL','Mount Mckinley, Alaska, Usa');
insert into airport values('MCM','Monte Carlo, Monaco');
insert into airport values('MCN','Macon, Georgia, Usa');
insert into airport values('MCO','Orlando, Florida, Usa-Intl');
insert into airport values('MCP','Macapa, Ap, Brazil');
insert into airport values('MCQ','Miskolc, Hungary');
insert into airport values('MCR','Melchor De Mencos, Guatemala');
insert into airport values('MCS','Monte Caseros, Cr, Argentina');
insert into airport values('MCT','Muscat, Oman');
insert into airport values('MCU','Montlucon, France');
insert into airport values('MCV','Mac Arthur River, Nt, Australi');
insert into airport values('MCW','Mason City, Iowa, Usa');
insert into airport values('MCX','Makhachkala, Ussr');
insert into airport values('MCY','Maroochydore, Qld, Australia');
insert into airport values('MCZ','Maceio, Al, Brazil');
insert into airport values('MDB','Melinda, Belize');
insert into airport values('MDC','Manado, Indonesia');
insert into airport values('MDE','Medellin, Colombia');
insert into airport values('MDF','Medford, Wisconsin, Usa');
insert into airport values('MDG','Mudanjiang, P. R. China');
insert into airport values('MDH','Carbondale, Illinois, Usa');
insert into airport values('MDI','Makurdi, Nigeria');
insert into airport values('MDJ','Madras, Oregon, Usa');
insert into airport values('MDK','Mbandaka, Zaire');
commit;
insert into airport values('MDL','Mandalay, Myanmar');
insert into airport values('MDM','Munduku, Papua New Guinea');
insert into airport values('MDN','Madison, Indiana, Usa');
insert into airport values('MDO','Middleton Is., Alaska, Usa');
insert into airport values('MDP','Mindiptana, Indonesia');
insert into airport values('MDQ','Mar Del Plata, Ba, Argentina');
insert into airport values('MDR','Medfra, Alaska, Usa');
insert into airport values('MDS','Middle Caicos, Turks & Caicos');
insert into airport values('MDT','Harrisburg, Pennsylvania, Usa');
insert into airport values('MDU','Mendi, Papua New Guinea');
insert into airport values('MDV','Medouneu, Gabon');
insert into airport values('MDW','Chicago, Illinois, Usa-Midway');
insert into airport values('MDX','Mercedes, Cr, Argentina');
insert into airport values('MDY','Midway Island, Pacific Ocean');
insert into airport values('MDZ','Mendoza, Md, Argentina');
insert into airport values('MEA','Macae, Rj, Brazil');
insert into airport values('MEB','Melbourne, Victoria, A-Essendo');
insert into airport values('MEC','Manta, Ecuador');
insert into airport values('MED','Madinah, Saudi Arabia');
insert into airport values('MEE','Mare, Loyalty Is., Pacific Oce');
insert into airport values('MEF','Melfi, Chad');
insert into airport values('MEG','Malange, Angola');
insert into airport values('MEH','Mehamn, Norway');
insert into airport values('MEI','Meridian, Mississippi, Usa');
insert into airport values('MEJ','Meadville, Pennsylvania, Usa');
insert into airport values('MEK','Meknes, Morocco');
insert into airport values('MEL','Melbourne, Victoria, A-Tulamar');
insert into airport values('MEM','Memphis, Tennessee, Usa');
insert into airport values('MEN','Mende, France');
insert into airport values('MEO','Manteo, North Carolina, Usa');
commit;
insert into airport values('MEP','Mersing, Malaysia');
insert into airport values('MES','Medan, Indonesia');
insert into airport values('MET','Moreton, Qld, Australia');
insert into airport values('MEU','Monte Dourado, Pa, Brazil');
insert into airport values('MEV','Minden, Nevada, Usa');
insert into airport values('MEW','Mweka, Zaire');
insert into airport values('MEX','Mexico City, Mexico-Juarez');
insert into airport values('MEY','Meghauli, Nepal');
insert into airport values('MEZ','Messina, South Africa');
insert into airport values('MFA','Mafia Island, Tanzania');
insert into airport values('MFB','Monfort, Colombia');
insert into airport values('MFC','Mafeteng, Lesotho');
insert into airport values('MFD','Mansfield, Ohio, Usa');
insert into airport values('MFE','Mc Allen, Texas, Usa');
insert into airport values('MFF','Moanda, Gabon');
insert into airport values('MFG','Muzaffarabad, Pakistan');
insert into airport values('MFI','Marshfield, Wisconsin, Usa');
insert into airport values('MFJ','Moala, Fiji');
insert into airport values('MFL','Mt. Full Stop, Qld, Australia');
insert into airport values('MFM','Macau Intl Airport, Macau');
insert into airport values('MFN','Milford Sound, New Zealand');
insert into airport values('MFO','Ras Nasrani, Arab Rep. Of Egyp');
insert into airport values('MFP','Manners Creek, Nt, Australia');
insert into airport values('MFQ','Maradi, Niger');
insert into airport values('MFR','Medford, Oregon, Usa');
insert into airport values('MFS','Miraflores, Colombia');
insert into airport values('MFU','Mfuwe, Zambia');
insert into airport values('MFY','Mayfa''Ah, Yemen, Republic Of');
insert into airport values('MGA','Managua, Nicaragua');
insert into airport values('MGB','Mt. Gambier, Sa, Australia');
commit;
insert into airport values('MGC','Michigan City, Indiana, Usa');
insert into airport values('MGD','Magdalena, Bolivia');
insert into airport values('MGF','Maringa, Pr, Brazil');
insert into airport values('MGG','Margarima, Papua New Guinea');
insert into airport values('MGH','Margate, South Africa');
insert into airport values('MGJ','Montgomery, New York, Usa');
insert into airport values('MGL','Moenchengladbach, Fed Rep Germ');
insert into airport values('MGM','Montgomery, Alabama, Usa');
insert into airport values('MGN','Magangue, Colombia');
insert into airport values('MGO','Manega, Gabon');
insert into airport values('MGP','Manga, Papua New Guinea');
insert into airport values('MGQ','Mogadishu, Somalia');
insert into airport values('MGR','Moultrie/Thomasville, Georgia,');
insert into airport values('MGS','Mangaia, Cook Is., S. Pacific');
insert into airport values('MGT','Millingimbi, Nt, Australia');
insert into airport values('MGV','Margaret River, Wa, Australia');
insert into airport values('MGW','Morgantown, West Virginia, Usa');
insert into airport values('MGX','Moabi, Gabon');
insert into airport values('MGY','Dayton, Ohio, Usa-Montgomery');
insert into airport values('MGZ','Myeik, Myanmar');
insert into airport values('MHA','Mahdia, Guyana');
insert into airport values('MHB','Auckland, New Zealand-Mechanic');
insert into airport values('MHD','Mashad, Iran, Islamic Rep. Of');
insert into airport values('MHE','Mitchell, South Dakota, Usa');
insert into airport values('MHF','Morichal, Colombia');
insert into airport values('MHG','Mannheim, Fed. Rep. Of Germany');
insert into airport values('MHH','Marsh Harbour, Bahamas');
insert into airport values('MHI','Musha, Djibouti');
insert into airport values('MHK','Manhattan, Kansas, Usa');
insert into airport values('MHN','Mullen, Nebraska, Usa');
commit;
insert into airport values('MHO','Mt. House, Wa, Australia');
insert into airport values('MHQ','Mariehamn, Aland Is., Finland');
insert into airport values('MHS','Mount Shasta, California, Usa');
insert into airport values('MHT','Manchester, New Hampshire, Usa');
insert into airport values('MHU','Mount Hotham, Vic, Australia');
insert into airport values('MHV','Mojave, California, Usa');
insert into airport values('MHX','Manihiki Island, Cook Is, S. P');
insert into airport values('MHY','Morehead, Papua New Guinea');
insert into airport values('MIA','Miami, Florida, Usa-Intl');
insert into airport values('MID','Merida, Mexico');
insert into airport values('MIE','Muncie, Indiana, Usa');
insert into airport values('MIF','Monahans, Texas, Usa');
insert into airport values('MIH','Mitchell Plateau, Wa, Australi');
insert into airport values('MII','Marilia, Sp, Brazil');
insert into airport values('MIJ','Mili, Marshall Islands');
insert into airport values('MIK','Mikkeli, Finland');
insert into airport values('MIL','Milan, Italy-Malpensa');
insert into airport values('MIM','Merimbula, Nsw, Australia');
insert into airport values('MIN','Minnipa, Sa, Australia');
insert into airport values('MIP','Mitspeh Ramon, Israel');
insert into airport values('MIQ','Omaha, Nebraska, Usa-Millard');
insert into airport values('MIR','Monastir, Tunisia');
insert into airport values('MIS','Misima, Papua New Guinea');
insert into airport values('MIT','Shafter, California, Usa');
insert into airport values('MIU','Maiduguri, Nigeria');
insert into airport values('MIV','Millville, New Jersey, Usa');
insert into airport values('MIW','Marshalltown, Iowa, Usa');
insert into airport values('MIX','Miriti, Colombia');
insert into airport values('MIZ','Mainoru, Nt, Australia');
insert into airport values('MJA','Manja, Dem. Rep. Madagascar');
commit;
insert into airport values('MJB','Megit Island, Marshall Islands');
insert into airport values('MJC','Man, Cote D''Ivoire');
insert into airport values('MJD','Mohenjo Daro, Pakistan');
insert into airport values('MJE','Majkin, Marshall Islands');
insert into airport values('MJF','Mosjoen, Norway');
insert into airport values('MJG','Mayajigua, Cuba');
insert into airport values('MJH','Majma, Saudi Arabia');
insert into airport values('MJJ','Moki, Papua New Guinea');
insert into airport values('MJL','Mouila, Gabon');
insert into airport values('MJM','Mbuji-Mayi, Zaire');
insert into airport values('MJN','Majunga, Dem. Rep. Madagascar');
insert into airport values('MJP','Manjimup, Wa, Australia');
insert into airport values('MJQ','Jackson, Minnesota, Usa');
insert into airport values('MJT','Mytilene, Greece');
insert into airport values('MJU','Mamuju, Indonesia');
insert into airport values('MJV','Murcia, Spain');
insert into airport values('MJX','Toms River, New Jersey, Usa');
insert into airport values('MJY','Mangunjaya, Indonesia');
insert into airport values('MJZ','Mirnyj, Ussr');
insert into airport values('MKA','Marianske Lazne, Czechoslovaki');
insert into airport values('MKB','Mekambo, Gabon');
insert into airport values('MKC','Kansas City, Missouri-Downtown');
insert into airport values('MKD','Chagni, Ethiopia');
insert into airport values('MKE','Milwaukee, Wisconsin, Usa');
insert into airport values('MKG','Muskegon, Michigan, Usa');
insert into airport values('MKH','Mokhotlong, Lesotho');
insert into airport values('MKI','M''Boki, Cen. African Republic');
insert into airport values('MKJ','Makoua, Peop. Rep. Of The Cong');
insert into airport values('MKK','Molokai/Hoolehua, Hawaii, Usa');
insert into airport values('MKL','Jackson, Tennessee, Usa');
commit;
insert into airport values('MKM','Mukah, Sarawak, Malaysia');
insert into airport values('MKN','Malekolon, Papua New Guinea');
insert into airport values('MKO','Muskogee, Oklahoma, Usa');
insert into airport values('MKP','Makemo, French Polynesia');
insert into airport values('MKQ','Merauke, Indonesia');
insert into airport values('MKR','Meekatharra, Wa, Australia');
insert into airport values('MKS','Mekane Selam, Ethiopia');
insert into airport values('MKT','Mankato, Minnesota, Usa');
insert into airport values('MKU','Makokou, Gabon');
insert into airport values('MKV','Mt. Cavenagh, Nt, Australia');
insert into airport values('MKW','Manokwari, Indonesia');
insert into airport values('MKX','Mukalla, Yemen, Republic Of');
insert into airport values('MKY','Mackay, Qld, Australia');
insert into airport values('MKZ','Malacca, Malaysia');
insert into airport values('MLA','Malta, Mediterranean Sea');
insert into airport values('MLB','Melbourne, Florida, Usa');
insert into airport values('MLC','Mc Alester, Oklahoma, Usa');
insert into airport values('MLD','Malad City, Idaho, Usa');
insert into airport values('MLE','Male, Maldives');
insert into airport values('MLF','Milford, Utah, Usa');
insert into airport values('MLG','Malang, Indonesia');
insert into airport values('MLH','Mulhouse/Basel, France');
insert into airport values('MLI','Moline, Illinois, Usa');
insert into airport values('MLJ','Milledgeville, Georgia, Usa');
insert into airport values('MLK','Malta, Montana, Usa');
insert into airport values('MLL','Marshall, Alaska, Usa');
insert into airport values('MLM','Morelia, Mexico');
insert into airport values('MLN','Melilla, Spain');
insert into airport values('MLO','Milos, Greece');
insert into airport values('MLP','Malabang, Philippines');
commit;
insert into airport values('MLQ','Malalaua, Papua New Guinea');
insert into airport values('MLR','Millicent, Sa, Australia');
insert into airport values('MLS','Miles City, Montana, Usa');
insert into airport values('MLT','Millinocket, Maine, Usa');
insert into airport values('MLU','Monroe, Louisiana, Usa');
insert into airport values('MLV','Merluna, Qld, Australia');
insert into airport values('MLW','Monrovia, Liberia-Payne');
insert into airport values('MLX','Malatya, Turkey');
insert into airport values('MLY','Manley Hot Spgs., Alaska, Usa');
insert into airport values('MLZ','Melo, Uruguay');
insert into airport values('MMA','Malmo, Sweden-Sturup');
insert into airport values('MMB','Memanbetsu, Japan');
insert into airport values('MMC','Ciudad Mante, Mexico');
insert into airport values('MMD','Minami Daito Jima, Okinawa Is,');
insert into airport values('MME','Teesside, England Uk');
insert into airport values('MMF','Mamfe, Republic Of Cameroon');
insert into airport values('MMG','Mount Magnet, Wa, Australia');
insert into airport values('MMH','Mammoth Lakes, California, Usa');
insert into airport values('MMI','Athens, Tennessee, Usa');
insert into airport values('MMJ','Matsumoto, Japan');
insert into airport values('MMK','Murmansk, Ussr');
insert into airport values('MML','Marshall, Minnesota, Usa');
insert into airport values('MMM','Middlemount, Qld, Australia');
insert into airport values('MMN','Stow, Massachusetts, Usa');
insert into airport values('MMO','Maio, Cape Verde Islands');
insert into airport values('MMP','Mompos, Colombia');
insert into airport values('MMQ','Mbala, Zambia');
insert into airport values('MMU','Morristown, New Jersey, Usa');
insert into airport values('MMW','Moma, Mozambique');
insert into airport values('MMX','Malmo, Sweden-Sturup');
commit;
insert into airport values('MMY','Miyako Jima, Japan');
insert into airport values('MMZ','Maimana, Dem. Rep. Of Afghanis');
insert into airport values('MNA','Melanguane, Indonesia');
insert into airport values('MNB','Moanda, Zaire');
insert into airport values('MNC','Nacala, Mozambique');
insert into airport values('MND','Medina, Colombia');
insert into airport values('MNE','Mungaranie, Sa, Australia');
insert into airport values('MNF','Mana, Fiji');
insert into airport values('MNG','Maningrida, Nt, Australia');
insert into airport values('MNH','Minneriya, Sri Lanka');
insert into airport values('MNI','Montserrat, Montserrat');
insert into airport values('MNJ','Mananjary, Dem. Rep. Madagasca');
insert into airport values('MNK','Maiana, Rep. Of Kiribati');
insert into airport values('MNL','Manila, Philippines');
insert into airport values('MNM','Menominee, Michigan, Usa');
insert into airport values('MNN','Marion, Ohio, Usa');
insert into airport values('MNO','Manono, Zaire');
insert into airport values('MNQ','Monto, Qld, Australia');
insert into airport values('MNR','Mongu, Zambia');
insert into airport values('MNS','Mansa, Zambia');
insert into airport values('MNT','Minto, Alaska, Usa');
insert into airport values('MNU','Maulmyine, Myanmar');
insert into airport values('MNV','Mountain Valley, Nt, Australia');
insert into airport values('MNW','Macdonald Downs, Nt, Australia');
insert into airport values('MNX','Manicore, Am, Brazil');
insert into airport values('MNY','Mono Is., Solomon Islands');
insert into airport values('MNZ','Manassas, Virginia, Usa');
insert into airport values('MOA','Moa, Cuba');
insert into airport values('MOB','Mobile Al/Pascagoula,Ms, Usa');
insert into airport values('MOC','Montes Claros, Mg, Brazil');
commit;
insert into airport values('MOD','Modesto, California, Usa');
insert into airport values('MOE','Momeik, Myanmar');
insert into airport values('MOF','Maumere, Indonesia');
insert into airport values('MOG','Monghsat, Myanmar');
insert into airport values('MOH','Mohanbari, India');
insert into airport values('MOI','Mitiaro, Cook Islands, South P');
insert into airport values('MOL','Molde, Norway');
insert into airport values('MOM','Moudjeria, Mauritania');
insert into airport values('MON','Mount Cook, New Zealand-Mon');
insert into airport values('MOO','Moomba, Sa, Australia');
insert into airport values('MOP','Mt. Pleasant, Michigan, Usa');
insert into airport values('MOQ','Morondava, Dem. Rep. Madagasca');
insert into airport values('MOR','Morristown, Tennessee, Usa');
insert into airport values('MOS','Moses Point, Alaska, Usa');
insert into airport values('MOT','Minot, North Dakota, Usa');
insert into airport values('MOU','Mountain Village, Alaska, Usa');
insert into airport values('MOV','Moranbah, Qld, Australia');
insert into airport values('MOW','Moscow, Ussr-Sheremetye');
insert into airport values('MOY','Monterrey, Colombia');
insert into airport values('MOZ','Moorea, French Polynesia');
insert into airport values('MPA','Mpacha, Namibia');
insert into airport values('MPB','Miami, Florida, Usa-Public Spb');
insert into airport values('MPC','Muko-Muko, Indonesia');
insert into airport values('MPD','Mirpur Khas, Pakistan');
insert into airport values('MPE','Madison, Connecticut, Usa');
insert into airport values('MPF','Mapoda, Papua New Guinea');
insert into airport values('MPG','Makini, Papua New Guinea');
insert into airport values('MPH','Caticlan, Philippines');
insert into airport values('MPI','Mamitupo, Panama Republic');
insert into airport values('MPK','Mokpo, Republic Of Korea');
commit;
insert into airport values('MPL','Montpellier, France');
insert into airport values('MPM','Maputo, Mozambique');
insert into airport values('MPN','Mount Pleasant, Falkland Islan');
insert into airport values('MPO','Mt. Pocono, Pennsylvania, Usa');
insert into airport values('MPP','Mulatupo, Panama Republic');
insert into airport values('MPQ','Maan, Jordan');
insert into airport values('MPR','Mc Pherson, Kansas, Usa');
insert into airport values('MPS','Mount Pleasant, Texas, Usa');
insert into airport values('MPT','Maliana, Indonesia');
insert into airport values('MPU','Mapua, Papua New Guinea');
insert into airport values('MPV','Montpelier, Vermont, Usa');
insert into airport values('MPW','Mariupol, Ussr');
insert into airport values('MPX','Miyanmin, Papua New Guinea');
insert into airport values('MPY','Maripasoula, Fr. Guiana');
insert into airport values('MPZ','Mt. Pleasant, Iowa, Usa');
insert into airport values('MQA','Mandora, Wa, Australia');
insert into airport values('MQB','Macomb, Illinois, Usa');
insert into airport values('MQC','Miquelon, St. Pierre & Miquelo');
insert into airport values('MQD','Maquinchao, Rn, Argentina');
insert into airport values('MQE','Marqua, Nt, Australia');
insert into airport values('MQF','Magnitogorsk, Ussr');
insert into airport values('MQI','Quincy, Massachusetts, Usa');
insert into airport values('MQL','Mildura, Vic, Australia');
insert into airport values('MQN','Mo I Rana, Norway');
insert into airport values('MQQ','Moundou, Chad');
insert into airport values('MQR','Mosquera, Colombia');
insert into airport values('MQS','Mustique, Windward Islands');
insert into airport values('MQT','Marquette, Michigan, Usa');
insert into airport values('MQU','Mariquita, Colombia');
insert into airport values('MQX','Makale, Ethiopia');
commit;
insert into airport values('MQY','Smyrna, Tennessee, Usa');
insert into airport values('MRA','Misurata, Libyan A Jamahiriya');
insert into airport values('MRD','Merida, Venezuela');
insert into airport values('MRE','Mara Lodges, Kenya');
insert into airport values('MRF','Marfa, Texas, Usa');
insert into airport values('MRG','Mareeba, Qld, Australia');
insert into airport values('MRI','Anchorage, Alaska, Usa-Merrill');
insert into airport values('MRJ','Marcala, Honduras');
insert into airport values('MRK','Marco Island, Florida, Usa');
insert into airport values('MRL','Miners Lake, Qld, Australia');
insert into airport values('MRM','Manare, Papua New Guinea');
insert into airport values('MRN','Morganton, North Carolina, Usa');
insert into airport values('MRO','Masterton, New Zealand');
insert into airport values('MRP','Marla, Sa, Australia');
insert into airport values('MRQ','Marinduque, Philippines');
insert into airport values('MRR','Macara, Ecuador');
insert into airport values('MRS','Marseille, France');
insert into airport values('MRT','Moroak River, Nt, Australia');
insert into airport values('MRU','Mauritius, Mauritius');
insert into airport values('MRV','Mineralnye Vody, Ussr');
insert into airport values('MRW','Maribo, Denmark');
insert into airport values('MRY','Monterey, California, Usa');
insert into airport values('MRZ','Moree, Nsw, Australia');
insert into airport values('MSA','Muskrat Dam, Ontario, Canada');
insert into airport values('MSB','Marigot, Neth. Antilles');
insert into airport values('MSC','Mesa, Arizona, Usa-Falcon Fld');
insert into airport values('MSD','Mt. Pleasant, Utah, Usa');
insert into airport values('MSE','Manston, England Uk');
insert into airport values('MSF','Mt. Swan, Nt, Australia');
insert into airport values('MSG','Matsaile, Lesotho');
commit;
insert into airport values('MSH','Masirah, Oman');
insert into airport values('MSJ','Misawa, Japan');
insert into airport values('MSL','Muscle Shoals, Alabama, Usa');
insert into airport values('MSM','Masi Manimba, Zaire');
insert into airport values('MSN','Madison, Wisconsin, Usa');
insert into airport values('MSO','Missoula, Montana, Usa');
insert into airport values('MSP','Minneapolis/St. Paul-Intl');
insert into airport values('MSQ','Minsk, Ussr');
insert into airport values('MSS','Massena, New York, Usa');
insert into airport values('MST','Maastricht, Netherlands');
insert into airport values('MSU','Maseru, Lesotho');
insert into airport values('MSV','Monticello Sullivan Co., Ny, U');
insert into airport values('MSW','Massawa, Eritrea, Ethiopia');
insert into airport values('MSX','Mossendjo, Peop. Rep. Of The C');
insert into airport values('MSY','New Orleans, Louisiana-Intl');
insert into airport values('MSZ','Namibe, Angola');
insert into airport values('MTA','Matamata, New Zealand');
insert into airport values('MTB','Monte Libano, Colombia');
insert into airport values('MTD','Mt. Sandford, Nt, Australia');
insert into airport values('MTE','Monte Alegre, Pa, Brazil');
insert into airport values('MTF','Mizan Teferi, Ethiopia');
insert into airport values('MTG','Mato Grosso, Mt, Brazil');
insert into airport values('MTH','Marathon, Florida, Usa');
insert into airport values('MTI','Mosteiros, Cape Verde Islands');
insert into airport values('MTJ','Montrose, Colorado, Usa');
insert into airport values('MTK','Makin, Rep. Of Kiribati');
insert into airport values('MTL','Maitland, Nsw, Australia');
insert into airport values('MTM','Metlakatla, Alaska, Usa');
insert into airport values('MTN','Baltimore, Maryland, U-Martin');
insert into airport values('MTO','Mattoon, Illinois, Usa');
commit;
insert into airport values('MTP','Montauk Point, New York, Usa');
insert into airport values('MTQ','Mitchell, Qld, Australia');
insert into airport values('MTR','Monteria, Colombia');
insert into airport values('MTS','Manzini, Swaziland');
insert into airport values('MTT','Minatitlan, Mexico');
insert into airport values('MTU','Montepuez, Mozambique');
insert into airport values('MTV','Mota Lava, Vanuatu');
insert into airport values('MTW','Manitowoc, Wisconsin, Usa');
insert into airport values('MTX','Fairbanks, Alaska, Usa-Metro');
insert into airport values('MTY','Monterrey, Mexico');
insert into airport values('MTZ','Masada, Israel');
insert into airport values('MUA','Munda, Solomon Islands');
insert into airport values('MUB','Maun, Botswana');
insert into airport values('MUC','Munich, Fed. Rep. Of Germany');
insert into airport values('MUD','Mueda, Mozambique');
insert into airport values('MUE','Kamuela, Hawaii; Hawaii, Usa');
insert into airport values('MUF','Muting, Indonesia');
insert into airport values('MUG','Mulege, Mexico');
insert into airport values('MUH','Mersa Matruh, Arab Rep. Of Egy');
insert into airport values('MUJ','Mui, Ethiopia');
insert into airport values('MUK','Mauke, Cook Islands, South Pac');
insert into airport values('MUM','Mumias, Kenya');
insert into airport values('MUN','Maturin, Venezuela');
insert into airport values('MUP','Mulga Park, Nt, Australia');
insert into airport values('MUQ','Muccan, Wa, Australia');
insert into airport values('MUR','Marudi, Sarawak, Malaysia');
insert into airport values('MUT','Muscatine, Iowa, Usa');
insert into airport values('MUU','Mount Union, Pennsylvania, Usa');
insert into airport values('MUW','Mascara, Algeria');
insert into airport values('MUX','Multan, Pakistan');
commit;
insert into airport values('MUY','Mouyondzi, Peop. Rep. Of The C');
insert into airport values('MUZ','Musoma, Tanzania');
insert into airport values('MVA','Myvatn, Iceland');
insert into airport values('MVB','Franceville, Gabon');
insert into airport values('MVD','Montevideo, Uruguay');
insert into airport values('MVE','Montevideo, Minnesota, Usa');
insert into airport values('MVF','Mossoro, Rn, Brazil');
insert into airport values('MVG','Mevang, Gabon');
insert into airport values('MVH','Macksville, Nsw, Australia');
insert into airport values('MVI','Manetai, Papua New Guinea');
insert into airport values('MVJ','Mandeville, Jamaica');
insert into airport values('MVK','Mulka, Sa, Australia');
insert into airport values('MVL','Stowe, Vermont, Usa');
insert into airport values('MVN','Mount Vernon, Illinois, Usa');
insert into airport values('MVO','Mongo, Chad');
insert into airport values('MVP','Mitu, Colombia');
insert into airport values('MVQ','Mogilev, Ussr');
insert into airport values('MVR','Maroua, Republic Of Cameroon');
insert into airport values('MVT','Mataiva, French Polynesia');
insert into airport values('MVU','Musgrave, Qld, Australia');
insert into airport values('MVV','Megeve, France');
insert into airport values('MVW','Mount Vernon, Washington, Usa');
insert into airport values('MVX','Minvoul, Gabon');
insert into airport values('MVY','Martha''S Vineyard, Ma, Usa');
insert into airport values('MVZ','Masvingo, Zimbabwe');
insert into airport values('MWA','Marion, Illinois, Usa');
insert into airport values('MWB','Morawa, Wa, Australia');
insert into airport values('MWD','Mianwali, Pakistan');
insert into airport values('MWE','Merowe, Sudan');
insert into airport values('MWF','Maewo, Vanuatu');
commit;
insert into airport values('MWG','Marawaka, Papua New Guinea');
insert into airport values('MWH','Moses Lake, Washington, Usa');
insert into airport values('MWI','Maramuni, Papua New Guinea');
insert into airport values('MWJ','Matthews Ridge, Guyana');
insert into airport values('MWK','Matak, Indonesia');
insert into airport values('MWL','Mineral Wells, Texas, Usa');
insert into airport values('MWM','Windom, Minnesota, Usa');
insert into airport values('MWN','Mwadui, Tanzania');
insert into airport values('MWQ','Magwe, Myanmar');
insert into airport values('MWT','Moolawatana, Sa, Australia');
insert into airport values('MWU','Mussau, Papua New Guinea');
insert into airport values('MWY','Miranda Downs, Qld, Australia');
insert into airport values('MWZ','Mwanza, Tanzania');
insert into airport values('MXB','Masamba, Indonesia');
insert into airport values('MXC','Monticello, Utah, Usa');
insert into airport values('MXD','Marion Downs, Qld, Australia');
insert into airport values('MXE','Maxton, North Carolina, Usa');
insert into airport values('MXG','Marlborough, Massachusetts, Us');
insert into airport values('MXH','Moro, Papua New Guinea');
insert into airport values('MXJ','Minna, Nigeria');
insert into airport values('MXK','Mindik, Papua New Guinea');
insert into airport values('MXL','Mexicali, Mexico');
insert into airport values('MXM','Morombe, Dem. Rep. Madagascar');
insert into airport values('MXN','Morlaix, France');
insert into airport values('MXP','Milan, Italy-Malpensa');
insert into airport values('MXQ','Mitchell River, Qld, Australia');
insert into airport values('MXR','Mirgorod, Ussr');
insert into airport values('MXS','Maota, Savaii Island, Western');
insert into airport values('MXT','Maintirano, Dem. Rep. Madagasc');
insert into airport values('MXU','Mullewa, Wa, Australia');
commit;
insert into airport values('MXV','Moron, Mongolia');
insert into airport values('MXW','Mandalgobi, Mongolia');
insert into airport values('MXX','Mora, Sweden');
insert into airport values('MXY','Mc Carthy, Alaska, Usa');
insert into airport values('MXZ','Meixian, P. R. China');
insert into airport values('MYA','Moruya, Nsw, Australia');
insert into airport values('MYB','Mayoumba, Gabon');
insert into airport values('MYC','Maracay, Venezuela');
insert into airport values('MYD','Malindi, Kenya');
insert into airport values('MYE','Miyake Jima, Japan');
insert into airport values('MYF','San Diego, California-Montgome');
insert into airport values('MYG','Mayaguana, Bahamas');
insert into airport values('MYH','Marble Canyon, Arizona, Usa');
insert into airport values('MYI','Murray Islands, Qld, Australia');
insert into airport values('MYJ','Matsuyama, Shikoku, Japan');
insert into airport values('MYK','May Creek, Alaska, Usa');
insert into airport values('MYL','Mc Call, Idaho, Usa');
insert into airport values('MYM','Monkey Mountain, Guyana');
insert into airport values('MYN','Mareb, Yemen, Republic Of');
insert into airport values('MYO','Myroodah, Wa, Australia');
insert into airport values('MYP','Mary, Ussr');
insert into airport values('MYQ','Mysore, India');
insert into airport values('MYR','Myrtle Beach, South Carolina,');
insert into airport values('MYS','Moyale, Ethiopia');
insert into airport values('MYT','Myitkyina, Myanmar');
insert into airport values('MYU','Mekoryuk, Alaska, Usa');
insert into airport values('MYV','Marysville, California, Usa');
insert into airport values('MYW','Mtwara, Tanzania');
insert into airport values('MYX','Menyamya, Papua New Guinea');
insert into airport values('MYY','Miri, Sarawak, Malaysia');
commit;
insert into airport values('MYZ','Monkey Bay, Malawi');
insert into airport values('MZA','Muzaffarnagar, India');
insert into airport values('MZB','Mocimboa De Praia, Mozambique');
insert into airport values('MZC','Mitzic, Gabon');
insert into airport values('MZD','Mendez, Ecuador');
insert into airport values('MZE','Manatee, Belize');
insert into airport values('MZF','Mzamba, South Africa');
insert into airport values('MZG','Makung, Taiwan');
insert into airport values('MZH','Merzifon, Turkey');
insert into airport values('MZI','Mopti, Mali');
insert into airport values('MZK','Marakei, Rep. Of Kiribati');
insert into airport values('MZL','Manizales, Colombia');
insert into airport values('MZM','Metz, France');
insert into airport values('MZN','Minj, Papua New Guinea');
insert into airport values('MZO','Manzanillo, Cuba');
insert into airport values('MZP','Motueka, New Zealand');
insert into airport values('MZQ','Mkuze, South Africa');
insert into airport values('MZR','Mazar-I-Sharif, Dem Rep Afghan');
insert into airport values('MZT','Mazatlan, Mexico');
insert into airport values('MZU','Muzaffarpur, India');
insert into airport values('MZV','Mulu, Malaysia');
insert into airport values('MZX','Mena, Ethiopia');
insert into airport values('MZZ','Marion, Indiana, Usa');
insert into airport values('NAA','Narrabri, Nsw, Australia');
insert into airport values('NAC','Naracoorte, Sa, Australia');
insert into airport values('NAD','Macanal, Colombia');
insert into airport values('NAE','Natitingou, Benin');
insert into airport values('NAF','Banaina, Indonesia');
insert into airport values('NAG','Nagpur, India');
insert into airport values('NAH','Naha, Indonesia');
commit;
insert into airport values('NAI','Annai, Guyana');
insert into airport values('NAK','Nakhon Ratchasima, Thailand');
insert into airport values('NAL','Nalchik, Ussr');
insert into airport values('NAM','Namlea, Indonesia');
insert into airport values('NAN','Nadi, Fiji');
insert into airport values('NAO','Nanchong, P. R. China');
insert into airport values('NAP','Naples, Italy');
insert into airport values('NAR','Nare, Colombia');
insert into airport values('NAS','Nassau, Bahamas-Intl');
insert into airport values('NAT','Natal, Rn, Brazil');
insert into airport values('NAU','Napuka Island, French Polynesi');
insert into airport values('NAW','Narathiwat, Thailand');
insert into airport values('NBA','Nambaiyufa, Papua New Guinea');
insert into airport values('NBB','Barrancominas, Colombia');
insert into airport values('NBC','Naberevnye Chelny, Ussr');
insert into airport values('NBH','Nambucca Heads, Nsw, Australia');
insert into airport values('NBL','San Blas, Panama Republic');
insert into airport values('NBO','Nairobi, Kenya-Jomo');
insert into airport values('NBR','Nambour, Qld, Australia');
insert into airport values('NBV','Cana Brava, Go, Brazil');
insert into airport values('NBX','Nabire, Indonesia');
insert into airport values('NCA','North Caicos, Turks & Caicos I');
insert into airport values('NCE','Nice, France');
insert into airport values('NCG','Nueva Casas Grandes, Mexico');
insert into airport values('NCH','Nachingwea, Tanzania');
insert into airport values('NCI','Necocli, Colombia');
insert into airport values('NCL','Newcastle, England Uk');
insert into airport values('NCN','New Chenega, Alaska, Usa');
insert into airport values('NCP','Luzon Is, Philippines-Cubi Pt');
insert into airport values('NCS','Newcastle, South Africa');
commit;
insert into airport values('NCT','Nicoya, Costa Rica');
insert into airport values('NCU','Nukus, Ussr');
insert into airport values('NCY','Annecy, France');
insert into airport values('NDA','Bandanaira, Indonesia');
insert into airport values('NDB','Nouadhibou, Mauritania');
insert into airport values('NDC','Nanded, India');
insert into airport values('NDD','Sumbe, Angola');
insert into airport values('NDE','Mandera, Kenya');
insert into airport values('NDG','Qiqihar, P. R. China');
insert into airport values('NDI','Namudi, Papua New Guinea');
insert into airport values('NDJ','N''Djamena, Chad');
insert into airport values('NDK','Namorik, Marshall Islands');
insert into airport values('NDL','Ndele, Cen. African Republic');
insert into airport values('NDM','Mendi, Ethiopia');
insert into airport values('NDN','Nadunumu, Papua New Guinea');
insert into airport values('NDR','Nador, Morocco');
insert into airport values('NDS','Sandstone, Wa, Australia');
insert into airport values('NDU','Rundu, Namibia');
insert into airport values('NDY','Sanday, Scotland Uk');
insert into airport values('NDZ','Nordholz-Spieka, Fed Rep Of Ge');
insert into airport values('NEC','Necochea, Ba, Argentina');
insert into airport values('NEF','Neftekamsk, Ussr');
insert into airport values('NEG','Negril, Jamaica');
insert into airport values('NEK','Nekemt, Ethiopia');
insert into airport values('NEN','Whitehouse, Florida, Usa');
insert into airport values('NER','Neryungri, Ussr');
insert into airport values('NEU','Sam Neua, Laos');
insert into airport values('NEV','Nevis, Leeward Islands');
insert into airport values('NEW','New Orleans, Louisiana-Lakefro');
insert into airport values('NFG','Nefteyugansk, Ussr');
commit;
insert into airport values('NFO','Niuafo''Ou, Tonga Is., So. Paci');
insert into airport values('NGA','Young, Nsw, Australia');
insert into airport values('NGB','Ningbo, P. R. China');
insert into airport values('NGC','Grand Canyon, Arizona-North Ri');
insert into airport values('NGD','Anegada, Brit. Virgin Is.');
insert into airport values('NGE','N''Gaoundere, Republic Of Camer');
insert into airport values('NGI','Ngau, Fiji');
insert into airport values('NGN','Nargana, Panama Republic');
insert into airport values('NGO','Nagoya, Japan');
insert into airport values('NGR','Nigerum, Papua New Guinea');
insert into airport values('NGS','Nagasaki, Japan');
insert into airport values('NGW','Corpus Christi, Texas-Cabaniss');
insert into airport values('NHA','Nha-Trang, Soc. Rep. Of Viet N');
insert into airport values('NHD','Minhad Ab, U. A. Emirates');
insert into airport values('NHF','New Halfa, Sudan');
insert into airport values('NHS','Nushki, Pakistan');
insert into airport values('NHT','Northolt, England Uk');
insert into airport values('NHV','Nuku Hiva, French Polynesia');
insert into airport values('NHX','Foley, Alabama, Usa');
insert into airport values('NIA','Nimba, Liberia');
insert into airport values('NIB','Nikolai, Alaska, Usa');
insert into airport values('NIE','Niblack, Alaska, Usa');
insert into airport values('NIG','Nikunau, Rep. Of Kiribati');
insert into airport values('NIK','Niokolo Koba, Senegal');
insert into airport values('NIM','Niamey, Niger');
insert into airport values('NIN','Ninilchik, Alaska, Usa');
insert into airport values('NIO','Nioki, Zaire');
insert into airport values('NIT','Niort, France');
insert into airport values('NIX','Nioro, Mali');
insert into airport values('NJC','Nizhnevartovsk, Ussr');
commit;
insert into airport values('NKA','Nkan, Gabon');
insert into airport values('NKB','Noonkanbah, Wa, Australia');
insert into airport values('NKC','Nouakchott, Mauritania');
insert into airport values('NKG','Nanjing, P. R. China');
insert into airport values('NKI','Naukiti, Alaska, Usa');
insert into airport values('NKL','Nkolo, Zaire');
insert into airport values('NKN','Nankina, Papua New Guinea');
insert into airport values('NKS','Nkongsamba, Republic Of Camero');
insert into airport values('NKU','Nkaus, Lesotho');
insert into airport values('NKV','Nichen Cove, Alaska, Usa');
insert into airport values('NKY','Nkayi, Peop. Rep. Of The Congo');
insert into airport values('NLA','Ndola, Zambia');
insert into airport values('NLD','Nuevo Laredo, Mexico');
insert into airport values('NLE','Niles, Michigan, Usa');
insert into airport values('NLF','Darnley Island, Qld, Australia');
insert into airport values('NLG','Nelson Lagoon, Alaska, Usa');
insert into airport values('NLK','Norfolk Island, Norfolk Island');
insert into airport values('NLL','Nullagine, Wa, Australia');
insert into airport values('NLP','Nelspruit, South Africa');
insert into airport values('NLS','Nicholson, Wa, Australia');
insert into airport values('NLV','Nikolaev, Ussr');
insert into airport values('NMA','Namangan, Ussr');
insert into airport values('NMB','Daman, India');
insert into airport values('NMC','Norman''S Cay, Bahamas');
insert into airport values('NME','Nightmute, Alaska, Usa');
insert into airport values('NMG','San Miguel, Panama Republic');
insert into airport values('NMN','Nomane, Papua New Guinea');
insert into airport values('NMP','New Moon, Qld, Australia');
insert into airport values('NMR','Nappa Merry, Qld, Australia');
insert into airport values('NMS','Namsang, Myanmar');
commit;
insert into airport values('NMT','Namtu, Myanmar');
insert into airport values('NMU','Namu, Marshall Islands');
insert into airport values('NNB','Santa Ana, Solomon Islands');
insert into airport values('NND','Nangade, Mozambique');
insert into airport values('NNG','Nanning, P. R. China');
insert into airport values('NNI','Namutoni, Namibia');
insert into airport values('NNK','Naknek, Alaska, Usa');
insert into airport values('NNL','Nondalton, Alaska, Usa');
insert into airport values('NNM','Narxan-Mar, Ussr');
insert into airport values('NNT','Nan, Thailand');
insert into airport values('NNU','Nanuque, Mg, Brazil');
insert into airport values('NNX','Nunukan, Indonesia');
insert into airport values('NNY','Nanyang, P. R. China');
insert into airport values('NOA','Nowra, Nsw, Australia');
insert into airport values('NOB','Nosara Beach, Costa Rica');
insert into airport values('NOC','Connaught, Republic Of Ireland');
insert into airport values('NOD','Norden, Fed. Rep. Of Germany');
insert into airport values('NOE','Norddeich, Fed. Rep. Of German');
insert into airport values('NOG','Nogales, Mexico');
insert into airport values('NOI','Novorossijsk, Ussr');
insert into airport values('NOM','Nomad River, Papua New Guinea');
insert into airport values('NON','Nonouti, Rep. Of Kiribati');
insert into airport values('NOO','Naoro, Papua New Guinea');
insert into airport values('NOP','Mactan Island, Philippines');
insert into airport values('NOR','Nordfjordur, Iceland');
insert into airport values('NOS','Nossi-Be, Dem. Rep. Madagascar');
insert into airport values('NOT','Novato, California, Usa');
insert into airport values('NOU','Noumea, New Caledonia-Tontouta');
insert into airport values('NOV','Huambo, Angola');
insert into airport values('NOZ','Novokuznetsk, Ussr');
commit;
insert into airport values('NPE','Napier, New Zealand');
insert into airport values('NPG','Nipa, Papua New Guinea');
insert into airport values('NPH','Nephi, Utah, Usa');
insert into airport values('NPL','New Plymouth, New Zealand');
insert into airport values('NPO','Nangapinoh, Indonesia');
insert into airport values('NPP','Napperby, Nt, Australia');
insert into airport values('NPT','Newport, Rhode Island, Usa');
insert into airport values('NQL','Niquelandia, Go, Brazil');
insert into airport values('NQN','Neuquen, Ne, Argentina');
insert into airport values('NQU','Nuqui, Colombia');
insert into airport values('NQY','Newquay, England Uk');
insert into airport values('NRA','Narrandera, Nsw, Australia');
insert into airport values('NRC','Crows Landing, California, Usa');
insert into airport values('NRD','Norderney, Fed. Rep. Of German');
insert into airport values('NRG','Narrogin, Wa, Australia');
insert into airport values('NRI','Shangri-La, Oklahoma, Usa');
insert into airport values('NRK','Norrkoping, Sweden');
insert into airport values('NRL','North Ronaldsay, Scotland Uk');
insert into airport values('NRM','Nara, Mali');
insert into airport values('NRT','Tokyo, Japan-Narita');
insert into airport values('NRY','Newry, Nt, Australia');
insert into airport values('NSA','Noosa, Qld, Australia');
insert into airport values('NSB','Bimini, Bahamas-North Spb');
insert into airport values('NSH','Nowshahr, Iran, Islamic Rep. O');
insert into airport values('NSK','Noril.Sk, Ussr');
insert into airport values('NSM','Norseman, Wa, Australia');
insert into airport values('NSN','Nelson, New Zealand');
insert into airport values('NSO','Scone, Nsw, Australia');
insert into airport values('NST','Nakhon Si Thammarat, Thailand');
insert into airport values('NSV','Noosaville, Qld, Australia');
commit;
insert into airport values('NSX','North Sound Virgin Gorda, B.V.');
insert into airport values('NTA','Natadola, Fiji');
insert into airport values('NTB','Notodden, Norway');
insert into airport values('NTE','Nantes, France');
insert into airport values('NTI','Bintuni, Indonesia');
insert into airport values('NTJ','Manti, Utah, Usa');
insert into airport values('NTL','Newcastle, Nsw, Austra-William');
insert into airport values('NTM','Miracema Do Norte, To, Brazil');
insert into airport values('NTN','Normanton, Qld, Australia');
insert into airport values('NTO','Santo Antao, Cape Verde Island');
insert into airport values('NTT','Niuatoputapu, Tonga Is., S. Pa');
insert into airport values('NTX','Natuna Ranai, Indonesia');
insert into airport values('NTY','Sun City, South Africa');
insert into airport values('NUB','Numbulwar, Nt, Australia');
insert into airport values('NUD','En Nahud, Sudan');
insert into airport values('NUE','Nuremberg, Fed. Rep. Of German');
insert into airport values('NUG','Nuguria, Papua New Guinea');
insert into airport values('NUH','Nunchia, Colombia');
insert into airport values('NUI','Nuiqsut, Alaska, Usa');
insert into airport values('NUK','Nukutavake, French Polynesia');
insert into airport values('NUL','Nulato, Alaska, Usa');
insert into airport values('NUP','Nunapitchuk, Alaska, Usa');
insert into airport values('NUQ','Mountain View, California, Usa');
insert into airport values('NUR','Nullarbor, Sa, Australia');
insert into airport values('NUS','Norsup, Vanuatu');
insert into airport values('NUT','Nutuve, Papua New Guinea');
insert into airport values('NUU','Nakuru, Kenya');
insert into airport values('NUX','Novyj Urengoj, Ussr');
insert into airport values('NVA','Neiva, Colombia');
insert into airport values('NVD','Nevada, Missouri, Usa');
commit;
insert into airport values('NVG','Nueva Guinea, Nicaragua');
insert into airport values('NVK','Narvik, Norway');
insert into airport values('NVP','Novo Aripuana, Am, Brazil');
insert into airport values('NVR','Novgorod, Ussr');
insert into airport values('NVS','Nevers, France');
insert into airport values('NVT','Navegantes, Sc, Brazil');
insert into airport values('NVY','Neyveli, India');
insert into airport values('NWA','Moheli, Comoros');
insert into airport values('NWH','Newport, New Hampshire, Usa');
insert into airport values('NWI','Norwich, England Uk');
insert into airport values('NWT','Nowata, Papua New Guinea');
insert into airport values('NYC','New York Ny/Newark, Nj-Kennedy');
insert into airport values('NYE','Nyeri, Kenya');
insert into airport values('NYI','Sunyani, Ghana');
insert into airport values('NYK','Nanyuki, Kenya');
insert into airport values('NYM','Naym, Ussr');
insert into airport values('NYN','Nyngan, Nsw, Australia');
insert into airport values('NYO','Nykoping, Sweden');
insert into airport values('NYU','Nyaung-U, Myanmar');
insert into airport values('NZE','Nzerekore, Guinea');
insert into airport values('NZO','Nzoia, Kenya');
insert into airport values('NZW','South Weymouth, Massachusetts,');
insert into airport values('OAG','Orange, Nsw, Australia-Springh');
insert into airport values('OAJ','Jacksonville, North Carolina,');
insert into airport values('OAK','Oakland, California, Usa');
insert into airport values('OAM','Oamaru, New Zealand');
insert into airport values('OAN','Olanchito, Honduras');
insert into airport values('OAX','Oaxaca, Mexico');
insert into airport values('OBA','Oban, Qld, Australia');
insert into airport values('OBC','Obock, Djibouti');
commit;
insert into airport values('OBD','Obano, Indonesia');
insert into airport values('OBE','Okeechobee, Florida, Usa');
insert into airport values('OBF','Oberpfaffenhofen, Fed.Rep.Of G');
insert into airport values('OBI','Obidos, Pa, Brazil');
insert into airport values('OBK','Northbrook, Illinois, Usa');
insert into airport values('OBM','Morobe, Papua New Guinea');
insert into airport values('OBN','Oban, Scotland Uk-Connel');
insert into airport values('OBO','Obihiro, Japan');
insert into airport values('OBS','Aubenas, France');
insert into airport values('OBU','Kobuk, Alaska, Usa');
insert into airport values('OBX','Obo, Papua New Guinea');
insert into airport values('OBY','Scoresbysund, Greenland');
insert into airport values('OCA','Ocean Reef Club, Florida, Usa');
insert into airport values('OCC','Coca, Ecuador');
insert into airport values('OCE','Ocean City, Maryland, Usa');
insert into airport values('OCF','Ocala, Florida, Usa');
insert into airport values('OCH','Nacogdoches, Texas, Usa');
insert into airport values('OCI','Oceanic, Alaska, Usa');
insert into airport values('OCJ','Ocho Rios, Jamaica');
insert into airport values('OCN','Oceanside, California, Usa');
insert into airport values('OCV','Ocana, Colombia');
insert into airport values('OCW','Washington, North Carolina, Us');
insert into airport values('ODA','Ouadda, Cen. African Republic');
insert into airport values('ODB','Cordoba, Spain');
insert into airport values('ODD','Oodnadatta, Sa, Australia');
insert into airport values('ODE','Odense, Denmark');
insert into airport values('ODJ','Ouanda Djalle, Cen. African Re');
insert into airport values('ODL','Cordillo Downs, Sa, Australia');
insert into airport values('ODM','Oakland, Maryland, Usa');
insert into airport values('ODN','Long Seridan, Sarawak, Malaysi');
commit;
insert into airport values('ODR','Ord River, Wa, Australia');
insert into airport values('ODS','Odessa, Ussr');
insert into airport values('ODW','Oak Harbor, Washington, Usa');
insert into airport values('ODY','Oudomxay, Laos');
insert into airport values('OEA','Vincennes, Indiana, Usa');
insert into airport values('OEC','Ocussi, Indonesia');
insert into airport values('OEL','Orel, Ussr');
insert into airport values('OEO','Osceola, Wisconsin, Usa');
insert into airport values('OER','Ornskoldsvik, Sweden');
insert into airport values('OES','San Antonio Oeste, Rn, Argenti');
insert into airport values('OFI','Ouango Fitini, Cote D''Ivoire');
insert into airport values('OFJ','Olafsfjordur, Iceland');
insert into airport values('OFK','Norfolk, Nebraska, Usa');
insert into airport values('OFU','Ofu Island, American Samoa');
insert into airport values('OGA','Ogallala, Nebraska, Usa');
insert into airport values('OGB','Orangeburg, South Carolina, Us');
insert into airport values('OGD','Ogden, Utah, Usa');
insert into airport values('OGE','Ogeranang, Papua New Guinea');
insert into airport values('OGG','Kahului, Maui; Hawaii, Usa');
insert into airport values('OGL','Ogle, Guyana');
insert into airport values('OGN','Yonaguni-Jima, Japan');
insert into airport values('OGO','Abengourou, Cote D''Ivoire');
insert into airport values('OGR','Bongor, Chad');
insert into airport values('OGS','Ogdensburg, New York, Usa');
insert into airport values('OGX','Ouargla, Algeria');
insert into airport values('OGZ','Ordzhonikidze, Ussr');
insert into airport values('OHA','Ohakea, New Zealand');
insert into airport values('OHC','North East Cape, Alaska, Usa');
insert into airport values('OHD','Ohrid, Yugoslavia');
insert into airport values('OHI','Oshakati, Namibia');
commit;
insert into airport values('OHO','Ohotsk, Ussr');
insert into airport values('OHP','Oban, Scotland Uk-Hlpt');
insert into airport values('OHR','Wyk Auf Foehr, Fed. Rep. Of Ge');
insert into airport values('OHT','Kohat, Pakistan');
insert into airport values('OIM','Oshima Is., Japan');
insert into airport values('OIR','Okushiri, Japan');
insert into airport values('OIT','Oita, Japan');
insert into airport values('OJC','Kansas City, Missouri-Executiv');
insert into airport values('OKA','Okinawa, Ryukyu Is., Japan');
insert into airport values('OKB','Orchid Beach, Qld, Australia');
insert into airport values('OKC','Oklahoma City, Oklahom-Rogers');
insert into airport values('OKD','Sapporo, Japan-Okadama');
insert into airport values('OKE','Okino Erabu, Japan');
insert into airport values('OKF','Okaukuejo, Namibia');
insert into airport values('OKG','Okoyo, Peop. Rep. Of The Congo');
insert into airport values('OKI','Oki Island, Japan');
insert into airport values('OKJ','Okayama, Japan');
insert into airport values('OKK','Kokomo, Indiana, Usa');
insert into airport values('OKL','Oksibil, Indonesia');
insert into airport values('OKM','Okmulgee, Oklahoma, Usa');
insert into airport values('OKN','Okondja, Gabon');
insert into airport values('OKP','Oksapmin, Papua New Guinea');
insert into airport values('OKQ','Okaba, Indonesia');
insert into airport values('OKR','Yorke Islands, Qld, Australia');
insert into airport values('OKS','Oshkosh, Nebraska, Usa');
insert into airport values('OKT','Oktiabrskij, Ussr');
insert into airport values('OKU','Mokuti Lodge, Namibia');
insert into airport values('OKY','Oakey, Qld, Australia');
insert into airport values('OLA','Orland, Norway');
insert into airport values('OLB','Olbia, Italy');
commit;
insert into airport values('OLD','Old Town, Maine, Usa');
insert into airport values('OLE','Olean, New York, Usa');
insert into airport values('OLF','Wolf Point, Montana, Usa');
insert into airport values('OLH','Old Harbor, Alaska, Usa');
insert into airport values('OLI','Olafsvik, Iceland');
insert into airport values('OLJ','Olpoi, Vanuatu');
insert into airport values('OLM','Olympia, Washington, Usa');
insert into airport values('OLN','Colonia Sarmiento, Cb, Argenti');
insert into airport values('OLO','Olomouc, Czechoslovakia');
insert into airport values('OLP','Olympic Dam, Sa, Australia');
insert into airport values('OLQ','Olsobip, Papua New Guinea');
insert into airport values('OLS','Nogales, Arizona, Usa');
insert into airport values('OLU','Columbus, Nebraska, Usa');
insert into airport values('OLV','Olive Branch, Mississippi, Usa');
insert into airport values('OLY','Olney, Illinois, Usa');
insert into airport values('OMA','Omaha, Nebraska, Usa-Eppley');
insert into airport values('OMB','Omboue, Gabon');
insert into airport values('OMC','Ormoc, Philippines');
insert into airport values('OMD','Oranjemund, Namibia');
insert into airport values('OME','Nome, Alaska, Usa');
insert into airport values('OMF','Mafraq, Jordan');
insert into airport values('OMG','Omega, Namibia');
insert into airport values('OMH','Urmieh, Iran, Islamic Rep. Of');
insert into airport values('OMK','Omak, Washington, Usa');
insert into airport values('OML','Omkalai, Papua New Guinea');
insert into airport values('OMN','Osmanabad, India');
insert into airport values('OMO','Mostar, Yugoslavia');
insert into airport values('OMR','Oradea, Romania');
insert into airport values('OMS','Omsk, Ussr');
insert into airport values('OMY','Phnom Thbeng Meanchey, Cambodi');
commit;
insert into airport values('ONB','Ononge, Papua New Guinea');
insert into airport values('OND','Ondangwa, Namibia');
insert into airport values('ONE','Onepusu, Solomon Islands');
insert into airport values('ONG','Mornington Is., Qld, Australia');
insert into airport values('ONH','Oneonta, New York, Usa');
insert into airport values('ONI','Moanamani, Indonesia');
insert into airport values('ONL','Oneill, Nebraska, Usa');
insert into airport values('ONM','Socorro, New Mexico, Usa');
insert into airport values('ONN','Onion Bay, Alaska, Usa');
insert into airport values('ONO','Ontario, Oregon, Usa');
insert into airport values('ONP','Newport, Oregon, Usa');
insert into airport values('ONR','Monkira, Qld, Australia');
insert into airport values('ONS','Onslow, Wa, Australia');
insert into airport values('ONT','Ontario, California, Usa');
insert into airport values('ONU','Ono-I-Lau, Fiji');
insert into airport values('ONX','Colon, Panama Republic');
insert into airport values('ONY','Olney, Texas, Usa');
insert into airport values('OOA','Oskaloosa, Iowa, Usa');
insert into airport values('OOK','Toksook Bay, Alaska, Usa');
insert into airport values('OOL','Gold Coast, Qld, Australia');
insert into airport values('OOM','Cooma, Nsw, Australia');
insert into airport values('OOR','Mooraberree, Qld, Australia');
insert into airport values('OOT','Onotoa, Rep. Of Kiribati');
insert into airport values('OPA','Kopasker, Iceland');
insert into airport values('OPB','Open Bay, Papua New Guinea');
insert into airport values('OPF','Miami, Florida, Usa-Opa Locka');
insert into airport values('OPI','Oenpelli, Nt, Australia');
insert into airport values('OPL','Opelousas, Louisiana, Usa');
insert into airport values('OPO','Porto, Portugal');
insert into airport values('OPS','Sinop, Mt, Brazil');
commit;
insert into airport values('OPU','Balimo, Papua New Guinea');
insert into airport values('OPW','Opuwa, Namibia');
insert into airport values('ORA','Oran, Sa, Argentina');
insert into airport values('ORB','Orebro, Sweden');
insert into airport values('ORC','Orocue, Colombia');
insert into airport values('ORD','Chicago, Illinois, Usa-O''Hare');
insert into airport values('ORE','Orleans, France');
insert into airport values('ORF','Norfolk/Va. Beach/Wmbg, Va, Us');
insert into airport values('ORG','Paramaribo, Republic O-Z En Ho');
insert into airport values('ORH','Worcester, Massachusetts, Usa');
insert into airport values('ORI','Port Lions, Alaska, Usa');
insert into airport values('ORJ','Orinduik, Guyana');
insert into airport values('ORK','Cork, Republic Of Ireland');
insert into airport values('ORL','Orlando, Florida, Usa-Herndon');
insert into airport values('ORM','Northampton, England Uk');
insert into airport values('ORN','Oran, Algeria-Es Senia');
insert into airport values('ORO','Yoro, Honduras');

insert into airport values('ORP','Orapa, Botswana');
insert into airport values('ORQ','Norwalk, Connecticut, Usa');
insert into airport values('ORR','Yorketown, Sa, Australia');
insert into airport values('ORS','Orpheus Is. Resort, Qld, Austr');
insert into airport values('ORT','Northway, Alaska, Usa');
insert into airport values('ORU','Oruro, Bolivia');
insert into airport values('ORV','Noorvik, Alaska, Usa');
insert into airport values('ORW','Ormara, Pakistan');
insert into airport values('ORX','Oriximina, Pa, Brazil');
insert into airport values('ORY','Paris, France-Orly');
insert into airport values('ORZ','Orange Walk, Belize');
insert into airport values('OSA','Osaka, Japan');
commit;
insert into airport values('OSB','Osage Beach, Missouri, Usa');
insert into airport values('OSC','Oscoda, Michigan, Usa');
insert into airport values('OSD','Ostersund, Sweden');
insert into airport values('OSE','Omora, Papua New Guinea');
insert into airport values('OSG','Ossima, Papua New Guinea');
insert into airport values('OSH','Oshkosh, Wisconsin, Usa');
insert into airport values('OSI','Osijek, Yugoslavia');
insert into airport values('OSK','Oskarshamn, Sweden');
insert into airport values('OSL','Oslo, Norway-Gardermoen');
insert into airport values('OSM','Mosul, Iraq');
insert into airport values('OSP','Slupsk, Poland');
insert into airport values('OSR','Ostrava, Czechoslovakia');
insert into airport values('OSS','Osh, Ussr');
insert into airport values('OST','Ostend, Belgium');
insert into airport values('OSU','Columbus, Ohio, Usa-University');
insert into airport values('OSW','Orsk, Ussr');
insert into airport values('OSX','Kosciusko, Mississippi, Usa');
insert into airport values('OSY','Namsos, Norway');
insert into airport values('OSZ','Koszalin, Poland');
insert into airport values('OTA','Mota, Ethiopia');
insert into airport values('OTC','Bol, Chad');
insert into airport values('OTD','Contadora, Panama Republic');
insert into airport values('OTG','Worthington, Minnesota, Usa');
insert into airport values('OTH','North Bend, Oregon, Usa');
insert into airport values('OTI','Morotai Island, Indonesia');
insert into airport values('OTL','Boutilimit, Mauritania');
insert into airport values('OTM','Ottumwa, Iowa, Usa');
insert into airport values('OTN','Oaktown, Indiana, Usa');
insert into airport values('OTO','Otto, New Mexico, Usa');
insert into airport values('OTP','Bucharest, Romania-Otopeni');
commit;
insert into airport values('OTR','Coto 47, Costa Rica');
insert into airport values('OTS','Anacortes, Washington, Usa');
insert into airport values('OTU','Otu, Colombia');
insert into airport values('OTY','Oria, Papua New Guinea');
insert into airport values('OTZ','Kotzebue, Alaska, Usa');
insert into airport values('OUA','Ouagadougou, Burkina Faso');
insert into airport values('OUD','Oujda, Morocco');
insert into airport values('OUE','Ouesso, Peop. Rep. Of The Cong');
insert into airport values('OUG','Ouahigouya, Burkina Faso');
insert into airport values('OUH','Oudtshoorn, South Africa');
insert into airport values('OUI','Ban Houei Sai, Laos');
insert into airport values('OUL','Oulu, Finland');
insert into airport values('OUM','Oum Hadjer, Chad');
insert into airport values('OUN','Norman, Oklahoma, Usa');
insert into airport values('OUR','Batouri, Republic Of Cameroon');
insert into airport values('OUS','Ourinhos, Sp, Brazil');
insert into airport values('OUT','Bousso, Chad');
insert into airport values('OUU','Ouanga, Gabon');
insert into airport values('OUZ','Zouerate, Mauritania');
insert into airport values('OVA','Bekily, Dem. Rep. Madagascar');
insert into airport values('OVB','Novosibirsk, Ussr');
insert into airport values('OVD','Asturias, Spain');
insert into airport values('OVE','Oroville, California, Usa');
insert into airport values('OVL','Ovalle, Chile');
insert into airport values('OWA','Owatonna, Minnesota, Usa');
insert into airport values('OWB','Owensboro, Kentucky, Usa');
insert into airport values('OWD','Norwood, Massachusetts, Usa');
insert into airport values('OWE','Owendo, Gabon');
insert into airport values('OWK','Norridgewock, Maine, Usa');
insert into airport values('OXC','Oxford, Connecticut, Usa');
commit;
insert into airport values('OXO','Orientos, Qld, Australia');
insert into airport values('OXR','Oxnard, California, Usa');
insert into airport values('OXY','Morney, Qld, Australia');
insert into airport values('OYA','Goya, Cr, Argentina');
insert into airport values('OYE','Oyem, Gabon');
insert into airport values('OYG','Moyo, Uganda');
insert into airport values('OYK','Oiapoque, Ap, Brazil');
insert into airport values('OYL','Moyale, Kenya');
insert into airport values('OYN','Ouyen, Vic, Australia');
insert into airport values('OYO','Tres Arroyos, Ba, Argentina');
insert into airport values('OYP','St-Georges De L/Oyapock, Fr. G');
insert into airport values('OYS','Yosemite National Park, Ca., U');
insert into airport values('OZA','Ozona, Texas, Usa');
insert into airport values('OZC','Ozamis City, Philippines');
insert into airport values('OZH','Zaporozh''Ye, Ussr');
insert into airport values('OZZ','Ouarzazate, Morocco');
insert into airport values('PAA','Pa-An, Myanmar');
insert into airport values('PAB','Bilaspur, India');
insert into airport values('PAC','Panama City, Panama Re-Paitill');
insert into airport values('PAD','Paderborn, Fed. Rep. Of German');
insert into airport values('PAE','Everett, Washington, Usa');
insert into airport values('PAF','Pakuba, Uganda');
insert into airport values('PAG','Pagadian, Philippines');
insert into airport values('PAH','Paducah, Kentucky, Usa');
insert into airport values('PAI','Pailin, Cambodia');
insert into airport values('PAJ','Para Chinar, Pakistan');
insert into airport values('PAK','Hanapepe, Kauai; Hawaii, Usa');
insert into airport values('PAL','Palanquero, Colombia');
insert into airport values('PAN','Pattani, Thailand');
insert into airport values('PAO','Palo Alto, California, Usa');
commit;
insert into airport values('PAP','Port Au Prince, Haiti');
insert into airport values('PAQ','Palmer, Alaska, Usa');
insert into airport values('PAR','Paris, France-Orly');
insert into airport values('PAS','Paros, Greece');
insert into airport values('PAT','Patna, India');
insert into airport values('PAU','Pauk, Myanmar');
insert into airport values('PAV','Paulo Afonso, Ba, Brazil');
insert into airport values('PAW','Pambwa, Papua New Guinea');
insert into airport values('PAX','Port-De-Paix, Haiti');
insert into airport values('PAY','Pamol, Sabah, Malaysia');
insert into airport values('PAZ','Poza Rica, Mexico');
insert into airport values('PBA','Point Barrow, Alaska, Usa');
insert into airport values('PBB','Paranaiba, Ms, Brazil');
insert into airport values('PBC','Puebla, Mexico');
insert into airport values('PBD','Porbandar, India');
insert into airport values('PBE','Puerto Berrio, Colombia');
insert into airport values('PBF','Pine Bluff, Arkansas, Usa');
insert into airport values('PBH','Paro, Bhutan');
insert into airport values('PBI','West Palm Beach, Florida, Usa');
insert into airport values('PBL','Puerto Cabello, Venezuela');
insert into airport values('PBM','Paramaribo, Republic O-Zanderi');
insert into airport values('PBN','Porto Amboim, Angola');
insert into airport values('PBO','Paraburdoo, Wa, Australia');
insert into airport values('PBQ','Pimenta Bueno, Ro, Brazil');
insert into airport values('PBR','Puerto Barrios, Guatemala');
insert into airport values('PBU','Putao, Myanmar');
insert into airport values('PBZ','Plettenberg, South Africa');
insert into airport values('PCA','Portage Creek, Alaska, Usa');
insert into airport values('PCB','Pondok Cabe, Indonesia');
insert into airport values('PCC','Puerto Rico, Colombia');
commit;
insert into airport values('PCD','Prairie Du Chien, Wisconsin, U');
insert into airport values('PCG','Paso Caballos, Guatemala');
insert into airport values('PCH','Palacios, Honduras');
insert into airport values('PCK','Porcupine Creek, Alaska, Usa');
insert into airport values('PCL','Pucallpa, Peru');
insert into airport values('PCN','Picton, New Zealand');
insert into airport values('PCO','Punta Colorada, Mexico');
insert into airport values('PCP','Principe Is., Principe Island');
insert into airport values('PCR','Puerto Carreno, Colombia');
insert into airport values('PCS','Picos, Pi, Brazil');
insert into airport values('PCT','Princeton, New Jersey, Usa');
insert into airport values('PCU','Picayune, Mississippi, Usa');
insert into airport values('PCV','Punta Chivato, Mexico');
insert into airport values('PDA','Puerto Inirida, Colombia');
insert into airport values('PDB','Pedro Bay, Alaska, Usa');
insert into airport values('PDC','Mueo, New Caledonia');
insert into airport values('PDE','Pandie Pandie, Sa, Australia');
insert into airport values('PDF','Prado, Ba, Brazil');
insert into airport values('PDG','Padang, Indonesia');
insert into airport values('PDI','Pindiu, Papua New Guinea');
insert into airport values('PDK','Atlanta, Georgia, Usa-Dekalb');
insert into airport values('PDL','Ponta Delgada, Portugal (Azore');
insert into airport values('PDN','Parndana, Sa, Australia');
insert into airport values('PDO','Pendopo, Indonesia');
insert into airport values('PDP','Punta Del Este, Uruguay');
insert into airport values('PDS','Piedras Negras, Mexico');
insert into airport values('PDT','Pendleton, Oregon, Usa');
insert into airport values('PDU','Paysandu, Uruguay');
insert into airport values('PDV','Plovdiv, Bulgaria');
insert into airport values('PDX','Portland, Oregon, Usa');
commit;
insert into airport values('PDZ','Pedernales, Venezuela');
insert into airport values('PEA','Penneshaw, Sa, Australia');
insert into airport values('PEB','Pebane, Mozambique');
insert into airport values('PEC','Pelican, Alaska, Usa');
insert into airport values('PEE','Perm, Ussr');
insert into airport values('PEG','Perugia, Italy');
insert into airport values('PEH','Pehuajo, Ba, Argentina');
insert into airport values('PEI','Pereira, Colombia');
insert into airport values('PEK','Beijing, P. R. China');
insert into airport values('PEL','Pelaneng, Lesotho');
insert into airport values('PEM','Puerto Maldonado, Peru');
insert into airport values('PEN','Penang, Malaysia');
insert into airport values('PEP','Peppimenarti, Nt, Australia');
insert into airport values('PEQ','Pecos, Texas, Usa');
insert into airport values('PER','Perth, Wa, Australia');
insert into airport values('PES','Petrozavodsk, Ussr');
insert into airport values('PET','Pelotas, Rs, Brazil');
insert into airport values('PEU','Puerto Lempira, Honduras');
insert into airport values('PEW','Peshawar, Pakistan');
insert into airport values('PEX','Pechora, Ussr');
insert into airport values('PEY','Penong, Sa, Australia');
insert into airport values('PEZ','Penza, Ussr');
insert into airport values('PFA','Paf Warren, Alaska, Usa');
insert into airport values('PFB','Passo Fundo, Rs, Brazil');
insert into airport values('PFC','Pacific City, Oregon, Usa');
insert into airport values('PFD','Port Frederick, Alaska, Usa');
insert into airport values('PFJ','Patreksfjordur, Iceland');
insert into airport values('PFN','Panama City, Florida, Usa');
insert into airport values('PFO','Paphos, Cyprus');
insert into airport values('PFR','Ilebo, Zaire');
commit;
insert into airport values('PGA','Page, Arizona, Usa');
insert into airport values('PGB','Pangoa, Papua New Guinea');
insert into airport values('PGC','Petersburg, West Virginia, Usa');
insert into airport values('PGD','Punta Gorda, Florida, Usa');
insert into airport values('PGE','Yegepa, Papua New Guinea');
insert into airport values('PGF','Perpignan, France');
insert into airport values('PGH','Pantnagar, India');
insert into airport values('PGI','Chitato, Angola');
insert into airport values('PGK','Pangkalpinang, Indonesia');
insert into airport values('PGM','Port Graham, Alaska, Usa');
insert into airport values('PGN','Pangia, Papua New Guinea');
insert into airport values('PGP','Porto Alegre, Sao Tome Island');
insert into airport values('PGR','Paragould, Arkansas, Usa');
insert into airport values('PGS','Peach Springs, Arizona, Usa');
insert into airport values('PGV','Greenville, North Carolina, Us');
insert into airport values('PGX','Perigueux, France');
insert into airport values('PGZ','Ponta Grossa, Pr, Brazil');
insert into airport values('PHA','Phan Rang, Soc. Rep. Of Viet N');
insert into airport values('PHB','Parnaiba, Pi, Brazil');
insert into airport values('PHC','Port Harcourt, Nigeria');
insert into airport values('PHD','New Philadelphia, Ohio, Usa');
insert into airport values('PHE','Port Hedland, Wa, Australia');
insert into airport values('PHF','Newport News/Williamsburg, Va,');
insert into airport values('PHH','Phan Thiet, Soc. Rep. Of Viet');
insert into airport values('PHI','Pinheiro, Ma, Brazil');
insert into airport values('PHJ','Port Hunter, Nsw, Australia');
insert into airport values('PHK','Pahokee, Florida, Usa');
insert into airport values('PHL','Philadelphia Pa/Wilm''T-Intl');
insert into airport values('PHN','Port Huron, Michigan, Usa');
insert into airport values('PHO','Point Hope, Alaska, Usa');
commit;
insert into airport values('PHP','Philip, South Dakota, Usa');
insert into airport values('PHR','Pacific Harbour, Fiji');
insert into airport values('PHS','Phitsanulok, Thailand');
insert into airport values('PHT','Paris, Tennessee, Usa');
insert into airport values('PHU','Phu-Vinh, Soc. Rep. Of Viet Na');
insert into airport values('PHW','Phalaborwa, South Africa');
insert into airport values('PHX','Phoenix, Arizona, Usa-Intl');
insert into airport values('PHZ','Phi Phi Island, Thailand');
insert into airport values('PIA','Peoria, Illinois, Usa');
insert into airport values('PIB','Laurel/Hattiesburg, Ms, Usa');
insert into airport values('PIC','Pine Cay, Turks & Caicos Is');
insert into airport values('PID','Nassau, Bahamas-Paradise I');
insert into airport values('PIE','Tampa/St. Petersburg-St Pete');
insert into airport values('PIG','Pitinga, Am, Brazil');
insert into airport values('PIH','Pocatello, Idaho, Usa');
insert into airport values('PII','Fairbanks, Alaska, Usa-Phillip');
insert into airport values('PIK','Glasgow, Scotland Uk-Prestwick');
insert into airport values('PIL','Pilar, Paraguay');
insert into airport values('PIM','Pine Mountain, Georgia, Usa');
insert into airport values('PIN','Parintins, Am, Brazil');
insert into airport values('PIO','Pisco, Peru');
insert into airport values('PIP','Pilot Point, Alaska, Usa-Pip');
insert into airport values('PIQ','Pipillipai, Guyana');
insert into airport values('PIR','Pierre, South Dakota, Usa');
insert into airport values('PIS','Poitiers, France');
insert into airport values('PIT','Pittsburgh, Pennsylvan-Grt Pit');
insert into airport values('PIU','Piura, Peru');
insert into airport values('PIW','Pikwitonei, Manitoba, Canada');
insert into airport values('PIX','Pico Island, Portugal (Azores)');
insert into airport values('PIZ','Point Lay, Alaska, Usa');
commit;
insert into airport values('PJB','Payson, Arizona, Usa');
insert into airport values('PJC','Pedro Juan Caballero, Paraguay');
insert into airport values('PJG','Panjgur, Pakistan');
insert into airport values('PJM','Puerto Jimenez, Costa Rica');
insert into airport values('PJS','Port San Juan, Alaska, Usa');
insert into airport values('PJZ','Puerto Juarez, Mexico');
insert into airport values('PKA','Napaskiak, Alaska, Usa');
insert into airport values('PKB','Parkersburg, West Virginia, Us');
insert into airport values('PKC','Petropavlovsk-Kamchatsky, Ussr');
insert into airport values('PKD','Park Rapids, Minnesota, Usa');
insert into airport values('PKE','Parkes, Nsw, Australia');
insert into airport values('PKF','Park Falls, Wisconsin, Usa');
insert into airport values('PKH','Porto Kheli, Greece');
insert into airport values('PKK','Pakokku, Myanmar');
insert into airport values('PKL','Pakatoa, New Zealand');
insert into airport values('PKM','Port Kaituma, Guyana');
insert into airport values('PKN','Pangkalanbuun, Indonesia');
insert into airport values('PKO','Parakou, Benin');
insert into airport values('PKP','Puka Puka, French Polynesia');
insert into airport values('PKR','Pokhara, Nepal');
insert into airport values('PKS','Paksane, Laos');
insert into airport values('PKT','Port Keats, Nt, Australia');
insert into airport values('PKU','Pekanbaru, Indonesia');
insert into airport values('PKV','Pskov, Ussr');
insert into airport values('PKW','Selebi-Phikwe, Botswana');
insert into airport values('PKY','Palangkaraya, Indonesia');
insert into airport values('PKZ','Pakse, Laos');
insert into airport values('PLA','Planadas, Colombia');
insert into airport values('PLB','Plattsburgh, New York, Usa');
insert into airport values('PLC','Planeta Rica, Colombia');
commit;
insert into airport values('PLD','Playa Samara, Costa Rica');
insert into airport values('PLF','Pala, Chad');
insert into airport values('PLH','Plymouth, England Uk');
insert into airport values('PLI','Palm Island, Windward Islands');
insert into airport values('PLK','Point Lookout, Missouri, Usa');
insert into airport values('PLL','Ponta Pelada, Am, Brazil');
insert into airport values('PLM','Palembang, Indonesia');
insert into airport values('PLN','Pellston, Michigan, Usa');
insert into airport values('PLO','Port Lincoln, Sa, Australia');
insert into airport values('PLP','La Palma, Panama Republic');
insert into airport values('PLQ','Palanga, Ussr');
insert into airport values('PLR','Pell City, Alabama, Usa');
insert into airport values('PLS','Providenciales, Turks & Caicos');
insert into airport values('PLT','Plato, Colombia');
insert into airport values('PLU','Belo Horizonte, Mg, Br-Pampulh');
insert into airport values('PLV','Poltava, Ussr');
insert into airport values('PLW','Palu, Indonesia');
insert into airport values('PLX','Semipalatinsk, Ussr');
insert into airport values('PLY','Plymouth, Indiana, Usa');
insert into airport values('PLZ','Port Elizabeth, South Africa');
insert into airport values('PMA','Pemba Island, Tanzania');
insert into airport values('PMB','Pembina, North Dakota, Usa');
insert into airport values('PMC','Puerto Montt, Chile');
insert into airport values('PMD','Palmdale/Lancaster, Ca-Afb');
insert into airport values('PME','Portsmouth, England Uk');
insert into airport values('PMF','Parma, Italy');
insert into airport values('PMG','Ponta Pora, Ms, Brazil');
insert into airport values('PMH','Portsmouth, Ohio, Usa');
insert into airport values('PMI','Palma, Mallorca Island, Spain');
insert into airport values('PMK','Palm Island, Qld, Australia');
commit;
insert into airport values('PML','Port Moller, Alaska, Usa');
insert into airport values('PMM','Phanom Sarakham, Thailand');
insert into airport values('PMN','Pumani, Papua New Guinea');
insert into airport values('PMO','Palermo, Italy');
insert into airport values('PMP','Pimaga, Papua New Guinea');
insert into airport values('PMQ','Perito Moreno, Sc, Argentina');
insert into airport values('PMR','Palmerston North, New Zealand');
insert into airport values('PMS','Palmyra, Syria');
insert into airport values('PMT','Paramakatoi, Guyana');
insert into airport values('PMU','Paimiut, Alaska, Usa');
insert into airport values('PMV','Porlamar, Venezuela');
insert into airport values('PMW','Palmas, To, Brazil');
insert into airport values('PMX','Palmer, Massachusetts, Usa');
insert into airport values('PMY','Puerto Madryn, Cb, Argentina');
insert into airport values('PMZ','Palmar, Costa Rica');
insert into airport values('PNA','Pamplona, Spain');
insert into airport values('PNB','Porto Nacional, To, Brazil');
insert into airport values('PNC','Ponca City, Oklahoma, Usa');
insert into airport values('PND','Punta Gorda, Belize');
insert into airport values('PNE','Philadelphia Pa/Wilm''T-No. Phi');
insert into airport values('PNF','Peterson''S Point, Alaska, Usa');
insert into airport values('PNG','Paranagua, Pr, Brazil');
insert into airport values('PNH','Phnom Penh, Cambodia');
insert into airport values('PNI','Pohnpei, Caroline Is., Pac. Oc');
insert into airport values('PNK','Pontianak, Indonesia');
insert into airport values('PNL','Pantelleria, Italy');
insert into airport values('PNN','Princeton, Maine, Usa');
insert into airport values('PNO','Pinotepa, Mexico');
insert into airport values('PNP','Popondetta, Papua New Guinea');
insert into airport values('PNQ','Poona, India');
commit;
insert into airport values('PNR','Pointe Noire, Peop. Rep. Of Co');
insert into airport values('PNS','Pensacola, Florida, Usa');
insert into airport values('PNT','Puerto Natales, Chile');
insert into airport values('PNU','Panguitch, Utah, Usa');
insert into airport values('PNX','Sherman/Denison, Texas, Usa');
insert into airport values('PNY','Pondicherry, India');
insert into airport values('PNZ','Petrolina, Pe, Brazil');
insert into airport values('POA','Porto Alegre, Rs, Brazil');
insert into airport values('POC','La Verne, California, Usa');
insert into airport values('POD','Podor, Senegal');
insert into airport values('POE','Fort Polk, Louisiana, Usa');
insert into airport values('POF','Poplar Bluff, Missouri, Usa');
insert into airport values('POG','Port Gentil, Gabon');
insert into airport values('POH','Pocahontas, Iowa, Usa');
insert into airport values('POI','Potosi, Bolivia');
insert into airport values('POL','Pemba, Mozambique');
insert into airport values('POM','Port Moresby, Papua New Guinea');
insert into airport values('PON','Poptun, Guatemala');
insert into airport values('POO','Pocos De Caldas, Mg, Brazil');
insert into airport values('POP','Puerto Plata, Dominican Rep.');
insert into airport values('POQ','Polk Inlet, Alaska, Usa');
insert into airport values('POR','Pori, Finland');
insert into airport values('POS','Port Of Spain, Trin. & Tob.');
insert into airport values('POT','Port Antonio, Jamaica');
insert into airport values('POU','Poughkeepsie, New York, Usa');
insert into airport values('POW','Portoroz, Yugoslavia');
insert into airport values('POX','Pontoise, France');
insert into airport values('POY','Powell, Wyoming, Usa');
insert into airport values('POZ','Poznan, Poland');
insert into airport values('PPA','Pampa, Texas, Usa');
commit;
insert into airport values('PPB','Presidente Prudente, Sp, Brazi');
insert into airport values('PPC','Prospect Creek, Alaska, Usa');
insert into airport values('PPE','Puerto Penasco, Mexico');
insert into airport values('PPF','Parsons, Kansas, Usa');
insert into airport values('PPG','Pago Pago, American Samoa');
insert into airport values('PPH','Peraitepuy, Venezuela');
insert into airport values('PPI','Port Pirie, Sa, Australia');
insert into airport values('PPJ','Pulau Panjang, Indonesia');
insert into airport values('PPK','Petropavlovsk, Ussr');
insert into airport values('PPL','Phaplu, Nepal');
insert into airport values('PPM','Pompano Beach, Florida, Usa');
insert into airport values('PPN','Popayan, Colombia');
insert into airport values('PPO','Powell Point, Bahamas');
insert into airport values('PPP','Proserpine, Qld, Australia');
insert into airport values('PPQ','Paraparaumu, New Zealand');
insert into airport values('PPR','Pasir Pangarayan, Indonesia');
insert into airport values('PPS','Puerto Princesa, Philippines');
insert into airport values('PPT','Papeete, French Polynesia');
insert into airport values('PPU','Papun, Myanmar');
insert into airport values('PPV','Port Protection, Alaska, Usa');
insert into airport values('PPW','Papa Westray, Scotland Uk');
insert into airport values('PPX','Param, Papua New Guinea');
insert into airport values('PPZ','Puerto Paez, Venezuela');
insert into airport values('PQC','Phuquoc, Soc. Rep. Of Viet Nam');
insert into airport values('PQI','Presque Isle, Maine, Usa');
insert into airport values('PQM','Palenque, Mexico');
insert into airport values('PQQ','Port Macquarie, Nsw, Australia');
insert into airport values('PQS','Pilot Station, Alaska, Usa');
insert into airport values('PRA','Parana, Er, Argentina');
insert into airport values('PRB','Paso Robles, California, Usa');
commit;
insert into airport values('PRC','Prescott, Arizona, Usa');
insert into airport values('PRD','Pardoo, Wa, Australia');
insert into airport values('PRE','Pore, Colombia');
insert into airport values('PRF','Port Johnson, Alaska, Usa');
insert into airport values('PRG','Prague, Czechoslovakia');
insert into airport values('PRH','Phrae, Thailand');
insert into airport values('PRI','Praslin Is., Seychelles Is, In');
insert into airport values('PRJ','Capri, Italy');
insert into airport values('PRK','Prieska, South Africa');
insert into airport values('PRL','Port Oceanic, Alaska, Usa');
insert into airport values('PRM','Portimao, Portugal');
insert into airport values('PRN','Pristina, Yugoslavia');
insert into airport values('PRP','Propriano, Corsica, France');
insert into airport values('PRQ','Pres. Roque Saenz Pena, Ch, Ar');
insert into airport values('PRR','Paruima, Guyana');
insert into airport values('PRS','Parasi, Solomon Islands');
insert into airport values('PRU','Prome, Myanmar');
insert into airport values('PRV','Prerov, Czechoslovakia');
insert into airport values('PRW','Prentice, Wisconsin, Usa');
insert into airport values('PRX','Paris, Texas, Usa');
insert into airport values('PRY','Pretoria, South Africa');
insert into airport values('PRZ','Prineville, Oregon, Usa');
insert into airport values('PSA','Pisa, Italy');
insert into airport values('PSC','Pasco, Washington, Usa');
insert into airport values('PSD','Port Said, Arab Rep. Of Egypt');
insert into airport values('PSE','Ponce, Puerto Rico');
insert into airport values('PSF','Pittsfield, Massachusetts, Usa');
insert into airport values('PSG','Petersburg, Alaska, Usa');
insert into airport values('PSH','St. Peter/Ording, Fed. Rep. Ge');
insert into airport values('PSI','Pasni, Pakistan');
commit;
insert into airport values('PSJ','Poso, Indonesia');
insert into airport values('PSK','Pulaski, Virginia, Usa');
insert into airport values('PSL','Perth, Scotland Uk');
insert into airport values('PSO','Pasto, Colombia');
insert into airport values('PSP','Palm Springs, California,-Psp');
insert into airport values('PSR','Pescara, Italy');
insert into airport values('PSS','Posadas, Mi, Argentina');
insert into airport values('PST','Preston, Cuba');
insert into airport values('PSU','Putussibau, Indonesia');
insert into airport values('PSW','Passos, Mg, Brazil');
insert into airport values('PSX','Palacios, Texas, Usa');
insert into airport values('PSY','Port Stanley, Falkland Islands');
insert into airport values('PSZ','Puerto Suarez, Bolivia');
insert into airport values('PTA','Port Alsworth, Alaska, Usa');
insert into airport values('PTB','Petersburg, Virginia, Usa');
insert into airport values('PTC','Port Alice, Alaska, Usa');
insert into airport values('PTD','Port Alexander, Alaska, Usa');
insert into airport values('PTE','Port Stephens, Nsw, Australia');
insert into airport values('PTF','Malololailai, Fiji');
insert into airport values('PTG','Pietersburg, South Africa');
insert into airport values('PTH','Port Heiden, Alaska, Usa');
insert into airport values('PTI','Port Douglas, Qld, Australia');
insert into airport values('PTJ','Portland, Vic, Australia');
insert into airport values('PTK','Pontiac, Michigan, Usa');
insert into airport values('PTL','Port Armstrong, Alaska, Usa');
insert into airport values('PTM','Palmarito, Venezuela');
insert into airport values('PTN','Morgan City/Patterson, La, Usa');
insert into airport values('PTO','Pato Branco, Pr, Brazil');
insert into airport values('PTP','Pointe A Pitre, Guadeloupe');
insert into airport values('PTQ','Porto De Moz, Pa, Brazil');
commit;
insert into airport values('PTR','Pleasant Harbor, Alaska, Usa');
insert into airport values('PTS','Pittsburg, Kansas, Usa');
insert into airport values('PTT','Pratt, Kansas, Usa');
insert into airport values('PTU','Platinum, Alaska, Usa');
insert into airport values('PTV','Porterville, California, Usa');
insert into airport values('PTW','Pottstown, Pennsylvania, Usa');
insert into airport values('PTX','Pitalito, Colombia');
insert into airport values('PTY','Panama City, Panama Re-Torrijo');
insert into airport values('PTZ','Pastaza, Ecuador');
insert into airport values('PUA','Puas, Papua New Guinea');
insert into airport values('PUB','Pueblo, Colorado, Usa');
insert into airport values('PUC','Price, Utah, Usa');
insert into airport values('PUD','Puerto Deseado, Sc, Argentina');
insert into airport values('PUE','Puerto Obaldia, Panama Republi');
insert into airport values('PUF','Pau, France');
insert into airport values('PUG','Port Augusta, Sa, Australia');
insert into airport values('PUH','Pochutla, Mexico');
insert into airport values('PUI','Pureni, Papua New Guinea');
insert into airport values('PUJ','Punta Cana, Dominican Rep.');
insert into airport values('PUK','Pukarua, French Polynesia');
insert into airport values('PUL','Poulsbo, Washington, Usa');
insert into airport values('PUM','Pomalaa, Indonesia');
insert into airport values('PUN','Punia, Zaire');
insert into airport values('PUP','Po, Burkina Faso');
insert into airport values('PUQ','Punta Arenas, Chile');
insert into airport values('PUR','Puerto Rico, Bolivia');
insert into airport values('PUS','Pusan, Republic Of Korea');
insert into airport values('PUU','Puerto Asis, Colombia');
insert into airport values('PUW','Pullman, Washington, Usa');
insert into airport values('PUY','Pula, Yugoslavia');
commit;
insert into airport values('PUZ','Puerto Cabezas, Nicaragua');
insert into airport values('PVA','Providencia, Colombia');
insert into airport values('PVC','Provincetown, Massachusetts, U');
insert into airport values('PVD','Providence, Rhode Island, Usa');
insert into airport values('PVE','El Porvenir, Panama Republic');
insert into airport values('PVF','Placerville, California, Usa');
insert into airport values('PVH','Porto Velho, Ro, Brazil');
insert into airport values('PVI','Paranavai, Pr, Brazil');
insert into airport values('PVK','Preveza/Lefkas, Greece');
insert into airport values('PVN','Pleven, Bulgaria');
insert into airport values('PVO','Portoviejo, Ecuador');
insert into airport values('PVR','Puerto Vallarta, Mexico');
insert into airport values('PVS','Provideniya, Siberia, Ussr');
insert into airport values('PVU','Provo, Utah, Usa');
insert into airport values('PVW','Plainview, Texas, Usa');
insert into airport values('PVX','Provedenia, Ussr');
insert into airport values('PVY','Pope Vanoy, Alaska, Usa');
insert into airport values('PVZ','Painesville, Ohio, Usa');
insert into airport values('PWA','Oklahoma City, Oklahom-Post');
insert into airport values('PWD','Plentywood, Montana, Usa');
insert into airport values('PWE','Pewek, Ussr');
insert into airport values('PWI','Pawi, Ethiopia');
insert into airport values('PWK','Chicago, Illinois, Usa-Pal Wau');
insert into airport values('PWL','Purwokerto, Indonesia');
insert into airport values('PWM','Portland, Maine, Usa');
insert into airport values('PWN','Pitts Town, Crooked Island, Ba');
insert into airport values('PWO','Pweto, Zaire');
insert into airport values('PWQ','Pavlodar, Ussr');
insert into airport values('PWR','Port Walter, Alaska, Usa');
insert into airport values('PWT','Bremerton, Washington, Usa');
commit;
insert into airport values('PXL','Polacca, Arizona, Usa');
insert into airport values('PXM','Puerto Escondido, Mexico');
insert into airport values('PXO','Porto Santo, Portugal (Madeira');
insert into airport values('PXU','Pleiku, Soc. Rep. Of Viet Nam');
insert into airport values('PYA','Puerto Boyaca, Colombia');
insert into airport values('PYB','Jeypore, India');
insert into airport values('PYC','Playon Chico, Panama Republic');
insert into airport values('PYE','Penrhyn Island, Cook Is, S. Pa');
insert into airport values('PYH','Puerto Ayacucho, Venezuela');
insert into airport values('PYJ','Polyarnyj, Ussr');
insert into airport values('PYL','Perry Island, Alaska, Usa');
insert into airport values('PYM','Plymouth, Massachusetts, Usa');
insert into airport values('PYN','Payan, Colombia');
insert into airport values('PYO','Putumayo, Ecuador');
insert into airport values('PYR','Pyrgos, Greece');
insert into airport values('PYV','Yaviza, Panama Republic');
insert into airport values('PYX','Pattaya, Thailand');
insert into airport values('PZA','Paz De Ariporo, Colombia');
insert into airport values('PZB','Pietermaritzburg, South Africa');
insert into airport values('PZE','Penzance, England Uk');
insert into airport values('PZH','Zhob, Pakistan');
insert into airport values('PZO','Puerto Ordaz, Venezuela');
insert into airport values('PZU','Port Sudan, Sudan');
insert into airport values('PZY','Piestany, Czechoslovakia');
insert into airport values('QBC','Bella Coola, Bc, Canada');
insert into airport values('QBE','Bega, Nsw, Australia');
insert into airport values('QBW','Batemans Bay, Nsw, Australia');
insert into airport values('QCE','Copper Mountain, Colorado, Usa');
insert into airport values('QDN','Eden, Nsw, Australia');
insert into airport values('QDU','Duesseldorf, Fed. Rep.-Main Rr');
commit;
insert into airport values('QFE','Columbus, Georgia, Usa-Ft Benn');
insert into airport values('QJD','Jindabyne, Nsw, Australia');
insert into airport values('QKB','Breckenridge, Colorado, Usa');
insert into airport values('QKL','Cologne/Bonn, Fed. Rep-Main Rr');
insert into airport values('QKS','Keystone, Colorado, Usa');
insert into airport values('QLE','Leeton, Nsw, Australia');
insert into airport values('QMM','Marina Di Massa, Italy');
insert into airport values('QND','Novi Sad, Yugoslavia');
insert into airport values('QPV','Perisher Valley, Nsw, Australi');
insert into airport values('QRM','Narromine, Nsw, Australia');
insert into airport values('QRO','Queretaro, Mexico');
insert into airport values('QRR','Warren, Nsw, Australia');
insert into airport values('QRX','Narooma, Nsw, Australia');
insert into airport values('QTH','Thredbo, Nsw, Australia');
insert into airport values('QUB','Ubari, Libyan A Jamahiriya');
insert into airport values('QVU','Viru, Solomon Islands');
insert into airport values('QWP','Winter Park, Colorado, Usa');
insert into airport values('QXD','Cachoeiro Itapemirim, Es, Braz');
insert into airport values('QXE','Sora, Italy');
insert into airport values('QYN','Byron Bay, Nsw, Australia');
insert into airport values('QZC','Smiggin Holes, Nsw, Australia');
insert into airport values('RAA','Rakanda, Papua New Guinea');
insert into airport values('RAB','Rabaul, Papua New Guinea');
insert into airport values('RAC','Racine, Wisconsin, Usa');
insert into airport values('RAE','Arar, Saudi Arabia');
insert into airport values('RAF','Ras An Naqb, Arab Rep. Of Egyp');
insert into airport values('RAG','Raglan, New Zealand');
insert into airport values('RAH','Rafha, Saudi Arabia');
insert into airport values('RAI','Praia, Cape Verde Islands');
insert into airport values('RAJ','Rajkot, India');
commit;
insert into airport values('RAK','Marrakech, Morocco');
insert into airport values('RAL','Riverside, California, Usa');
insert into airport values('RAM','Ramingining, Nt, Australia');
insert into airport values('RAN','Ravenna, Italy');
insert into airport values('RAO','Ribeirao Preto, Sp, Brazil');
insert into airport values('RAP','Rapid City, South Dakota, Usa');
insert into airport values('RAQ','Raha, Indonesia');
insert into airport values('RAR','Rarotonga, Cook Is., South Pac');
insert into airport values('RAS','Rasht, Iran, Islamic Rep. Of');
insert into airport values('RAU','Rangpur, Bangladesh');
insert into airport values('RAV','Cravo Norte, Colombia');
insert into airport values('RAW','Arawa, Papua New Guinea');
insert into airport values('RAX','Oram, Papua New Guinea');
insert into airport values('RAY','Rothesay, Scotland Uk');
insert into airport values('RAZ','Rawala Kot, Pakistan');
insert into airport values('RBA','Rabat, Morocco');
insert into airport values('RBB','Borba, Am, Brazil');
insert into airport values('RBC','Robinvale, Vic, Australia');
insert into airport values('RBF','Big Bear, California, Usa');
insert into airport values('RBG','Roseburg, Oregon, Usa');
insert into airport values('RBH','Brooks Lodge, Alaska, Usa');
insert into airport values('RBI','Rabi, Fiji');
insert into airport values('RBJ','Rebun, Japan');
insert into airport values('RBL','Red Bluff, California, Usa');
insert into airport values('RBO','Robore, Bolivia');
insert into airport values('RBP','Rabaraba, Papua New Guinea');
insert into airport values('RBQ','Rurrenabaque, Bolivia');
insert into airport values('RBR','Rio Branco, Ac, Brazil');
insert into airport values('RBS','Orbost, Vic, Australia');
insert into airport values('RBT','Marsabit, Kenya');
commit;
insert into airport values('RBU','Roebourne, Wa, Australia');
insert into airport values('RBW','Walterboro, South Carolina, Us');
insert into airport values('RBY','Ruby, Alaska, Usa');
insert into airport values('RCB','Richards Bay, South Africa');
insert into airport values('RCE','Roche Harbor, Washington, Usa');
insert into airport values('RCH','Riohacha, Colombia');
insert into airport values('RCK','Rockdale, Texas, Usa');
insert into airport values('RCL','Redcliffe, Vanuatu');
insert into airport values('RCM','Richmond, Qld, Australia');
insert into airport values('RCN','American River, Sa, Australia');
insert into airport values('RCO','Rochefort, France');
insert into airport values('RCQ','Reconquista, Sf, Argentina');
insert into airport values('RCS','Rochester, England Uk');
insert into airport values('RCT','Reed City, Michigan, Usa');
insert into airport values('RCU','Rio Cuarto, Cd, Argentina');
insert into airport values('RCY','Rum Cay, Bahamas');
insert into airport values('RDA','Rockhampton Downs, Nt, Austral');
insert into airport values('RDB','Red Dog, Alaska, Usa');
insert into airport values('RDC','Redencao, Pa, Brazil');
insert into airport values('RDD','Redding, California, Usa');
insert into airport values('RDE','Merdey, Indonesia');
insert into airport values('RDG','Reading, Pennsylvania, Usa');
insert into airport values('RDM','Redmond, Oregon, Usa');
insert into airport values('RDT','Richard-Toll, Senegal');
insert into airport values('RDU','Raleigh/Durham, North Carolina');
insert into airport values('RDV','Red Devil, Alaska, Usa');
insert into airport values('RDZ','Rodez, France');
insert into airport values('REA','Reao, French Polynesia');
insert into airport values('REC','Recife, Pe, Brazil');
insert into airport values('RED','Reedsville, Pennsylvania, Usa');
commit;
insert into airport values('REG','Reggio Calabria, Italy');
insert into airport values('REH','Rehoboth Beach, Delaware, Usa');
insert into airport values('REI','Regina, Fr. Guiana');
insert into airport values('REK','Reykjavik, Iceland-Domestic');
insert into airport values('REL','Trelew, Cb, Argentina');
insert into airport values('REN','Orenburg, Ussr');
insert into airport values('REO','Rome, Oregon, Usa');
insert into airport values('REP','Siem Reap, Cambodia');
insert into airport values('RES','Resistencia, Ch, Argentina');
insert into airport values('RET','Rost, Norway');
insert into airport values('REU','Reus, Spain');
insert into airport values('REW','Rewa, India');
insert into airport values('REX','Reynosa, Mexico');
insert into airport values('REY','Reyes, Bolivia');
insert into airport values('RFA','Rafai, Cen. African Republic');
insert into airport values('RFD','Rockford, Illinois, Usa');
insert into airport values('RFK','Anguilla, Mississippi, Usa');
insert into airport values('RFN','Raufarhofn, Iceland');
insert into airport values('RFP','Raiatea, French Polynesia');
insert into airport values('RFR','Rio Frio, Costa Rica');
insert into airport values('RGA','Rio Grande, Tf, Argentina');
insert into airport values('RGE','Porgera, Papua New Guinea');
insert into airport values('RGH','Balurghat, India');
insert into airport values('RGI','Rangiroa, French Polynesia');
insert into airport values('RGL','Rio Gallegos, Sc, Argentina');
insert into airport values('RGN','Yangon, Myanmar');
insert into airport values('RGR','Ranger, Texas, Usa');
insert into airport values('RGT','Rengat, Indonesia');
insert into airport values('RHA','Reykholar, Iceland');
insert into airport values('RHD','Rio Hondo, Se, Argentina');
commit;
insert into airport values('RHE','Reims, France');
insert into airport values('RHG','Ruhengeri, Rwanda');
insert into airport values('RHI','Rhinelander, Wisconsin, Usa');
insert into airport values('RHL','Roy Hill, Wa, Australia');
insert into airport values('RHO','Rhodes, Greece');
insert into airport values('RHP','Ramechap, Nepal');
insert into airport values('RIA','Santa Maria, Rs, Brazil');
insert into airport values('RIB','Riberalta, Bolivia');
insert into airport values('RIC','Richmond/Wmbg, Virginia, Usa');
insert into airport values('RID','Richmond, Indiana, Usa');
insert into airport values('RIE','Rice Lake, Wisconsin, Usa');
insert into airport values('RIF','Richfield, Utah, Usa');
insert into airport values('RIG','Rio Grande, Rs, Brazil');
insert into airport values('RIJ','Rioja, Peru');
insert into airport values('RIL','Rifle, Colorado, Usa');
insert into airport values('RIN','Ringi Cove, Solomon Islands');
insert into airport values('RIO','Rio De Janeiro, Rj, Br-Intl');
insert into airport values('RIS','Rishiri, Japan');
insert into airport values('RIT','Rio Tigre, Panama Republic');
insert into airport values('RIW','Riverton, Wyoming, Usa');
insert into airport values('RIX','Riga, Ussr-Spilve');
insert into airport values('RIY','Riyan, Yemen, Republic Of');
insert into airport values('RIZ','Rio Alzucar, Panama Republic');
insert into airport values('RJA','Rajahmundry, India');
insert into airport values('RJB','Rajbiraj, Nepal');
insert into airport values('RJH','Rajshahi, Bangladesh');
insert into airport values('RJI','Rajouri, India');
insert into airport values('RJK','Rijeka, Yugoslavia');
insert into airport values('RKC','Yreka, California, Usa');
insert into airport values('RKD','Rockland, Maine, Usa');
commit;
insert into airport values('RKE','Copenhagen, Denmark-Roskilde');
insert into airport values('RKH','Rock Hill, South Carolina, Usa');
insert into airport values('RKI','Rokot, Indonesia');
insert into airport values('RKO','Sipora, Indonesia');
insert into airport values('RKP','Rockport, Texas, Usa');
insert into airport values('RKR','Poteau, Oklahoma, Usa');
insert into airport values('RKS','Rock Springs, Wyoming, Usa');
insert into airport values('RKT','Ras Al Khaimah, U. A. Emirates');
insert into airport values('RKU','Yule Island, Papua New Guinea');
insert into airport values('RKW','Rockwood, Tennessee, Usa');
insert into airport values('RKY','Rokeby, Qld, Australia');
insert into airport values('RLA','Rolla, Missouri, Usa');
insert into airport values('RLD','Richland, Washington, Usa');
insert into airport values('RLP','Rosella Plains, Qld, Australia');
insert into airport values('RLT','Arlit, Niger');
insert into airport values('RLU','Bornite, Alaska, Usa');
insert into airport values('RMA','Roma, Qld, Australia');
insert into airport values('RMB','Buraimi, Oman');
insert into airport values('RMD','Ramagundam, India');
insert into airport values('RMG','Rome, Georgia, Usa');
insert into airport values('RMI','Rimini, Italy');
insert into airport values('RMK','Renmark, Sa, Australia');
insert into airport values('RMN','Rumginae, Papua New Guinea');
insert into airport values('RMP','Rampart, Alaska, Usa');
insert into airport values('RMS','Ramstein, Fed. Rep. Of Germany');
insert into airport values('RNB','Ronneby, Sweden');
insert into airport values('RNE','Roanne, France');
insert into airport values('RNG','Rangely, Colorado, Usa');
insert into airport values('RNH','New Richmond, Wisconsin, Usa');
insert into airport values('RNI','Corn Island, Nicaragua');
commit;
insert into airport values('RNJ','Yoron-Jima, Japan');
insert into airport values('RNL','Rennell Island, Solomon Island');
insert into airport values('RNN','Ronne, Denmark');
insert into airport values('RNO','Reno, Nevada, Usa');
insert into airport values('RNP','Rongelap, Marshall Islands');
insert into airport values('RNR','Robinson River, Papua New Guin');
insert into airport values('RNS','Rennes, France');
insert into airport values('RNT','Renton, Washington, Usa');
insert into airport values('RNU','Ranau, Sabah, Malaysia');
insert into airport values('RNZ','Rensselaer, Indiana, Usa');
insert into airport values('ROA','Roanoke, Virginia, Usa');
insert into airport values('ROB','Monrovia, Liberia-Roberts');
insert into airport values('ROC','Rochester, New York, Usa');
insert into airport values('ROD','Robertson, South Africa');
insert into airport values('ROG','Rogers, Arkansas, Usa');
insert into airport values('ROH','Robinhood, Qld, Australia');
insert into airport values('ROK','Rockhampton, Qld, Australia');
insert into airport values('ROL','Roosevelt, Utah, Usa');
insert into airport values('ROM','Rome, Italy-Da Vinci');
insert into airport values('RON','Rondon, Colombia');
insert into airport values('ROO','Rondonopolis, Mt, Brazil');
insert into airport values('ROP','Rota, Mariana Islands');
insert into airport values('ROR','Koror, Palau Island, Pacific O');
insert into airport values('ROS','Rosario, Sf, Argentina');
insert into airport values('ROT','Rotorua, New Zealand');
insert into airport values('ROU','Rousse, Bulgaria');
insert into airport values('ROV','Rostov, Ussr');
insert into airport values('ROW','Roswell, New Mexico, Usa');
insert into airport values('ROY','Rio Mayo, Cb, Argentina');
insert into airport values('RPA','Rolpa, Nepal');
commit;
insert into airport values('RPB','Roper Bar, Nt, Australia');
insert into airport values('RPM','Ngukurr, Nt, Australia');
insert into airport values('RPN','Rosh-Pina, Galilee, Israel');
insert into airport values('RPR','Raipur, India');
insert into airport values('RPV','Roper Valley, Nt, Australia');
insert into airport values('RPX','Roundup, Montana, Usa');
insert into airport values('RRE','Marree, Sa, Australia');
insert into airport values('RRG','Rodrigues Is., Mauritius');
insert into airport values('RRI','Barora, Solomon Islands');
insert into airport values('RRK','Rourkela, India');
insert into airport values('RRN','Serra Norte, Pa, Brazil');
insert into airport values('RRS','Roros, Norway');
insert into airport values('RRV','Robinson River, Nt, Australia');
insert into airport values('RSA','Santa Rosa, Lp, Argentina');
insert into airport values('RSB','Roseberth, Qld, Australia');
insert into airport values('RSC','Riga, Ussr-Skulte');
insert into airport values('RSD','Rock Sound, Bahamas');
insert into airport values('RSE','Sydney, Nsw, Australia-Rose Ba');
insert into airport values('RSG','Serra Pelada, Pa, Brazil');
insert into airport values('RSH','Russian Mission, Alaska, Usa');
insert into airport values('RSI','Rio Sidra, Panama Republic');
insert into airport values('RSJ','Rosario, Washington, Usa');
insert into airport values('RSK','Ransiki, Indonesia');
insert into airport values('RSL','Russell, Kansas, Usa');
insert into airport values('RSN','Ruston, Louisiana, Usa');
insert into airport values('RSP','Raspberry Strait, Alaska, Usa');
insert into airport values('RSS','Roseires, Sudan');
insert into airport values('RST','Rochester, Minnesota, Usa');
insert into airport values('RSU','Yosu, Republic Of Korea');
insert into airport values('RSW','Fort Myers, Florida, U-Regiona');
commit;
insert into airport values('RSX','Rouses Point, New York, Usa');
insert into airport values('RTA','Rotuma, Fiji');
insert into airport values('RTB','Roatan, Honduras');
insert into airport values('RTC','Ratnagiri, India');
insert into airport values('RTD','Rotunda, Florida, Usa');
insert into airport values('RTE','Marguerite Bay, Alaska, Usa');
insert into airport values('RTG','Ruteng, Indonesia');
insert into airport values('RTI','Roti, Indonesia');
insert into airport values('RTL','Spirit Lake, Iowa, Usa');
insert into airport values('RTM','Rotterdam, Netherlands');
insert into airport values('RTN','Raton, New Mexico, Usa');
insert into airport values('RTP','Rutland Plains, Qld, Australia');
insert into airport values('RTS','Rottnest Is., Wa, Australia');
insert into airport values('RTW','Saratov, Ussr');
insert into airport values('RTY','Merty, Sa, Australia');
insert into airport values('RUA','Arua, Uganda');
insert into airport values('RUH','Riyadh, Saudi Arabia');
insert into airport values('RUI','Ruidoso, New Mexico, Usa');
insert into airport values('RUK','Rukumkot, Nepal');
insert into airport values('RUM','Rumjartar, Nepal');
insert into airport values('RUN','St. Denis De La Reunion, Ind.');
insert into airport values('RUP','Rupsi, India');
insert into airport values('RUR','Rurutu, French Polynesia');
insert into airport values('RUS','Marau, Solomon Islands');
insert into airport values('RUT','Rutland, Vermont, Usa');
insert into airport values('RUU','Ruti, Papua New Guinea');
insert into airport values('RUV','Rubelsanto, Guatemala');
insert into airport values('RUY','Copan, Honduras');
insert into airport values('RVA','Farafangana, Dem. Rep. Madagas');
insert into airport values('RVC','Rivercess, Liberia');
commit;
insert into airport values('RVE','Saravena, Colombia');
insert into airport values('RVK','Roervik, Norway');
insert into airport values('RVN','Rovaniemi, Finland');
insert into airport values('RVO','Reivilo, South Africa');
insert into airport values('RVR','Green River, Utah, Usa');
insert into airport values('RVS','Tulsa, Oklahoma, Usa-Jones');
insert into airport values('RVY','Rivera, Uruguay');
insert into airport values('RWB','Rowan Bay, Alaska, Usa');
insert into airport values('RWF','Redwood Falls, Minnesota, Usa');
insert into airport values('RWI','Rocky Mount/Wilson, Nc, Usa');
insert into airport values('RWL','Rawlins, Wyoming, Usa');
insert into airport values('RWN','Rovno, Ussr');
insert into airport values('RXA','Raudha, Yemen, Republic Of');
insert into airport values('RXS','Roxas City, Philippines');
insert into airport values('RYB','Rybinsk, Ussr');
insert into airport values('RYK','Rahim Yar Khan, Pakistan');
insert into airport values('RYN','Royan, France');
insert into airport values('RYO','Rio Turbio, Sc, Argentina');
insert into airport values('RZA','Santa Cruz, Sc, Argentina');
insert into airport values('RZE','Rzeszow, Poland');
insert into airport values('RZN','Ryazan, Ussr');
insert into airport values('RZR','Ramsar, Iran, Islamic Rep. Of');
insert into airport values('RZZ','Roanoke Rapids, North Carolina');
insert into airport values('SAA','Saratoga, Wyoming, Usa');
insert into airport values('SAB','Saba, Neth. Antilles');
insert into airport values('SAC','Sacramento, California-Executi');
insert into airport values('SAD','Safford, Arizona, Usa');
insert into airport values('SAE','Sangir, Indonesia');
insert into airport values('SAF','Santa Fe, New Mexico, Usa-Saf');
insert into airport values('SAG','Sagwon, Alaska, Usa');
commit;
insert into airport values('SAH','Sanaa, Yemen, Republic Of');
insert into airport values('SAI','San Marino, San Marino');
insert into airport values('SAJ','Sirajganj, Bangladesh');
insert into airport values('SAK','Saudarkrokur, Iceland');
insert into airport values('SAL','San Salvador, El Salvador');
insert into airport values('SAM','Salamo, Papua New Guinea');
insert into airport values('SAN','San Diego, California-Lindberg');
insert into airport values('SAO','Sao Paulo, Sp, Brazil-Guarulho');
insert into airport values('SAP','San Pedro Sula, Honduras');
insert into airport values('SAQ','San Andros, Bahamas');
insert into airport values('SAR','Sparta, Illinois, Usa');
insert into airport values('SAS','Salton City, California, Usa');
insert into airport values('SAT','San Antonio, Texas, Usa');
insert into airport values('SAU','Sawu, Indonesia');
insert into airport values('SAV','Savannah, Georgia, Usa');
insert into airport values('SAX','Sambu, Panama Republic');
insert into airport values('SAY','Siena, Italy');
insert into airport values('SAZ','Sasstown, Liberia');
insert into airport values('SBA','Santa Barbara, California, Usa');
insert into airport values('SBB','Santa Barbara, Barinas, Venezu');
insert into airport values('SBC','Selbang, Papua New Guinea');
insert into airport values('SBE','Suabi, Papua New Guinea');
insert into airport values('SBG','Sabang, Indonesia');
insert into airport values('SBH','St. Barthelemy, Guadeloupe');
insert into airport values('SBI','Koundara, Guinea');
insert into airport values('SBJ','Sao Mateus, Es, Brazil');
insert into airport values('SBK','St. Brieuc, France');
insert into airport values('SBL','Santa Ana, Bolivia');
insert into airport values('SBM','Sheboygan, Wisconsin, Usa');
insert into airport values('SBN','South Bend, Indiana, Usa');
commit;
insert into airport values('SBO','Salina, Utah, Usa');
insert into airport values('SBP','San Luis Obispo, California, U');
insert into airport values('SBQ','Sibi, Pakistan');
insert into airport values('SBR','Saibai Island, Qld, Australia');
insert into airport values('SBS','Steamboat Springs, Colorad-Sbs');
insert into airport values('SBT','San Bernardino, California, Us');
insert into airport values('SBU','Springbok, South Africa');
insert into airport values('SBV','Sabah, Papua New Guinea');
insert into airport values('SBW','Sibu, Sarawak, Malaysia');
insert into airport values('SBX','Shelby, Montana, Usa');
insert into airport values('SBY','Salisbury, Maryland, Usa');
insert into airport values('SBZ','Sibiu, Romania');
insert into airport values('SCA','Santa Catalina, Colombia');
insert into airport values('SCB','Scribner, Nebraska, Usa');
insert into airport values('SCC','Prudhoe Bay/Deadhorse, Alaska,');
insert into airport values('SCD','Sulaco, Honduras');
insert into airport values('SCE','State College, Pennsylvania, U');
insert into airport values('SCF','Scottsdale, Arizona, Usa');
insert into airport values('SCG','Spring Creek, Qld, Australia');
insert into airport values('SCI','San Cristobal, Venezuela');
insert into airport values('SCJ','Smith Cove, Alaska, Usa');
insert into airport values('SCK','Stockton, California, Usa');
insert into airport values('SCL','Santiago, Chile');
insert into airport values('SCM','Scammon Bay, Alaska, Usa');
insert into airport values('SCN','Saarbruecken, Fed. Rep. Of Ger');
insert into airport values('SCO','Shevchenko, Ussr');
insert into airport values('SCP','St. Crepin/Vars, France');
insert into airport values('SCQ','Santiago De Compostela, Spain');
insert into airport values('SCS','Shetland Islands, Scot-Scatsta');
insert into airport values('SCT','Socotra, Yemen, Republic Of');
commit;
insert into airport values('SCU','Santiago, Cuba');
insert into airport values('SCV','Suceava, Romania');
insert into airport values('SCW','Syktyvkar, Ussr');
insert into airport values('SCX','Salina Cruz, Mexico');
insert into airport values('SCZ','Santa Cruz, Solomon Islands');
insert into airport values('SDA','Baghdad, Iraq-Saddam');
insert into airport values('SDB','Saldanha Bay, South Africa');
insert into airport values('SDC','Sandcreek, Guyana');
insert into airport values('SDD','Lubango, Angola');
insert into airport values('SDE','Santiago Del Estero, Se, Argen');
insert into airport values('SDF','Louisville, Kentucky, Usa');
insert into airport values('SDG','Sanandaj, Iran, Islamic Rep. O');
insert into airport values('SDH','Santa Rosa De Copan, Honduras');
insert into airport values('SDI','Saidor, Papua New Guinea');
insert into airport values('SDJ','Sendai, Japan');
insert into airport values('SDK','Sandakan, Sabah, Malaysia');
insert into airport values('SDL','Sundsvall, Sweden');
insert into airport values('SDM','San Diego, California-Brownfie');
insert into airport values('SDN','Sandane, Norway');
insert into airport values('SDO','Ryotsu Sado Island, Japan');
insert into airport values('SDP','Sand Point, Alaska, Usa');
insert into airport values('SDQ','Santo Domingo, Dominican Rep.');
insert into airport values('SDR','Santander, Spain');
insert into airport values('SDS','Sado Shima, Japan');
insert into airport values('SDT','Saidu Sharif, Pakistan');
insert into airport values('SDU','Rio De Janeiro, Rj, Br-Dumont');
insert into airport values('SDV','Tel Aviv-Yafo, Israel-Sde Dov');
insert into airport values('SDW','Sandwip, Bangladesh');
insert into airport values('SDX','Sedona, Arizona, Usa');
insert into airport values('SDY','Sidney, Montana, Usa');
commit;
insert into airport values('SDZ','Shetland Islands, Scot-Sumburg');
insert into airport values('SEA','Seattle/Tacoma, Washin-Sea/Tac');
insert into airport values('SEB','Sebha, Libyan A Jamahiriya');
insert into airport values('SEC','Serre Chevalier, France');
insert into airport values('SED','Sedom, Israel');
insert into airport values('SEE','San Diego, California-Gillespi');
insert into airport values('SEF','Sebring, Florida, Usa');
insert into airport values('SEG','Selinsgrove, Pennsylvania, Usa');
insert into airport values('SEH','Senggeh, Indonesia');
insert into airport values('SEI','Senhor Do Bonfim, Ba, Brazil');
insert into airport values('SEJ','Seydisfjordur, Iceland');
insert into airport values('SEK','Ksar Es Souk, Morocco');
insert into airport values('SEL','Seoul, Republic Of Korea');
insert into airport values('SEN','London, England Uk-Southend');
insert into airport values('SEO','Seguela, Cote D''Ivoire');
insert into airport values('SEP','Stephenville, Texas, Usa');
insert into airport values('SEQ','Sungai Pakning, Indonesia');
insert into airport values('SER','Seymour, Indiana, Usa');
insert into airport values('SES','Selma, Alabama, Usa');
insert into airport values('SET','San Esteban, Honduras');
insert into airport values('SEU','Seronera, Tanzania');
insert into airport values('SEV','Severodoneck, Ussr');
insert into airport values('SEW','Siwa, Arab Rep. Of Egypt');
insert into airport values('SEX','Sembach, Fed. Rep. Of Germany');
insert into airport values('SEY','Selibaby, Mauritania');
insert into airport values('SEZ','Mahe Is., Seychelles Is. India');
insert into airport values('SFA','Sfax, Tunisia');
insert into airport values('SFB','Sanford, Florida, Usa');
insert into airport values('SFC','St. Francois, Guadeloupe');
insert into airport values('SFD','San Fernando De Apure, Venezue');
commit;
insert into airport values('SFE','San Fernando, Philippines');
insert into airport values('SFF','Spokane, Washington, U-Felts F');
insert into airport values('SFG','St. Maarten, Neth. Ant-Esperan');
insert into airport values('SFH','San Felipe, Mexico');
insert into airport values('SFI','Safi, Morocco');
insert into airport values('SFJ','Sondre Stromfjord, Greenland');
insert into airport values('SFL','Sao Filipe, Cape Verde Islands');
insert into airport values('SFM','Sanford, Maine, Usa');
insert into airport values('SFN','Santa Fe, Sf, Argentina');
insert into airport values('SFP','Surfers Paradise, Qld, Austral');
insert into airport values('SFQ','Sanliurfa, Turkey');
insert into airport values('SFT','Skelleftea, Sweden');
insert into airport values('SFU','Safia, Papua New Guinea');
insert into airport values('SFV','Santa Fe Do Sul, Sp, Brazil');
insert into airport values('SFW','Santa Fe, Panama Republic');
insert into airport values('SFX','San Felix, Venezuela');
insert into airport values('SGA','Sheghnan, Dem. Rep. Of Afghani');
insert into airport values('SGB','Singaua, Papua New Guinea');
insert into airport values('SGC','Surgut, Ussr');
insert into airport values('SGD','Sonderborg, Denmark');
insert into airport values('SGF','Springfield, Missouri, Usa');
insert into airport values('SGG','Simanggang, Sarawak, Malaysia');
insert into airport values('SGI','Sargodha, Pakistan');
insert into airport values('SGJ','Sagarai, Papua New Guinea');
insert into airport values('SGK','Sangapi, Papua New Guinea');

insert into airport values('SGM','San Ignacio, Mexico');
insert into airport values('SGN','Ho Chi Minh, Soc. Rep. Of Viet');
insert into airport values('SGO','St. George, Qld, Australia');
commit;
insert into airport values('SGP','Shay Gap, Wa, Australia');
insert into airport values('SGQ','Sanggata, Indonesia');
insert into airport values('SGR','Sugar Land, Texas, Usa');
insert into airport values('SGS','Sanga Sanga, Philippines');
insert into airport values('SGT','Stuttgart, Arkansas, Usa');
insert into airport values('SGU','St. George, Utah, Usa');
insert into airport values('SGV','Sierra Grande, Rn, Argentina');
insert into airport values('SGW','Saginaw, Alaska, Usa');
insert into airport values('SGX','Songea, Tanzania');
insert into airport values('SGY','Skagway, Alaska, Usa');
insert into airport values('SGZ','Singora, Thailand');
insert into airport values('SHA','Shanghai, P. R. China');
insert into airport values('SHB','Nakashibetsu, Japan');
insert into airport values('SHC','Indaselassie, Ethiopia');
insert into airport values('SHD','Shenandoah Valley Airport, Va,');
insert into airport values('SHE','Shenyang, P. R. China');
insert into airport values('SHF','Shanhaiguan, P. R. China');
insert into airport values('SHG','Shungnak, Alaska, Usa');
insert into airport values('SHH','Shishmaref, Alaska, Usa');
insert into airport values('SHI','Shimojishima, Japan');
insert into airport values('SHJ','Sharjah, U. A. Emirates');
insert into airport values('SHK','Sehonghong, Lesotho');
insert into airport values('SHL','Shillong, India');
insert into airport values('SHM','Nanki Shirahama, Japan');
insert into airport values('SHN','Shelton, Washington, Usa');
insert into airport values('SHO','Sokcho, Republic Of Korea');
insert into airport values('SHP','Qinhuangdao, P. R. China');
insert into airport values('SHQ','Southport, Qld, Australia');
insert into airport values('SHR','Sheridan, Wyoming, Usa');
insert into airport values('SHS','Shashi, P. R. China');
commit;
insert into airport values('SHT','Shepparton, Vic, Australia');
insert into airport values('SHU','Smith Point, Nt, Australia');
insert into airport values('SHV','Shreveport, Louisiana, Usa');
insert into airport values('SHW','Sharurah, Saudi Arabia');
insert into airport values('SHX','Shageluk, Alaska, Usa');
insert into airport values('SHY','Shinyanga, Tanzania');
insert into airport values('SHZ','Seshute''S, Lesotho');
insert into airport values('SIA','Xi An, P. R. China');
insert into airport values('SIB','Sibiti, Peop. Rep. Of The Cong');
insert into airport values('SIC','Sinop, Turkey');
insert into airport values('SID','Sal, Cape Verde Islands');
insert into airport values('SIE','Sines, Portugal');
insert into airport values('SIF','Simra, Nepal');
insert into airport values('SIG','San Juan, Puerto Rico-Isla Gra');
insert into airport values('SIH','Silgadi Doti, Nepal');
insert into airport values('SII','Sidi Ifni, Morocco');
insert into airport values('SIJ','Siglufjordur, Iceland');
insert into airport values('SIK','Sikeston, Missouri, Usa');
insert into airport values('SIL','Sila, Papua New Guinea');
insert into airport values('SIM','Simbai, Papua New Guinea');
insert into airport values('SIN','Singapore, Singapore-Changi');
insert into airport values('SIO','Smithton, Tasmania, Australia');
insert into airport values('SIP','Simferopol, Ussr');
insert into airport values('SIQ','Singkep, Indonesia');
insert into airport values('SIR','Sion, Switzerland');
insert into airport values('SIS','Sishen, South Africa');
insert into airport values('SIT','Sitka, Alaska, Usa');
insert into airport values('SIU','Siuna, Nicaragua');
insert into airport values('SIV','Sullivan, Indiana, Usa');
insert into airport values('SIX','Singleton, Nsw, Australia');
commit;
insert into airport values('SIY','Montague, California, Usa');
insert into airport values('SIZ','Sissano, Papua New Guinea');
insert into airport values('SJA','San Juan, Peru');
insert into airport values('SJB','San Joaquin, Bolivia');
insert into airport values('SJC','San Jose, California, Usa');
insert into airport values('SJD','Los Cabos, Mexico');
insert into airport values('SJE','San Jose Del Guaviaro, Colombi');
insert into airport values('SJF','St. John, Virgin Islands');
insert into airport values('SJG','San Pedro Jagua, Colombia');
insert into airport values('SJH','San Juan Del Cesar, Colombia');
insert into airport values('SJI','San Jose, Philippines');
insert into airport values('SJJ','Sarajevo, Yugoslavia');
insert into airport values('SJK','Sao Jose Dos Campos, Sp, Brazi');
insert into airport values('SJL','Sao Gabriel, Rs, Brazil');
insert into airport values('SJM','San Juan De La M., Dominican R');
insert into airport values('SJN','St. Johns, Arizona, Usa');
insert into airport values('SJO','San Jose, Costa Rica');
insert into airport values('SJP','Sao Jose Do Rio Preto, Sp, Bra');
insert into airport values('SJQ','Sesheke, Zambia');
insert into airport values('SJR','San Juan De Uraba, Colombia');
insert into airport values('SJS','San Jose, Bolivia');
insert into airport values('SJT','San Angelo, Texas, Usa');
insert into airport values('SJU','San Juan, Puerto Rico-Marin In');
insert into airport values('SJV','San Javier, Bolivia');
insert into airport values('SJW','Shijiazhuang, P. R. China');
insert into airport values('SJX','Sartaneja, Belize');
insert into airport values('SJY','Seinajoki, Finland');
insert into airport values('SJZ','San Jorge Island, Portugal (Az');
insert into airport values('SKB','St. Kitts, Leeward Islands');
insert into airport values('SKC','Suki, Papua New Guinea');
commit;
insert into airport values('SKD','Samarkand, Ussr');
insert into airport values('SKE','Skien, Norway');
insert into airport values('SKG','Thessaloniki, Greece');
insert into airport values('SKH','Surkhet, Nepal');
insert into airport values('SKI','Skikda, Algeria');
insert into airport values('SKJ','Sitkinak, Alaska, Usa');
insert into airport values('SKK','Shaktoolik, Alaska, Usa');
insert into airport values('SKL','Isle Of Skye, Scotland Uk');
insert into airport values('SKM','Skeldon, Guyana');
insert into airport values('SKN','Stokmarknes, Norway');
insert into airport values('SKO','Sokoto, Nigeria');
insert into airport values('SKP','Skopje, Yugoslavia');
insert into airport values('SKQ','Sekakes, Lesotho');
insert into airport values('SKR','Shakiso, Ethiopia');
insert into airport values('SKS','Vojens, Denmark');
insert into airport values('SKT','Sialkot, Pakistan');
insert into airport values('SKU','Skiros, Greece');
insert into airport values('SKV','Santa Katarina, Arab Rep. Of E');
insert into airport values('SKW','Skwentna, Alaska, Usa');
insert into airport values('SKX','Saransk, Ussr');
insert into airport values('SKY','Sandusky, Ohio, Usa');
insert into airport values('SKZ','Sukkur, Pakistan');
insert into airport values('SLA','Salta, Sa, Argentina');
insert into airport values('SLB','Storm Lake, Iowa, Usa');
insert into airport values('SLC','Salt Lake City, Utah, Usa');
insert into airport values('SLD','Sliac, Czechoslovakia');
insert into airport values('SLE','Salem, Oregon, Usa');
insert into airport values('SLF','Sulayel, Saudi Arabia');
insert into airport values('SLG','Siloam Springs, Arkansas, Usa');
insert into airport values('SLH','Sola, Vanuatu');
commit;
insert into airport values('SLI','Solwezi, Zambia');
insert into airport values('SLJ','Chandler, Arizona, Usa-Stellar');
insert into airport values('SLK','Saranac Lake, New York, Usa');
insert into airport values('SLL','Salalah, Oman');
insert into airport values('SLM','Salamanca, Spain');
insert into airport values('SLN','Salina, Kansas, Usa');
insert into airport values('SLO','Salem, Illinois, Usa');
insert into airport values('SLP','San Luis Potosi, Mexico');
insert into airport values('SLQ','Sleetmute, Alaska, Usa');
insert into airport values('SLR','Sulphur Springs, Texas, Usa');
insert into airport values('SLS','Silistra, Bulgaria');
insert into airport values('SLT','Salida, Colorado, Usa');
insert into airport values('SLU','St. Lucia, West Indies-Vigie F');
insert into airport values('SLV','Simla, India');
insert into airport values('SLW','Saltillo, Mexico');
insert into airport values('SLX','Salt Cay, Turks & Caicos Is');
insert into airport values('SLY','Salehard, Ussr');
insert into airport values('SLZ','Sao Luiz, Ma, Brazil');
insert into airport values('SMA','Santa Maria, Portugal (Azores)');
insert into airport values('SMB','Cerro El Sombrero, Chile');
insert into airport values('SMC','Santa Maria, Colombia');
insert into airport values('SME','Somerset, Kentucky, Usa');
insert into airport values('SMF','Sacramento, California-Metro');
insert into airport values('SMG','Santa Maria, Peru');
insert into airport values('SMH','Sapmanga, Papua New Guinea');
insert into airport values('SMI','Samos Island, Greece');
insert into airport values('SMJ','Sim, Papua New Guinea');
insert into airport values('SMK','St. Michael, Alaska, Usa');
insert into airport values('SML','Stella Maris, Long Island, Bah');
insert into airport values('SMM','Semporna, Sabah, Malaysia');
commit;
insert into airport values('SMN','Salmon, Idaho, Usa');
insert into airport values('SMP','Stockholm, Papua New Guinea');
insert into airport values('SMQ','Sampit, Indonesia');
insert into airport values('SMR','Santa Marta, Colombia');
insert into airport values('SMS','St. Marie, Dem. Rep. Madagasca');
insert into airport values('SMT','Sun Moon Lake, Taiwan');
insert into airport values('SMU','Sheep Mountain, Alaska, Usa');
insert into airport values('SMV','St. Moritz, Switzerland');
insert into airport values('SMW','Smara, Morocco');
insert into airport values('SMX','Santa Maria, California, Usa');
insert into airport values('SMY','Simenti, Senegal');
insert into airport values('SMZ','Stoelmanseiland, Rep. Of Surin');
insert into airport values('SNA','Orange County, Califor-Wayne I');
insert into airport values('SNB','Snake Bay, Nt, Australia');
insert into airport values('SNC','Salinas, Ecuador');
insert into airport values('SND','Seno, Laos');
insert into airport values('SNE','Sao Nicolau, Cape Verde Island');
insert into airport values('SNF','San Felipe, Venezuela');
insert into airport values('SNG','San Ignacio De Velasco, Bolivi');
insert into airport values('SNH','Stanthorpe, Qld, Australia');
insert into airport values('SNI','Sinoe, Liberia');
insert into airport values('SNJ','San Julian, Cuba');
insert into airport values('SNK','Snyder, Texas, Usa');
insert into airport values('SNL','Shawnee, Oklahoma, Usa');
insert into airport values('SNM','San Ignacio De Moxos, Bolivia');
insert into airport values('SNN','Shannon, Republic Of Ireland');
insert into airport values('SNO','Sakon Nakhon, Thailand');
insert into airport values('SNP','St. Paul Island, Alaska, Usa');
insert into airport values('SNQ','San Quintin, Mexico');
insert into airport values('SNR','St. Nazaire, France');
commit;
insert into airport values('SNS','Salinas, California, Usa');
insert into airport values('SNT','Sabana De Torres, Colombia');
insert into airport values('SNU','Santa Clara, Cuba');
insert into airport values('SNV','Santa Elena, Venezuela');
insert into airport values('SNW','Thandwe, Myanmar');
insert into airport values('SNX','Sabana De La Mar, Dominican Re');
insert into airport values('SNY','Sidney, Nebraska, Usa');
insert into airport values('SOB','Saarmelleek, Hungary');
insert into airport values('SOC','Solo City, Indonesia');
insert into airport values('SOD','Sorocaba, Sp, Brazil');
insert into airport values('SOE','Souanke, Peop. Rep. Of The Con');
insert into airport values('SOF','Sofia, Bulgaria');
insert into airport values('SOG','Sogndal, Norway');
insert into airport values('SOH','Solita, Colombia');
insert into airport values('SOI','South Molle Island, Qld, Austr');
insert into airport values('SOJ','Sorkjosen, Norway');
insert into airport values('SOK','Semongkong, Lesotho');
insert into airport values('SOL','Solomon, Alaska, Usa');
insert into airport values('SOM','San Tome, Venezuela');
insert into airport values('SON','Espiritu Santo, Vanuatu');
insert into airport values('SOO','Soderhamn, Sweden');
insert into airport values('SOP','Pinehurst, North Carolina, Usa');
insert into airport values('SOQ','Sorong, Indonesia');
insert into airport values('SOR','Al Thaurah, Syria');
insert into airport values('SOT','Sodankyla, Finland');
insert into airport values('SOU','Southampton, England Uk');
insert into airport values('SOV','Seldovia, Alaska, Usa');
insert into airport values('SOW','Show Low, Arizona, Usa');
insert into airport values('SOX','Sogamoso, Colombia');
insert into airport values('SOY','Stronsay, Scotland Uk');
commit;
insert into airport values('SOZ','Solenzara, France');
insert into airport values('SPC','Santa Cruz La Palma, Canary Is');
insert into airport values('SPD','Saidpur, Bangladesh');
insert into airport values('SPE','Sepulot, Sabah, Malaysia');
insert into airport values('SPF','Spearfish, South Dakota, Usa');
insert into airport values('SPG','Tampa/St. Petersburg-Whitted');
insert into airport values('SPH','Sopu, Papua New Guinea');
insert into airport values('SPI','Springfield, Illinois, Usa');
insert into airport values('SPJ','Sparta, Greece');
insert into airport values('SPK','Sapporo, Japan-Chitose');
insert into airport values('SPN','Saipan, Mariana Islands');
insert into airport values('SPP','Menongue, Angola');
insert into airport values('SPQ','San Pedro, California, Usa');
insert into airport values('SPR','San Pedro, Belize');
insert into airport values('SPS','Wichita Falls, Texas-Sheppard');
insert into airport values('SPT','Sipitang, Sarawak, Malaysia');
insert into airport values('SPU','Split, Yugoslavia');
insert into airport values('SPV','Sepik Plains, Papua New Guinea');
insert into airport values('SPW','Spencer, Iowa, Usa');
insert into airport values('SPY','San Pedro, Cote D''Ivoire');
insert into airport values('SPZ','Springdale, Arkansas, Usa');
insert into airport values('SQB','Santa Ana, Colombia');
insert into airport values('SQC','Southern Cross, Wa, Australia');
insert into airport values('SQE','San Luis De Palenque, Colombia');
insert into airport values('SQF','Solano, Colombia');
insert into airport values('SQG','Sintang, Indonesia');
insert into airport values('SQI','Sterling/Rock Falls, Illinois,');
insert into airport values('SQL','San Carlos, California, Usa');
insert into airport values('SQM','Sao Miguel Do Araguaia, Go, Br');
insert into airport values('SQN','Sanana, Indonesia');
commit;
insert into airport values('SQP','Starcke, Qld, Australia');
insert into airport values('SQR','Soroako, Indonesia');
insert into airport values('SQV','Sequim, Washington, Usa');
insert into airport values('SRA','Santa Rosa, Rs, Brazil');
insert into airport values('SRB','Santa Rosa, Bolivia');
insert into airport values('SRC','Searcy, Arkansas, Usa');
insert into airport values('SRD','San Ramon, Bolivia');
insert into airport values('SRE','Sucre, Bolivia');
insert into airport values('SRG','Semarang, Indonesia');
insert into airport values('SRH','Sarh, Chad');
insert into airport values('SRI','Samarinda, Indonesia');
insert into airport values('SRJ','San Borja, Bolivia');
insert into airport values('SRK','Sierra Leone, Sierra Leone');
insert into airport values('SRL','Santa Rosalia, Mexico');
insert into airport values('SRM','Sandringham, Qld, Australia');
insert into airport values('SRN','Strahan, Tasmania, Australia');
insert into airport values('SRO','Santana Ramos, Colombia');
insert into airport values('SRP','Stord, Norway');
insert into airport values('SRQ','Sarasota/Bradenton, Florida, U');
insert into airport values('SRS','San Marcos, Colombia');
insert into airport values('SRT','Soroti, Uganda');
insert into airport values('SRV','Stony River, Alaska, Usa');
insert into airport values('SRW','Salisbury, North Carolina, Usa');
insert into airport values('SRX','Sert, Libyan A Jamahiriya');
insert into airport values('SRY','Sary, Iran, Islamic Rep. Of');
insert into airport values('SRZ','Santa Cruz, Bolivia');
insert into airport values('SSA','Salvador, Ba, Brazil');
insert into airport values('SSB','St. Croix, Virgin Isla-Spb');
insert into airport values('SSD','San Felipe, Colombia');
insert into airport values('SSE','Sholapur, India');
commit;
insert into airport values('SSG','Malabo, Equatorial Guinea');
insert into airport values('SSH','Sharm El Sheikh, Arab Rep. Of');
insert into airport values('SSI','Brunswick, Georgia, Us-Mc Kinn');
insert into airport values('SSJ','Sandnessjoen, Norway');
insert into airport values('SSK','Sturt Creek, Wa, Australia');
insert into airport values('SSL','Santa Rosalia, Colombia');
insert into airport values('SSM','Sault Ste. Marie, Mich-County');
insert into airport values('SSO','Sao Lourenco, Mg, Brazil');
insert into airport values('SSP','Silver Plains, Qld, Australia');
insert into airport values('SSQ','La Sarre, Quebec, Canada');
insert into airport values('SSR','Sara, Vanuatu');
insert into airport values('SSS','Siassi, Papua New Guinea');
insert into airport values('SST','Santa Teresita, Ba, Argentina');
insert into airport values('SSV','Siasi, Philippines');
insert into airport values('SSW','Stuart Island, Washington, Usa');
insert into airport values('SSY','M''Banza Congo, Angola');
insert into airport values('SSZ','Santos, Sp, Brazil');
insert into airport values('STA','Stauning, Denmark');
insert into airport values('STB','Santa Barbara, Zulia, Venezuel');
insert into airport values('STC','Saint Cloud, Minnesota, Usa');
insert into airport values('STD','Santo Domingo, Venezuela');
insert into airport values('STF','Stephen Island, Qld, Australia');
insert into airport values('STG','St. George Island, Alaska, Usa');
insert into airport values('STH','Strathmore, Qld, Australia');
insert into airport values('STI','Santiago, Dominican Rep.');
insert into airport values('STJ','St. Joseph, Missouri, Usa');
insert into airport values('STK','Sterling, Colorado, Usa');
insert into airport values('STL','St. Louis, Missouri, U-Intl');
insert into airport values('STM','Santarem, Pa, Brazil');
insert into airport values('STN','London, England Uk-Stansted');
commit;
insert into airport values('STO','Stockholm, Sweden-Arlanda');
insert into airport values('STP','Minneapolis/St. Paul-Dntn');
insert into airport values('STQ','St. Marys, Pennsylvania, Usa');
insert into airport values('STR','Stuttgart, Fed. Rep. O-Ecterdi');
insert into airport values('STS','Santa Rosa, California, Usa');
insert into airport values('STT','St. Thomas, Virgin Islands');
insert into airport values('STU','Santa Cruz, Belize');
insert into airport values('STV','Surat, India');
insert into airport values('STW','Stavropol, Ussr');
insert into airport values('STX','St. Croix, Virgin Isla-Hamilto');
insert into airport values('STY','Salto, Uruguay');
insert into airport values('STZ','Santa Terezinha, Mt, Brazil');
insert into airport values('SUA','Stuart, Florida, Usa');
insert into airport values('SUB','Surabaya, Indonesia');
insert into airport values('SUC','Sundance, Wyoming, Usa');
insert into airport values('SUD','Stroud, Oklahoma, Usa');
insert into airport values('SUE','Sturgeon Bay, Wisconsin, Usa');
insert into airport values('SUF','Lamezia Terme, Italy');
insert into airport values('SUG','Surigao, Philippines');
insert into airport values('SUH','Sur, Oman');
insert into airport values('SUI','Sukhumi, Ussr');
insert into airport values('SUJ','Satu Mare, Romania');
insert into airport values('SUK','Samchok, Republic Of Korea');
insert into airport values('SUL','Sui, Pakistan');
insert into airport values('SUM','Sumter, South Carolina, Usa');
insert into airport values('SUN','Sun Valley, Idaho, Usa');
insert into airport values('SUP','Sumenep, Indonesia');
insert into airport values('SUQ','Sucua, Ecuador');
insert into airport values('SUS','St. Louis, Missouri, U-Spirit');
insert into airport values('SUT','Sumbawanga, Tanzania');
commit;
insert into airport values('SUV','Suva, Fiji');
insert into airport values('SUW','Duluth Mn/Superior, Wi-Bong');
insert into airport values('SUX','Sioux City, Iowa, Usa');
insert into airport values('SUY','Sudureyri, Iceland');
insert into airport values('SUZ','Suria, Papua New Guinea');
insert into airport values('SVA','Savoonga, Alaska, Usa');
insert into airport values('SVB','Sambava, Dem. Rep. Madagascar');
insert into airport values('SVC','Silver City, New Mexico, Usa');
insert into airport values('SVD','St. Vincent, Windward Islands');
insert into airport values('SVE','Susanville, California, Usa');
insert into airport values('SVF','Save, Benin');
insert into airport values('SVG','Stavanger, Norway');
insert into airport values('SVH','Statesville, North Carolina, U');
insert into airport values('SVI','San Vincente Del Caguan, Colom');
insert into airport values('SVJ','Svolvaer, Norway');
insert into airport values('SVK','Silver Creek, Belize');
insert into airport values('SVL','Savonlinna, Finland');
insert into airport values('SVM','St. Paul''S Mission, Qld, Austr');
insert into airport values('SVO','Moscow, Ussr-Sheremetye');
insert into airport values('SVP','Kuito, Angola');
insert into airport values('SVQ','Seville, Spain');
insert into airport values('SVR','Svay Rieng, Cambodia');
insert into airport values('SVS','Stevens Village, Alaska, Usa');
insert into airport values('SVU','Savusavu, Fiji');
insert into airport values('SVV','San Salvador De Paul, Venezuel');
insert into airport values('SVW','Sparrevohn, Alaska, Usa');
insert into airport values('SVX','Ekaterinburg, Ussr');
insert into airport values('SVY','Savo, Solomon Islands');
insert into airport values('SVZ','San Antonio, Venezuela');
insert into airport values('SWA','Shantou, P. R. China');
commit;
insert into airport values('SWB','Shaw River, Wa, Australia');
insert into airport values('SWC','Stawell, Vic, Australia');
insert into airport values('SWD','Seward, Alaska, Usa');
insert into airport values('SWE','Siwea, Papua New Guinea');
insert into airport values('SWF','Newburgh, New York, Usa');
insert into airport values('SWG','Satwag, Papua New Guinea');
insert into airport values('SWH','Swan Hill, Vic, Australia');
insert into airport values('SWI','Swindon, England Uk');
insert into airport values('SWJ','South West Bay, Vanuatu');
insert into airport values('SWM','Suia-Missu, Mt, Brazil');
insert into airport values('SWN','Sahiwal, Pakistan');
insert into airport values('SWO','Stillwater, Oklahoma, Usa');
insert into airport values('SWP','Swakopmund, Namibia');
insert into airport values('SWQ','Sumbawa Island, Indonesia');
insert into airport values('SWS','Swansea, Wales Uk');
insert into airport values('SWU','Su Won City, Republic Of Korea');
insert into airport values('SWW','Sweetwater, Texas, Usa');
insert into airport values('SWX','Shakawe, Botswana');
insert into airport values('SWY','Sitiawan, Malaysia');
insert into airport values('SXA','Sialum, Papua New Guinea');
insert into airport values('SXB','Strasbourg, France');
insert into airport values('SXC','Catalina Is., Californ-Avalo V');
insert into airport values('SXD','Sophia Antipolis, France');
insert into airport values('SXE','Sale, Vic, Australia');
insert into airport values('SXF','Berlin, Fed. Rep. Of G-Schoene');
insert into airport values('SXG','Senanga, Zambia');
insert into airport values('SXH','Sehulea, Papua New Guinea');
insert into airport values('SXI','Sirri Island, Iran, Islamic Re');
insert into airport values('SXJ','Shanshan, P. R. China');
insert into airport values('SXK','Saumlaki, Indonesia');
commit;
insert into airport values('SXL','Sligo, Republic Of Ireland');
insert into airport values('SXM','St. Maarten, Neth. Ant-Juliana');
insert into airport values('SXN','Suapan, Botswana');
insert into airport values('SXO','Sao Felix Araguaia, Mt, Brazil');
insert into airport values('SXP','Sheldon Point, Alaska, Usa');
insert into airport values('SXQ','Soldotna, Alaska, Usa');
insert into airport values('SXR','Srinagar, India');
insert into airport values('SXS','Sahabat 16, Malaysia');
insert into airport values('SXT','Taman Negara, Malaysia');
insert into airport values('SXU','Soddu, Ethiopia');
insert into airport values('SXX','Sao Felix Do Xingu, Pa, Brazil');
insert into airport values('SXY','Sidney, New York, Usa');
insert into airport values('SYA','Shemya Is., Alaska, Usa');
insert into airport values('SYB','Seal Bay, Alaska, Usa');
insert into airport values('SYD','Sydney, Nsw, Australia-Kingsfo');
insert into airport values('SYE','Sa''Dah, Yemen, Republic Of');
insert into airport values('SYI','Shelbyville, Tennessee, Usa');
insert into airport values('SYK','Stykkisholmur, Iceland');
insert into airport values('SYM','Simao, P. R. China');
insert into airport values('SYN','Stanton, Minnesota, Usa');
insert into airport values('SYO','Shonai, Japan');
insert into airport values('SYR','Syracuse, New York, Usa');
insert into airport values('SYS','Sunchon, Republic Of Korea');
insert into airport values('SYT','Saint-Yan, France');
insert into airport values('SYU','Sue Island, Qld, Australia');
insert into airport values('SYV','Sylvester, Georgia, Usa');
insert into airport values('SYX','Sanya, P. R. China');
insert into airport values('SYY','Stornoway, Scotland Uk');
insert into airport values('SYZ','Shiraz, Iran, Islamic Rep. Of');
insert into airport values('SZA','Soyo, Angola');
commit;
insert into airport values('SZC','Santa Cruz, Costa Rica');
insert into airport values('SZG','Salzburg, Austria');
insert into airport values('SZH','Senipah, Indonesia');
insert into airport values('SZK','Skukuza, South Africa');
insert into airport values('SZP','Santa Paula, California, Usa');
insert into airport values('SZQ','Saenz Pena, Ba, Argentina');
insert into airport values('SZR','Stara Zagora, Bulgaria');
insert into airport values('SZS','Stewart Island, New Zealand');
insert into airport values('SZU','Segou, Mali');
insert into airport values('SZX','Shenzhen, P. R. China');
insert into airport values('SZZ','Szczecin, Poland');
insert into airport values('TAA','Tarapaina, Solomon Islands');
insert into airport values('TAB','Tobago, Trinidad & Tobago');
insert into airport values('TAC','Tacloban, Philippines');
insert into airport values('TAD','Trinidad, Colorado, Usa');
insert into airport values('TAE','Taegu, Republic Of Korea');
insert into airport values('TAF','Oran, Algeria-Taforaoui');
insert into airport values('TAG','Tagbilaran, Philippines');
insert into airport values('TAH','Tanna Island, Vanuatu');
insert into airport values('TAI','Taiz, Yemen, Republic Of');
insert into airport values('TAJ','Tadji, Papua New Guinea');
insert into airport values('TAK','Takamatsu, Japan');
insert into airport values('TAL','Tanana, Alaska, Usa');
insert into airport values('TAM','Tampico, Mexico');
insert into airport values('TAN','Tangalooma, Qld, Australia');
insert into airport values('TAO','Qingdao, P. R. China');
insert into airport values('TAP','Tapachula, Mexico');
insert into airport values('TAQ','Tarcoola, Sa, Australia');
insert into airport values('TAR','Taranto, Italy');
insert into airport values('TAS','Tashkent, Ussr');
commit;
insert into airport values('TAT','Tatry/Poprad, Czechoslovakia');
insert into airport values('TAU','Tauramena, Colombia');
insert into airport values('TAV','Ta''U Island, American Samoa');
insert into airport values('TAW','Tacuarembo, Uruguay');
insert into airport values('TAX','Taliabu, Indonesia');
insert into airport values('TAY','Tartu, Ussr');
insert into airport values('TAZ','Tashauz, Ussr');
insert into airport values('TBA','Tabibuga, Papua New Guinea');
insert into airport values('TBB','Tuy Hoa, Soc. Rep. Of Viet Nam');
insert into airport values('TBC','Tuba City, Arizona, Usa');
insert into airport values('TBD','Timbiqui, Colombia');
insert into airport values('TBE','Timbunke, Papua New Guinea');
insert into airport values('TBF','Tabiteuea North, Rep. Of Kirib');
insert into airport values('TBG','Tabubil, Papua New Guinea');
insert into airport values('TBH','Tablas, Philippines');
insert into airport values('TBI','The Bight, Bahamas');
insert into airport values('TBK','Timber Creek, Nt, Australia');
insert into airport values('TBL','Tableland, Wa, Australia');
insert into airport values('TBM','Tumbang Samba, Indonesia');
insert into airport values('TBN','Ft. Leonard Wood, Missouri, Us');
insert into airport values('TBO','Tabora, Tanzania');
insert into airport values('TBP','Tumbes, Peru');
insert into airport values('TBR','Statesboro, Georgia, Usa');
insert into airport values('TBS','Tbilisi, Ussr');
insert into airport values('TBT','Tabatinga, Am, Brazil');
insert into airport values('TBU','Tongatapu, Tonga Island, S. Pa');
insert into airport values('TBW','Tambow, Ussr');
insert into airport values('TBY','Tsabong, Botswana');
insert into airport values('TBZ','Tabriz, Iran, Islamic Rep. Of');
insert into airport values('TCA','Tennant Creek, Nt, Australia');
commit;
insert into airport values('TCB','Treasure Cay, Bahamas');
insert into airport values('TCC','Tucumcari, New Mexico, Usa');
insert into airport values('TCD','Tarapaca, Colombia');
insert into airport values('TCE','Tulcea, Romania');
insert into airport values('TCF','Tocoa, Honduras');
insert into airport values('TCH','Tchibanga, Gabon');
insert into airport values('TCI','Tenerife, Canary Islan-N Losro');
insert into airport values('TCL','Tuscaloosa, Alabama, Usa');
insert into airport values('TCN','Tehuacan, Mexico');
insert into airport values('TCO','Tumaco, Colombia');
insert into airport values('TCQ','Tacna, Peru');
insert into airport values('TCS','Truth Or Consequences, Nm, Usa');
insert into airport values('TCT','Takotna, Alaska, Usa');
insert into airport values('TCU','Thaba Nchu, South Africa');
insert into airport values('TCW','Tocumwal, Nsw, Australia');
insert into airport values('TDA','Trinidad, Colombia');
insert into airport values('TDB','Tetabedi, Papua New Guinea');
insert into airport values('TDD','Trinidad, Bolivia');
insert into airport values('TDG','Tandag, Philippines');
insert into airport values('TDJ','Tadjoura, Djibouti');
insert into airport values('TDK','Taldy-Kurgan, Ussr');
insert into airport values('TDL','Tandil, Ba, Argentina');
insert into airport values('TDR','Theodore, Qld, Australia');
insert into airport values('TDT','Tanda Tula, South Africa');
insert into airport values('TDV','Tanandava, Dem. Rep. Madagasca');
insert into airport values('TDW','Amarillo, Texas, Usa-Tradewind');
insert into airport values('TEA','Tela, Honduras');
insert into airport values('TEB','Teterboro, New Jersey, Usa');
insert into airport values('TED','Thisted, Denmark');
insert into airport values('TEE','Tbessa, Algeria');
commit;
insert into airport values('TEF','Telfer, Wa, Australia');
insert into airport values('TEG','Tenkodogo, Burkina Faso');
insert into airport values('TEH','Tetlin, Alaska, Usa');
insert into airport values('TEI','Tezu, India');
insert into airport values('TEK','Tatitlek, Alaska, Usa');
insert into airport values('TEL','Telupid, Malaysia');
insert into airport values('TEM','Temora, Nsw, Australia');
insert into airport values('TEO','Terapo, Papua New Guinea');
insert into airport values('TEP','Teptep, Papua New Guinea');
insert into airport values('TER','Terceira, Portugal (Azores)');
insert into airport values('TES','Tessenei, Ethiopia');
insert into airport values('TET','Tete, Mozambique');
insert into airport values('TEU','Te Anau, New Zealand');
insert into airport values('TEX','Telluride, Colorado, Usa-Tex');
insert into airport values('TEY','Thingeyri, Iceland');
insert into airport values('TEZ','Tezpur, India');
insert into airport values('TFA','Tilfalmin, Papua New Guinea');
insert into airport values('TFF','Tefe, Am, Brazil');
insert into airport values('TFI','Tufi, Papua New Guinea');
insert into airport values('TFL','Teofilo Otoni, Mg, Brazil');
insert into airport values('TFM','Telefomin, Papua New Guinea');
insert into airport values('TFN','Tenerife, Canary Islan-N Losro');
insert into airport values('TFS','Tenerife, Canary Islan-Reinaso');
insert into airport values('TFT','Taftan, Pakistan');
insert into airport values('TFY','Tarfaya, Morocco');
insert into airport values('TGD','Titograd, Yugoslavia');
insert into airport values('TGE','Tuskegee, Alabama, Usa');
insert into airport values('TGF','Tignes, France');
insert into airport values('TGG','Kuala Terengganu, Malaysia');
insert into airport values('TGH','Tongoa, Vanuatu');
commit;
insert into airport values('TGI','Tingo Maria, Peru');
insert into airport values('TGJ','Tiga, Loyalty Island, Pacific');
insert into airport values('TGL','Tagula, Papua New Guinea');
insert into airport values('TGM','Tirgu Mures, Romania');
insert into airport values('TGN','Traralgon, Victoria, Australia');
insert into airport values('TGO','Tongliao, P. R. China');
insert into airport values('TGR','Touggourt, Algeria');
insert into airport values('TGS','Chokwe, Mozambique');
insert into airport values('TGT','Tanga, Tanzania');
insert into airport values('TGU','Tegucigalpa, Honduras');
insert into airport values('TGV','Targovishte, Bulgaria');
insert into airport values('TGX','Tingrela, Cote D''Ivoire');
insert into airport values('TGZ','Tuxtla Gutierrez, Mexico');
insert into airport values('THA','Tullahoma, Tennessee, Usa');
insert into airport values('THB','Thaba Tseka, Lesotho');
insert into airport values('THC','Tchien, Liberia');
insert into airport values('THE','Teresina, Pi, Brazil');
insert into airport values('THF','Berlin, Fed. Rep. Of G-Tempelh');
insert into airport values('THG','Thangool, Qld, Australia');
insert into airport values('THH','Taharoa, New Zealand');
insert into airport values('THI','Tichitt, Mauritania');
insert into airport values('THK','Thakhek, Laos');
insert into airport values('THL','Tachilek, Myanmar');
insert into airport values('THN','Trollhattan, Sweden');
insert into airport values('THO','Thorshofn, Iceland');
insert into airport values('THP','Thermopolis, Wyoming, Usa');
insert into airport values('THR','Tehran, Iran, Islamic Rep. Of');
insert into airport values('THT','Tamchackett, Mauritania');
insert into airport values('THU','Thule, Greenland');
insert into airport values('THY','Thohoyandou, South Africa');
commit;
insert into airport values('THZ','Tahoua, Niger');
insert into airport values('TIA','Tirana, Albania');
insert into airport values('TIB','Tibu, Colombia');
insert into airport values('TIC','Tinak, Marshall Islands');
insert into airport values('TID','Tiaret, Algeria');
insert into airport values('TIE','Tippi, Ethiopia');
insert into airport values('TIF','Taif, Saudi Arabia');
insert into airport values('TIG','Tingwon, Papua New Guinea');
insert into airport values('TIH','Tikehau Atoll, French Polynesi');
insert into airport values('TII','Tirinkot, Dem Rep Of Afghanist');
insert into airport values('TIJ','Tijuana, Mexico');
insert into airport values('TIM','Tembagapura, Indonesia');
insert into airport values('TIN','Tindouf, Algeria');
insert into airport values('TIO','Tilin, Myanmar');
insert into airport values('TIP','Tripoli, Libyan A Jamahiriya');
insert into airport values('TIQ','Tinian, Mariana Islands');
insert into airport values('TIR','Tirupati, India');
insert into airport values('TIS','Thursday Island, Qld, Australi');
insert into airport values('TIU','Timaru, New Zealand');
insert into airport values('TIV','Tivat, Yugoslavia');
insert into airport values('TIX','Titusville, Florida, Usa');
insert into airport values('TIY','Tidjikja, Mauritania');
insert into airport values('TIZ','Tari, Papua New Guinea');
insert into airport values('TJA','Tarija, Bolivia');
insert into airport values('TJB','Tanjung Balai, Indonesia');
insert into airport values('TJG','Tanjung Warukin, Indonesia');
insert into airport values('TJI','Trujillo, Honduras');
insert into airport values('TJM','Tyumen, Ussr');
insert into airport values('TJQ','Tanjung Pandan, Indonesia');
insert into airport values('TJS','Tanjung Selor, Indonesia');
commit;
insert into airport values('TJV','Thanjavur, India');
insert into airport values('TKA','Talkeetna, Alaska, Usa');
insert into airport values('TKB','Tekadu, Papua New Guinea');
insert into airport values('TKC','Tiko, Republic Of Cameroon');
insert into airport values('TKD','Takoradi, Ghana');
insert into airport values('TKE','Tenakee, Alaska, Usa');
insert into airport values('TKF','Truckee, California, Usa');
insert into airport values('TKG','Bandar Lampung, Indonesia');
insert into airport values('TKH','Takhli, Thailand');
insert into airport values('TKI','Tokeen, Alaska, Usa');
insert into airport values('TKJ','Tok, Alaska, Usa');
insert into airport values('TKK','Truk, Caroline Is., Pacific Oc');
insert into airport values('TKN','Tokuno Shima, Japan');
insert into airport values('TKO','Tlokoeng, Lesotho');
insert into airport values('TKP','Takapoto, French Polynesia');
insert into airport values('TKQ','Kigoma, Tanzania');
insert into airport values('TKR','Thakurgaon, Bangladesh');
insert into airport values('TKS','Tokushima, Japan');
insert into airport values('TKT','Tak, Thailand');
insert into airport values('TKU','Turku, Finland');
insert into airport values('TKV','Tatakoto, French Polynesia');
insert into airport values('TKW','Tekin, Papua New Guinea');
insert into airport values('TKX','Takaroa, French Polynesia');
insert into airport values('TKY','Turkey Creek, Wa, Australia');
insert into airport values('TKZ','Tokoroa, New Zealand');
insert into airport values('TLA','Teller, Alaska, Usa');
insert into airport values('TLB','Tarbela, Pakistan');
insert into airport values('TLC','Mexico City, Mexico-Morelos');
insert into airport values('TLD','Tuli Lodge, Botswana');
insert into airport values('TLE','Tulear, Dem. Rep. Madagascar');
commit;
insert into airport values('TLF','Telida, Alaska, Usa');
insert into airport values('TLG','Tulaghi Island, Solomon Island');
insert into airport values('TLH','Tallahassee, Florida, Usa');
insert into airport values('TLI','Tolitoli, Indonesia');
insert into airport values('TLJ','Tatalina, Alaska, Usa');
insert into airport values('TLK','Talknafjordur, Iceland');
insert into airport values('TLL','Tallinn, Ussr');
insert into airport values('TLM','Tlemcen, Algeria');
insert into airport values('TLN','Toulon/Hyeres, France');
insert into airport values('TLO','Tol, Papua New Guinea');
insert into airport values('TLP','Tumolbil, Papua New Guinea');
insert into airport values('TLS','Toulouse, France');
insert into airport values('TLT','Tuluksak, Alaska, Usa');
insert into airport values('TLU','Tolu, Colombia');
insert into airport values('TLV','Tel Aviv-Yafo, Israel-Ben Guri');
insert into airport values('TLW','Talasea, Papua New Guinea');
insert into airport values('TLX','Talca, Chile');
insert into airport values('TLZ','Catalao, Go, Brazil');
insert into airport values('TMA','Tifton, Georgia, Usa');
insert into airport values('TMC','Tambolaka, Indonesia');
insert into airport values('TMD','Timbedra, Mauritania');
insert into airport values('TME','Tame, Colombia');
insert into airport values('TMG','Tomanggong, Malaysia');
insert into airport values('TMH','Tanahmerah, Indonesia');
insert into airport values('TMI','Tumlingtar, Nepal');
insert into airport values('TMK','Tam-Ky, Soc. Rep. Of Viet Nam');
insert into airport values('TML','Tamale, Ghana');
insert into airport values('TMM','Tamatave, Dem. Rep. Madagascar');
insert into airport values('TMN','Tamana, Rep. Of Kiribati');
insert into airport values('TMO','Tumeremo, Venezuela');
commit;
insert into airport values('TMP','Tampere, Finland');
insert into airport values('TMQ','Tambao, Burkina Faso');
insert into airport values('TMR','Tamanrasset, Algeria');
insert into airport values('TMS','Sao Tome Island, Sao Tome Is.');
insert into airport values('TMT','Trombetas, Pa, Brazil');
insert into airport values('TMW','Tamworth, Nsw, Australia');
insert into airport values('TMX','Timimoun, Algeria');
insert into airport values('TMY','Tiom, Indonesia');
insert into airport values('TMZ','Thames, New Zealand');
insert into airport values('TNA','Jinan, P. R. China');
insert into airport values('TNB','Tanahgrogot, Indonesia');
insert into airport values('TNC','Tin City, Alaska, Usa');
insert into airport values('TND','Trinidad, Cuba');
insert into airport values('TNE','Tanegashima, Japan');
insert into airport values('TNG','Tangier, Morocco');
insert into airport values('TNI','Satna, India');
insert into airport values('TNJ','Tanjung Pinang, Indonesia');
insert into airport values('TNK','Tununak, Alaska, Usa');
insert into airport values('TNL','Ternopolx, Ussr');
insert into airport values('TNN','Tainan, Taiwan');
insert into airport values('TNO','Tamarindo, Costa Rica');
insert into airport values('TNP','Twenty Nine Palms, California,');
insert into airport values('TNR','Antananarivo, Dem. Rep. Madaga');
insert into airport values('TNS','Tungsten, Nwt, Canada');
insert into airport values('TNU','Newton, Iowa, Usa');
insert into airport values('TNX','Stung Treng, Cambodia');
insert into airport values('TOA','Torrance, California, Usa');
insert into airport values('TOB','Tobruk, Libyan A Jamahiriya');
insert into airport values('TOC','Toccoa, Georgia, Usa');
insert into airport values('TOD','Tioman, Malaysia');
commit;
insert into airport values('TOE','Tozeur, Tunisia');
insert into airport values('TOF','Tomsk, Ussr');
insert into airport values('TOG','Togiak, Alaska, Usa');
insert into airport values('TOH','Torres, Vanuatu');
insert into airport values('TOI','Troy, Alabama, Usa');
insert into airport values('TOK','Torokina, Papua New Guinea');
insert into airport values('TOL','Toledo, Ohio, Usa');
insert into airport values('TOM','Tombouctou, Mali');
insert into airport values('TON','Tonu, Papua New Guinea');
insert into airport values('TOP','Topeka, Kansas, Usa-Billard');
insert into airport values('TOQ','Tocopilla, Chile');
insert into airport values('TOR','Torrington, Wyoming, Usa');
insert into airport values('TOS','Tromso, Norway');
insert into airport values('TOT','Totness, Republic Of Suriname');
insert into airport values('TOU','Touho, New Caledonia');
insert into airport values('TOV','Tortola, Brit. Virgin-Wstend S');
insert into airport values('TOX','Tobolsk, Ussr');
insert into airport values('TOY','Toyama, Japan');
insert into airport values('TOZ','Touba, Cote D''Ivoire');
insert into airport values('TPA','Tampa/St. Petersburg-Tampa');
insert into airport values('TPC','Tarapoa, Ecuador');
insert into airport values('TPE','Taipei, Taiwan-Shek');
insert into airport values('TPG','Taiping, Malaysia');
insert into airport values('TPH','Tonopah, Nevada, Usa');
insert into airport values('TPI','Tapini, Papua New Guinea');
insert into airport values('TPJ','Taplejung, Nepal');
insert into airport values('TPK','Tapaktuan, Indonesia');
insert into airport values('TPL','Temple, Texas, Usa');
insert into airport values('TPN','Tiputini, Ecuador');
insert into airport values('TPP','Tarapoto, Peru');
commit;
insert into airport values('TPQ','Tepic, Mexico');
insert into airport values('TPR','Tom Price, Wa, Australia');
insert into airport values('TPS','Trapani, Italy');
insert into airport values('TPT','Tapete, Liberia');
insert into airport values('TQN','Taluqan, Dem Rep Of Afghanista');
insert into airport values('TQS','Tres Esquinas, Colombia');
insert into airport values('TRA','Taramajima, Japan');
insert into airport values('TRB','Turbo, Colombia');
insert into airport values('TRC','Torreon, Mexico');
insert into airport values('TRD','Trondheim, Norway');
insert into airport values('TRE','Tiree Island, Scotland Uk');
insert into airport values('TRF','Sandefjord, Norway');
insert into airport values('TRG','Tauranga, New Zealand');
insert into airport values('TRH','Trona, California, Usa');
insert into airport values('TRI','Tri-City Airport, Tennessee, U');
insert into airport values('TRJ','Tarakbits, Papua New Guinea');
insert into airport values('TRK','Tarakan, Indonesia');
insert into airport values('TRM','Thermal, California, Usa');
insert into airport values('TRN','Turin, Italy');
insert into airport values('TRO','Taree, Nsw, Australia');
insert into airport values('TRQ','Tarauaca, Ac, Brazil');
insert into airport values('TRR','Trincomalee, Sri Lanka');
insert into airport values('TRS','Trieste, Italy');
insert into airport values('TRT','Tremonton, Utah, Usa');
insert into airport values('TRU','Trujillo, Peru');
insert into airport values('TRV','Trivandrum, India');
insert into airport values('TRW','Tarawa, Rep. Of Kiribati');
insert into airport values('TRX','Trenton, Missouri, Usa');
insert into airport values('TRY','Tororo, Uganda');
insert into airport values('TRZ','Tiruchirapally, India');
commit;
insert into airport values('TSA','Taipei, Taiwan-Sung Shan');
insert into airport values('TSB','Tsumeb, Namibia');
insert into airport values('TSC','Taisha, Ecuador');
insert into airport values('TSD','Tshipise, South Africa');
insert into airport values('TSE','Tselinograd, Ussr');
insert into airport values('TSF','Venice, Italy-Treviso');
insert into airport values('TSG','Tanacross, Alaska, Usa');
insert into airport values('TSH','Tshikapa, Zaire');
insert into airport values('TSI','Tsili Tsili, Papua New Guinea');
insert into airport values('TSJ','Tsushima, Japan');
insert into airport values('TSK','Taskul, Papua New Guinea');
insert into airport values('TSL','Tamuin, Mexico');
insert into airport values('TSM','Taos, New Mexico, Usa');
insert into airport values('TSN','Tianjin, P. R. China');
insert into airport values('TSO','Isles Of Scilly, Uk-Tresco');
insert into airport values('TSP','Tehachapi, California, Usa');
insert into airport values('TSR','Timisoara, Romania');
insert into airport values('TSS','New York Ny/Newark, Nj-E 34th');
insert into airport values('TST','Trang, Thailand');
insert into airport values('TSU','Tabiteuea South, Rep. Of Kirib');
insert into airport values('TSV','Townsville, Qld, Australia');
insert into airport values('TSW','Tsewi, Papua New Guinea');
insert into airport values('TSX','Tanjung Santan, Indonesia');
insert into airport values('TSY','Tasikmalaya, Indonesia');
insert into airport values('TSZ','Tsetserleg, Mongolia');
insert into airport values('TTA','Tan Tan, Morocco');
insert into airport values('TTB','Tortoli, Italy');
insert into airport values('TTC','Taltal, Chile');
insert into airport values('TTD','Troutdale, Oregon, Usa');
insert into airport values('TTE','Ternate, Indonesia');
commit;
insert into airport values('TTG','Tartagal, Sa, Argentina');
insert into airport values('TTH','Thumrait, Oman');
insert into airport values('TTI','Tetiaroa Is., French Polynesia');
insert into airport values('TTJ','Tottori, Japan');
insert into airport values('TTK','Tottenham Hale Station, Englan');
insert into airport values('TTL','Turtle Island, Fiji');
insert into airport values('TTM','Tablon De Tamara, Colombia');
insert into airport values('TTN','Trenton, New Jersey, Usa');
insert into airport values('TTO','Britton, South Dakota, Usa');
insert into airport values('TTR','Tanatoraja, Indonesia');
insert into airport values('TTS','Tsaratanana, Dem. Rep. Madagas');
insert into airport values('TTT','Taitung, Taiwan');
insert into airport values('TTU','Tetuan, Morocco');
insert into airport values('TUA','Tulcan, Ecuador');
insert into airport values('TUB','Tubuai, French Polynesia');
insert into airport values('TUC','Tucuman, Tu, Argentina');
insert into airport values('TUD','Tambacounda, Senegal');
insert into airport values('TUE','Tupile, Panama Republic');
insert into airport values('TUF','Tours, France');
insert into airport values('TUG','Tuguegarao, Philippines');
insert into airport values('TUI','Turaif, Saudi Arabia');
insert into airport values('TUJ','Tum, Ethiopia');
insert into airport values('TUK','Turbat, Pakistan');
insert into airport values('TUL','Tulsa, Oklahoma, Usa-Intl');
insert into airport values('TUM','Tumut, Nsw, Australia');
insert into airport values('TUN','Tunis, Tunisia');
insert into airport values('TUO','Taupo, New Zealand');
insert into airport values('TUP','Tupelo, Mississippi, Usa');
insert into airport values('TUQ','Tougan, Burkina Faso');
insert into airport values('TUR','Tucurui, Pa, Brazil');
commit;
insert into airport values('TUS','Tucson, Arizona, Usa-Intl');
insert into airport values('TUT','Tauta, Papua New Guinea');
insert into airport values('TUU','Tabuk, Saudi Arabia');
insert into airport values('TUV','Tucupita, Venezuela');
insert into airport values('TUW','Tubala, Panama Republic');
insert into airport values('TUX','Tumbler Ridge, Bc, Canada');
insert into airport values('TUY','Tulum, Mexico');
insert into airport values('TUZ','Tucuma, Pa, Brazil');
insert into airport values('TVA','Morafenobe, Dem. Rep. Madagasc');
insert into airport values('TVC','Traverse City, Michigan, Usa');
insert into airport values('TVF','Thief River Falls, Minnesota,');
insert into airport values('TVL','Lake Tahoe, California, Usa');
insert into airport values('TVU','Taveuni, Fiji');
insert into airport values('TVY','Dawe, Myanmar');
insert into airport values('TWA','Twin Hills, Alaska, Usa');
insert into airport values('TWB','Toowoomba, Qld, Australia');
insert into airport values('TWD','Port Townsend, Washington, Usa');
insert into airport values('TWE','Taylor, Alaska, Usa');
insert into airport values('TWF','Twin Falls, Idaho, Usa');
insert into airport values('TWH','Catalina Is., Californ-Harbors');
insert into airport values('TWN','Tewantin, Qld, Australia');
insert into airport values('TWP','Torwood, Qld, Australia');
insert into airport values('TWT','Tawitawi, Philippines');
insert into airport values('TWU','Tawau, Sabah, Malaysia');
insert into airport values('TWY','Tawa, Papua New Guinea');
insert into airport values('TXG','Taichung, Taiwan');
insert into airport values('TXK','Texarkana, Arkansas, Usa');
insert into airport values('TXL','Berlin, Fed. Rep. Of G-Tegel');
insert into airport values('TXM','Teminabuan, Indonesia');
insert into airport values('TXN','Tunxi, P. R. China');
commit;
insert into airport values('TXR','Tanbar, Qld, Australia');
insert into airport values('TXU','Tabou, Cote D''Ivoire');
insert into airport values('TYA','Tula, Ussr');
insert into airport values('TYB','Tibooburra, Nsw, Australia');
insert into airport values('TYD','Tynda, Ussr');
insert into airport values('TYE','Tyonek, Alaska, Usa');
insert into airport values('TYG','Thylungra, Qld, Australia');
insert into airport values('TYL','Talara, Peru');
insert into airport values('TYM','Staniel Cay, Bahamas');
insert into airport values('TYN','Taiyuan, P. R. China');
insert into airport values('TYO','Tokyo, Japan-Narita');
insert into airport values('TYP','Tobermorey, Nt, Australia');
insert into airport values('TYR','Tyler, Texas, Usa');
insert into airport values('TYS','Knoxville, Tennessee, Usa');
insert into airport values('TYT','Treinta Y Tres, Uruguay');
insert into airport values('TYZ','Taylor, Arizona, Usa');
insert into airport values('TZA','Belize City, Belize-Municipal');
insert into airport values('TZM','Tizimin, Mexico');
insert into airport values('TZN','South Andros, Bahamas');
insert into airport values('TZX','Trabzon, Turkey');
insert into airport values('UAC','San Luis Rio Colorado, Mexico');
insert into airport values('UAE','Mount Aue, Papua New Guinea');
insert into airport values('UAH','Ua Huka, French Polynesia');
insert into airport values('UAI','Suai, Indonesia');
insert into airport values('UAK','Narssarssuaq, Greenland');
insert into airport values('UAL','Luau, Angola');
insert into airport values('UAP','Ua Pou, French Polynesia');
insert into airport values('UAQ','San Juan, Sj, Argentina');
insert into airport values('UAS','Samburu, Kenya');
insert into airport values('UAX','Uaxactun, Guatemala');
commit;
insert into airport values('UBA','Uberaba, Mg, Brazil');
insert into airport values('UBB','Mabuiag Island, Qld, Australia');
insert into airport values('UBI','Buin, Papua New Guinea');
insert into airport values('UBJ','Ube, Japan');
insert into airport values('UBP','Ubon Ratchathani, Thailand');
insert into airport values('UBS','Columbus/Starkville/West Pt,Ms');
insert into airport values('UBT','Ubatuba, Sp, Brazil');
insert into airport values('UBU','Kalumburu, Wa, Australia');
insert into airport values('UCA','Utica, New York, Usa');
insert into airport values('UCE','Eunice, Louisiana, Usa');
insert into airport values('UCK','Lutsk, Ussr');
insert into airport values('UCN','Buchanan, Liberia');
insert into airport values('UCT','Ukhta, Ussr');
insert into airport values('UCY','Union City, Tennessee, Usa');
insert into airport values('UDD','Palm Springs, Californ-Bermuda');
insert into airport values('UDE','Uden, Netherlands');
insert into airport values('UDI','Uberlandia, Mg, Brazil');
insert into airport values('UDJ','Uzhgorod, Ussr');
insert into airport values('UDN','Udine, Italy');
insert into airport values('UDO','Udomxay, Laos');
insert into airport values('UDR','Udaipur, India');
insert into airport values('UEE','Queenstown, Tasmania, Australi');
insert into airport values('UEL','Quelimane, Mozambique');
insert into airport values('UEO','Kume Jima, Japan');
insert into airport values('UES','Waukesha, Wisconsin, Usa');
insert into airport values('UET','Quetta, Pakistan');
insert into airport values('UFA','Ufa, Ussr');
insert into airport values('UGA','Bulgan, Mongolia');
insert into airport values('UGB','Pilot Point, Alaska, U-Ugashik');
insert into airport values('UGC','Urgench, Ussr');
commit;
insert into airport values('UGI','Uganik, Alaska, Usa');
insert into airport values('UGN','Waukegan, Illinois, Usa');
insert into airport values('UGO','Uige, Angola');
insert into airport values('UHE','Uherske Hradiste, Czechoslovak');
insert into airport values('UIB','Quibdo, Colombia');
insert into airport values('UIH','Quinhon, Soc. Rep. Of Viet Nam');
insert into airport values('UII','Utila Island, Honduras');
insert into airport values('UIK','Ust-Ilimsk, Ussr');
insert into airport values('UIL','Quillayute, Washington, Usa');
insert into airport values('UIN','Quincy, Illinois, Usa');
insert into airport values('UIO','Quito, Ecuador');
insert into airport values('UIP','Quimper, France');
insert into airport values('UIQ','Quine Hill, Vanuatu');
insert into airport values('UIR','Quirindi, Nsw, Australia');
insert into airport values('UIT','Jaluit, Marshall Islands');
insert into airport values('UJE','Ujae Island, Marshall Islands');
insert into airport values('UKB','Kobe, Japan');
insert into airport values('UKI','Ukiah, California, Usa');
insert into airport values('UKK','Ust-Kamenogorsk, Ussr');
insert into airport values('UKN','Waukon, Iowa, Usa');
insert into airport values('UKR','Mukeiras, Yemen, Republic Of');
insert into airport values('UKT','Quakertown, Pennsylvania, Usa');
insert into airport values('UKU','Nuku, Papua New Guinea');
insert into airport values('UKX','Ust-Kut, Ussr');
insert into airport values('ULA','San Julian, Sc, Argentina');
insert into airport values('ULB','Ulei, Vanuatu');
insert into airport values('ULD','Ulundi, South Africa');
insert into airport values('ULE','Sule, Papua New Guinea');
insert into airport values('ULG','Ulgii, Mongolia');
insert into airport values('ULI','Ulithi, Caroline Is., Pac. Oce');
commit;
insert into airport values('ULL','Mull, Scotland Uk');
insert into airport values('ULM','New Ulm, Minnesota, Usa');
insert into airport values('ULN','Ulan Bator, Mongolia');
insert into airport values('ULO','Ulaangom, Mongolia');
insert into airport values('ULP','Quilpie, Qld, Australia');
insert into airport values('ULQ','Tulua, Colombia');
insert into airport values('ULS','Mulatos, Colombia');
insert into airport values('ULU','Gulu, Uganda');
insert into airport values('ULX','Ulusaba, South Africa');
insert into airport values('ULY','Ulyanovsk, Ussr');
insert into airport values('ULZ','Uliastai, Mongolia');
insert into airport values('UMA','Punta De Maisi, Cuba');
insert into airport values('UMB','Umnak Island, Alaska, Usa');
insert into airport values('UMC','Umba, Papua New Guinea');
insert into airport values('UMD','Uummannaq, Greenland');
insert into airport values('UME','Umea, Sweden');
insert into airport values('UMI','Quincemil, Peru');
insert into airport values('UMM','Summit, Alaska, Usa');
insert into airport values('UMR','Woomera, Sa, Australia');
insert into airport values('UMT','Umiat, Alaska, Usa');
insert into airport values('UMU','Umuarama, Pr, Brazil');
insert into airport values('UMY','Sumy, Ussr');
insert into airport values('UNC','Unguia, Colombia');
insert into airport values('UND','Kunduz, Dem Rep Of Afghanistan');
insert into airport values('UNE','Qacha''S Nek, Lesotho');
insert into airport values('UNG','Kiunga, Papua New Guinea');
insert into airport values('UNI','Union Island, Windward Islands');
insert into airport values('UNK','Unalakleet, Alaska, Usa');
insert into airport values('UNN','Ranong, Thailand');
insert into airport values('UNR','Underkhaan, Mongolia');
commit;
insert into airport values('UNT','Unst. Shetland Is., Scotland U');
insert into airport values('UNU','Juneau, Wisconsin, Usa');
insert into airport values('UOL','Buol, Indonesia');
insert into airport values('UON','Muong Sai, Laos');
insert into airport values('UOS','Sewanee, Tennessee, Usa');
insert into airport values('UOX','University/Oxford, Mississippi');
insert into airport values('UPA','Punta Alegre, Cuba');
insert into airport values('UPC','Puerto La Cruz, Canary Islands');
insert into airport values('UPF','Pforheim, Fed. Rep. Of Germany');
insert into airport values('UPG','Ujung Pandang, Indonesia');
insert into airport values('UPL','Upala, Costa Rica');
insert into airport values('UPN','Uruapan, Mexico');
insert into airport values('UPP','Upolu Point, Hawaii; Hawaii, U');
insert into airport values('UPR','Upiara, Papua New Guinea');
insert into airport values('UQE','Queen, Alaska, Usa');
insert into airport values('URA','Uralsk, Ussr');
insert into airport values('URB','Urubupunga, Sp, Brazil');
insert into airport values('URC','Urumqi, P. R. China');
insert into airport values('URG','Uruguaiana, Rs, Brazil');
insert into airport values('URI','Uribe, Colombia');
insert into airport values('URJ','Uraj, Ussr');
insert into airport values('URM','Uriman, Venezuela');
insert into airport values('URO','Rouen, France');
insert into airport values('URR','Urrao, Colombia');
insert into airport values('URS','Kursk, Ussr');
insert into airport values('URT','Surat Thani, Thailand');
insert into airport values('URY','Gurayat, Saudi Arabia');
insert into airport values('URZ','Uruzgan, Dem Rep Of Afghanista');
insert into airport values('USH','Ushuaia, Tf, Argentina');
insert into airport values('USI','Mabaruma, Guyana');
commit;
insert into airport values('USK','Usinsk, Ussr');
insert into airport values('USL','Useless Loop, Wa, Australia');
insert into airport values('USM','Koh Samui, Thailand');
insert into airport values('USN','Ulsan, Republic Of Korea');
insert into airport values('USO','Usino, Papua New Guinea');

insert into airport values('USS','Sancti Spiritus, Cuba');
insert into airport values('UST','St. Augustine, Florida, Usa');
insert into airport values('USU','Busuanga, Philippines');
insert into airport values('UTA','Mutare, Zimbabwe');
insert into airport values('UTB','Muttaburra, Qld, Australia');
insert into airport values('UTC','Utrecht, Netherlands');
insert into airport values('UTD','Nutwood Downs, Nt, Australia');
insert into airport values('UTE','Butterworth, South Africa');
insert into airport values('UTG','Quthing, Lesotho');
insert into airport values('UTH','Udon Thani, Thailand');
insert into airport values('UTI','Kouvola, Finland');
insert into airport values('UTK','Utirik, Marshall Islands');
insert into airport values('UTL','Torremolinos, Spain');
insert into airport values('UTN','Upington, South Africa');
insert into airport values('UTO','Utopia Creek, Alaska, Usa');
insert into airport values('UTP','Utapao, Thailand');
insert into airport values('UTR','Uttaradit, Thailand');
insert into airport values('UTT','Umtata, South Africa');
insert into airport values('UTU','Ustupo, Panama Republic');
insert into airport values('UTW','Queenstown, South Africa');
insert into airport values('UUA','Bugulma, Ussr');
insert into airport values('UUD','Ulan-Ude, Ussr');
insert into airport values('UUK','Kuparuk, Alaska, Usa');
insert into airport values('UUN','Baruun-Urt, Mongolia');
commit;
insert into airport values('UUS','Yuzhno-Sakhalinsk, Ussr');
insert into airport values('UUU','Manumu, Papua New Guinea');
insert into airport values('UVA','Uvalde, Texas, Usa');
insert into airport values('UVE','Ouvea, Loyalty Island, Pacific');
insert into airport values('UVF','St. Lucia, West Indies-Hewanor');
insert into airport values('UVL','New Valley, Arab Rep Of Egypt');
insert into airport values('UVO','Uvol, Papua New Guinea');
insert into airport values('UWA','Ware, Massachusetts, Usa');
insert into airport values('UYL','Nyala, Sudan');
insert into airport values('UYN','Yulin, P. R. China');
insert into airport values('UZH','Unayzah, Saudi Arabia');
insert into airport values('UZU','Curuzu Cuatia, Cr, Argentina');
insert into airport values('VAA','Vaasa, Finland');
insert into airport values('VAB','Yavarate, Colombia');
insert into airport values('VAF','Valence, France');
insert into airport values('VAG','Varginha, Mg, Brazil');
insert into airport values('VAI','Vanimo, Papua New Guinea');
insert into airport values('VAK','Chevak, Alaska, Usa');
insert into airport values('VAL','Valenca, Ba, Brazil');
insert into airport values('VAN','Van, Turkey');
insert into airport values('VAP','Valparaiso, Chile');
insert into airport values('VAR','Varna, Bulgaria');
insert into airport values('VAS','Sivas, Turkey');
insert into airport values('VAT','Vatomandry, Dem. Rep. Madagasc');
insert into airport values('VAU','Vatukoula, Fiji');
insert into airport values('VAV','Vava''U, Tonga Island');
insert into airport values('VAW','Vardoe, Norway');
insert into airport values('VAZ','Val D''Isere, France');
insert into airport values('VBV','Vanuabalavu, Fiji');
insert into airport values('VBY','Visby, Sweden');
commit;
insert into airport values('VCA','Can Tho, Soc. Rep. Of Viet Nam');
insert into airport values('VCB','View Cove, Alaska, Usa');
insert into airport values('VCC','Victoria, Republic Of Cameroon');
insert into airport values('VCD','Victoria R. Downs, Nt, Austral');
insert into airport values('VCE','Venice, Italy-Marco Polo');
insert into airport values('VCF','Valcheta, Rn, Argentina');
insert into airport values('VCH','Vichadero, Uruguay');
insert into airport values('VCP','Sao Paulo, Sp, Brazil-Viracopo');
insert into airport values('VCR','Carora, Venezuela');
insert into airport values('VCT','Victoria, Texas, Usa');
insert into airport values('VDA','Ovda, Israel');
insert into airport values('VDB','Fagernes, Norway');
insert into airport values('VDC','Vitoria Da Conquista, Ba, Braz');
insert into airport values('VDE','Valverde, Canary Islands');
insert into airport values('VDI','Vidalia, Georgia, Usa');
insert into airport values('VDM','Viedma, Rn, Argentina');
insert into airport values('VDP','Valle De La Pascua, Venezuela');
insert into airport values('VDR','Villa Dolores, Cd, Argentina');
insert into airport values('VDS','Vadso, Norway');
insert into airport values('VDZ','Valdez, Alaska, Usa');
insert into airport values('VEE','Venetie, Alaska, Usa');
insert into airport values('VEG','Maikwak, Guyana');
insert into airport values('VEJ','Vejle, Denmark');
insert into airport values('VEL','Vernal, Utah, Usa');
insert into airport values('VER','Veracruz, Mexico');
insert into airport values('VEV','Barakoma, Solomon Islands');
insert into airport values('VEX','Tioga, North Dakota, Usa');
insert into airport values('VEY','Vestmannaeyjar, Iceland');
insert into airport values('VFA','Victoria Falls, Zimbabwe');
insert into airport values('VGA','Vijayawada, India');
commit;
insert into airport values('VGD','Vologda, Ussr');
insert into airport values('VGO','Vigo, Spain');
insert into airport values('VGS','General Villegas, Ba, Argentin');
insert into airport values('VGT','Las Vegas, Nevada, Usa-N Termi');
insert into airport values('VGZ','Villagarzon, Colombia');
insert into airport values('VHC','Saurimo, Angola');
insert into airport values('VHM','Vilhelmina, Sweden');
insert into airport values('VHN','Van Horn, Texas, Usa');
insert into airport values('VHY','Vichy, France');
insert into airport values('VHZ','Vahitahi, French Polynesia');
insert into airport values('VIB','V. Constitucion, Mexico');
insert into airport values('VIC','Vicenza, Italy');
insert into airport values('VID','Vidin, Bulgaria');
insert into airport values('VIE','Vienna, Austria');
insert into airport values('VIG','El Vigia, Venezuela');
insert into airport values('VIH','Vichy, Missouri, Usa');
insert into airport values('VIJ','Virgin Gorda, Brit. Virgin Is.');
insert into airport values('VIL','Dakhla, Morocco');
insert into airport values('VIN','Vinnica, Ussr');
insert into airport values('VIQ','Viqueque, Indonesia');
insert into airport values('VIS','Visalia, California, Usa');
insert into airport values('VIT','Vitoria, Spain');
insert into airport values('VIV','Vivigani, Papua New Guinea');
insert into airport values('VIX','Vitoria, Es, Brazil');
insert into airport values('VJB','Xai Xai, Mozambique');
insert into airport values('VJQ','Gurue, Mozambique');
insert into airport values('VKG','Rach Gia, Soc. Rep. Of Viet Na');
insert into airport values('VKO','Moscow, Ussr-Vnukovo');
insert into airport values('VKT','Vorkuta, Ussr');
insert into airport values('VKW','West Kavik, Alaska, Usa');
commit;
insert into airport values('VLA','Vandalia, Illinois, Usa');
insert into airport values('VLC','Valencia, Spain');
insert into airport values('VLD','Valdosta, Georgia, Usa');
insert into airport values('VLE','Valle, Arizona, Usa');
insert into airport values('VLG','Villa Gesell, Ba, Argentina');
insert into airport values('VLI','Port Vila, Vanuatu');
insert into airport values('VLK','Volgodonsk, Ussr');
insert into airport values('VLL','Valladolid, Spain');
insert into airport values('VLM','Villa Montes, Bolivia');
insert into airport values('VLN','Valencia, Venezuela');
insert into airport values('VLO','Vallejo, California, Usa');
insert into airport values('VLR','Vallenar, Chile');
insert into airport values('VLS','Valesdir, Vanuatu');
insert into airport values('VLU','Velikiye Luki, Ussr');
insert into airport values('VLV','Valera, Venezuela');
insert into airport values('VME','Villa Mercedes, Sl, Argentina');
insert into airport values('VMU','Baimuru, Papua New Guinea');
insert into airport values('VNA','Saravane, Laos');
insert into airport values('VNC','Venice, Florida, Usa');
insert into airport values('VNE','Vannes, France');
insert into airport values('VNG','Viengxay, Laos');
insert into airport values('VNO','Vilnius, Ussr');
insert into airport values('VNR','Vanrook, Qld, Australia');
insert into airport values('VNS','Varanasi, India');
insert into airport values('VNX','Vilanculos, Mozambique');
insert into airport values('VNY','Los Angeles, Californi-Van Nuy');
insert into airport values('VOG','Volgograd, Ussr');
insert into airport values('VOH','Vohemar, Dem. Rep. Madagascar');
insert into airport values('VOI','Voinjama, Liberia');
insert into airport values('VOK','Camp Douglas, Wisconsin, Usa');
commit;
insert into airport values('VOL','Volos, Greece');
insert into airport values('VOT','Votuporanga, Sp, Brazil');
insert into airport values('VOZ','Voronezh, Ussr');
insert into airport values('VPE','Ongiva, Angola');
insert into airport values('VPN','Vopnafjordur, Iceland');
insert into airport values('VPS','Ft. Walton Beach, Florida, Usa');
insert into airport values('VPZ','Valparaiso, Indiana, Usa');
insert into airport values('VQS','Vieques, Puerto Rico');
insert into airport values('VRA','Varadero, Cuba');
insert into airport values('VRB','Vero Beach, Florida, Usa');
insert into airport values('VRC','Virac, Philippines');
insert into airport values('VRE','Vredendal, South Africa');
insert into airport values('VRK','Varkaus, Finland');
insert into airport values('VRL','Vila Real, Portugal');
insert into airport values('VRN','Verona, Italy');
insert into airport values('VRS','Versailles, Missouri, Usa');
insert into airport values('VRU','Vryburg, South Africa');
insert into airport values('VRY','Vaeroy, Norway');
insert into airport values('VSA','Villahermosa, Mexico');
insert into airport values('VSE','Viseu, Portugal');
insert into airport values('VSF','Springfield, Vermont, Usa');
insert into airport values('VSG','Lugansk, Ussr');
insert into airport values('VSO','Phuoc Long, Soc. Rep. Of Viet');
insert into airport values('VST','Vasteras, Sweden');
insert into airport values('VTA','Victoria, Honduras');
insert into airport values('VTB','Vitebsk, Ussr');
insert into airport values('VTE','Vientiane, Laos');
insert into airport values('VTF','Vatulele, Fiji');
insert into airport values('VTL','Vittel, France');
insert into airport values('VTN','Valentine, Nebraska, Usa');
commit;
insert into airport values('VTU','Las Tunas, Cuba');
insert into airport values('VTZ','Vishakhapatnam, India');
insert into airport values('VUP','Valledupar, Colombia');
insert into airport values('VUS','Velikij Ustyug, Ussr');
insert into airport values('VVB','Mahanoro, Dem. Rep. Madagascar');
insert into airport values('VVC','Villavicencio, Colombia');
insert into airport values('VVI','Santa Cruz, Bolivia');
insert into airport values('VVK','Vastervik, Sweden');
insert into airport values('VVO','Vladivostok, Ussr');
insert into airport values('VVZ','Illizi, Algeria');
insert into airport values('VXC','Lichinga, Mozambique');
insert into airport values('VXE','Sao Vicente, Cape Verde Island');
insert into airport values('VXO','Vaxjo, Sweden');
insert into airport values('VYD','Vryheid, South Africa');
insert into airport values('VYS','Peru, Illinois, Usa');
insert into airport values('WAA','Wales, Alaska, Usa');
insert into airport values('WAB','Wabag, Papua New Guinea');
insert into airport values('WAC','Waca, Ethiopia');
insert into airport values('WAD','Andriamena, Dem. Rep. Madagasc');
insert into airport values('WAE','Wadi-Ad-Dawasir, Saudi Arabia');
insert into airport values('WAF','Wana, Pakistan');
insert into airport values('WAG','Wanganui, New Zealand');
insert into airport values('WAH','Wahpeton, North Dakota, Usa');
insert into airport values('WAI','Antsohihy, Dem. Rep. Madagasca');
insert into airport values('WAJ','Wawoi Falls, Papua New Guinea');
insert into airport values('WAK','Ankazoabo, Dem. Rep. Madagasca');
insert into airport values('WAL','Chincoteague, Virginia, Usa');
insert into airport values('WAM','Ambatondrazaka, Dem. Rep. Mada');
insert into airport values('WAN','Waverney, Qld, Australia');
insert into airport values('WAO','Wabo, Papua New Guinea');
commit;
insert into airport values('WAP','Alto Palena, Chile');
insert into airport values('WAQ','Antsalova, Dem. Rep. Madagasca');
insert into airport values('WAR','Waris, Indonesia');
insert into airport values('WAS','Washington, Dc, Usa-Dulles');
insert into airport values('WAT','Waterford, Republic Of Ireland');
insert into airport values('WAU','Wauchope, Nsw, Australia');
insert into airport values('WAV','Wave Hill, Nt, Australia');
insert into airport values('WAW','Warsaw, Poland');
insert into airport values('WAX','Warroad, Minnesota, Usa');
insert into airport values('WAZ','Warwick, Qld, Australia');
insert into airport values('WBA','Warraber Island, Qld, Australi');
insert into airport values('WBB','Stebbins, Alaska, Usa');
insert into airport values('WBD','Befandriana, Dem. Rep. Madagas');
insert into airport values('WBE','Bealanana, Dem. Rep. Madagasca');
insert into airport values('WBM','Wapenamanda, Papua New Guinea');
insert into airport values('WBN','Woburn, Massachusetts, Usa');
insert into airport values('WBO','Beroroha, Dem. Rep. Madagascar');
insert into airport values('WBQ','Beaver, Alaska, Usa');
insert into airport values('WBR','Big Rapids, Michigan, Usa');
insert into airport values('WBU','Boulder, Colorado, Usa');
insert into airport values('WCA','Castro, Chile');
insert into airport values('WCH','Chaiten, Chile');
insert into airport values('WCR','Chandalar, Alaska, Usa');
insert into airport values('WDA','Wadi Ain, Yemen, Republic Of');
insert into airport values('WDB','Deep Bay, Alaska, Usa');
insert into airport values('WDG','Enid, Oklahoma, Usa');
insert into airport values('WDH','Windhoek, Namibia-Intl');
insert into airport values('WDI','Wondai, Qld, Australia');
insert into airport values('WDR','Winder, Georgia, Usa');
insert into airport values('WEA','Weatherford, Texas, Usa');
commit;
insert into airport values('WED','Wedau, Papua New Guinea');
insert into airport values('WEI','Weipa, Qld, Australia');
insert into airport values('WEL','Welkom, South Africa');
insert into airport values('WEM','West Malling, England Uk');
insert into airport values('WEP','Weam, Papua New Guinea');
insert into airport values('WES','Weasua, Liberia');
insert into airport values('WET','Wagethe, Indonesia');
insert into airport values('WEW','Wee Waa, Nsw, Australia');
insert into airport values('WEX','Wexford, Republic Of Ireland');
insert into airport values('WFB','Ketchikan, Alaska, Usa-Waterfr');
insert into airport values('WFI','Fianarantsoa, Dem. Rep. Madaga');
insert into airport values('WFK','Frenchville, Maine, Usa');
insert into airport values('WGA','Wagga-Wagga, Nsw, Australia');
insert into airport values('WGB','Bahawalnagar, Pakistan');
insert into airport values('WGC','Warrangal, India');
insert into airport values('WGE','Walgett, Nsw, Australia');
insert into airport values('WGN','Waitangi, New Zealand');
insert into airport values('WGO','Winchester, Virginia, Usa');
insert into airport values('WGP','Waingapu, Indonesia');
insert into airport values('WGT','Wangaratta, Vic, Australia');
insert into airport values('WGU','Wagau, Papua New Guinea');
insert into airport values('WGY','Wagny, Gabon');
insert into airport values('WHD','Hyder, Alaska, Usa');
insert into airport values('WHK','Whakatane, New Zealand');
insert into airport values('WHL','Welshpool, Vic, Australia');
insert into airport values('WHO','Franz Josef, New Zealand');
insert into airport values('WHR','Vail/Eagle, Colorado-Avon');
insert into airport values('WHS','Whalsay, Shetland Is., Scotlan');
insert into airport values('WHT','Wharton, Texas, Usa');
insert into airport values('WIC','Wick, Scotland Uk');
commit;
insert into airport values('WID','Wildenrath, Fed. Rep. Of Germa');
insert into airport values('WIK','Surfdale, Waiheke Is., New Zea');
insert into airport values('WIL','Nairobi, Kenya-Wilson');
insert into airport values('WIN','Winton, Qld, Australia');
insert into airport values('WIO','Wilcannia, Nsw, Australia');
insert into airport values('WIT','Wittenoom Gorge, Wa, Australia');
insert into airport values('WIU','Witu, Papua New Guinea');
insert into airport values('WJA','Woja, Marshall Islands');
insert into airport values('WJF','Palmdale/Lancaster, Ca-Fox');
insert into airport values('WJR','Wajir, Kenya');
insert into airport values('WKA','Wanaka, New Zealand');
insert into airport values('WKB','Warracknabeal, Vic, Australia');
insert into airport values('WKJ','Wakkanai, Japan');
insert into airport values('WKK','Aleknagik, Alaska, Usa');
insert into airport values('WKL','Waikoloa, Hawaii; Hawaii, Usa');
insert into airport values('WKN','Wakunai, Papua New Guinea');
insert into airport values('WKR','Walker''S Cay, Bahamas');
insert into airport values('WLA','Wallal, Wa, Australia');
insert into airport values('WLB','Labouchere Bay, Alaska, Usa');
insert into airport values('WLC','Walcha, Nsw, Australia');
insert into airport values('WLD','Winfield, Kansas, Usa');
insert into airport values('WLG','Wellington, New Zealand');
insert into airport values('WLH','Walaha, Vanuatu');
insert into airport values('WLK','Selawik, Alaska, Usa');
insert into airport values('WLL','Wollogorang, Nt, Australia');
insert into airport values('WLM','Waltham, Massachusetts, Usa');
insert into airport values('WLN','Little Naukati, Alaska, Usa');
insert into airport values('WLO','Waterloo, Nt, Australia');
insert into airport values('WLR','Loring, Alaska, Usa');
insert into airport values('WLS','Wallis Is., Wallis & Futuna Is');
commit;
insert into airport values('WLW','Willows, California, Usa');
insert into airport values('WMA','Mandritsara, Dem. Rep. Madagas');
insert into airport values('WMB','Warrnambool, Vic, Australia');
insert into airport values('WMC','Winnemucca, Nevada, Usa');
insert into airport values('WMD','Mandabe, Dem. Rep. Madagascar');
insert into airport values('WMH','Mountain Home, Arkansas, Usa');
insert into airport values('WMK','Meyers Chuck, Alaska, Usa');
insert into airport values('WML','Malaimbandy, Dem. Rep. Madagas');
insert into airport values('WMN','Maroantsetra, Dem. Rep. Madaga');
insert into airport values('WMO','White Mountain, Alaska, Usa');
insert into airport values('WMR','Mananara, Dem. Rep. Madagascar');
insert into airport values('WMV','Madirovalo, Dem. Rep. Madagasc');
insert into airport values('WMX','Wamena, Indonesia');
insert into airport values('WNA','Napakiak, Alaska, Usa');
insert into airport values('WNC','Tuxekan Island, Alaska, Usa');
insert into airport values('WND','Windarra, Wa, Australia');
insert into airport values('WNE','Wora Na Ye, Gabon');
insert into airport values('WNN','Wunnummin Lake, Ontario, Canad');
insert into airport values('WNP','Naga, Philippines');
insert into airport values('WNR','Windorah, Qld, Australia');
insert into airport values('WNS','Nawab Shah, Pakistan');
insert into airport values('WNU','Wanuma, Papua New Guinea');
insert into airport values('WNZ','Wenzhou, P. R. China');
insert into airport values('WOA','Wonenara, Papua New Guinea');
insert into airport values('WOD','Wood River, Alaska, Usa');
insert into airport values('WOG','Woodgreen, Nt, Australia');
insert into airport values('WOI','Wologissi, Liberia');
insert into airport values('WOK','Wonken, Venezuela');
insert into airport values('WOL','Wollongong, Nsw, Australia');
insert into airport values('WON','Wondoola, Qld, Australia');
commit;
insert into airport values('WOO','Woodchopper, Alaska, Usa');
insert into airport values('WOT','Wonan, Taiwan');
insert into airport values('WOW','Willow, Alaska, Usa');
insert into airport values('WPA','Puerto Aisen, Chile');
insert into airport values('WPB','Port Berge, Dem. Rep. Madagasc');
insert into airport values('WPC','Pincher Creek, Alberta, Canada');
insert into airport values('WPK','Wrotham Park, Qld, Australia');
insert into airport values('WPL','Powell Lake, Bc, Canada');
insert into airport values('WPM','Wipim, Papua New Guinea');
insert into airport values('WPO','Paonia, Colorado, Usa');
insert into airport values('WPR','Porvenir, Chile');
insert into airport values('WPU','Puerto Williams, Chile');
insert into airport values('WRA','Warder, Ethiopia');
insert into airport values('WRE','Whangarei, New Zealand');
insert into airport values('WRG','Wrangell, Alaska, Usa');
insert into airport values('WRL','Worland, Wyoming, Usa');
insert into airport values('WRO','Wroclaw, Poland');
insert into airport values('WRW','Warrawagine, Wa, Australia');
insert into airport values('WRY','Westray, Scotland Uk');
insert into airport values('WSA','Wasua, Papua New Guinea');
insert into airport values('WSB','Steamboat Bay, Alaska, Usa');
insert into airport values('WSG','Washington, Pennsylvania, Usa');
insert into airport values('WSH','Shirley, New York, Usa');
insert into airport values('WSJ','San Juan, Alaska, Usa');
insert into airport values('WSM','Wiseman, Alaska, Usa');
insert into airport values('WSN','South Naknek, Alaska, Usa');
insert into airport values('WSO','Washabo, Republic Of Suriname');
insert into airport values('WSP','Waspam, Nicaragua');
insert into airport values('WSR','Wasior, Indonesia');
insert into airport values('WST','Westerly, Rhode Island, Usa');
commit;
insert into airport values('WSU','Wasu, Papua New Guinea');
insert into airport values('WSX','Westsound, Washington, Usa');
insert into airport values('WSY','Airlie Beach, Qld, Australia');
insert into airport values('WSZ','Westport, New Zealand');
insert into airport values('WTA','Tambohorano, Dem. Rep. Madagas');
insert into airport values('WTD','West End, Bahamas');
insert into airport values('WTE','Wotje, Marshall Islands');
insert into airport values('WTK','Noatak, Alaska, Usa');
insert into airport values('WTL','Tuntutuliak, Alaska, Usa');
insert into airport values('WTO','Wotho, Marshall Islands');
insert into airport values('WTP','Woitape, Papua New Guinea');
insert into airport values('WTR','Whiteriver, Arizona, Usa');
insert into airport values('WTS','Tsiroanomandidy, Dem.Rep. Mada');
insert into airport values('WTT','Wantoat, Papua New Guinea');
insert into airport values('WTZ','Whitianga, New Zealand');
insert into airport values('WUD','Wudinna, Sa, Australia');
insert into airport values('WUG','Wau, Papua New Guinea');
insert into airport values('WUH','Wuhan, P. R. China');
insert into airport values('WUN','Wiluna, Wa, Australia');
insert into airport values('WUU','Wau, Sudan');
insert into airport values('WUV','Wuvulu Island, Papua New Guine');
insert into airport values('WUZ','Wuzhou, P. R. China');
insert into airport values('WVB','Walvis Bay, South Africa');
insert into airport values('WVI','Watsonville, California, Usa');
insert into airport values('WVK','Manakara, Dem. Rep. Madagascar');
insert into airport values('WVL','Waterville, Maine, Usa');
insert into airport values('WVN','Wilhelmshaven, Fed. Rep. Of Ge');
insert into airport values('WWA','Wasilla, Alaska, Usa');
insert into airport values('WWD','Cape May, New Jersey, Usa');
insert into airport values('WWK','Wewak, Papua New Guinea');
commit;
insert into airport values('WWP','Whale Pass, Alaska, Usa');
insert into airport values('WWR','Woodward, Oklahoma, Usa');
insert into airport values('WWT','Newtok, Alaska, Usa');
insert into airport values('WWY','West Wyalong, Nsw, Australia');
insert into airport values('WXN','Wanxian, P. R. China');
insert into airport values('WYA','Whyalla, Sa, Australia');
insert into airport values('WYB','Yes Bay, Alaska, Usa');
insert into airport values('WYE','Yengema, Sierra Leone');
insert into airport values('WYN','Wyndham, Wa, Australia');
insert into airport values('WYS','West Yellowstone, Montana, Usa');
insert into airport values('XAL','Alamos, Mexico');
insert into airport values('XAP','Chapeco, Sc, Brazil');
insert into airport values('XAR','Aribinda, Burkina Faso');
insert into airport values('XAU','Saul, Fr. Guiana');
insert into airport values('XAY','Xayabury, Laos');
insert into airport values('XBB','Blubber Bay, Bc, Canada');
insert into airport values('XBE','Bearskin Lake, Ontario, Canada');
insert into airport values('XBG','Bogande, Burkina Faso');
insert into airport values('XBJ','Birjand, Iran, Islamic Rep. Of');
insert into airport values('XBL','Buno Bedelle, Ethiopia');
insert into airport values('XBN','Biniguni, Papua New Guinea');
insert into airport values('XBO','Boulsa, Burkina Faso');
insert into airport values('XBR','Brockville, Ontario, Canada');
insert into airport values('XBW','Killineq, Ontario, Canada');
insert into airport values('XCH','Christmas Island, Ind. Ocean');
insert into airport values('XCL','Cluff Lake, Sask, Canada');
insert into airport values('XCM','Chatham, Ontario, Canada');
insert into airport values('XCN','Coron, Philippines');
insert into airport values('XCO','Colac, Vic, Australia');
insert into airport values('XDE','Diebougou, Burkina Faso');
commit;
insert into airport values('XDJ','Djibo, Burkina Faso');
insert into airport values('XEN','Xingcheng, P. R. China');
insert into airport values('XES','Lake Geneva, Wisconsin, Usa');
insert into airport values('XFN','Xiangfan, P. R. China');
insert into airport values('XFW','Finkenwerder, Fed. Rep. Of Ger');
insert into airport values('XGA','Gaoua, Burkina Faso');
insert into airport values('XGG','Gorom-Gorom, Burkina Faso');
insert into airport values('XGL','Granville Lake, Manitoba, Cana');
insert into airport values('XGN','Xangongo, Angola');
insert into airport values('XGR','Kangiqsualujjuaq, Quebec, Cana');
insert into airport values('XIC','Xichang, P. R. China');
insert into airport values('XIE','Xieng Lom, Laos');
insert into airport values('XIL','Xilinhot, P. R. China');
insert into airport values('XIN','Xingning, P. R. China');
insert into airport values('XKA','Kantchari, Burkina Faso');
insert into airport values('XKH','Xieng Khouang, Laos');
insert into airport values('XKO','Kemano, Bc, Canada');
insert into airport values('XKS','Kasabonika, Ontario, Canada');
insert into airport values('XKY','Kaya, Burkina Faso');
insert into airport values('XLB','Lac Brochet, Manitoba, Canada');
insert into airport values('XLF','Leaf Bay, Quebec, Canada');
insert into airport values('XLO','Long Xuyen, Soc. Rep. Of Viet');
insert into airport values('XLS','St. Louis, Senegal');
insert into airport values('XLU','Leo, Burkina Faso');
insert into airport values('XLW','Lemwerder, Fed. Rep. Of German');
insert into airport values('XMB','M''Bahiakro, Cote D''Ivoire');
insert into airport values('XMC','Mallacoota, Vic, Australia');
insert into airport values('XMD','Madison, South Dakota, Usa');
insert into airport values('XMG','Mahendranagar, Nepal');
insert into airport values('XMH','Manihi, French Polynesia');
commit;
insert into airport values('XMI','Masasi, Tanzania');
insert into airport values('XML','Minlaton, Sa, Australia');
insert into airport values('XMN','Xiamen, P. R. China');
insert into airport values('XMP','Macmillan Pass, Yt, Canada');
insert into airport values('XMS','Macas, Ecuador');
insert into airport values('XMY','Yam Island, Qld, Australia');
insert into airport values('XNG','Quang Ngai, Soc. Rep. Of Viet');
insert into airport values('XNN','Xining, P. R. China');
insert into airport values('XNU','Nouna, Burkina Faso');
insert into airport values('XPA','Pama, Burkina Faso');
insert into airport values('XPK','Pukatawagan, Manitoba, Canada');
insert into airport values('XPL','Comayagua, Honduras');
insert into airport values('XPP','Poplar River, Manitoba, Canada');
insert into airport values('XPR','Pine Ridge, South Dakota, Usa');
insert into airport values('XPU','West Kuparuk, Alaska, Usa');
insert into airport values('XQP','Quepos, Costa Rica');
insert into airport values('XQU','Qualicum, Bc, Canada');
insert into airport values('XRR','Ross River, Yt, Canada');
insert into airport values('XRY','Jerez De La Frontera, Spain');
insert into airport values('XSC','South Caicos, Turks & Caicos I');
insert into airport values('XSE','Sebba, Burkina Faso');
insert into airport values('XSI','South Indian Lake, Manitoba, C');
insert into airport values('XSM','St. Mary''S, Maryland, Usa');
insert into airport values('XSO','Siocon, Philippines');
insert into airport values('XSP','Singapore, Singapore-Seletar');
insert into airport values('XTG','Thargomindah, Qld, Australia');
insert into airport values('XTL','Tadoule Lake, Manitoba, Canada');
insert into airport values('XTO','Taroom, Qld, Australia');
insert into airport values('XTR','Tara, Qld, Australia');
insert into airport values('XUZ','Xuzhou, P. R. China');
commit;
insert into airport values('XVL','Vinh Long, Soc. Rep. Of Viet N');
insert into airport values('XYA','Yandina, Solomon Islands');
insert into airport values('XYE','Ye, Myanmar');
insert into airport values('XYR','Yellow River, Papua New Guinea');
insert into airport values('XZA','Zabre, Burkina Faso');
insert into airport values('YAA','Anahim Lake, Bc, Canada');
insert into airport values('YAB','Arctic Bay, Nwt, Canada');
insert into airport values('YAC','Cat Lake, Ontario, Canada');
insert into airport values('YAF','Asbestos Hill, Quebec, Canada');
insert into airport values('YAG','Fort Frances, Ontario, Canada');
insert into airport values('YAH','Lagrande 4, Quebec, Canada');
insert into airport values('YAI','Chillan, Chile');
insert into airport values('YAK','Yakutat, Alaska, Usa');
insert into airport values('YAL','Alert Bay, Bc, Canada');
insert into airport values('YAM','Sault Ste. Marie, Ontario, Can');
insert into airport values('YAN','Yangambi, Zaire');
insert into airport values('YAO','Yaounde, Republic Of Cameroon');
insert into airport values('YAP','Yap, Caroline Is., Pac. Ocean');
insert into airport values('YAR','Lagrande 3, Quebec, Canada');
insert into airport values('YAS','Yasawa Island, Fiji');
insert into airport values('YAT','Attawapiskat, Ontario, Canada');
insert into airport values('YAX','Angling Lake, Ontario, Canada');
insert into airport values('YAY','St. Anthony, Nfld, Canada');
insert into airport values('YAZ','Tofino, Bc, Canada-Yaz');
insert into airport values('YBA','Banff, Alberta, Canada');
insert into airport values('YBB','Pelly Bay, Nwt, Canada-Townsit');
insert into airport values('YBC','Baie Comeau, Quebec, Canada');
insert into airport values('YBE','Uranium City, Sask, Canada');
insert into airport values('YBF','Bamfield, Bc, Canada');
insert into airport values('YBG','Bagotville, Quebec, Canada');
commit;
insert into airport values('YBH','Bull Harbour, Bc, Canada');
insert into airport values('YBI','Black Tickle, Nfld, Canada');
insert into airport values('YBJ','Baie Johan Beetz, Quebec, Cana');
insert into airport values('YBK','Baker Lake, Nwt, Canada');
insert into airport values('YBL','Campbell River, Bc, Canada-Ybl');
insert into airport values('YBM','Bronson Creek, Bc, Canada');
insert into airport values('YBP','Yibin, P. R. China');
insert into airport values('YBR','Brandon, Manitoba, Canada');
insert into airport values('YBT','Brochet, Manitoba, Canada');
insert into airport values('YBV','Berens River, Manitoba, Canada');
insert into airport values('YBW','Bedwell Harbor, Bc, Canada');
insert into airport values('YBX','Blanc Sablon, Quebec, Canada');
insert into airport values('YBY','Bonnyville, Alberta, Canada');
insert into airport values('YBZ','Toronto, Ontario, Cana-Downtow');
insert into airport values('YCA','Courtenay, Bc, Canada');
insert into airport values('YCB','Cambridge Bay, Nwt, Canada');
insert into airport values('YCC','Cornwall, Ontario, Canada');
insert into airport values('YCD','Nanaimo, Bc, Canada-Ycd');
insert into airport values('YCF','Cortes Bay, Bc, Canada');
insert into airport values('YCG','Castlegar, Bc, Canada');
insert into airport values('YCH','Chatham, Nb, Canada');
insert into airport values('YCI','Caribou Island, Ontario, Canad');
insert into airport values('YCJ','Cape St. James, Bc, Canada');
insert into airport values('YCK','Colville Lake, Nwt, Canada');
insert into airport values('YCL','Charlo, Nb, Canada');
insert into airport values('YCM','St. Catharines, Ontario, Canad');
insert into airport values('YCN','Cochrane, Ontario, Canada');
insert into airport values('YCO','Coppermine, Nwt, Canada');
insert into airport values('YCP','Co-Op Point, Manitoba, Canada');
insert into airport values('YCQ','Chetwynd, Bc, Canada');
commit;
insert into airport values('YCR','Cross Lake, Manitoba, Canada');
insert into airport values('YCS','Chesterfield Inlet, Nwt, Canad');
insert into airport values('YCU','Cullaton Lake, Nwt, Canada');
insert into airport values('YCV','Cartierville, Quebec, Canada');
insert into airport values('YCW','Chilliwack, Bc, Canada');
insert into airport values('YCX','Gagetown, Nb, Canada');
insert into airport values('YCY','Clyde River, Nwt, Canada');
insert into airport values('YCZ','Creston, Bc, Canada');
insert into airport values('YDA','Dawson City, Yt, Canada');
insert into airport values('YDB','Burwash Landings, Yt, Canada');
insert into airport values('YDC','Drayton Valley, Alberta, Canad');
insert into airport values('YDE','Paradise River, Nfld, Canada');
insert into airport values('YDF','Deer Lake, Nfld, Canada');
insert into airport values('YDG','Digby, Ns, Canada');
insert into airport values('YDI','Davis Inlet, Nfld, Canada');
insert into airport values('YDK','Main Duck Island, Ontario, Can');
insert into airport values('YDL','Dease Lake, Bc, Canada');
insert into airport values('YDN','Dauphin, Manitoba, Canada');
insert into airport values('YDO','Dolbeau, Quebec, Canada');
insert into airport values('YDP','Nain, Nfld, Canada');
insert into airport values('YDQ','Dawson Creek, Bc, Canada');
insert into airport values('YDR','Broadview, Sask, Canada');
insert into airport values('YDS','Desolation Sound, Bc, Canada');
insert into airport values('YDT','Vancouver, Bc, Canada-Boundary');
insert into airport values('YDX','Doc Creek, Bc, Canada');
insert into airport values('YEA','Edmonton, Alberta, Can-Namao F');
insert into airport values('YEC','Yechon, Republic Of Korea');
insert into airport values('YED','Edmonton, Alberta, Can-Namao F');
insert into airport values('YEG','Edmonton, Alberta, Can-Intl');
insert into airport values('YEI','Ennadai Lake, Nwt, Canada');
commit;
insert into airport values('YEK','Eskimo Point, Nwt, Canada');
insert into airport values('YEL','Elliot Lake, Ontario, Canada');
insert into airport values('YEN','Estevan, Sask, Canada');
insert into airport values('YEO','Yeovilton, England Uk');
insert into airport values('YEP','Estevan Point, Bc, Canada');
insert into airport values('YEQ','Yenkis, Papua New Guinea');
insert into airport values('YER','Fort Severn, Ontario, Canada');
insert into airport values('YET','Edson, Alberta, Canada');
insert into airport values('YEU','Eureka, Nwt, Canada');
insert into airport values('YEV','Inuvik, Nwt, Canada');
insert into airport values('YEY','Amos, Quebec, Canada');
insert into airport values('YFA','Fort Albany, Ontario, Canada');
insert into airport values('YFB','Iqaluit, Nwt, Canada');
insert into airport values('YFC','Fredericton, Nb, Canada');
insert into airport values('YFE','Forestville, Quebec, Canada');
insert into airport values('YFG','Fontanges, Quebec, Canada');
insert into airport values('YFH','Fort Hope, Ontario, Canada');
insert into airport values('YFL','Fort Reliance, Nwt, Canada');
insert into airport values('YFO','Flin Flon, Manitoba, Canada');
insert into airport values('YFR','Ft. Resolution, Nwt, Canada');
insert into airport values('YFS','Ft. Simpson, Nwt, Canada');
insert into airport values('YFX','Fox Harbour/St. Lewis, Nfld, C');
insert into airport values('YGA','Gagnon, Quebec, Canada');
insert into airport values('YGB','Gillies Bay, Bc, Canada');
insert into airport values('YGE','Gorge Harbor, Bc, Canada');
insert into airport values('YGG','Ganges Harbor, Bc, Canada');
insert into airport values('YGH','Ft. Good Hope, Nwt, Canada');
insert into airport values('YGJ','Yonago, Japan');
insert into airport values('YGK','Kingston, Ontario, Canada');
insert into airport values('YGL','La Grande, Quebec, Canada');
commit;
insert into airport values('YGM','Gimli, Manitoba, Canada');
insert into airport values('YGN','Greenway Sound, Bc, Canada');
insert into airport values('YGO','Gods Narrows, Manitoba, Canada');
insert into airport values('YGP','Gaspe, Quebec, Canada');
insert into airport values('YGQ','Geraldton, Ontario, Canada');
insert into airport values('YGR','Iles De La Madeleine, Quebec,');
insert into airport values('YGS','Germansen, Bc, Canada');
insert into airport values('YGT','Igloolik, Nwt, Canada');
insert into airport values('YGV','Havre St. Pierre, Quebec, Cana');
insert into airport values('YGW','Kuujjuarapik, Quebec, Canada');
insert into airport values('YGX','Gillam, Manitoba, Canada');
insert into airport values('YGY','Deception, Quebec, Canada');
insert into airport values('YGZ','Grise Fiord, Nwt, Canada');
insert into airport values('YHA','Port Hope Simpson, Nfld, Canad');
insert into airport values('YHB','Hudson Bay, Sask, Canada');
insert into airport values('YHC','Hakai Pass, Bc, Canada');
insert into airport values('YHD','Dryden, Ontario, Canada');
insert into airport values('YHE','Hope, Bc, Canada');
insert into airport values('YHF','Hearst, Ontario, Canada');
insert into airport values('YHG','Charlottetown, Nfld, Canada');
insert into airport values('YHH','Campbell River, Bc, Ca-Harbor');
insert into airport values('YHI','Holman Island, Nwt, Canada');
insert into airport values('YHK','Gjoa Haven, Nwt, Canada');
insert into airport values('YHM','Hamilton, Ontario, Canada');
insert into airport values('YHN','Hornepayne, Ontario, Canada');
insert into airport values('YHO','Hopedale, Nfld, Canada');
insert into airport values('YHP','Poplar Hill, Ontario, Canada');
insert into airport values('YHR','Harrington Harbour, Quebec, Ca');
insert into airport values('YHS','Sechelt, Bc, Canada');
insert into airport values('YHT','Haines Junction, Yt, Canada');
commit;
insert into airport values('YHU','Montreal, Quebec, Cana-St. Hub');
insert into airport values('YHY','Hay River, Nwt, Canada');
insert into airport values('YHZ','Halifax, Ns, Canada-Intl');
insert into airport values('YIB','Atikokan, Ontario, Canada');
insert into airport values('YIC','Isachsen, Nwt, Canada');
insert into airport values('YIF','Pakuashipi, Quebec, Canada');
insert into airport values('YIG','Big Bay Marina, Bc, Canada');
insert into airport values('YIH','Yichang, P. R. China');
insert into airport values('YIK','Ivujivik, Quebec, Canada');
insert into airport values('YIN','Yining, P. R. China');
insert into airport values('YIO','Pond Inlet, Nwt, Canada');
insert into airport values('YIP','Detroit, Michigan, Usa-Willow');
insert into airport values('YIV','Island Lake/Garden Hill, Man,');
insert into airport values('YIW','Yiwu, P. R. China');
insert into airport values('YIX','Port Radium, Nwt, Canada');
insert into airport values('YJA','Jasper, Alberta, Canada');
insert into airport values('YJF','Fort Liard, Nwt, Canada');
insert into airport values('YJN','St. Jean, Quebec, Canada');
insert into airport values('YJO','Johnny Mountain, Bc, Canada');
insert into airport values('YJT','Stephenville, Nfld, Canada');
insert into airport values('YKA','Kamloops, Bc, Canada');
insert into airport values('YKC','Collins Bay, Sask, Canada');
insert into airport values('YKD','Kincardine, Ontario, Canada');
insert into airport values('YKE','Knee Lake, Manitoba, Canada');
insert into airport values('YKF','Kitchener, Ontario, Canada');
insert into airport values('YKG','Kangirsuk, Quebec, Canada');
insert into airport values('YKJ','Key Lake, Sask, Canada');
insert into airport values('YKK','Kitkatla, Bc, Canada');
insert into airport values('YKL','Schefferville, Quebec, Canada');
insert into airport values('YKM','Yakima, Washington, Usa');
commit;
insert into airport values('YKN','Yankton, South Dakota, Usa');
insert into airport values('YKQ','Waskaganish, Quebec, Canada');
insert into airport values('YKS','Yakutsk, Ussr');
insert into airport values('YKT','Klemtu, Bc, Canada');
insert into airport values('YKU','Chisasibi, Quebec, Canada');
insert into airport values('YKX','Kirkland Lake, Ontario, Canada');
insert into airport values('YKY','Kindersley, Sask, Canada');
insert into airport values('YKZ','Toronto, Ontario, Cana-Buttonv');
insert into airport values('YLA','Langara, Bc, Canada');
insert into airport values('YLB','Lac Biche, Alberta, Canada');
insert into airport values('YLC','Lake Harbour, Nwt, Canada');
insert into airport values('YLD','Chapleau, Ontario, Canada');
insert into airport values('YLE','Lac La Martre, Nwt, Canada');
insert into airport values('YLF','Laforges, Quebec, Canada');
insert into airport values('YLG','Yalgoo, Wa, Australia');
insert into airport values('YLH','Lansdowne House, Ontario, Cana');
insert into airport values('YLJ','Meadow Lake, Sask, Canada');
insert into airport values('YLL','Lloydminster, Alberta, Canada');
insert into airport values('YLM','Clinton Creek, Yt, Canada');
insert into airport values('YLN','Yilan, P. R. China');
insert into airport values('YLP','Mingan, Quebec, Canada');
insert into airport values('YLQ','La Tuque, Quebec, Canada');
insert into airport values('YLR','Leaf Rapids, Manitoba, Canada');
insert into airport values('YLS','Lebel-Sur-Quevillon, Quebec, C');
insert into airport values('YLT','Alert, Nwt, Canada');
insert into airport values('YLW','Kelowna, Bc, Canada');
insert into airport values('YMA','Mayo, Yt, Canada');
insert into airport values('YMB','Merritt, Bc, Canada');
insert into airport values('YMC','Maricourt Airstrip, Quebec, Ca');
insert into airport values('YME','Matane, Quebec, Canada');
commit;
insert into airport values('YMF','Montague Harbor, Bc, Canada');
insert into airport values('YMG','Manitouwadge, Ontario, Canada');
insert into airport values('YMH','Mary''S Harbour, Nfld, Canada');
insert into airport values('YMI','Minaki, Ontario, Canada');
insert into airport values('YMJ','Moose Jaw, Sask, Canada');
insert into airport values('YML','Murray Bay, Quebec, Canada');
insert into airport values('YMM','Ft. Mcmurray, Alberta, Canada');
insert into airport values('YMN','Makkovik, Nfld, Canada');
insert into airport values('YMO','Moosonee, Ontario, Canada');
insert into airport values('YMP','Port Mcneil, Bc, Canada');
insert into airport values('YMQ','Montreal, Quebec, Cana-Mirabel');
insert into airport values('YMS','Yurimaguas, Peru');
insert into airport values('YMT','Chibougamau, Quebec, Canada');
insert into airport values('YMX','Montreal, Quebec, Cana-Mirabel');
insert into airport values('YNA','Natashquan, Quebec, Canada');
insert into airport values('YNB','Yanbu, Saudi Arabia');
insert into airport values('YNC','Wemindji, Quebec, Canada');
insert into airport values('YND','Gatineau/Hull, Quebec, Canada');
insert into airport values('YNE','Norway House, Manitoba, Canada');
insert into airport values('YNG','Youngstown, Ohio, Usa');
insert into airport values('YNH','Hudson Hope, Bc, Canada');
insert into airport values('YNI','Nitchequon, Quebec, Canada');
insert into airport values('YNJ','Yanji, P. R. China');
insert into airport values('YNK','Nootka Sound, Bc, Canada');
insert into airport values('YNL','Points North Landing, Sask, Ca');
insert into airport values('YNM','Matagami, Quebec, Canada');
insert into airport values('YNO','North Spirit Lake, Ontario, Ca');
insert into airport values('YNS','Nemiscau, Quebec, Canada');
insert into airport values('YNT','Yantai, P. R. China');
insert into airport values('YOC','Old Crow, Yt, Canada');
commit;
insert into airport values('YOD','Cold Lake, Alberta, Canada');
insert into airport values('YOE','Falher, Alberta, Canada');
insert into airport values('YOG','Ogoki, Ontario, Canada');
insert into airport values('YOH','Oxford House, Manitoba, Canada');
insert into airport values('YOJ','High Level, Alberta, Canada');
insert into airport values('YOK','Yokohama, Japan');
insert into airport values('YOL','Yola, Nigeria');
insert into airport values('YOO','Oshawa, Ontario, Canada');
insert into airport values('YOP','Rainbow Lake, Alberta, Canada');
insert into airport values('YOW','Ottawa, Ontario, Canada');
insert into airport values('YPA','Prince Albert, Sask, Canada');
insert into airport values('YPB','Port Alberni, Bc, Canada');
insert into airport values('YPC','Paulatuk, Nwt, Canada');
insert into airport values('YPD','Parry Sound, Ontario, Canada');
insert into airport values('YPE','Peace River, Alberta, Canada');
insert into airport values('YPF','Esquimalt, Bc, Canada');
insert into airport values('YPG','Portage La Prairie, Manitoba,');
insert into airport values('YPH','Inukjuak, Quebec, Canada');
insert into airport values('YPI','Port Simpson, Bc, Canada');
insert into airport values('YPJ','Aupaluk, Quebec, Canada');
insert into airport values('YPL','Pickle Lake, Ontario, Canada');
insert into airport values('YPM','Pikangikum, Ontario, Canada');
insert into airport values('YPN','Port Menier, Quebec, Canada');
insert into airport values('YPO','Peawanuck, Ontario, Canada');
insert into airport values('YPP','Pine Point, Nwt, Canada');
insert into airport values('YPQ','Peterborough, Ontario, Canada');
insert into airport values('YPR','Prince Rupert, Bc, Can-Digby I');
insert into airport values('YPS','Port Hawkesbury, Ns, Canada');
insert into airport values('YPT','Pender Harbor, Bc, Canada');
insert into airport values('YPW','Powell River, Bc, Canada');
commit;
insert into airport values('YPX','Povungnituk, Quebec, Canada');
insert into airport values('YPY','Ft. Chipewyan, Alberta, Canada');
insert into airport values('YPZ','Burns Lake, Bc, Canada');
insert into airport values('YQA','Muskoka, Ontario, Canada');
insert into airport values('YQB','Quebec, Quebec, Canada');
insert into airport values('YQC','Quaqtaq, Quebec, Canada');
insert into airport values('YQD','The Pas, Manitoba, Canada');
insert into airport values('YQE','Kimberley, Bc, Canada');
insert into airport values('YQF','Red Deer, Alberta, Canada');
insert into airport values('YQG','Windsor, Ontario, Canada');
insert into airport values('YQH','Watson Lake, Yt, Canada');
insert into airport values('YQI','Yarmouth, Ns, Canada');
insert into airport values('YQK','Kenora, Ontario, Canada');
insert into airport values('YQL','Lethbridge, Alberta, Canada');
insert into airport values('YQM','Moncton, Nb, Canada');
insert into airport values('YQN','Nakina, Ontario, Canada');
insert into airport values('YQQ','Comox, Bc, Canada');
insert into airport values('YQR','Regina, Sask, Canada');
insert into airport values('YQS','St. Thomas, Ontario, Canada');
insert into airport values('YQT','Thunder Bay, Ontario, Canada');
insert into airport values('YQU','Grande Prairie, Alberta, Canad');
insert into airport values('YQV','Yorkton, Sask, Canada');
insert into airport values('YQW','North Battleford, Sask, Canada');
insert into airport values('YQX','Gander, Nfld, Canada');
insert into airport values('YQY','Sydney, Ns, Canada');
insert into airport values('YQZ','Quesnel, Bc, Canada');
insert into airport values('YRA','Rae Lakes, Nwt, Canada');
insert into airport values('YRB','Resolute, Nwt, Canada');
insert into airport values('YRD','Dean River, Bc, Canada');
insert into airport values('YRE','Resolution Island, Nwt, Canada');
commit;
insert into airport values('YRF','Cartwright, Nfld, Canada');
insert into airport values('YRG','Rigolet, Nfld, Canada');
insert into airport values('YRI','Riviere Du Loup, Quebec, Canad');
insert into airport values('YRJ','Roberval, Quebec, Canada');
insert into airport values('YRL','Red Lake, Ontario, Canada');
insert into airport values('YRM','Rocky Mountain House, Alta, Ca');
insert into airport values('YRN','Rivers Inlet, Bc, Canada');
insert into airport values('YRQ','Three Rivers, Quebec, Canada');
insert into airport values('YRR','Stuart Island, Bc, Canada');
insert into airport values('YRS','Red Sucker Lake, Manitoba, Can');
insert into airport values('YRT','Rankin Inlet, Nwt, Canada');
insert into airport values('YRV','Revelstoke, Bc, Canada');
insert into airport values('YSA','Sable Island, Ns, Canada');
insert into airport values('YSB','Sudbury, Ontario, Canada');
insert into airport values('YSC','Sherbrooke, Quebec, Canada');
insert into airport values('YSD','Suffield, Alberta, Canada');
insert into airport values('YSE','Swan River, Manitoba, Canada');
insert into airport values('YSF','Stony Rapids, Sask, Canada');
insert into airport values('YSG','Snowdrift, Nwt, Canada');
insert into airport values('YSH','Smith Falls, Ontario, Canada');
insert into airport values('YSI','Sans Souci, Ontario, Canada');
insert into airport values('YSJ','Saint John, Nb, Canada');
insert into airport values('YSK','Sanikiluaq, Nwt, Canada');
insert into airport values('YSL','St. Leonard, Nb, Canada');
insert into airport values('YSM','Ft. Smith, Nwt, Canada');
insert into airport values('YSN','Salmon Arm, Bc, Canada');
insert into airport values('YSO','Postville, Nfld, Canada');
insert into airport values('YSP','Marathon, Ontario, Canada');
insert into airport values('YSR','Nanisivik, Nwt, Canada');
insert into airport values('YST','St. Therese Point, Manitoba, C');
commit;
insert into airport values('YSU','Summerside, Pei, Canada');
insert into airport values('YSV','Saglek, Nfld, Canada');
insert into airport values('YSX','Shearwater, Bc, Canada');
insert into airport values('YSY','Sachs Harbour, Nwt, Canada');
insert into airport values('YSZ','Squirrel Cove, Bc, Canada');
insert into airport values('YTA','Pembroke, Ontario, Canada');
insert into airport values('YTB','Hartley Bay, Bc, Canada');
insert into airport values('YTC','Sturdee, Bc, Canada');
insert into airport values('YTD','Thicket Portage, Manitoba, Can');
insert into airport values('YTE','Cape Dorset, Nwt, Canada');
insert into airport values('YTF','Alma, Quebec, Canada');
insert into airport values('YTG','Sullivan Bay, Bc, Canada');
insert into airport values('YTH','Thompson, Manitoba, Canada');
insert into airport values('YTJ','Terrace Bay, Ontario, Canada');
insert into airport values('YTK','Tulugak, Quebec, Canada');
insert into airport values('YTL','Big Trout Lake, Ontario, Canad');
insert into airport values('YTN','Riviere Au Tonnerre, Quebec, C');
insert into airport values('YTO','Toronto, Ontario, Cana-Pearson');
insert into airport values('YTP','Tofino, Bc, Canada-Spb');
insert into airport values('YTQ','Tasiujuaq, Quebec, Canada');
insert into airport values('YTR','Trenton, Ontario, Canada');
insert into airport values('YTS','Timmins, Ontario, Canada');
insert into airport values('YTT','Tisdale, Sask, Canada');
insert into airport values('YTX','Telegraph Creek, Bc, Canada');
insert into airport values('YTZ','Toronto, Ontario, Cana-Toronto');
insert into airport values('YUA','Yuanmou, P. R. China');
insert into airport values('YUB','Tuktoyaktuk, Nwt, Canada');
insert into airport values('YUD','Umiujaq, Quebec, Canada');
insert into airport values('YUE','Yuendumu, Nt, Australia');
insert into airport values('YUF','Pelly Bay, Nwt, Canada-Dewline');
commit;
insert into airport values('YUJ','Lady Franklin, Nwt, Canada');
insert into airport values('YUL','Montreal, Quebec, Cana-Dorval');
insert into airport values('YUM','Yuma, Arizona, Usa');
insert into airport values('YUN','Johnson Point, Nwt, Canada');
insert into airport values('YUT','Repulse Bay, Nwt, Canada');
insert into airport values('YUX','Hall Beach, Nwt, Canada');
insert into airport values('YUY','Rouyn-Noranda, Quebec, Canada');
insert into airport values('YVA','Moroni, Comoros-Iconi');
insert into airport values('YVB','Bonaventure, Quebec, Canada');
insert into airport values('YVC','La Ronge, Sask, Canada');
insert into airport values('YVD','Yeva, Papua New Guinea');
insert into airport values('YVE','Vernon, Bc, Canada');
insert into airport values('YVG','Vermilion, Alberta, Canada');
insert into airport values('YVM','Broughton Island, Nwt, Canada');
insert into airport values('YVN','Cape Dyer, Nwt, Canada');
insert into airport values('YVO','Val D''Or, Quebec, Canada');
insert into airport values('YVP','Kuujjuaq, Quebec, Canada');
insert into airport values('YVQ','Norman Wells, Nwt, Canada');
insert into airport values('YVR','Vancouver, Bc, Canada-Intl');
insert into airport values('YVT','Buffalo Narrows, Sask, Canada');
insert into airport values('YVV','Wiarton, Ontario, Canada');
insert into airport values('YVZ','Deer Lake, Ontario, Canada');
insert into airport values('YWA','Petawawa, Ontario, Canada');
insert into airport values('YWB','Kangiqsujuaq, Quebec, Canada');
insert into airport values('YWF','Halifax, Ns, Canada-Waterfront');
insert into airport values('YWG','Winnipeg, Manitoba, Canada');
insert into airport values('YWH','Victoria, Bc, Canada-Inner Har');
insert into airport values('YWJ','Fort Franklin, Nwt, Canada');
insert into airport values('YWK','Wabush, Nfld, Canada');
insert into airport values('YWL','Williams Lake, Bc, Canada');
commit;
insert into airport values('YWM','Williams Harbour, Nfld, Canada');
insert into airport values('YWN','Winisk, Ontario, Canada');
insert into airport values('YWP','Webequie, Ontario, Canada');
insert into airport values('YWR','White River, Ontario, Canada');
insert into airport values('YWS','Whistler, Bc, Canada');
insert into airport values('YWY','Wrigley, Nwt, Canada');
insert into airport values('YXC','Cranbrook, Bc, Canada');
insert into airport values('YXD','Edmonton, Alberta, Can-Municip');
insert into airport values('YXE','Saskatoon, Sask, Canada');
insert into airport values('YXF','Snake River, Yt, Canada');
insert into airport values('YXH','Medicine Hat, Alberta, Canada');
insert into airport values('YXI','Killaloe, Ontario, Canada');
insert into airport values('YXJ','Ft. St. John, Bc, Canada');
insert into airport values('YXK','Rimouski, Quebec, Canada');
insert into airport values('YXL','Sioux Lookout, Ontario, Canada');
insert into airport values('YXN','Whale Cove, Nwt, Canada');
insert into airport values('YXP','Pangnirtung, Nwt, Canada');
insert into airport values('YXR','Earlton, Ontario, Canada');
insert into airport values('YXS','Prince George, Bc, Canada');
insert into airport values('YXT','Terrace, Bc, Canada');
insert into airport values('YXU','London, Ontario, Canada');
insert into airport values('YXX','Abbotsford, Bc, Canada');
insert into airport values('YXY','Whitehorse, Yt, Canada');
insert into airport values('YXZ','Wawa, Ontario, Canada');
insert into airport values('YYA','Big Bay Yacht Club, Bc, Canada');
insert into airport values('YYB','North Bay, Ontario, Canada');
insert into airport values('YYC','Calgary, Alberta, Canada');
insert into airport values('YYD','Smithers, Bc, Canada');
insert into airport values('YYE','Ft. Nelson, Bc, Canada');
insert into airport values('YYF','Penticton, Bc, Canada');
commit;
insert into airport values('YYG','Charlottetown, Pei, Canada');
insert into airport values('YYH','Spence Bay, Nwt, Canada');
insert into airport values('YYI','Rivers, Manitoba, Canada');
insert into airport values('YYJ','Victoria, Bc, Canada-Intl');
insert into airport values('YYL','Lynn Lake, Manitoba, Canada');
insert into airport values('YYM','Cowley, Alberta, Canada');
insert into airport values('YYN','Swift Current, Sask, Canada');
insert into airport values('YYQ','Churchill, Manitoba, Canada');
insert into airport values('YYR','Goose Bay, Nfld, Canada');
insert into airport values('YYT','St. Johns, Nfld, Canada');
insert into airport values('YYU','Kapuskasing, Ontario, Canada');
insert into airport values('YYW','Armstrong, Ontario, Canada');
insert into airport values('YYY','Mont Joli, Quebec, Canada');
insert into airport values('YYZ','Toronto, Ontario, Cana-Pearson');
insert into airport values('YZA','Ashcroft, Bc, Canada');
insert into airport values('YZC','Beatton River, Bc, Canada');
insert into airport values('YZE','Gore Bay, Ontario, Canada');
insert into airport values('YZF','Yellowknife, Nwt, Canada');
insert into airport values('YZG','Salluit, Quebec, Canada');
insert into airport values('YZH','Slave Lake, Alberta, Canada');
insert into airport values('YZL','Liard River, Bc, Canada');
insert into airport values('YZM','Buchans, Nfld, Canada');
insert into airport values('YZP','Sandspit, Bc, Canada');
insert into airport values('YZR','Sarnia, Ontario, Canada');
insert into airport values('YZS','Coral Harbour, Nwt, Canada');
insert into airport values('YZT','Port Hardy, Bc, Canada');
insert into airport values('YZU','Whitecourt, Alberta, Canada');
insert into airport values('YZV','Sept-Iles, Quebec, Canada');
insert into airport values('YZW','Teslin, Yt, Canada');
insert into airport values('YZX','Greenwood, Ns, Canada');
commit;
insert into airport values('ZAA','Alice Arm/Kitsault, Bc, Canada');
insert into airport values('ZAC','York Landing, Manitoba, Canada');
insert into airport values('ZAD','Zadar, Yugoslavia');
insert into airport values('ZAG','Zagreb, Yugoslavia');
insert into airport values('ZAH','Zahedan, Iran, Islamic Rep. Of');
insert into airport values('ZAJ','Zaranj, Dem. Rep. Of Afghanist');
insert into airport values('ZAK','Chiusa/Klausen, Italy');
insert into airport values('ZAL','Valdivia, Chile');
insert into airport values('ZAM','Zamboanga, Philippines');
insert into airport values('ZAO','Cahors, France');
insert into airport values('ZAR','Zaria, Nigeria');
insert into airport values('ZAT','Zhaotong, P. R. China');
insert into airport values('ZAZ','Zaragoza, Spain');
insert into airport values('ZBE','Zabreh, Czechoslovakia');
insert into airport values('ZBF','Bathurst, Nb, Canada');
insert into airport values('ZBK','Zabljak, Yugoslavia');
insert into airport values('ZBL','Biloela, Qld, Australia');
insert into airport values('ZBN','Bozen, Italy');
insert into airport values('ZBO','Bowen, Qld, Australia');
insert into airport values('ZBR','Chah-Bahar, Iran, Islamic Rep.');
insert into airport values('ZBS','Mesa, Arizona, Usa-Bus Stn.');
insert into airport values('ZBV','Beaver Creek, Colorado, Usa');
insert into airport values('ZBY','Sayaboury, Laos');
insert into airport values('ZCL','Zacatecas, Mexico');
insert into airport values('ZCO','Temuco, Chile');
insert into airport values('ZDJ','Berne, Switzerland-Rr Station');
insert into airport values('ZEC','Secunda, South Africa');
insert into airport values('ZEG','Senggo, Indonesia');
insert into airport values('ZEL','Bella Bella, Bc, Canada');
insert into airport values('ZEM','East Main, Quebec, Canada');
commit;
insert into airport values('ZEN','Zenag, Papua New Guinea');
insert into airport values('ZER','Zero, India');
insert into airport values('ZFA','Faro, Yt, Canada');
insert into airport values('ZFB','Old Fort Bay, Quebec, Canada');
insert into airport values('ZFD','Fond Du Lac, Sask, Canada');
insert into airport values('ZFL','South Trout Lake, Ontario, Can');
insert into airport values('ZFM','Ft. Mcpherson, Nwt, Canada');
insert into airport values('ZFN','Ft. Norman, Nwt, Canada');
insert into airport values('ZFW','Fairview, Alberta, Canada');
insert into airport values('ZGC','Lanzhou, P. R. China-Zhongchua');
insert into airport values('ZGF','Grand Forks, Bc, Canada');
insert into airport values('ZGI','Gods River, Manitoba, Canada');
insert into airport values('ZGL','South Galway, Qld, Australia');
insert into airport values('ZGM','Ngoma, Zambia');
insert into airport values('ZGR','Little Grand Rapids, Man, Cana');
insert into airport values('ZGS','Gethsemani, Quebec, Canada');
insert into airport values('ZGU','Gaua, Vanuatu');
insert into airport values('ZHA','Zhanjiang, P. R. China');
insert into airport values('ZHM','Shamshernagar, Bangladesh');
insert into airport values('ZHP','High Prairie, Alberta, Canada');
insert into airport values('ZIC','Victoria, Chile');
insert into airport values('ZIG','Ziguinchor, Senegal');
insert into airport values('ZIH','Ixtapa/Zihuatanejo, Mexico');
insert into airport values('ZIN','Interlaken Ost, Switzerland');
insert into airport values('ZJG','Jenpeg, Manitoba, Canada');
insert into airport values('ZKB','Kasaba Bay, Zambia');
insert into airport values('ZKE','Kaschechewan, Ontario, Canada');
insert into airport values('ZKG','Kegaska, Quebec, Canada');
insert into airport values('ZKL','Steenkool, Indonesia');
insert into airport values('ZKM','Sette Cama, Gabon');
commit;
insert into airport values('ZKP','Kasompe, Zambia');
insert into airport values('ZLG','El Gouera, Mauritania');
insert into airport values('ZLO','Manzanillo, Mexico');
insert into airport values('ZLT','La Tabatiere, Quebec, Canada');
insert into airport values('ZMD','Sena Madureira, Ac, Brazil');
insert into airport values('ZMM','Zamora, Mexico');
insert into airport values('ZMR','Meran, Italy');
insert into airport values('ZMT','Masset, Bc, Canada');
insert into airport values('ZNA','Nanaimo, Bc, Canada-Harbour');
insert into airport values('ZNC','Nyac, Alaska, Usa');
insert into airport values('ZND','Zinder, Niger');
insert into airport values('ZNE','Newman, Wa, Australia');
insert into airport values('ZNG','Negginan, Manitoba, Canada');
insert into airport values('ZNU','Namu, Bc, Canada');

insert into airport values('ZNZ','Zanzibar, Tanzania');
insert into airport values('ZOF','Ocean Falls, Bc, Canada');
insert into airport values('ZOS','Osorno, Chile');
insert into airport values('ZPB','Sachigo Lake, Ontario, Canada');
insert into airport values('ZPC','Pucon, Chile');
insert into airport values('ZPH','Zephyrhills, Florida, Usa');
insert into airport values('ZPO','Pine House, Sask, Canada');
insert into airport values('ZQN','Queenstown, New Zealand');
insert into airport values('ZQS','Queen Charlotte Is, Bc, Canada');
insert into airport values('ZRA','Atlantic City, New Jer-Rr Stn');
insert into airport values('ZRH','Zurich, Switzerland');
insert into airport values('ZRI','Serui, Indonesia');
insert into airport values('ZRJ','Round Lake, Ontario, Canada');
insert into airport values('ZRM','Sarmi, Indonesia');
insert into airport values('ZRR','Arctic Red River, Nwt, Canada');
commit;
insert into airport values('ZSA','San Salvador, Bahamas');
insert into airport values('ZSE','Saint-Pierre De La Reunion, In');
insert into airport values('ZSH','Santa Fe, New Mexico-Bus Stn');
insert into airport values('ZSJ','Sandy Lake, Ontario, Canada');
insert into airport values('ZSP','St. Paul, Quebec, Canada');
insert into airport values('ZSS','Sassandra, Cote D''Ivoire');
insert into airport values('ZST','Stewart, Bc, Canada');
insert into airport values('ZSW','Prince Rupert, Bc, Can-Cove');
insert into airport values('ZSZ','Spiez, Switzerland');
insert into airport values('ZTA','Tureira, French Polynesia');
insert into airport values('ZTB','Tete A La Baleine, Quebec, Can');
insert into airport values('ZTH','Zakinthos, Greece');
insert into airport values('ZTJ','Interlaken West, Switzerland');
insert into airport values('ZTL','Telluride, Colorado, U-Bus Stn');
insert into airport values('ZTM','Shamattawa, Manitoba, Canada');
insert into airport values('ZTR','Zhitomir, Ussr');
insert into airport values('ZTS','Tahsis, Bc, Canada');
insert into airport values('ZUC','Ignace, Ontario, Canada');
insert into airport values('ZUD','Ancud, Chile');
insert into airport values('ZUE','Zuenoula, Cote D''Ivoire');
insert into airport values('ZUL','Zilfi, Saudi Arabia');
insert into airport values('ZUM','Churchill Falls, Nfld, Canada');
insert into airport values('ZVA','Miandrivazo, Dem. Rep. Madagas');
insert into airport values('ZVG','Springvale, Wa, Australia');
insert into airport values('ZVK','Savannakhet, Laos');
insert into airport values('ZWA','Andapa, Dem. Rep. Madagascar');
insert into airport values('ZWL','Wollaston Lake, Sask, Canada');
insert into airport values('ZWS','Stuttgart, Fed. Rep. O-Main Rr');
insert into airport values('ZYI','Zunyi, P. R. China');
insert into airport values('ZYL','Sylhet, Bangladesh');
commit;
insert into airport values('ZZU','Mzuzu, Malawi');
insert into airport values('ZZV','Zanesville, Ohio, Usa');
set echo on
set termout on
commit;
REM
REM The following will fail unless you're using Oracle8i
REM which supports functional indexes.
REM
create index airport_uppername_idx on airport(UPPER(description));

