<?xml version="1.0"?>
<!--
| $Author: kkarun $
| $Date: 20-apr-00.23:40:14 $
| $Source: /vobs/oracore3/demo/xdk/java/xsql/demo/common/rowcol.xsl.mkelem $
| $Revision: /main/0 $
+-->
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">

  <xsl:template match="/">
    <html>
      <head><link rel="stylesheet" type="text/css" href="../common/rowcol.css" />
      </head>
      <body class="page">
        <xsl:apply-templates/>      
      </body>
    </html>
  </xsl:template>

    <xsl:template match="ROWSET">
      <center>
      <table border="0" cellpadding="4">
      <xsl:choose>
        <xsl:when test="ROW">
	  <xsl:for-each select="ROW[1]">
	    <tr>
	      <xsl:for-each select="*[not(starts-with(name(.),'H_'))]">
		<th align="left">
		  <xsl:attribute name="class">
		    <xsl:choose>
		      <xsl:when test="position() mod 2 = 1">colodd</xsl:when>
		      <xsl:when test="position() mod 2 = 0">coleven</xsl:when>
		    </xsl:choose>
		  </xsl:attribute>
		  <xsl:value-of select="name(.)"/>
		</th>
	      </xsl:for-each>
	    </tr>
	  </xsl:for-each>
	  <xsl:apply-templates/>
        </xsl:when>
        <xsl:otherwise>
          <tr><td>No Matches</td></tr> 
        </xsl:otherwise>
      </xsl:choose>
      </table>
      </center>
    </xsl:template>

    <xsl:template match="ROW">
        <tr>
          <xsl:attribute name="class">
            <xsl:choose>
              <xsl:when test="position() mod 2 = 1">rowodd</xsl:when>
              <xsl:when test="position() mod 2 = 0">roweven</xsl:when>
            </xsl:choose>
          </xsl:attribute>
          <xsl:for-each select="*[not(starts-with(name(.),'H_'))]">
            <td>
	      <xsl:attribute name="class">
		<xsl:choose>
		  <xsl:when test="position() mod 2 = 1">colodd</xsl:when>
		  <xsl:when test="position() mod 2 = 0">coleven</xsl:when>
		</xsl:choose>
	      </xsl:attribute>
              <xsl:apply-templates select='.'/>
            </td>
          </xsl:for-each>
        </tr>
  </xsl:template>

</xsl:stylesheet>
