Rem
Rem $Header: olsu901.sql 08-dec-2004.11:41:04 cchui Exp $
Rem
Rem olsu901.sql
Rem
Rem Copyright (c) 2001, 2004, Oracle. All rights reserved.  
Rem
Rem    NAME
Rem      olsu901.sql - <one-line expansion of the name>
Rem
Rem    DESCRIPTION
Rem      This is the upgrade script for OLS from 9.0.1 to 9.2.
Rem
Rem    NOTES
Rem      Must be run as SYSDBA.
Rem
Rem      Immediately after this script you must run $ORACLE_HOME/admin/utlrp
Rem      as SYSDBA to validate invalid OLS objects. Then you must shutdown
Rem      and restart the database instance. 
Rem
Rem      Do not shutdown and restart the instance before running utlrp.
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    cchui       12/08/04 - Backport 3936531: use validate_ols 
Rem    srtata      12/08/03 - drop lbacrls_libt 
Rem    srtata      03/12/03 - add validate procedure when upgrading
Rem    shwong      01/14/02 - grant execute on dbms_registry to lbacsys.
Rem    rburns      10/31/01 - add dbms_registry call
Rem    shwong      10/26/01 - Merged shwong_upgdng
Rem    shwong      10/26/01 - Created
Rem

WHENEVER SQLERROR EXIT;

DECLARE
  compat         VARCHAR2(30);
BEGIN

-- Check compatible parameter
   select value into compat from v$parameter
   where name='compatible';
   if substr(compat,1,5) < '8.1.7' then
RAISE_APPLICATION_ERROR(-20000,
  'Compatibile init file parameter ' || compat ||
  ' must be >= 8.1.7 for OLS');
   end if;
END;
/

WHENEVER SQLERROR CONTINUE;

-- Disable system event triggers during upgrade
ALTER SYSTEM SET "_system_trig_enabled" = FALSE;

GRANT EXECUTE ON dbms_registry to LBACSYS;

-- indicate the upgrade process has begun
EXECUTE DBMS_REGISTRY.UPGRADING('OLS', 'Oracle Label Security', 'validate_ols');

DROP LIBRARY LBACSYS.LBAC$RLS_LIBT;

-- Load LBAC framework packages.
@@catlbac

-- Load SA policy packages.
@@catsa
@@catlabel

BEGIN
  dbms_registry.loaded('OLS', dbms_registry.release_version,
            'Oracle Label Security Release ' ||
            dbms_registry.release_version    ||
            ' - ' || dbms_registry.release_status);
  SYS.validate_ols;
END;
/
commit;
