# $Header: snmxwosd.tcl 19-apr-2004.15:20:43 xxu Exp $
#
# Copyright (c) 2000, 2004, Oracle Corporation.  All rights reserved.  
#
# NAME:
#
#  snmxwosd.tcl : This file contains the OSD definitions and procedures
#                 used by nmxw (webserver) Tcl scripts.
# $Log:  $
# $Log:  $
#
#


global nmxwosd_PathSeparator
set nmxwosd_PathSeparator "/"

#Load registry package
package ifneeded registry 1.1 [list load tclreg11.dll registry]
package require registry

#
# nmxwosd_getExecutableName Procedure
# returns the full path of the Apache executable to start/stop
#
proc nmxwosd_getExecutableName {serverRoot} {
	global oramsg
	append execFilename $serverRoot "\\apache.exe"
	if {![file exists $execFilename] } {
		set  output [format [msgtxt [NETWORK] nmxw 1000] $execFilename]
		orafail $output
	}
	return $execFilename;
}
# Find all the oracle homes installed on this machine by inspecting the registry.
# Multiple oracle home (MOH) compliant installer create homes under
# HKEY_LOCAL_MACHINE Software\\oracle as Home0, Home1 ...
#
# Returns the list of the form { oracleHome1 oracleHome2 ... oracleHomeN }

## This proc is only used for Windows NT
proc nmxwosd_getAllOracleHomes { } {
    global nmiconf_OracleHomeList

    set nmiconf_OracleHomeList {}
    if {[catch {registry keys HKEY_LOCAL_MACHINE\\Software\\Oracle} oracleKeyList] != 0} {
        error "Could not retrieve registry subkeys under HKEY_LOCAL_MACHINE\\Software\\Oracle"
    }

    foreach oracleKey $oracleKeyList {
        if {[string match "HOME*" $oracleKey] == 1} {
            if {[catch {registry get HKEY_LOCAL_MACHINE\\Software\\Oracle\\$oracleKey ORACLE_HOME} oracleHome] == 0} {
                set oracleHomeEntry {}
                set oracleHome [string trimright [string trim $oracleHome] "\\"]
                set homeNameResult [catch {registry get HKEY_LOCAL_MACHINE\\Software\\Oracle\\$oracleKey ORACLE_HOME_NAME} oracleHomeName]
                if {$homeNameResult != 0} {
                    # Its ok for HOME0 not to have ORACLE_HOME_NAME set
                    set oracleHomeName ""
                }
                lappend oracleHomeEntry $oracleHome
                lappend oracleHomeEntry [string trim $oracleHomeName]
                lappend nmiconf_OracleHomeList $oracleHomeEntry
            } else {
                if { [string compare [string toupper $oracleKey] HOME0] } {
                    # Its ok for HOME0 not to have ORACLE_HOME set
                }
            }
        }
    }

    # look for default Home.
    if {[catch {registry get HKEY_LOCAL_MACHINE\\Software\\Oracle ORACLE_HOME} defaultHome] == 0} {
        set defaultHome [string trimright [string trim $defaultHome] "\\"]
        set defaultHomeNameResult [catch {registry get HKEY_LOCAL_MACHINE\\Software\\Oracle ORACLE_HOME_NAME} defaultHomeName]
        if {$defaultHomeNameResult != 0} {
            set defaultHomeName ""
        }

        set defaultHomeEntry {}
        lappend defaultHomeEntry $defaultHome
        lappend defaultHomeEntry [string trim $defaultHomeName]
        if {[lsearch -exact $nmiconf_OracleHomeList $defaultHomeEntry ] == -1} {
            set nmiconf_OracleHomeList [linsert $nmiconf_OracleHomeList 0 $defaultHomeEntry]
        }
    }

    return $nmiconf_OracleHomeList
}

# Windows NT only Proc
proc nmxwosd_GetOracleHome {serverRoot} {
	global tcl_platform
      set platform $tcl_platform(platform)
      if { $platform == "unix" } {
		regsub {/Apache/Apache} $serverRoot "" OracleHome
      } elseif { $platform == "windows" } {
	      regsub -all {\\} $serverRoot {/} serverRoot
		regsub -nocase {/Apache/Apache} $serverRoot "" OracleHome
	}
	return $OracleHome
}

# Windows NT only Proc
proc nmxwosd_getHTTPServiceName {serverRoot} {
    global oramsg
	set OracleHomeName ""
	set OracleHome [nmxwosd_GetOracleHome $serverRoot]
	set AllOracleHomes [nmxwosd_getAllOracleHomes]

	foreach OracleHomeEntry $AllOracleHomes {
		set OracleHomeTmp [convertin $oramsg(agent_characterset) [lindex $OracleHomeEntry 0]]
		regsub -all {\\} $OracleHomeTmp {/} OracleHomeTmp
		if { $OracleHomeTmp == $OracleHome } {
		set OracleHomeName [convertin $oramsg(agent_characterset) [lindex $OracleHomeEntry 1]]
		}
	}
	append HTTPServiceName "Oracle" $OracleHomeName "HTTPServer"
	return $HTTPServiceName
}
proc nmxwosd_startupCommand {serverRoot args1 args2} {
	global oramsg
	set HTTPServiceName [nmxwosd_getHTTPServiceName $serverRoot]
	set ExecutableName [nmxwosd_getExecutableName $serverRoot]
        regsub -all {\\} $ExecutableName {\\\\} ExecutableName
	append startupCommand "exec " "cmd " "/c " "$ExecutableName " "-n " $HTTPServiceName " -k " "start"
	return $startupCommand
}

proc nmxwosd_ExtractLogFile {InputString sRoot} {
global tcl_platform

        #If the server Root starts with " remove it.
        if { [string index $sRoot 0] == "\"" } {
                set sRootList [split $sRoot \"]
                set sRoot [lindex $sRootList 1]
        }

        if { [string index $InputString 0] == "\"" } {
                set InputStringList [split $InputString \"]
                set tmpLogFile [lindex $InputStringList 1]
        } else {
                scan $InputString "%s " tmpLogFile
        }
	regsub -all {/} $tmpLogFile "\\" tmpLogFile
	if {[string index $tmpLogFile 0] == "\\"} {
		set drive [string range $sRoot 0 1]
		append LogFile $drive $tmpLogFile
		return $LogFile
	} elseif { [string index $tmpLogFile 1] == ":"} {
		return $tmpLogFile
	} elseif { [string index $tmpLogFile 0] == "|" } {
		return [string range $tmpLogFile 1 end]
	} else {
		append LogFile $sRoot "\\" $tmpLogFile
		return $LogFile
	}
}

proc nmxwosd_Shutdown {sRoot pidFile} {
	global oramsg tcl_platform

	set HTTPServiceName [nmxwosd_getHTTPServiceName $sRoot]
	set ExecutableName [nmxwosd_getExecutableName $sRoot]
	regsub -all {\\} $ExecutableName {\\\\} ExecutableName
	append shutdownCommand "exec " "cmd " "/c " "$ExecutableName " "-n " $HTTPServiceName " -k " "shutdown"

	if { [catch {eval $shutdownCommand } out] } {
	   set output [format [msgtxt [NETWORK] nmxw 1005] $out]
	   orafail $output
	}
	set output [format [msgtxt [NETWORK] nmxw 1003] $out]
	puts $output
}
