
Rem
Rem $Header: prvtlrsh.sql 08-sep-2005.10:31:18 jcwang Exp $
Rem
Rem prvtlrsh.sql
Rem
Rem Copyright (c) 2000, 2005, Oracle. All rights reserved.  
Rem
Rem    NAME
Rem      prvtlrsh.sql - <one-line expansion of the name>
Rem
Rem    DESCRIPTION
Rem      <short description of component this file declares/defines>
Rem
Rem    NOTES
Rem      <other useful comments, qualifications, etc.>
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    jcwang      09/08/05 - dbms_assert support 
Rem    jcwang      08/09/05 - backport:4447540
Rem    jcwang      06/18/02 - 92 Patch
Rem    jcwang      03/13/02 - bug#2262576: Fix geodetic tolerance conversion
Rem    jcwang      12/10/01 - Support unknown element (type 0)
Rem    jcwang      07/30/01 - fix sdo_point bug
Rem    jcwang      02/26/01 - add geodetic offset func.
Rem    jcwang      11/03/00 - Add LRS geodetic support
Rem    jcwang      10/04/00 - LRS Gtype QA
Rem    jcwang      09/29/00 - Add LRS Dim position in GTYPE
Rem    jcwang      09/12/00 - Add monotonic decreasing measure
Rem    jcwang      08/15/00 - Created
Rem    jcwang      08/15/00 - Created
Rem


--
--
-- Private LRS Package Functions/Procedures Header used by External LRS package
-- 
--

CREATE OR REPLACE PACKAGE md_lrs AUTHID current_user AS


   --
   -- OCI functions/procedures
   -- 

   PROCEDURE define_geom_segment_proc(geom_segment  IN OUT MDSYS.SDO_GEOMETRY,
   			              dim_array     IN MDSYS.SDO_DIM_ARRAY,
   			              start_measure IN NUMBER,
   			              end_measure   IN NUMBER,
				      use_3d        IN NUMBER DEFAULT NULL) ;

   PRAGMA RESTRICT_REFERENCES(define_geom_segment_proc, wnds, rnps, wnps);



   FUNCTION clip_geom_segment_fun(geom_segment  IN MDSYS.SDO_GEOMETRY,
			          dim_array     IN MDSYS.SDO_DIM_ARRAY,
			          start_measure IN NUMBER,
			          end_measure   IN NUMBER,
				  use_3d        IN NUMBER DEFAULT NULL)
   RETURN MDSYS.SDO_GEOMETRY DETERMINISTIC;
   PRAGMA RESTRICT_REFERENCES(clip_geom_segment_fun, wnds, rnps, wnps);


   FUNCTION concatenate_geom_segments_fun(geom_segment_1  IN MDSYS.SDO_GEOMETRY,
  				          dim_array_1     IN MDSYS.SDO_DIM_ARRAY,
  				          geom_segment_2  IN MDSYS.SDO_GEOMETRY,
		   	                  dim_array_2     IN MDSYS.SDO_DIM_ARRAY,
					  shift_segment_2 IN NUMBER DEFAULT 1,
					  use_3d          IN NUMBER DEFAULT NULL )
				   
   RETURN MDSYS.SDO_GEOMETRY DETERMINISTIC;
   PRAGMA RESTRICT_REFERENCES(concatenate_geom_segments_fun, wnds, rnps, wnps);



   FUNCTION locate_pt_fun(geom_segment IN MDSYS.SDO_GEOMETRY,
			  dim_array    IN MDSYS.SDO_DIM_ARRAY,
			  measure      IN NUMBER,
			  offset       IN NUMBER,
			  use_3d       IN NUMBER DEFAULT NULL)
   RETURN MDSYS.SDO_GEOMETRY DETERMINISTIC;
   PRAGMA RESTRICT_REFERENCES(locate_pt_fun, wnds, rnps, wnps);



   FUNCTION project_pt_fun(geom_segment  IN MDSYS.SDO_GEOMETRY,
			   dim_array     IN MDSYS.SDO_DIM_ARRAY,
			   point         IN MDSYS.SDO_GEOMETRY,
			   offset        OUT NUMBER,
		           use_3d        IN NUMBER DEFAULT NULL)

   RETURN MDSYS.SDO_GEOMETRY DETERMINISTIC;
   PRAGMA RESTRICT_REFERENCES(project_pt_fun, wnds, rnps, wnps);


   FUNCTION reverse_geometry_fun(geom          IN MDSYS.SDO_GEOMETRY,
		                 dim_array     IN MDSYS.SDO_DIM_ARRAY)

   RETURN MDSYS.SDO_GEOMETRY DETERMINISTIC;
   PRAGMA restrict_references(reverse_geometry_fun, wnds, rnps, wnps);



   FUNCTION offset_geom_segment_fun(geom_segment  IN MDSYS.SDO_GEOMETRY,
	                            dim_array     IN MDSYS.SDO_DIM_ARRAY,
				    start_measure IN NUMBER,
				    end_measure   IN NUMBER,
				    offset        IN NUMBER,
				    unit          IN VARCHAR2)


   RETURN MDSYS.SDO_GEOMETRY DETERMINISTIC;
   PRAGMA restrict_references(offset_geom_segment_fun, wnds, rnps, wnps);

   FUNCTION lrs_geom_length_3d(geom_segment IN MDSYS.SDO_GEOMETRY,
			       dim_array    IN MDSYS.SDO_DIM_ARRAY)
   RETURN NUMBER;
   PRAGMA restrict_references(lrs_geom_length_3d, wnds, rnps, wnps);



   --
   -- privtae LRS functions/procedures
   --

   --
   -- check if two given geometric segments are connected, return possible types
   -- -1: error
   -- 0: not connected
   -- 1: end1   = start2
   -- 2: end1   = end2
   -- 3: start1 = end2
   -- 4: start1 = start2
   --

   FUNCTION geom_segments_con_type(geom_segment_1 IN MDSYS.SDO_GEOMETRY,
  				   dim_array_1    IN MDSYS.SDO_DIM_ARRAY,
  				   geom_segment_2 IN MDSYS.SDO_GEOMETRY,
  				   dim_array_2    IN MDSYS.SDO_DIM_ARRAY)
				   
   RETURN NUMBER;
   PRAGMA RESTRICT_REFERENCES(geom_segments_con_type, wnds, rnps, wnps);

   FUNCTION geom_segments_con_type_3d(geom_segment_1 IN MDSYS.SDO_GEOMETRY,
  				      dim_array_1    IN MDSYS.SDO_DIM_ARRAY,
  				      geom_segment_2 IN MDSYS.SDO_GEOMETRY,
  				      dim_array_2    IN MDSYS.SDO_DIM_ARRAY)
				   
   RETURN NUMBER;
   PRAGMA RESTRICT_REFERENCES(geom_segments_con_type_3d, wnds, rnps, wnps);



--
-- Helper functions/procedures
--

   --
   -- check if two given sdo_ordinate_arrays are the same (against diminfo tolerances)
   --

   FUNCTION same_sdo_ordinate_array(array_1         IN MDSYS.SDO_ORDINATE_ARRAY,
			            array_2         IN MDSYS.SDO_ORDINATE_ARRAY,
			            tolerance_array IN MDSYS.SDO_ORDINATE_ARRAY,
				    no              IN NUMBER)
   RETURN VARCHAR2;
   PRAGMA RESTRICT_REFERENCES(same_sdo_ordinate_array, wnds, rnps, wnps);


   --
   -- Gtype filter, return the original Gtype, ignore the new dimensional information
   --			
   
   FUNCTION gtype_filter(gtype	IN NUMBER)
   RETURN NUMBER;
   PRAGMA RESTRICT_REFERENCES(gtype_filter, wnds, rnps, wnps);		


   --
   -- Diminfo contains LRS measure Dimension 'M'
   --

   FUNCTION contain_measure_dim(dim_array IN MDSYS.SDO_DIM_ARRAY)
   RETURN VARCHAR2;
   PRAGMA RESTRICT_REFERENCES(contain_measure_dim, wnds, rnps, wnps);

   FUNCTION contain_measure_dim_3d(dim_array IN MDSYS.SDO_DIM_ARRAY)
   RETURN VARCHAR2;
   PRAGMA RESTRICT_REFERENCES(contain_measure_dim_3d, wnds, rnps, wnps);

   --
   -- Reverse the measure information
   --

   FUNCTION reverse_m(geom_segment IN MDSYS.SDO_GEOMETRY,
		      dim_array    IN MDSYS.SDO_DIM_ARRAY)

   RETURN MDSYS.SDO_GEOMETRY DETERMINISTIC;
   PRAGMA restrict_references(reverse_m, wnds, rnps, wnps);


   -- check if the given v no is an element end point

   FUNCTION elem_end_pt(geom         IN MDSYS.SDO_GEOMETRY,
	                dim_array    IN MDSYS.SDO_DIM_ARRAY,
                        v_no         IN NUMBER) 

   RETURN VARCHAR2;
   PRAGMA restrict_references(elem_end_pt, wnds, rnps, wnps);


   --
   -- no of dimensions from gtype (post 816, 2 will be returned before 816)
   -- 

   FUNCTION no_of_dimensions(gtype IN NUMBER)
   RETURN NUMBER;
   PRAGMA RESTRICT_REFERENCES(no_of_dimensions, wnds, rnps, wnps);

   --
   -- no of elements 
   -- 

   FUNCTION no_of_elements(geom_segment IN MDSYS.SDO_GEOMETRY)
   RETURN NUMBER;
   PRAGMA RESTRICT_REFERENCES(no_of_elements, wnds, rnps, wnps);


   --
   -- no of vertexs
   -- 

   FUNCTION no_of_vertices(geom_segment IN MDSYS.SDO_GEOMETRY)
   RETURN NUMBER;
   PRAGMA RESTRICT_REFERENCES(no_of_vertices, wnds, rnps, wnps);


   --
   -- no of vertexs
   -- 

   FUNCTION no_of_vertices(geom_segment IN MDSYS.SDO_GEOMETRY,
			   dim_array    IN MDSYS.SDO_DIM_ARRAY)
   RETURN NUMBER;
   PRAGMA RESTRICT_REFERENCES(no_of_vertices, wnds, rnps, wnps);

   


   --
   -- Support Geometry for LRS
   --

   FUNCTION lrs_geometry(geom IN MDSYS.SDO_GEOMETRY)
   RETURN VARCHAR2;
   PRAGMA RESTRICT_REFERENCES(lrs_geometry, wnds, rnps, wnps);

   --
   -- supported geometry types
   --

   FUNCTION lrs_pt_gtype(gtype IN NUMBER)
   RETURN VARCHAR2;
   PRAGMA RESTRICT_REFERENCES(lrs_pt_gtype, wnds, rnps, wnps);

   FUNCTION lrs_segment_gtype(gtype IN NUMBER)
   RETURN VARCHAR2;
   PRAGMA RESTRICT_REFERENCES(lrs_segment_gtype, wnds, rnps, wnps);

   FUNCTION lrs_polygon_gtype(gtype IN NUMBER)
   RETURN VARCHAR2;
   PRAGMA RESTRICT_REFERENCES(lrs_polygon_gtype, wnds, rnps, wnps);

   FUNCTION lrs_multi_segments_gtype(gtype IN NUMBER)
   RETURN VARCHAR2;
   PRAGMA RESTRICT_REFERENCES(lrs_multi_segments_gtype, wnds, rnps, wnps);

   --
   -- a pure linestring geometry
   --

   FUNCTION linestring_geom(geom IN MDSYS.SDO_GEOMETRY)
   RETURN VARCHAR2;
   PRAGMA RESTRICT_REFERENCES(linestring_geom, wnds, rnps, wnps);


   FUNCTION monotonic_measure(geom_segment IN MDSYS.SDO_GEOMETRY,	
			      dim_array    IN MDSYS.SDO_DIM_ARRAY)
   RETURN INTEGER;
   PRAGMA RESTRICT_REFERENCES(monotonic_measure, wnds, rnps, wnps);



   FUNCTION next_non_null_ordinate(geom_segment  IN MDSYS.SDO_GEOMETRY, 
				   idx           IN OUT NUMBER,	
				   dim_no        IN NUMBER)
   RETURN NUMBER;
   PRAGMA RESTRICT_REFERENCES(next_non_null_ordinate, wnds, rnps, wnps);


   --
   -- snap the given point to the closest shape point of the geometry
   -- the start index of the snapped point is returned
   -- 

   FUNCTION snap_to_pt(geom_segment  IN MDSYS.SDO_GEOMETRY, 
		       dim_array     IN MDSYS.SDO_DIM_ARRAY,
		       point         IN MDSYS.SDO_GEOMETRY,
		       pt_dim_array  IN MDSYS.SDO_DIM_ARRAY ) 
   RETURN NUMBER;
   PRAGMA RESTRICT_REFERENCES(snap_to_pt, wnds, rnps, wnps);

   FUNCTION snap_to_pt_3d(geom_segment  IN MDSYS.SDO_GEOMETRY, 
			  dim_array     IN MDSYS.SDO_DIM_ARRAY,
			  point         IN MDSYS.SDO_GEOMETRY, 
		          pt_dim_array  IN MDSYS.SDO_DIM_ARRAY )
   RETURN NUMBER;
   PRAGMA RESTRICT_REFERENCES(snap_to_pt_3d, wnds, rnps, wnps);



   -- construct an dim_array from a geometry

   FUNCTION construct_dim_array(geometry   IN MDSYS.SDO_GEOMETRY,
			        tolerance  IN NUMBER DEFAULT 1.0e-8)

   RETURN MDSYS.SDO_DIM_ARRAY;
   PRAGMA restrict_references(construct_dim_array, wnds, rnps, wnps);

   -- construct an LRS GTYPE (dm0g)

   FUNCTION construct_lrs_gtype(geometry        IN MDSYS.SDO_GEOMETRY,
			        measure_dim_pos IN INTEGER DEFAULT NULL)


   RETURN NUMBER;
   PRAGMA restrict_references(construct_lrs_gtype, wnds, rnps, wnps);

   -- get the measure dimension position from gtype

   FUNCTION get_lrs_dim_pos(geometry        IN MDSYS.SDO_GEOMETRY)

   RETURN INTEGER;
   PRAGMA restrict_references(get_lrs_dim_pos, wnds, rnps, wnps);

   -- set the LRS measure dimension position in the geometry 

   PROCEDURE set_lrs_dim_pos(geometry        IN OUT MDSYS.SDO_GEOMETRY,
			    m_pos	    IN INTEGER) ;

   PRAGMA restrict_references(set_lrs_dim_pos, wnds, rnps, wnps);

   -- get the measure value from the vertex of the geometry

   FUNCTION get_m_value(geometry        IN MDSYS.SDO_GEOMETRY,
			vertex_no       IN INTEGER)
   RETURN NUMBER;
   PRAGMA restrict_references(get_m_value, wnds, rnps, wnps);

   FUNCTION get_m_value(geometry        IN MDSYS.SDO_GEOMETRY,
			vertex_no       IN INTEGER,
			dim_no		IN INTEGER,
			m_pos		IN INTEGER)
   RETURN NUMBER;
   PRAGMA restrict_references(get_m_value, wnds, rnps, wnps);

   -- set the measure value for the vertex of the geometry

   PROCEDURE set_m_value(geometry        IN OUT MDSYS.SDO_GEOMETRY,
			 vertex_no       IN INTEGER,
			 measure	 IN NUMBER);

   PRAGMA restrict_references(set_m_value, wnds, rnps, wnps);

   PROCEDURE set_m_value(geometry        IN OUT MDSYS.SDO_GEOMETRY,
			 vertex_no       IN INTEGER,
			 dim_no		 IN INTEGER,
			 m_pos	 	 IN INTEGER,
			 measure	 IN NUMBER);

   PRAGMA restrict_references(set_m_value, wnds, rnps, wnps);


   -- check if the given srid is geodetic 

   FUNCTION geodetic_srid(srid        IN NUMBER)
			      
   RETURN VARCHAR2;
   PRAGMA restrict_references(geodetic_srid, wnds, rnps, wnps);

   -- check if the given geometry is geodetic 

   FUNCTION geodetic_geometry(geometry        IN MDSYS.SDO_GEOMETRY)
			      
   RETURN VARCHAR2;
   PRAGMA restrict_references(geodetic_geometry, wnds, rnps, wnps);

   -- check if the given srid is projected coordinate system 

   FUNCTION projected_srid(srid        IN NUMBER)
			      
   RETURN VARCHAR2;
   PRAGMA restrict_references(projected_srid, wnds, rnps, wnps);

   -- check if the given geometry is projected 

   FUNCTION projected_geometry(geometry        IN MDSYS.SDO_GEOMETRY)
			      
   RETURN VARCHAR2;
   PRAGMA restrict_references(projected_geometry, wnds, rnps, wnps);



   -- check if tow given geometry have the same srid

   FUNCTION same_cs(geom1      IN MDSYS.SDO_GEOMETRY,
	            geom2      IN MDSYS.SDO_GEOMETRY) 
			      
   RETURN VARCHAR2;
   PRAGMA restrict_references(same_cs, wnds, rnps, wnps);

   --- check if the given geometry is an LRS geometry by checking its gtype (dm0t), in 9i

   FUNCTION lrs_geom_by_gtype(geom      IN MDSYS.SDO_GEOMETRY)
   RETURN VARCHAR2;
   PRAGMA restrict_references( lrs_geom_by_gtype, wnds, rnps, wnps);

   --- make a point geometry with right dimensions

   FUNCTION make_point_geom(point      IN MDSYS.SDO_GEOMETRY,
	                    dim_no     IN NUMBER,
			    pt_dim_no  IN NUMBER,
			    m_pos      IN NUMBER)
   RETURN MDSYS.SDO_GEOMETRY DETERMINISTIC;
   PRAGMA restrict_references(make_point_geom, wnds, rnps, wnps);

   -- adjust start/end measure if any of them is null

   PROCEDURE adjust_measure(geom_segment  IN  MDSYS.SDO_GEOMETRY,
	                    dim_array     IN  MDSYS.SDO_DIM_ARRAY,
   			    start_measure IN  OUT NUMBER,
   			    end_measure   IN  OUT NUMBER,
                            fun_type      IN  INTEGER) ;


   PRAGMA RESTRICT_REFERENCES(adjust_measure, wnds, rnps, wnps);

   -- adjust start/end measure if any of them is null

   PROCEDURE adjust_measure_3d(geom_segment  IN  MDSYS.SDO_GEOMETRY,
	                       dim_array     IN  MDSYS.SDO_DIM_ARRAY,
   			       start_measure IN  OUT NUMBER,
   			       end_measure   IN  OUT NUMBER,
			       fun_type      IN  INTEGER);


   PRAGMA RESTRICT_REFERENCES(adjust_measure_3d, wnds, rnps, wnps);

   -- check if the given geometry has unknown elements (type 0)

   FUNCTION contains_unknown_elem(geom      IN MDSYS.SDO_GEOMETRY)
			      
   RETURN VARCHAR2;
   PRAGMA restrict_references(contains_unknown_elem, wnds, rnps, wnps);


   FUNCTION clean_geometry_fun(geom          IN MDSYS.SDO_GEOMETRY,
		               dim_array     IN MDSYS.SDO_DIM_ARRAY)

   RETURN MDSYS.SDO_GEOMETRY DETERMINISTIC;
   PRAGMA restrict_references(clean_geometry_fun, wnds, rnps, wnps);


   FUNCTION clean_geometry(geom          IN MDSYS.SDO_GEOMETRY,
			   dim_array     IN MDSYS.SDO_DIM_ARRAY)

   RETURN MDSYS.SDO_GEOMETRY DETERMINISTIC;
   PRAGMA restrict_references(clean_geometry, wnds, rnps, wnps);


   FUNCTION clean_geometry(geom          IN MDSYS.SDO_GEOMETRY)

   RETURN MDSYS.SDO_GEOMETRY DETERMINISTIC;
   PRAGMA restrict_references(clean_geometry, wnds, rnps, wnps);

   FUNCTION connection_type_fun(geom_segment_1          IN MDSYS.SDO_GEOMETRY,
		                dim_array_1     	IN MDSYS.SDO_DIM_ARRAY,
				geom_segment_2          IN MDSYS.SDO_GEOMETRY,
		                dim_array_2     	IN MDSYS.SDO_DIM_ARRAY,
				use_3d			IN NUMBER )

   RETURN NUMBER ;
   PRAGMA restrict_references(connection_type_fun, wnds, rnps, wnps);

   FUNCTION is_defined_fun(geom_segment          IN MDSYS.SDO_GEOMETRY,
	                   dim_array     	 IN MDSYS.SDO_DIM_ARRAY)

   RETURN NUMBER ;
   PRAGMA restrict_references(is_defined_fun, wnds, rnps, wnps);

   PROCEDURE adjust_measure(geom_segment          IN MDSYS.SDO_GEOMETRY,
	                    dim_array     	  IN MDSYS.SDO_DIM_ARRAY,
			    old_ms		  IN NUMBER,
			    old_me		  IN NUMBER,
			    new_ms		  OUT NUMBER,
			    new_me	          OUT NUMBER) ;


   PRAGMA restrict_references(adjust_measure, wnds, rnps, wnps);




END md_lrs;
/

SHOW ERRORS;
