<?xml version="1.0" encoding="utf-8"?>
<!--

 Copyright (c) 2006, 2010, Oracle and/or its affiliates. All rights reserved. 

NAME
    kuacomm.xsl
DESCRIPTION 
    XSLT stylesheet: common templates for SXML => ALTER_XML conversions
    This stylesheet imports kuscommc.xsl, common templates for both
    this and SXML => DDL conversions
MODIFIED        MM/DD/YY
    rapayne     03/15/10 - bug 9439234: add mesg for not_alterable columns ref'ed
                           in virtual column expressions.
    lbarton     10/08/09 - bug 8796742: translatable error messages
    rapayne     11/09/09 - bug 8714709: CommonNotAlterable must check PRS_ALTERABLE.
    lbarton     07/08/08 - bug 5709159: UnquotedSourceName
    lbarton     01/24/08 - Bug 6724820: move VERSION param to kuscommc.xsl
    rapayne     12/21/06 - add AlterCOL_LIST template
    lbarton     09/22/06 - parse item support
    rapayne     06/09/06 - Add CmpObjects template.
    rapayne     05/24/06 - creation.
-->
<xsl:stylesheet version="1.0" xmlns:sxml="http://xmlns.oracle.com/ku" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
 <!-- Top level imports -->
 <xsl:import href="kuscommc.xsl"/>
 <!-- Parameters referenced by imported templates. They are never set
      by the ALTERXML transform, but they must be defined and have
      the specified values. -->
 <xsl:param name="PRETTY">0</xsl:param>
 <xsl:param name="SQLTERMINATOR">0</xsl:param>
 <xsl:param name="SEGMENT_ATTRIBUTES">1</xsl:param>
 <xsl:param name="STORAGE">1</xsl:param>
 <xsl:param name="TABLESPACE">1</xsl:param>
 <xsl:param name="PARTITIONING">1</xsl:param>
 <xsl:param name="CONSTRAINTS">1</xsl:param>
 <xsl:param name="REF_CONSTRAINTS">1</xsl:param>
 <!-- params for alter -->
 <xsl:param name="DROP_MISSING_COLUMNS">1</xsl:param>
 <xsl:param name="NOT_NULL_METHOD">AUTOMATIC</xsl:param>
 <!-- params for parse -->
 <xsl:param name="PRS_XPATH">0</xsl:param>
 <xsl:param name="PRS_XPATH_NS">sxml:</xsl:param>
 <xsl:param name="PRS_ALTERABLE">0</xsl:param>
 <xsl:param name="PRS_NAME">0</xsl:param>
 <xsl:param name="PRS_CLAUSE_TYPE">0</xsl:param>
 <!-- PRS_COLUMN_ATTRIBUTE defined in kuscommc -->
 <xsl:param name="PRS_CONSTRAINT_TYPE">0</xsl:param>
 <xsl:param name="PRS_CONSTRAINT_STATE">0</xsl:param>
 <xsl:param name="PRS_PARTITION_TYPE">0</xsl:param>
 <!-- params for error messages

    We have 2 mechanisms for telling a user that a diff can't be altered:
    1.If the user calls set_parse_item specifying ALTERABLE, we return 
      in the ALTER_XML document a NOT_ALTERABLE parse item 
      whose value indicates the reason.
    2.In the SQL text we also generate a comment with an error message.
    These mechanisms should match one-to-one: for each unique
    NOT_ALTERABLE value there should be one and only one error message.
    The error messages must be internationalized, i.e., the message
    text must be stored in a message file for translation.

    The following parameters (and the associated comments) form the core of
    the error reporting mechanism.  For each NOT_ALTERABLE reason there
    is a parameter whose name is the NOT_ALTERABLE parse item value
    prefixed with "MSG_", e.g., for RENAME_CLUSTER the parameter name
    is MSG_RENAME_CLUSTER.  The parameter has (1) an English-language
    default value, and (2) an associated error message in a message file.
    At run time the metadata API code calls SQLERRM to get the (potentially 
    translated) text from the message file and calls set_transform_param
    to pass it to the XSL stylesheet.  When the XSL code detects a diff
    that can't be altered, it calls the "CommonNotAlterable" template
    (defined in this module) which generates the appropriate ALTER_LIST_ITEM.
    Users of DBMS_METADATA_DIFF get the translated error, while those 
    who use the bare XSL stylesheet fall back on the untranslated
    English-language error.

    For maintainability, this file (kuacomm.xsl) contains for each message
    both the XSL parameter and (in a comment) the message number, text,
    cause and action; these last are in the correct format to be
    copied to the message file.

    Substitution strings: Any substitution string comes at the end of the
    message following a colon.  (For an example, see MSG_TABLE_TYPE, below.)
 -->
 <!-- kuaclus.xsl - clusters -->
 <xsl:param name="MSG_RENAME_CLUSTER">Cannot rename cluster.</xsl:param>
 <!--
39258, 00000, "Cannot rename cluster."
// *Cause:    DBMS_METADATA_DIFF was comparing two clusters with different 
//            names.  There is no SQL ALTER statement to rename a cluster.
// *Action:  The difference cannot be eliminated with an SQL ALTER statement.
 -->
 <xsl:param name="MSG_ADD_COLUMN">Cannot add column to cluster.</xsl:param>
 <!--
39259, 00000, "Cannot add column to cluster."
// *Cause:    DBMS_METADATA_DIFF was comparing two clusters with different 
//            column lists.  There is no SQL ALTER statement to add a column
//            to a cluster.
// *Action:  The difference cannot be eliminated with an SQL ALTER statement.
 -->
 <xsl:param name="MSG_DELETE_COLUMN">Cannot delete column from cluster.</xsl:param>
 <!--
39260, 00000, "Cannot delete column from cluster."
// *Cause:    DBMS_METADATA_DIFF was comparing two clusters with different 
//            column lists.  There is no SQL ALTER statement to delete a column
//            from a cluster.
// *Action:  The difference cannot be eliminated with an SQL ALTER statement.
 -->
 <xsl:param name="MSG_MODIFY_COLUMN">Cannot modify column in cluster. </xsl:param>
 <!--
39261, 00000, "Cannot modify column in cluster."
// *Cause:    DBMS_METADATA_DIFF was comparing two clusters with different 
//            column lists.  There is no SQL ALTER statement to modify a column
//            in a cluster.
// *Action:  The difference cannot be eliminated with an SQL ALTER statement.
 -->
 <xsl:param name="MSG_SIZE_ON_HASH_CLUSTER">Cannot alter size for hash cluster.</xsl:param>
 <!--
39262, 00000, "Cannot alter size for hash cluster."
// *Cause:    DBMS_METADATA_DIFF was comparing two hash clusters with
//            different sizes.  There is no SQL ALTER statement to modify 
//            the size of a hash cluster.
// *Action:  The difference cannot be eliminated with an SQL ALTER statement.
 -->
 <xsl:param name="MSG_PARALLEL_INSTANCES">Cannot alter PARALLEL INSTANCES.</xsl:param>
 <!--
39263, 00000, "Cannot alter PARALLEL INSTANCES."
// *Cause:    DBMS_METADATA_DIFF was comparing two objects, both with 
//            PARALLEL but with different INSTANCES values.
//            There is no SQL ALTER statement to modify PARALLEL INSTANCES.
// *Action:  The difference cannot be eliminated with an SQL ALTER statement.
 -->
 <!-- kuatable.xsl - tables -->
 <xsl:param name="MSG_TABLE_TYPE">Cannot alter type of table: </xsl:param>
 <!--
39264, 00000, "Cannot alter type of table: %s"
// *Cause:    DBMS_METADATA_DIFF was comparing tables of different types:
//            relational table, object table or XMLType table.
//            There is no SQL ALTER statement to change a table's type.
// *Action:  The difference cannot be eliminated with an SQL ALTER statement.
 -->
 <xsl:param name="MSG_OBJECT_TABLE_TYPE">Cannot alter object_type of object table: </xsl:param>
 <!--
39265, 00000, "Cannot alter object_type of object table: %s"
// *Cause:    DBMS_METADATA_DIFF was comparing object tables based on
//            different object types.  There is no SQL ALTER statement
//            to change an object table's object type.
// *Action:  The difference cannot be eliminated with an SQL ALTER statement.
 -->
 <xsl:param name="MSG_ADD_REM_OR_MOD_PARTITIONING">Cannot alter unpartitioned table to partitioned.</xsl:param>
 <!--
39266, 00000, "Cannot alter unpartitioned table to partitioned."
// *Cause:    DBMS_METADATA_DIFF was comparing two tables, one unpartitioned,
//            the other partitioned.  There is no SQL ALTER statement
//            to partition an unpartitioned table.
// *Action:  The difference cannot be eliminated with an SQL ALTER statement.
 -->
 <!-- kuatcol.xsl - table columns -->
 <xsl:param name="MSG_NO_DEFAULT">Cannot remove default from table column.</xsl:param>
 <!--
39267, 00000, "Cannot remove default from table column."
// *Cause:    DBMS_METADATA_DIFF was comparing two table columns, 
//            one with a default value, one without.  There is no SQL ALTER
//            syntax to remove a column default.
// *Action:  The difference cannot be eliminated with an SQL ALTER statement.
 -->
 <xsl:param name="MSG_VIRTUAL_REAL_CHANGE">Cannot alter a real column to make it virtual or vice versa.</xsl:param>
 <!--
39268, 00000, "Cannot alter a real column to make it virtual or vice versa."
// *Cause:    DBMS_METADATA_DIFF was comparing two table columns, 
//            one virtual, one real.  There is no SQL ALTER statement
//            to make a virtual column real or vice versa.
// *Action:  The difference cannot be eliminated with an SQL ALTER statement.
 -->
 <xsl:param name="MSG_CHANGE_LONG_DATATYPE">Cannot alter a column of type LONG to anything other than LOB.</xsl:param>
 <!--
39269, 00000, "Cannot alter a column of type LONG to anything other than LOB."
// *Cause:    DBMS_METADATA_DIFF was comparing two table columns, 
//            the first of type LONG, the second of a data type other than
//            LOB.  There is no SQL ALTER statement to modify a long data type
//            to anything other than a CLOB or NCLOB.
// *Action:  The difference cannot be eliminated with an SQL ALTER statement.
 -->
 <xsl:param name="MSG_CHANGE_LOB_DATATYPE">Cannot alter a LOB column to another data type.</xsl:param>
 <!--
39270, 00000, "Cannot alter a LOB column to another data type."
// *Cause:    DBMS_METADATA_DIFF was comparing two table columns, 
//            the first of type CLOB, NCLOB or BLOB, the second of 
//            some other data type.  There is no SQL ALTER statement to 
//            change the data type of a LOB column.
// *Action:  The difference cannot be eliminated with an SQL ALTER statement.
 -->
 <!-- kualob.xsl - table column attributes -->
 <xsl:param name="MSG_SUBSTITUTABLE_COLUMN">Cannot alter substitutability of column: </xsl:param>
 <!--
39271, 00000, "Cannot alter substitutability of column: %s"
// *Cause:    DBMS_METADATA_DIFF was comparing two table columns.
//            This error may occur because the first column is substitutable 
//            and the second column is not, or because the first column is 
//            OF TYPE and the second column is substitutable.
// *Action:  The difference cannot be eliminated with an SQL ALTER statement.
 -->
 <xsl:param name="MSG_NESTED_TABLE_ORGANIZATION">Cannot alter organization of nested table column: </xsl:param>
 <!--
39272, 00000, "Cannot alter organization of nested table column: %s"
// *Cause:    DBMS_METADATA_DIFF was comparing two nested table columns.
//            One was a heap table, the other an index-organized table.
//            There is no SQL ALTER statement to change the organization
//            of a nested table.
// *Action:  The difference cannot be eliminated with an SQL ALTER statement.
 -->
 <xsl:param name="MSG_XMLTYPE_STORAGE_TYPE">Cannot alter storage type of XMLType column: </xsl:param>
 <!--
39273, 00000, "Cannot alter storage type of XMLType column: %s"
// *Cause:    DBMS_METADATA_DIFF was comparing two XMLType columns
//            with different storage types (CLOB, BINARY, OBJECT RELATIONAL).
//            There is no SQL ALTER statement to change the storage type
//            of an XMLType column.
// *Action:  The difference cannot be eliminated with an SQL ALTER statement.
 -->
 <!-- kuatprop.xsl - table properties -->
 <xsl:param name="MSG_TABLE_ORGANIZATION">Cannot alter physical organization of table.</xsl:param>
 <!--
39274, 00000, "Cannot alter physical organization of table."
// *Cause:    DBMS_METADATA_DIFF was comparing two tables with different
//            physical organizations (heap, index organized, external, or
//            cluster). There is no SQL ALTER statement to change the
//            physical organization of a table.
// *Action:  The difference cannot be eliminated with an SQL ALTER statement.
 -->
 <xsl:param name="MSG_INITIAL">Cannot alter INITIAL storage option.</xsl:param>
 <!--
39275, 00000, "Cannot alter INITIAL storage option."
// *Cause:    DBMS_METADATA_DIFF was comparing two tables with different
//            FREELIST GROUPS storage options.
//            There is no SQL ALTER statement to change a table's
//            INITIAL storage option.
// *Action:  The difference cannot be eliminated with an SQL ALTER statement.
 -->
 <xsl:param name="MSG_MINEXTENTS">Cannot alter MINEXTENTS storage option.</xsl:param>
 <!--
39276, 00000, "Cannot alter MINEXTENTS storage option."
// *Cause:    DBMS_METADATA_DIFF was comparing two tables with different
//            MINEXTENTS storage options.
//            There is no SQL ALTER statement to change a table's
//            MINEXTENTS storage option.
// *Action:  The difference cannot be eliminated with an SQL ALTER statement.
 -->
 <xsl:param name="MSG_FREELIST_GROUPS">Cannot alter FREELIST GROUPS storage option.</xsl:param>
 <!--
39277, 00000, "Cannot alter FREELIST GROUPS storage option."
// *Cause:    DBMS_METADATA_DIFF was comparing two tables with different
//            FREELIST GROUPS storage options.
//            There is no SQL ALTER statement to change a table's
//            FREELIST GROUPS storage option.
// *Action:  The difference cannot be eliminated with an SQL ALTER statement.
 -->
 <xsl:param name="MSG_SEGMENT_CREATION_DEFERRED">Cannot alter table with segments to segment creation deferred.</xsl:param>
 <!--
39278, 00000, "Cannot alter table with segments to segment creation deferred."
// *Cause:    DBMS_METADATA_DIFF was comparing two tables, the first with
//            allocated segments, the second with deferred segments.
//            There is no SQL ALTER statement to change a table
//            which already has segments to segment creation deferred.
// *Action:  The difference cannot be eliminated with an SQL ALTER statement.
 -->
 <xsl:param name="MSG_OVERFLOW_TABLESPACE">Cannot alter tablespace of overflow segment.</xsl:param>
 <!--
39279, 00000, "Cannot alter tablespace of overflow segment."
// *Cause:    DBMS_METADATA_DIFF was comparing two index organized tables
//            whose overflow segments have different tablespaces.
//            There is no SQL ALTER statement to change an overflow segment's
//            tablespace.
// *Action:  The difference cannot be eliminated with an SQL ALTER statement.
 -->
 <xsl:param name="MSG_DROP_OVERFLOW">Cannot drop overflow segment.</xsl:param>
 <!--
39280, 00000, "Cannot drop overflow segment."
// *Cause:    DBMS_METADATA_DIFF was comparing two index organized tables,
//            the first with an overflow segment, the second without.
//            There is no SQL ALTER statement to drop an overflow segment.
// *Action:  The difference cannot be eliminated with an SQL ALTER statement.
 -->
 <xsl:param name="MSG_MV_KEYCOMPRESS">Cannot alter COMPRESS in index organized materialized view.</xsl:param>
 <!--
39281, 00000, "Cannot alter COMPRESS in index-organized materialized view."
// *Cause:    DBMS_METADATA_DIFF was comparing two index organized
//            materialized views with different key compression values.
//            There is no SQL ALTER statement to modify the key compression
//            of an index organized materialized view.
// *Action:  The difference cannot be eliminated with an SQL ALTER statement.
 -->
 <!-- kuatpar.xsl - partitions -->
 <xsl:param name="MSG_DEFAULT_PARTITION_TABLESPACE">Cannot alter default tablespace of partitions in partitioned table.</xsl:param>
 <!--
39282, 00000, "Cannot alter default tablespace of partitions in partitioned table."
// *Cause:    DBMS_METADATA_DIFF was comparing two partitioned tables
//            with different default tablespaces.
//            There is no SQL ALTER statement to change the default
//            tablespace of a partitioned table.
// *Action:  The difference cannot be eliminated with an SQL ALTER statement.
 -->
 <xsl:param name="MSG_DROP_HASH_PARTITION">Cannot drop, split or merge hash partition: </xsl:param>
 <!--
39283, 00000, "Cannot drop, split or merge hash partition: %s"
// *Cause:    DBMS_METADATA_DIFF was comparing two tables or indexes
//            partitioned or subpartitioned by hash, and a 
//            (sub)partition in the first object was not present
//            in the second object.
//            Partition maintenance operations such as drop, split
//            or merge can only be performed on list or range
//            (sub)partitioned objects.
// *Action:  The difference cannot be eliminated with an SQL ALTER statement.
 -->
 <xsl:param name="MSG_SUBPARTITION_LIST_VALUES">Cannot alter the list values of a list subpartition: </xsl:param>
 <!--
39284, 00000, "Cannot alter the list values of a list subpartition: %s"
// *Cause:    DBMS_METADATA_DIFF was comparing two tables subpartitioned
//            by list, one of which has a subpartition with the same name
//            but a different values list as a subpartition in the other.
//            There is no SQL ALTER statement to change the list values
//            of a list subpartition.
// *Action:  The difference cannot be eliminated with an SQL ALTER statement.
 -->
 <!-- kuaindex.xsl - indexes -->
 <xsl:param name="MSG_KEY_COMPRESSION">Cannot alter index key compression.</xsl:param>
 <!--
39285, 00000, "Cannot alter index key compression."
// *Cause:    DBMS_METADATA_DIFF was comparing two indexes with different
//            values of key compression.
//            There is no SQL ALTER statement to change index key compression.
// *Action:  The difference cannot be eliminated with an SQL ALTER statement.
 -->
 <xsl:param name="MSG_INCOMPATIBLE_INDEX">Cannot convert between types of index.</xsl:param>
 <!--
39286, 00000, "Cannot convert between types of index."
// *Cause:    DBMS_METADATA_DIFF was comparing two indexes of different
//            types, for example, a table index, a domain index, 
//            a cluster index, a bitmap index or a bitmap join index
//            There is no SQL ALTER statement to change the type of
//            an index.
// *Action:  The difference cannot be eliminated with an SQL ALTER statement.
 -->
 <xsl:param name="MSG_INDEX_COLUMNS">Cannot alter index column list.</xsl:param>
 <!--
39287, 00000, "Cannot alter index column list."
// *Cause:    DBMS_METADATA_DIFF was comparing two indexes with different
//            column lists.
//            There is no SQL ALTER statement to change the columns
//            of an index.
// *Action:  The difference cannot be eliminated with an SQL ALTER statement.
 -->
 <xsl:param name="MSG_ON_TABLE">Cannot alter index base table.</xsl:param>
 <!--
39288, 00000, "Cannot alter index base table."
// *Cause:    DBMS_METADATA_DIFF was comparing two table indexes
//            defined on different tables.
//            There is no SQL ALTER statement to change the base table
//            of an index.
// *Action:  The difference cannot be eliminated with an SQL ALTER statement.
 -->
 <xsl:param name="MSG_DROP_ADD_LOCAL_PARTITION">Cannot add or drop local index partition or subpartition: </xsl:param>
 <!--
39289, 00000, "Cannot add or drop local index partition or subpartition: %s"
// *Cause:    DBMS_METADATA_DIFF was comparing two locally partitioned indexes
//            with different partitions or subpartitions.
//            There is no SQL ALTER statement to add or drop
//            a partition or subpartition of a locally partitioned index.
// *Action:  The difference cannot be eliminated with an SQL ALTER statement.
 -->
 <xsl:param name="MSG_DROP_GLOBAL_PARTITION">Cannot drop a partition of a globally partitioned index.</xsl:param>
 <!--
39290, 00000, "Cannot drop a partition of a globally partitioned index."
// *Cause:    DBMS_METADATA_DIFF was comparing two globally partitioned indexes
//            and a partition in the first index does not exist in the second
//            index. There is no SQL ALTER statement to drop a partition of a
//            globally partitioned index.
// *Action:  The difference cannot be eliminated with an SQL ALTER statement.
 -->
 <xsl:param name="MSG_STORAGE">Cannot alter index storage option: </xsl:param>
 <!--
39291, 00000, "Cannot alter index storage option: %s"
// *Cause:    DBMS_METADATA_DIFF was comparing two indexes with different
//            values for the specified storage option.
//            There is no SQL ALTER statement to change this storage option.
// *Action:  The difference cannot be eliminated with an SQL ALTER statement.
 -->
 <xsl:param name="MSG_JOIN_TABLE">Cannot alter join table of bitmap join index.</xsl:param>
 <!--
39292, 00000, "Cannot alter join table of bitmap join index."
// *Cause:    DBMS_METADATA_DIFF was comparing two bitmap join indexes
//            with different join tables.
//            There is no SQL ALTER statement to alter the join tables
//            of a bitmap join index.
// *Action:  The difference cannot be eliminated with an SQL ALTER statement.
 -->
 <xsl:param name="MSG_JOIN_CONDITION">Cannot alter join condition of bitmap join index.</xsl:param>
 <!--
39293, 00000, "Cannot alter join condition of bitmap join index."
// *Cause:    DBMS_METADATA_DIFF was comparing two bitmap join indexes
//            with different join conditions.
//            There is no SQL ALTER statement to alter the join condition
//            of a bitmap join index.
// *Action:  The difference cannot be eliminated with an SQL ALTER statement.
 -->
 <xsl:param name="MSG_DOMAIN_INDEX_INDEXTYPE">Cannot alter indextype of domain index.</xsl:param>
 <!--
39294, 00000, "Cannot alter indextype of domain index."
// *Cause:    DBMS_METADATA_DIFF was comparing two bitmap domain indexes
//            with different indextypes.
//            There is no SQL ALTER statement to alter the indextype
//            of a domain index.
// *Action:  The difference cannot be eliminated with an SQL ALTER statement.
 -->
 <xsl:param name="MSG_ON_CLUSTER">Cannot alter index base cluster.</xsl:param>
 <!--
39295, 00000, "Cannot alter index base cluster."
// *Cause:    DBMS_METADATA_DIFF was comparing two cluster indexes
//            defined on different clusters.
//            There is no SQL ALTER statement to change the base cluster
//            of a cluster index.
// *Action:  The difference cannot be eliminated with an SQL ALTER statement.
 -->
 <xsl:param name="MSG_INCOMPATIBLE_PARTITIONING">Cannot alter index partitioning type or partitioning columns.</xsl:param>
 <!--
39296, 00000, "Cannot alter index partitioning type or partitioning columns."
// *Cause:    DBMS_METADATA_DIFF was comparing two indexes with incompatible
//            partitioning: 
//            (1) one is partitioned and one is not
//            (2) both are partitioned but in different ways 
//                (locally vs. globally, hash vs. range)
//            (3) both are partitioned but on different columns.
//            There is no SQL ALTER statement to change the way an index
//            is partitioned.
// *Action:  The difference cannot be eliminated with an SQL ALTER statement.
 -->
 <!-- kuamv.xsl - materialized views -->
 <xsl:param name="MSG_INCOMPATIBLE_MV_ATTRIBUTE">Cannot alter materialized view attribute: </xsl:param>
 <!--
39297, 00000, "Cannot alter materialized view attribute: %s"
// *Cause:    DBMS_METADATA_DIFF was comparing two materialized views
//            with incompatible attributes.
//            There is no SQL ALTER statement to change this attribute
//            of a materialized view.
// *Action:  The difference cannot be eliminated with an SQL ALTER statement.
 -->
 <xsl:param name="MSG_INCOMPATIBLE_MV_PARTITIONING">Cannot alter materialized view partitioning type or partitioning columns.</xsl:param>
 <!--
39298, 00000, "Cannot alter materialized view partitioning type or partitioning columns."
// *Cause:    DBMS_METADATA_DIFF was comparing two materialized views 
//            with incompatible partitioning: 
//            (1) one is partitioned and one is not
//            (2) both are partitioned but in different ways 
//                (locally vs. globally, hash vs. range)
//            (3) both are partitioned but on different columns.
//            There is no SQL ALTER statement to change the way a materialized
//            view is partitioned.
// *Action:  The difference cannot be eliminated with an SQL ALTER statement.
 -->
 <xsl:param name="MSG_MV_PHYSICAL_ORGANIZATION">Cannot alter materialized view physical organization.</xsl:param>
 <!--
39299, 00000, "Cannot alter materialized view physical organization."
// *Cause:    DBMS_METADATA_DIFF was comparing two materialized views 
//            with different physical organizations: heap, index 
//            organized, etc.
//            There is no SQL ALTER statement to change the index organization
//            of a materialized view.
// *Action:  The difference cannot be eliminated with an SQL ALTER statement.
 -->
 <!-- kuamvl.xsl - materialized view logs -->
 <xsl:param name="MSG_INCOMPATIBLE_MVL_PARTITIONING">Cannot alter materialized view log partitioning type or partitioning columns.</xsl:param>
 <!--
39300, 00000, "Cannot alter materialized view log partitioning type or partitioning columns."
// *Cause:    DBMS_METADATA_DIFF was comparing two materialized view logs 
//            with incompatible partitioning: 
//            (1) one is partitioned and one is not
//            (2) both are partitioned but in different ways 
//                (locally vs. globally, hash vs. range)
//            (3) both are partitioned but on different columns.
//            There is no SQL ALTER statement to change the way a materialized
//            view log is partitioned.
// *Action:  The difference cannot be eliminated with an SQL ALTER statement.
 -->
 <xsl:param name="MSG_INVALID_MVL_AUGMENTATION">Cannot alter values recorded in materialized view log: </xsl:param>
 <!--
39301, 00000, "Cannot alter values recorded in materialized view log: %s"
// *Cause:    DBMS_METADATA_DIFF was comparing two materialized view logs 
//            that are recording different values, and the set of values
//            in the first materialized view log cannot be changed to that
//            in the second materialized view log.
//            The error message identifies the specific problem.
// *Action:  The difference cannot be eliminated with an SQL ALTER statement.
 -->
 <xsl:param name="MSG_MVL_TABLESPACE">Cannot alter tablespace of materialized view log.</xsl:param>
 <!--
39302, 00000, "Cannot alter tablespace of materialized view log."
// *Cause:    DBMS_METADATA_DIFF was comparing two materialized view logs
//            which have different tablespaces.
//            There is no SQL ALTER statement to change the tablespace of
//            a materialized view log.
// *Action:  The difference cannot be eliminated with an SQL ALTER statement.
 -->
 <!-- kuaque.xsl - advanced queues -->
 <xsl:param name="MSG_AQ_QUEUE_ATTRIBUTE">Cannot alter attribute of queue: </xsl:param>
 <!--
39303, 00000, "Cannot alter attribute of queue: %s"
// *Cause:    DBMS_METADATA_DIFF was comparing two advanced queues
//            with attribute differences that cannot be reconciled.
//            The error message identifies the specific problem.
// *Action:  The difference cannot be eliminated with an SQL ALTER statement.
 -->
 <!-- kuaqtab.xsl - advanced queue tabless -->
 <xsl:param name="MSG_AQ_QUEUE_TABLE_ATTRIBUTE">Cannot alter attribute of queue table: </xsl:param>
 <!--
39304, 00000, "Cannot alter attribute of queue table: %s"
// *Cause:    DBMS_METADATA_DIFF was comparing two AQ queue tabless
//            with attribute differences that cannot be reconciled.
//            The error message identifies the specific problem.
// *Action:  The difference cannot be eliminated with an SQL ALTER statement.
 -->
 <!-- kuaseq.xsl - sequences -->
 <xsl:param name="MSG_SEQUENCE_ATTRIBUTE">Cannot alter attribute of sequence: </xsl:param>
 <!--
39305, 00000, "Cannot alter attribute of sequence: %s"
// *Cause:    DBMS_METADATA_DIFF was comparing two sequences
//            with attribute differences that cannot be reconciled.
//            The error message identifies the specific problem.
// *Action:  The difference cannot be eliminated with an SQL ALTER statement.
 -->
 <!-- kuatrig.xsl - triggers -->
 <xsl:param name="MSG_TRIGGER_ATTRIBUTE">Cannot alter attribute of trigger: </xsl:param>
 <!--
39306, 00000, "Cannot alter attribute of trigger: %s"
// *Cause:    DBMS_METADATA_DIFF was comparing two triggers
//            with differences that cannot be reconciled.
//            The error message identifies the specific problem.
// *Action:  The difference cannot be eliminated with an SQL ALTER statement.
 -->
 <!-- kuatype.xsl - types -->
 <xsl:param name="MSG_TYPE_ATTRIBUTE">Cannot alter attribute of type: </xsl:param>
 <!--
39307, 00000, "Cannot alter attribute of type: %s"
// *Cause:    DBMS_METADATA_DIFF was comparing two types
//            with differences that cannot be reconciled.
//            The error message identifies the specific problem.
// *Action:  The difference cannot be eliminated with an SQL ALTER statement.
 -->
 <!-- kuaview.xsl - views -->
 <xsl:param name="MSG_VIEW_ATTRIBUTE">Cannot alter attribute of view: </xsl:param>
 <!--
39308, 00000, "Cannot alter attribute of view: %s"
// *Cause:    DBMS_METADATA_DIFF was comparing two views
//            with differences that cannot be reconciled.
//            The error message identifies the specific problem.
// *Action:  The difference cannot be eliminated with an SQL ALTER statement.
 -->
 <!-- kuatbls.xsl - tablespaces -->
 <xsl:param name="MSG_BIGFILE">Cannot alter tablespace between bigfile and smallfile.</xsl:param>
 <!--
39309, 00000, "Cannot alter tablespace between bigfile and smallfile."
// *Cause:    DBMS_METADATA_DIFF was comparing two tablespaces,
//            one bigfile, one smallfile.
//            There is no SQL ALTER statement to change a tablespace 
//            from smallfile to bigfile or vice versa.
// *Action:  The difference cannot be eliminated with an SQL ALTER statement.
 -->
 <xsl:param name="MSG_TABLESPACE_TYPE">Cannot alter tablespace type.</xsl:param>
 <!--
39310, 00000, "Cannot alter tablespace type."
// *Cause:    DBMS_METADATA_DIFF was comparing two tablespaces of different
//            types: permanent, temporary or undo.
//            There is no SQL ALTER statement to change the type of
//            a tablespace.
// *Action:  The difference cannot be eliminated with an SQL ALTER statement.
 -->
 <xsl:param name="MSG_BLOCKSIZE">Cannot alter tablespace blocksize.</xsl:param>
 <!--
39311, 00000, "Cannot alter tablespace blocksize."
// *Cause:    DBMS_METADATA_DIFF was comparing two tablespaces with
//            different blocksizes.
//            There is no SQL ALTER statement to change the blocksize
//            of a tablespace.
// *Action:  The difference cannot be eliminated with an SQL ALTER statement.
 -->
 <xsl:param name="MSG_ENCRYPTION">Cannot alter tablespace encryption.</xsl:param>
 <!--
39312, 00000, "Cannot alter tablespace encryption."
// *Cause:    DBMS_METADATA_DIFF was comparing two tablespaces, one
//            encrypted, one not.
//            There is no SQL ALTER statement to change the encryption property
//            of a tablespace.
// *Action:  The difference cannot be eliminated with an SQL ALTER statement.
 -->
 <xsl:param name="MSG_FLASHBACK">Cannot alter tablespace flashback mode.</xsl:param>
 <!--
39313, 00000, "Cannot alter tablespace flashback mode."
// *Cause:    DBMS_METADATA_DIFF was comparing two tablespaces, one
//            in flashback mode, one not.
//            There is no SQL ALTER statement to alter the flashback mode
//            of a tablespace.
// *Action:  The difference cannot be eliminated with an SQL ALTER statement.
 -->
 <xsl:param name="MSG_EXTENT_MANAGEMENT">Cannot alter tablespace extent management.</xsl:param>
 <!--
39314, 00000, "Cannot alter tablespace extent_management."
// *Cause:    DBMS_METADATA_DIFF was comparing two tablespaces with
//            different extent management properties.
//            There is no SQL ALTER statement to alter the extent management
//            properties of a tablespace.
// *Action:  The difference cannot be eliminated with an SQL ALTER statement.
 -->
 <xsl:param name="MSG_DROP_FIRST_DATAFILE">Cannot drop the first data file from a permanent or undo tablespace.</xsl:param>
 <!--
39315, 00000, "Cannot drop the first data file from a permanent or undo tablespace."
// *Cause:    DBMS_METADATA_DIFF was comparing two permanent or undo 
//            tablespaces. The first data file in the first tablespace 
//            is missing from the second tablespace.  
//            There is no SQL ALTER statement to drop the first data file from
//            a permanent or undo tablespace.
// *Action:  The difference cannot be eliminated with an SQL ALTER statement.
 -->
 <xsl:param name="MSG_RESIZE_DATAFILE">Cannot resize a data file in a smallfile tablespace.</xsl:param>
 <!--
39316, 00000, "Cannot resize a data file in a smallfile tablespace."
// *Cause:    DBMS_METADATA_DIFF was comparing two smallfile tablespaces. 
//            A data file in the first tablespace is of a different size
//            from the corresponding data file in the second tablespace.
//            There is no SQL ALTER statement to resize a data file in
//            a smallfile tablespace.
// *Action:  The difference cannot be eliminated with an SQL ALTER statement.
 -->
 <xsl:param name="MSG_SEGMENT_SPACE_MANAGEMENT">Cannot change the segment space management of a tablespace.</xsl:param>
 <!--
39317, 00000, "Cannot change the segment space management of a tablespace."
// *Cause:    DBMS_METADATA_DIFF was comparing two tablespaces
//            with different segment space management.
//            There is no SQL ALTER statement to change the segment space
//            management of a tablespace.
// *Action:  The difference cannot be eliminated with an SQL ALTER statement.
 -->
 <!-- kuauser.xsl - users -->
 <xsl:param name="MSG_USER_NAME">Cannot alter user name.</xsl:param>
 <!--
39318, 00000, "Cannot alter user name."
// *Cause:    DBMS_METADATA_DIFF was comparing two users with different names.
//            There is no SQL ALTER statement to change the name of a user.
// *Action:  The difference cannot be eliminated with an SQL ALTER statement.
 -->
 <xsl:param name="MSG_UNEXPIRE_PASSWORD">Cannot undo password expiration.</xsl:param>
 <!--
39319, 00000, "Cannot undo password expiration."
// *Cause:    DBMS_METADATA_DIFF was comparing two users and the first user
//            had an expired password.
//            There is no SQL ALTER statement to undo the expiration
//            of a user password.
// *Action:  The difference cannot be eliminated with an SQL ALTER statement.
 -->
 <xsl:param name="MSG_VIRTUAL_COL_EXPRESSION">Cannot alter functional index or virtual expression column: </xsl:param>
 <!--
39321, 00000, ""Cannot alter functional index or virtual expression column: %s"
// *Cause:    Altered column is referenced in a virtual column or functional index expression.
//           There is no SQL ALTER statement to change a column which is referenced
//           in one of these types of expressions.
// *Action:  The difference cannot be eliminated with an SQL ALTER statement.
//
-->
 <!-- templates -->
 <xsl:template match="/">
 <!-- *******************************************************************
Top level template for all objects
******************************************************************** -->
  <xsl:apply-templates/>
 </xsl:template>
 <xsl:template name="Object1">
  <xsl:param name="ParentNode" select="''"/>
  <!-- *******************************************************************
Template: Object1
Parameters:
 ParentNode - Parent node of SCHEMA, NAME
******************************************************************** -->
  <xsl:element name="OBJECT1">
   <xsl:call-template name="ObjectSchemaName">
    <xsl:with-param name="ParentNode" select="$ParentNode"/>
    <xsl:with-param name="ObjectNumber">1</xsl:with-param>
   </xsl:call-template>
  </xsl:element>
 </xsl:template>
 <xsl:template name="Object2">
  <xsl:param name="ParentNode" select="''"/>
  <!-- *******************************************************************
Template: Object2
Parameters:
 ParentNode - Parent node of SCHEMA, NAME
******************************************************************** -->
  <xsl:element name="OBJECT2">
   <xsl:call-template name="ObjectSchemaName">
    <xsl:with-param name="ParentNode" select="$ParentNode"/>
    <xsl:with-param name="ObjectNumber">2</xsl:with-param>
   </xsl:call-template>
  </xsl:element>
 </xsl:template>
 <xsl:template name="CmpObjects">
  <xsl:param name="ParentNode" select="''"/>
  <!-- *******************************************************************
Template:  CmpObjects
Parameters:
 ParentNode - Parent node of SCHEMA, NAME for both object 1
                       and object2.
******************************************************************** -->
  <!-- Object 1 -->
  <xsl:call-template name="Object1">
   <xsl:with-param name="ParentNode" select="."/>
  </xsl:call-template>
  <!-- Object 2 -->
  <xsl:call-template name="Object2">
   <xsl:with-param name="ParentNode" select="."/>
  </xsl:call-template>
 </xsl:template>
 <xsl:template name="ObjectSchemaName">
  <xsl:param name="ParentNode" select="''"/>
  <xsl:param name="ObjectNumber">1</xsl:param>
  <!-- *******************************************************************
Template: ObjectSchemaName
Parameters:
 ParentNode - Parent node of SCHEMA, NAME
 ObjectNumber - 1 (default) or 2
******************************************************************** -->
  <xsl:if test="$ParentNode/sxml:SCHEMA">
   <xsl:element name="SCHEMA">
    <xsl:apply-templates select="$ParentNode/sxml:SCHEMA">
     <xsl:with-param name="ObjectNumber" select="$ObjectNumber"/>
    </xsl:apply-templates>
   </xsl:element>
  </xsl:if>
  <xsl:element name="NAME">
   <xsl:apply-templates select="$ParentNode/sxml:NAME">
    <xsl:with-param name="ObjectNumber" select="$ObjectNumber"/>
   </xsl:apply-templates>
  </xsl:element>
 </xsl:template>
 <xsl:template match="sxml:SCHEMA | sxml:NAME">
  <xsl:param name="ObjectNumber">1</xsl:param>
  <!-- *******************************************************************
Template: SCHEMA | NAME
Parameters:
 ObjectNumber - 1 (default) or 2
******************************************************************** -->
  <xsl:choose>
   <xsl:when test="$ObjectNumber=1 and @value1">
    <xsl:value-of select="@value1"/>
   </xsl:when>
   <xsl:otherwise>
    <xsl:value-of select="."/>
   </xsl:otherwise>
  </xsl:choose>
 </xsl:template>
 <xsl:template name="SchemaName">
  <xsl:param name="ParentNode" select="''"/>
  <!-- *******************************************************************
Template: SchemaName
 This template puts out "<schema>"."<name>"
Parameters:
 ParentNode - parent of SCHEMA and NAME
******************************************************************** -->
  <xsl:if test="$ParentNode/sxml:SCHEMA">
   <xsl:call-template name="SourceName">
    <xsl:with-param name="NameNode" select="$ParentNode/sxml:SCHEMA"/>
   </xsl:call-template>
   <xsl:text>.</xsl:text>
  </xsl:if>
  <xsl:call-template name="SourceName">
   <xsl:with-param name="NameNode" select="$ParentNode/sxml:NAME"/>
  </xsl:call-template>
 </xsl:template>
 <xsl:template name="SourceName">
  <xsl:param name="NameNode" select="''"/>
  <!-- *******************************************************************
Template: SourceName: emit the source name or schema.
 The schema/name values are from the value1 attribute, if present,
 otherwise the element content.  This lets the template handle the
 case of comparing object1 and object2 where the objects have different
 names or schemas.  The alter templates should always generate ALTERs
 to object1.  But if the objects have different names or schemas,
 object1's name and schema are in the value1 attribute rather than the
 element content, e.g.,
      <NAME value1="EMP1">EMP2</NAME>
Parameters:
 NameNode - NAME or SCHEMA node
******************************************************************** -->
  <xsl:choose>
   <xsl:when test="$NameNode/@value1">
    <xsl:call-template name="QuotedName">
     <xsl:with-param name="NameNode" select="$NameNode/@value1"/>
    </xsl:call-template>
   </xsl:when>
   <xsl:otherwise>
    <xsl:call-template name="QuotedName">
     <xsl:with-param name="NameNode" select="$NameNode"/>
    </xsl:call-template>
   </xsl:otherwise>
  </xsl:choose>
 </xsl:template>
 <xsl:template name="UnquotedSourceName">
  <xsl:param name="NameNode" select="''"/>
  <!-- *******************************************************************
Template: UnquotedSourceName: Like "SourceName" except the quotes are
 omitted.
Parameters:
 NameNode - NAME or SCHEMA node
******************************************************************** -->
  <xsl:choose>
   <xsl:when test="$NameNode/@value1">
    <xsl:value-of select="$NameNode/@value1"/>
   </xsl:when>
   <xsl:otherwise>
    <xsl:value-of select="$NameNode"/>
   </xsl:otherwise>
  </xsl:choose>
 </xsl:template>
 <xsl:template name="QuotedName">
  <xsl:param name="NameNode" select="''"/>
  <!-- *******************************************************************
Template: QuotedName
Parameters:
 NameNode - NAME node
******************************************************************** -->
  <xsl:if test="(not(contains($NameNode,'&quot;')))">"</xsl:if>
  <xsl:value-of select="$NameNode"/>
  <xsl:if test="(not(contains($NameNode,'&quot;')))">"</xsl:if>
 </xsl:template>
 <xsl:template name="AddParseItem">
  <xsl:param name="ParseIt">0</xsl:param>
  <xsl:param name="Item" select="''"/>
  <xsl:param name="Value1" select="''"/>
  <xsl:param name="Value2" select="''"/>
  <xsl:param name="Value3" select="''"/>
  <xsl:param name="Value4" select="''"/>
  <xsl:param name="Value5" select="''"/>
  <xsl:param name="Value6" select="''"/>
  <xsl:param name="Value7" select="''"/>
  <!-- *******************************************************************
Template: AddParseItem
Parameters:
 ParseIt : 1 = generate the parse item
 Item    : Item name
 Value1  : value
 Value2-7: if defined, these values are appended (space-separated) to Value1
******************************************************************** -->
  <xsl:if test="$ParseIt=1 and (string-length($Value1)!=0 or
                                string-length($Value2)!=0 or
                                string-length($Value3)!=0 or
                                string-length($Value4)!=0 or
                                string-length($Value5)!=0 or
                                string-length($Value6)!=0 or
                                string-length($Value7)!=0)">
   <xsl:element name="PARSE_LIST_ITEM">
    <xsl:element name="ITEM">
     <xsl:value-of select="$Item"/>
    </xsl:element>
    <xsl:element name="VALUE">
     <xsl:if test="string-length($Value1)!=0">
      <xsl:value-of select="$Value1"/>
     </xsl:if>
     <xsl:if test="string-length($Value2)!=0">
      <xsl:text> </xsl:text>
      <xsl:value-of select="$Value2"/>
     </xsl:if>
     <xsl:if test="string-length($Value3)!=0">
      <xsl:text> </xsl:text>
      <xsl:value-of select="$Value3"/>
     </xsl:if>
     <xsl:if test="string-length($Value4)!=0">
      <xsl:text> </xsl:text>
      <xsl:value-of select="$Value4"/>
     </xsl:if>
     <xsl:if test="string-length($Value5)!=0">
      <xsl:text> </xsl:text>
      <xsl:value-of select="$Value5"/>
     </xsl:if>
     <xsl:if test="string-length($Value6)!=0">
      <xsl:text> </xsl:text>
      <xsl:value-of select="$Value6"/>
     </xsl:if>
     <xsl:if test="string-length($Value7)!=0">
      <xsl:text> </xsl:text>
      <xsl:value-of select="$Value7"/>
     </xsl:if>
    </xsl:element>
   </xsl:element>
  </xsl:if>
 </xsl:template>
 <xsl:template name="AddXPathParseItem">
  <xsl:param name="Node" select="''"/>
  <!-- *******************************************************************
Template: AddXPathParseItem
Parameters:
 Node - Node whose XPath we generate
******************************************************************** -->
  <xsl:if test="$PRS_XPATH=1">
   <xsl:element name="PARSE_LIST_ITEM">
    <xsl:element name="ITEM">XPATH</xsl:element>
    <xsl:element name="VALUE">
     <xsl:call-template name="GenXPath">
      <xsl:with-param name="Node" select="$Node"/>
     </xsl:call-template>
    </xsl:element>
   </xsl:element>
  </xsl:if>
 </xsl:template>
 <xsl:template name="GenXPath">
  <xsl:param name="Node" select="''"/>
  <!-- *******************************************************************
Template: GenXPath - recursive template to generate XPath
Parameters:
 Node - current node
******************************************************************** -->
  <!-- In Oracle C-based XSL parser, the local name of the document root node
     is '#document' -->
  <xsl:if test="string-length(local-name($Node))!=0 and local-name($Node)!='#document'">
   <xsl:call-template name="GenXPath">
    <xsl:with-param name="Node" select="$Node/parent::node()"/>
   </xsl:call-template>
   <xsl:text>/</xsl:text>
   <xsl:value-of select="$PRS_XPATH_NS"/>
   <xsl:value-of select="local-name($Node)"/>
   <xsl:variable name="thisPosition" select="count($Node/preceding-sibling::*[name($Node)=name()])"/>
   <xsl:variable name="numFollowing" select="count($Node/following-sibling::*[name($Node)=name()])"/>
   <xsl:if test="$thisPosition+$numFollowing &gt; 0">
    <xsl:value-of select="concat('[',$thisPosition+1,']')"/>
   </xsl:if>
  </xsl:if>
 </xsl:template>
 <xsl:template name="AlterCOL_LIST">
  <xsl:param name="ColListItems" select="''"/>
  <!-- ***********************
Template: AlterCOL_LIST 
Parameters:
ColListItems - COL_LIST_ITEM nodes
******************************************************************** -->
  <xsl:for-each select="$ColListItems">
   <xsl:choose>
    <xsl:when test="@src='1'"/>
    <xsl:otherwise>
     <xsl:if test="position()!=1">
      <!-- to avoid the last item is @src='1' -->
      <xsl:text>,</xsl:text>
     </xsl:if>
     <xsl:call-template name="QuotedName">
      <xsl:with-param name="NameNode" select="sxml:NAME"/>
     </xsl:call-template>
    </xsl:otherwise>
   </xsl:choose>
  </xsl:for-each>
 </xsl:template>
 <xsl:template name="CommonNotAlterable">
  <xsl:param name="XpathNode" select="''"/>
  <xsl:param name="NameNode" select="''"/>
  <xsl:param name="Reason" select="''"/>
  <xsl:param name="Message" select="''"/>
  <xsl:param name="Subst" select="''"/>
  <!-- *******************************************************************
Template: CommonNotAlterable
Parameters:
 XpathNode:
 NameNode:
 Reason:   value of the NOT_ALTERABLE parse item
 Message:  message text to be used as a comment in the SQL text
 Subst:    optional substitution string
******************************************************************** -->
  <xsl:element name="ALTER_LIST_ITEM">
   <xsl:if test="$PRS_NAME=1 or 
                 $PRS_ALTERABLE=1 or
                 $PRS_XPATH=1">
    <xsl:element name="PARSE_LIST">
     <xsl:if test="$XpathNode">
      <xsl:call-template name="AddXPathParseItem">
       <xsl:with-param name="Node" select="$XpathNode"/>
      </xsl:call-template>
     </xsl:if>
     <xsl:if test="$NameNode">
      <xsl:call-template name="AddParseItem">
       <xsl:with-param name="ParseIt" select="$PRS_NAME"/>
       <xsl:with-param name="Item">NAME</xsl:with-param>
       <xsl:with-param name="Value1" select="$NameNode"/>
      </xsl:call-template>
     </xsl:if>
     <xsl:call-template name="AddParseItem">
      <xsl:with-param name="ParseIt" select="$PRS_ALTERABLE"/>
      <xsl:with-param name="Item">NOT_ALTERABLE</xsl:with-param>
      <xsl:with-param name="Value1" select="$Reason"/>
     </xsl:call-template>
    </xsl:element>
   </xsl:if>
   <xsl:if test="string-length($Message)!=0">
    <xsl:element name="SQL_LIST">
     <xsl:element name="SQL_LIST_ITEM">
      <xsl:element name="TEXT">
       <xsl:text>-- </xsl:text>
       <xsl:value-of select="$Message"/>
       <xsl:value-of select="$Subst"/>
      </xsl:element>
     </xsl:element> 
    </xsl:element> 
   </xsl:if>
  </xsl:element>
 </xsl:template>

</xsl:stylesheet>
