<?xml version="1.0"?>
<!--

 Copyright (c) 2006, 2010, Oracle and/or its affiliates. All rights reserved. 

NAME
    kuamv.xsl
DESCRIPTION
    Convert sxml MATERIALIZED_VIEW diff document to ALTER_XML document

MODIFIED        MM/DD/YY
    lbarton      01/11/10 - bug 8796742: translatable error messages
    rapayne      11/25/08 - bug 7595899: change import of kuamvl to accommodate CM synch.
    lbarton      07/10/08 - bug 5709159: SQL_LIST_ITEM subelements
    lbarton      03/06/08 - change interface to ModifyLob
    rapayne      01/22/07 - import kuamvl.xsl
    htseng       12/07/06 - differ features support 
    rapayne      06/09/06 - Initial version
 -->
<xsl:stylesheet version="1.0" xmlns:sxml="http://xmlns.oracle.com/ku" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
 <!-- Top level imports -->
 <xsl:import href="kuacomm.xsl"/>
 <xsl:import href="kuatprop.xsl"/>
 <xsl:import href="kuatpar.xsl"/>
 <xsl:import href="kuatcol.xsl"/>
 <!-- Templates -->
 <xsl:template match="sxml:MATERIALIZED_VIEW">
  <!-- *******************************************************************
Template: MATERIALIZED_VIEW - top-level template for materialized views.
******************************************************************** -->
  <xsl:element name="ALTER_XML">
   <xsl:attribute name="xmlns">http://xmlns.oracle.com/ku</xsl:attribute>
   <xsl:attribute name="version">1.0</xsl:attribute>
   <!-- Object type -->
   <xsl:element name="OBJECT_TYPE">MATERIALIZED_VIEW</xsl:element>
   <!-- Display schema.objname for CoMPareObjects 1 and 2 -->
   <xsl:call-template name="CmpObjects">
    <xsl:with-param name="ParentNode" select="."/>
   </xsl:call-template>
   <!-- Alter list -->
   <xsl:element name="ALTER_LIST">
    <!-- alter_iot_clauses -->
    <xsl:call-template name="AlterMVIOT">
     <xsl:with-param name="ParentNode" select="."/>
    </xsl:call-template>
    <!-- Physical_attributes_clause, table_compression -->
    <xsl:if test="sxml:PHYSICAL_PROPERTIES/sxml:HEAP_TABLE/sxml:SEGMENT_ATTRIBUTES//@value1
               or sxml:PHYSICAL_PROPERTIES/sxml:HEAP_TABLE/sxml:COMPRESS/@value1">
     <xsl:call-template name="MViewPhysical">
      <xsl:with-param name="ParentNode" select="."/>
     </xsl:call-template>
    </xsl:if>
    <!-- Alter CACHE if appropriate -->
    <xsl:call-template name="AlterCache">
     <xsl:with-param name="ObjectNode" select="."/>
     <xsl:with-param name="ParentNode" select="."/>
     <xsl:with-param name="ObjType">MATERIALIZED VIEW</xsl:with-param>
     <xsl:with-param name="OnTable"> </xsl:with-param>
    </xsl:call-template>
    <!-- Alter PARALLEL if appropriate -->
    <xsl:call-template name="AlterParallel">
     <xsl:with-param name="ObjectNode" select="."/>
     <xsl:with-param name="ParentNode" select="."/>
     <xsl:with-param name="ObjType">MATERIALIZED VIEW</xsl:with-param>
     <xsl:with-param name="OnTable"> </xsl:with-param>
    </xsl:call-template>
    <!-- LOB storage clause -->
    <xsl:call-template name="AlterMVLob">
     <xsl:with-param name="ParentNode" select="."/>
     <xsl:with-param name="ColProperties" select="sxml:COLUMN_PROPERTIES"/>
    </xsl:call-template>
    <!-- alter_table_partitioning -->
    <xsl:call-template name="AlterMVPartition">
     <xsl:with-param name="ParentNode" select="."/>
     <xsl:with-param name="ObjType" select="'MATERIALIZED VIEW'"/>
    </xsl:call-template>
    <!-- cannot alter between USING_NO_INDEX and USING INDEX-->
    <!-- create mv with using no index and then alter mv using index, there is -->
    <!-- no error but metadata does not make any change   -->
    <xsl:if test="sxml:USING_NO_INDEX/@src='2'">
     <xsl:call-template name="CommonNotAlterable">
      <xsl:with-param name="XpathNode" select="./sxml:USING_NO_INDEX"/>
      <xsl:with-param name="NameNode" select="sxml:NAME"/>
      <xsl:with-param name="Reason">INCOMPATIBLE_MV_ATTRIBUTE</xsl:with-param>
      <xsl:with-param name="Message" select="$MSG_INCOMPATIBLE_MV_ATTRIBUTE"/>
      <xsl:with-param name="Subst">USING INDEX</xsl:with-param>
     </xsl:call-template>
    </xsl:if>
    <!-- incompatible index attributes -->
    <xsl:if test="sxml:INDEX_ATTRIBUTES/sxml:PCTFREE/@value1">
     <xsl:call-template name="CommonNotAlterable">
      <xsl:with-param name="XpathNode" select="./sxml:INDEX_ATTRIBUTES/sxml:PCTFREE"/>
      <xsl:with-param name="NameNode" select="sxml:NAME"/>
      <xsl:with-param name="Reason">INCOMPATIBLE_MV_ATTRIBUTE</xsl:with-param>
      <xsl:with-param name="Message" select="$MSG_INCOMPATIBLE_MV_ATTRIBUTE"/>
      <xsl:with-param name="Subst">USING INDEX PCTFREE</xsl:with-param>
     </xsl:call-template>
    </xsl:if>
    <xsl:if test="sxml:INDEX_ATTRIBUTES/sxml:TABLESPACE/@value1">
     <xsl:call-template name="CommonNotAlterable">
      <xsl:with-param name="XpathNode" select="./sxml:INDEX_ATTRIBUTES/sxml:TABLESPACE"/>
      <xsl:with-param name="NameNode" select="sxml:NAME"/>
      <xsl:with-param name="Reason">INCOMPATIBLE_MV_ATTRIBUTE</xsl:with-param>
      <xsl:with-param name="Message" select="$MSG_INCOMPATIBLE_MV_ATTRIBUTE"/>
      <xsl:with-param name="Subst">USING INDEX TABLESPACE</xsl:with-param>
     </xsl:call-template>
    </xsl:if>
    <xsl:if test="sxml:INDEX_ATTRIBUTES/sxml:STORAGE/sxml:INITIAL/@value1">
     <xsl:call-template name="CommonNotAlterable">
      <xsl:with-param name="XpathNode" select="./sxml:INDEX_ATTRIBUTES/sxml:STORAGE/sxml:INITIAL"/>
      <xsl:with-param name="NameNode" select="sxml:NAME"/>
      <xsl:with-param name="Reason">INCOMPATIBLE_MV_ATTRIBUTE</xsl:with-param>
      <xsl:with-param name="Message" select="$MSG_INCOMPATIBLE_MV_ATTRIBUTE"/>
      <xsl:with-param name="Subst">USING INDEX INITIAL</xsl:with-param>
     </xsl:call-template>
    </xsl:if>
    <xsl:if test="sxml:INDEX_ATTRIBUTES/sxml:STORAGE/sxml:MINEXTENTS/@value1">
     <xsl:call-template name="CommonNotAlterable">
      <xsl:with-param name="XpathNode" select="./sxml:INDEX_ATTRIBUTES/sxml:STORAGE/sxml:MINEXTENTS"/>
      <xsl:with-param name="NameNode" select="sxml:NAME"/>
      <xsl:with-param name="Reason">INCOMPATIBLE_MV_ATTRIBUTE</xsl:with-param>
      <xsl:with-param name="Message" select="$MSG_INCOMPATIBLE_MV_ATTRIBUTE"/>
      <xsl:with-param name="Subst">USING INDEX MINEXTENTS</xsl:with-param>
     </xsl:call-template>
    </xsl:if>
    <xsl:if test="sxml:INDEX_ATTRIBUTES/sxml:STORAGE/sxml:FREELIST_GROUPS/@value1">
     <xsl:call-template name="CommonNotAlterable">
      <xsl:with-param name="XpathNode" select="./sxml:INDEX_ATTRIBUTES/sxml:STORAGE/sxml:FREELIST GROUPS"/>
      <xsl:with-param name="NameNode" select="sxml:NAME"/>
      <xsl:with-param name="Reason">INCOMPATIBLE_MV_ATTRIBUTE</xsl:with-param>
      <xsl:with-param name="Message" select="$MSG_INCOMPATIBLE_MV_ATTRIBUTE"/>
      <xsl:with-param name="Subst">USING INDEX FREELIST GROUPS</xsl:with-param>
     </xsl:call-template>
    </xsl:if>
    <!-- USING INDEX -->
    <xsl:if test="sxml:INDEX_ATTRIBUTES/@src='2' or
                 sxml:INDEX_ATTRIBUTES/sxml:INITRANS/@value1 or 
                 sxml:INDEX_ATTRIBUTES/sxml:STORAGE//@value1">
     <xsl:element name="ALTER_LIST_ITEM">
      <xsl:call-template name="AlterUsingIndex">
       <xsl:with-param name="ParentNode" select="."/>
       <xsl:with-param name="Action">PARSE</xsl:with-param>
      </xsl:call-template>
      <xsl:call-template name="AlterUsingIndex">
       <xsl:with-param name="ParentNode" select="."/>
       <xsl:with-param name="Action">SQL</xsl:with-param>
      </xsl:call-template>
     </xsl:element>
    </xsl:if>
    <!-- REFRESH -->
    <xsl:if test="sxml:REFRESH//@src or sxml:REFRESH//@value1">
     <xsl:call-template name="AlterRefresh">
      <xsl:with-param name="ParentNode" select="."/>
     </xsl:call-template>
    </xsl:if>
    <!-- FOR UPDATE -->
    <xsl:if test="sxml:FOR_UPDATE/@src">
     <xsl:call-template name="CommonNotAlterable">
      <xsl:with-param name="XpathNode" select="./sxml:FOR_UPDATE"/>
      <xsl:with-param name="NameNode" select="sxml:NAME"/>
      <xsl:with-param name="Reason">INCOMPATIBLE_MV_ATTRIBUTE</xsl:with-param>
      <xsl:with-param name="Message" select="$MSG_INCOMPATIBLE_MV_ATTRIBUTE"/>
      <xsl:with-param name="Subst">FOR_UPDATE</xsl:with-param>
     </xsl:call-template>
    </xsl:if>
    <!-- SUBQUERY  -->
    <xsl:if test="sxml:SUBQUERY/@src or sxml:SUBQUERY/@value1">
     <xsl:call-template name="CommonNotAlterable">
      <xsl:with-param name="XpathNode" select="./sxml:SUBQUERY"/>
      <xsl:with-param name="NameNode" select="sxml:NAME"/>
      <xsl:with-param name="Reason">INCOMPATIBLE_MV_ATTRIBUTE</xsl:with-param>
      <xsl:with-param name="Message" select="$MSG_INCOMPATIBLE_MV_ATTRIBUTE"/>
      <xsl:with-param name="Subst">SUBQUERY</xsl:with-param>
     </xsl:call-template>
    </xsl:if>
    <!-- Enable/disable  QUERY REWRITE -->
    <xsl:if test="sxml:QUERY_REWRITE/@src">
     <xsl:element name="ALTER_LIST_ITEM">
      <xsl:call-template name="AlterQueryRewrite">
       <xsl:with-param name="ParentNode" select="."/>
       <xsl:with-param name="Action">PARSE</xsl:with-param>
      </xsl:call-template>
      <xsl:call-template name="AlterQueryRewrite">
       <xsl:with-param name="ParentNode" select="."/>
       <xsl:with-param name="Action">SQL</xsl:with-param>
      </xsl:call-template>
     </xsl:element>
    </xsl:if>
   </xsl:element>
  </xsl:element>
 </xsl:template>
 <xsl:template name="AlterMVPartition">
  <xsl:param name="ParentNode" select="''"/>
  <xsl:param name="ObjType" select="''"/>
  <!-- *******************************************************************
Template: AlterMVPartition
Current node: 
Parameters:
 ParentNode - MATERIALIZED_VIEW
 ObjType    - 'MATERIALIZED VIEW'
******************************************************************** -->
  <!-- useful variables -->
  <xsl:variable name="PartitionType">
   <xsl:choose>
    <xsl:when test="$ParentNode/sxml:RANGE_PARTITIONING">RANGE</xsl:when>
    <xsl:when test="$ParentNode/sxml:HASH_PARTITIONING">HASH</xsl:when>
    <xsl:when test="$ParentNode/sxml:LIST_PARTITIONING">LIST</xsl:when>
   </xsl:choose>
  </xsl:variable>
  <xsl:variable name="SubpartitionType">
   <xsl:choose>
    <xsl:when test="$ParentNode//sxml:RANGE_SUBPARTITIONING">RANGE</xsl:when>
    <xsl:when test="$ParentNode//sxml:HASH_SUBPARTITIONING">HASH</xsl:when>
    <xsl:when test="$ParentNode//sxml:LIST_SUBPARTITIONING">LIST</xsl:when>
   </xsl:choose>
  </xsl:variable>
  <xsl:variable name="PartitioningNode" select="$ParentNode/sxml:RANGE_PARTITIONING | $ParentNode/sxml:LIST_PARTITIONING | $ParentNode/sxml:HASH_PARTITIONING"/>

  <xsl:if test="$ParentNode/sxml:RANGE_PARTITIONING/@src or
                $ParentNode/sxml:LIST_PARTITIONING/@src or 
                $ParentNode/sxml:HASH_PARTITIONING/@src or
                $PartitioningNode//sxml:COL_LIST//@src or
                $PartitioningNode//sxml:COL_LIST//@value1">
   <xsl:call-template name="CommonNotAlterable">
    <xsl:with-param name="XpathNode" select="$ParentNode"/>
    <xsl:with-param name="NameNode" select="sxml:NAME"/>
    <xsl:with-param name="Reason">INCOMPATIBLE_MV_PARTITIONING</xsl:with-param>
    <xsl:with-param name="Message" select="$MSG_INCOMPATIBLE_MV_PARTITIONING"/>
   </xsl:call-template>
  </xsl:if>
  <xsl:call-template name="AlterPartitions">
   <xsl:with-param name="TableNode" select="$ParentNode"/>
   <xsl:with-param name="PartitionType" select="$PartitionType"/>
   <xsl:with-param name="SubpartitionType" select="$SubpartitionType"/>
   <xsl:with-param name="ParentNode" select="$PartitioningNode"/>
   <xsl:with-param name="ObjType" select="$ObjType"/>
  </xsl:call-template>
 </xsl:template>
 <xsl:template name="AlterMVIOT">
  <xsl:param name="ParentNode" select="''"/>
  <!-- *******************************************************************
Template: AlterMVIOT
Current node: 
Parameters:
 ParentNode - 
 IOTNode - sxml:PHYSICAL_PROPERTIES/sxml:INDEX_ORGANIZED_TABLE
 Action   - PARSE or SQL
******************************************************************** -->
  <xsl:choose>
   <xsl:when test="$ParentNode/sxml:PHYSICAL_PROPERTIES/sxml:INDEX_ORGANIZED_TABLE[@src] or
       $ParentNode/sxml:PHYSICAL_PROPERTIES/sxml:HEAP_TABLE[@src] or
       $ParentNode/sxml:PHYSICAL_PROPERTIES/sxml:EXTERNAL_TABLE[@src] or
       $ParentNode/sxml:PHYSICAL_PROPERTIES/sxml:CLUSTER_TABLE[@src]">
    <xsl:call-template name="CommonNotAlterable">
      <xsl:with-param name="XpathNode" select="$ParentNode/sxml:PHYSICAL_PROPERTIES"/>
     <xsl:with-param name="NameNode" select="sxml:NAME"/>
     <xsl:with-param name="Reason">MV_PHYSICAL_ORGANIZATION</xsl:with-param>
     <xsl:with-param name="Message" select="$MSG_MV_PHYSICAL_ORGANIZATION"/>
    </xsl:call-template>
   </xsl:when>
   <!-- alter_iot_clauses -->
   <xsl:otherwise>
    <xsl:call-template name="AlterIOT">
     <xsl:with-param name="TableNode" select="$ParentNode"/>
     <xsl:with-param name="ParentNode" select="$ParentNode"/>
     <xsl:with-param name="ObjType" select="'MATERIALIZED_VIEW'"/>
    </xsl:call-template>
   </xsl:otherwise>
  </xsl:choose>
 </xsl:template>
 <xsl:template name="MViewPhysical">
  <xsl:param name="ParentNode" select="''"/>
  <!-- *******************************************************************
Template: MViewPhysical
Current node: 
Parameters:
 ParentNode - 
******************************************************************** -->
  <!-- Physical_Attributes -->
  <xsl:element name="ALTER_LIST_ITEM">
   <xsl:call-template name="AlterMViewPhysical">
    <xsl:with-param name="ParentNode" select="$ParentNode"/>
    <xsl:with-param name="Action">PARSE</xsl:with-param>
   </xsl:call-template>
   <xsl:call-template name="AlterMViewPhysical">
    <xsl:with-param name="ParentNode" select="$ParentNode"/>
    <xsl:with-param name="Action">SQL</xsl:with-param>
   </xsl:call-template>
  </xsl:element>
 </xsl:template>
 <xsl:template name="AlterMViewPhysical">
  <xsl:param name="ParentNode" select="''"/>
  <xsl:param name="Action" select="''"/>
  <!-- *******************************************************************
Template: AlterMViewPhysical
Current node: 
Parameters:
 ParentNode - 
 Action   - PARSE or SQL
******************************************************************** -->
  <xsl:choose>
   <xsl:when test="$Action='PARSE' and ($PRS_NAME=1 or 
                                        $PRS_CLAUSE_TYPE=1 or
					$PRS_CONSTRAINT_TYPE=1 or
					$PRS_CONSTRAINT_STATE=1 or
                                        $PRS_ALTERABLE=1 or
                                        $PRS_XPATH=1)">
    <xsl:element name="PARSE_LIST">
     <xsl:call-template name="AddXPathParseItem">
      <xsl:with-param name="Node" select="$ParentNode"/>
     </xsl:call-template>
     <xsl:call-template name="AddParseItem">
      <xsl:with-param name="ParseIt" select="$PRS_NAME"/>
      <xsl:with-param name="Item">NAME</xsl:with-param>
      <xsl:with-param name="Value1" select="$ParentNode/sxml:NAME"/>
     </xsl:call-template>
     <xsl:call-template name="AddParseItem">
      <xsl:with-param name="ParseIt" select="$PRS_CLAUSE_TYPE"/>
      <xsl:with-param name="Item">CLAUSE_TYPE</xsl:with-param>
      <xsl:with-param name="Value1">PHYSICAL_ATTRIBUTES</xsl:with-param>
     </xsl:call-template>
    </xsl:element>
   </xsl:when>
   <xsl:when test="$Action='SQL'">
    <xsl:element name="SQL_LIST">
     <xsl:element name="SQL_LIST_ITEM">
      <xsl:element name="TEXT">
       <xsl:text>ALTER MATERIALIZED VIEW </xsl:text>
       <xsl:call-template name="SchemaName">
        <xsl:with-param name="ParentNode" select="$ParentNode"/>
       </xsl:call-template>
       <!-- Physical_Attributes -->
       <xsl:call-template name="AlterPhysicalAttributes">
        <xsl:with-param name="ParentNode" select="$ParentNode/sxml:PHYSICAL_PROPERTIES/sxml:HEAP_TABLE/sxml:SEGMENT_ATTRIBUTES"/>
       </xsl:call-template>
       <!-- Table_compression -->
       <xsl:call-template name="AlterCompress">
        <xsl:with-param name="ParentNode" select="$ParentNode/sxml:PHYSICAL_PROPERTIES/sxml:HEAP_TABLE"/>
       </xsl:call-template>
       <!-- Logging_clause-->
       <xsl:call-template name="AlterLogging">
        <xsl:with-param name="ParentNode" select="$ParentNode/sxml:PHYSICAL_PROPERTIES/sxml:HEAP_TABLE/sxml:SEGMENT_ATTRIBUTES"/>
       </xsl:call-template>
      </xsl:element>
     </xsl:element>
    </xsl:element>
   </xsl:when>
  </xsl:choose>
 </xsl:template>
 <xsl:template name="AlterUsingIndex">
  <xsl:param name="ParentNode" select="''"/>
  <xsl:param name="Action" select="''"/>
  <!-- *******************************************************************
Template: AlterUsingIndex
Current node: 
Parameters:
 ParentNode - 
 Action   - PARSE or SQL
Note: All this seems wrong. Here are 2 results:
SQL> ALTER MATERIALIZED VIEW "ALT7"."MV6" USING INDEX INITRANS 2
  2  /
ALTER MATERIALIZED VIEW "ALT7"."MV6" USING INDEX INITRANS 2
*
ERROR at line 1:
ORA-12023: missing index on materialized view "ALT7"."MV6"
and
SQL> ALTER MATERIALIZED VIEW "ALT7"."MV6" USING INDEX
  2  /
Materialized view altered.
but in fact the MV is not altered and still has USING_NO_INDEX
******************************************************************** -->
  <xsl:choose>
   <xsl:when test="$Action='PARSE' and ($PRS_NAME=1 or 
                                        $PRS_CLAUSE_TYPE=1 or
                                        $PRS_XPATH=1)">
    <xsl:element name="PARSE_LIST">
     <xsl:call-template name="AddXPathParseItem">
      <xsl:with-param name="Node" select="$ParentNode"/>
     </xsl:call-template>
     <xsl:call-template name="AddParseItem">
      <xsl:with-param name="ParseIt" select="$PRS_NAME"/>
      <xsl:with-param name="Item">NAME</xsl:with-param>
      <xsl:with-param name="Value1" select="$ParentNode/sxml:NAME"/>
     </xsl:call-template>
     <xsl:call-template name="AddParseItem">
      <xsl:with-param name="ParseIt" select="$PRS_CLAUSE_TYPE"/>
      <xsl:with-param name="Item">CLAUSE_TYPE</xsl:with-param>
      <xsl:with-param name="Value1">USING_INDEX</xsl:with-param>
     </xsl:call-template>
    </xsl:element>
   </xsl:when>
   <xsl:when test="$Action='SQL'">
    <xsl:element name="SQL_LIST">
     <xsl:element name="SQL_LIST_ITEM">
      <xsl:element name="TEXT">
       <xsl:text>ALTER MATERIALIZED VIEW </xsl:text>
       <xsl:call-template name="SchemaName">
        <xsl:with-param name="ParentNode" select="$ParentNode"/>
       </xsl:call-template>
       <xsl:text> USING INDEX</xsl:text>
       <xsl:if test="$ParentNode/sxml:INDEX_ATTRIBUTES/sxml:INITRANS">
        <xsl:text> INITRANS </xsl:text>
        <xsl:value-of select="$ParentNode/sxml:INDEX_ATTRIBUTES/sxml:INITRANS"/>
       </xsl:if>
       <!-- storage_clause -->
       <xsl:if test="$ParentNode/sxml:INDEX_ATTRIBUTES/sxml:STORAGE">
        <xsl:call-template name="AlterStorage">
         <xsl:with-param name="ParentNode" select="$ParentNode/sxml:INDEX_ATTRIBUTES/sxml:STORAGE"/>
        </xsl:call-template>
       </xsl:if>
      </xsl:element>
     </xsl:element>
    </xsl:element>
   </xsl:when>
  </xsl:choose>
 </xsl:template>
 <xsl:template name="AlterRefresh">
  <xsl:param name="ParentNode" select="''"/>
  <!-- *******************************************************************
Template: AlterRefresh
Current node: 
Parameters:
 ParentNode - 
******************************************************************** -->
   <xsl:if test="$ParentNode/sxml:REFRESH/sxml:START_WITH/@src='1'">
    <xsl:call-template name="CommonNotAlterable">
     <xsl:with-param name="XpathNode" select="$ParentNode/sxml:REFRESH/sxml:START_WITH"/>
     <xsl:with-param name="NameNode" select="$ParentNode/sxml:NAME"/>
     <xsl:with-param name="Reason">INCOMPATIBLE_MV_ATTRIBUTE</xsl:with-param>
     <xsl:with-param name="Message" select="$MSG_INCOMPATIBLE_MV_ATTRIBUTE"/>
     <xsl:with-param name="Subst">UNDO REFRESH START_WITH (DATE)</xsl:with-param>
    </xsl:call-template>
   </xsl:if>
   <xsl:if test="$ParentNode/sxml:REFRESH/sxml:NEXT/@src='1'">
    <xsl:call-template name="CommonNotAlterable">
     <xsl:with-param name="XpathNode" select="$ParentNode/sxml:REFRESH/sxml:NEXT"/>
     <xsl:with-param name="NameNode" select="$ParentNode/sxml:NAME"/>
     <xsl:with-param name="Reason">INCOMPATIBLE_MV_ATTRIBUTE</xsl:with-param>
     <xsl:with-param name="Message" select="$MSG_INCOMPATIBLE_MV_ATTRIBUTE"/>
     <xsl:with-param name="Subst">UNDO REFRESH NEXT (DATE)</xsl:with-param>
    </xsl:call-template>
   </xsl:if>
   <xsl:if test="$ParentNode/sxml:REFRESH/sxml:WITH_PRIMARY_KEY/@src='1'">
    <xsl:call-template name="CommonNotAlterable">
     <xsl:with-param name="XpathNode" select="$ParentNode/sxml:REFRESH/sxml:WITH_PRIMARY_KEY"/>
     <xsl:with-param name="NameNode" select="$ParentNode/sxml:NAME"/>
     <xsl:with-param name="Reason">INCOMPATIBLE_MV_ATTRIBUTE</xsl:with-param>
     <xsl:with-param name="Message" select="$MSG_INCOMPATIBLE_MV_ATTRIBUTE"/>
     <xsl:with-param name="Subst">UNDO REFRESH WITH PRIMARY KEY</xsl:with-param>
    </xsl:call-template>
   </xsl:if>
   <xsl:if test="$ParentNode/sxml:REFRESH/sxml:FAST/@src='1'">
    <xsl:call-template name="CommonNotAlterable">
     <xsl:with-param name="XpathNode" select="$ParentNode/sxml:REFRESH/sxml:FAST"/>
     <xsl:with-param name="NameNode" select="$ParentNode/sxml:NAME"/>
     <xsl:with-param name="Reason">INCOMPATIBLE_MV_ATTRIBUTE</xsl:with-param>
     <xsl:with-param name="Message" select="$MSG_INCOMPATIBLE_MV_ATTRIBUTE"/>
     <xsl:with-param name="Subst">UNDO REFRESH FAST</xsl:with-param>
    </xsl:call-template>
   </xsl:if>
   <xsl:if test="$ParentNode/sxml:REFRESH/sxml:FORCE/@src='1'">
    <xsl:call-template name="CommonNotAlterable">
     <xsl:with-param name="XpathNode" select="$ParentNode/sxml:REFRESH/sxml:FORCE"/>
     <xsl:with-param name="NameNode" select="$ParentNode/sxml:NAME"/>
     <xsl:with-param name="Reason">INCOMPATIBLE_MV_ATTRIBUTE</xsl:with-param>
     <xsl:with-param name="Message" select="$MSG_INCOMPATIBLE_MV_ATTRIBUTE"/>
     <xsl:with-param name="Subst">UNDO REFRESH FORCE</xsl:with-param>
    </xsl:call-template>
   </xsl:if>
   <xsl:if test="$ParentNode/sxml:REFRESH/sxml:COMPLETE/@src='1'">
    <xsl:call-template name="CommonNotAlterable">
     <xsl:with-param name="XpathNode" select="$ParentNode/sxml:REFRESH/sxml:COMPLETE"/>
     <xsl:with-param name="NameNode" select="$ParentNode/sxml:NAME"/>
     <xsl:with-param name="Reason">INCOMPATIBLE_MV_ATTRIBUTE</xsl:with-param>
     <xsl:with-param name="Message" select="$MSG_INCOMPATIBLE_MV_ATTRIBUTE"/>
     <xsl:with-param name="Subst">UNDO REFRESH COMPLETE</xsl:with-param>
    </xsl:call-template>
   </xsl:if>
   <xsl:if test="$ParentNode/sxml:REFRESH/sxml:WITH_ROWID/@src">
    <xsl:call-template name="CommonNotAlterable">
     <xsl:with-param name="XpathNode" select="$ParentNode/sxml:REFRESH/sxml:WITH_ROWID"/>
     <xsl:with-param name="NameNode" select="$ParentNode/sxml:NAME"/>
     <xsl:with-param name="Reason">INCOMPATIBLE_MV_ATTRIBUTE</xsl:with-param>
     <xsl:with-param name="Message" select="$MSG_INCOMPATIBLE_MV_ATTRIBUTE"/>
     <xsl:with-param name="Subst">REFRESH WITH ROWID</xsl:with-param>
    </xsl:call-template>
   </xsl:if>
   <xsl:if test="($ParentNode/sxml:REFRESH/sxml:ON_COMMIT/@src='1') or
                   ($ParentNode/sxml:REFRESH/sxml:ON_COMMIT/@src='2' and
                    not ($ParentNode/sxml:REFRESH/sxml:FAST))">
    <xsl:call-template name="CommonNotAlterable">
     <xsl:with-param name="XpathNode" select="$ParentNode/sxml:REFRESH/sxml:ON_COMMIT"/>
     <xsl:with-param name="NameNode" select="$ParentNode/sxml:NAME"/>
     <xsl:with-param name="Reason">INCOMPATIBLE_MV_ATTRIBUTE</xsl:with-param>
     <xsl:with-param name="Message" select="$MSG_INCOMPATIBLE_MV_ATTRIBUTE"/>
     <xsl:with-param name="Subst">UNDO REFRESH ON COMMIT</xsl:with-param>
    </xsl:call-template>
   </xsl:if>
   <xsl:if test="$ParentNode/sxml:REFRESH/sxml:LOCAL_ROLLBACK_SEGMENT/sxml:NAME/@src='2' or $ParentNode/sxml:REFRESH/sxml:LOCAL_ROLLBACK_SEGMENT/sxml:NAME/@value1 or $ParentNode/sxml:REFRESH/sxml:LOCAL_ROLLBACK_SEGMENT/sxml:DEFAULT/@src='2'">
    <xsl:call-template name="CommonNotAlterable">
     <xsl:with-param name="XpathNode" select="$ParentNode/sxml:LOCAL_ROLLBACK_SEGMENT"/>
     <xsl:with-param name="NameNode" select="$ParentNode/sxml:NAME"/>
     <xsl:with-param name="Reason">INCOMPATIBLE_MV_ATTRIBUTE</xsl:with-param>
     <xsl:with-param name="Message" select="$MSG_INCOMPATIBLE_MV_ATTRIBUTE"/>
     <xsl:with-param name="Subst">LOCAL ROLLBACK SEGMENT</xsl:with-param>
    </xsl:call-template>
   </xsl:if>
   <xsl:if test="$ParentNode/sxml:REFRESH/sxml:COMPLETE/@src='2' or
                 ($ParentNode/sxml:REFRESH/sxml:ON_COMMIT/@src='2' and
                  $ParentNode/sxml:REFRESH/sxml:FAST) or
                 $ParentNode/sxml:REFRESH/sxml:FAST/@src='2'or
                 $ParentNode/sxml:REFRESH/sxml:WITH_PRIMARY_KEY/@src='2'or
                 $ParentNode/sxml:REFRESH/sxml:START_WITH/@src='2' or
		 $ParentNode/sxml:REFRESH/sxml:START_WITH/@value1 or
                 $ParentNode/sxml:REFRESH/sxml:NEXT/@src='2' or
		 $ParentNode/sxml:REFRESH/sxml:NEXT/@value1 or
                 $ParentNode/sxml:REFRESH/sxml:MASTER_ROLLBACK_SEGMENT/sxml:NAME/@src='2' or 
                 $ParentNode/sxml:REFRESH/sxml:MASTER_ROLLBACK_SEGMENT/sxml:NAME/@value1 or
                 $ParentNode/sxml:REFRESH/sxml:MASTER_ROLLBACK_SEGMENT/sxml:DEFAULT/@src='2' or
                 $ParentNode/sxml:REFRESH/sxml:CONSTRAINTS/@src='2' or $ParentNode/sxml:REFRESH/sxml:CONSTRAINTS/@value1">
    <xsl:element name="ALTER_LIST_ITEM">
     <xsl:call-template name="DoAlterRefresh">
      <xsl:with-param name="ParentNode" select="$ParentNode"/>
      <xsl:with-param name="Action">PARSE</xsl:with-param>
     </xsl:call-template>
      <xsl:call-template name="DoAlterRefresh">
       <xsl:with-param name="ParentNode" select="$ParentNode"/>
       <xsl:with-param name="Action">SQL</xsl:with-param>
      </xsl:call-template>
     </xsl:element>
   </xsl:if>    
 </xsl:template>
 <xsl:template name="DoAlterRefresh">
  <xsl:param name="ParentNode" select="''"/>
  <xsl:param name="Action" select="''"/>
  <!-- *******************************************************************
Template: AlterRefresh
Current node: 
Parameters:
 ParentNode - 
 Action   - PARSE or SQL
******************************************************************** -->
  <xsl:choose>
   <xsl:when test="$Action='PARSE' and ($PRS_NAME=1 or 
                                        $PRS_CLAUSE_TYPE=1 or
                                        $PRS_XPATH=1)">
    <xsl:element name="PARSE_LIST">
     <xsl:call-template name="AddXPathParseItem">
      <xsl:with-param name="Node" select="$ParentNode"/>
     </xsl:call-template>
     <xsl:call-template name="AddParseItem">
      <xsl:with-param name="ParseIt" select="$PRS_NAME"/>
      <xsl:with-param name="Item">NAME</xsl:with-param>
      <xsl:with-param name="Value1" select="$ParentNode/sxml:NAME"/>
     </xsl:call-template>
     <xsl:call-template name="AddParseItem">
      <xsl:with-param name="ParseIt" select="$PRS_CLAUSE_TYPE"/>
      <xsl:with-param name="Item">CLAUSE_TYPE</xsl:with-param>
      <xsl:with-param name="Value1">MODIFY_MV_REFRESH</xsl:with-param>
     </xsl:call-template>
    </xsl:element>
   </xsl:when>
   <xsl:when test="$Action='SQL'">
    <xsl:element name="SQL_LIST">
     <xsl:element name="SQL_LIST_ITEM">
      <xsl:element name="TEXT">
       <xsl:text>ALTER MATERIALIZED VIEW </xsl:text>
       <xsl:call-template name="SchemaName">
        <xsl:with-param name="ParentNode" select="$ParentNode"/>
       </xsl:call-template>
       <xsl:text> REFRESH</xsl:text>
       <xsl:if test="$ParentNode/sxml:REFRESH/sxml:COMPLETE/@src='2'">
        <xsl:text> COMPLETE</xsl:text>
       </xsl:if>
       <xsl:if test="$ParentNode/sxml:REFRESH/sxml:ON_COMMIT/@src='2' and
		     $ParentNode/sxml:REFRESH/sxml:FAST">
        <xsl:text> ON COMMIT</xsl:text>
       </xsl:if>
       <xsl:if test="$ParentNode/sxml:REFRESH/sxml:FAST/@src='2'">
        <xsl:text> FAST</xsl:text>
       </xsl:if>
       <xsl:if test="$ParentNode/sxml:REFRESH/sxml:WITH_PRIMARY_KEY/@src='2'">
        <xsl:text> WITH PRIMARY KEY</xsl:text>
       </xsl:if>
       <xsl:if test="$ParentNode/sxml:REFRESH/sxml:START_WITH/@src='2' 
		or $ParentNode/sxml:REFRESH/sxml:START_WITH/@value1">
        <xsl:text> START WITH </xsl:text>
        <xsl:value-of select="$ParentNode/sxml:REFRESH/sxml:START_WITH"/>
       </xsl:if>
       <xsl:if test="$ParentNode/sxml:REFRESH/sxml:NEXT/@src='2' 
		or $ParentNode/sxml:REFRESH/sxml:NEXT/@value1">
        <xsl:text> NEXT </xsl:text>
        <xsl:value-of select="$ParentNode/sxml:REFRESH/sxml:NEXT"/>
       </xsl:if>
       <xsl:choose>
        <xsl:when test="$ParentNode/sxml:REFRESH/sxml:MASTER_ROLLBACK_SEGMENT/sxml:NAME/@src='2' or $ParentNode/sxml:REFRESH/sxml:MASTER_ROLLBACK_SEGMENT/sxml:NAME/@value1">
         <xsl:text> USING MASTER ROLLBACK SEGMENT </xsl:text>
         <xsl:value-of select="$ParentNode/sxml:REFRESH/sxml:MASTER_ROLLBACK_SEGMENT/sxml:NAME"/>
        </xsl:when>
        <xsl:when test="$ParentNode/sxml:REFRESH/sxml:MASTER_ROLLBACK_SEGMENT/sxml:DEFAULT/@src='2'">
         <xsl:text> USING DEFAULT MASTER ROLLBACK SEGMENT </xsl:text>
        </xsl:when>
       </xsl:choose>
       <xsl:if test="$ParentNode/sxml:REFRESH/sxml:CONSTRAINTS/@src='2' or $ParentNode/sxml:REFRESH/sxml:CONSTRAINTS/@value1">
        <xsl:text> USING </xsl:text>
        <xsl:value-of select="$ParentNode/sxml:REFRESH/sxml:CONSTRAINTS"/>
        <xsl:text> CONSTRAINTS </xsl:text>
       </xsl:if>
      </xsl:element>
     </xsl:element>
    </xsl:element>
   </xsl:when>
  </xsl:choose>
 </xsl:template>
 <xsl:template name="AlterQueryRewrite">
  <xsl:param name="ParentNode" select="''"/>
  <xsl:param name="Action" select="''"/>
  <!-- *******************************************************************
Template: AlterQueryRewrite
Current node: 
Parameters:
 ParentNode - 
 Action   - PARSE or SQL
******************************************************************** -->
  <xsl:choose>
   <xsl:when test="$Action='PARSE' and ($PRS_NAME=1 or 
                                        $PRS_CLAUSE_TYPE=1 or
					$PRS_CONSTRAINT_TYPE=1 or
					$PRS_CONSTRAINT_STATE=1 or
                                        $PRS_ALTERABLE=1 or
                                        $PRS_XPATH=1)">
    <xsl:element name="PARSE_LIST">
     <xsl:call-template name="AddXPathParseItem">
      <xsl:with-param name="Node" select="$ParentNode"/>
     </xsl:call-template>
     <xsl:call-template name="AddParseItem">
      <xsl:with-param name="ParseIt" select="$PRS_NAME"/>
      <xsl:with-param name="Item">NAME</xsl:with-param>
      <xsl:with-param name="Value1" select="$ParentNode/sxml:NAME"/>
     </xsl:call-template>
     <xsl:call-template name="AddParseItem">
      <xsl:with-param name="ParseIt" select="$PRS_CLAUSE_TYPE"/>
      <xsl:with-param name="Item">CLAUSE_TYPE</xsl:with-param>
      <xsl:with-param name="Value1">QUERY_REWRITE</xsl:with-param>
     </xsl:call-template>
    </xsl:element>
   </xsl:when>
   <xsl:when test="$Action='SQL'">
    <xsl:element name="SQL_LIST">
     <xsl:element name="SQL_LIST_ITEM">
      <xsl:element name="TEXT">
       <xsl:text>ALTER MATERIALIZED VIEW </xsl:text>
       <xsl:call-template name="SchemaName">
        <xsl:with-param name="ParentNode" select="$ParentNode"/>
       </xsl:call-template>
       <xsl:choose>
        <xsl:when test="$ParentNode/sxml:QUERY_REWRITE/@src='1'">
         <xsl:text> DISABLE QUERY REWRITE</xsl:text>
        </xsl:when>
        <xsl:when test="$ParentNode/sxml:QUERY_REWRITE/@src='2'">
         <xsl:text> ENABLE QUERY REWRITE</xsl:text>
        </xsl:when>
       </xsl:choose>
      </xsl:element>
     </xsl:element>
    </xsl:element>
   </xsl:when>
  </xsl:choose>
 </xsl:template>
 <xsl:template name="AlterMVLob">
  <xsl:param name="ParentNode" select="''"/>
  <xsl:param name="ColProperties" select="''"/>
  <!-- *******************************************************************
Template: AlterMVLob
Current node: 
Parameters:
 ParentNode - 
 Action   - PARSE or SQL
******************************************************************** -->
  <xsl:for-each select="$ColProperties/sxml:COL_LIST/sxml:COL_LIST_ITEM">
   <xsl:if test="(sxml:DATATYPE='CLOB' or
                 sxml:DATATYPE='BLOB' or
                 sxml:DATATYPE='NCLOB') and
                 sxml:LOB_PROPERTIES//*[@value1]">
    <xsl:element name="ALTER_LIST_ITEM">
     <xsl:call-template name="ModifyLob">
      <xsl:with-param name="TableNode" select="$ParentNode"/>
      <xsl:with-param name="NameNode" select="sxml:NAME"/>
      <xsl:with-param name="ColProperties" select="$ColProperties"/>
      <xsl:with-param name="LobProperties" select="sxml:LOB_PROPERTIES"/>
      <xsl:with-param name="ObjType" select="'MATERIALIZED VIEW'"/>
      <xsl:with-param name="Action">PARSE</xsl:with-param>
     </xsl:call-template>
     <xsl:call-template name="ModifyLob">
      <xsl:with-param name="TableNode" select="$ParentNode"/>
      <xsl:with-param name="NameNode" select="sxml:NAME"/>
      <xsl:with-param name="ColProperties" select="$ColProperties"/>
      <xsl:with-param name="LobProperties" select="sxml:LOB_PROPERTIES"/>
      <xsl:with-param name="ObjType" select="'MATERIALIZED VIEW'"/>
      <xsl:with-param name="Action">SQL</xsl:with-param>
     </xsl:call-template>
    </xsl:element>
   </xsl:if>
  </xsl:for-each>
 </xsl:template>
</xsl:stylesheet>
