<?xml version="1.0"?>
<!--

 Copyright (c) 2006, 2010, Oracle and/or its affiliates. All rights reserved. 

NAME
    kuamvl.xsl
DESCRIPTION
    Convert sxml MATERIALIZED_VIEW_LOG diff document to ALTER_XML document

MODIFIED        MM/DD/YY
    lbarton      01/11/10 - bug 8796742: translatable error messages
    rapayne      11/25/08 - bug 7595899: add import of kuamv to accommodate CM synch.
    lbarton      07/10/08 - bug 5709159: SQL_LIST_ITEM subelements
    rapayne      07/12/07 - 
    htseng       01/02/07 - differ features support 
    rapayne      06/09/06 - Initial version
 -->
<xsl:stylesheet version="1.0" xmlns:sxml="http://xmlns.oracle.com/ku" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
 <!-- Top level imports -->
 <xsl:import href="kuacomm.xsl"/>
 <xsl:import href="kuatprop.xsl"/>
 <xsl:import href="kuatpar.xsl"/>
 <xsl:import href="kuamv.xsl"/>
 <!-- Templates -->
 <xsl:template match="sxml:MATERIALIZED_VIEW_LOG">
  <!-- *******************************************************************
Template: MATERIALIZED_VIEW_LOG - top-level template for materialized view log.
******************************************************************** -->
  <xsl:element name="ALTER_XML">
   <xsl:attribute name="xmlns">http://xmlns.oracle.com/ku</xsl:attribute>
   <xsl:attribute name="version">1.0</xsl:attribute>
   <!-- Object type -->
   <xsl:element name="OBJECT_TYPE">MATERIALIZED_VIEW_LOG</xsl:element>
   <!-- Display schema.objname for CoMPareObjects 1 and 2  
   <xsl:call-template name="CmpObjects">
    <xsl:with-param name="ParentNode" select="./sxml:ON_TABLE"/>
   </xsl:call-template>
   -->
   <!-- Alter list -->
   <xsl:element name="ALTER_LIST">
    <!-- SEGMENT_ATTRIBUTES -->
    <xsl:call-template name="AlterMVLSegAttrib">
     <xsl:with-param name="ParentNode" select="."/>
     <xsl:with-param name="ObjType">MATERIALIZED VIEW LOG</xsl:with-param>
    </xsl:call-template>
    <!-- Alter CACHE if appropriate -->
    <xsl:call-template name="AlterCache">
     <xsl:with-param name="ObjectNode" select="."/>
     <xsl:with-param name="ParentNode" select="."/>
     <xsl:with-param name="ObjType">MATERIALIZED VIEW LOG</xsl:with-param>
     <xsl:with-param name="OnTable" select="./sxml:ON_TABLE"/>
    </xsl:call-template>
    <!-- Parallel_clause -->
    <xsl:call-template name="AlterParallel">
     <xsl:with-param name="ObjectNode" select="."/>
     <xsl:with-param name="ParentNode" select="."/>
     <xsl:with-param name="ObjType">MATERIALIZED VIEW LOG</xsl:with-param>
     <xsl:with-param name="OnTable" select="./sxml:ON_TABLE"/>
    </xsl:call-template>
    <!-- alter_table_partitioning -->
    <xsl:call-template name="AlterMVLPartition">
     <xsl:with-param name="ParentNode" select="."/>
     <xsl:with-param name="ObjType">MATERIALIZED VIEW LOG</xsl:with-param>
    </xsl:call-template>
    <!-- RECORDS node includes ROWID, SEQUENCE, OBJECT_ID, PRIMARY_KEY and COL_LIST nodes  -->
    <xsl:if test="sxml:RECORDS//@src or sxml:RECORDS//@value1">
     <xsl:call-template name="AlterRecords">
      <xsl:with-param name="ParentNode" select="."/>
     </xsl:call-template>
    </xsl:if>
   </xsl:element>
  </xsl:element>
 </xsl:template>
 <xsl:template name="AlterMVLSegAttrib">
  <xsl:param name="ParentNode" select="''"/>
  <xsl:param name="ObjType" select="''"/>
  <!-- *******************************************************************
Template: AlterMVLSegAttrib
       <SEGMENT_ATTRIBUTES> are composed of physical attributes, storage and logging
Current node: 
Parameters:
 ParentNode - 
 ObjType - MATERIALIZED VIEW LOG
 OnTable -
******************************************************************** -->
  <!-- PHYSICAL_ATTRIBUTES (INITRANS, PCTFREE, and/or PCTUSED) -->
  <xsl:if test="sxml:SEGMENT_ATTRIBUTES/sxml:PCTFREE/@value1 or
sxml:SEGMENT_ATTRIBUTES/sxml:PCTUSED/@value1 or
sxml:SEGMENT_ATTRIBUTES/sxml:INITRANS/@value1">
   <xsl:element name="ALTER_LIST_ITEM">
    <xsl:call-template name="AlterMVLPhysical">
     <xsl:with-param name="ParentNode" select="$ParentNode"/>
     <xsl:with-param name="Action">PARSE</xsl:with-param>
    </xsl:call-template>
    <xsl:call-template name="AlterMVLPhysical">
     <xsl:with-param name="ParentNode" select="$ParentNode"/>
     <xsl:with-param name="Action">SQL</xsl:with-param>
    </xsl:call-template>
   </xsl:element>
  </xsl:if>
  <!-- Logging_clause-->
  <xsl:if test="./sxml:SEGMENT_ATTRIBUTES/sxml:LOGGING[@value1]">
   <xsl:element name="ALTER_LIST_ITEM">
    <xsl:call-template name="AlterMVLogging">
     <xsl:with-param name="LoggingNode" select="$ParentNode/sxml:SEGMENT_ATTRIBUTES/sxml:LOGGING"/>
     <xsl:with-param name="OnTableNode" select="$ParentNode/sxml:ON_TABLE"/>
     <xsl:with-param name="Action">PARSE</xsl:with-param>
    </xsl:call-template>
    <xsl:call-template name="AlterMVLogging">
     <xsl:with-param name="LoggingNode" select="$ParentNode/sxml:SEGMENT_ATTRIBUTES/sxml:LOGGING"/>
     <xsl:with-param name="OnTableNode" select="$ParentNode/sxml:ON_TABLE"/>
     <xsl:with-param name="Action">SQL</xsl:with-param>
    </xsl:call-template>
   </xsl:element>
  </xsl:if>
  <!-- Tablespace  is NOT alterable -->
  <xsl:if test="./sxml:SEGMENT_ATTRIBUTES/sxml:TABLESPACE[@value1]">
   <xsl:call-template name="CommonNotAlterable">
    <xsl:with-param name="XpathNode" select="sxml:SEGMENT_ATTRIBUTES/sxml:TABLESPACE"/>
    <xsl:with-param name="Reason">MVL_TABLESPACE</xsl:with-param>
    <xsl:with-param name="Message" select="$MSG_MVL_TABLESPACE"/>
   </xsl:call-template>
  </xsl:if>
 </xsl:template>
 <xsl:template name="AlterMVLPhysical">
  <xsl:param name="ParentNode" select="''"/>
  <xsl:param name="Action" select="''"/>
  <!-- *******************************************************************
Template: AlterMVLPhysical
Current node: 
Parameters:
 ParentNode - Object node (e.g., MATERIALIZED_VIEW_LOG
 Action   - PARSE or SQL
******************************************************************** -->
  <xsl:choose>
   <xsl:when test="$Action='PARSE' and ($PRS_NAME=1 or 
                                        $PRS_CLAUSE_TYPE=1 or
					$PRS_CONSTRAINT_TYPE=1 or
					$PRS_CONSTRAINT_STATE=1 or
                                        $PRS_ALTERABLE=1 or
                                        $PRS_XPATH=1)">
    <xsl:element name="PARSE_LIST">
     <xsl:call-template name="AddXPathParseItem">
      <xsl:with-param name="Node" select="$ParentNode/sxml:SEGMENT_ATTRIBUTES"/>
     </xsl:call-template>
     <xsl:call-template name="AddParseItem">
      <xsl:with-param name="ParseIt" select="$PRS_CLAUSE_TYPE"/>
      <xsl:with-param name="Item">CLAUSE_TYPE</xsl:with-param>
      <xsl:with-param name="Value1">PHYSICAL_ATTRIBUTES</xsl:with-param>
     </xsl:call-template>
    </xsl:element>
   </xsl:when>
   <xsl:when test="$Action='SQL'">
    <xsl:element name="SQL_LIST">
     <xsl:element name="SQL_LIST_ITEM">
      <xsl:element name="TEXT">
       <xsl:text>ALTER MATERIALIZED VIEW LOG ON </xsl:text>
       <xsl:call-template name="SchemaName">
        <xsl:with-param name="ParentNode" select="$ParentNode/sxml:ON_TABLE"/>
       </xsl:call-template>
       <!-- Physical_Attributes -->
       <xsl:call-template name="AlterPhysicalAttributes">
        <xsl:with-param name="ParentNode" select="$ParentNode/sxml:SEGMENT_ATTRIBUTES"/>
       </xsl:call-template>
      </xsl:element>
     </xsl:element>
    </xsl:element>
   </xsl:when>
  </xsl:choose>
 </xsl:template>
 <xsl:template name="AlterMVLogging">
  <xsl:param name="LoggingNode" select="''"/>
  <xsl:param name="OnTableNode" select="''"/>
  <xsl:param name="Action" select="''"/>
  <!-- *******************************************************************
Template: AlterMVLogging
Logging node: 
Parameters:
  LoggingNode - LOGGING node
 OnTableNode - ON_TABLE node
 Action - PARSE or SQL
******************************************************************** -->
  <xsl:choose>
   <xsl:when test="$Action='PARSE' and ($PRS_NAME=1 or 
                               $PRS_CLAUSE_TYPE=1 or
                          					$PRS_CONSTRAINT_TYPE=1 or
				                          	$PRS_CONSTRAINT_STATE=1 or
                               $PRS_ALTERABLE=1 or
                               $PRS_XPATH=1)">
    <xsl:element name="PARSE_LIST">
     <xsl:call-template name="AddXPathParseItem">
      <xsl:with-param name="Node" select="$LoggingNode"/>
     </xsl:call-template>
     <xsl:call-template name="AddParseItem">
      <xsl:with-param name="ParseIt" select="$PRS_CLAUSE_TYPE"/>
      <xsl:with-param name="Item">CLAUSE_TYPE</xsl:with-param>
      <xsl:with-param name="Value1">LOGGING</xsl:with-param>
     </xsl:call-template>
    </xsl:element>
   </xsl:when>
   <xsl:when test="$Action='SQL'">
    <xsl:element name="SQL_LIST">
     <xsl:element name="SQL_LIST_ITEM">
      <xsl:element name="TEXT">
       <xsl:text>ALTER MATERIALIZED VIEW LOG ON </xsl:text>
       <xsl:call-template name="SchemaName">
        <xsl:with-param name="ParentNode" select="$OnTableNode"/>
       </xsl:call-template>
       <xsl:apply-templates select="$LoggingNode"/>
      </xsl:element>
     </xsl:element>
    </xsl:element>
   </xsl:when>
  </xsl:choose>
 </xsl:template>
 <xsl:template name="AlterMVLPartition">
  <xsl:param name="ParentNode" select="''"/>
  <xsl:param name="ObjType" select="''"/>
  <!-- *******************************************************************
Template: AlterMVLPartition
Current node: 
Parameters:
 ParentNode - MATERIALIZED_VIEW_LOG
 ObjType    - 'MATERIALIZED VIEW LOG
******************************************************************** -->
  <!-- useful variables -->
  <xsl:variable name="PartitionType">
   <xsl:choose>
    <xsl:when test="$ParentNode/sxml:RANGE_PARTITIONING">RANGE</xsl:when>
    <xsl:when test="$ParentNode/sxml:HASH_PARTITIONING">HASH</xsl:when>
    <xsl:when test="$ParentNode/sxml:LIST_PARTITIONING">LIST</xsl:when>
   </xsl:choose>
  </xsl:variable>
  <xsl:variable name="SubpartitionType">
   <xsl:choose>
    <xsl:when test="$ParentNode//sxml:RANGE_SUBPARTITIONING">RANGE</xsl:when>
    <xsl:when test="$ParentNode//sxml:HASH_SUBPARTITIONING">HASH</xsl:when>
    <xsl:when test="$ParentNode//sxml:LIST_SUBPARTITIONING">LIST</xsl:when>
   </xsl:choose>
  </xsl:variable>
  <xsl:variable name="PartitioningNode" select="$ParentNode/sxml:RANGE_PARTITIONING | $ParentNode/sxml:LIST_PARTITIONING | $ParentNode/sxml:HASH_PARTITIONING"/>
  <xsl:choose>
   <xsl:when test="$ParentNode/sxml:RANGE_PARTITIONING/@src or
                   $ParentNode/sxml:LIST_PARTITIONING/@src or 
                   $ParentNode/sxml:HASH_PARTITIONING/@src or
                   $PartitioningNode//sxml:COL_LIST//@src or
                   $PartitioningNode//sxml:COL_LIST//@value1">
    <xsl:call-template name="CommonNotAlterable">
     <xsl:with-param name="XpathNode" select="$ParentNode"/>
     <xsl:with-param name="Reason">INCOMPATIBLE_MVL_PARTITIONING</xsl:with-param>
     <xsl:with-param name="Message" select="$MSG_INCOMPATIBLE_MVL_PARTITIONING"/>
    </xsl:call-template>
   </xsl:when>
   <xsl:otherwise>
    <xsl:call-template name="AlterPartitions">
     <xsl:with-param name="TableNode" select="$ParentNode"/>
     <xsl:with-param name="PartitionType" select="$PartitionType"/>
     <xsl:with-param name="SubpartitionType" select="$SubpartitionType"/>
     <xsl:with-param name="ParentNode" select="$PartitioningNode"/>
     <xsl:with-param name="ObjType" select="$ObjType"/>
    </xsl:call-template>
   </xsl:otherwise>
  </xsl:choose>
 </xsl:template>
 <xsl:template name="AlterRecords">
  <xsl:param name="ParentNode" select="''"/>
  <!-- *******************************************************************
Template: AlterRecords - Process RECORDS differences
Parameters:
 ParentNode - parent of RECORDS node
******************************************************************** -->
   <xsl:if test="$ParentNode/sxml:RECORDS/sxml:ROWID/@src='1'">
    <xsl:call-template name="CommonNotAlterable">
     <xsl:with-param name="XpathNode" select="$ParentNode/sxml:RECORDS/sxml:ROWID"/>
     <xsl:with-param name="NameNode" select="sxml:NAME"/>
     <xsl:with-param name="Reason">MSG_INVALID_MVL_AUGMENTATION</xsl:with-param>
     <xsl:with-param name="Message" select="$MSG_INVALID_MVL_AUGMENTATION"/>
     <xsl:with-param name="Subst">DROP ROWID</xsl:with-param>
    </xsl:call-template>
   </xsl:if>
   <xsl:if test="$ParentNode/sxml:RECORDS/sxml:PRIMARY_KEY/@src='1'">
    <xsl:call-template name="CommonNotAlterable">
     <xsl:with-param name="XpathNode" select="$ParentNode/sxml:RECORDS/sxml:PRIMARY_KEY"/>
     <xsl:with-param name="NameNode" select="sxml:NAME"/>
     <xsl:with-param name="Reason">MSG_INVALID_MVL_AUGMENTATION</xsl:with-param>
     <xsl:with-param name="Message" select="$MSG_INVALID_MVL_AUGMENTATION"/>
     <xsl:with-param name="Subst">DROP PRIMARY KEY</xsl:with-param>
    </xsl:call-template>
   </xsl:if>
   <xsl:if test="$ParentNode/sxml:RECORDS/sxml:SEQUENCE/@src='1'">
    <xsl:call-template name="CommonNotAlterable">
     <xsl:with-param name="XpathNode" select="$ParentNode/sxml:RECORDS/sxml:SEQUENCE"/>
     <xsl:with-param name="NameNode" select="sxml:NAME"/>
     <xsl:with-param name="Reason">MSG_INVALID_MVL_AUGMENTATION</xsl:with-param>
     <xsl:with-param name="Message" select="$MSG_INVALID_MVL_AUGMENTATION"/>
     <xsl:with-param name="Subst">DROP SEQUENCE</xsl:with-param>
    </xsl:call-template>
   </xsl:if>
   <xsl:if test="$ParentNode/sxml:RECORDS/sxml:OBJECT_ID/@src='1'">
    <xsl:call-template name="CommonNotAlterable">
     <xsl:with-param name="XpathNode" select="$ParentNode/sxml:RECORDS/sxml:OBJECT_ID"/>
     <xsl:with-param name="NameNode" select="sxml:NAME"/>
     <xsl:with-param name="Reason">MSG_INVALID_MVL_AUGMENTATION</xsl:with-param>
     <xsl:with-param name="Message" select="$MSG_INVALID_MVL_AUGMENTATION"/>
     <xsl:with-param name="Subst">DROP OBJECT_ID</xsl:with-param>
    </xsl:call-template>
   </xsl:if>
   <xsl:if test="$ParentNode/sxml:RECORDS/sxml:OBJECT_ID/@src='2'">
    <xsl:call-template name="CommonNotAlterable">
     <xsl:with-param name="XpathNode" select="$ParentNode/sxml:RECORDS/sxml:OBJECT_ID"/>
     <xsl:with-param name="NameNode" select="sxml:NAME"/>
     <xsl:with-param name="Reason">MSG_INVALID_MVL_AUGMENTATION</xsl:with-param>
     <xsl:with-param name="Message" select="$MSG_INVALID_MVL_AUGMENTATION"/>
     <xsl:with-param name="Subst">ADD OBJECT_ID</xsl:with-param>
    </xsl:call-template>
   </xsl:if>
   <xsl:if test="$ParentNode/sxml:RECORDS/sxml:COL_LIST//*[@value1] or
                   $ParentNode/sxml:RECORDS/sxml:COL_LIST//*[@src] or 
                   $ParentNode/sxml:RECORDS/sxml:COL_LIST/@src='1'">
    <xsl:call-template name="CommonNotAlterable">
     <xsl:with-param name="XpathNode" select="$ParentNode/sxml:RECORDS/sxml:COL_LIST"/>
     <xsl:with-param name="NameNode" select="sxml:NAME"/>
     <xsl:with-param name="Reason">MSG_INVALID_MVL_AUGMENTATION</xsl:with-param>
     <xsl:with-param name="Message" select="$MSG_INVALID_MVL_AUGMENTATION"/>
     <xsl:with-param name="Subst">MODIFY COLUMN LIST</xsl:with-param>
    </xsl:call-template>
   </xsl:if>
   <xsl:if test="$ParentNode/sxml:RECORDS/*/@src='2' or
                 $ParentNode/sxml:INCLUDING_NEW_VALUES/@src">
    <xsl:element name="ALTER_LIST_ITEM">
     <xsl:call-template name="DoAlterRecords">
      <xsl:with-param name="ParentNode" select="$ParentNode"/>
      <xsl:with-param name="Action">PARSE</xsl:with-param>
     </xsl:call-template>
      <xsl:call-template name="DoAlterRecords">
       <xsl:with-param name="ParentNode" select="$ParentNode"/>
       <xsl:with-param name="Action">SQL</xsl:with-param>
      </xsl:call-template>
     </xsl:element>
   </xsl:if>
 </xsl:template>
 <xsl:template name="DoAlterRecords">
  <xsl:param name="ParentNode" select="''"/>
  <xsl:param name="Action" select="''"/>
  <!-- *******************************************************************
Template: DoAlterRecords - The RECORD node contains 
    ROWID:      Only ADDS are supported
    COL_LIST: Only ADDS are supported
Parameters:
 ParentNode - parent of RECORDS node
 Action   - PARSE or SQL
******************************************************************** -->
  <xsl:choose>
   <xsl:when test="$Action='PARSE' and ($PRS_CLAUSE_TYPE=1 or
                                        $PRS_XPATH=1)">
    <xsl:element name="PARSE_LIST">
     <xsl:call-template name="AddXPathParseItem">
      <xsl:with-param name="Node" select="$ParentNode/sxml:RECORDS"/>
     </xsl:call-template>
     <!-- Add PARSE_ITEM for ROWID (if appropriate) -->
     <xsl:if test="$ParentNode/sxml:RECORDS/sxml:ROWID/@src='2'">
      <xsl:call-template name="AddParseItem">
       <xsl:with-param name="ParseIt" select="$PRS_CLAUSE_TYPE"/>
       <xsl:with-param name="Item">CLAUSE_TYPE</xsl:with-param>
       <xsl:with-param name="Value1">ADD_ROWID</xsl:with-param>
      </xsl:call-template>
     </xsl:if>
     <!-- Add PARSE_ITEM for PRIMARY_KEY (if appropriate) -->
     <xsl:if test="$ParentNode/sxml:RECORDS/sxml:PRIMARY_KEY/@src='2'">
      <xsl:call-template name="AddParseItem">
       <xsl:with-param name="ParseIt" select="$PRS_CLAUSE_TYPE"/>
       <xsl:with-param name="Item">CLAUSE_TYPE</xsl:with-param>
       <xsl:with-param name="Value1">ADD_PRIMARY_KEY</xsl:with-param>
      </xsl:call-template>
     </xsl:if>
     <!-- Add PARSE_ITEM for SEQUENCE (if appropriate) -->
     <xsl:if test="$ParentNode/sxml:RECORDS/sxml:SEQUENCE/@src='2'">
      <xsl:call-template name="AddParseItem">
       <xsl:with-param name="ParseIt" select="$PRS_CLAUSE_TYPE"/>
       <xsl:with-param name="Item">CLAUSE_TYPE</xsl:with-param>
       <xsl:with-param name="Value1">ADD_SEQUENCE</xsl:with-param>
      </xsl:call-template>
     </xsl:if>
     <!-- Add PARSE_ITEM for OBJECT_ID  (if appropriate) -->
     <xsl:if test="$ParentNode/sxml:RECORDS/sxml:OBJECT_ID/@src='2'">
      <xsl:call-template name="AddParseItem">
       <xsl:with-param name="ParseIt" select="$PRS_CLAUSE_TYPE"/>
       <xsl:with-param name="Item">CLAUSE_TYPE</xsl:with-param>
       <xsl:with-param name="Value1">ADD_OBJECT_ID </xsl:with-param>
      </xsl:call-template>
     </xsl:if>
     <!-- Add PARSE_ITEM for COL_LIST (if appropriate) -->
     <xsl:choose>
      <xsl:when test="$ParentNode/sxml:RECORDS/sxml:COL_LIST/@src='2'">
       <xsl:call-template name="AddParseItem">
        <xsl:with-param name="ParseIt" select="$PRS_CLAUSE_TYPE"/>
        <xsl:with-param name="Item">CLAUSE_TYPE</xsl:with-param>
        <xsl:with-param name="Value1">ADD COL_LIST</xsl:with-param>
       </xsl:call-template>
      </xsl:when>
     </xsl:choose>
     <!-- Add PARSE_ITEM for INCLUDING_NEW_VALUES (if appropriate) -->
     <xsl:if test="$ParentNode/sxml:INCLUDING_NEW_VALUES/@src='1'">
      <xsl:call-template name="AddParseItem">
       <xsl:with-param name="ParseIt" select="$PRS_CLAUSE_TYPE"/>
       <xsl:with-param name="Item">CLAUSE_TYPE</xsl:with-param>
       <xsl:with-param name="Value1">EXCLUDING_NEW_VALUE</xsl:with-param>
      </xsl:call-template>
     </xsl:if>
     <xsl:if test="$ParentNode/sxml:INCLUDING_NEW_VALUES/@src='2'">
      <xsl:call-template name="AddParseItem">
       <xsl:with-param name="ParseIt" select="$PRS_CLAUSE_TYPE"/>
       <xsl:with-param name="Item">CLAUSE_TYPE</xsl:with-param>
       <xsl:with-param name="Value1">INCLUDING_NEW_VALUE</xsl:with-param>
      </xsl:call-template>
     </xsl:if>
    </xsl:element>
   </xsl:when>
   <xsl:when test="$Action='SQL'">
    <xsl:element name="SQL_LIST">
     <xsl:element name="SQL_LIST_ITEM">
      <xsl:element name="TEXT">
       <xsl:text>ALTER MATERIALIZED VIEW LOG ON </xsl:text>
       <xsl:call-template name="SchemaName">
        <xsl:with-param name="ParentNode" select="$ParentNode/sxml:ON_TABLE"/>
       </xsl:call-template>
       <xsl:text> ADD</xsl:text>
       <xsl:if test="$ParentNode/sxml:RECORDS/sxml:OBJECT_ID/@src='2'">
        <xsl:text> OBJECT ID</xsl:text>
       </xsl:if>
       <xsl:if test="$ParentNode/sxml:RECORDS/sxml:PRIMARY_KEY/@src='2'">
        <xsl:if test="$ParentNode/sxml:RECORDS/sxml:OBJECT_ID/@src='2'">
         <xsl:text>,</xsl:text>
        </xsl:if>
        <xsl:text> PRIMARY KEY</xsl:text>
       </xsl:if>
       <xsl:if test="$ParentNode/sxml:RECORDS/sxml:ROWID/@src='2'">
        <xsl:if test="$ParentNode/sxml:RECORDS/sxml:OBJECT_ID/@src='2' or
               $ParentNode/sxml:RECORDS/sxml:PRIMARY_KEY/@src='2'">
         <xsl:text>,</xsl:text>
        </xsl:if>
        <xsl:text> ROWID</xsl:text>
       </xsl:if>
       <xsl:if test="$ParentNode/sxml:RECORDS/sxml:SEQUENCE/@src='2'">
        <xsl:if test="$ParentNode/sxml:RECORDS/sxml:OBJECT_ID/@src='2' or
               $ParentNode/sxml:RECORDS/sxml:PRIMARY_KEY/@src='2' or
               $ParentNode/sxml:RECORDS/sxml:ROWID/@src='2'">
         <xsl:text>,</xsl:text>
        </xsl:if>
        <xsl:text> SEQUENCE</xsl:text>
       </xsl:if>
       <xsl:if test="$ParentNode/sxml:RECORDS/sxml:COL_LIST/@src='2'">
        <xsl:text> (</xsl:text>
        <xsl:call-template name="AlterCOL_LIST">
         <xsl:with-param name="ColListItems" select="$ParentNode/sxml:RECORDS/sxml:COL_LIST/sxml:COL_LIST_ITEM"/>
        </xsl:call-template>
        <xsl:text>)</xsl:text>
       </xsl:if>
       <!-- New_values_clause -->
       <xsl:if test="$ParentNode/sxml:INCLUDING_NEW_VALUES/@src='2'">
        <xsl:text> INCLUDING NEW VALUES </xsl:text>
       </xsl:if>
       <xsl:if test="$ParentNode/sxml:INCLUDING_NEW_VALUES/@src='1'">
        <xsl:text> EXCLUDING NEW VALUES </xsl:text>
       </xsl:if>
      </xsl:element>
     </xsl:element>
    </xsl:element>
   </xsl:when>
  </xsl:choose>
 </xsl:template>
</xsl:stylesheet>
