<?xml version="1.0"?>
<!--

 Copyright (c) 2007, 2010, Oracle and/or its affiliates. All rights reserved. 

NAME
    kuaque.xsl
DESCRIPTION
    Convert sxml AQ_QUEUE diff document to ALTER_XML document

MODIFIED        MM/DD/YY
    lbarton     01/13/10 - bug 8796742: translatable error messages
    lbarton     07/10/08 - bug 5709159: SQL_LIST_ITEM subelements
    htseng      01/08/07 - Initial version
 -->
<xsl:stylesheet version="1.0" xmlns:sxml="http://xmlns.oracle.com/ku" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
 <!-- Top level imports -->
 <xsl:import href="kuacomm.xsl"/>
 <!-- Templates -->
 <xsl:template match="sxml:AQ_QUEUE ">
  <!-- *******************************************************************
Template: AQ_QUEUE  - top-level template for AQ_QUEUE .
******************************************************************** -->
  <xsl:element name="ALTER_XML">
   <xsl:attribute name="xmlns">http://xmlns.oracle.com/ku</xsl:attribute>
   <xsl:attribute name="version">1.0</xsl:attribute>
   <!-- Object type -->
   <xsl:element name="OBJECT_TYPE">AQ_QUEUE</xsl:element>
   <!-- Display schema.objname for CoMPareObjects 1 and 2  -->
   <xsl:call-template name="CmpObjects">
    <xsl:with-param name="ParentNode" select="."/>
   </xsl:call-template>
   <!-- Alter list -->
   <xsl:element name="ALTER_LIST">
    <!-- NOT_ALTERABLE cases -->
    <xsl:if test="./sxml:DEPENDENCY_TRACKING/@src">
     <xsl:call-template name="CommonNotAlterable">
      <xsl:with-param name="XpathNode" select="./sxml:DEPENDENCY_TRACKING"/>
      <xsl:with-param name="NameNode" select="sxml:NAME"/>
      <xsl:with-param name="Reason">AQ_QUEUE_ATTRIBUTE</xsl:with-param>
      <xsl:with-param name="Message" select="$MSG_AQ_QUEUE_ATTRIBUTE"/>
      <xsl:with-param name="Subst">DEPENDENCY_TRACKING</xsl:with-param>
     </xsl:call-template>
    </xsl:if>
    <xsl:if test="./sxml:EXCEPTION_QUEUE/@src">
     <xsl:call-template name="CommonNotAlterable">
      <xsl:with-param name="XpathNode" select="./sxml:EXCEPTION_QUEUE"/>
      <xsl:with-param name="NameNode" select="sxml:NAME"/>
      <xsl:with-param name="Reason">AQ_QUEUE_ATTRIBUTE</xsl:with-param>
      <xsl:with-param name="Message" select="$MSG_AQ_QUEUE_ATTRIBUTE"/>
      <xsl:with-param name="Subst">EXCEPTION_QUEUE</xsl:with-param>
     </xsl:call-template>
     <xsl:if test="./sxml:MAX_RETRIES/@value1 or ./sxml:MAX_RETRIES/@src='2'">
      <xsl:call-template name="CommonNotAlterable">
       <xsl:with-param name="XpathNode" select="./sxml:MAX_RETRIES"/>
       <xsl:with-param name="NameNode" select="sxml:NAME"/>
       <xsl:with-param name="Reason">AQ_QUEUE_ATTRIBUTE</xsl:with-param>
       <xsl:with-param name="Message" select="$MSG_AQ_QUEUE_ATTRIBUTE"/>
       <xsl:with-param name="Subst">MAX_RETRIES</xsl:with-param>
      </xsl:call-template>
     </xsl:if>
     <xsl:if test="./sxml:RETRY_DELAY/@value1 or ./sxml:RETRY_DELAY/@src='2'">
      <xsl:call-template name="CommonNotAlterable">
       <xsl:with-param name="XpathNode" select="./sxml:RETRY_DELAY"/>
       <xsl:with-param name="NameNode" select="sxml:NAME"/>
       <xsl:with-param name="Reason">AQ_QUEUE_ATTRIBUTE</xsl:with-param>
       <xsl:with-param name="Message" select="$MSG_AQ_QUEUE_ATTRIBUTE"/>
       <xsl:with-param name="Subst">RETRY_DELAY</xsl:with-param>
      </xsl:call-template>
     </xsl:if>
     <xsl:if test="./sxml:RETENTION/@value1 or ./sxml:RETENTION/@src='2'">
      <xsl:call-template name="CommonNotAlterable">
       <xsl:with-param name="XpathNode" select="./sxml:RETENTION"/>
       <xsl:with-param name="NameNode" select="sxml:NAME"/>
       <xsl:with-param name="Reason">AQ_QUEUE_ATTRIBUTE</xsl:with-param>
       <xsl:with-param name="Message" select="$MSG_AQ_QUEUE_ATTRIBUTE"/>
       <xsl:with-param name="Subst">RETENTION</xsl:with-param>
      </xsl:call-template>
     </xsl:if>
    </xsl:if>
    <xsl:if test="((sxml:MAX_RETRIES/@value1 or sxml:MAX_RETRIES/@src='2' or
                  sxml:RETRY_DELAY/@value1 or sxml:RETRY_DELAY/@src='2' or
                  sxml:RETENTION/@value1 or sxml:RETENTION/@src='2')
                  and not (sxml:EXCEPTION_QUEUE/@src)) or
                  sxml:AUTO_COMMIT/@value1 or sxml:AUTO_COMMIT/@src='2' or
                  sxml:COMMENT/@value1 or sxml:COMMENT/@src='2'">
     <xsl:element name="ALTER_LIST_ITEM">
      <xsl:call-template name="AlterQueue">
       <xsl:with-param name="ParentNode" select="."/>
       <xsl:with-param name="Action">PARSE</xsl:with-param>
      </xsl:call-template>
      <xsl:call-template name="AlterQueue">
       <xsl:with-param name="ParentNode" select="."/>
       <xsl:with-param name="Action">SQL</xsl:with-param>
      </xsl:call-template>
     </xsl:element>
    </xsl:if>
   </xsl:element>
  </xsl:element>
 </xsl:template>
 <xsl:template name="AlterQueue">
  <xsl:param name="ParentNode" select="''"/>
  <xsl:param name="Action" select="''"/>
  <!-- *******************************************************************
Template: AlterQueue
Parameters:
 ParentNode - 
 Action   - PARSE or SQL
******************************************************************** -->
  <xsl:choose>
   <xsl:when test="$Action='PARSE' and ($PRS_NAME=1 or 
                                        $PRS_CLAUSE_TYPE=1 or
                                        $PRS_COLUMN_ATTRIBUTE=1 or
                                        $PRS_XPATH=1)">
    <xsl:element name="PARSE_LIST">
     <xsl:call-template name="AddXPathParseItem">
      <xsl:with-param name="Node" select="$ParentNode"/>
     </xsl:call-template>
     <xsl:call-template name="AddParseItem">
      <xsl:with-param name="ParseIt" select="$PRS_NAME"/>
      <xsl:with-param name="Item">NAME</xsl:with-param>
      <xsl:with-param name="Value1" select="$ParentNode/sxml:NAME"/>
     </xsl:call-template>
     <xsl:call-template name="AddParseItem">
      <xsl:with-param name="ParseIt" select="$PRS_CLAUSE_TYPE"/>
      <xsl:with-param name="Item">CLAUSE_TYPE</xsl:with-param>
      <xsl:with-param name="Value1">AQ_QUEUE</xsl:with-param>
     </xsl:call-template>
     <xsl:call-template name="AddParseItem">
      <xsl:with-param name="ParseIt" select="$PRS_COLUMN_ATTRIBUTE"/>
      <xsl:with-param name="Item">AQ_QUEUE_PARAMETERS</xsl:with-param>
      <xsl:with-param name="Value1">
       <xsl:if test="$ParentNode/sxml:MAX_RETRIES/@value1 or $ParentNode/sxml:MAX_RETRIES/@src='2'">MAX_RETRIES</xsl:if>
      </xsl:with-param>
      <xsl:with-param name="Value2">
       <xsl:if test="$ParentNode/sxml:RETRY_DELAY/@value1 or $ParentNode/sxml:RETRY_DELAY/@src='2'">RETRY_DELAY</xsl:if>
      </xsl:with-param>
      <xsl:with-param name="Value3">
       <xsl:if test="$ParentNode/sxml:RETENTION/@value1 or $ParentNode/sxml:RETENTION/@src='2'">RETENTION_TIME</xsl:if>
      </xsl:with-param>
      <xsl:with-param name="Value4">
       <xsl:if test="$ParentNode/sxml:AUTO_COMMIT/@value1 or $ParentNode/sxml:AUTO_COMMIT/@src='2'">AUTO_COMMIT</xsl:if>
      </xsl:with-param>
      <xsl:with-param name="Value5">
       <xsl:if test="$ParentNode/sxml:COMMENT/@value1 or $ParentNode/sxml:COMMENT/@src='2'">COMMENT</xsl:if>
      </xsl:with-param>
     </xsl:call-template>
    </xsl:element>
   </xsl:when>
   <xsl:when test="$Action='SQL'">
    <xsl:element name="SQL_LIST">
     <xsl:element name="SQL_LIST_ITEM">
      <xsl:element name="TEXT">
       <xsl:text> BEGIN DBMS_AQADM.ALTER_QUEUE(</xsl:text>
       <xsl:text>QUEUE_NAME => '</xsl:text>
       <xsl:call-template name="SchemaName">
        <xsl:with-param name="ParentNode" select="$ParentNode"/>
       </xsl:call-template>
       <xsl:text>'</xsl:text>
       <xsl:choose>
        <xsl:when test="$ParentNode/sxml:EXCEPTION_QUEUE/@src"/>
        <xsl:otherwise>
         <xsl:if test="$ParentNode/sxml:MAX_RETRIES/@value1 or $ParentNode/sxml:MAX_RETRIES/@src='2'">
          <xsl:text>, </xsl:text>
          <xsl:text>MAX_RETRIES => </xsl:text>
          <xsl:value-of select="$ParentNode/sxml:MAX_RETRIES"/>
         </xsl:if>
         <xsl:if test="$ParentNode/sxml:RETRY_DELAY/@value1 or $ParentNode/sxml:RETRY_DELAY/@src='2'">
          <xsl:text>, </xsl:text>
          <xsl:text>RETRY_DELAY => </xsl:text>
          <xsl:value-of select="$ParentNode/sxml:RETRY_DELAY"/>
         </xsl:if>
         <xsl:if test="$ParentNode/sxml:RETENTION/@value1 or $ParentNode/sxml:RETENTION/@src='2'">
          <xsl:text>, </xsl:text>
          <xsl:text>RETENTION_TIME => </xsl:text>
          <xsl:value-of select="$ParentNode/sxml:RETENTION"/>
         </xsl:if>
        </xsl:otherwise>
       </xsl:choose>
       <xsl:if test="$ParentNode/sxml:AUTO_COMMIT/@value1 or $ParentNode/sxml:AUTO_COMMIT/@src='2'">
        <xsl:text>, </xsl:text>
        <xsl:text>AUTO_COMMIT => </xsl:text>
        <xsl:value-of select="$ParentNode/sxml:AUTO_COMMIT"/>
       </xsl:if>
       <xsl:if test="$ParentNode/sxml:COMMENT/@value1 or $ParentNode/sxml:COMMENT/@src='2'">
        <xsl:text>, </xsl:text>
        <xsl:text>COMMENT => '</xsl:text>
        <xsl:value-of select="$ParentNode/sxml:COMMENT"/>
        <xsl:text>'</xsl:text>
       </xsl:if>
       <xsl:text> ); </xsl:text>
       <xsl:text>END; </xsl:text>
      </xsl:element>
     </xsl:element>
    </xsl:element>
   </xsl:when>
  </xsl:choose>
 </xsl:template>
</xsl:stylesheet>
