<?xml version="1.0"?>
<!--

 Copyright (c) 2007, 2010, Oracle and/or its affiliates. All rights reserved. 

NAME
    kuarls.xsl
DESCRIPTION
    Convert sxml RLS_GROUP, RLS_POLICY, RLS_CONTEXT diff document to ALTER_XML document

MODIFIED        MM/DD/YY
    lbarton     01/26/10 - bug 8796742: translatable error messages
    lbarton     07/10/08 - bug 5709159: SQL_LIST_ITEM subelements
    htseng      01/16/07 - Initial version
 -->
<xsl:stylesheet version="1.0" xmlns:sxml="http://xmlns.oracle.com/ku" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
 <!-- Top level imports -->
 <xsl:import href="kuacomm.xsl"/>
 <!-- Templates -->
 <xsl:template match="sxml:RLS_POLICY">
  <!-- *******************************************************************
Template: RLS_POLICY  - top-level template for RLS_POLICY.
******************************************************************** -->
  <xsl:element name="ALTER_XML">
   <xsl:attribute name="xmlns">http://xmlns.oracle.com/ku</xsl:attribute>
   <xsl:attribute name="version">1.0</xsl:attribute>
   <!-- Object type -->
   <xsl:element name="OBJECT_TYPE">RLS_POLICY</xsl:element>
   <!-- Display schema.objname for CoMPareObjects 1 and 2  -->
   <xsl:call-template name="CmpObjects">
    <xsl:with-param name="ParentNode" select="."/>
   </xsl:call-template>
   <!-- Alter list -->
   <xsl:element name="ALTER_LIST">
    <xsl:element name="ALTER_LIST_ITEM">
     <xsl:if test="sxml:POLICY_GROUP/@value1 or
                   sxml:POLICY_NAME/@value1 or
		   sxml:FUNCTION_SCHEMA/@value1 or
		   sxml:POLICY_FUNCTION/@value1 or
		   sxml:UPDATE_CHECK/@value1 or
		   sxml:ENABLE/@value1 or
		   sxml:STATIC_POLICY/@value1 or
		   sxml:POLICY_TYPE/@value1 or
		   sxml:LONG_PREDICATE/@value1 or
		   sxml:RELEVANT_COLUMN_LIST/@src or
		   sxml:ALL_ROWS/@src">
      <!-- drop it first -->
      <xsl:call-template name="DropRlsPolicy">
       <xsl:with-param name="ParentNode" select="."/>
       <xsl:with-param name="Action">PARSE</xsl:with-param>
      </xsl:call-template>
      <xsl:call-template name="DropRlsPolicy">
       <xsl:with-param name="ParentNode" select="."/>
       <xsl:with-param name="Action">SQL</xsl:with-param>
      </xsl:call-template>
      <!-- add it -->
      <xsl:call-template name="AddRlsPolicy">
       <xsl:with-param name="ParentNode" select="."/>
       <xsl:with-param name="Action">PARSE</xsl:with-param>
      </xsl:call-template>
      <xsl:call-template name="AddRlsPolicy">
       <xsl:with-param name="ParentNode" select="."/>
       <xsl:with-param name="Action">SQL</xsl:with-param>
      </xsl:call-template>
     </xsl:if>
    </xsl:element>
   </xsl:element>
  </xsl:element>
 </xsl:template>
 <xsl:template name="DropRlsPolicy">
  <xsl:param name="ParentNode" select="''"/>
  <xsl:param name="Action" select="''"/>
  <!-- *******************************************************************
Template: DropRlsPolicy
Parameters:
 ParentNode - 
 Action   - PARSE or SQL
******************************************************************** -->
  <xsl:choose>
   <xsl:when test="$Action='PARSE' and ($PRS_NAME=1 or 
                                        $PRS_CLAUSE_TYPE=1 or
                                        $PRS_XPATH=1)">
    <xsl:element name="PARSE_LIST">
     <xsl:call-template name="AddXPathParseItem">
      <xsl:with-param name="Node" select="$ParentNode"/>
     </xsl:call-template>
     <xsl:call-template name="AddParseItem">
      <xsl:with-param name="ParseIt" select="$PRS_NAME"/>
      <xsl:with-param name="Item">NAME</xsl:with-param>
      <xsl:with-param name="Value1" select="$ParentNode/sxml:NAME"/>
     </xsl:call-template>
     <xsl:call-template name="AddParseItem">
      <xsl:with-param name="ParseIt" select="$PRS_CLAUSE_TYPE"/>
      <xsl:with-param name="Item">CLAUSE_TYPE</xsl:with-param>
      <xsl:with-param name="Value1">DROP RLS_GROUP_POLICY</xsl:with-param>
     </xsl:call-template>
    </xsl:element>
   </xsl:when>
   <xsl:when test="$Action='SQL'">
    <xsl:element name="SQL_LIST">
     <xsl:element name="SQL_LIST_ITEM">
      <xsl:element name="TEXT">
       <xsl:text> BEGIN  DBMS_RLS.DROP_GROUPED_POLICY ( '</xsl:text>
       <xsl:choose>
        <xsl:when test="$ParentNode/sxml:SCHEMA/@value1">
         <xsl:value-of select="$ParentNode/sxml:SCHEMA/@value1"/>
        </xsl:when>
        <xsl:otherwise>
         <xsl:value-of select="$ParentNode/sxml:SCHEMA"/>
        </xsl:otherwise>
       </xsl:choose>
       <xsl:text>','</xsl:text>
       <xsl:choose>
        <xsl:when test="$ParentNode/sxml:NAME/@value1">
         <xsl:value-of select="$ParentNode/sxml:NAME/@value1"/>
        </xsl:when>
        <xsl:otherwise>
         <xsl:value-of select="$ParentNode/sxml:NAME"/>
        </xsl:otherwise>
       </xsl:choose>
       <xsl:text>','</xsl:text>
       <xsl:choose>
        <xsl:when test="$ParentNode/sxml:POLICY_GROUP/@value1">
         <xsl:value-of select="$ParentNode/sxml:POLICY_GROUP/@value1"/>
        </xsl:when>
        <xsl:otherwise>
         <xsl:value-of select="$ParentNode/sxml:POLICY_GROUP"/>
        </xsl:otherwise>
       </xsl:choose>
       <xsl:text>','</xsl:text>
       <xsl:choose>
        <xsl:when test="$ParentNode/sxml:POLICY_NAME/@value1">
         <xsl:value-of select="$ParentNode/sxml:POLICY_NAME/@value1"/>
        </xsl:when>
        <xsl:otherwise>
         <xsl:value-of select="$ParentNode/sxml:POLICY_NAME"/>
        </xsl:otherwise>
       </xsl:choose>
       <xsl:text>'); </xsl:text>
       <xsl:text>END; </xsl:text>
      </xsl:element>
     </xsl:element>
    </xsl:element>
   </xsl:when>
  </xsl:choose>
 </xsl:template>
 <xsl:template name="AddRlsPolicy">
  <xsl:param name="ParentNode" select="''"/>
  <xsl:param name="Action" select="''"/>
  <!-- *******************************************************************
Template: AddRlsPolicy
Parameters:
 ParentNode - 
 Action   - PARSE or SQL
******************************************************************** -->
  <xsl:choose>
   <xsl:when test="$Action='PARSE' and ($PRS_NAME=1 or 
                                        $PRS_CLAUSE_TYPE=1 or
                                        $PRS_XPATH=1)">
    <xsl:element name="PARSE_LIST">
     <xsl:call-template name="AddXPathParseItem">
      <xsl:with-param name="Node" select="$ParentNode"/>
     </xsl:call-template>
     <xsl:call-template name="AddParseItem">
      <xsl:with-param name="ParseIt" select="$PRS_NAME"/>
      <xsl:with-param name="Item">NAME</xsl:with-param>
      <xsl:with-param name="Value1" select="$ParentNode/sxml:NAME"/>
     </xsl:call-template>
     <xsl:call-template name="AddParseItem">
      <xsl:with-param name="ParseIt" select="$PRS_CLAUSE_TYPE"/>
      <xsl:with-param name="Item">CLAUSE_TYPE</xsl:with-param>
      <xsl:with-param name="Value1">ADD RLS_GROUP_POLICY</xsl:with-param>
     </xsl:call-template>
    </xsl:element>
   </xsl:when>
   <xsl:when test="$Action='SQL'">
    <xsl:element name="SQL_LIST">
     <xsl:element name="SQL_LIST_ITEM">
      <xsl:element name="TEXT">
       <xsl:text>  BEGIN DBMS_RLS.ADD_GROUPED_POLICY('</xsl:text>
       <xsl:choose>
        <xsl:when test="$ParentNode/sxml:SCHEMA/@value1">
         <xsl:value-of select="$ParentNode/sxml:SCHEMA/@value1"/>
        </xsl:when>
        <xsl:otherwise>
         <xsl:value-of select="$ParentNode/sxml:SCHEMA"/>
        </xsl:otherwise>
       </xsl:choose>
       <xsl:text>','</xsl:text>
       <xsl:choose>
        <xsl:when test="$ParentNode/sxml:NAME/@value1">
         <xsl:value-of select="$ParentNode/sxml:NAME/@value1"/>
        </xsl:when>
        <xsl:otherwise>
         <xsl:value-of select="$ParentNode/sxml:NAME"/>
        </xsl:otherwise>
       </xsl:choose>
       <xsl:text>','</xsl:text>
       <xsl:value-of select="$ParentNode/sxml:POLICY_GROUP"/>
       <xsl:text>','</xsl:text>
       <xsl:value-of select="$ParentNode/sxml:POLICY_NAME"/>
       <xsl:text>','</xsl:text>
       <xsl:value-of select="$ParentNode/sxml:FUNCTION_SCHEMA"/>
       <xsl:text>','</xsl:text>
       <xsl:value-of select="$ParentNode/sxml:POLICY_FUNCTION"/>
       <xsl:text>','</xsl:text>
       <xsl:call-template name="StatementLIST">
        <xsl:with-param name="StatItems" select="$ParentNode/sxml:STATEMENT_TYPE_LIST/sxml:STATEMENT_TYPE_LIST_ENTRY"/>
       </xsl:call-template>
       <xsl:text>',</xsl:text>
       <xsl:choose>
        <xsl:when test="$ParentNode/sxml:UPDATE_CHECK='Y'">
         <xsl:text>TRUE,</xsl:text>
        </xsl:when>
        <xsl:otherwise>
         <xsl:text>FALSE,</xsl:text>
        </xsl:otherwise>
       </xsl:choose>
       <xsl:choose>
        <xsl:when test="$ParentNode/sxml:ENABLE='Y'">
         <xsl:text>TRUE,</xsl:text>
        </xsl:when>
        <xsl:otherwise>
         <xsl:text>FALSE,</xsl:text>
        </xsl:otherwise>
       </xsl:choose>
       <xsl:choose>
        <xsl:when test="$ParentNode/sxml:STATIC_POLICY='Y'">
         <xsl:text>TRUE,</xsl:text>
        </xsl:when>
        <xsl:otherwise>
         <xsl:text>FALSE,</xsl:text>
        </xsl:otherwise>
       </xsl:choose>
       <xsl:value-of select="$ParentNode/sxml:POLICY_TYPE"/>
       <xsl:text>,</xsl:text>
       <xsl:choose>
        <xsl:when test="$ParentNode/sxml:LONG_PREDICATE='Y'">
         <xsl:text>TRUE,'</xsl:text>
        </xsl:when>
        <xsl:otherwise>
         <xsl:text>FALSE,'</xsl:text>
        </xsl:otherwise>
       </xsl:choose>
       <!-- list of security relevant cols, ok to have empty str:
       will have something like '' (empty list) or '"COL1","COL2"'
  -->
       <xsl:choose>
        <xsl:when test="$ParentNode/sxml:RELEVANT_COLUMN_LIST/@src='2'">
         <xsl:for-each select="$ParentNode/sxml:RELEVANT_COLUMN_LIST/sxml:RELEVANT_COLUMN_LIST_ENTRY/sxml:NAME">
          <xsl:text>"</xsl:text>
          <xsl:value-of select="."/>
          <xsl:text>"</xsl:text>
          <xsl:if test="not(position()=last())">
           <xsl:text>,</xsl:text>
          </xsl:if>
         </xsl:for-each>
        </xsl:when>
        <xsl:otherwise/>
       </xsl:choose>
       <xsl:text>',</xsl:text>
       <!-- security relevant cols option -->
       <!-- this is for statement type SELECT only -->
       <xsl:choose>
        <xsl:when test="$ParentNode/sxml:ALL_ROWS/@src='2'">
         <xsl:text>dbms_rls.ALL_ROWS</xsl:text>
        </xsl:when>
        <xsl:otherwise>
         <xsl:text>NULL</xsl:text>
        </xsl:otherwise>
       </xsl:choose>
       <xsl:text>)</xsl:text>
       <xsl:text>; END;</xsl:text>
      </xsl:element>
     </xsl:element>
    </xsl:element>
   </xsl:when>
  </xsl:choose>
 </xsl:template>
 <xsl:template match="sxml:RLS_GROUP">
  <!-- *******************************************************************
Template: RLS_GROUP  - top-level template for RLS_POLICY_GROUP.
******************************************************************** -->
  <xsl:element name="ALTER_XML">
   <xsl:attribute name="xmlns">http://xmlns.oracle.com/ku</xsl:attribute>
   <xsl:attribute name="version">1.0</xsl:attribute>
   <!-- Object type -->
   <xsl:element name="OBJECT_TYPE">RLS_GROUP</xsl:element>
   <!-- Display schema.objname for CoMPareObjects 1 and 2  -->
   <xsl:call-template name="CmpObjects">
    <xsl:with-param name="ParentNode" select="."/>
   </xsl:call-template>
   <!-- Alter list -->
   <xsl:element name="ALTER_LIST">
    <xsl:element name="ALTER_LIST_ITEM">
     <xsl:if test="sxml:POLICY_GROUP/@value1">
      <!-- drop it first -->
      <xsl:call-template name="DropRlsPolicyGroup">
       <xsl:with-param name="ParentNode" select="."/>
       <xsl:with-param name="Action">PARSE</xsl:with-param>
      </xsl:call-template>
      <xsl:call-template name="DropRlsPolicyGroup">
       <xsl:with-param name="ParentNode" select="."/>
       <xsl:with-param name="Action">SQL</xsl:with-param>
      </xsl:call-template>
      <!-- add it -->
      <xsl:call-template name="AddRlsPolicyGroup">
       <xsl:with-param name="ParentNode" select="."/>
       <xsl:with-param name="Action">PARSE</xsl:with-param>
      </xsl:call-template>
      <xsl:call-template name="AddRlsPolicyGroup">
       <xsl:with-param name="ParentNode" select="."/>
       <xsl:with-param name="Action">SQL</xsl:with-param>
      </xsl:call-template>
     </xsl:if>
    </xsl:element>
   </xsl:element>
  </xsl:element>
 </xsl:template>
 <xsl:template name="DropRlsPolicyGroup">
  <xsl:param name="ParentNode" select="''"/>
  <xsl:param name="Action" select="''"/>
  <!-- *******************************************************************
Template: DropRlsPolicyGroup
Parameters:
 ParentNode - 
 Action   - PARSE or SQL
******************************************************************** -->
  <xsl:choose>
   <xsl:when test="$Action='PARSE' and ($PRS_NAME=1 or 
                                        $PRS_CLAUSE_TYPE=1 or
                                        $PRS_XPATH=1)">
    <xsl:element name="PARSE_LIST">
     <xsl:call-template name="AddXPathParseItem">
      <xsl:with-param name="Node" select="$ParentNode"/>
     </xsl:call-template>
     <xsl:call-template name="AddParseItem">
      <xsl:with-param name="ParseIt" select="$PRS_NAME"/>
      <xsl:with-param name="Item">NAME</xsl:with-param>
      <xsl:with-param name="Value1" select="$ParentNode/sxml:NAME"/>
     </xsl:call-template>
     <xsl:call-template name="AddParseItem">
      <xsl:with-param name="ParseIt" select="$PRS_CLAUSE_TYPE"/>
      <xsl:with-param name="Item">CLAUSE_TYPE</xsl:with-param>
      <xsl:with-param name="Value1">DELETE RLS_POLICY_GROUP</xsl:with-param>
     </xsl:call-template>
    </xsl:element>
   </xsl:when>
   <xsl:when test="$Action='SQL'">
    <xsl:element name="SQL_LIST">
     <xsl:element name="SQL_LIST_ITEM">
      <xsl:element name="TEXT">
       <xsl:text> BEGIN  DBMS_RLS.DELETE_POLICY_GROUP ( '</xsl:text>
       <xsl:choose>
        <xsl:when test="$ParentNode/sxml:SCHEMA/@value1">
         <xsl:value-of select="$ParentNode/sxml:SCHEMA/@value1"/>
        </xsl:when>
        <xsl:otherwise>
         <xsl:value-of select="$ParentNode/sxml:SCHEMA"/>
        </xsl:otherwise>
       </xsl:choose>
       <xsl:text>','</xsl:text>
       <xsl:choose>
        <xsl:when test="$ParentNode/sxml:NAME/@value1">
         <xsl:value-of select="$ParentNode/sxml:NAME/@value1"/>
        </xsl:when>
        <xsl:otherwise>
         <xsl:value-of select="$ParentNode/sxml:NAME"/>
        </xsl:otherwise>
       </xsl:choose>
       <xsl:text>','</xsl:text>
       <xsl:choose>
        <xsl:when test="$ParentNode/sxml:POLICY_GROUP/@value1">
         <xsl:value-of select="$ParentNode/sxml:POLICY_GROUP/@value1"/>
        </xsl:when>
        <xsl:otherwise>
         <xsl:value-of select="$ParentNode/sxml:POLICY_GROUP"/>
        </xsl:otherwise>
       </xsl:choose>
       <xsl:text>'); </xsl:text>
       <xsl:text>END; </xsl:text>
      </xsl:element>
     </xsl:element>
    </xsl:element>
   </xsl:when>
  </xsl:choose>
 </xsl:template>
 <xsl:template name="AddRlsPolicyGroup">
  <xsl:param name="ParentNode" select="''"/>
  <xsl:param name="Action" select="''"/>
  <!-- *******************************************************************
Template: AddRlsPolicyGroup
Parameters:
 ParentNode - 
 Action   - PARSE or SQL
******************************************************************** -->
  <xsl:choose>
   <xsl:when test="$Action='PARSE' and ($PRS_NAME=1 or 
                                        $PRS_CLAUSE_TYPE=1 or
                                        $PRS_XPATH=1)">
    <xsl:element name="PARSE_LIST">
     <xsl:call-template name="AddXPathParseItem">
      <xsl:with-param name="Node" select="$ParentNode"/>
     </xsl:call-template>
     <xsl:call-template name="AddParseItem">
      <xsl:with-param name="ParseIt" select="$PRS_NAME"/>
      <xsl:with-param name="Item">NAME</xsl:with-param>
      <xsl:with-param name="Value1" select="$ParentNode/sxml:NAME"/>
     </xsl:call-template>
     <xsl:call-template name="AddParseItem">
      <xsl:with-param name="ParseIt" select="$PRS_CLAUSE_TYPE"/>
      <xsl:with-param name="Item">CLAUSE_TYPE</xsl:with-param>
      <xsl:with-param name="Value1">CREATE RLS_POLICY_GROUP</xsl:with-param>
     </xsl:call-template>
    </xsl:element>
   </xsl:when>
   <xsl:when test="$Action='SQL'">
    <xsl:element name="SQL_LIST">
     <xsl:element name="SQL_LIST_ITEM">
      <xsl:element name="TEXT">
       <xsl:text>  BEGIN DBMS_RLS.CREATE_POLICY_GROUP('</xsl:text>
       <xsl:choose>
        <xsl:when test="$ParentNode/sxml:SCHEMA/@value1">
         <xsl:value-of select="$ParentNode/sxml:SCHEMA/@value1"/>
        </xsl:when>
        <xsl:otherwise>
         <xsl:value-of select="$ParentNode/sxml:SCHEMA"/>
        </xsl:otherwise>
       </xsl:choose>
       <xsl:text>','</xsl:text>
       <xsl:choose>
        <xsl:when test="$ParentNode/sxml:NAME/@value1">
         <xsl:value-of select="$ParentNode/sxml:NAME/@value1"/>
        </xsl:when>
        <xsl:otherwise>
         <xsl:value-of select="$ParentNode/sxml:NAME"/>
        </xsl:otherwise>
       </xsl:choose>
       <xsl:text>','</xsl:text>
       <xsl:value-of select="$ParentNode/sxml:POLICY_GROUP"/>
       <xsl:text>'); </xsl:text>
       <xsl:text> END;</xsl:text>
      </xsl:element>
     </xsl:element>
    </xsl:element>
   </xsl:when>
  </xsl:choose>
 </xsl:template>
 <xsl:template name="StatementLIST">
  <xsl:param name="StatItems" select="''"/>
  <!-- ***********************
Template: StatementLIST 
Parameters:
StateItems - STATEMENT_TYPE_LIST_ITEM nodes
******************************************************************** -->
  <xsl:for-each select="$StatItems">
   <xsl:choose>
    <xsl:when test="@src='1'"/>
    <xsl:otherwise>
     <xsl:if test="position()!=1">
      <!-- to avoid the last item is @src='1' -->
      <xsl:text>,</xsl:text>
     </xsl:if>
     <xsl:value-of select="sxml:NAME"/>
    </xsl:otherwise>
   </xsl:choose>
  </xsl:for-each>
 </xsl:template>
</xsl:stylesheet>
