<?xml version="1.0"?>
<!--

 Copyright (c) 2007, 2010, Oracle and/or its affiliates. All rights reserved. 

NAME
    kuasyn.xsl
DESCRIPTION
    Convert sxml SYNONYM diff document to ALTER_XML document

MODIFIED        MM/DD/YY
    lbarton     01/26/10 - bug 8796742: translatable error messages
    lbarton     07/10/08 - bug 5709159: SQL_LIST_ITEM subelements
    lbarton     01/03/07 - Initial version
 -->
<xsl:stylesheet version="1.0" xmlns:sxml="http://xmlns.oracle.com/ku" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
 <!-- Top level imports -->
 <xsl:import href="kuacomm.xsl"/>
 <!-- Templates -->
 <xsl:template match="sxml:SYNONYM">
  <!-- *******************************************************************
Template: SYNONYM  - top-level template for synonym.
******************************************************************** -->
  <xsl:element name="ALTER_XML">
   <xsl:attribute name="xmlns">http://xmlns.oracle.com/ku</xsl:attribute>
   <xsl:attribute name="version">1.0</xsl:attribute>
   <!-- Object type -->
   <xsl:element name="OBJECT_TYPE">SYNONYM</xsl:element>
   <!-- Display schema.objname for CoMPareObjects 1 and 2  -->
   <xsl:call-template name="CmpObjects">
    <xsl:with-param name="ParentNode" select="."/>
   </xsl:call-template>
   <!-- Alter list -->
   <xsl:element name="ALTER_LIST">
    <xsl:element name="ALTER_LIST_ITEM">
     <xsl:if test="$PRS_NAME=1 or 
                   $PRS_XPATH=1">
      <xsl:element name="PARSE_LIST">
       <xsl:call-template name="AddXPathParseItem">
        <xsl:with-param name="Node" select="."/>
       </xsl:call-template>
       <xsl:call-template name="AddParseItem">
        <xsl:with-param name="ParseIt" select="$PRS_NAME"/>
        <xsl:with-param name="Item">NAME</xsl:with-param>
        <xsl:with-param name="Value1" select="sxml:NAME"/>
       </xsl:call-template>
      </xsl:element>
     </xsl:if>
     <xsl:element name="SQL_LIST">
      <xsl:element name="SQL_LIST_ITEM">
       <xsl:element name="TEXT">
        <xsl:call-template name="CreSyn"/>
       </xsl:element>
      </xsl:element>
     </xsl:element>
    </xsl:element>
   </xsl:element>
  </xsl:element>
 </xsl:template>
</xsl:stylesheet>
