<?xml version="1.0"?>
<!--

 Copyright (c) 2006, 2009, Oracle and/or its affiliates. All rights reserved. 

NAME
    kuatable.xsl
DESCRIPTION
    Convert sxml TABLE diff document to ALTER_XML document

MODIFIED        MM/DD/YY
    lbarton     10/29/09 - bug 8796742: translatable error messages
    abodge      09/24/09 - CONSOLIDATE STYLESHEETS: Partitioning check
    rapayne     11/30/08 - bug 7595899: sync with ChangeManager (tableproperties)
    lbarton     07/10/08 - bug 5709159: SQL_LIST_ITEM subelements
    rapayne     02/29/08 - Add prameter to AlterConstraints template to support
                           OBJECT_TABLE constraints.
    pkaliren    03/13/07 - Adding Table properties
    lbarton     09/22/06 - modularize
    htseng      08/21/06 - alter iot clause
    htseng      08/15/06 -
    htseng	08/07/06 - physical_properities,supplemental_table support
    htseng      07/20/06 - constraint support
    rapayne     06/09/06 - 
    lbarton     05/25/05 - Initial version
 -->
<xsl:stylesheet version="1.0" xmlns:sxml="http://xmlns.oracle.com/ku" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
 <!-- Top level imports -->
 <xsl:import href="kuacomm.xsl"/>
 <xsl:import href="kustablc.xsl"/>
 <xsl:import href="kuatcol.xsl"/>
 <xsl:import href="kuatpar.xsl"/>
 <xsl:import href="kuacnstr.xsl"/>
 <xsl:import href="kuatprop.xsl"/>
 <xsl:import href="kustbphd.xsl"/>
 <!-- Templates -->
 <xsl:template match="sxml:TABLE">
  <!-- *******************************************************************
Template: TABLE - top-level template for tables.
******************************************************************** -->
  <xsl:element name="ALTER_XML">
   <xsl:attribute name="xmlns">http://xmlns.oracle.com/ku</xsl:attribute>
   <xsl:attribute name="version">1.0</xsl:attribute>
   <!-- Object type -->
   <xsl:element name="OBJECT_TYPE">TABLE</xsl:element>
   <!-- Display schema.objname for CoMPareObjects 1 and 2 -->
   <xsl:call-template name="CmpObjects">
    <xsl:with-param name="ParentNode" select="."/>
   </xsl:call-template>
   <!-- Alter list -->
   <xsl:element name="ALTER_LIST">
    <!-- table type -->
    <xsl:call-template name="TableType">
     <xsl:with-param name="ParentNode" select="."/>
    </xsl:call-template>
    <!-- columns -->
    <xsl:call-template name="AlterColumns">
     <xsl:with-param name="ParentNode" select="."/>
    </xsl:call-template>
    <!-- constraints -->
    <xsl:call-template name="AlterConstraints">
     <xsl:with-param name="TableNode" select="."/>
     <xsl:with-param name="ParentNode" select="sxml:RELATIONAL_TABLE | sxml:OBJECT_TABLE"/>
    </xsl:call-template>
    <!-- Table_Properities -->
    <xsl:call-template name="AlterTableProperties">
     <xsl:with-param name="ParentNode" select="."/>
    </xsl:call-template>
    <!-- Table_Partitioning -->
    <xsl:call-template name="AlterTablePartitions">
     <xsl:with-param name="ParentNode" select="."/>
    </xsl:call-template>
    <!-- table name rename (the last thing we do) -->
    <xsl:call-template name="RenTable">
     <xsl:with-param name="ParentNode" select="."/>
    </xsl:call-template>
   </xsl:element>
  </xsl:element>
 </xsl:template>
 <xsl:template name="TableType">
  <xsl:param name="ParentNode" select="''"/>
  <!-- *******************************************************************
Template: TableType - Detects certain non-alterable cases
      (1) can't interconvert between relational, object or XMLType table
      (2) can't change object type of object table
      (3) can't alter partition vs. non-partition 
Parameters:
 ParentNode - Parent node of SCHEMA, NAME
******************************************************************** -->
  <xsl:variable name="TableName">
   <xsl:call-template name="SchemaName">
    <xsl:with-param name="ParentNode" select="$ParentNode"/>
   </xsl:call-template>
  </xsl:variable>
  <xsl:if test="$ParentNode/sxml:RELATIONAL_TABLE[@src] or
                $ParentNode/sxml:OBJECT_TABLE[@src] or
                $ParentNode/sxml:XMLTYPE_TABLE[@src]">
   <xsl:call-template name="CommonNotAlterable">
    <xsl:with-param name="XpathNode" select="$ParentNode"/>
    <xsl:with-param name="NameNode" select="$ParentNode/sxml:NAME"/>
    <xsl:with-param name="Reason">TABLE_TYPE</xsl:with-param>
    <xsl:with-param name="Message" select="$MSG_TABLE_TYPE"/>
    <xsl:with-param name="Subst" select="$TableName"/>
   </xsl:call-template>
  </xsl:if>
  <xsl:if test="$ParentNode/sxml:OBJECT_TABLE/sxml:OF_TYPE/sxml:SCHEMA[@value1]
            or  $ParentNode/sxml:OBJECT_TABLE/sxml:OF_TYPE/sxml:NAME[@value1]">
   <xsl:call-template name="CommonNotAlterable">
    <xsl:with-param name="XpathNode" select="$ParentNode/sxml:OBJECT_TABLE/sxml:OF_TYPE"/>
    <xsl:with-param name="NameNode" select="$ParentNode/sxml:NAME"/>
    <xsl:with-param name="Reason">OBJECT_TABLE_TYPE</xsl:with-param>
    <xsl:with-param name="Message" select="$MSG_OBJECT_TABLE_TYPE"/>
    <xsl:with-param name="Subst" select="$TableName"/>
   </xsl:call-template>
  </xsl:if>
  <!-- check partition vs non-partitioned -->
  <!-- NOTE: We are looking at RELATIONAL_TABLE/*_PARTITIONING as well as 
     RELATIONAL_TABLE/TABLE_PROPERTIES/*_PARTITIONING.  Currently (10.2.0.5GC),
     *_PARTITIONING can appear in either location.  This is not correct,
     and in future releases *_PARTITIONING will only appear within the
     TABLE_PROPERTIES element. -->
  <xsl:if test="$ParentNode/sxml:RELATIONAL_TABLE/sxml:TABLE_PROPERTIES/sxml:RANGE_PARTITIONING[@src] or
                $ParentNode/sxml:RELATIONAL_TABLE/sxml:RANGE_PARTITIONING[@src] or
                $ParentNode/sxml:RELATIONAL_TABLE/sxml:TABLE_PROPERTIES[@src]/sxml:RANGE_PARTITIONING or
                $ParentNode/sxml:RELATIONAL_TABLE/sxml:TABLE_PROPERTIES/sxml:HASH_PARTITIONING[@src] or
                $ParentNode/sxml:RELATIONAL_TABLE/sxml:HASH_PARTITIONING[@src] or
                $ParentNode/sxml:RELATIONAL_TABLE/sxml:TABLE_PROPERTIES[@src]/sxml:HASH_PARTITIONING or
                $ParentNode/sxml:RELATIONAL_TABLE/sxml:TABLE_PROPERTIES/sxml:LIST_PARTITIONING[@src] or
                $ParentNode/sxml:RELATIONAL_TABLE/sxml:LIST_PARTITIONING[@src] or
                $ParentNode/sxml:RELATIONAL_TABLE/sxml:TABLE_PROPERTIES[@src]/sxml:LIST_PARTITIONING">
   <xsl:call-template name="CommonNotAlterable">
    <xsl:with-param name="XpathNode" select="$ParentNode/sxml:RELATIONAL_TABLE/sxml:TABLE_PROPERTIES"/>
    <xsl:with-param name="NameNode" select="$ParentNode/sxml:NAME"/>
    <xsl:with-param name="Reason">ADD_REM_OR_MOD_PARTITIONING</xsl:with-param>
    <xsl:with-param name="Message" select="$MSG_ADD_REM_OR_MOD_PARTITIONING"/>
   </xsl:call-template>
  </xsl:if>
 </xsl:template>
 <xsl:template name="RenTable">
  <xsl:param name="ParentNode" select="''"/>
  <!-- *******************************************************************
Template: RenTable
Parameters:
 ParentNode - Parent node of SCHEMA, NAME
******************************************************************** -->
  <xsl:if test="$ParentNode/sxml:NAME[@value1]">
   <xsl:element name="ALTER_LIST_ITEM">
    <xsl:if test="$PRS_NAME=1 or 
                  $PRS_CLAUSE_TYPE=1 or
                  $PRS_XPATH=1">
     <xsl:element name="PARSE_LIST">
      <xsl:call-template name="AddXPathParseItem">
       <xsl:with-param name="Node" select="$ParentNode"/>
      </xsl:call-template>
      <xsl:call-template name="AddParseItem">
       <xsl:with-param name="ParseIt" select="$PRS_NAME"/>
       <xsl:with-param name="Item">NAME</xsl:with-param>
       <xsl:with-param name="Value1" select="$ParentNode/sxml:NAME/@value1"/>
      </xsl:call-template>
      <xsl:call-template name="AddParseItem">
       <xsl:with-param name="ParseIt" select="$PRS_CLAUSE_TYPE"/>
       <xsl:with-param name="Item">CLAUSE_TYPE</xsl:with-param>
       <xsl:with-param name="Value1">RENAME_TABLE</xsl:with-param>
      </xsl:call-template>
     </xsl:element>
    </xsl:if>
    <xsl:element name="SQL_LIST">
     <xsl:element name="SQL_LIST_ITEM">
      <xsl:element name="TEXT">
       <xsl:text>ALTER TABLE </xsl:text>
       <xsl:call-template name="SchemaName">
        <xsl:with-param name="ParentNode" select="$ParentNode"/>
       </xsl:call-template>
       <xsl:text> RENAME TO </xsl:text>
       <xsl:call-template name="QuotedName">
        <xsl:with-param name="NameNode" select="sxml:NAME"/>
       </xsl:call-template>
      </xsl:element>
     </xsl:element>
    </xsl:element>
   </xsl:element>
  </xsl:if>
 </xsl:template>
</xsl:stylesheet>
