<?xml version="1.0"?>
<!--

 Copyright (c) 2006, 2010, Oracle and/or its affiliates. All rights reserved. 

NAME
    kuatbls.xsl
DESCRIPTION
    Convert sxml TABLESPACE diff document to ALTER_XML document

MODIFIED        MM/DD/YY
    lbarton      01/14/10 - bug 8796742: translatable error messages
    rapayne      06/09/06 - Initial version
 -->
<xsl:stylesheet version="1.0" xmlns:sxml="http://xmlns.oracle.com/ku" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
 <!-- Top level imports -->
 <xsl:import href="kuacomm.xsl"/>
 <!-- params for parse -->
 <xsl:template match="sxml:TABLESPACE">
  <!-- *******************************************************************
Template: TABLESPACE - top-level template for tablespaces.
******************************************************************** -->
  <xsl:element name="ALTER_XML">
   <xsl:attribute name="xmlns">http://xmlns.oracle.com/ku</xsl:attribute>
   <xsl:attribute name="version">1.0</xsl:attribute>
   <!-- Object type -->
   <xsl:element name="OBJECT_TYPE">TABLESPACE</xsl:element>
   <!-- Display schema.objname for CoMPareObjects 1 and 2  -->
   <xsl:call-template name="CmpObjects">
    <xsl:with-param name="ParentNode" select="."/>
   </xsl:call-template>
   <!-- Alter list -->
   <xsl:element name="ALTER_LIST">
    <!-- check top level unalterable stuff:
          - BIGFILE
          - Tablespace type
   -->
    <xsl:if test="sxml:BIGFILE/@src">
     <xsl:call-template name="CommonNotAlterable">
      <xsl:with-param name="XpathNode" select="sxml:BIGFILE"/>
      <xsl:with-param name="NameNode" select="sxml:NAME"/>
      <xsl:with-param name="Reason">BIGFILE</xsl:with-param>
      <xsl:with-param name="Message" select="$MSG_BIGFILE"/>
     </xsl:call-template>
    </xsl:if>
    <xsl:choose>
     <xsl:when test="sxml:TYPE/@value1">
      <xsl:call-template name="CommonNotAlterable">
       <xsl:with-param name="XpathNode" select="sxml:TYPE"/>
       <xsl:with-param name="NameNode" select="sxml:NAME"/>
       <xsl:with-param name="Reason">TABLESPACE_TYPE</xsl:with-param>
       <xsl:with-param name="Message" select="$MSG_TABLESPACE_TYPE"/>
      </xsl:call-template>
     </xsl:when>
     <xsl:when test="sxml:TYPE='PERMANENT'">
      <xsl:call-template name="PermanentTablespace">
       <xsl:with-param name="ParentNode" select="."/>
      </xsl:call-template>
     </xsl:when>
     <xsl:when test="sxml:TYPE='TEMPORARY'">
      <xsl:call-template name="TemporaryTablespace">
       <xsl:with-param name="ParentNode" select="."/>
      </xsl:call-template>
     </xsl:when>
     <xsl:when test="sxml:TYPE='UNDO'">
      <xsl:call-template name="UndoTablespace">
       <xsl:with-param name="ParentNode" select="."/>
      </xsl:call-template>
     </xsl:when>
    </xsl:choose>
    <!-- tablespace rename (the last thing we do) -->
    <xsl:call-template name="RenTablespace">
     <xsl:with-param name="ParentNode" select="."/>
    </xsl:call-template>
   </xsl:element>
  </xsl:element>
 </xsl:template>
 <!-- Supporting templates follow:-->
 <xsl:template name="PermanentTablespace">
  <xsl:param name="ParentNode" select="''"/>
  <!-- *******************************************************************
Template: PermanentTablespace
Parameters:
 ParentNode - TABLESPACE node
******************************************************************** -->
  <!-- MINIMUM_EXTENT -->
  <xsl:if test="sxml:MINIMUM_EXTENT/@value1">
   <xsl:element name="ALTER_LIST_ITEM">
    <xsl:call-template name="AlterMinExtent">
     <xsl:with-param name="ParentNode" select="$ParentNode"/>
     <xsl:with-param name="Action">PARSE</xsl:with-param>
    </xsl:call-template>
    <xsl:call-template name="AlterMinExtent">
     <xsl:with-param name="ParentNode" select="$ParentNode"/>
     <xsl:with-param name="Action">SQL</xsl:with-param>
    </xsl:call-template>
   </xsl:element>
  </xsl:if>
  <!-- BLOCKSIZE is not alterable -->
  <xsl:if test="sxml:BLOCKSIZE/@value1">
   <xsl:call-template name="CommonNotAlterable">
    <xsl:with-param name="XpathNode" select="sxml:BLOCKSIZE"/>
    <xsl:with-param name="NameNode" select="sxml:NAME"/>
    <xsl:with-param name="Reason">BLOCKSIZE</xsl:with-param>
    <xsl:with-param name="Message" select="$MSG_BLOCKSIZE"/>
   </xsl:call-template>
  </xsl:if>
  <!-- Logging -->
  <xsl:if test="sxml:LOGGING/@value1">
   <xsl:element name="ALTER_LIST_ITEM">
    <xsl:call-template name="AlterLogging">
     <xsl:with-param name="ParentNode" select="$ParentNode"/>
     <xsl:with-param name="Action">PARSE</xsl:with-param>
    </xsl:call-template>
    <xsl:call-template name="AlterLogging">
     <xsl:with-param name="ParentNode" select="$ParentNode"/>
     <xsl:with-param name="Action">SQL</xsl:with-param>
    </xsl:call-template>
   </xsl:element>
  </xsl:if>
  <!-- Force_Logging -->
  <xsl:if test="sxml:FORCE_LOGGING/@src">
   <xsl:element name="ALTER_LIST_ITEM">
    <xsl:call-template name="AlterForceLogging">
     <xsl:with-param name="ParentNode" select="$ParentNode"/>
     <xsl:with-param name="Action">PARSE</xsl:with-param>
    </xsl:call-template>
    <xsl:call-template name="AlterForceLogging">
     <xsl:with-param name="ParentNode" select="$ParentNode"/>
     <xsl:with-param name="Action">SQL</xsl:with-param>
    </xsl:call-template>
   </xsl:element>
  </xsl:if>
  <!-- DEFAULT COMPRESS -->
  <xsl:call-template name="AlterTbspCompress">
   <xsl:with-param name="ParentNode" select="$ParentNode"/>
   <xsl:with-param name="DefaultNode" select="sxml:DEFAULT"/>
  </xsl:call-template>
  <!-- Alter tablespace state  -->
  <xsl:call-template name="AlterTablespaceState">
   <xsl:with-param name="ParentNode" select="$ParentNode"/>
  </xsl:call-template>
  <!-- Add DATAFILES  -->
  <xsl:call-template name="AddDatafiles">
   <xsl:with-param name="ParentNode" select="$ParentNode"/>
   <xsl:with-param name="DatafileList" select="sxml:DATAFILE_LIST"/>
  </xsl:call-template>
  <!-- Drop DATAFILES  -->
  <xsl:call-template name="DropDatafiles">
   <xsl:with-param name="ParentNode" select="$ParentNode"/>
   <xsl:with-param name="DatafileList" select="sxml:DATAFILE_LIST"/>
  </xsl:call-template>
  <!-- Alter DATAFILES  - adjust bigfile size -->
  <xsl:call-template name="AlterDatafiles">
   <xsl:with-param name="ParentNode" select="$ParentNode"/>
   <xsl:with-param name="DatafileList" select="sxml:DATAFILE_LIST"/>
  </xsl:call-template>
  <!-- ENCRYPTION is NOT alterable -->
  <xsl:if test="sxml:ENCRYPT/@src">
   <xsl:call-template name="CommonNotAlterable">
    <xsl:with-param name="XpathNode" select="sxml:ENCRYPT"/>
    <xsl:with-param name="NameNode" select="sxml:NAME"/>
    <xsl:with-param name="Reason">ENCRYPTION</xsl:with-param>
    <xsl:with-param name="Message" select="$MSG_ENCRYPTION"/>
   </xsl:call-template>
  </xsl:if>
  <!-- EXTENT_MANAGEMENT  -->
  <xsl:call-template name="CheckExtentManagement">
   <xsl:with-param name="ParentNode" select="$ParentNode"/>
  </xsl:call-template>
  <!-- SEGMENT_SPACE_MANAGEMENT  -->
  <xsl:if test="sxml:SEGMENT_SPACE_MANAGEMENT/@src or
                    sxml:SEGMENT_SPACE_MANAGEMENT/@value1">
   <xsl:call-template name="AlterSegSpace">
    <xsl:with-param name="ParentNode" select="$ParentNode"/>
    <xsl:with-param name="SegSpaceNode" select="sxml:SEGMENT_SPACE_MANAGEMENT"/>
   </xsl:call-template>
  </xsl:if>
  <!-- FLASHBACK   -->
  <xsl:if test="sxml:FLASHBACK_OFF/@src or
                    sxml:FLASHBACK_OFF/@value1">
   <xsl:call-template name="CommonNotAlterable">
    <xsl:with-param name="XpathNode" select="sxml:FLASHBACK_OFF"/>
    <xsl:with-param name="NameNode" select="sxml:NAME"/>
    <xsl:with-param name="Reason">FLASHBACK</xsl:with-param>
    <xsl:with-param name="Message" select="$MSG_FLASHBACK"/>
   </xsl:call-template>
  </xsl:if>
 </xsl:template>
 <xsl:template name="TemporaryTablespace">
  <xsl:param name="ParentNode" select="''"/>
  <!-- *******************************************************************
Template: TemporaryTablespace
Parameters:
 ParentNode - TABLESPACE node
******************************************************************** -->
  <!-- Add DATAFILES  -->
  <xsl:call-template name="AddDatafiles">
   <xsl:with-param name="ParentNode" select="."/>
   <xsl:with-param name="DatafileList" select="sxml:DATAFILE_LIST"/>
  </xsl:call-template>
  <!-- Drop DATAFILES -->
  <xsl:call-template name="DropDatafiles">
   <xsl:with-param name="ParentNode" select="."/>
   <xsl:with-param name="DatafileList" select="sxml:DATAFILE_LIST"/>
  </xsl:call-template>
  <!-- Process TABLESPACE_GROUP diffs -->
  <xsl:if test="sxml:TABLESPACE_GROUP/@src or
                        sxml:TABLESPACE_GROUP/@value1">
   <xsl:element name="ALTER_LIST_ITEM">
    <xsl:call-template name="AlterTablespaceGroup">
     <xsl:with-param name="ParentNode" select="."/>
     <xsl:with-param name="Action">PARSE</xsl:with-param>
    </xsl:call-template>
    <xsl:call-template name="AlterTablespaceGroup">
     <xsl:with-param name="ParentNode" select="."/>
     <xsl:with-param name="Action">SQL</xsl:with-param>
    </xsl:call-template>
   </xsl:element>
  </xsl:if>
  <!-- Process EXTENT_MANAGEMENT diffs -->
  <xsl:call-template name="CheckExtentManagement">
   <xsl:with-param name="ParentNode" select="."/>
  </xsl:call-template>
 </xsl:template>
 <xsl:template name="UndoTablespace">
  <xsl:param name="ParentNode" select="''"/>
  <!-- *******************************************************************
Template: UndoTablespace
Parameters:
 ParentNode - TABLESPACE node
******************************************************************** -->
  <!-- Process EXTENT_MANAGEMENT diffs -->
  <xsl:call-template name="CheckExtentManagement">
   <xsl:with-param name="ParentNode" select="$ParentNode"/>
  </xsl:call-template>
  <!-- Process RETENTION_GUARANTEE diff  -->
  <xsl:if test="$ParentNode/sxml:RETENTION_GUARANTEE/@src or
                       $ParentNode/sxml:RETENTION_GUARANTEE/@value1">
   <xsl:element name="ALTER_LIST_ITEM">
    <xsl:call-template name="AlterRetention">
     <xsl:with-param name="ParentNode" select="$ParentNode"/>
     <xsl:with-param name="Action">PARSE</xsl:with-param>
    </xsl:call-template>
    <xsl:call-template name="AlterRetention">
     <xsl:with-param name="ParentNode" select="$ParentNode"/>
     <xsl:with-param name="Action">SQL</xsl:with-param>
    </xsl:call-template>
   </xsl:element>
  </xsl:if>
 </xsl:template>
 <!-- Supporting templates follow:-->
 <xsl:template name="CheckExtentManagement">
  <xsl:param name="ParentNode" select="''"/>
  <!-- *******************************************************************
Template: CheckExtentManagement- Nothing in this clause seems to be alterable.
Parameters:
 ParentNode - TABLESPACE node
******************************************************************** -->
  <xsl:choose>
   <xsl:when test="sxml:EXTENT_MANAGEMENT//@value1 or 
                               sxml:EXTENT_MANAGEMENT//@src">
    <xsl:call-template name="CommonNotAlterable">
     <xsl:with-param name="XpathNode" select="sxml:EXTENT_MANAGEMENT"/>
     <xsl:with-param name="NameNode" select="sxml:NAME"/>
     <xsl:with-param name="Reason">EXTENT_MANAGEMENT</xsl:with-param>
     <xsl:with-param name="Message" select="$MSG_EXTENT_MANAGEMENT"/>
    </xsl:call-template>
   </xsl:when>
  </xsl:choose>
 </xsl:template>
 <xsl:template name="AlterRetention">
  <xsl:param name="ParentNode" select="''"/>
  <xsl:param name="Action" select="''"/>
  <!-- *******************************************************************
Template: AlterRetention
Parameters:
 ParentNode - TABLESPACE node
Action - PARSE || SQL
******************************************************************** -->
  <xsl:choose>
   <xsl:when test="$Action='PARSE' and ($PRS_NAME=1 or 
                                        $PRS_CLAUSE_TYPE=1 or
                                        $PRS_XPATH=1)">
    <xsl:element name="PARSE_LIST">
     <xsl:call-template name="AddXPathParseItem">
      <xsl:with-param name="Node" select="$ParentNode"/>
     </xsl:call-template>
     <xsl:call-template name="AddParseItem">
      <xsl:with-param name="ParseIt" select="$PRS_NAME"/>
      <xsl:with-param name="Item">NAME</xsl:with-param>
      <xsl:with-param name="Value1" select="sxml:NAME"/>
     </xsl:call-template>
     <xsl:call-template name="AddParseItem">
      <xsl:with-param name="ParseIt" select="$PRS_CLAUSE_TYPE"/>
      <xsl:with-param name="Item">CLAUSE_TYPE</xsl:with-param>
      <xsl:with-param name="Value1">RETENTION_GUARANTEE</xsl:with-param>
     </xsl:call-template>
    </xsl:element>
   </xsl:when>
   <xsl:when test="$Action='SQL'">
    <xsl:element name="SQL_LIST">
     <xsl:element name="SQL_LIST_ITEM">
      <xsl:element name="TEXT">
       <xsl:text>ALTER TABLESPACE </xsl:text>
       <xsl:call-template name="SchemaName">
        <xsl:with-param name="ParentNode" select="$ParentNode"/>
       </xsl:call-template>
       <xsl:text> RETENTION </xsl:text>
       <xsl:choose>
        <xsl:when test="$ParentNode/sxml:RETENTION_GUARANTEE/@src='1'">
         <xsl:text>NO</xsl:text>
        </xsl:when>
       </xsl:choose>
       <xsl:text>GUARANTEE</xsl:text>
      </xsl:element>
     </xsl:element>
    </xsl:element>
   </xsl:when>
  </xsl:choose>
 </xsl:template>
 <xsl:template name="AlterMinExtent">
  <xsl:param name="ParentNode" select="''"/>
  <xsl:param name="Action" select="''"/>
  <!-- *******************************************************************
Template: AlterMinExtent
Parameters:
 ParentNode - TABLESPACE node
Action - PARSE || SQL
******************************************************************** -->
  <xsl:choose>
   <xsl:when test="$Action='PARSE' and ($PRS_NAME=1 or 
                                        $PRS_CLAUSE_TYPE=1 or
                                        $PRS_XPATH=1)">
    <xsl:element name="PARSE_LIST">
     <xsl:call-template name="AddXPathParseItem">
      <xsl:with-param name="Node" select="$ParentNode"/>
     </xsl:call-template>
     <xsl:call-template name="AddParseItem">
      <xsl:with-param name="ParseIt" select="$PRS_NAME"/>
      <xsl:with-param name="Item">NAME</xsl:with-param>
      <xsl:with-param name="Value1" select="sxml:NAME"/>
     </xsl:call-template>
     <xsl:call-template name="AddParseItem">
      <xsl:with-param name="ParseIt" select="$PRS_CLAUSE_TYPE"/>
      <xsl:with-param name="Item">CLAUSE_TYPE</xsl:with-param>
      <xsl:with-param name="Value1">MINIMUM_EXTENT</xsl:with-param>
     </xsl:call-template>
    </xsl:element>
   </xsl:when>
   <xsl:when test="$Action='SQL'">
    <xsl:element name="SQL_LIST">
     <xsl:element name="SQL_LIST_ITEM">
      <xsl:element name="TEXT">
       <xsl:text>ALTER TABLESPACE </xsl:text>
       <xsl:call-template name="SchemaName">
        <xsl:with-param name="ParentNode" select="$ParentNode"/>
       </xsl:call-template>
       <xsl:text> MINIMUM EXTENT </xsl:text>
       <xsl:value-of select="sxml:MINIMUM_EXTENT"/>
      </xsl:element>
     </xsl:element>
    </xsl:element>
   </xsl:when>
  </xsl:choose>
 </xsl:template>
 <xsl:template name="AlterLogging">
  <xsl:param name="ParentNode" select="''"/>
  <xsl:param name="Action" select="''"/>
  <!-- *******************************************************************
Template: AlterLogging
Parameters:
 ParentNode - TABLESPACE node
Action - PARSE || SQL
******************************************************************** -->
  <xsl:choose>
   <xsl:when test="$Action='PARSE' and ($PRS_NAME=1 or 
                                        $PRS_CLAUSE_TYPE=1 or
                                        $PRS_XPATH=1)">
    <xsl:element name="PARSE_LIST">
     <xsl:call-template name="AddXPathParseItem">
      <xsl:with-param name="Node" select="$ParentNode"/>
     </xsl:call-template>
     <xsl:call-template name="AddParseItem">
      <xsl:with-param name="ParseIt" select="$PRS_NAME"/>
      <xsl:with-param name="Item">NAME</xsl:with-param>
      <xsl:with-param name="Value1" select="sxml:NAME"/>
     </xsl:call-template>
     <xsl:call-template name="AddParseItem">
      <xsl:with-param name="ParseIt" select="$PRS_CLAUSE_TYPE"/>
      <xsl:with-param name="Item">CLAUSE_TYPE</xsl:with-param>
      <xsl:with-param name="Value1">LOGGING</xsl:with-param>
     </xsl:call-template>
    </xsl:element>
   </xsl:when>
   <xsl:when test="$Action='SQL'">
    <xsl:element name="SQL_LIST">
     <xsl:element name="SQL_LIST_ITEM">
      <xsl:element name="TEXT">
       <xsl:text>ALTER TABLESPACE </xsl:text>
       <xsl:call-template name="SchemaName">
        <xsl:with-param name="ParentNode" select="$ParentNode"/>
       </xsl:call-template>
       <xsl:choose>
        <xsl:when test="sxml:LOGGING/@src='1' or
                                    sxml:LOGGING/@value1='N'">
         <xsl:text> LOGGING</xsl:text>
        </xsl:when>
        <xsl:otherwise>
         <xsl:text> NOLOGGING</xsl:text>
        </xsl:otherwise>
       </xsl:choose>
      </xsl:element>
     </xsl:element>
    </xsl:element>
   </xsl:when>
  </xsl:choose>
 </xsl:template>
 <xsl:template name="AlterForceLogging">
  <xsl:param name="ParentNode" select="''"/>
  <xsl:param name="Action" select="''"/>
  <!-- *******************************************************************
Template: AlterForceLogging
Parameters:
 ParentNode - TABLESPACE node
Action - PARSE || SQL
******************************************************************** -->
  <xsl:choose>
   <xsl:when test="$Action='PARSE' and ($PRS_NAME=1 or 
                                        $PRS_CLAUSE_TYPE=1 or
                                        $PRS_XPATH=1)">
    <xsl:element name="PARSE_LIST">
     <xsl:call-template name="AddXPathParseItem">
      <xsl:with-param name="Node" select="$ParentNode"/>
     </xsl:call-template>
     <xsl:call-template name="AddParseItem">
      <xsl:with-param name="ParseIt" select="$PRS_NAME"/>
      <xsl:with-param name="Item">NAME</xsl:with-param>
      <xsl:with-param name="Value1" select="sxml:NAME"/>
     </xsl:call-template>
     <xsl:call-template name="AddParseItem">
      <xsl:with-param name="ParseIt" select="$PRS_CLAUSE_TYPE"/>
      <xsl:with-param name="Item">CLAUSE_TYPE</xsl:with-param>
      <xsl:with-param name="Value1">FORCE_LOGGING</xsl:with-param>
     </xsl:call-template>
    </xsl:element>
   </xsl:when>
   <xsl:when test="$Action='SQL'">
    <xsl:element name="SQL_LIST">
     <xsl:element name="SQL_LIST_ITEM">
      <xsl:element name="TEXT">
       <xsl:text>ALTER TABLESPACE </xsl:text>
       <xsl:call-template name="SchemaName">
        <xsl:with-param name="ParentNode" select="$ParentNode"/>
       </xsl:call-template>
       <xsl:if test="sxml:FORCE_LOGGING/@src='1'">
        <xsl:text> NO</xsl:text>
       </xsl:if>
       <xsl:text> FORCE LOGGING</xsl:text>
      </xsl:element>
     </xsl:element>
    </xsl:element>
   </xsl:when>
  </xsl:choose>
 </xsl:template>
 <xsl:template name="AlterTablespaceState">
  <xsl:param name="ParentNode" select="''"/>
  <!-- *******************************************************************
Template: AlterTablespaceState
Parameters:
 ParentNode - TABLESPACE node
******************************************************************** -->
  <!-- check ONLINE state -->
  <xsl:if test="sxml:OFFLINE/@src">
   <xsl:element name="ALTER_LIST_ITEM">
    <xsl:call-template name="AlterOnline">
     <xsl:with-param name="ParentNode" select="."/>
     <xsl:with-param name="Action">PARSE</xsl:with-param>
    </xsl:call-template>
    <xsl:call-template name="AlterOnline">
     <xsl:with-param name="ParentNode" select="."/>
     <xsl:with-param name="Action">SQL</xsl:with-param>
    </xsl:call-template>
   </xsl:element>
  </xsl:if>
  <!-- Check READ/WRITE state -->
  <xsl:if test="sxml:READ_ONLY/@src">
   <xsl:element name="ALTER_LIST_ITEM">
    <xsl:call-template name="AlterReadonly">
     <xsl:with-param name="ParentNode" select="."/>
     <xsl:with-param name="Action">PARSE</xsl:with-param>
    </xsl:call-template>
    <xsl:call-template name="AlterReadonly">
     <xsl:with-param name="ParentNode" select="."/>
     <xsl:with-param name="Action">SQL</xsl:with-param>
    </xsl:call-template>
   </xsl:element>
  </xsl:if>
 </xsl:template>
 <xsl:template name="AlterOnline">
  <xsl:param name="ParentNode" select="''"/>
  <xsl:param name="Action" select="''"/>
  <!-- *******************************************************************
Template: AlterOnline
Parameters:
 ParentNode - TABLESPACE node
Action - 'PARSE' or 'SQL'
******************************************************************** -->
  <xsl:choose>
   <xsl:when test="$Action='PARSE' and ($PRS_NAME=1 or 
                                        $PRS_CLAUSE_TYPE=1 or
                                        $PRS_XPATH=1)">
    <xsl:element name="PARSE_LIST">
     <xsl:call-template name="AddXPathParseItem">
      <xsl:with-param name="Node" select="$ParentNode"/>
     </xsl:call-template>
     <xsl:call-template name="AddParseItem">
      <xsl:with-param name="ParseIt" select="$PRS_NAME"/>
      <xsl:with-param name="Item">NAME</xsl:with-param>
      <xsl:with-param name="Value1" select="sxml:NAME"/>
     </xsl:call-template>
     <xsl:call-template name="AddParseItem">
      <xsl:with-param name="ParseIt" select="$PRS_CLAUSE_TYPE"/>
      <xsl:with-param name="Item">CLAUSE_TYPE</xsl:with-param>
      <xsl:with-param name="Value1">
       <xsl:choose>
        <xsl:when test="sxml:OFFLINE/@src='1'">ONLINE</xsl:when>
        <xsl:otherwise>OFFLINE</xsl:otherwise>
       </xsl:choose>
      </xsl:with-param>
     </xsl:call-template>
    </xsl:element>
   </xsl:when>
   <xsl:when test="$Action='SQL'">
    <xsl:element name="SQL_LIST">
     <xsl:element name="SQL_LIST_ITEM">
      <xsl:element name="TEXT">
       <xsl:text>ALTER TABLESPACE </xsl:text>
       <xsl:call-template name="SchemaName">
        <xsl:with-param name="ParentNode" select="$ParentNode"/>
       </xsl:call-template>
       <xsl:choose>
        <xsl:when test="sxml:OFFLINE/@src='1'"> ONLINE</xsl:when>
        <xsl:otherwise> OFFLINE</xsl:otherwise>
       </xsl:choose>
      </xsl:element>
     </xsl:element>
    </xsl:element>
   </xsl:when>
  </xsl:choose>
 </xsl:template>
 <xsl:template name="AlterReadonly">
  <xsl:param name="ParentNode" select="''"/>
  <xsl:param name="Action" select="''"/>
  <!-- *******************************************************************
Template: AlterReadonly
Parameters:
 ParentNode - TABLESPACE node
Action - 'PARSE' or 'SQL'
******************************************************************** -->
  <xsl:choose>
   <xsl:when test="$Action='PARSE' and ($PRS_NAME=1 or 
                                        $PRS_CLAUSE_TYPE=1 or
                                        $PRS_XPATH=1)">
    <xsl:element name="PARSE_LIST">
     <xsl:call-template name="AddXPathParseItem">
      <xsl:with-param name="Node" select="$ParentNode"/>
     </xsl:call-template>
     <xsl:call-template name="AddParseItem">
      <xsl:with-param name="ParseIt" select="$PRS_NAME"/>
      <xsl:with-param name="Item">NAME</xsl:with-param>
      <xsl:with-param name="Value1" select="sxml:NAME"/>
     </xsl:call-template>
     <xsl:call-template name="AddParseItem">
      <xsl:with-param name="ParseIt" select="$PRS_CLAUSE_TYPE"/>
      <xsl:with-param name="Item">CLAUSE_TYPE</xsl:with-param>
      <xsl:with-param name="Value1">
       <xsl:choose>
        <xsl:when test="sxml:READONLY/@src='1'">READWRITE</xsl:when>
        <xsl:otherwise>READONLY</xsl:otherwise>
       </xsl:choose>
      </xsl:with-param>
     </xsl:call-template>
    </xsl:element>
   </xsl:when>
   <xsl:when test="$Action='SQL'">
    <xsl:element name="SQL_LIST">
     <xsl:element name="SQL_LIST_ITEM">
      <xsl:element name="TEXT">
       <xsl:text>ALTER TABLESPACE </xsl:text>
       <xsl:call-template name="SchemaName">
        <xsl:with-param name="ParentNode" select="$ParentNode"/>
       </xsl:call-template>
       <xsl:choose>
        <xsl:when test="sxml:READONLY/@src='1'"> READWRITE</xsl:when>
        <xsl:otherwise> READ ONLY</xsl:otherwise>
       </xsl:choose>
      </xsl:element>
     </xsl:element>
    </xsl:element>
   </xsl:when>
  </xsl:choose>
 </xsl:template>
 <xsl:template name="DropDatafiles">
  <xsl:param name="ParentNode" select="''"/>
  <xsl:param name="DatafileList" select="''"/>
  <!-- *******************************************************************
Template: DropDatafiles - 
Parameters:
 ParentNode - TABLESPACE node
 DatafileList - <DATAFILE_LIST>
******************************************************************** -->
  <xsl:for-each select="$DatafileList/sxml:DATAFILE_LIST_ITEM">
   <xsl:if test="./@src='1'">
    <xsl:choose>
     <xsl:when test="position() =1 and
                                ($ParentNode/sxml:TYPE = 'PERMANENT' or
                                $ParentNode/sxml:TYPE ='UNDO')">
      <xsl:call-template name="CommonNotAlterable">
       <xsl:with-param name="XpathNode" select="."/>
       <xsl:with-param name="NameNode" select="./sxml:NAME"/>
       <xsl:with-param name="Reason">DROP_FIRST_DATAFILE</xsl:with-param>
       <xsl:with-param name="Message" select="$MSG_DROP_FIRST_DATAFILE"/>
      </xsl:call-template>
     </xsl:when>
     <xsl:otherwise>
      <xsl:element name="ALTER_LIST_ITEM">
       <xsl:call-template name="DropDatafile">
        <xsl:with-param name="ParentNode" select="$ParentNode"/>
        <xsl:with-param name="FileNode" select="."/>
        <xsl:with-param name="Action">PARSE</xsl:with-param>
       </xsl:call-template>
       <xsl:call-template name="DropDatafile">
        <xsl:with-param name="ParentNode" select="$ParentNode"/>
        <xsl:with-param name="FileNode" select="."/>
        <xsl:with-param name="Action">SQL</xsl:with-param>
       </xsl:call-template>
      </xsl:element>
     </xsl:otherwise>
    </xsl:choose>
   </xsl:if>
  </xsl:for-each>
 </xsl:template>
 <xsl:template name="DropDatafile">
  <xsl:param name="ParentNode" select="''"/>
  <xsl:param name="FileNode" select="''"/>
  <xsl:param name="Action" select="''"/>
  <!-- *******************************************************************
Template: DropDatafile
Parameters:
 ParentNode - TABLESPACE node
 FileNode- <DATAFILE_LIST_ITEM>
Action - 'PARSE' or 'SQL'
******************************************************************** -->
  <xsl:choose>
   <xsl:when test="$Action='PARSE' and ($PRS_NAME=1 or 
                                        $PRS_CLAUSE_TYPE=1 or
                                        $PRS_XPATH=1)">
    <xsl:element name="PARSE_LIST">
     <xsl:call-template name="AddXPathParseItem">
      <xsl:with-param name="Node" select="$FileNode"/>
     </xsl:call-template>
     <xsl:call-template name="AddParseItem">
      <xsl:with-param name="ParseIt" select="$PRS_NAME"/>
      <xsl:with-param name="Item">NAME</xsl:with-param>
      <xsl:with-param name="Value1" select="sxml:NAME"/>
     </xsl:call-template>
     <xsl:call-template name="AddParseItem">
      <xsl:with-param name="ParseIt" select="$PRS_CLAUSE_TYPE"/>
      <xsl:with-param name="Item">CLAUSE_TYPE</xsl:with-param>
      <xsl:with-param name="Value1">DROP_DATAFILE</xsl:with-param>
     </xsl:call-template>
    </xsl:element>
   </xsl:when>
   <xsl:when test="$Action='SQL'">
    <xsl:element name="SQL_LIST">
     <xsl:element name="SQL_LIST_ITEM">
      <xsl:element name="TEXT">
       <xsl:text>ALTER TABLESPACE </xsl:text>
       <xsl:call-template name="SchemaName">
        <xsl:with-param name="ParentNode" select="$ParentNode"/>
       </xsl:call-template>
       <xsl:text> DROP </xsl:text>
       <xsl:choose>
        <xsl:when test="$ParentNode/sxml:TYPE='TEMPORARY'">TEMPFILE </xsl:when>
        <xsl:otherwise>DATAFILE </xsl:otherwise>
       </xsl:choose>
       <xsl:if test="$FileNode/sxml:NAME">
        <xsl:text>'</xsl:text>
        <xsl:value-of select="$FileNode/sxml:NAME"/>
        <xsl:text>' </xsl:text>
       </xsl:if>
      </xsl:element>
     </xsl:element>
    </xsl:element>
   </xsl:when>
  </xsl:choose>
 </xsl:template>
 <xsl:template name="AddDatafiles">
  <xsl:param name="ParentNode" select="''"/>
  <xsl:param name="DatafileList" select="''"/>
  <!-- *******************************************************************
Template: AddDatafiles
Parameters:
 ParentNode - TABLESPACE node
 DatafileList - <DATAFILE_LIST>
******************************************************************** -->
  <xsl:for-each select="$DatafileList/sxml:DATAFILE_LIST_ITEM[@src='2']">
   <xsl:element name="ALTER_LIST_ITEM">
    <xsl:call-template name="AddDatafile">
     <xsl:with-param name="ParentNode" select="$ParentNode"/>
     <xsl:with-param name="FileNode" select="."/>
     <xsl:with-param name="Action">PARSE</xsl:with-param>
    </xsl:call-template>
    <xsl:call-template name="AddDatafile">
     <xsl:with-param name="ParentNode" select="$ParentNode"/>
     <xsl:with-param name="FileNode" select="."/>
     <xsl:with-param name="Action">SQL</xsl:with-param>
    </xsl:call-template>
   </xsl:element>
  </xsl:for-each>
 </xsl:template>
 <xsl:template name="AddDatafile">
  <xsl:param name="ParentNode" select="''"/>
  <xsl:param name="FileNode" select="''"/>
  <xsl:param name="Action" select="''"/>
  <!-- *******************************************************************
Template: AddDatafile
Parameters:
 ParentNode - TABLESPACE node
 FileNode- <DATAFILE_LIST_ITEM>
Action - 'PARSE' or 'SQL'
******************************************************************** -->
  <xsl:choose>
   <xsl:when test="$Action='PARSE' and ($PRS_NAME=1 or 
                                        $PRS_CLAUSE_TYPE=1 or
                                        $PRS_XPATH=1)">
    <xsl:element name="PARSE_LIST">
     <xsl:call-template name="AddXPathParseItem">
      <xsl:with-param name="Node" select="$FileNode"/>
     </xsl:call-template>
     <xsl:call-template name="AddParseItem">
      <xsl:with-param name="ParseIt" select="$PRS_NAME"/>
      <xsl:with-param name="Item">NAME</xsl:with-param>
      <xsl:with-param name="Value1" select="sxml:NAME"/>
     </xsl:call-template>
     <xsl:call-template name="AddParseItem">
      <xsl:with-param name="ParseIt" select="$PRS_CLAUSE_TYPE"/>
      <xsl:with-param name="Item">CLAUSE_TYPE</xsl:with-param>
      <xsl:with-param name="Value1">ADD_DATAFILE</xsl:with-param>
     </xsl:call-template>
    </xsl:element>
   </xsl:when>
   <xsl:when test="$Action='SQL'">
    <xsl:element name="SQL_LIST">
     <xsl:element name="SQL_LIST_ITEM">
      <xsl:element name="TEXT">
       <xsl:text>ALTER TABLESPACE </xsl:text>
       <xsl:call-template name="SchemaName">
        <xsl:with-param name="ParentNode" select="$ParentNode"/>
       </xsl:call-template>
       <xsl:text> ADD </xsl:text>
       <xsl:choose>
        <xsl:when test="$ParentNode/sxml:TYPE='TEMPORARY'">TEMPFILE </xsl:when>
        <xsl:otherwise>DATAFILE </xsl:otherwise>
       </xsl:choose>
       <xsl:if test="$FileNode/sxml:NAME">
        <xsl:text>'</xsl:text>
        <xsl:value-of select="$FileNode/sxml:NAME"/>
        <xsl:text>' </xsl:text>
       </xsl:if>
       <xsl:text>SIZE </xsl:text>
       <xsl:value-of select="$FileNode/sxml:SIZE"/>
       <xsl:if test="$FileNode/sxml:AUTOEXTEND">
        <xsl:text> AUTOEXTEND ON</xsl:text>
        <xsl:text> NEXT </xsl:text>
        <xsl:value-of select="$FileNode/sxml:AUTOEXTEND/sxml:NEXT"/>
        <xsl:text> MAXSIZE </xsl:text>
        <xsl:value-of select="$FileNode/sxml:AUTOEXTEND/sxml:MAXSIZE"/>
       </xsl:if>
      </xsl:element>
     </xsl:element>
    </xsl:element>
   </xsl:when>
  </xsl:choose>
 </xsl:template>
 <xsl:template name="AlterDatafiles">
  <xsl:param name="ParentNode" select="''"/>
  <xsl:param name="DatafileList" select="''"/>
  <!-- *******************************************************************
Template: AlterDatafiles
Parameters:
 ParentNode - TABLESPACE node
 DatafileList - <DATAFILE_LIST>
******************************************************************** -->
  <xsl:for-each select="$DatafileList/sxml:DATAFILE_LIST_ITEM">
   <xsl:if test="$DatafileList/sxml:DATAFILE_LIST_ITEM/sxml:SIZE[@value1]">
    <xsl:variable name="newSize" select="./sxml:SIZE"/>
    <xsl:variable name="oldSize" select="./sxml:SIZE/@value1"/>
    <xsl:choose>
     <xsl:when test="$ParentNode//sxml:BIGFILE and
                         ($newSize > $oldSize)">
      <xsl:element name="ALTER_LIST_ITEM">
       <xsl:call-template name="ResizeBigfile">
        <xsl:with-param name="ParentNode" select="$ParentNode"/>
        <xsl:with-param name="SizeNode" select="./sxml:SIZE"/>
        <xsl:with-param name="Action">PARSE</xsl:with-param>
       </xsl:call-template>
       <xsl:call-template name="ResizeBigfile">
        <xsl:with-param name="ParentNode" select="$ParentNode"/>
        <xsl:with-param name="SizeNode" select="./sxml:SIZE"/>
        <xsl:with-param name="Action">SQL</xsl:with-param>
       </xsl:call-template>
      </xsl:element>
     </xsl:when>
     <xsl:otherwise>
      <!-- Resize small datafiles is not supported -->
      <xsl:call-template name="CommonNotAlterable">
       <xsl:with-param name="XpathNode" select="sxml:SIZE"/>
       <xsl:with-param name="NameNode" select="$ParentNode/sxml:NAME"/>
       <xsl:with-param name="Reason">RESIZE_DATAFILE</xsl:with-param>
       <xsl:with-param name="Message" select="$MSG_RESIZE_DATAFILE"/>
      </xsl:call-template>
     </xsl:otherwise>
    </xsl:choose>
   </xsl:if>
   <xsl:if test="sxml:AUTOEXTEND//@value1">
    <xsl:element name="ALTER_LIST_ITEM">
     <xsl:call-template name="AlterAutoextend">
      <xsl:with-param name="ParentNode" select="$ParentNode"/>
      <xsl:with-param name="AutoExtNode" select="./sxml:AUTOEXTEND"/>
      <xsl:with-param name="Action">PARSE</xsl:with-param>
     </xsl:call-template>
     <xsl:call-template name="AlterAutoextend">
      <xsl:with-param name="ParentNode" select="$ParentNode"/>
      <xsl:with-param name="AutoExtNode" select="./sxml:AUTOEXTEND"/>
      <xsl:with-param name="Action">SQL</xsl:with-param>
     </xsl:call-template>
    </xsl:element>
   </xsl:if>
  </xsl:for-each>
 </xsl:template>
 <xsl:template name="ResizeBigfile">
  <xsl:param name="ParentNode" select="''"/>
  <xsl:param name="SizeNode" select="''"/>
  <xsl:param name="Action" select="''"/>
  <!-- *******************************************************************
Template: ResizeBigfile
Parameters:
 ParentNode - TABLESPACE node
SizeNode - SIZE node
Action - PARSE || SQL
******************************************************************** -->
  <xsl:choose>
   <xsl:when test="$Action='PARSE' and ($PRS_NAME=1 or 
                                        $PRS_CLAUSE_TYPE=1 or
                                        $PRS_XPATH=1)">
    <xsl:element name="PARSE_LIST">
     <xsl:call-template name="AddXPathParseItem">
      <xsl:with-param name="Node" select="$ParentNode"/>
     </xsl:call-template>
     <xsl:call-template name="AddParseItem">
      <xsl:with-param name="ParseIt" select="$PRS_NAME"/>
      <xsl:with-param name="Item">NAME</xsl:with-param>
      <xsl:with-param name="Value1" select="sxml:NAME"/>
     </xsl:call-template>
     <xsl:call-template name="AddParseItem">
      <xsl:with-param name="ParseIt" select="$PRS_CLAUSE_TYPE"/>
      <xsl:with-param name="Item">CLAUSE_TYPE</xsl:with-param>
      <xsl:with-param name="Value1">RESIZE_BIGFILE</xsl:with-param>
     </xsl:call-template>
    </xsl:element>
   </xsl:when>
   <xsl:when test="$Action='SQL'">
    <xsl:element name="SQL_LIST">
     <xsl:element name="SQL_LIST_ITEM">
      <xsl:element name="TEXT">
       <xsl:text>ALTER TABLESPACE </xsl:text>
       <xsl:call-template name="SchemaName">
        <xsl:with-param name="ParentNode" select="$ParentNode"/>
       </xsl:call-template>
       <xsl:text> RESIZE </xsl:text>
       <xsl:value-of select="$SizeNode"/>
      </xsl:element>
     </xsl:element>
    </xsl:element>
   </xsl:when>
  </xsl:choose>
 </xsl:template>
 <xsl:template name="AlterAutoextend">
  <xsl:param name="ParentNode" select="''"/>
  <xsl:param name="AutoExtNode" select="''"/>
  <xsl:param name="Action" select="''"/>
  <!-- *******************************************************************
Template: AlterAutoextend
Parameters:
 ParentNode - TABLESPACE node
AutoExtNode - SIZE node
Action - PARSE || SQL
******************************************************************** -->
  <xsl:choose>
   <xsl:when test="$Action='PARSE' and ($PRS_NAME=1 or 
                                        $PRS_CLAUSE_TYPE=1 or
                                        $PRS_XPATH=1)">
    <xsl:element name="PARSE_LIST">
     <xsl:call-template name="AddXPathParseItem">
      <xsl:with-param name="Node" select="$ParentNode"/>
     </xsl:call-template>
     <xsl:call-template name="AddParseItem">
      <xsl:with-param name="ParseIt" select="$PRS_NAME"/>
      <xsl:with-param name="Item">NAME</xsl:with-param>
      <xsl:with-param name="Value1" select="sxml:NAME"/>
     </xsl:call-template>
     <xsl:call-template name="AddParseItem">
      <xsl:with-param name="ParseIt" select="$PRS_CLAUSE_TYPE"/>
      <xsl:with-param name="Item">CLAUSE_TYPE</xsl:with-param>
      <xsl:with-param name="Value1">RESIZE_BIGFILE</xsl:with-param>
     </xsl:call-template>
    </xsl:element>
   </xsl:when>
   <xsl:when test="$Action='SQL'">
    <xsl:element name="SQL_LIST">
     <xsl:element name="SQL_LIST_ITEM">
      <xsl:element name="TEXT">
       <xsl:text>ALTER TABLESPACE </xsl:text>
       <xsl:call-template name="SchemaName">
        <xsl:with-param name="ParentNode" select="$ParentNode"/>
       </xsl:call-template>
       <xsl:text> AUTOEXTEND ON NEXT </xsl:text>
       <xsl:value-of select="$AutoExtNode/sxml:NEXT"/>
       <xsl:text> MAXSIZE </xsl:text>
       <xsl:value-of select="$AutoExtNode/sxml:MAXSIZE"/>
      </xsl:element>
     </xsl:element>
    </xsl:element>
   </xsl:when>
  </xsl:choose>
 </xsl:template>
 <xsl:template name="RenameDatafiles">
  <xsl:param name="ParentNode" select="''"/>
  <xsl:param name="DatafileList" select="''"/>
  <!-- *******************************************************************
Template: RenameDatafiles - not called
Parameters:
 ParentNode - TABLESPACE node
 DatafileList - <DATAFILE_LIST>
******************************************************************** -->
  <xsl:for-each select="$DatafileList/sxml:DATAFILE_LIST_ITEM">
    <xsl:if test="not(./@src) and ./sxml:NAME/@value1">
    <xsl:choose>
     <xsl:when test="$ParentNode/sxml:TYPE ='TEMPORARY'">
      <xsl:call-template name="CommonNotAlterable">
       <xsl:with-param name="XpathNode" select="./sxml:NAME"/>
       <xsl:with-param name="NameNode" select="./sxml:NAME/@value1"/>
       <xsl:with-param name="Reason">RENAME_DATAFILE</xsl:with-param>
       <!--xsl:with-param name="Message" select="$MSG_RENAME_DATAFILE"/-->
      </xsl:call-template>
     </xsl:when>
     <xsl:otherwise>
      <xsl:element name="ALTER_LIST_ITEM">
       <xsl:call-template name="RenameDatafile">
        <xsl:with-param name="ParentNode" select="$ParentNode"/>
        <xsl:with-param name="FileNode" select="."/>
        <xsl:with-param name="Action">PARSE</xsl:with-param>
       </xsl:call-template>
       <xsl:call-template name="RenameDatafile">
        <xsl:with-param name="ParentNode" select="$ParentNode"/>
        <xsl:with-param name="FileNode" select="."/>
        <xsl:with-param name="Action">SQL</xsl:with-param>
       </xsl:call-template>
      </xsl:element>
     </xsl:otherwise>
    </xsl:choose>
   </xsl:if>
  </xsl:for-each>
 </xsl:template>
 <xsl:template name="RenameDatafile">
  <xsl:param name="ParentNode" select="''"/>
  <xsl:param name="FileNode" select="''"/>
  <xsl:param name="Action" select="''"/>
  <!-- *******************************************************************
Template: RenameDatafile
Description: Currently this is not called/supported. There are many things
    to considered when renaming datafiles:
    -  tablespace must be offline
    - This clause merely associates the tablespace with the new file rather than the old one.
       This clause does not actually change the name of the operating system file. You must
       change the name of the file through your operating system.
Parameters:
 ParentNode - TABLESPACE node
 FileNode- <DATAFILE_LIST_ITEM>
Action - 'PARSE' or 'SQL'
******************************************************************** -->
  <xsl:choose>
   <xsl:when test="$Action='PARSE' and ($PRS_NAME=1 or 
                                        $PRS_CLAUSE_TYPE=1 or
                                        $PRS_XPATH=1)">
    <xsl:element name="PARSE_LIST">
     <xsl:call-template name="AddXPathParseItem">
      <xsl:with-param name="Node" select="$FileNode"/>
     </xsl:call-template>
     <xsl:call-template name="AddParseItem">
      <xsl:with-param name="ParseIt" select="$PRS_NAME"/>
      <xsl:with-param name="Item">NAME</xsl:with-param>
      <xsl:with-param name="Value1" select="sxml:NAME"/>
     </xsl:call-template>
     <xsl:call-template name="AddParseItem">
      <xsl:with-param name="ParseIt" select="$PRS_CLAUSE_TYPE"/>
      <xsl:with-param name="Item">CLAUSE_TYPE</xsl:with-param>
      <xsl:with-param name="Value1">ALTER_DATAFILE</xsl:with-param>
     </xsl:call-template>
    </xsl:element>
   </xsl:when>
   <xsl:when test="$Action='SQL'">
    <xsl:element name="SQL_LIST">
     <xsl:element name="SQL_LIST_ITEM">
      <xsl:element name="TEXT">
       <xsl:text>ALTER TABLESPACE </xsl:text>
       <xsl:call-template name="SchemaName">
        <xsl:with-param name="ParentNode" select="$ParentNode"/>
       </xsl:call-template>
       <xsl:text> RENAME DATAFILE </xsl:text>
       <xsl:text>'</xsl:text>
       <xsl:value-of select="$FileNode/sxml:NAME/@value1"/>
       <xsl:text>' TO '</xsl:text>
       <xsl:value-of select="$FileNode/sxml:NAME"/>
       <xsl:text>'</xsl:text>
      </xsl:element>
     </xsl:element>
    </xsl:element>
   </xsl:when>
  </xsl:choose>
 </xsl:template>
 <xsl:template name="ResizeTablespace">
  <xsl:param name="ParentNode" select="''"/>
  <xsl:param name="FileNode" select="''"/>
  <xsl:param name="Action" select="''"/>
  <!-- *******************************************************************
Template: ResizeTablespace
Parameters:
 ParentNode - TABLESPACE node
 FileNode- <DATAFILE_LIST_ITEM>
Action - 'PARSE' or 'SQL'
******************************************************************** -->
  <xsl:choose>
   <xsl:when test="$Action='PARSE' and ($PRS_NAME=1 or 
                                        $PRS_CLAUSE_TYPE=1 or
                                        $PRS_XPATH=1)">
    <xsl:element name="PARSE_LIST">
     <xsl:call-template name="AddXPathParseItem">
      <xsl:with-param name="Node" select="$FileNode"/>
     </xsl:call-template>
     <xsl:call-template name="AddParseItem">
      <xsl:with-param name="ParseIt" select="$PRS_NAME"/>
      <xsl:with-param name="Item">NAME</xsl:with-param>
      <xsl:with-param name="Value1" select="sxml:NAME"/>
     </xsl:call-template>
     <xsl:call-template name="AddParseItem">
      <xsl:with-param name="ParseIt" select="$PRS_CLAUSE_TYPE"/>
      <xsl:with-param name="Item">CLAUSE_TYPE</xsl:with-param>
      <xsl:with-param name="Value1">RESIZE_DATAFILE</xsl:with-param>
     </xsl:call-template>
    </xsl:element>
   </xsl:when>
   <xsl:when test="$Action='SQL'">
    <xsl:element name="SQL_LIST">
     <xsl:element name="SQL_LIST_ITEM">
      <xsl:element name="TEXT">
       <xsl:text>ALTER TABLESPACE </xsl:text>
       <xsl:call-template name="SchemaName">
        <xsl:with-param name="ParentNode" select="$ParentNode"/>
       </xsl:call-template>
       <xsl:text>RESIZE </xsl:text>
       <xsl:value-of select="$FileNode/sxml:SIZE"/>
       <xsl:text>'</xsl:text>
      </xsl:element>
     </xsl:element>
    </xsl:element>
   </xsl:when>
  </xsl:choose>
 </xsl:template>
 <xsl:template name="AlterTbspCompress">
  <xsl:param name="ParentNode" select="''"/>
  <xsl:param name="DefaultNode" select="''"/>
  <!-- *******************************************************************
Template: AlterTbspCompress
Parameters:
 ParentNode - TABLESPACE node
 DefaultNode - Parent of COMPRESS
******************************************************************** -->
  <xsl:if test="$DefaultNode/sxml:COMPRESS[@value1]">
   <xsl:element name="ALTER_LIST_ITEM">
    <xsl:if test="$PRS_NAME=1 or 
                  $PRS_CLAUSE_TYPE=1 or
                  $PRS_XPATH=1">
     <xsl:element name="PARSE_LIST">
      <xsl:call-template name="AddXPathParseItem">
       <xsl:with-param name="Node" select="$ParentNode"/>
      </xsl:call-template>
      <xsl:call-template name="AddParseItem">
       <xsl:with-param name="ParseIt" select="$PRS_NAME"/>
       <xsl:with-param name="Item">NAME</xsl:with-param>
       <xsl:with-param name="Value1" select="$ParentNode/sxml:NAME"/>
      </xsl:call-template>
      <xsl:call-template name="AddParseItem">
       <xsl:with-param name="ParseIt" select="$PRS_CLAUSE_TYPE"/>
       <xsl:with-param name="Item">CLAUSE_TYPE</xsl:with-param>
       <xsl:with-param name="Value1">DEFAULT_COMPRESSION</xsl:with-param>
      </xsl:call-template>
     </xsl:element>
    </xsl:if>
    <xsl:element name="SQL_LIST">
     <xsl:element name="SQL_LIST_ITEM">
      <xsl:element name="TEXT">
       <xsl:text>ALTER TABLESPACE </xsl:text>
       <xsl:call-template name="SchemaName">
        <xsl:with-param name="ParentNode" select="$ParentNode"/>
       </xsl:call-template>
       <xsl:text> DEFAULT </xsl:text>
       <xsl:if test="$DefaultNode/sxml:COMPRESS/@value1">
        <xsl:choose>
         <xsl:when test="$DefaultNode/sxml:COMPRESS = 'N'">
          <xsl:text>NOCOMPRESS</xsl:text>
         </xsl:when>
         <xsl:when test="$DefaultNode/sxml:COMPRESS = 'OLTP'">
          <xsl:text>COMPRESS FOR OLTP </xsl:text>
         </xsl:when>
         <xsl:when test="$DefaultNode/sxml:COMPRESS = 'BASIC' and
                                    $DefaultNode/sxml:COMPRESS/@value1">
          <xsl:text>COMPRESS BASIC </xsl:text>
         </xsl:when>
         <xsl:otherwise>
          <xsl:text>COMPRESS FOR </xsl:text>
          <xsl:value-of select="$DefaultNode/sxml:COMPRESS"/>
          <xsl:if test="not($DefaultNode/sxml:COMPRESS='BASIC')">
           <xsl:choose>
            <xsl:when test="$DefaultNode/sxml:COMPRESS_LEVEL = 'HIGH' or
                          not($DefaultNode/sxml:COMPRESS_LEVEL)">
             <xsl:text> HIGH</xsl:text>
            </xsl:when>
            <xsl:otherwise>
             <xsl:text> LOW</xsl:text>
            </xsl:otherwise>
           </xsl:choose>
          </xsl:if>
         </xsl:otherwise>
        </xsl:choose>
       </xsl:if>
      </xsl:element>
     </xsl:element>
    </xsl:element>
   </xsl:element>
  </xsl:if>
 </xsl:template>
 <xsl:template name="RenTablespace">
  <xsl:param name="ParentNode" select="''"/>
  <!-- *******************************************************************
Template: RenTablespace
Parameters:
 ParentNode - Parent node of SCHEMA, NAME
******************************************************************** -->
  <xsl:if test="$ParentNode/sxml:NAME[@value1]">
   <xsl:element name="ALTER_LIST_ITEM">
    <xsl:if test="$PRS_NAME=1 or 
                  $PRS_CLAUSE_TYPE=1 or
                  $PRS_XPATH=1">
     <xsl:element name="PARSE_LIST">
      <xsl:call-template name="AddXPathParseItem">
       <xsl:with-param name="Node" select="$ParentNode"/>
      </xsl:call-template>
      <xsl:call-template name="AddParseItem">
       <xsl:with-param name="ParseIt" select="$PRS_NAME"/>
       <xsl:with-param name="Item">NAME</xsl:with-param>
       <xsl:with-param name="Value1" select="$ParentNode/sxml:NAME/@value1"/>
      </xsl:call-template>
      <xsl:call-template name="AddParseItem">
       <xsl:with-param name="ParseIt" select="$PRS_CLAUSE_TYPE"/>
       <xsl:with-param name="Item">CLAUSE_TYPE</xsl:with-param>
       <xsl:with-param name="Value1">RENAME_TABLESPACE</xsl:with-param>
      </xsl:call-template>
     </xsl:element>
    </xsl:if>
    <xsl:element name="SQL_LIST">
     <xsl:element name="SQL_LIST_ITEM">
      <xsl:element name="TEXT">
       <xsl:text>ALTER TABLESPACE </xsl:text>
       <xsl:call-template name="SchemaName">
        <xsl:with-param name="ParentNode" select="$ParentNode"/>
       </xsl:call-template>
       <xsl:text> RENAME TO </xsl:text>
       <xsl:call-template name="QuotedName">
        <xsl:with-param name="NameNode" select="sxml:NAME"/>
       </xsl:call-template>
      </xsl:element>
     </xsl:element>
    </xsl:element>
   </xsl:element>
  </xsl:if>
 </xsl:template>
 <xsl:template name="AlterTablespaceGroup">
  <xsl:param name="ParentNode" select="''"/>
  <xsl:param name="Action" select="''"/>
  <!-- *******************************************************************
Template: AlterTablespaceGroup
Description: The only thing we can alter here is ALLOCATION_TYPE.
Parameters:
 ParentNode - TABLESPACE node
 Action - "PARSE" or "SQL"
******************************************************************** -->
  <xsl:choose>
   <xsl:when test="$Action='PARSE' and ($PRS_NAME=1 or 
                  $PRS_CLAUSE_TYPE=1 or
                  $PRS_XPATH=1)">
    <xsl:element name="PARSE_LIST">
     <xsl:call-template name="AddParseItem">
      <xsl:with-param name="ParseIt" select="$PRS_CLAUSE_TYPE"/>
      <xsl:with-param name="Item">CLAUSE_TYPE</xsl:with-param>
      <xsl:with-param name="Value1">TABLESPACE_GROUP</xsl:with-param>
     </xsl:call-template>
    </xsl:element>
   </xsl:when>
   <xsl:when test="$Action='SQL'">
    <xsl:element name="SQL_LIST">
     <xsl:element name="SQL_LIST_ITEM">
      <xsl:element name="TEXT">
       <xsl:text>ALTER TABLESPACE  </xsl:text>
       <xsl:call-template name="SchemaName">
        <xsl:with-param name="ParentNode" select="$ParentNode"/>
       </xsl:call-template>
       <xsl:text> TABLESPACE GROUP </xsl:text>
       <xsl:choose>
        <xsl:when test="$ParentNode/sxml:TABLESPACE_GROUP/@src='1'">
         <xsl:text> ''</xsl:text>
        </xsl:when>
        <xsl:otherwise>
         <xsl:value-of select="sxml:TABLESPACE_GROUP"/>
        </xsl:otherwise>
       </xsl:choose>
      </xsl:element>
     </xsl:element>
    </xsl:element>
   </xsl:when>
  </xsl:choose>
 </xsl:template>
 <xsl:template name="AlterSegSpace">
  <xsl:param name="ParentNode" select="''"/>
  <xsl:param name="SegSpaceNode" select="''"/>
  <!-- *******************************************************************
Template: AlterSegSpace - can not be altered
Parameters:
 ParentNode - TABLESPACE node
 SegSpaceNode - <SEGMENT_SPACE_MANAGEMENT>
******************************************************************** -->
  <xsl:call-template name="CommonNotAlterable">
   <xsl:with-param name="XpathNode" select="$SegSpaceNode"/>
   <xsl:with-param name="NameNode" select="$ParentNode/sxml:NAME"/>
   <xsl:with-param name="Reason">SEGMENT_SPACE_MANAGEMENT</xsl:with-param>
   <xsl:with-param name="Message" select="$MSG_SEGMENT_SPACE_MANAGEMENT"/>
  </xsl:call-template>
 </xsl:template>
</xsl:stylesheet>
