<?xml version="1.0"?>
<!--

 Copyright (c) 2006, 2010, Oracle and/or its affiliates. All rights reserved. 

NAME
    kuatprop.xsl
DESCRIPTION
    Convert table property diffs in sxml TABLE diff document
     to ALTER_XML document

MODIFIED        MM/DD/YY
    rapayne   02/18/09 - (bvaranas)bug-8911160: In version 11.2.0.2 alter table move
                                    no longer creates segments. Therefore we need to explicitly
                                    allocate an extent to compensate for this new behavior.
    lbarton     11/13/09 - bug 8796742: translatable error messages
    lbarton     09/21/09 - bug 8820324: support all values in deferred_stg
    lbarton     07/20/09 - bug 8494344: archive compression
    adalee      04/16/09 - add FLASH_CACHE and CELL_FLASH_CACHE
    lbarton     09/15/08 - move LRG param declaration after imports
    lbarton     07/10/08 - bug 5709159: SQL_LIST_ITEM subelements
    htseng      07/18/08 - add sleep between to alter flashback archive
                           statement (lrg 3403596)
    rapayne     02/27/08 - Fix NOT_ALTERABLE catches for storage/initial and
                                        and storage/minextents.
                         - Fix check for storage/sxml:freelist and storage/sxml:initial
    rapayne     06/19/07 - Fix alter parallel support.
    lbarton     02/29/08 - flashback archive
    lbarton     01/18/08 - Bug 6724820: table compression
    lbarton     03/19/08 - deferred segment creation
    lbarton     12/29/06 - 
    rapayne     12/20/06 - import kuacomm.xsl
    htseng      12/14/06 - mview support
    htseng      12/12/06 - make alter parallel_clause,Cache callable
    lbarton     11/30/06 - bugfix
    htseng      11/06/06 - move partitions to kuatpar.xsl
    htseng      10/20/06 - more work
    htseng      10/11/06 - add PARSE_LIST
    htseng      10/04/06 - AlterPhysicalAttributes
    htseng      09/29/06 - condition STORAGE tag 
    lbarton     09/22/05 - Initial version
 -->
<xsl:stylesheet version="1.0" xmlns:sxml="http://xmlns.oracle.com/ku" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
 <!-- Top level imports -->
 <xsl:import href="kuacomm.xsl"/>
 <!-- Top-level parameters -->
 <xsl:param name="LRG">0</xsl:param>
 <!-- Templates -->
 <xsl:template name="AlterTableProperties">
  <xsl:param name="ParentNode" select="''"/>
  <!-- *******************************************************************
Template: AlterTableProperties
Parameters:
 ParentNode - Parent node of SCHEMA, NAME
******************************************************************** -->
  <!-- table organization: heap vs. IOT vs. external vs. cluster -->
  <xsl:call-template name="TableOrganization">
   <xsl:with-param name="ParentNode" select="$ParentNode"/>
   <xsl:with-param name="PhysicalPropertiesNode" select="$ParentNode/sxml:RELATIONAL_TABLE/sxml:PHYSICAL_PROPERTIES | $ParentNode/sxml:OBJECT_TABLE/sxml:PHYSICAL_PROPERTIES | $ParentNode/sxml:XMLTYPE_TABLE/sxml:PHYSICAL_PROPERTIES"/>
  </xsl:call-template>
  <!-- Physical_Attributes, logging_clause , table_compression -->
  <xsl:call-template name="AlterTabProperties">
   <xsl:with-param name="TableNode" select="$ParentNode"/>
   <xsl:with-param name="Partitioning">N</xsl:with-param>
   <xsl:with-param name="ParentNode" select="$ParentNode/sxml:RELATIONAL_TABLE/sxml:PHYSICAL_PROPERTIES/sxml:HEAP_TABLE"/>
  </xsl:call-template>
  <xsl:call-template name="AlterTabProperties">
   <xsl:with-param name="TableNode" select="$ParentNode"/>
   <xsl:with-param name="ParentNode" select=" $ParentNode/sxml:RELATIONAL_TABLE/sxml:TABLE_PROPERTIES/sxml:RANGE_PARTITIONING/sxml:DEFAULT_PHYSICAL_PROPERTIES/sxml:HEAP_TABLE |
$ParentNode/sxml:RELATIONAL_TABLE/sxml:TABLE_PROPERTIES/sxml:HASH_PARTITIONING/sxml:DEFAULT_PHYSICAL_PROPERTIES/sxml:HEAP_TABLE |
$ParentNode/sxml:RELATIONAL_TABLE/sxml:TABLE_PROPERTIES/sxml:LIST_PARTITIONING/sxml:DEFAULT_PHYSICAL_PROPERTIES/sxml:HEAP_TABLE"/>
  </xsl:call-template>
  <!-- Row Movement, Parallel, Cache  -->
  <xsl:call-template name="AlterMiscProperties">
   <xsl:with-param name="ObjectNode" select="$ParentNode"/>
   <xsl:with-param name="PropertyNode" select="$ParentNode/sxml:RELATIONAL_TABLE/sxml:TABLE_PROPERTIES"/>
  </xsl:call-template>
  <!-- flashback archive -->
  <xsl:call-template name="AlterFlashbackArchive">
   <xsl:with-param name="TableNode" select="$ParentNode"/>
   <xsl:with-param name="ParentNode" select="$ParentNode/sxml:RELATIONAL_TABLE/sxml:TABLE_PROPERTIES"/>
  </xsl:call-template>
  <!-- alter_iot_clauses -->
  <xsl:call-template name="AlterIOT">
   <xsl:with-param name="TableNode" select="$ParentNode"/>
   <xsl:with-param name="ParentNode" select="$ParentNode/sxml:RELATIONAL_TABLE"/>
  </xsl:call-template>
  <!-- Supplemental_table_clause -->
  <xsl:call-template name="AlterSupplemental">
   <xsl:with-param name="ParentNode" select="$ParentNode"/>
  </xsl:call-template>
  <!-- allocate_extent_clause -->
  <!-- deallocate_unused_clause -->
 </xsl:template>
 <xsl:template name="TableOrganization">
  <xsl:param name="ParentNode" select="''"/>
  <xsl:param name="PhysicalPropertiesNode" select="''"/>
  <!-- *******************************************************************
Template: TableOrganization - detects non-alterable case:
  can't interconvert between table organizations (heap, IOT, external, cluster)
Parameters:
 ParentNode - Parent node of SCHEMA, NAME
 PhysicalPropertiesNode - PHYSICAL_PROPERTIES
******************************************************************** -->
  <xsl:if test="$PhysicalPropertiesNode/sxml:HEAP_TABLE[@src] or
                $PhysicalPropertiesNode/sxml:INDEX_ORGANIZED_TABLE[@src] or
                $PhysicalPropertiesNode/sxml:EXTERNAL_TABLE[@src] or
                $PhysicalPropertiesNode/sxml:CLUSTER_TABLE[@src]">
   <xsl:call-template name="CommonNotAlterable">
    <xsl:with-param name="XpathNode" select="$PhysicalPropertiesNode"/>
    <xsl:with-param name="NameNode" select="./sxml:NAME"/>
    <xsl:with-param name="Reason">TABLE_ORGANIZATION</xsl:with-param>
    <xsl:with-param name="Message" select="$MSG_TABLE_ORGANIZATION"/>
   </xsl:call-template>
  </xsl:if>
 </xsl:template>
 <xsl:template name="AlterTabProperties">
  <xsl:param name="TableNode" select="''"/>
  <xsl:param name="ParentNode" select="''"/>
  <xsl:param name="Partition" select="''"/>
  <!-- *******************************************************************
Template: AlterTabProperties
Parameters:
 ParentNode - Parent node of SCHEMA, NAME
******************************************************************** -->
  <!-- NOT_ALTERABLE properties -->
  <xsl:call-template name="NotAlterableTabPhysical">
   <xsl:with-param name="TableNode" select="$TableNode"/>
   <xsl:with-param name="ParentNode" select="$ParentNode"/>
   <xsl:with-param name="Action">PARSE</xsl:with-param>
  </xsl:call-template>
  <!-- process SEGMENT_CREATION diff - can only be altered to IMMEDIATE-->
  <xsl:if test="$ParentNode/sxml:SEGMENT_ATTRIBUTES/sxml:SEGMENT_CREATION_DEFERRED/@src='1'">
   <xsl:element name="ALTER_LIST_ITEM">
    <xsl:call-template name="AlterDeferredSegment">
     <xsl:with-param name="TableNode" select="$TableNode"/>
     <xsl:with-param name="ParentNode" select="$ParentNode"/>
     <xsl:with-param name="Action">PARSE</xsl:with-param>
    </xsl:call-template>
    <xsl:call-template name="AlterDeferredSegment">
     <xsl:with-param name="TableNode" select="$TableNode"/>
     <xsl:with-param name="ParentNode" select="$ParentNode"/>
     <xsl:with-param name="Action">SQL</xsl:with-param>
    </xsl:call-template>
   </xsl:element>
  </xsl:if>
  <!-- alterable properties -->
  <xsl:if test="$ParentNode/sxml:SEGMENT_ATTRIBUTES/sxml:PCTFREE/@value1 or
                $ParentNode/sxml:SEGMENT_ATTRIBUTES/sxml:INITRANS/@value1 or
                $ParentNode/sxml:SEGMENT_ATTRIBUTES/sxml:PCTUSED/@value1 or
                $ParentNode/sxml:SEGMENT_ATTRIBUTES/sxml:STORAGE/sxml:NEXT/@value1 or
                $ParentNode/sxml:SEGMENT_ATTRIBUTES/sxml:STORAGE/sxml:MAXEXTENTS/@value1 or
                $ParentNode/sxml:SEGMENT_ATTRIBUTES/sxml:STORAGE/sxml:PCTINCREASE/@value1 or
                $ParentNode/sxml:SEGMENT_ATTRIBUTES/sxml:STORAGE/sxml:FREELISTS/@value1 or
                $ParentNode/sxml:SEGMENT_ATTRIBUTES/sxml:STORAGE/sxml:FREELIST_GROUP/@value1 or
                $ParentNode/sxml:SEGMENT_ATTRIBUTES/sxml:STORAGE/sxml:BUFFER_POOL/@value1 or
                $ParentNode/sxml:SEGMENT_ATTRIBUTES/sxml:STORAGE/sxml:FLASH_CACHE/@value1 or
                $ParentNode/sxml:SEGMENT_ATTRIBUTES/sxml:STORAGE/sxml:CELL_FLASH_CACHE/@value1 or
                ($Partition='N' and $ParentNode/sxml:SEGMENT_ATTRIBUTES/sxml:TABLESPACE/@value1) or
                $ParentNode/sxml:SEGMENT_ATTRIBUTES/sxml:LOGGING/@value1 or
                $ParentNode/sxml:COMPRESS/@value1 or
                $ParentNode/sxml:COMPRESS/@src!='1' or
                $ParentNode/sxml:COMPRESS_LEVEL/@src">
   <xsl:element name="ALTER_LIST_ITEM">
    <xsl:call-template name="AlterTabPhysical">
     <xsl:with-param name="TableNode" select="$TableNode"/>
     <xsl:with-param name="ParentNode" select="$ParentNode"/>
     <xsl:with-param name="Action">PARSE</xsl:with-param>
    </xsl:call-template>
    <xsl:call-template name="AlterTabPhysical">
     <xsl:with-param name="TableNode" select="$TableNode"/>
     <xsl:with-param name="ParentNode" select="$ParentNode"/>
     <xsl:with-param name="Action">SQL</xsl:with-param>
    </xsl:call-template>
   </xsl:element>
  </xsl:if>
 </xsl:template>
 <xsl:template name="NotAlterableTabPhysical">
  <xsl:param name="TableNode" select="''"/>
  <xsl:param name="ParentNode" select="''"/>
  <!-- *******************************************************************
Template: NotAlterableTabPhysical
Parameters:
 ParentNode - Parent node of SCHEMA, NAME
******************************************************************** -->
  <xsl:if test="$ParentNode/sxml:SEGMENT_ATTRIBUTES/sxml:STORAGE/sxml:FREELIST_GROUPS/@value1">
   <xsl:call-template name="CommonNotAlterable">
    <xsl:with-param name="XpathNode" select="$ParentNode/sxml:SEGMENT_ATTRIBUTES/sxml:STORAGE/sxml:FREELIST_GROUPS"/>
    <xsl:with-param name="NameNode" select="$ParentNode/sxml:NAME"/>
    <xsl:with-param name="Reason">FREELIST_GROUPS</xsl:with-param>
    <xsl:with-param name="Message" select="$MSG_FREELIST_GROUPS"/>
   </xsl:call-template>
  </xsl:if>
  <xsl:if test="$ParentNode/sxml:SEGMENT_ATTRIBUTES/sxml:STORAGE/sxml:INITIAL/@value1">
   <xsl:call-template name="CommonNotAlterable">
    <xsl:with-param name="XpathNode" select="$ParentNode/sxml:SEGMENT_ATTRIBUTES/sxml:STORAGE/sxml:INITIAL"/>
    <xsl:with-param name="NameNode" select="$ParentNode/sxml:NAME"/>
    <xsl:with-param name="Reason">INITIAL</xsl:with-param>
    <xsl:with-param name="Message" select="$MSG_INITIAL"/>
   </xsl:call-template>
  </xsl:if>
  <xsl:if test="$ParentNode/sxml:SEGMENT_ATTRIBUTES/sxml:STORAGE/sxml:MINEXTENTS/@value1">
   <xsl:call-template name="CommonNotAlterable">
    <xsl:with-param name="XpathNode" select="$ParentNode/sxml:SEGMENT_ATTRIBUTES/sxml:STORAGE/sxml:MINEXTENTS"/>
    <xsl:with-param name="NameNode" select="$ParentNode/sxml:NAME"/>
    <xsl:with-param name="Reason">MINEXTENTS</xsl:with-param>
    <xsl:with-param name="Message" select="$MSG_MINEXTENTS"/>
   </xsl:call-template>
  </xsl:if>
  <xsl:if test="$ParentNode/sxml:SEGMENT_ATTRIBUTES/sxml:SEGMENT_CREATION_DEFERRED/@src='2'">
   <xsl:call-template name="CommonNotAlterable">
    <xsl:with-param name="XpathNode" select="$ParentNode/sxml:SEGMENT_ATTRIBUTES/sxml:SEGMENT_CREATION_DEFERRED"/>
    <xsl:with-param name="NameNode" select="$ParentNode/sxml:NAME"/>
    <xsl:with-param name="Reason">SEGMENT_CREATION_DEFERRED</xsl:with-param>
    <xsl:with-param name="Message" select="$MSG_SEGMENT_CREATION_DEFERRED"/>
   </xsl:call-template>
  </xsl:if>
 </xsl:template>
 <xsl:template name="AlterTabPhysical">
  <xsl:param name="TableNode" select="''"/>
  <xsl:param name="ParentNode" select="''"/>
  <xsl:param name="Action" select="''"/>
  <!-- *******************************************************************
Template: AlterTabPhysical
Parameters:
 ParentNode - Parent node of SCHEMA, NAME
******************************************************************** -->
  <xsl:choose>
   <xsl:when test="$Action='PARSE' and ($PRS_NAME=1 or 
                                        $PRS_CLAUSE_TYPE=1 or
                                        $PRS_COLUMN_ATTRIBUTE=1 or
                                        $PRS_ALTERABLE=1 or
                                        $PRS_XPATH=1)">
    <xsl:element name="PARSE_LIST">
     <xsl:call-template name="AddXPathParseItem">
      <xsl:with-param name="Node" select="$ParentNode"/>
     </xsl:call-template>
     <xsl:call-template name="AddParseItem">
      <xsl:with-param name="ParseIt" select="$PRS_NAME"/>
      <xsl:with-param name="Item">NAME</xsl:with-param>
      <xsl:with-param name="Value1" select="sxml:NAME"/>
     </xsl:call-template>
     <xsl:call-template name="AddParseItem">
      <xsl:with-param name="ParseIt" select="$PRS_CLAUSE_TYPE"/>
      <xsl:with-param name="Item">CLAUSE_TYPE</xsl:with-param>
      <xsl:with-param name="Value1">PHYSICAL_ATTRIBUTES</xsl:with-param>
     </xsl:call-template>
    </xsl:element>
   </xsl:when>
   <xsl:when test="$Action='SQL'">
    <xsl:element name="SQL_LIST">
     <!-- Physical_Attributes -->
     <xsl:element name="SQL_LIST_ITEM">
      <xsl:element name="TEXT">
       <xsl:text>ALTER TABLE </xsl:text>
       <xsl:call-template name="SchemaName">
        <xsl:with-param name="ParentNode" select="$TableNode"/>
       </xsl:call-template>
       <!-- Physical_Attributes -->
       <xsl:call-template name="AlterPhysicalAttributes">
        <xsl:with-param name="ParentNode" select="$ParentNode/sxml:SEGMENT_ATTRIBUTES"/>
       </xsl:call-template>
       <!-- logging_clause -->
       <xsl:call-template name="AlterLogging">
        <xsl:with-param name="ParentNode" select="$ParentNode/sxml:SEGMENT_ATTRIBUTES"/>
       </xsl:call-template>
       <!-- table_compression -->
       <xsl:call-template name="AlterCompress">
        <xsl:with-param name="ParentNode" select="$ParentNode"/>
       </xsl:call-template>
      </xsl:element>
     </xsl:element>
    </xsl:element>
   </xsl:when>
  </xsl:choose>
 </xsl:template>
 <xsl:template name="AlterPhysicalAttributes">
  <xsl:param name="ParentNode" select="''"/>
  <xsl:param name="TypeNode" select="''"/>
  <xsl:param name="ObjType">TABLE</xsl:param>
  <!-- *******************************************************************
Template: AlterPhysicalAttributes - this template is called from several stylesheets:
         kuaclus.xsl, kuacnstr.xsl, kuaindex.xsl, kuamv.xsl, kuavml.xsl, and kuatpar.xsl
Parameters:
 ParentNode - Parent node of SEGMENT_ATTRIBUTES
 TypeNode   - ADD or '' (modify)
 ObjType    - TABLE, INDEX, BITMAP_JOIN_INDEX
******************************************************************** -->
  <!-- Physical_attributes_clause -->
  <xsl:choose>
   <xsl:when test="$TypeNode='ADD'">
    <xsl:if test="$ParentNode/sxml:PCTFREE">
     <xsl:text> PCTFREE </xsl:text>
     <xsl:value-of select="$ParentNode/sxml:PCTFREE"/>
    </xsl:if>
    <xsl:if test="$ParentNode/sxml:PCTUSED">
     <xsl:text> PCTUSED </xsl:text>
     <xsl:value-of select="$ParentNode/sxml:PCTUSED"/>
    </xsl:if>
    <xsl:if test="$ParentNode/sxml:INITRANS">
     <xsl:text> INITRANS </xsl:text>
     <xsl:value-of select="$ParentNode/sxml:INITRANS"/>
    </xsl:if>
   </xsl:when>
   <xsl:otherwise>
    <xsl:if test="$ParentNode/sxml:PCTFREE[@value1] and $ObjType!='INDEX' and $ObjType!='BITMAP_JOIN_INDEX'">
     <xsl:text> PCTFREE </xsl:text>
     <xsl:value-of select="$ParentNode/sxml:PCTFREE"/>
    </xsl:if>
    <xsl:if test="$ParentNode/sxml:PCTUSED[@value1]">
     <xsl:text> PCTUSED </xsl:text>
     <xsl:value-of select="$ParentNode/sxml:PCTUSED"/>
    </xsl:if>
    <xsl:if test="$ParentNode/sxml:INITRANS[@value1] and $ObjType!='BITMAP_JOIN_INDEX'">
     <xsl:text> INITRANS </xsl:text>
     <xsl:value-of select="$ParentNode/sxml:INITRANS"/>
    </xsl:if>
   </xsl:otherwise>
  </xsl:choose>
  <!-- storage_clause -->
  <xsl:if test="$ParentNode/sxml:STORAGE">
   <xsl:call-template name="AlterStorage">
    <xsl:with-param name="ParentNode" select="$ParentNode/sxml:STORAGE"/>
    <xsl:with-param name="TypeNode" select="$TypeNode"/>
   </xsl:call-template>
  </xsl:if>
 </xsl:template>
 <xsl:template name="AlterDeferredSegment">
  <xsl:param name="TableNode" select="''"/>
  <xsl:param name="ParentNode" select="''"/>
  <xsl:param name="ObjType">TABLE</xsl:param>
  <xsl:param name="Action" select="''"/>
  <!-- *******************************************************************
Template: AlterDeferedSegment - This template handles diffs in which segment_creation 
    has been altered to immediate. In version prior to 11.2.0.2 this was accomplished implicitly 
    with an alter table move. However, in later version this behavior change thereby requiring
    us to explicitly allocate a segment.
    note: immediate to deferred is NOT alterable and is handle before this in a common rtn.
Parameters:
 ParentNode - Parent node of SEGMENT_ATTRIBUTES
 ObjType    - TABLE, INDEX, BITMAP_JOIN_INDEX
******************************************************************** -->
  <xsl:choose>
   <xsl:when test="$Action='PARSE' and ($PRS_NAME=1 or 
                                        $PRS_CLAUSE_TYPE=1 or
                                        $PRS_COLUMN_ATTRIBUTE=1 or
                                        $PRS_ALTERABLE=1 or
                                        $PRS_XPATH=1)">
    <xsl:element name="PARSE_LIST">
     <xsl:call-template name="AddXPathParseItem">
      <xsl:with-param name="Node" select="$ParentNode"/>
     </xsl:call-template>
     <xsl:call-template name="AddParseItem">
      <xsl:with-param name="ParseIt" select="$PRS_NAME"/>
      <xsl:with-param name="Item">NAME</xsl:with-param>
      <xsl:with-param name="Value1" select="sxml:NAME"/>
     </xsl:call-template>
     <xsl:call-template name="AddParseItem">
      <xsl:with-param name="ParseIt" select="$PRS_CLAUSE_TYPE"/>
      <xsl:with-param name="Item">CLAUSE_TYPE</xsl:with-param>
      <xsl:with-param name="Value1">DEFERRED_SEGMENTS</xsl:with-param>
     </xsl:call-template>
    </xsl:element>
   </xsl:when>
   <xsl:when test="$Action='SQL'">
    <xsl:element name="SQL_LIST">
     <!-- In versions prior to 11.2.0.2 ALTER TABLE MOVE caused segments to be created.
          However, in 11.2.0.2 the MOVE behavior changed and no longer creates segments
          if the table has deferred segment creation. Therefore, in later versions we need to
          manually ALLOCATE an EXTENT.
    -->
     <xsl:element name="SQL_LIST_ITEM">
      <xsl:element name="TEXT">
       <xsl:text>ALTER TABLE </xsl:text>
       <xsl:call-template name="SchemaName">
        <xsl:with-param name="ParentNode" select="$TableNode"/>
       </xsl:call-template>
       <xsl:choose>
        <xsl:when test="$VERSION>=110200200">
         <xsl:text> ALLOCATE EXTENT</xsl:text>
        </xsl:when>
        <xsl:otherwise>
         <xsl:text> MOVE</xsl:text>
        </xsl:otherwise>
       </xsl:choose>
      </xsl:element>
     </xsl:element>
    </xsl:element>
   </xsl:when>
  </xsl:choose>
 </xsl:template>
 <xsl:template name="AlterStorage">
  <xsl:param name="ParentNode" select="''"/>
  <xsl:param name="TypeNode" select="''"/>
  <!-- *******************************************************************
Template: AlterStorage
Parameters:
 ParentNode - $ParentNode/sxml:RELATIONAL_TABLE/sxml:PHYSICAL_PROPERTIES/sxml:HEAP_TABLE/sxml:SEGMENT_ATTRIBUTES/sxml:STORAGE
 TypeNode   - ADD or '' (modify)
******************************************************************** -->
  <xsl:choose>
   <xsl:when test="$TypeNode='ADD' or $ParentNode//@src='2'">
    <xsl:text> STORAGE (</xsl:text>
    <xsl:if test="$ParentNode/sxml:INITIAL">
     <xsl:text> INITIAL </xsl:text>
     <xsl:value-of select="$ParentNode/sxml:INITIAL"/>
    </xsl:if>
    <xsl:if test="$ParentNode/sxml:NEXT">
     <xsl:text> NEXT </xsl:text>
     <xsl:value-of select="$ParentNode/sxml:NEXT"/>
    </xsl:if>
    <xsl:if test="$ParentNode/sxml:MINEXTENTS">
     <xsl:text> MINEXTENTS </xsl:text>
     <xsl:value-of select="$ParentNode/sxml:MINEXTENTS"/>
    </xsl:if>
    <xsl:if test="$ParentNode/sxml:MAXEXTENTS">
     <xsl:text> MAXEXTENTS </xsl:text>
     <xsl:value-of select="$ParentNode/sxml:MAXEXTENTS"/>
    </xsl:if>
    <xsl:if test="$ParentNode/sxml:PCTINCREASE">
     <xsl:text> PCTINCREASE </xsl:text>
     <xsl:value-of select="$ParentNode/sxml:PCTINCREASE"/>
    </xsl:if>
    <xsl:if test="$ParentNode/sxml:FREELISTS">
     <xsl:text> FREELISTS </xsl:text>
     <xsl:value-of select="$ParentNode/sxml:FREELISTS"/>
    </xsl:if>
    <xsl:if test="$ParentNode/sxml:FREELIST_GROUPS">
     <xsl:text> FREELIST GROUPS </xsl:text>
     <xsl:value-of select="$ParentNode/sxml:FREELIST_GROUPS"/>
    </xsl:if>
    <xsl:if test="$ParentNode/sxml:BUFFER_POOL">
     <xsl:text> BUFFER_POOL </xsl:text>
     <xsl:value-of select="$ParentNode/sxml:BUFFER_POOL"/>
    </xsl:if>
    <xsl:if test="$ParentNode/sxml:FLASH_CACHE">
     <xsl:text> FLASH_CACHE </xsl:text>
     <xsl:value-of select="$ParentNode/sxml:FLASH_CACHE"/>
    </xsl:if>
    <xsl:if test="$ParentNode/sxml:CELL_FLASH_CACHE">
     <xsl:text> CELL_FLASH_CACHE </xsl:text>
     <xsl:value-of select="$ParentNode/sxml:CELL_FLASH_CACHE"/>
    </xsl:if>
    <xsl:text>) </xsl:text>
   </xsl:when>
   <xsl:otherwise>
    <xsl:if test="$ParentNode/sxml:NEXT[@value1] 
	or $ParentNode/sxml:MAXEXTENTS[@value1] 
	or $ParentNode/sxml:PCTINCREASE[@value1] 
	or $ParentNode/sxml:FREELISTS[@value1]
	or $ParentNode/sxml:BUFFER_POOL[@value1]
	or $ParentNode/sxml:FLASH_CACHE[@value1]
	or $ParentNode/sxml:CELL_FLASH_CACHE[@value1]">
     <xsl:text> STORAGE (</xsl:text>
     <!-- ORA-02203: INITIAL storage options not allowed -->
     <xsl:if test="$ParentNode/sxml:NEXT[@value1]">
      <xsl:text> NEXT </xsl:text>
      <xsl:value-of select="$ParentNode/sxml:NEXT"/>
     </xsl:if>
     <!-- ORA-01570: MINEXTENTS not alterable -->
     <xsl:if test="$ParentNode/sxml:MAXEXTENTS[@value1]">
      <xsl:text> MAXEXTENTS </xsl:text>
      <xsl:value-of select="$ParentNode/sxml:MAXEXTENTS"/>
     </xsl:if>
     <xsl:if test="$ParentNode/sxml:PCTINCREASE[@value1]">
      <xsl:text> PCTINCREASE </xsl:text>
      <xsl:value-of select="$ParentNode/sxml:PCTINCREASE"/>
     </xsl:if>
     <xsl:if test="$ParentNode/sxml:FREELISTS[@value1]">
      <xsl:text> FREELISTS </xsl:text>
      <xsl:value-of select="$ParentNode/sxml:FREELISTS"/>
     </xsl:if>
     <!-- ORA-02170: FREELIST GROUPS storage option not allowed -->
     <xsl:if test="$ParentNode/sxml:BUFFER_POOL[@value1]">
      <xsl:text> BUFFER_POOL </xsl:text>
      <xsl:value-of select="$ParentNode/sxml:BUFFER_POOL"/>
     </xsl:if>
     <xsl:if test="$ParentNode/sxml:FLASH_CACHE[@value1]">
      <xsl:text> FLASH_CACHE </xsl:text>
      <xsl:value-of select="$ParentNode/sxml:FLASH_CACHE"/>
     </xsl:if>
     <xsl:if test="$ParentNode/sxml:CELL_FLASH_CACHE[@value1]">
      <xsl:text> CELL_FLASH_CACHE </xsl:text>
      <xsl:value-of select="$ParentNode/sxml:CELL_FLASH_CACHE"/>
     </xsl:if>
     <xsl:text>) </xsl:text>
    </xsl:if>
   </xsl:otherwise>
  </xsl:choose>
 </xsl:template>
 <xsl:template name="AlterSegmentAttributes">
  <xsl:param name="ParentNode" select="''"/>
  <xsl:param name="TypeNode" select="''"/>
  <!-- *******************************************************************
Template: AlterSegmentAttributes
Parameters:
 ParentNode - $ParentNode/sxml:RELATIONAL_TABLE/sxml:PHYSICAL_PROPERTIES/sxml:HEAP_TABLE/sxml:SEGMENT_ATTRIBUTES
 TypeNode   - ADD or '' (modify)
******************************************************************** -->
  <!-- Physical_Attributes -->
  <xsl:call-template name="AlterPhysicalAttributes">
   <xsl:with-param name="ParentNode" select="$ParentNode"/>
   <xsl:with-param name="TypeNode" select="$TypeNode"/>
  </xsl:call-template>
  <!-- Tablespace -->
  <xsl:apply-templates select="$ParentNode/sxml:TABLESPACE"/>
  <!-- logging_clause -->
  <xsl:call-template name="AlterLogging">
   <xsl:with-param name="ParentNode" select="$ParentNode"/>
   <xsl:with-param name="TypeNode" select="'ADD'"/>
  </xsl:call-template>
 </xsl:template>
 <xsl:template name="AlterLogging">
  <xsl:param name="ParentNode" select="''"/>
  <xsl:param name="TypeNode" select="''"/>
  <!-- *******************************************************************
Template: AlterLogging
Parameters:
 ParentNode -  $ParentNode/sxml:RELATIONAL_TABLE/sxml:PHYSICAL_PROPERTIES/sxml:HEAP_TABLE/sxml:SEGMENT_ATTRIBUTES
 TypeNode   - ADD or '' (modify)
******************************************************************** -->
  <xsl:if test="$TypeNode='ADD' or $ParentNode/sxml:LOGGING[@value1]">
   <xsl:apply-templates select="$ParentNode/sxml:LOGGING"/>
  </xsl:if>
 </xsl:template>
 <xsl:template name="AlterTablespace">
  <xsl:param name="ParentNode" select="''"/>
  <!-- *******************************************************************
Template: AlterTablespace
Parameters:
 ParentNode -  $ParentNode/sxml:RELATIONAL_TABLE/sxml:PHYSICAL_PROPERTIES/sxml:HEAP_TABLE/sxml:SEGMENT_ATTRIBUTES/sxml:TABLESPACE
******************************************************************** -->
  <xsl:if test="$ParentNode/sxml:TABLESPACE">
   <xsl:text> TABLESPACE </xsl:text>
   <xsl:apply-templates select="$ParentNode/sxml:TABLESPACE"/>
  </xsl:if>
 </xsl:template>
 <xsl:template name="AlterCompress">
  <xsl:param name="ParentNode" select="''"/>
  <!-- *******************************************************************
Template: AlterCompress - table compression
Parameters:
 ParentNode -  $ParentNode/sxml:RELATIONAL_TABLE/sxml:PHYSICAL_PROPERTIES/sxml:HEAP_TABLE
******************************************************************** -->
  <xsl:choose>
   <xsl:when test="$ParentNode/sxml:COMPRESS/@value1 or $ParentNode/sxml:COMPRESS/@src='2' or $ParentNode/sxml:COMPRESS_LEVEL/@src">
    <xsl:call-template name="DoCompressDDL">
     <xsl:with-param name="Compress" select="$ParentNode/sxml:COMPRESS"/>
     <xsl:with-param name="CompressLevel" select="$ParentNode/sxml:COMPRESS_LEVEL[@src='2']"/>
    </xsl:call-template>
   </xsl:when>
   <xsl:when test="$ParentNode/sxml:COMPRESS/@src='1'"> NOCOMPRESS </xsl:when>
  </xsl:choose>
 </xsl:template>
 <xsl:template name="AlterSupplemental">
  <xsl:param name="ParentNode" select="''"/>
  <!-- *******************************************************************
Template: AlterSupplemental
Parameters:
 ParentNode - Parent node of SCHEMA, NAME, constraint lists
******************************************************************** -->
  <xsl:if test="$ParentNode/sxml:RELATIONAL_TABLE/sxml:SUPPLEMENTAL_LOGGING">
   <!-- supplemental_log_grp_clause -->
   <xsl:call-template name="AlterGroupList">
    <xsl:with-param name="ParentNode" select="$ParentNode"/>
    <xsl:with-param name="GroupListNode" select="$ParentNode/sxml:RELATIONAL_TABLE/sxml:SUPPLEMENTAL_LOGGING/sxml:GROUP_LIST/sxml:GROUP_LIST_ITEM"/>
    <xsl:with-param name="DoAll">
     <xsl:choose>
      <xsl:when test="$ParentNode/sxml:RELATIONAL_TABLE/sxml:SUPPLEMENTAL_LOGGING/@src='1'">DROP</xsl:when>
      <xsl:when test="$ParentNode/sxml:RELATIONAL_TABLE/sxml:SUPPLEMENTAL_LOGGING/@src='2'">ADD</xsl:when>
      <xsl:otherwise>N</xsl:otherwise>
     </xsl:choose>
    </xsl:with-param>
   </xsl:call-template>
   <!-- supplemental_id_key_clause -->
   <xsl:call-template name="AlterIDList">
    <xsl:with-param name="ParentNode" select="$ParentNode"/>
    <xsl:with-param name="IDListNode" select="$ParentNode/sxml:RELATIONAL_TABLE/sxml:SUPPLEMENTAL_LOGGING/sxml:ID_LIST/sxml:ID_LIST_ITEM"/>
    <xsl:with-param name="DoAll">
     <xsl:choose>
      <xsl:when test="$ParentNode/sxml:RELATIONAL_TABLE/sxml:SUPPLEMENTAL_LOGGING/@src='1'">DROP</xsl:when>
      <xsl:when test="$ParentNode/sxml:RELATIONAL_TABLE/sxml:SUPPLEMENTAL_LOGGING/@src='2'">ADD</xsl:when>
      <xsl:otherwise>N</xsl:otherwise>
     </xsl:choose>
    </xsl:with-param>
   </xsl:call-template>
  </xsl:if>
 </xsl:template>
 <xsl:template name="AlterGroupList">
  <xsl:param name="ParentNode" select="''"/>
  <xsl:param name="GroupListNode" select="''"/>
  <xsl:param name="DoAll">N</xsl:param>
  <!-- *******************************************************************
Template: AlterGroupList
Parameters:
 ParentNode - sxml:RELATIONAL_TABLE/sxml:SUPPLEMENTAL_LOGGING
 GroupNode - sxml:RELATIONAL_TABLE/sxml:SUPPLEMENTAL_LOGGING/sxml:GROUP_LIST
 DoAll - "DROP" = entire list is in doc1, not in doc2
         "ADD"  = entire list is in doc2, not in doc1
         "N"    = otherwise
******************************************************************** -->
  <xsl:for-each select="$GroupListNode">
   <xsl:choose>
    <xsl:when test="$DoAll='DROP'">
     <xsl:call-template name="SupplementLogs">
      <xsl:with-param name="ParentNode" select="$ParentNode"/>
      <xsl:with-param name="GroupNameNode" select="$GroupListNode/sxml:NAME"/>
      <xsl:with-param name="TypeNode" select="'DROP'"/>
     </xsl:call-template>
    </xsl:when>
    <xsl:when test="$DoAll='ADD'">
     <xsl:call-template name="SupplementLogs">
      <xsl:with-param name="ParentNode" select="$ParentNode"/>
      <xsl:with-param name="GroupNameNode" select="$GroupListNode/sxml:NAME"/>
      <xsl:with-param name="GroupListNode" select="$GroupListNode"/>
      <xsl:with-param name="TypeNode" select="'ADD'"/>
     </xsl:call-template>
    </xsl:when>
    <xsl:when test="$GroupListNode/sxml:NAME[@value1]">
     <xsl:call-template name="SupplementLogs">
      <xsl:with-param name="ParentNode" select="$ParentNode"/>
      <xsl:with-param name="GroupNameNode" select="$GroupListNode/sxml:NAME/@value1"/>
      <xsl:with-param name="TypeNode" select="'DROP'"/>
     </xsl:call-template>
     <xsl:call-template name="SupplementLogs">
      <xsl:with-param name="ParentNode" select="$ParentNode"/>
      <xsl:with-param name="GroupNameNode" select="$GroupListNode/sxml:NAME"/>
      <xsl:with-param name="GroupListNode" select="$GroupListNode"/>
      <xsl:with-param name="TypeNode" select="'ADD'"/>
     </xsl:call-template>
    </xsl:when>
   </xsl:choose>
  </xsl:for-each>
 </xsl:template>
 <xsl:template name="SupplementLogs">
  <xsl:param name="ParentNode" select="''"/>
  <xsl:param name="GroupListNode" select="''"/>
  <xsl:param name="GroupNameNode" select="''"/>
  <xsl:param name="TypeNode" select="''"/>
  <!-- *******************************************************************
Template: SupplementLogs
Parameters:
 ParentNode - sxml:RELATIONAL_TABLE/sxml:SUPPLEMENTAL_LOGGING
 GrouplistNode - sxml:RELATIONAL_TABLE/sxml:SUPPLEMENTAL_LOGGING/sxml:GROUP_LIST/sxml:GROUP_LIST_ITEM
 GroupNameNode - sxml:RELATIONAL_TABLE/sxml:SUPPLEMENTAL_LOGGING/sxml:GROUP_LIST/sxml:GROUP_LIST_ITEM/sxml:NAME
 TypeNode - ADD or DROP
******************************************************************** -->
  <xsl:element name="ALTER_LIST_ITEM">
   <xsl:call-template name="SupplementLog">
    <xsl:with-param name="ParentNode" select="$ParentNode"/>
    <xsl:with-param name="GroupNameNode" select="$GroupNameNode"/>
    <xsl:with-param name="GroupListNode" select="$GroupListNode"/>
    <xsl:with-param name="TypeNode" select="$TypeNode"/>
    <xsl:with-param name="Action">PARSE</xsl:with-param>
   </xsl:call-template>
   <xsl:call-template name="SupplementLog">
    <xsl:with-param name="ParentNode" select="$ParentNode"/>
    <xsl:with-param name="GroupNameNode" select="$GroupNameNode"/>
    <xsl:with-param name="GroupListNode" select="$GroupListNode"/>
    <xsl:with-param name="TypeNode" select="$TypeNode"/>
    <xsl:with-param name="Action">SQL</xsl:with-param>
   </xsl:call-template>
  </xsl:element>
 </xsl:template>
 <xsl:template name="SupplementLog">
  <xsl:param name="ParentNode" select="''"/>
  <xsl:param name="GroupListNode" select="''"/>
  <xsl:param name="GroupNameNode" select="''"/>
  <xsl:param name="TypeNode" select="''"/>
  <xsl:param name="Action" select="''"/>
  <!-- *******************************************************************
Template: SupplementLog
Parameters:
 ParentNode - sxml:RELATIONAL_TABLE/sxml:SUPPLEMENTAL_LOGGING
 GrouplistNode - sxml:RELATIONAL_TABLE/sxml:SUPPLEMENTAL_LOGGING/sxml:GROUP_LIST/sxml:GROUP_LIST_ITEM
 GroupNameNode - sxml:RELATIONAL_TABLE/sxml:SUPPLEMENTAL_LOGGING/sxml:GROUP_LIST/sxml:GROUP_LIST_ITEM/sxml:NAME
 TypeNode - ADD or DROP
******************************************************************** -->
  <xsl:choose>
   <xsl:when test="$Action='PARSE' and ($PRS_NAME=1 or 
                                        $PRS_CLAUSE_TYPE=1 or
                                        $PRS_COLUMN_ATTRIBUTE=1 or
                                        $PRS_ALTERABLE=1 or
                                        $PRS_XPATH=1)">
    <xsl:element name="PARSE_LIST">
     <xsl:call-template name="AddXPathParseItem">
      <xsl:with-param name="Node" select="$GroupNameNode"/>
     </xsl:call-template>
     <xsl:call-template name="AddParseItem">
      <xsl:with-param name="ParseIt" select="$PRS_NAME"/>
      <xsl:with-param name="Item">NAME</xsl:with-param>
      <xsl:with-param name="Value1" select="$GroupNameNode"/>
     </xsl:call-template>
     <xsl:call-template name="AddParseItem">
      <xsl:with-param name="ParseIt" select="$PRS_CLAUSE_TYPE"/>
      <xsl:with-param name="Item">CLAUSE_TYPE</xsl:with-param>
      <xsl:with-param name="Value1">
       <xsl:if test="$TypeNode='ADD'">ADD_SUPPLEMENTAL_LOGGING</xsl:if>
       <xsl:if test="$TypeNode='DROP'">DROP_SUPPLEMENTAL_LOGGING</xsl:if>
      </xsl:with-param>
     </xsl:call-template>
    </xsl:element>
   </xsl:when>
   <xsl:when test="$Action='SQL'">
    <xsl:element name="SQL_LIST">
     <xsl:element name="SQL_LIST_ITEM">
      <xsl:element name="TEXT">
       <xsl:text>ALTER TABLE </xsl:text>
       <xsl:call-template name="SchemaName">
        <xsl:with-param name="ParentNode" select="$ParentNode"/>
       </xsl:call-template>
       <xsl:choose>
        <xsl:when test="$TypeNode='ADD'">
         <xsl:text> ADD </xsl:text>
        </xsl:when>
        <xsl:when test="$TypeNode='DROP'">
         <xsl:text> DROP </xsl:text>
        </xsl:when>
        <xsl:otherwise/>
       </xsl:choose>
       <xsl:text>SUPPLEMENTAL LOG GROUP </xsl:text>
       <xsl:value-of select="$GroupNameNode"/>
       <xsl:if test="$TypeNode='ADD'">
        <xsl:text>(</xsl:text>
        <xsl:call-template name="AlterCOL_LIST">
         <xsl:with-param name="ColListItems" select="$GroupListNode/sxml:COL_LIST/sxml:COL_LIST_ITEM"/>
        </xsl:call-template>
        <xsl:text>)</xsl:text>
        <xsl:if test="$GroupListNode/sxml:ALWAYS[@src!='1']">
         <xsl:text> ALWAYS </xsl:text>
        </xsl:if>
       </xsl:if>
      </xsl:element>
     </xsl:element>
    </xsl:element>
   </xsl:when>
  </xsl:choose>
 </xsl:template>
 <xsl:template name="AlterIDList">
  <xsl:param name="ParentNode" select="''"/>
  <xsl:param name="IDListNode" select="''"/>
  <xsl:param name="DoAll">N</xsl:param>
  <!-- *******************************************************************
Template: AlterIDList
Parameters:
 ParentNode - sxml:RELATIONAL_TABLE/sxml:SUPPLEMENTAL_LOGGING
 GroupNode - sxml:RELATIONAL_TABLE/sxml:SUPPLEMENTAL_LOGGING/sxml:ID_LIST
******************************************************************** -->
  <xsl:for-each select="$IDListNode">
   <xsl:choose>
    <xsl:when test="$DoAll='DROP' or @src='1'">
     <xsl:call-template name="SupplementIDLogs">
      <xsl:with-param name="ParentNode" select="$ParentNode"/>
      <xsl:with-param name="IDListNode" select="sxml:COLUMNS"/>
      <xsl:with-param name="TypeNode" select="'DROP'"/>
     </xsl:call-template>
    </xsl:when>
    <xsl:when test="$DoAll='ADD' or @src='2'">
     <xsl:call-template name="SupplementIDLogs">
      <xsl:with-param name="ParentNode" select="$ParentNode"/>
      <xsl:with-param name="IDListNode" select="sxml:COLUMNS"/>
      <xsl:with-param name="TypeNode" select="'ADD'"/>
     </xsl:call-template>
    </xsl:when>
    <xsl:when test="$IDListNode/sxml:COLUMNS[@value1]">
     <xsl:call-template name="SupplementIDLogs">
      <xsl:with-param name="ParentNode" select="$ParentNode"/>
      <xsl:with-param name="IDListNode" select="sxml:COLUMNS/@value1"/>
      <xsl:with-param name="TypeNode" select="'DROP'"/>
     </xsl:call-template>
     <xsl:call-template name="SupplementIDLogs">
      <xsl:with-param name="ParentNode" select="$ParentNode"/>
      <xsl:with-param name="IDListNode" select="sxml:COLUMNS"/>
      <xsl:with-param name="TypeNode" select="'ADD'"/>
     </xsl:call-template>
    </xsl:when>
   </xsl:choose>
  </xsl:for-each>
 </xsl:template>
 <xsl:template name="SupplementIDLogs">
  <xsl:param name="ParentNode" select="''"/>
  <xsl:param name="IDListNode" select="''"/>
  <xsl:param name="TypeNode" select="''"/>
  <!-- *******************************************************************
Template: SupplementIDLogs
Parameters:
 ParentNode - sxml:RELATIONAL_TABLE/sxml:SUPPLEMENTAL_LOGGING
 GroupNode - sxml:RELATIONAL_TABLE/sxml:SUPPLEMENTAL_LOGGING/sxml:GROUP_LIST/sxml:GROUP_LIST_ITEM/sxml:NAME
 TypeNode - ADD or DROP
******************************************************************** -->
  <xsl:element name="ALTER_LIST_ITEM">
   <xsl:call-template name="SupplementIDLog">
    <xsl:with-param name="ParentNode" select="$ParentNode"/>
    <xsl:with-param name="IDListNode" select="$IDListNode"/>
    <xsl:with-param name="TypeNode" select="$TypeNode"/>
    <xsl:with-param name="Action">PARSE</xsl:with-param>
   </xsl:call-template>
   <xsl:call-template name="SupplementIDLog">
    <xsl:with-param name="ParentNode" select="$ParentNode"/>
    <xsl:with-param name="IDListNode" select="$IDListNode"/>
    <xsl:with-param name="TypeNode" select="$TypeNode"/>
    <xsl:with-param name="Action">SQL</xsl:with-param>
   </xsl:call-template>
  </xsl:element>
 </xsl:template>
 <xsl:template name="SupplementIDLog">
  <xsl:param name="ParentNode" select="''"/>
  <xsl:param name="IDListNode" select="''"/>
  <xsl:param name="TypeNode" select="''"/>
  <xsl:param name="Action" select="''"/>
  <!-- *******************************************************************
Template: SupplementIDLog
Parameters:
 ParentNode - sxml:RELATIONAL_TABLE/sxml:SUPPLEMENTAL_LOGGING
 GroupNode - sxml:RELATIONAL_TABLE/sxml:SUPPLEMENTAL_LOGGING/sxml:GROUP_LIST/sxml:GROUP_LIST_ITEM/sxml:NAME
 TypeNode - ADD or DROP
 Action _ PARSE or SQL
******************************************************************** -->
  <xsl:choose>
   <xsl:when test="$Action='PARSE' and ($PRS_NAME=1 or 
                                        $PRS_CLAUSE_TYPE=1 or
                                        $PRS_COLUMN_ATTRIBUTE=1 or
                                        $PRS_ALTERABLE=1 or
                                        $PRS_XPATH=1)">
    <xsl:element name="PARSE_LIST">
     <xsl:call-template name="AddXPathParseItem">
      <xsl:with-param name="Node" select="$IDListNode"/>
     </xsl:call-template>
     <xsl:call-template name="AddParseItem">
      <xsl:with-param name="ParseIt" select="$PRS_NAME"/>
      <xsl:with-param name="Item">NAME</xsl:with-param>
      <xsl:with-param name="Value1" select="$IDListNode"/>
     </xsl:call-template>
     <xsl:call-template name="AddParseItem">
      <xsl:with-param name="ParseIt" select="$PRS_CLAUSE_TYPE"/>
      <xsl:with-param name="Item">CLAUSE_TYPE</xsl:with-param>
      <xsl:with-param name="Value1">
       <xsl:if test="$TypeNode='ADD'">ADD_SUPPLEMENTAL_ID_KEY</xsl:if>
       <xsl:if test="$TypeNode='DROP'">DROP_SUPPLEMENTAL_ID_KEY</xsl:if>
      </xsl:with-param>
     </xsl:call-template>
    </xsl:element>
   </xsl:when>
   <xsl:when test="$Action='SQL'">
    <xsl:element name="SQL_LIST">
     <xsl:element name="SQL_LIST_ITEM">
      <xsl:element name="TEXT">
       <xsl:text>ALTER TABLE </xsl:text>
       <xsl:call-template name="SchemaName">
        <xsl:with-param name="ParentNode" select="$ParentNode"/>
       </xsl:call-template>
       <xsl:choose>
        <xsl:when test="$TypeNode='ADD'">
         <xsl:text> ADD </xsl:text>
        </xsl:when>
        <xsl:when test="$TypeNode='DROP'">
         <xsl:text> DROP </xsl:text>
        </xsl:when>
       </xsl:choose>
       <xsl:text>SUPPLEMENTAL LOG DATA (</xsl:text>
       <xsl:choose>
        <xsl:when test="$IDListNode='ALL'">ALL</xsl:when>
        <xsl:when test="$IDListNode='PRIMARY_KEY'">PRIMARY KEY</xsl:when>
        <xsl:when test="$IDListNode='UNIQUE'">UNIQUE INDEX</xsl:when>
        <xsl:when test="$IDListNode='FOREIGN_KEY'">FOREIGN KEY</xsl:when>
       </xsl:choose>
       <xsl:text>) COLUMNS </xsl:text>
      </xsl:element>
     </xsl:element>
    </xsl:element>
   </xsl:when>
  </xsl:choose>
 </xsl:template>
 <xsl:template name="AlterMiscProperties">
  <xsl:param name="ObjectNode" select="''"/>
  <xsl:param name="PropertyNode" select="''"/>
  <!-- *******************************************************************
Template: AlterMiscProperties 
Parameters:
 ObejctNode - <TABLE> 
 PropertyNode - <TABLE_PROPERTIES> i.e., parent of ROW_MOVEMENT, CACHE, and PARALLEL
******************************************************************** -->
  <!-- Cache -->
  <xsl:call-template name="AlterRowMovement">
   <xsl:with-param name="ObjectNode" select="$ObjectNode"/>
   <xsl:with-param name="PropertyNode" select="$PropertyNode"/>
   <xsl:with-param name="ObjType">TABLE</xsl:with-param>
  </xsl:call-template>
  <!-- Cache -->
  <xsl:call-template name="AlterCache">
   <xsl:with-param name="ObjectNode" select="$ObjectNode"/>
   <xsl:with-param name="ParentNode" select="$PropertyNode"/>
   <xsl:with-param name="ObjType">TABLE</xsl:with-param>
   <xsl:with-param name="OnTable"> </xsl:with-param>
  </xsl:call-template>
  <!-- Parallel -->
  <xsl:call-template name="AlterParallel">
   <xsl:with-param name="ObjectNode" select="$ObjectNode"/>
   <xsl:with-param name="ParentNode" select="$PropertyNode"/>
   <xsl:with-param name="ObjType">TABLE</xsl:with-param>
   <xsl:with-param name="OnTable"> </xsl:with-param>
  </xsl:call-template>
 </xsl:template>
 <xsl:template name="AlterRowMovement">
  <xsl:param name="ObjectNode" select="''"/>
  <xsl:param name="PropertyNode" select="''"/>
  <xsl:param name="ObjType" select="''"/>
  <!-- *******************************************************************
Template: AlterRowMovement
Description: This template determines if there was a change in the ROW_MOVEMENT element
Parameters:
 ObjectNode - object node e.g., <TABLE>
 PropertyNode - Parent of the ROW_MOVEMENT node
ObjType - object type containing the ROW_MOVEMENT directive 
******************************************************************** -->
  <xsl:if test="$PropertyNode/sxml:ROW_MOVEMENT/@src or 
           ($PropertyNode/@src and $PropertyNode/sxml:ROW_MOVEMENT)">
   <xsl:element name="ALTER_LIST_ITEM">
    <xsl:call-template name="DoAlterRowMovement">
     <xsl:with-param name="ObjectNode" select="$ObjectNode"/>
     <xsl:with-param name="PropertyNode" select="$PropertyNode"/>
     <xsl:with-param name="ObjType" select="$ObjType"/>
     <xsl:with-param name="Action">PARSE</xsl:with-param>
    </xsl:call-template>
    <xsl:call-template name="DoAlterRowMovement">
     <xsl:with-param name="ObjectNode" select="$ObjectNode"/>
     <xsl:with-param name="PropertyNode" select="$PropertyNode"/>
     <xsl:with-param name="ObjType" select="$ObjType "/>
     <xsl:with-param name="Action">SQL</xsl:with-param>
    </xsl:call-template>
   </xsl:element>
  </xsl:if>
 </xsl:template>
 <xsl:template name="DoAlterRowMovement">
  <xsl:param name="ObjectNode" select="''"/>
  <xsl:param name="PropertyNode" select="''"/>
  <xsl:param name="ObjType" select="''"/>
  <xsl:param name="Action" select="''"/>
  <!-- *******************************************************************
Template: DoAlterRowMovement
Parameters:
 ObjectNode - e.g., <TABLE>
 PropertyNode - <TABLE_PROPERTIES> i.e., parent of ROW_MOVEMENT
 ObjType - object type c
 Action - PARSE or SQL
******************************************************************** -->
  <xsl:choose>
   <xsl:when test="$Action='PARSE' and ($PRS_NAME=1 or 
                                        $PRS_CLAUSE_TYPE=1 or
                                        $PRS_COLUMN_ATTRIBUTE=1 or
                                        $PRS_ALTERABLE=1 or
                                        $PRS_XPATH=1)">
    <xsl:element name="PARSE_LIST">
     <xsl:call-template name="AddXPathParseItem">
      <xsl:with-param name="Node" select="$PropertyNode"/>
     </xsl:call-template>
     <xsl:call-template name="AddParseItem">
      <xsl:with-param name="ParseIt" select="$PRS_NAME"/>
      <xsl:with-param name="Item">NAME</xsl:with-param>
      <xsl:with-param name="Value1" select="$ObjectNode/sxml:NAME"/>
     </xsl:call-template>
     <xsl:call-template name="AddParseItem">
      <xsl:with-param name="ParseIt" select="$PRS_CLAUSE_TYPE"/>
      <xsl:with-param name="Item">CLAUSE_TYPE</xsl:with-param>
      <xsl:with-param name="Value1">ALTER_TABLE_PROPERTIES</xsl:with-param>
     </xsl:call-template>
     <xsl:call-template name="AddParseItem">
      <xsl:with-param name="ParseIt" select="$PRS_COLUMN_ATTRIBUTE"/>
      <xsl:with-param name="Item">TABLE_PROPERTIES</xsl:with-param>
      <xsl:with-param name="Value1">ROW_MOVEMENT</xsl:with-param>
     </xsl:call-template>
    </xsl:element>
   </xsl:when>
   <xsl:when test="$Action='SQL'">
    <xsl:element name="SQL_LIST">
     <xsl:element name="SQL_LIST_ITEM">
      <xsl:element name="TEXT">
       <xsl:text>ALTER </xsl:text>
       <xsl:value-of select="$ObjType"/>
       <xsl:text> </xsl:text>
       <xsl:call-template name="SchemaName">
        <xsl:with-param name="ParentNode" select="$ObjectNode"/>
       </xsl:call-template>
       <xsl:choose>
        <xsl:when test="$PropertyNode/@src='2' or $PropertyNode/sxml:ROW_MOVEMENT/@src='2'">
         <xsl:if test="$PropertyNode/sxml:ROW_MOVEMENT"> ENABLE ROW MOVEMENT</xsl:if>
        </xsl:when>
        <xsl:when test="$PropertyNode/@src='1' or $PropertyNode/sxml:ROW_MOVEMENT/@src='1'">
         <xsl:if test="$PropertyNode/sxml:ROW_MOVEMENT"> DISABLE ROW MOVEMENT</xsl:if>
        </xsl:when>
        <xsl:otherwise/>
       </xsl:choose>
      </xsl:element>
     </xsl:element>
    </xsl:element>
   </xsl:when>
  </xsl:choose>
 </xsl:template>
 <xsl:template name="AlterCache">
  <xsl:param name="ObjectNode" select="''"/>
  <xsl:param name="ParentNode" select="''"/>
  <xsl:param name="ObjType" select="''"/>
  <xsl:param name="OnTable" select="''"/>
  <!-- *******************************************************************
Template: AlterCache
Description: This template determines if there was a change in the CACHE element
                    and then call DoAlterCache to generate SQL_LIST
Parameters:
 ObjectNode - <TABLE> 
 ParentNode -  Parent of the CACHE node e.g., <TABLE_PROPERTIES>
 ObjType - object type containing the CACHE directive (e.g., MATERIALIZED VIEW LOG)
 OnTable - Materialized View Logs require the ON_TABLE node for identifying the objname
******************************************************************** -->
  <xsl:if test="$ParentNode/sxml:CACHE/@src or 
           ($ParentNode/@src and $ParentNode/sxml:CACHE)">
   <xsl:element name="ALTER_LIST_ITEM">
    <xsl:call-template name="DoAlterCache">
     <xsl:with-param name="ObjectNode" select="$ObjectNode"/>
     <xsl:with-param name="ParentNode" select="$ParentNode"/>
     <xsl:with-param name="ObjType" select="$ObjType"/>
     <xsl:with-param name="OnTable" select="$OnTable"/>
     <xsl:with-param name="Action">PARSE</xsl:with-param>
    </xsl:call-template>
    <xsl:call-template name="DoAlterCache">
     <xsl:with-param name="ObjectNode" select="$ObjectNode"/>
     <xsl:with-param name="ParentNode" select="$ParentNode"/>
     <xsl:with-param name="ObjType" select="$ObjType"/>
     <xsl:with-param name="OnTable" select="$OnTable"/>
     <xsl:with-param name="Action">SQL</xsl:with-param>
    </xsl:call-template>
   </xsl:element>
  </xsl:if>
 </xsl:template>
 <xsl:template name="DoAlterCache">
  <xsl:param name="ObjectNode" select="''"/>
  <xsl:param name="ParentNode" select="''"/>
  <xsl:param name="ObjType" select="''"/>
  <xsl:param name="OnTable" select="''"/>
  <xsl:param name="Action" select="''"/>
  <!-- *******************************************************************
Template: DoAlterCache
Parameters:
 ObjectNode - <TABLE>
 ParentNode - parent of <CACHE>   e.g., <TABLE_PROPERTIES>
 ObjType - object type containing the CACHE directive (e.g., MATERIALIZED VIEW LOG)
 OnTable - the syntax for altering a MATERIALIZED VIEW LOG is slightly different in that
        it requires an ON clause to identified the table the mview is referencing.
 Action - PARSE or SQL
******************************************************************** -->
  <xsl:choose>
   <xsl:when test="$Action='PARSE' and ($PRS_NAME=1 or 
                                        $PRS_CLAUSE_TYPE=1 or
                                        $PRS_COLUMN_ATTRIBUTE=1 or
                                        $PRS_ALTERABLE=1 or
                                        $PRS_XPATH=1)">
    <xsl:element name="PARSE_LIST">
     <xsl:call-template name="AddXPathParseItem">
      <xsl:with-param name="Node" select="$ParentNode/sxml:CACHE"/>
     </xsl:call-template>
     <xsl:call-template name="AddParseItem">
      <xsl:with-param name="ParseIt" select="$PRS_NAME"/>
      <xsl:with-param name="Item">NAME</xsl:with-param>
      <xsl:with-param name="Value1" select="$ObjectNode/sxml:NAME"/>
     </xsl:call-template>
     <xsl:choose>
      <xsl:when test="$ObjType = 'TABLE'">
       <xsl:call-template name="AddParseItem">
        <xsl:with-param name="ParseIt" select="$PRS_CLAUSE_TYPE"/>
        <xsl:with-param name="Item">CLAUSE_TYPE</xsl:with-param>
        <xsl:with-param name="Value1">ALTER_TABLE_PROPERTIES</xsl:with-param>
       </xsl:call-template>
       <xsl:call-template name="AddParseItem">
        <xsl:with-param name="ParseIt" select="$PRS_COLUMN_ATTRIBUTE"/>
        <xsl:with-param name="Item">TABLE_PROPERTIES</xsl:with-param>
        <xsl:with-param name="Value1">CACHE</xsl:with-param>
       </xsl:call-template>
      </xsl:when>
      <xsl:otherwise>
       <xsl:call-template name="AddParseItem">
        <xsl:with-param name="ParseIt" select="$PRS_CLAUSE_TYPE"/>
        <xsl:with-param name="Item">CLAUSE_TYPE</xsl:with-param>
        <xsl:with-param name="Value1">CACHE</xsl:with-param>
       </xsl:call-template>
      </xsl:otherwise>
     </xsl:choose>
    </xsl:element>
   </xsl:when>
   <xsl:when test="$Action='SQL'">
    <xsl:element name="SQL_LIST">
     <xsl:element name="SQL_LIST_ITEM">
      <xsl:element name="TEXT">
       <xsl:text>ALTER </xsl:text>
       <xsl:value-of select="$ObjType"/>
       <xsl:text> </xsl:text>
       <xsl:choose>
        <xsl:when test="string-length($OnTable)!=0">
         <xsl:text> ON </xsl:text>
         <xsl:call-template name="SchemaName">
          <xsl:with-param name="ParentNode" select="$OnTable"/>
         </xsl:call-template>
         <xsl:text> </xsl:text>
        </xsl:when>
        <xsl:otherwise>
         <xsl:call-template name="SchemaName">
          <xsl:with-param name="ParentNode" select="$ObjectNode"/>
         </xsl:call-template>
        </xsl:otherwise>
       </xsl:choose>
       <xsl:choose>
        <xsl:when test="$ParentNode/sxml:CACHE/@src='1'">
         <xsl:text> NOCACHE</xsl:text>
        </xsl:when>
        <xsl:otherwise>
         <xsl:text> CACHE</xsl:text>
        </xsl:otherwise>
       </xsl:choose>
      </xsl:element>
     </xsl:element>
    </xsl:element>
   </xsl:when>
  </xsl:choose>
 </xsl:template>
 <xsl:template name="AlterParallel">
  <xsl:param name="ObjectNode" select="''"/>
  <xsl:param name="ParentNode" select="''"/>
  <xsl:param name="ObjType" select="''"/>
  <xsl:param name="OnTable" select="''"/>
  <!-- *******************************************************************
Template: AlterParallel
          This template determines if PARALLEL has been modified and if so,
          calls DoAlterParallel to generate the alters
Parameters:
 ObjectNode - <TABLE>
 ParentNode -  Parent of the PARALLEL or PARALLEL_DEGREE element  e.g., <TABLE_PROPERTIES>
 ObjType - e.g., 'TABLE'
 OnTable
******************************************************************** -->
  <xsl:if test="($ParentNode/@src='2' and 
                                           ($ParentNode/sxml:PARALLEL or $ParentNode/sxml:PARALLEL_DEGREE)) or 
                                           ($ParentNode/sxml:PARALLEL/@src or 
                      $ParentNode/sxml:PARALLEL/@src or
                      $ParentNode/sxml:PARALLEL/@value1 or
                      $ParentNode/sxml:PARALLEL_DEGREE/@src or
                      $ParentNode/sxml:PARALLEL_DEGREE/sxml:DEGREE/@value1 or
                      $ParentNode/sxml:PARALLEL_DEGREE/sxml:INSTANCES/@value1) ">
   <xsl:element name="ALTER_LIST_ITEM">
    <xsl:call-template name="DoAlterParallel">
     <xsl:with-param name="ObjectNode" select="$ObjectNode"/>
     <xsl:with-param name="ParentNode" select="$ParentNode"/>
     <xsl:with-param name="ObjType" select="$ObjType"/>
     <xsl:with-param name="Action">PARSE</xsl:with-param>
    </xsl:call-template>
    <xsl:call-template name="DoAlterParallel">
     <xsl:with-param name="ObjectNode" select="$ObjectNode"/>
     <xsl:with-param name="ParentNode" select="$ParentNode"/>
     <xsl:with-param name="ObjType" select="$ObjType"/>
     <xsl:with-param name="OnTable" select="$OnTable"/>
     <xsl:with-param name="Action">SQL</xsl:with-param>
    </xsl:call-template>
   </xsl:element>
  </xsl:if>
 </xsl:template>
 <xsl:template name="DoAlterParallel">
  <xsl:param name="ObjectNode" select="''"/>
  <xsl:param name="ParentNode" select="''"/>
  <xsl:param name="ObjType" select="''"/>
  <xsl:param name="OnTable" select="''"/>
  <xsl:param name="Action" select="''"/>
  <!-- *******************************************************************
Template: DoAlterParallel
          This template generates the alter parallel directives
Parameters:
 ObjectNode - <TABLE>
 ParentNode -  parent of PARALLEL e.g., <TABLE_PROPERTIES>
 ObjType - e.g. 'TABLE'
 OnTable - This is only used by MATERIALIZED VIEW LOG
 Action - PARSE | SQL 
******************************************************************** -->
  <xsl:choose>
   <xsl:when test="$Action='PARSE' and ($PRS_NAME=1 or 
                                        $PRS_CLAUSE_TYPE=1 or
                                        $PRS_COLUMN_ATTRIBUTE=1 or
                                        $PRS_ALTERABLE=1 or
                                        $PRS_XPATH=1)">
    <xsl:element name="PARSE_LIST">
     <xsl:call-template name="AddXPathParseItem">
      <xsl:with-param name="Node" select="$ParentNode/sxml:PARALLEL"/>
     </xsl:call-template>
     <xsl:call-template name="AddParseItem">
      <xsl:with-param name="ParseIt" select="$PRS_NAME"/>
      <xsl:with-param name="Item">NAME</xsl:with-param>
      <xsl:with-param name="Value1" select="$ObjectNode/sxml:NAME"/>
     </xsl:call-template>
     <xsl:choose>
      <xsl:when test="$ObjType = 'TABLE'">
       <xsl:call-template name="AddParseItem">
        <xsl:with-param name="ParseIt" select="$PRS_CLAUSE_TYPE"/>
        <xsl:with-param name="Item">CLAUSE_TYPE</xsl:with-param>
        <xsl:with-param name="Value1">ALTER_TABLE_PROPERTIES</xsl:with-param>
       </xsl:call-template>
       <xsl:call-template name="AddParseItem">
        <xsl:with-param name="ParseIt" select="$PRS_COLUMN_ATTRIBUTE"/>
        <xsl:with-param name="Item">TABLE_PROPERTIES</xsl:with-param>
        <xsl:with-param name="Value1">PARALLEL</xsl:with-param>
       </xsl:call-template>
      </xsl:when>
      <xsl:otherwise>
       <xsl:call-template name="AddParseItem">
        <xsl:with-param name="ParseIt" select="$PRS_CLAUSE_TYPE"/>
        <xsl:with-param name="Item">CLAUSE_TYPE</xsl:with-param>
        <xsl:with-param name="Value1">PARALLEL</xsl:with-param>
       </xsl:call-template>
      </xsl:otherwise>
     </xsl:choose>
    </xsl:element>
   </xsl:when>
   <xsl:when test="$Action='SQL'">
    <xsl:element name="SQL_LIST">
     <xsl:element name="SQL_LIST_ITEM">
      <xsl:element name="TEXT">
       <xsl:text>ALTER </xsl:text>
       <xsl:value-of select="$ObjType"/>
       <xsl:text> </xsl:text>
       <xsl:choose>
        <xsl:when test="string-length($OnTable)!=0">
         <xsl:text> ON </xsl:text>
         <xsl:call-template name="SchemaName">
          <xsl:with-param name="ParentNode" select="$OnTable"/>
         </xsl:call-template>
         <xsl:text> </xsl:text>
        </xsl:when>
        <xsl:otherwise>
         <xsl:call-template name="SchemaName">
          <xsl:with-param name="ParentNode" select="$ObjectNode"/>
         </xsl:call-template>
        </xsl:otherwise>
       </xsl:choose>
       <!-- There are 2 flavors of PARALLEL syntax:
 PARALLEL [integer]  (old syntax) 
| PARALLEL (DEGREE int INSTANCES int)
Note: it is possible for each to be present in any given diff doc. 
-->
       <xsl:choose>
        <xsl:when test="($ParentNode/@src='1' and 
                                    ($ParentNode/sxml:PARALLEL_DEGREE or
                                     $ParentNode/sxml:PARALLEL)) or
                                   ($ParentNode/sxml:PARALLEL_DEGREE/@src='1')">
         <xsl:text> NOPARALLEL</xsl:text>
        </xsl:when>
        <xsl:when test="($ParentNode/@src='2' and 
                                    ($ParentNode/sxml:PARALLEL_DEGREE)) or
                                   ($ParentNode/sxml:PARALLEL_DEGREE/@src='2')">
         <xsl:text> PARALLEL (</xsl:text>
         <!-- Generate PARALLEL integer if appropriate-->
         <xsl:text>DEGREE </xsl:text>
         <xsl:value-of select="$ParentNode/sxml:PARALLEL_DEGREE/sxml:DEGREE"/>
         <xsl:text> INSTANCES </xsl:text>
         <xsl:value-of select="$ParentNode/sxml:PARALLEL_DEGREE/sxml:INSTANCES"/>
         <xsl:text>)</xsl:text>
        </xsl:when>
        <xsl:when test="($ParentNode/@src='2' and 
                                    ($ParentNode/sxml:PARALLEL)) or
                                   ($ParentNode/sxml:PARALLEL/@src='2') or
                                   ($ParentNode/sxml:PARALLEL/@value1)">
         <xsl:text> PARALLEL </xsl:text>
         <!-- Generate PARALLEL integer if appropriate-->
         <xsl:value-of select="$ParentNode/sxml:PARALLEL"/>
        </xsl:when>
        <xsl:when test="$ParentNode/sxml:PARALLEL/@src='1'">
         <xsl:text> NOPARALLEL</xsl:text>
        </xsl:when>
       </xsl:choose>
      </xsl:element>
     </xsl:element>
    </xsl:element>
   </xsl:when>
  </xsl:choose>
 </xsl:template>
 <xsl:template name="AlterFlashbackArchive">
  <xsl:param name="ParentNode" select="''"/>
  <xsl:param name="TableNode" select="''"/>
  <!-- *******************************************************************
Template: AlterFlashbackArchive
Parameters:
 ParentNode - 
******************************************************************** -->
  <xsl:if test="($ParentNode/@src and $ParentNode/sxml:FLASHBACK_ARCHIVE) or
    $ParentNode/sxml:FLASHBACK_ARCHIVE/@src or
    $ParentNode/sxml:FLASHBACK_ARCHIVE/@value1">
   <xsl:element name="ALTER_LIST_ITEM">
    <xsl:call-template name="DoAlterFlashbackArchive">
     <xsl:with-param name="TableNode" select="$TableNode"/>
     <xsl:with-param name="ParentNode" select="$ParentNode"/>
     <xsl:with-param name="Action">PARSE</xsl:with-param>
    </xsl:call-template>
    <xsl:call-template name="DoAlterFlashbackArchive">
     <xsl:with-param name="TableNode" select="$TableNode"/>
     <xsl:with-param name="ParentNode" select="$ParentNode"/>
     <xsl:with-param name="Action">SQL</xsl:with-param>
    </xsl:call-template>
   </xsl:element>
  </xsl:if>
 </xsl:template>
 <xsl:template name="DoAlterFlashbackArchive">
  <xsl:param name="ParentNode" select="''"/>
  <xsl:param name="TableNode" select="''"/>
  <xsl:param name="Action" select="''"/>
  <!-- *******************************************************************
Template: DoAlterFlashbackArchive
Parameters:
 ParentNode - 
******************************************************************** -->
  <xsl:choose>
   <xsl:when test="$Action='PARSE' and ($PRS_NAME=1 or 
                                        $PRS_CLAUSE_TYPE=1 or
                                        $PRS_COLUMN_ATTRIBUTE=1 or
                                        $PRS_ALTERABLE=1 or
                                        $PRS_XPATH=1)">
    <xsl:element name="PARSE_LIST">
     <xsl:call-template name="AddXPathParseItem">
      <xsl:with-param name="Node" select="$ParentNode"/>
     </xsl:call-template>
     <xsl:call-template name="AddParseItem">
      <xsl:with-param name="ParseIt" select="$PRS_NAME"/>
      <xsl:with-param name="Item">NAME</xsl:with-param>
      <xsl:with-param name="Value1" select="$TableNode/sxml:NAME"/>
     </xsl:call-template>
     <xsl:call-template name="AddParseItem">
      <xsl:with-param name="ParseIt" select="$PRS_CLAUSE_TYPE"/>
      <xsl:with-param name="Item">CLAUSE_TYPE</xsl:with-param>
      <xsl:with-param name="Value1">ALTER_TABLE_PROPERTIES</xsl:with-param>
     </xsl:call-template>
     <xsl:call-template name="AddParseItem">
      <xsl:with-param name="ParseIt" select="$PRS_COLUMN_ATTRIBUTE"/>
      <xsl:with-param name="Item">TABLE_PROPERTIES</xsl:with-param>
      <xsl:with-param name="Value1">FLASHBACK_ARCHIVE</xsl:with-param>
     </xsl:call-template>
    </xsl:element>
   </xsl:when>
   <xsl:when test="$Action='SQL'">
    <xsl:element name="SQL_LIST">
     <xsl:choose>
      <xsl:when test="$ParentNode/@src='2' or $ParentNode/sxml:FLASHBACK_ARCHIVE/@src='2'">
       <xsl:element name="SQL_LIST_ITEM">
        <xsl:element name="TEXT">
         <xsl:text>ALTER TABLE </xsl:text>
         <xsl:call-template name="SchemaName">
          <xsl:with-param name="ParentNode" select="$TableNode"/>
         </xsl:call-template>
         <xsl:apply-templates select="$ParentNode/sxml:FLASHBACK_ARCHIVE"/>
        </xsl:element>
       </xsl:element>
      </xsl:when>
      <xsl:when test="$ParentNode/@src='1' or $ParentNode/sxml:FLASHBACK_ARCHIVE/@src='1'">
       <xsl:if test="$ParentNode/sxml:FLASHBACK_ARCHIVE">
        <xsl:element name="SQL_LIST_ITEM">
         <xsl:element name="TEXT">
          <xsl:text>ALTER TABLE </xsl:text>
          <xsl:call-template name="SchemaName">
           <xsl:with-param name="ParentNode" select="$TableNode"/>
          </xsl:call-template>
          <xsl:text> NO FLASHBACK ARCHIVE</xsl:text>
         </xsl:element>
        </xsl:element>
        <xsl:if test="$LRG!=0">
         <xsl:element name="SQL_LIST_ITEM">
          <xsl:element name="TEXT">
           <xsl:text> begin dbms_lock.sleep(20);  end; </xsl:text>
          </xsl:element>
         </xsl:element>
        </xsl:if>
       </xsl:if>
      </xsl:when>
      <!-- to change flashback archive, first set no archive, then set archive-->
      <xsl:when test="$ParentNode/sxml:FLASHBACK_ARCHIVE/@value1">
       <xsl:element name="SQL_LIST_ITEM">
        <xsl:element name="TEXT">
         <xsl:text>ALTER TABLE </xsl:text>
         <xsl:call-template name="SchemaName">
          <xsl:with-param name="ParentNode" select="$TableNode"/>
         </xsl:call-template>
         <xsl:text> NO FLASHBACK ARCHIVE</xsl:text>
        </xsl:element>
       </xsl:element>
       <xsl:if test="$LRG!=0">
        <xsl:element name="SQL_LIST_ITEM">
         <xsl:element name="TEXT">
          <xsl:text> begin dbms_lock.sleep(20);  end; </xsl:text>
         </xsl:element>
        </xsl:element>
       </xsl:if>
       <xsl:element name="SQL_LIST_ITEM">
        <xsl:element name="TEXT">
         <xsl:text>ALTER TABLE </xsl:text>
         <xsl:call-template name="SchemaName">
          <xsl:with-param name="ParentNode" select="$TableNode"/>
         </xsl:call-template>
         <xsl:apply-templates select="$ParentNode/sxml:FLASHBACK_ARCHIVE"/>
        </xsl:element>
       </xsl:element>
      </xsl:when>
     </xsl:choose>
    </xsl:element>
   </xsl:when>
  </xsl:choose>
 </xsl:template>
 <xsl:template name="AlterIOT">
  <xsl:param name="ParentNode" select="''"/>
  <xsl:param name="TableNode" select="''"/>
  <xsl:param name="ObjType" select="'TABLE'"/>
  <!-- *******************************************************************
Template: AlterIOT 
Parameters:
 ParentNode - sxml:RELATIONAL_TABLE
******************************************************************** -->
  <!-- index_org_table_clause -->
  <xsl:if test="$ParentNode/sxml:PHYSICAL_PROPERTIES/sxml:INDEX_ORGANIZED_TABLE">
   <xsl:call-template name="IndexOrg">
    <xsl:with-param name="TableNode" select="$TableNode"/>
    <xsl:with-param name="ParentNode" select="$ParentNode/sxml:PHYSICAL_PROPERTIES/sxml:INDEX_ORGANIZED_TABLE"/>
    <xsl:with-param name="ObjType" select="$ObjType"/>
   </xsl:call-template>
  </xsl:if>
  <!-- alter_overflow_clause -->
  <xsl:choose>
   <!-- range partition-->
   <xsl:when test="$ParentNode/sxml:TABLE_PROPERTIES/sxml:RANGE_PARTITIONING">
    <xsl:call-template name="IndexOrg">
     <xsl:with-param name="TableNode" select="$TableNode"/>
     <xsl:with-param name="ParentNode" select="$ParentNode/sxml:TABLE_PROPERTIES/sxml:RANGE_PARTITIONING/sxml:DEFAULT_PHYSICAL_PROPERTIES/sxml:INDEX_ORGANIZED_TABLE"/>
     <xsl:with-param name="ListNode" select="$ParentNode/sxml:TABLE_PROPERTIES/sxml:RANGE_PARTITIONING/sxml:PARTITION_LIST"/>
     <xsl:with-param name="ObjType" select="$ObjType"/>
    </xsl:call-template>
   </xsl:when>
   <!-- Hash partition-->
   <xsl:when test="$ParentNode/sxml:TABLE_PROPERTIES/sxml:HASH_PARTITIONING">
    <xsl:call-template name="IndexOrg">
     <xsl:with-param name="TableNode" select="$TableNode"/>
     <xsl:with-param name="ParentNode" select="$ParentNode/sxml:TABLE_PROPERTIES/sxml:HASH_PARTITIONING/sxml:DEFAULT_PHYSICAL_PROPERTIES/sxml:INDEX_ORGANIZED_TABLE"/>
     <xsl:with-param name="ListNode" select="$ParentNode/sxml:TABLE_PROPERTIES/sxml:HASH_PARTITIONING/sxml:PARTITION_LIST"/>
     <xsl:with-param name="ObjType" select="$ObjType"/>
    </xsl:call-template>
   </xsl:when>
   <!-- List partition-->
   <xsl:when test="$ParentNode/sxml:TABLE_PROPERTIES/sxml:LIST_PARTITIONING">
    <xsl:call-template name="IndexOrg">
     <xsl:with-param name="TableNode" select="$TableNode"/>
     <xsl:with-param name="ParentNode" select="$ParentNode/sxml:TABLE_PROPERTIES/sxml:LIST_PARTITIONING/sxml:DEFAULT_PHYSICAL_PROPERTIES/sxml:INDEX_ORGANIZED_TABLE"/>
     <xsl:with-param name="ListNode" select="$ParentNode/sxml:TABLE_PROPERTIES/sxml:LIST_PARTITIONING/sxml:PARTITION_LIST"/>
     <xsl:with-param name="ObjType" select="$ObjType"/>
    </xsl:call-template>
   </xsl:when>
   <xsl:otherwise/>
  </xsl:choose>
  <!-- alter_mapping_table_clause -->
  <!-- COALESCE -->
 </xsl:template>
 <xsl:template name="IndexOrg">
  <xsl:param name="TableNode" select="''"/>
  <xsl:param name="ParentNode" select="''"/>
  <xsl:param name="ListNode" select="''"/>
  <xsl:param name="ObjType" select="'TABLE'"/>
  <!-- *******************************************************************
Template: IndexOrg 
Parameters:
 ParentNode -Parent of sxml:INDEX_ORGANIZED_TABLE
 ListNote - parent of PARTITION_LIST
******************************************************************** -->
  <!-- mapping -->
  <xsl:call-template name="DoMapping">
   <xsl:with-param name="TableNode" select="$TableNode"/>
   <xsl:with-param name="ParentNode" select="$ParentNode"/>
   <xsl:with-param name="ObjType" select="$ObjType"/>
  </xsl:call-template>
  <!-- PCTTHRESHOLD -->
  <xsl:call-template name="DoPCTthreshold">
   <xsl:with-param name="TableNode" select="$TableNode"/>
   <xsl:with-param name="ParentNode" select="$ParentNode"/>
   <xsl:with-param name="ObjType" select="$ObjType"/>
  </xsl:call-template>
  <!-- key_compression -->
  <xsl:call-template name="DoKeyCompress">
   <xsl:with-param name="TableNode" select="$TableNode"/>
   <xsl:with-param name="ParentNode" select="$ParentNode"/>
   <xsl:with-param name="ObjType" select="$ObjType"/>
  </xsl:call-template>
  <!-- OVERFLOW -->
  <xsl:call-template name="DoOverFlow">
   <xsl:with-param name="TableNode" select="$TableNode"/>
   <xsl:with-param name="ParentNode" select="$ParentNode"/>
   <xsl:with-param name="ListNode" select="$ListNode"/>
   <xsl:with-param name="ObjType" select="$ObjType"/>
  </xsl:call-template>
 </xsl:template>
 <xsl:template name="DoMapping">
  <xsl:param name="ParentNode" select="''"/>
  <xsl:param name="TableNode" select="''"/>
  <xsl:param name="ObjType" select="'TABLE'"/>
  <!-- *******************************************************************
Template: DoMapping 
Parameters:
 ParentNode - sxml:INDEX_ORGANIZED_TABLE
******************************************************************** -->
  <xsl:if test="$ParentNode/sxml:MAPPING_TABLE/@src">
   <xsl:choose>
    <xsl:when test="$ObjType='MATERIALIZED_VIEW'">
     <xsl:element name="ERROR">Mapping table clause not supported with materialized views</xsl:element>
    </xsl:when>
    <xsl:otherwise>
     <xsl:element name="ALTER_LIST_ITEM">
      <xsl:call-template name="Mapping">
       <xsl:with-param name="TableNode" select="$TableNode"/>
       <xsl:with-param name="ParentNode" select="$ParentNode"/>
       <xsl:with-param name="ObjType" select="$ObjType"/>
       <xsl:with-param name="Action">PARSE</xsl:with-param>
      </xsl:call-template>
      <xsl:call-template name="Mapping">
       <xsl:with-param name="TableNode" select="$TableNode"/>
       <xsl:with-param name="ParentNode" select="$ParentNode"/>
       <xsl:with-param name="ObjType" select="$ObjType"/>
       <xsl:with-param name="Action">SQL</xsl:with-param>
      </xsl:call-template>
     </xsl:element>
    </xsl:otherwise>
   </xsl:choose>
  </xsl:if>
 </xsl:template>
 <xsl:template name="Mapping">
  <xsl:param name="ParentNode" select="''"/>
  <xsl:param name="TableNode" select="''"/>
  <xsl:param name="ObjType" select="'TABLE'"/>
  <xsl:param name="Action" select="''"/>
  <!-- *******************************************************************
Template: Mapping 
Parameters:
 ParentNode - sxml:INDEX_ORGANIZED_TABLE
******************************************************************** -->
  <xsl:choose>
   <xsl:when test="$Action='PARSE' and ($PRS_NAME=1 or 
                                        $PRS_CLAUSE_TYPE=1 or
                                        $PRS_COLUMN_ATTRIBUTE=1 or
                                        $PRS_ALTERABLE=1 or
                                        $PRS_XPATH=1)">
    <xsl:element name="PARSE_LIST">
     <xsl:call-template name="AddXPathParseItem">
      <xsl:with-param name="Node" select="$ParentNode"/>
     </xsl:call-template>
     <xsl:call-template name="AddParseItem">
      <xsl:with-param name="ParseIt" select="$PRS_NAME"/>
      <xsl:with-param name="Item">NAME</xsl:with-param>
      <xsl:with-param name="Value1" select="sxml:NAME"/>
     </xsl:call-template>
     <xsl:call-template name="AddParseItem">
      <xsl:with-param name="ParseIt" select="$PRS_CLAUSE_TYPE"/>
      <xsl:with-param name="Item">CLAUSE_TYPE</xsl:with-param>
      <xsl:with-param name="Value1">PHYSICAL_ATTRIBUTES</xsl:with-param>
      <xsl:with-param name="Value2">MAPPING</xsl:with-param>
     </xsl:call-template>
    </xsl:element>
   </xsl:when>
   <xsl:when test="$Action='SQL'">
    <xsl:element name="SQL_LIST">
     <xsl:element name="SQL_LIST_ITEM">
      <xsl:element name="TEXT">
       <xsl:text>ALTER TABLE </xsl:text>
       <xsl:call-template name="SchemaName">
        <xsl:with-param name="ParentNode" select="$TableNode"/>
       </xsl:call-template>
       <xsl:choose>
        <xsl:when test="$ParentNode/sxml:MAPPING_TABLE/@src='1'">
         <xsl:text> MOVE NOMAPPING </xsl:text>
        </xsl:when>
        <xsl:when test="$ParentNode/sxml:MAPPING_TABLE/@src='2'">
         <xsl:text> MOVE MAPPING TABLE </xsl:text>
        </xsl:when>
       </xsl:choose>
      </xsl:element>
     </xsl:element>
    </xsl:element>
   </xsl:when>
  </xsl:choose>
 </xsl:template>
 <xsl:template name="DoPCTthreshold">
  <xsl:param name="ParentNode" select="''"/>
  <xsl:param name="TableNode" select="''"/>
  <xsl:param name="ObjType" select="'TABLE'"/>
  <!-- *******************************************************************
Template: DoPCTthreshold 
Parameters:
 ParentNode - sxml:INDEX_ORGANIZED_TABLE
******************************************************************** -->
  <xsl:if test="$ParentNode/sxml:PCTTHRESHOLD/@src='2' 
		     or $ParentNode/sxml:PCTTHRESHOLD/@value1">
   <xsl:element name="ALTER_LIST_ITEM">
    <xsl:call-template name="PCTthreshold">
     <xsl:with-param name="TableNode" select="$TableNode"/>
     <xsl:with-param name="ParentNode" select="$ParentNode"/>
     <xsl:with-param name="ObjType" select="$ObjType"/>
     <xsl:with-param name="Action">PARSE</xsl:with-param>
    </xsl:call-template>
    <xsl:call-template name="PCTthreshold">
     <xsl:with-param name="TableNode" select="$TableNode"/>
     <xsl:with-param name="ParentNode" select="$ParentNode"/>
     <xsl:with-param name="ObjType" select="$ObjType"/>
     <xsl:with-param name="Action">SQL</xsl:with-param>
    </xsl:call-template>
   </xsl:element>
  </xsl:if>
 </xsl:template>
 <xsl:template name="PCTthreshold">
  <xsl:param name="ParentNode" select="''"/>
  <xsl:param name="TableNode" select="''"/>
  <xsl:param name="ObjType" select="'TABLE'"/>
  <xsl:param name="Action" select="''"/>
  <!-- *******************************************************************
Template: PCTthreshold 
Parameters:
 ParentNode - sxml:INDEX_ORGANIZED_TABLE
******************************************************************** -->
  <xsl:choose>
   <xsl:when test="$Action='PARSE' and ($PRS_NAME=1 or 
                                        $PRS_CLAUSE_TYPE=1 or
                                        $PRS_COLUMN_ATTRIBUTE=1 or
                                        $PRS_ALTERABLE=1 or
                                        $PRS_XPATH=1)">
    <xsl:element name="PARSE_LIST">
     <xsl:call-template name="AddXPathParseItem">
      <xsl:with-param name="Node" select="$ParentNode"/>
     </xsl:call-template>
     <xsl:call-template name="AddParseItem">
      <xsl:with-param name="ParseIt" select="$PRS_NAME"/>
      <xsl:with-param name="Item">NAME</xsl:with-param>
      <xsl:with-param name="Value1" select="$TableNode/sxml:NAME"/>
     </xsl:call-template>
     <xsl:call-template name="AddParseItem">
      <xsl:with-param name="ParseIt" select="$PRS_CLAUSE_TYPE"/>
      <xsl:with-param name="Item">CLAUSE_TYPE</xsl:with-param>
      <xsl:with-param name="Value1">PHYSICAL_ATTRIBUTES</xsl:with-param>
      <xsl:with-param name="Value2">PCTTHRESHOLD</xsl:with-param>
     </xsl:call-template>
    </xsl:element>
   </xsl:when>
   <xsl:when test="$Action='SQL'">
    <xsl:element name="SQL_LIST">
     <xsl:element name="SQL_LIST_ITEM">
      <xsl:element name="TEXT">
       <xsl:choose>
        <xsl:when test="$ObjType='TABLE'">
         <xsl:text>ALTER TABLE </xsl:text>
        </xsl:when>
        <xsl:when test="$ObjType='MATERIALIZED_VIEW'">
         <xsl:text>ALTER MATERIALIZED VIEW </xsl:text>
        </xsl:when>
       </xsl:choose>
       <xsl:call-template name="SchemaName">
        <xsl:with-param name="ParentNode" select="$TableNode"/>
       </xsl:call-template>
       <xsl:choose>
        <xsl:when test="$ParentNode/sxml:PCTTHRESHOLD/@src='1'">
         <xsl:text> PCTTHRESHOLD 0  </xsl:text>
         <!-- assume 0 is default value -->
        </xsl:when>
        <xsl:when test="$ParentNode/sxml:PCTTHRESHOLD/@src='2' 
	     or $ParentNode/sxml:PCTTHRESHOLD/@value1">
         <xsl:text> PCTTHRESHOLD </xsl:text>
         <xsl:value-of select="$ParentNode/sxml:PCTTHRESHOLD"/>
        </xsl:when>
        <xsl:otherwise/>
       </xsl:choose>
      </xsl:element>
     </xsl:element>
    </xsl:element>
   </xsl:when>
  </xsl:choose>
 </xsl:template>
 <xsl:template name="DoKeyCompress">
  <xsl:param name="ParentNode" select="''"/>
  <xsl:param name="TableNode" select="''"/>
  <xsl:param name="ObjType" select="'TABLE'"/>
  <!--*******************************************************************
Template: DoKeyCompress
Parameters:
 ParentNode - sxml:INDEX_ORGANIZED_TABLE
******************************************************************** -->
  <xsl:if test="$ParentNode/sxml:KEYCOMPRESS/@src!='1'
		     or $ParentNode/sxml:KEYCOMPRESS/@value1">
   <xsl:choose>
    <xsl:when test="$ObjType='MATERIALIZED_VIEW'">
     <xsl:call-template name="CommonNotAlterable">
      <xsl:with-param name="XpathNode" select="$ParentNode/sxml:KEYCOMPRESS"/>
      <xsl:with-param name="NameNode" select="$TableNode/sxml:NAME"/>
      <xsl:with-param name="Reason">MV_KEYCOMPRESS</xsl:with-param>
      <xsl:with-param name="Message" select="$MSG_MV_KEYCOMPRESS"/>
     </xsl:call-template>
    </xsl:when>
    <xsl:otherwise>
     <xsl:element name="ALTER_LIST_ITEM">
      <xsl:call-template name="KeyCompress">
       <xsl:with-param name="TableNode" select="$TableNode"/>
       <xsl:with-param name="ParentNode" select="$ParentNode"/>
       <xsl:with-param name="ObjType" select="$ObjType"/>
       <xsl:with-param name="Action">PARSE</xsl:with-param>
      </xsl:call-template>
      <xsl:call-template name="KeyCompress">
       <xsl:with-param name="TableNode" select="$TableNode"/>
       <xsl:with-param name="ParentNode" select="$ParentNode"/>
       <xsl:with-param name="ObjType" select="$ObjType"/>
       <xsl:with-param name="Action">SQL</xsl:with-param>
      </xsl:call-template>
     </xsl:element>
    </xsl:otherwise>
   </xsl:choose>
  </xsl:if>
 </xsl:template>
 <xsl:template name="KeyCompress">
  <xsl:param name="ParentNode" select="''"/>
  <xsl:param name="TableNode" select="''"/>
  <xsl:param name="ObjType" select="'TABLE'"/>
  <xsl:param name="Action" select="''"/>
  <!-- *******************************************************************
Template: KeyCompress
Parameters:
 ParentNode - sxml:INDEX_ORGANIZED_TABLE
******************************************************************** -->
  <xsl:choose>
   <xsl:when test="$Action='PARSE' and ($PRS_NAME=1 or 
                                        $PRS_CLAUSE_TYPE=1 or
                                        $PRS_COLUMN_ATTRIBUTE=1 or
                                        $PRS_ALTERABLE=1 or
                                        $PRS_XPATH=1)">
    <xsl:element name="PARSE_LIST">
     <xsl:call-template name="AddXPathParseItem">
      <xsl:with-param name="Node" select="$ParentNode"/>
     </xsl:call-template>
     <xsl:call-template name="AddParseItem">
      <xsl:with-param name="ParseIt" select="$PRS_NAME"/>
      <xsl:with-param name="Item">NAME</xsl:with-param>
      <xsl:with-param name="Value1" select="$TableNode/sxml:NAME"/>
     </xsl:call-template>
     <xsl:call-template name="AddParseItem">
      <xsl:with-param name="ParseIt" select="$PRS_CLAUSE_TYPE"/>
      <xsl:with-param name="Item">CLAUSE_TYPE</xsl:with-param>
      <xsl:with-param name="Value1">PHYSICAL_ATTRIBUTES</xsl:with-param>
      <xsl:with-param name="Value2">KEYCOMPRESS</xsl:with-param>
     </xsl:call-template>
    </xsl:element>
   </xsl:when>
   <xsl:when test="$Action='SQL'">
    <xsl:element name="SQL_LIST">
     <xsl:element name="SQL_LIST_ITEM">
      <xsl:element name="TEXT">
       <xsl:text>ALTER TABLE </xsl:text>
       <xsl:call-template name="SchemaName">
        <xsl:with-param name="ParentNode" select="$TableNode"/>
       </xsl:call-template>
       <xsl:call-template name="AlterKeyCompress">
        <xsl:with-param name="ParentNode" select="$ParentNode"/>
       </xsl:call-template>
      </xsl:element>
     </xsl:element>
    </xsl:element>
   </xsl:when>
  </xsl:choose>
 </xsl:template>
 <xsl:template name="AlterKeyCompress">
  <xsl:param name="ParentNode" select="''"/>
  <!-- *******************************************************************
Template: AlterKeyCompress - index key compression
Parameters:
 ParentNode -  sxml:INDEX_ORGANIZED_TABLE
******************************************************************** -->
  <xsl:choose>
   <xsl:when test="$ParentNode/sxml:KEYCOMPRESS[@value1] or $ParentNode/sxml:KEYCOMPRESS/@src='2'">
    <xsl:choose>
     <xsl:when test="$ParentNode/sxml:KEYCOMPRESS='N'"> NOCOMPRESS </xsl:when>
     <xsl:otherwise>
      <xsl:text> MOVE COMPRESS </xsl:text>
      <xsl:value-of select="$ParentNode/sxml:KEYCOMPRESS"/>
     </xsl:otherwise>
    </xsl:choose>
   </xsl:when>
   <xsl:when test="$ParentNode/sxml:KEYCOMPRESS/@src='1'"> NOCOMPRESS </xsl:when>
  </xsl:choose>
 </xsl:template>
 <xsl:template name="DoOverFlow">
  <xsl:param name="ParentNode" select="''"/>
  <xsl:param name="TableNode" select="''"/>
  <xsl:param name="ListNode" select="''"/>
  <xsl:param name="ObjType" select="'TABLE'"/>
  <!-- *******************************************************************
Template: DoOverFlow 
Parameters:
 ParentNode - :INDEX_ORGANIZED_TABLE 
******************************************************************** -->
  <xsl:if test="$ParentNode/sxml:OVERFLOW/@src or
   $ParentNode/sxml:OVERFLOW/sxml:SEGMENT_ATTRIBUTES//@value1">
   <xsl:choose>
    <xsl:when test="$ParentNode/sxml:OVERFLOW/@src='1'">
     <xsl:call-template name="CommonNotAlterable">
      <xsl:with-param name="XpathNode" select="$ParentNode/sxml:OVERFLOW"/>
      <xsl:with-param name="NameNode" select="$TableNode/sxml:NAME"/>
      <xsl:with-param name="Reason">DROP_OVERFLOW</xsl:with-param>
      <xsl:with-param name="Message" select="$MSG_DROP_OVERFLOW"/>
     </xsl:call-template>
    </xsl:when>
    <xsl:otherwise>
     <xsl:if test="$ParentNode/sxml:OVERFLOW/sxml:SEGMENT_ATTRIBUTES/sxml:TABLESPACE/@value1">
      <xsl:call-template name="CommonNotAlterable">
       <xsl:with-param name="XpathNode" select="$ParentNode/sxml:OVERFLOW/sxml:SEGMENT_ATTRIBUTES/sxml:TABLESPACE"/>
       <xsl:with-param name="NameNode" select="$TableNode/sxml:NAME"/>
       <xsl:with-param name="Reason">OVERFLOW_TABLESPACE</xsl:with-param>
       <xsl:with-param name="Message" select="$MSG_OVERFLOW_TABLESPACE"/>
      </xsl:call-template>
     </xsl:if>
     <xsl:variable name="DoAll">
      <xsl:choose>
       <xsl:when test="$ParentNode/sxml:OVERFLOW/@src='2'">ADD</xsl:when>
      </xsl:choose>
     </xsl:variable>
     <xsl:element name="ALTER_LIST_ITEM">
      <xsl:call-template name="OverFlow">
       <xsl:with-param name="TableNode" select="$TableNode"/>
       <xsl:with-param name="ParentNode" select="$ParentNode"/>
       <xsl:with-param name="ListNode" select="$ListNode"/>
       <xsl:with-param name="ObjType" select="$ObjType"/>
       <xsl:with-param name="DoAll" select="$DoAll"/>
       <xsl:with-param name="Action">PARSE</xsl:with-param>
      </xsl:call-template>
      <xsl:call-template name="OverFlow">
       <xsl:with-param name="TableNode" select="$TableNode"/>
       <xsl:with-param name="ParentNode" select="$ParentNode"/>
       <xsl:with-param name="ListNode" select="$ListNode"/>
       <xsl:with-param name="ObjType" select="$ObjType"/>
       <xsl:with-param name="DoAll" select="$DoAll"/>
       <xsl:with-param name="Action">SQL</xsl:with-param>
      </xsl:call-template>
     </xsl:element>
    </xsl:otherwise>
   </xsl:choose>
  </xsl:if>
 </xsl:template>
 <xsl:template name="OverFlow">
  <xsl:param name="ParentNode" select="''"/>
  <xsl:param name="TableNode" select="''"/>
  <xsl:param name="ListNode" select="''"/>
  <xsl:param name="DoAll" select="''"/>
  <xsl:param name="ObjType" select="'TABLE'"/>
  <xsl:param name="Action" select="''"/>
  <!-- *******************************************************************
Template: OverFlow 
Parameters:
 ParentNode - :INDEX_ORGANIZED_TABLE 
******************************************************************** -->
  <xsl:choose>
   <xsl:when test="$Action='PARSE' and ($PRS_NAME=1 or 
                                        $PRS_CLAUSE_TYPE=1 or
					$PRS_CONSTRAINT_TYPE=1 or
					$PRS_CONSTRAINT_STATE=1 or
                                        $PRS_ALTERABLE=1 or
                                        $PRS_XPATH=1)">
    <xsl:element name="PARSE_LIST">
     <xsl:call-template name="AddXPathParseItem">
      <xsl:with-param name="Node" select="$ParentNode"/>
     </xsl:call-template>
     <xsl:call-template name="AddParseItem">
      <xsl:with-param name="ParseIt" select="$PRS_NAME"/>
      <xsl:with-param name="Item">NAME</xsl:with-param>
      <xsl:with-param name="Value1" select="$TableNode/sxml:NAME"/>
     </xsl:call-template>
     <xsl:call-template name="AddParseItem">
      <xsl:with-param name="ParseIt" select="$PRS_CLAUSE_TYPE"/>
      <xsl:with-param name="Item">CLAUSE_TYPE</xsl:with-param>
      <xsl:with-param name="Value1">
       <xsl:choose>
        <xsl:when test="$DoAll='ADD'">ADD_OVERFLOW</xsl:when>
        <xsl:otherwise>ALTER_OVERFLOW</xsl:otherwise>
       </xsl:choose>
      </xsl:with-param>
     </xsl:call-template>
     <xsl:call-template name="AddParseItem">
      <xsl:with-param name="ParseIt" select="$PRS_COLUMN_ATTRIBUTE"/>
      <xsl:with-param name="Item">OVERFLOW CLAUSE</xsl:with-param>
      <xsl:with-param name="Value1">
       <xsl:if test="$ParentNode/sxml:OVERFLOW/sxml:SEGMENT_ATTRIBUTES/sxml:PCTFREE/@value1"> PCTFREE</xsl:if>
      </xsl:with-param>
      <xsl:with-param name="Value2">
       <xsl:if test="$ParentNode/sxml:OVERFLOW/sxml:SEGMENT_ATTRIBUTES/sxml:PCTUSED/@value1"> PCTUSED</xsl:if>
      </xsl:with-param>
      <xsl:with-param name="Value3">
       <xsl:if test="$ParentNode/sxml:OVERFLOW/sxml:SEGMENT_ATTRIBUTES/sxml:INITRANS/@value1"> INITRANS</xsl:if>
      </xsl:with-param>
      <xsl:with-param name="Value4">
       <xsl:if test="$ParentNode/sxml:OVERFLOW/sxml:SEGMENT_ATTRIBUTES/sxml:INITRANS/@value1"> INCLUDING COLUMN</xsl:if>
      </xsl:with-param>
     </xsl:call-template>
    </xsl:element>
   </xsl:when>
   <xsl:when test="$Action='SQL'">
    <xsl:choose>
     <xsl:when test="$ParentNode/sxml:OVERFLOW/@src='2'">
      <!-- including -->
      <xsl:element name="SQL_LIST">
       <xsl:element name="SQL_LIST_ITEM">
        <xsl:element name="TEXT">
         <xsl:choose>
          <xsl:when test="$ObjType='TABLE'">
           <xsl:text>ALTER TABLE </xsl:text>
          </xsl:when>
          <xsl:when test="$ObjType='MATERIALIZED_VIEW'">
           <xsl:text>ALTER MATERIALIZED VIEW </xsl:text>
          </xsl:when>
         </xsl:choose>
         <xsl:call-template name="SchemaName">
          <xsl:with-param name="ParentNode" select="$TableNode"/>
         </xsl:call-template>
         <xsl:text> ADD OVERFLOW </xsl:text>
         <!-- Segment_Attributes -->
         <xsl:call-template name="AlterSegmentAttributes">
          <xsl:with-param name="ParentNode" select="$ParentNode/sxml:OVERFLOW/sxml:SEGMENT_ATTRIBUTES"/>
          <xsl:with-param name="TypeNode" select="'ADD'"/>
         </xsl:call-template>
         <xsl:if test="$ListNode">
          <xsl:call-template name="PartitionList">
           <xsl:with-param name="ParentNode" select="$ListNode"/>
          </xsl:call-template>
         </xsl:if>
        </xsl:element>
       </xsl:element>
       <xsl:if test="$ParentNode/sxml:OVERFLOW/sxml:INCLUDING">
        <xsl:element name="SQL_LIST_ITEM">
         <xsl:element name="TEXT">
          <xsl:choose>
           <xsl:when test="$ObjType='TABLE'">
            <xsl:text>ALTER TABLE </xsl:text>
           </xsl:when>
           <xsl:when test="$ObjType='MATERIALIZED_VIEW'">
            <xsl:text>ALTER MATERIALIZED VIEW </xsl:text>
           </xsl:when>
          </xsl:choose>
          <xsl:call-template name="SchemaName">
           <xsl:with-param name="ParentNode" select="$TableNode"/>
          </xsl:call-template>
          <xsl:text> INCLUDING </xsl:text>
          <xsl:value-of select="$ParentNode/sxml:OVERFLOW/sxml:INCLUDING"/>
         </xsl:element>
        </xsl:element>
       </xsl:if>
      </xsl:element>
     </xsl:when>
     <xsl:otherwise>
      <!-- there are some diffs  -->
      <xsl:element name="SQL_LIST">
       <xsl:if test="$ParentNode/sxml:OVERFLOW/sxml:SEGMENT_ATTRIBUTES/sxml:PCTFREE/@value1 or
$ParentNode/sxml:OVERFLOW/sxml:SEGMENT_ATTRIBUTES/sxml:PCTUSED/@value1 or
$ParentNode/sxml:OVERFLOW/sxml:SEGMENT_ATTRIBUTES/sxml:INITRANS/@value1">
        <xsl:element name="SQL_LIST_ITEM">
         <xsl:element name="TEXT">
          <xsl:choose>
           <xsl:when test="$ObjType='TABLE'">
            <xsl:text>ALTER TABLE </xsl:text>
           </xsl:when>
           <xsl:when test="$ObjType='MATERIALIZED_VIEW'">
            <xsl:text>ALTER MATERIALIZED VIEW </xsl:text>
           </xsl:when>
          </xsl:choose>
          <xsl:call-template name="SchemaName">
           <xsl:with-param name="ParentNode" select="$TableNode"/>
          </xsl:call-template>
          <xsl:text> OVERFLOW </xsl:text>
          <!-- Physical_Attributes -->
          <xsl:call-template name="AlterPhysicalAttributes">
           <xsl:with-param name="ParentNode" select="$ParentNode/sxml:OVERFLOW/sxml:SEGMENT_ATTRIBUTES"/>
          </xsl:call-template>
          <!-- Tablespace can not be altered -->
          <!-- logging_clause -->
          <xsl:call-template name="AlterLogging">
           <xsl:with-param name="ParentNode" select="$ParentNode/sxml:OVERFLOW/sxml:SEGMENT_ATTRIBUTES"/>
          </xsl:call-template>
         </xsl:element>
        </xsl:element>
       </xsl:if>
       <xsl:if test="$ParentNode/sxml:OVERFLOW/sxml:INCLUDING/@value1 or
                       $ParentNode/sxml:OVERFLOW/sxml:INCLUDING/@src='2'">
        <xsl:element name="SQL_LIST_ITEM">
         <xsl:element name="TEXT">
          <xsl:choose>
           <xsl:when test="$ObjType='TABLE'">
            <xsl:text>ALTER TABLE </xsl:text>
           </xsl:when>
           <xsl:when test="$ObjType='MATERIALIZED_VIEW'">
            <xsl:text>ALTER MATERIALIZED VIEW </xsl:text>
           </xsl:when>
          </xsl:choose>
          <xsl:call-template name="SchemaName">
           <xsl:with-param name="ParentNode" select="$TableNode"/>
          </xsl:call-template>
          <xsl:text> INCLUDING </xsl:text>
          <xsl:value-of select="$ParentNode/sxml:OVERFLOW/sxml:INCLUDING"/>
         </xsl:element>
        </xsl:element>
       </xsl:if>
      </xsl:element>
     </xsl:otherwise>
    </xsl:choose>
   </xsl:when>
  </xsl:choose>
 </xsl:template>
 <xsl:template name="PartitionList">
  <xsl:param name="ParentNode" select="''"/>
  <!-- *******************************************************************
Template: PartitionList
ParentNode:sxml:PARTITION_LIST 
******************************************************************** -->
  <xsl:for-each select="$ParentNode/sxml:PARTITION_LIST_ITEM">
   <xsl:if test="sxml:PHYSICAL_PROPERTIES/sxml:INDEX_ORGANIZED_TABLE/sxml:OVERFLOW/sxml:SEGMENT_ATTRIBUTES/sxml:TABLESPACE">
    <xsl:if test="position()=1">
     <xsl:text>(</xsl:text>
    </xsl:if>
    <xsl:text> PARTITION </xsl:text>
    <!-- Segment_Attributes -->
    <xsl:call-template name="AlterSegmentAttributes">
     <xsl:with-param name="ParentNode" select="sxml:PHYSICAL_PROPERTIES/sxml:INDEX_ORGANIZED_TABLE/sxml:OVERFLOW/sxml:SEGMENT_ATTRIBUTES"/>
    </xsl:call-template>
    <xsl:if test="position()!=last()">
     <xsl:text>,</xsl:text>
    </xsl:if>
    <xsl:if test="position()=last()">
     <xsl:text>) </xsl:text>
    </xsl:if>
   </xsl:if>
  </xsl:for-each>
 </xsl:template>
 <xsl:template match="sxml:PCTFREE | sxml:PCTUSED | sxml:INITRANS |
                     sxml:INITIAL | sxml:NEXT | sxml:MINEXTENTS |
                     sxml:MAXEXTENTS | sxml:PCTINCREASE | sxml:FREELISTS |
                     sxml:FREELIST_GROUPS| 
		     sxml:LOBRETENTION|
		     sxml:MAXSIZE | sxml:BUFFER_POOL | sxml:FLASH_CACHE | sxml:CELL_FLASH_CACHE |
                     sxml:TABLESPACE | sxml:PCTTHRESHOLD | sxml:COMPRESS |
                     sxml:INCLUDING | sxml:DEFAULT_DIRECTORY |
                     sxml:REJECT_LIMIT | sxml:RETURN_AS | sxml:STORE_AS |
                     sxml:CHUNK | sxml:PCTVERSION">
  <!-- *******************************************************************
Template: PCTFREE, PCTUSED, INITRANS,
          INITIAL, NEXT, MINEXTENTS, MAXEXTENTS, PCTINCREASE, FREELISTS,
          FREELIST_GROUPS, LOBRETENTION, MAXSIZE, BUFFER_POOL, FLASH_CACHE, CELL_FLASH_CACHE
	  TABLESPACE, PCTTHRESHOLD,
          COMPRESS, INCLUDING, DEFAULT_DIRECTORY, REJECT_LIMIT,
          RETURN_AS, STORE_AS, CHUNK, PCTVERSION
******************************************************************** -->
  <xsl:text> </xsl:text>
  <xsl:choose>
   <xsl:when test="local-name(.)='FREELIST_GROUPS'">FREELIST GROUPS </xsl:when>
   <xsl:when test="local-name(.)='DEFAULT_DIRECTORY'">DEFAULT DIRECTORY "</xsl:when>
   <xsl:when test="local-name(.)='REJECT_LIMIT'">REJECT LIMIT </xsl:when>
   <xsl:when test="local-name(.)='RETURN_AS'">RETURN AS </xsl:when>
   <xsl:when test="local-name(.)='STORE_AS'">STORE AS </xsl:when>
   <xsl:otherwise>
    <xsl:value-of select="local-name(.)"/>
    <xsl:text> </xsl:text>
   </xsl:otherwise>
  </xsl:choose>
  <xsl:if test="local-name(.)='TABLESPACE'">"</xsl:if>
  <xsl:if test="local-name(.)='INCLUDING'">"</xsl:if>
  <xsl:value-of select="."/>
  <xsl:if test="local-name(.)='TABLESPACE'">"</xsl:if>
  <xsl:if test="local-name(.)='INCLUDING'">"</xsl:if>
  <xsl:if test="local-name(.)='DEFAULT_DIRECTORY'">"</xsl:if>
 </xsl:template>
 <xsl:template match="sxml:LOGGING">
  <!-- *******************************************************************
Template: LOGGING
******************************************************************** -->
  <xsl:choose>
   <xsl:when test=".='Y'"> LOGGING</xsl:when>
   <xsl:when test=".='N'"> NOLOGGING</xsl:when>
  </xsl:choose>
 </xsl:template>
</xsl:stylesheet>
