<?xml version="1.0"?>
<!--

 Copyright (c) 2006, 2010, Oracle and/or its affiliates. All rights reserved. 

NAME
    kuaview.xsl
DESCRIPTION
    Convert sxml VIEW diff document to ALTER_XML document

MODIFIED        MM/DD/YY
    lbarton     07/24/09 - bug 8342311: view subquery restriction clause
    rapayne     06/09/06 - Initial version
 -->
<xsl:stylesheet version="1.0" xmlns:sxml="http://xmlns.oracle.com/ku" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
 <!-- Top level imports -->
 <xsl:import href="kuacomm.xsl"/>
 <!-- Templates -->
 <xsl:template match="sxml:VIEW">
  <!-- *******************************************************************
Template: VIEW - top-level template for views.
******************************************************************** -->
  <xsl:element name="ALTER_XML">
   <xsl:attribute name="xmlns">http://xmlns.oracle.com/ku</xsl:attribute>
   <xsl:attribute name="version">1.0</xsl:attribute>
   <!-- Object type -->
   <xsl:element name="OBJECT_TYPE">VIEW</xsl:element>
   <!-- Display schema.objname for CoMPareObjects 1 and 2  -->
   <xsl:call-template name="CmpObjects">
    <xsl:with-param name="ParentNode" select="."/>
   </xsl:call-template>
   <!-- Alter list -->
   <xsl:element name="ALTER_LIST">
    <!--check if index is alterable  -->
    <xsl:call-template name="checkAlterable">
     <xsl:with-param name="ParentNode" select="."/>
    </xsl:call-template>
    <!--check for restriction changes -->
    <xsl:call-template name="checkRestriction">
     <xsl:with-param name="ParentNode" select="."/>
    </xsl:call-template>
    <!-- view name rename (the last thing we do) -->
    <xsl:call-template name="RenameView">
     <xsl:with-param name="ParentNode" select="."/>
    </xsl:call-template>
   </xsl:element>
  </xsl:element>
 </xsl:template>
 <xsl:template name="checkAlterable">
  <xsl:param name="ParentNode" select="''"/>
  <!-- *******************************************************************
Template: checkAlterable - Detects certain non-alterable cases
 1. View NAME change
 2. COL_LIST diffs
 3. SUBQUERY diffs
Parameters:
 ParentNode - Parent node of SCHEMA, NAME
 Action = "PARSE"
******************************************************************** -->
  <!-- Check for COL_LIST  difference -->
  <xsl:for-each select="$ParentNode/sxml:COL_LIST/sxml:COL_LIST_ITEM">
   <xsl:if test="./@src or sxml:NAME/@value1">
    <xsl:call-template name="CommonNotAlterable">
     <xsl:with-param name="XpathNode" select="."/>
     <xsl:with-param name="NameNode">
     <xsl:choose>
      <xsl:when test="sxml:NAME/@value1">
       <xsl:value-of select="sxml:NAME/@value1"/>
      </xsl:when>
      <xsl:otherwise>
       <xsl:value-of select="sxml:NAME"/>
      </xsl:otherwise>
     </xsl:choose>
     </xsl:with-param>
     <xsl:with-param name="Reason">VIEW_ATTRIBUTE</xsl:with-param>
     <xsl:with-param name="Message" select="$MSG_VIEW_ATTRIBUTE"/>
     <xsl:with-param name="Subst">COLUMN LIST</xsl:with-param>
    </xsl:call-template>
   </xsl:if>
  </xsl:for-each>
  <!-- Check for SUBQUERY differences -->
  <xsl:if test="$ParentNode/sxml:SUBQUERY/@value1">
   <xsl:call-template name="CommonNotAlterable">
    <xsl:with-param name="XpathNode" select="$ParentNode/sxml:SUBQUERY"/>
    <xsl:with-param name="NameNode" select="$ParentNode/sxml:NAME"/>
    <xsl:with-param name="Reason">VIEW_ATTRIBUTE</xsl:with-param>
    <xsl:with-param name="Message" select="$MSG_VIEW_ATTRIBUTE"/>
    <xsl:with-param name="Subst">SUBQUERY</xsl:with-param>
   </xsl:call-template>
  </xsl:if>
 </xsl:template>
 <xsl:template name="checkRestriction">
  <xsl:param name="ParentNode" select="''"/>
  <!-- *******************************************************************
Template: checkRestriction - look for diffs in RESTRICTION
       The only valid case is altering to/from read_only for an editioning view
Parameters:
 ParentNode - Parent node of SCHEMA, NAME
******************************************************************** -->
  <xsl:if test="$ParentNode/sxml:RESTRICTION//@src">
   <xsl:choose>
    <xsl:when test="($ParentNode/sxml:RESTRICTION[@src]/sxml:READ_ONLY or $ParentNode/sxml:RESTRICTION/sxml:READ_ONLY/@src) and not ($ParentNode/sxml:RESTRICTION/sxml:CHECK_OPTION)">
     <xsl:call-template name="checkReadOnly">
      <xsl:with-param name="ParentNode" select="$ParentNode"/>
     </xsl:call-template>
    </xsl:when>
    <xsl:otherwise>
     <xsl:call-template name="CommonNotAlterable">
      <xsl:with-param name="XpathNode" select="$ParentNode/sxml:RESTRICTION"/>
      <xsl:with-param name="NameNode" select="$ParentNode/sxml:NAME"/>
      <xsl:with-param name="Reason">VIEW_ATTRIBUTE</xsl:with-param>
      <xsl:with-param name="Message" select="$MSG_VIEW_ATTRIBUTE"/>
      <xsl:with-param name="Subst">RESTRICTION</xsl:with-param>
     </xsl:call-template>
    </xsl:otherwise>
   </xsl:choose>
  </xsl:if>
 </xsl:template>
 <xsl:template name="checkReadOnly">
  <xsl:param name="ParentNode" select="''"/>
  <!-- *******************************************************************
Template: checkReadOnly- 
Parameters:
 ParentNode - Parent node of SCHEMA, NAME
******************************************************************** -->
  <xsl:if test="$ParentNode/sxml:RESTRICTION/@src or 
                $ParentNode/sxml:RESTRICTION/sxml:READ_ONLY/@src">
   <xsl:choose>
    <xsl:when test="$ParentNode/sxml:EDITIONING_VIEW">
     <xsl:element name="ALTER_LIST_ITEM">
      <xsl:call-template name="alterReadOnlyView">
       <xsl:with-param name="ParentNode" select="$ParentNode"/>
       <xsl:with-param name="Action">PARSE</xsl:with-param>
      </xsl:call-template>
      <xsl:call-template name="alterReadOnlyView">
       <xsl:with-param name="ParentNode" select="$ParentNode"/>
       <xsl:with-param name="Action">SQL</xsl:with-param>
      </xsl:call-template>
     </xsl:element>
    </xsl:when>
    <xsl:otherwise>
     <xsl:call-template name="CommonNotAlterable">
      <xsl:with-param name="XpathNode" select="$ParentNode/sxml:RESTRICTION"/>
      <xsl:with-param name="NameNode" select="$ParentNode/sxml:NAME"/>
      <xsl:with-param name="Reason">VIEW_ATTRIBUTE</xsl:with-param>
      <xsl:with-param name="Message" select="$MSG_VIEW_ATTRIBUTE"/>
      <xsl:with-param name="Subst">NOT EDITIONING VIEW</xsl:with-param>
     </xsl:call-template>
    </xsl:otherwise>
   </xsl:choose>
  </xsl:if>
 </xsl:template>
 <xsl:template name="alterReadOnlyView">
  <xsl:param name="ParentNode" select="''"/>
  <xsl:param name="Action" select="''"/>
  <!-- *******************************************************************
Template: alterReadOnlyView - only possible to alter EDITIONING VIEWS. 
      If READ_ONLY has been alter and not an editioning view then only
      a not alterable parse item is generated.
Parameters:
 ParentNode - Parent node of SCHEMA, NAME
 Action - PARSE or SQL
******************************************************************** -->
  <xsl:choose>
   <xsl:when test="$Action='PARSE' and ($PRS_NAME=1 or 
                                        $PRS_CLAUSE_TYPE=1 or
                                        $PRS_XPATH=1)">
    <xsl:element name="PARSE_LIST">
     <xsl:call-template name="AddXPathParseItem">
      <xsl:with-param name="Node" select="./sxml:RESTRICTION/sxml:READ_ONLY"/>
     </xsl:call-template>
     <xsl:choose>
      <xsl:when test="./sxml:RESTRICTION[@src='1']/sxml:READ_ONLY or ./sxml:RESTRICTION/sxml:READ_ONLY/@src='1'">
       <xsl:call-template name="AddParseItem">
        <xsl:with-param name="ParseIt" select="$PRS_CLAUSE_TYPE"/>
        <xsl:with-param name="Item">CLAUSE_TYPE</xsl:with-param>
        <xsl:with-param name="Value1">READ_WRITE</xsl:with-param>
       </xsl:call-template>
      </xsl:when>
      <xsl:otherwise>
       <xsl:call-template name="AddParseItem">
        <xsl:with-param name="ParseIt" select="$PRS_CLAUSE_TYPE"/>
        <xsl:with-param name="Item">CLAUSE_TYPE</xsl:with-param>
        <xsl:with-param name="Value1">READ_ONLY</xsl:with-param>
       </xsl:call-template>
      </xsl:otherwise>
     </xsl:choose>
    </xsl:element>
   </xsl:when>
   <xsl:when test="$Action='SQL'">
    <xsl:element name="SQL_LIST">
     <xsl:element name="SQL_LIST_ITEM">
      <xsl:element name="TEXT">
       <xsl:text>ALTER VIEW </xsl:text>
       <xsl:call-template name="SchemaName">
        <xsl:with-param name="ParentNode" select="$ParentNode"/>
       </xsl:call-template>
       <xsl:choose>
        <xsl:when test="./sxml:RESTRICTION[@src='1']/sxml:READ_ONLY or ./sxml:RESTRICTION/sxml:READ_ONLY/@src='1'"> READ WRITE </xsl:when>
        <xsl:otherwise> READ ONLY</xsl:otherwise>
       </xsl:choose>
      </xsl:element>
     </xsl:element>
    </xsl:element>
   </xsl:when>
  </xsl:choose>
 </xsl:template>
 <xsl:template name="RenameView">
  <xsl:param name="ParentNode" select="''"/>
  <!-- *******************************************************************
Template: RenameView
Parameters:
 ParentNode - Parent node of SCHEMA, NAME
******************************************************************** -->
  <xsl:if test="$ParentNode/sxml:NAME/@value1">
   <xsl:element name="ALTER_LIST_ITEM">
    <xsl:if test="$PRS_NAME=1 or 
                  $PRS_CLAUSE_TYPE=1 or
                  $PRS_XPATH=1">
     <xsl:element name="PARSE_LIST">
      <xsl:call-template name="AddXPathParseItem">
       <xsl:with-param name="Node" select="$ParentNode"/>
      </xsl:call-template>
      <xsl:call-template name="AddParseItem">
       <xsl:with-param name="ParseIt" select="$PRS_NAME"/>
       <xsl:with-param name="Item">NAME</xsl:with-param>
       <xsl:with-param name="Value1" select="$ParentNode/sxml:NAME/@value1"/>
      </xsl:call-template>
      <xsl:call-template name="AddParseItem">
       <xsl:with-param name="ParseIt" select="$PRS_CLAUSE_TYPE"/>
       <xsl:with-param name="Item">CLAUSE_TYPE</xsl:with-param>
       <xsl:with-param name="Value1">RENAME_VIEW</xsl:with-param>
      </xsl:call-template>
     </xsl:element>
    </xsl:if>
    <xsl:element name="SQL_LIST">
     <xsl:element name="SQL_LIST_ITEM">
      <xsl:element name="TEXT">
       <xsl:text>RENAME </xsl:text>
       <xsl:call-template name="SourceName">
        <xsl:with-param name="NameNode" select="$ParentNode/sxml:NAME"/>
       </xsl:call-template>
       <xsl:text> TO </xsl:text>
       <xsl:call-template name="QuotedName">
        <xsl:with-param name="NameNode" select="sxml:NAME"/>
       </xsl:call-template>
      </xsl:element>
     </xsl:element>
    </xsl:element>
   </xsl:element>
  </xsl:if>
 </xsl:template>
</xsl:stylesheet>
