<?xml version="1.0"?>
<!-- 

 Copyright (c) 2000, 2010, Oracle and/or its affiliates. All rights reserved. 
NAME
    kuidxwrk.xsl
DESCRIPTION
    worker XSLT stylesheet for XML => DDL conversion of md$_index_t ADTs
NOTES
    Do NOT modify this file under any circumstance. Copy the file
    if you wish to use this stylesheet with an external XML/XSL parser

MODIFIED	MM/DD/YY
    lbarton     04/27/10 - bug 9650606: more dsc details
    lbarton     08/14/09 - bug 8795792: no compress/logging in deferred stg for
                           indexes
    dgagne      07/29/09 - add calls to patchdictionary
    rapayne     06/26/09 - bug 8664468/8592114 colname references to EXTRADATA
                           are not valid for index. Therefore, we force these to
                           OBJECT_VALUE.
    lbarton     03/19/09 - lrg 3762023: unusable index (sub)partitions and
                           transportable
    tbhukya     04/16/09 - Bug 8436781: NOSEGMENT for virtual index
    lbarton     02/26/09 - bug 8252494: more deferred segment creation
    rapayne     12/06/08 - merge BLOCKSIZE logic for CM
    lbarton     09/30/08 - bug 7334782 (again): more xmltype virtual columns
    lbarton     09/10/08 - bug 7362930: index (sub)partition UNUSABLE
    mjangir     06/10/08 - bug 7138608: dom idx partitions without parameters
    lbarton     11/26/07 - bug 6051635: null params on dom idx partitions
    lbarton     11/02/07 - bug 6605086: escape single quote
    htseng      06/15/07 - fix virtual column in DomainCol 
    htseng      04/10/07 - bug 5982584: domain indx column
    lbarton     10/23/06 - bug 5610872: composite domain indexes
    dgagne      05/23/06 - don't require transportable to departition an index 
    sdavidso    05/09/06 - support invisible index attribute 
    sdavidso    05/01/06 - support parameters in domain index partitions
    lbarton     01/27/06 - partition transportable 
    lbarton     11/02/05 - Bug 4715313: reformat files for use with XMLSpy 
    sdavidso    09/23/05 - support NOCPRESS for slected partitions 
    htseng      08/08/05 - bug 3560220: get correct behavior from processor 
    baleti      06/03/05 - Bug 4357181: Add RPKE clause 
    htseng      02/10/05 - bug 3483988 : index REVERSE 
    dgagne      06/29/04 - only compute index stats if no export transform 
    htseng      05/18/04 - bug 3635820: check index unusable status
    lbarton     05/11/04 - Bug 3617842: SAMPLE and PCTSPACE 
    lbarton     12/16/03 - COMPRESS with part. idx 
    lbarton     10/14/03 - lrg 1582938: sort join tables for reproduc. results
    lbarton     07/18/03 - Bug 3045926: restructure ku_procobj_lines
    htseng      06/13/03 - bug 3006177 : PL/SQL BEGIN/END block too big
    emagrath    06/06/03 - Correct index info for constraints
    lbarton     05/07/03 - bug 2944274: bitmap join indexes
    lbarton     05/05/03 - remove quotes in dbms_export_extension calls
    lbarton     04/10/03 - Bug 2883530: params for partitioned domain index
    lbarton     03/06/03 - bug 2832345: no RESET_PARALLEL if idx on temp table
    lbarton     12/10/02 - new types for procedural objects
    lbarton     10/21/02 - add PARALLEL, RESET_PARALLEL params
    lbarton     10/11/02 - new parse item: SYSTEM_GENERATED
    lbarton     08/02/02 - transportable export
    lbarton     04/30/02 - add EXPORT transform param
    lbarton     04/26/02 - domain index support
    lbarton     06/01/01 - remove oradb-style imports
    lbarton     10/24/00 - sort in views, not xsl
    gclaborn    10/30/00 - Add external imports; change name
    lbarton	10/05/00 - cluster index
    lbarton	09/27/00 - bugfix: sort columns on pos_num
    lbarton	07/24/00 - use uriref in import
    lbarton	06/23/00 - parsing for PL/SQL code
    lbarton	06/14/00 - add PRS_TABLESPACE
    lbarton	06/01/00 - support parsing
    lbarton	05/15/00 - Params for new API
    lbarton	04/03/00 - Creation
 -->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
 <!-- Import required scripts -->
 <xsl:import href="kucommon.xsl"/>
 <xsl:import href="kustorag.xsl"/>
 <xsl:import href="kuprtobj.xsl"/>
 <!-- Top-level parameters -->
 <xsl:param name="PARALLEL">-1</xsl:param>
 <xsl:param name="RESET_PARALLEL">0</xsl:param>
 <xsl:param name="PARTITION_NAME" select="''"/>
 <xsl:param name="SUBPARTITION_NAME" select="''"/>
 <xsl:param name="BASE_PARTITION_NAME" select="''"/>
 <xsl:param name="BASE_SUBPARTITION_NAME" select="''"/>
 <!-- Templates -->
 <xsl:template match="INDEX_T | IND">
  <xsl:param name="ConstraintIndex">0</xsl:param>
  <!-- *******************************************************************
Template: INDEX_T - top-level template for indexes.
           IND - indexes embedded in other types, e.g., constraints
 Parameters:
  ConstraintIndex:     0 - CREATE INDEX DDL statement
                       1 - CREATE INDEX clause in constraint
                       2 - only index attributes in constraint
******************************************************************** -->
  <xsl:if test="$ConstraintIndex=0">
   <!--
     Emit anonymous PLSQL blocks needed for export
 -->
   <xsl:if test="$EXPORT=1">
    <!-- insert secondary objects for domain indexes -->
    <xsl:apply-templates select="SECOBJS"/>
    <!-- emit the domain index PLSQL code (from ODCIIndexGetMetadata) -->
    <xsl:apply-templates select="PLSQL_CODE/PLSQL">
     <xsl:with-param name="Objecttype">INDEX</xsl:with-param>
    </xsl:apply-templates>
   </xsl:if>
   <!--
     Generate parse items
-->
   <xsl:if test="$PRS_TABLESPACE=1">
    <xsl:value-of select="$PRS_DELIM"/>
    <xsl:text>ATABLESPACE</xsl:text>
    <xsl:value-of select="$PRS_DELIM"/>
    <xsl:text>B</xsl:text>
    <xsl:choose>
     <xsl:when test="(PART_OBJ)">
      <xsl:value-of select="PART_OBJ/PARTOBJ/DEFTS_NAME"/>
     </xsl:when>
     <xsl:otherwise>
      <xsl:value-of select="TS_NAME"/>
     </xsl:otherwise>
    </xsl:choose>
   </xsl:if>
   <xsl:if test="$PRS_SYSTEM_GENERATED=1">
    <xsl:value-of select="$PRS_DELIM"/>
    <xsl:text>ASYSTEM_GENERATED</xsl:text>
    <xsl:value-of select="$PRS_DELIM"/>
    <xsl:text>E</xsl:text>
    <xsl:if test="(SCHEMA_OBJ/FLAGS mod 8)>=4">Y</xsl:if>
    <xsl:value-of select="$PRS_DELIM"/>
   </xsl:if>
   <xsl:call-template name="DoParse">
    <xsl:with-param name="Verb">CREATE</xsl:with-param>
    <xsl:with-param name="ObjectType">INDEX</xsl:with-param>
    <xsl:with-param name="SchemaNode" select="SCHEMA_OBJ/OWNER_NAME"/>
    <xsl:with-param name="NameNode" select="SCHEMA_OBJ/NAME"/>
   </xsl:call-template>
  </xsl:if>
  <!--
     do the CREATE INDEX statement
 -->
  <xsl:if test="$ConstraintIndex!=2">
   <xsl:choose>
    <!-- cluster index -->
    <xsl:when test="BASE_OBJ/TYPE_NUM=3">
     <xsl:text>CREATE INDEX </xsl:text>
     <xsl:apply-templates select="SCHEMA_OBJ"/>
     <xsl:text>ON CLUSTER </xsl:text>
     <xsl:apply-templates select="BASE_OBJ"/>
    </xsl:when>
    <!-- table index -->
    <xsl:otherwise>
     <xsl:text>CREATE </xsl:text>
     <xsl:choose>
      <xsl:when test="TYPE_NUM='2'">BITMAP </xsl:when>
      <xsl:when test="(PROPERTY mod 2)=1">UNIQUE </xsl:when>
     </xsl:choose>
     <xsl:text>INDEX </xsl:text>
     <xsl:apply-templates select="SCHEMA_OBJ"/>
     <xsl:text>ON </xsl:text>
     <xsl:apply-templates select="BASE_OBJ"/>
     <!--
    Generate the column list
        NOTE: we do our own COL_LIST processing,
       not the one in kucolumn.xsl
 -->
     <xsl:choose>
      <!-- domain index (type=9) -->
      <xsl:when test="TYPE_NUM=9">
       <xsl:call-template name="DomainCol">
        <xsl:with-param name="ColListNode" select="COL_LIST"/>
        <xsl:with-param name="IndProperty" select="PROPERTY"/>
       </xsl:call-template>
      </xsl:when>
      <!-- not domain index -->
      <xsl:otherwise>
       <xsl:call-template name="DoColList">
        <xsl:with-param name="ColListNode" select="COL_LIST"/>
        <xsl:with-param name="IndProperty" select="PROPERTY"/>
       </xsl:call-template>
      </xsl:otherwise>
     </xsl:choose>
    </xsl:otherwise>
   </xsl:choose>
  </xsl:if>
  <xsl:if test="(PROPERTY mod 8)>=4">REVERSE </xsl:if>
  <!--  Explicitly turn off RPKE optimization for transportable 
        tablespaces, if disabled on IOT sec index -->
  <xsl:if test="($TRANSPORTABLE=1 and
             ((PROPERTY mod 32768) &lt; 16384) 
             and ((FLAGS mod 256)>=128))">DISABLE_RPKE </xsl:if>
  <!-- if this is an index on a temporary table, skip segment attrs -->
  <xsl:if test="2>(BASE_OBJ/FLAGS mod 4)">
   <!-- if this is a bitmap join index, add the from-where clause -->
   <xsl:if test="(PROPERTY mod 2048)>=1024">
    <xsl:if test="$PRETTY=1">
     <xsl:text>&#xa;  </xsl:text>
    </xsl:if>
    <xsl:apply-templates select="JIJOIN_TABS"/>
    <xsl:if test="$PRETTY=1">
     <xsl:text>&#xa;  </xsl:text>
    </xsl:if>
    <xsl:apply-templates select="JIJOIN"/>
   </xsl:if>
   <xsl:if test="$ConstraintIndex!=2">
    <xsl:if test="$PRETTY=1">
     <xsl:text>&#xa;  </xsl:text>
    </xsl:if>
   </xsl:if>
   <!--
    Index Properties
-->
   <xsl:choose>
    <!-- domain index (type=9) -->
    <xsl:when test="TYPE_NUM=9">
     <xsl:call-template name="DomainIndexClause"/>
    </xsl:when>
    <xsl:otherwise>
     <!-- not domain index -->
     <xsl:choose>
      <!-- Partitioned index (both LOCAL and GLOBAL) -->
      <xsl:when test="(PART_OBJ)">
       <xsl:choose>
        <xsl:when test="PART_OBJ/PARTOBJ/PARTTYPE=1 and
                        (string-length($PARTITION_NAME)!=0 or
                         string-length($SUBPARTITION_NAME)!=0 or
                         string-length($BASE_PARTITION_NAME)!=0 or
                         string-length($BASE_SUBPARTITION_NAME)!=0)">
         <!-- convert (sub)partition of local partidx for partition tte -->
         <xsl:call-template name="CvtToNPIdx"/>
        </xsl:when>
        <xsl:otherwise>
         <xsl:call-template name="PartitionedIndexProperties"/>
        </xsl:otherwise>
       </xsl:choose>
      </xsl:when>
      <xsl:otherwise>
       <!-- non-partitioned -->
       <xsl:call-template name="IndexAttributes"/>
      </xsl:otherwise>
     </xsl:choose>
    </xsl:otherwise>
   </xsl:choose>
   <xsl:if test="$ConstraintIndex=0">
    <xsl:if test="$SEGMENT_ATTRIBUTES=1">
     <xsl:call-template name="DoParallel">
      <xsl:with-param name="ADT_type">INDEX</xsl:with-param>
      <xsl:with-param name="FlagsParent" select="current()"/>
      <xsl:with-param name="SetParallel" select="$PARALLEL"/>
     </xsl:call-template>
    </xsl:if>
   </xsl:if>
  </xsl:if>
  <xsl:if test="$ConstraintIndex=0">
   <!-- check INDEX if unusable -->
   <xsl:if test="(FLAGS mod 2)=1 and $TRANSPORTABLE=1">
    <xsl:text> UNUSABLE</xsl:text>
   </xsl:if>
   <!-- Terminate the SQL statement -->
   <xsl:if test="$SQLTERMINATOR=1">
    <xsl:text>;</xsl:text>
   </xsl:if>
   <!--
      Reset parallel if requested (but not if index is on temporary table) 
-->
   <xsl:if test="$RESET_PARALLEL!=0 and 2>(BASE_OBJ/FLAGS mod 4)">
    <xsl:call-template name="DoParse">
     <xsl:with-param name="Verb">ALTER</xsl:with-param>
     <xsl:with-param name="ObjectType">INDEX</xsl:with-param>
     <xsl:with-param name="SchemaNode" select="SCHEMA_OBJ/OWNER_NAME"/>
     <xsl:with-param name="NameNode" select="SCHEMA_OBJ/NAME"/>
    </xsl:call-template>
    <xsl:if test="$PRETTY=1">
     <xsl:text>&#xa; </xsl:text>
    </xsl:if>
    <xsl:text> ALTER INDEX </xsl:text>
    <xsl:apply-templates select="SCHEMA_OBJ"/>
    <xsl:choose>
     <xsl:when test="DEGREE">
      <xsl:text>PARALLEL </xsl:text>
      <xsl:if test="32767>DEGREE">
       <xsl:value-of select="DEGREE"/>
      </xsl:if>
     </xsl:when>
     <xsl:otherwise>
      <xsl:text>NOPARALLEL</xsl:text>
     </xsl:otherwise>
    </xsl:choose>
    <!-- Terminate the CREATE INDEX statement -->
    <xsl:if test="$SQLTERMINATOR=1">
     <xsl:text>;</xsl:text>
    </xsl:if>
   </xsl:if>
  </xsl:if>
  <!-- check INDEX if unusable -->
  <!-- for transportable we use the UNUSABLE keyword in the CREATE (above)
  -->
  <xsl:if test="(FLAGS mod 2)=1 and $TRANSPORTABLE=0">
   <xsl:call-template name="DoParse">
    <xsl:with-param name="Verb">ALTER</xsl:with-param>
    <xsl:with-param name="ObjectType">INDEX</xsl:with-param>
    <xsl:with-param name="SchemaNode" select="SCHEMA_OBJ/OWNER_NAME"/>
    <xsl:with-param name="NameNode" select="SCHEMA_OBJ/NAME"/>
   </xsl:call-template>
   <xsl:if test="$PRETTY=1">
    <xsl:text>&#xa; </xsl:text>
   </xsl:if>
   <xsl:text> ALTER INDEX </xsl:text>
   <xsl:apply-templates select="SCHEMA_OBJ"/>
   <xsl:text> UNUSABLE</xsl:text>
   <!-- Terminate the SQL statement -->
   <xsl:if test="$SQLTERMINATOR=1">
    <xsl:text>;</xsl:text>
   </xsl:if>
  </xsl:if>
  <!-- unusable (sub)partitions: for TRANSPORTABLE we use the UNUSABLE keyword
       on the partition (see DoPartSegAttrs in kuprtobj.xsl) -->
  <xsl:if test="$TRANSPORTABLE=0">
   <xsl:call-template name="DoUnusablePartitions">
    <xsl:with-param name="Idx" select="."/>
   </xsl:call-template>
  </xsl:if>
  <!-- If transportable and the flags field is not null, then call
       patchdictionary -->
  <xsl:if test="($TRANSPORTABLE=1 and
                 TYPE_NUM=2 and
                 FLAGS>0)">
   <!-- Calls to dbms_plugtsp need to be run while connected to the schema
        running the job.  Add a parse item ALT_CONNECT_TYPE=NONE -->
   <xsl:if test="$PRS_ALT_CONNECT_TYPE=1">
    <xsl:value-of select="$PRS_DELIM"/>
    <xsl:text>AALT_CONNECT_TYPE</xsl:text>
    <xsl:value-of select="$PRS_DELIM"/>
    <xsl:text>BNONE</xsl:text>
   </xsl:if>

   <xsl:call-template name="DoParse">
    <xsl:with-param name="Verb">DBMS_PLUGTSP.PATCHDICTIONARY</xsl:with-param>
    <xsl:with-param name="ObjectType">INDEX</xsl:with-param>
   </xsl:call-template>
   <xsl:text>BEGIN </xsl:text>
   <xsl:if test="$PRETTY=1">
    <xsl:text>&#xa;</xsl:text>
   </xsl:if>
   <xsl:text>SYS.DBMS_PLUGTSP.PATCHDICTIONARY('</xsl:text>
   <xsl:value-of select="BASE_OBJ/OWNER_NAME"/>
   <xsl:text>','</xsl:text>
   <xsl:value-of select="BASE_OBJ/NAME"/>
   <xsl:text>','</xsl:text>
   <xsl:value-of select="SCHEMA_OBJ/OWNER_NAME"/>
   <xsl:text>','</xsl:text>
   <xsl:value-of select="SCHEMA_OBJ/NAME"/>
   <xsl:text>',</xsl:text>
   <xsl:value-of select="FLAGS"/>
   <xsl:text>,'unused','unused',1); </xsl:text>
   <xsl:if test="$PRETTY=1">
    <xsl:text>&#xa;</xsl:text>
   </xsl:if>
   <xsl:text>END;</xsl:text>
   <!-- Terminate the SQL statement -->
   <xsl:if test="$SQLTERMINATOR=1">
    <xsl:text>
/
</xsl:text>
   </xsl:if>
  </xsl:if>
 </xsl:template>
 <xsl:template name="DoColList">
  <xsl:param name="ColListNode" select="''"/>
  <xsl:param name="IndProperty" select="''"/>
  <!-- *******************************************************************
Template: DoColList - col list processing for indexes
Parameters:
  ColListNode: COL_LIST
  IndProperty: PROPERTY
******************************************************************** -->
  <xsl:text>(</xsl:text>
  <xsl:for-each select="$ColListNode/COL_LIST_ITEM">
   <!--xsl:sort select="POS_NUM" data-type="number"/-->
   <xsl:choose>
    <!-- check PROPERTY flags: functional index virt column is marked
     both virtual and hidden
                /* 0x0020 =      32 = hidden column                          */
            /* 0x00010000 =   65536 = virtual column                         */
     In such case we put out col$.default$ which contains the
     defining functional expression.
     HOWEVER, if this bit
                /* 0x0008 =       8 = virtual column                         */
     is also set and these bits are clear:
                /* 0x0100 =     256 = system-generated column                */
                /* 0x0200 =     512 = rowinfo column of typed table/view     */
                /* 0x4000 =   16384 = dropped column                         */
     that means it is an XMLType virtual column, and we should use the
     column name.
-->
    <xsl:when test="(COL/PROPERTY mod 16 >= 8) and
                    (COL/PROPERTY mod 64 >= 32) and
                    (COL/PROPERTY mod 131052 >= 65536) and
                    (256 > (COL/PROPERTY mod 512)) and
                    (512 > (COL/PROPERTY mod 1024)) and
                    (16384 > (COL/PROPERTY mod 32768))">
     <!-- xmltype virtual column: use column name -->
     <xsl:call-template name="DoIdxColName">
      <xsl:with-param name="ColNode" select="COL"/>
      <xsl:with-param name="IndProperty" select="$IndProperty"/>
     </xsl:call-template>
    </xsl:when>
    <xsl:when test="((COL/PROPERTY mod 64)>=32 
                    and (COL/PROPERTY mod 131072)>=65536)">
     <!-- functional index -->
     <xsl:value-of select="COL/DEFAULT_VAL"/>
    </xsl:when>
    <!-- Note: colname references to XMLEXTRA.EXTRADATA are not valid
           for indexes. Therefore, we force the colname to OBJECT_VALUE.
     -->
    <xsl:when test="(COL/PROPERTY mod 64 >= 32) and
                      (COL/PROPERTY mod 256 >= 128) and
                      (contains(COL/ATTRNAME, 'EXTRADATA'))">
    <xsl:text>OBJECT_VALUE</xsl:text>
    </xsl:when>
    <xsl:otherwise>
     <xsl:call-template name="DoIdxColName">
      <xsl:with-param name="ColNode" select="COL"/>
      <xsl:with-param name="IndProperty" select="$IndProperty"/>
     </xsl:call-template>
    </xsl:otherwise>
   </xsl:choose>
   <!-- DESCending order index is bit 0x20000 (131072) in col$.property -->
   <xsl:if test="(COL/PROPERTY mod 262144)>=131072"> DESC</xsl:if>
   <!-- Put out a ',' when not the last column -->
   <!-- Otherwise, terminate the col. list -->
   <xsl:choose>
    <xsl:when test="not(position()=last())">
     <xsl:text>, </xsl:text>
    </xsl:when>
    <xsl:otherwise>) </xsl:otherwise>
   </xsl:choose>
  </xsl:for-each>
 </xsl:template>
 <xsl:template name="DoIdxColName">
  <xsl:param name="ColNode" select="''"/>
  <xsl:param name="IndProperty" select="''"/>
  <!-- *******************************************************************
Template: DoIdxColName - generate index column name
Parameters:
  ColNode: COL
  IndProperty: PROPERTY
******************************************************************** -->
  <!-- if this is a bitmap join index, prefix column name with table alias -->
  <xsl:if test="($IndProperty mod 2048)>=1024">
   <xsl:text>"T</xsl:text>
   <xsl:value-of select="$ColNode/OBJ_NUM"/>
   <xsl:text>".</xsl:text>
  </xsl:if>
  <xsl:call-template name="ColNameOrAttr">
   <xsl:with-param name="ColItem" select="$ColNode"/>
  </xsl:call-template>
 </xsl:template>
 <xsl:template name="DomainCol">
  <xsl:param name="ColListNode" select="''"/>
  <xsl:param name="IndProperty" select="''"/>
  <!-- *******************************************************************
Template: DomainCol - col processing for domain index
Parameters:
  ColListNode: COL_LIST
  IndProperty: PROPERTY
******************************************************************** -->
  <xsl:text>(</xsl:text>
  <xsl:for-each select="$ColListNode/COL_LIST_ITEM[POS_NUM=1]">
   <!-- pos_num =1 is the domain index col -->
   <xsl:choose>
    <!-- check PROPERTY flags: functional index virt column is marked
     both virtual and hidden
                /* 0x0020 =      32 = hidden column                          */
            /* 0x00010000 =   65536 = virtual column                         */
     In such case we put out col$.default$ which contains the
     defining functional expression.
-->
    <!-- Note: colname references to XMLEXTRA.EXTRADATA are not valid
           for indexes. Therefore, we force the colname to OBJECT_VALUE.
     -->
    <xsl:when test="((COL/PROPERTY mod 64)>=32 
                 and (COL/PROPERTY mod 131072)>=65536)">
     <xsl:value-of select="COL/DEFAULT_VAL"/>
    </xsl:when>
    <xsl:when test="(COL/PROPERTY mod 64 >= 32) and
                      (COL/PROPERTY mod 256 >= 128) and
                      (contains(COL/ATTRNAME, 'EXTRADATA'))">
     <xsl:text>OBJECT_VALUE</xsl:text>
    </xsl:when>
    <xsl:otherwise>
     <!-- if this is a bitmap join index, prefix column name with table alias -->
     <xsl:if test="($IndProperty mod 2048)>=1024">
      <xsl:text>"T</xsl:text>
      <xsl:value-of select="COL/OBJ_NUM"/>
      <xsl:text>".</xsl:text>
     </xsl:if>
       <xsl:call-template name="ColNameOrAttr">
        <xsl:with-param name="ColItem" select="COL"/>
       </xsl:call-template>
    </xsl:otherwise>
   </xsl:choose>
  </xsl:for-each>
  <xsl:text>) </xsl:text>
 </xsl:template>
 <xsl:template match="JIJOIN_TABS">
  <!-- *******************************************************************
Template: JIJOIN_TABS 
  - template for bitmap join index FROM... WHERE... clause 
******************************************************************** -->
  <xsl:for-each select="JIJOIN_TABS_ITEM">
   <xsl:sort select="NAME"/>
   <xsl:if test="position()=1">
    <xsl:text> FROM </xsl:text>
   </xsl:if>
   <xsl:call-template name="QuoteObject">
    <xsl:with-param name="Schema" select="OWNER_NAME"/>
    <xsl:with-param name="Object" select="NAME"/>
   </xsl:call-template>
   <xsl:text> "T</xsl:text>
   <xsl:value-of select="TABOBJ_NUM"/>
   <xsl:text>"</xsl:text>
   <xsl:if test="not(position()=last())">
    <xsl:text>, </xsl:text>
   </xsl:if>
  </xsl:for-each>
 </xsl:template>
 <xsl:template match="JIJOIN">
  <!-- *******************************************************************
Template: JIJOIN
******************************************************************** -->
  <xsl:for-each select="JIJOIN_ITEM">
   <xsl:choose>
    <xsl:when test="position()=1">
     <xsl:text> WHERE </xsl:text>
    </xsl:when>
    <xsl:otherwise>AND </xsl:otherwise>
   </xsl:choose>
   <xsl:text>"T</xsl:text>
   <xsl:value-of select="TAB1OBJ_NUM"/>
   <xsl:text>"."</xsl:text>
   <xsl:value-of select="TAB1COL/NAME"/>
   <xsl:text>"="T</xsl:text>
   <xsl:value-of select="TAB2OBJ_NUM"/>
   <xsl:text>"."</xsl:text>
   <xsl:value-of select="TAB2COL/NAME"/>
   <xsl:text>" </xsl:text>
  </xsl:for-each>
 </xsl:template>
 <xsl:template name="DomainIndexClause">
  <!-- *******************************************************************
Template: DomainIndexClause
  Index properties for a domain index
******************************************************************** -->
  <xsl:text> INDEXTYPE IS "</xsl:text>
  <xsl:value-of select="INDTYPE_OWNER"/>
  <xsl:text>"."</xsl:text>
  <xsl:value-of select="INDTYPE_NAME"/>
  <xsl:text>" </xsl:text>
  <!-- FILTER BY -->
  <xsl:for-each select="COL_LIST/COL_LIST_ITEM[(FLAGS mod 8)>=4]">
   <xsl:if test="position()=1">
    <xsl:if test="$PRETTY=1">
     <xsl:text>&#xa;   </xsl:text>
    </xsl:if>
    <xsl:text> FILTER BY </xsl:text>
   </xsl:if>
   <xsl:call-template name="ColNameOrAttr">
    <xsl:with-param name="ColItem" select="COL"/>
   </xsl:call-template>
   <xsl:if test="not(position()=last())">, </xsl:if>
  </xsl:for-each>
  <!-- ORDER BY -->
  <xsl:for-each select="COL_LIST/COL_LIST_ITEM[(FLAGS mod 16)>=8]">
   <xsl:sort select="SPARE3" data-type="number"/>
   <xsl:if test="position()=1">
    <xsl:if test="$PRETTY=1">
     <xsl:text>&#xa;   </xsl:text>
    </xsl:if>
    <xsl:text> ORDER BY </xsl:text>
   </xsl:if>
   <xsl:call-template name="ColNameOrAttr">
    <xsl:with-param name="ColItem" select="COL"/>
   </xsl:call-template>
   <xsl:if test="(FLAGS mod 4)>=2"> DESC</xsl:if>
   <xsl:if test="not(position()=last())">, </xsl:if>
  </xsl:for-each>
  <xsl:choose>
   <xsl:when test="(PART_OBJ)">
    <!-- Partitioned domain index -->
    <xsl:if test="PART_OBJ/PARTOBJ/DEFPARAMETERS">
     <xsl:text> PARAMETERS (</xsl:text>
     <xsl:call-template name="EscapeString">
      <xsl:with-param name="OrigStr" select="PART_OBJ/PARTOBJ/DEFPARAMETERS"/>
      <xsl:with-param name="Leading">'</xsl:with-param>
      <xsl:with-param name="Trailing">'</xsl:with-param>
     </xsl:call-template>
     <xsl:text>)</xsl:text>
    </xsl:if>
    <xsl:text> LOCAL </xsl:text>
    <xsl:for-each select="PART_OBJ/PART_LIST/PART_LIST_ITEM">
     <xsl:if test="position()=1">(</xsl:if>
     <xsl:if test="$PRETTY=1">
      <xsl:text>&#xa;   </xsl:text>
     </xsl:if>
     <xsl:text>PARTITION "</xsl:text>
     <xsl:value-of select="SCHEMA_OBJ/SUBNAME"/>
     <xsl:text>"</xsl:text>
     <xsl:if test="PARAMETERS">
      <xsl:text> PARAMETERS (</xsl:text>
      <xsl:call-template name="EscapeString">
       <xsl:with-param name="OrigStr" select="PARAMETERS"/>
       <xsl:with-param name="Leading">'</xsl:with-param>
       <xsl:with-param name="Trailing">'</xsl:with-param>
      </xsl:call-template>
      <xsl:text>)</xsl:text>
     </xsl:if>
     <xsl:choose>
      <xsl:when test="position()=last()">)</xsl:when>
      <xsl:otherwise>, </xsl:otherwise>
     </xsl:choose>
    </xsl:for-each>
   </xsl:when>
   <xsl:otherwise>
    <!-- non-partitioned -->
    <xsl:if test="SPARE4">
     <xsl:text> PARAMETERS (</xsl:text>
     <xsl:call-template name="EscapeString">
      <xsl:with-param name="OrigStr" select="SPARE4"/>
      <xsl:with-param name="Leading">'</xsl:with-param>
      <xsl:with-param name="Trailing">'</xsl:with-param>
     </xsl:call-template>
     <xsl:text>)</xsl:text>
    </xsl:if>
   </xsl:otherwise>
  </xsl:choose>
 </xsl:template>
 <xsl:template name="PartitionedIndexProperties">
  <!-- *******************************************************************
Template: PartitionedIndexProperties
- emit properties for partitioned index
******************************************************************** -->
  <xsl:if test="$SEGMENT_ATTRIBUTES=1">
   <xsl:call-template name="DoPartObjSegAttrs">
    <xsl:with-param name="ADT_type">INDEX</xsl:with-param>
   </xsl:call-template>
   <xsl:call-template name="DoPartObjLogging"/>
   <xsl:call-template name="DoPartObjStorage">
    <xsl:with-param name="ADT_type">INDEX</xsl:with-param>
    <xsl:with-param name="Pctspace" select="$PCTSPACE"/>
   </xsl:call-template>
   <xsl:call-template name="DoPartObjTablespace"/>
  </xsl:if>
  <xsl:call-template name="DoPartitionClause">
   <xsl:with-param name="ADT_type">INDEX</xsl:with-param>
   <xsl:with-param name="Pctspace" select="$PCTSPACE"/>
   <xsl:with-param name="PartCompress" select="((FLAGS mod 64)>=32) and NUMKEYCOLS and (NUMKEYCOLS > 0)"/>
  </xsl:call-template>
  <xsl:if test="(FLAGS mod 64)>=32 and NUMKEYCOLS">
   <xsl:text>COMPRESS </xsl:text>
   <xsl:value-of select="NUMKEYCOLS"/>
   <xsl:text> </xsl:text>
  </xsl:if>
 </xsl:template>
 <xsl:template name="CvtToNPIdx">
  <!-- *******************************************************************
Template: CvtToNPIdx
- Convert a local index (sub)partition to a non-partitioned index
  for partition transportable
Current node: parent of PART_OBJ
******************************************************************** -->
  <xsl:choose>
   <xsl:when test="string-length($PARTITION_NAME)!=0 or
                     string-length($BASE_PARTITION_NAME)!=0">
    <xsl:call-template name="CvtIdxPart"/>
   </xsl:when>
   <xsl:otherwise>
    <xsl:call-template name="CvtIdxSubPart"/>
   </xsl:otherwise>
  </xsl:choose>
 </xsl:template>
 <xsl:template name="CvtIdxPart">
  <!-- *******************************************************************
Template: CvtIdxPart
- Convert a local index partition to a non-partitioned index
  for partition transportable
Current node: parent of PART_OBJ
******************************************************************** -->
  <xsl:choose>
   <xsl:when test="string-length($PARTITION_NAME)!=0">
    <xsl:apply-templates select="PART_OBJ/PART_LIST/PART_LIST_ITEM[SCHEMA_OBJ/SUBNAME=$PARTITION_NAME]/PCT_FREE">
     <xsl:with-param name="ADT_type">INDEX</xsl:with-param>
    </xsl:apply-templates>
    <xsl:apply-templates select="PART_OBJ/PART_LIST/PART_LIST_ITEM[SCHEMA_OBJ/SUBNAME=$PARTITION_NAME]/STORAGE">
     <xsl:with-param name="PARTITION">1</xsl:with-param>
     <xsl:with-param name="BlkSize" select="PART_OBJ/PART_LIST/PART_LIST_ITEM[SCHEMA_OBJ/SUBNAME=$PARTITION_NAME]/BLOCKSIZE"/>
     <xsl:with-param name="Dataobjnum" select="PART_OBJ/PART_LIST/PART_LIST_ITEM[SCHEMA_OBJ/SUBNAME=$PARTITION_NAME]/DATAOBJ_NUM"/>
    </xsl:apply-templates>
   </xsl:when>
   <xsl:otherwise>
    <xsl:apply-templates select="PART_OBJ/PART_LIST/PART_LIST_ITEM[TAB_PART_NAME=$BASE_PARTITION_NAME]/PCT_FREE">
     <xsl:with-param name="ADT_type">INDEX</xsl:with-param>
    </xsl:apply-templates>
    <xsl:apply-templates select="PART_OBJ/PART_LIST/PART_LIST_ITEM[TAB_PART_NAME=$BASE_PARTITION_NAME]/STORAGE">
     <xsl:with-param name="PARTITION">1</xsl:with-param>
     <xsl:with-param name="BlkSize" select="PART_OBJ/PART_LIST/PART_LIST_ITEM[TAB_PART_NAME=$BASE_PARTITION_NAME]/BLOCKSIZE"/>
     <xsl:with-param name="Dataobjnum" select="PART_OBJ/PART_LIST/PART_LIST_ITEM[TAB_PART_NAME=$BASE_PARTITION_NAME]/DATAOBJ_NUM"/>
    </xsl:apply-templates>
   </xsl:otherwise>
  </xsl:choose>
 </xsl:template>
 <xsl:template name="CvtIdxSubPart">
  <!-- *******************************************************************
Template: CvtIdxSubPart
- Convert a local index subpartition to a non-partitioned index
  for partition transportable
Current node: parent of PART_OBJ
******************************************************************** -->
  <xsl:choose>
   <xsl:when test="string-length($SUBPARTITION_NAME)!=0">
    <xsl:apply-templates select="PART_OBJ/COMPART_LIST/COMPART_LIST_ITEM/SUBPARTS/SUBPARTS_ITEM[SCHEMA_OBJ/SUBNAME=$SUBPARTITION_NAME]/PCT_FREE">
     <xsl:with-param name="ADT_type">INDEX</xsl:with-param>
    </xsl:apply-templates>
    <xsl:apply-templates select="PART_OBJ/COMPART_LIST/COMPART_LIST_ITEM/SUBPARTS/SUBPARTS_ITEM[SCHEMA_OBJ/SUBNAME=$SUBPARTITION_NAME]/STORAGE">
     <xsl:with-param name="PARTITION">1</xsl:with-param>
     <xsl:with-param name="BlkSize" select="PART_OBJ/COMPART_LIST/COMPART_LIST_ITEM/SUBPARTS/SUBPARTS_ITEM[SCHEMA_OBJ/SUBNAME=$SUBPARTITION_NAME]/BLOCKSIZE"/>
     <xsl:with-param name="Dataobjnum" select="PART_OBJ/COMPART_LIST/COMPART_LIST_ITEM/SUBPARTS/SUBPARTS_ITEM[SCHEMA_OBJ/SUBNAME=$SUBPARTITION_NAME]/DATAOBJ_NUM"/>
    </xsl:apply-templates>
   </xsl:when>
   <xsl:otherwise>
    <xsl:apply-templates select="PART_OBJ/COMPART_LIST/COMPART_LIST_ITEM/SUBPARTS/SUBPARTS_ITEM[TAB_SUBPART_NAME=$BASE_SUBPARTITION_NAME]/PCT_FREE">
     <xsl:with-param name="ADT_type">INDEX</xsl:with-param>
    </xsl:apply-templates>
    <xsl:apply-templates select="PART_OBJ/COMPART_LIST/COMPART_LIST_ITEM/SUBPARTS/SUBPARTS_ITEM[TAB_SUBPART_NAME=$BASE_SUBPARTITION_NAME]/STORAGE">
     <xsl:with-param name="PARTITION">1</xsl:with-param>
     <xsl:with-param name="BlkSize" select="PART_OBJ/COMPART_LIST/COMPART_LIST_ITEM/SUBPARTS/SUBPARTS_ITEM[TAB_SUBPART_NAME=$BASE_SUBPARTITION_NAME]/BLOCKSIZE"/>
     <xsl:with-param name="Dataobjnum" select="PART_OBJ/COMPART_LIST/COMPART_LIST_ITEM/SUBPARTS/SUBPARTS_ITEM[TAB_SUBPART_NAME=$BASE_SUBPARTITION_NAME]/DATAOBJ_NUM"/>
    </xsl:apply-templates>
   </xsl:otherwise>
  </xsl:choose>
 </xsl:template>
 <xsl:template name="IndexAttributes">
  <!-- *******************************************************************
Template: IndexAttributes
- emit index attributes for non-partitioned index
******************************************************************** -->
  <xsl:if test="$SEGMENT_ATTRIBUTES=1">
   <xsl:apply-templates select="PCT_FREE">
    <xsl:with-param name="ADT_type">INDEX</xsl:with-param>
   </xsl:apply-templates>
   <!-- Invisible if bit 0x200000 in FLAGS=1 -->
   <xsl:if test="(FLAGS mod 4194304)>=2097152">INVISIBLE </xsl:if>
   <xsl:if test="($EXPORT = 0) and
                      (FLAGS mod 4)>=2">COMPUTE STATISTICS </xsl:if>
   <xsl:if test="(FLAGS mod 64)>=32 and NUMKEYCOLS">
    <xsl:text>COMPRESS </xsl:text>
    <xsl:value-of select="NUMKEYCOLS"/>
    <xsl:text> </xsl:text>
   </xsl:if>
   <xsl:choose>
    <xsl:when test="DEFERRED_STG">
     <!-- DoDeferredStg does index logging as well as storage -->
     <xsl:call-template name="DoDeferredStg">
      <xsl:with-param name="DeferredStg" select="DEFERRED_STG"/>
      <xsl:with-param name="Pctspace" select="$PCTSPACE"/>
      <xsl:with-param name="ADT_type">INDEX</xsl:with-param>
     </xsl:call-template>
     <xsl:if test="$TABLESPACE=1">
      <xsl:apply-templates select="TS_NAME"/>
     </xsl:if>
    </xsl:when>
    <xsl:otherwise>
     <xsl:call-template name="DoIndLogging">
      <xsl:with-param name="FlagsNode" select="FLAGS"/>
     </xsl:call-template>
     <xsl:choose>
      <xsl:when test="STORAGE">
       <xsl:apply-templates select="STORAGE">
        <xsl:with-param name="BlkSize" select="../BLOCKSIZE | BLOCKSIZE"/>
        <xsl:with-param name="Dataobjnum" select="SCHEMA_OBJ/DATAOBJ_NUM"/>
        <xsl:with-param name="Pctspace" select="$PCTSPACE"/>
       </xsl:apply-templates>
      </xsl:when>
      <xsl:otherwise>
       <xsl:if test="(FLAGS mod 8192)>=4096">
        <xsl:text> NOSEGMENT </xsl:text>
       </xsl:if>
      </xsl:otherwise>
     </xsl:choose>
    </xsl:otherwise>
   </xsl:choose>
  </xsl:if>
 </xsl:template>
 <xsl:template match="SECOBJS">
  <!-- *******************************************************************
Template: SECOBJS
******************************************************************** -->
  <xsl:for-each select="SECOBJS_ITEM">
   <xsl:if test="position()=1">
    <xsl:call-template name="DoParse">
     <xsl:with-param name="Verb">DBMS_EXPORT_EXTENSION.BEGIN_IMPORT_DOMAIN_INDEX</xsl:with-param>
     <xsl:with-param name="ObjectType">INDEX</xsl:with-param>
    </xsl:call-template>
    <xsl:text>BEGIN </xsl:text>
    <xsl:if test="$PRETTY=1">
     <xsl:text>&#xa;</xsl:text>
    </xsl:if>
    <xsl:text>SYS.DBMS_EXPORT_EXTENSION.BEGIN_IMPORT_DOMAIN_INDEX('</xsl:text>
    <xsl:value-of select="../../SCHEMA_OBJ/OWNER_NAME"/>
    <xsl:text>','</xsl:text>
    <xsl:value-of select="../../SCHEMA_OBJ/NAME"/>
    <xsl:text>'); </xsl:text>
    <xsl:if test="$PRETTY=1">
     <xsl:text>&#xa;</xsl:text>
    </xsl:if>
    <xsl:text>END;</xsl:text>
    <!-- Terminate the SQL statement -->
    <xsl:if test="$SQLTERMINATOR=1">
     <xsl:text>
/
</xsl:text>
    </xsl:if>
   </xsl:if>
   <xsl:call-template name="DoParse">
    <xsl:with-param name="Verb">DBMS_EXPORT_EXTENSION.INSERT_SECOBJ</xsl:with-param>
    <xsl:with-param name="ObjectType">INDEX</xsl:with-param>
   </xsl:call-template>
   <xsl:text>BEGIN </xsl:text>
   <xsl:if test="$PRETTY=1">
    <xsl:text>&#xa;</xsl:text>
   </xsl:if>
   <xsl:text>SYS.DBMS_EXPORT_EXTENSION.INSERT_SECOBJ('</xsl:text>
   <xsl:value-of select="SCHEMA_OBJ/OWNER_NAME"/>
   <xsl:text>','</xsl:text>
   <xsl:value-of select="SCHEMA_OBJ/NAME"/>
   <xsl:text>'); </xsl:text>
   <xsl:if test="$PRETTY=1">
    <xsl:text>&#xa;</xsl:text>
   </xsl:if>
   <xsl:text>END;</xsl:text>
   <!-- Terminate the SQL statement -->
   <xsl:if test="$SQLTERMINATOR=1">
    <xsl:text>
/
</xsl:text>
   </xsl:if>
  </xsl:for-each>
 </xsl:template>
</xsl:stylesheet>
