<?xml version="1.0"?>
<!-- Copyright (c) 2000, 2010, Oracle and/or its affiliates. 
All rights reserved. -->
<!-- 
NAME
    kulob.xsl
DESCRIPTION
    XSLT stylesheet for XML => DDL conversion of lob ADTs
NOTES
    Do NOT modify this file under any circumstance. Copy the file
    if you wish to use this stylesheet with an external XML/XSL parser

MODIFIED	MM/DD/YY
    lbarton     04/26/10 - bug 9650606: more dsc details
    sdavidso    04/29/10 - bug 9633699: composite partition and specific data
                           types
    lbarton     04/19/10 - lrg 4476227: no ALLOW NOSCHEMA for lob
    sdavidso    01/27/10 - bug 8929002: bad column name for mView
    rapayne     01/10/10 - bug 9235295: suppress hidden subtype references
                           which contain TREAT AS syntax.
    lbarton     08/27/09 - bug 8820324: support all values in deferred_stg
    lbarton     08/14/09 - bug 8795792: no compress/logging in deferred stg for
                           indexes
    lbarton     06/18/09 - lrg 3543159: XMLType virtual columns
    tbhukya     06/24/09 - Bug 8282506: don't generate duplicate lob storage 
                           for list partition in transportable.
    lbarton     03/04/09 - bug 8252494: deferred segment creation
    slynn       02/04/09 - Fix bug-7023008: RETENTION NONE emitted as RETENTION
                           AUTO.
    rapayne     12/06/08 - merge BLOCKSIZE logic for CM
    slynn       05/08/08 - Fix bug-5868613: Fix Partition/subpartition
                           parameters.
    rapayne     12/31/07 - lrg 3246276 : make RETENTION AUTO the default
                                       for securefile lobs.
    ebatbout    12/12/07 - bug 6468074 : missing lob Params for SecureFile lobs
    rapayne     12/07/07 - bug : output LOB STORAGE RETENTION for
                           non-Export comsummers.
    slynn       09/13/07 - Fix bug-6414775: problems with SecureFiles.
    slynn       08/28/07 - Remove lob specification encrypt clause.
    htseng      06/07/07 - bug 6118244 - generate LOB clause for OPAQUE
			   in LobComppart 
    slynn       02/25/07 - Backout changes that removed dedup validate.
    sdavidso    02/28/07 - aviod illegal chunk clause
    slynn       02/11/07 - Fix Partitioned LOB Column Retention
    spetride    12/05/06 - binary XML: ensure lob name/attrs present
                         - corrected pos ALLOW/DIALLOW ANYSCHEMA/NONSCHEMA
    slynn       11/20/06 - Remove unimplemented keywords
    slynn       10/12/06 - smartfile->securefile
    slynn       07/31/06 - change csce keywords
    jforsyth    05/10/06 - adding encryption, compression, sharing 
    lbarton     05/18/06 - bug 5152323: xmltype in partitioned tbl and tte 
    kkunchit    11/02/05 - project-18204: inode: LOCAL/NOLOCAL support 
    mbaloglu    12/23/05 - Add SYNC/ASYNC, CACHE NOLOGGING 
    htseng      03/13/06 - binary xml support 
    htseng      03/07/06 - bug 4963080: not generate LOB STORE AS for xmltype 
			   column 
    lbarton     02/28/06 - bug 4959915: transportable lobs in list 
                           subpartition 
    lbarton     11/02/05 - Bug 4715313: reformat files for use with XMLSpy 
    htseng      08/05/05 - bug 3560220 : get correct behivor processor 
    lbarton     05/16/05 - Bug 4373204: generate correct [NO]LOGGING for lobs
    lbarton     05/04/05 - bug 4347010: exclude unused columns 
    rpfau       11/30/04 - bug 3684091 - add check and apply template of 
                           LOBINDEX in template DoXMLTypeStorage. Have callers
                           of DoXMLTypeStorage emit XMLTYPE and simplify
                           call logic.
    rpfau       06/22/04 - Redo xmltype with partitions, put it at table level
                           only and not at partition level. Also fix carriage
                           return logic for storage parameters if there is no
                           tablespace.
    rpfau       06/11/04 - Fix anytype column in partitioned table - bug
                           3618089.
    lbarton     10/31/03 - Bug 3215955: Emit XMLTYPE LOBINDEX if TRANSPORTABLE
    lbarton     05/05/03 - remove obsolete TABLESPACE clause on lob INDEX
    htseng      03/31/03 - fix TRANSPORTABLE for index
    htseng      03/26/03 - fix bug 2862458 opaque type
    bmccarth    03/28/03 - revert to NOT put out XMLTYPE on store as lob
    bmccarth    11/15/02 - fix xmltype store as clob
    bmccarth    10/14/02 - bug 2549870 remove XMLTYPE from store as clob
    lbarton     08/02/02 - transportable export
    lbarton	04/03/02 - xdb bugfix
    lbarton	01/07/02 - formatting
    dgagne	09/19/01 - create lob store as clause for template subp
    dgagne	09/06/01 - add support for range/list composite partitions
    dgagne	06/14/01 - Move storage PRETTY statements to kustorag
    lbarton	06/01/01 - remove oradb-style imports
    lbarton	12/01/00 - XMLType support
    lbarton	10/27/00 - bugfix
    gclaborn    10/30/00 - Add external imports
    lbarton	09/29/00 - use ColNameOrAttr
    lbarton	07/24/00 - use uriref in import
    lbarton	05/15/00 - Params for new API
    lbarton	04/05/00 - Creation (make separate script)
 -->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
 <!-- Import required scripts -->
 <xsl:import href="kucommon.xsl"/>
 <xsl:import href="kustorag.xsl"/>
 <!-- Templates -->
 <xsl:template name="DoLOBStoreAs">
  <xsl:param name="MetaType">Lob</xsl:param>
  <xsl:param name="Parttype">0</xsl:param>
  <xsl:param name="Subpartition">0</xsl:param>
  <xsl:param name="ColList" select="''"/>
  <xsl:param name="Intcolnum">0</xsl:param>
  <xsl:param name="TabBlocksize">0</xsl:param>
  <xsl:param name="XMLType_storage">0</xsl:param>
  <!-- *******************************************************************
Template:  DoLOBStoreAs
  XML environment:

   TABLE_T
    COL_LIST
     COL_LIST_ITEM
      TYPE_NUM
      TYPEMD
       FLAGS
      LOBMD		(current node)
      OPQMD
       FLAGS

  or

   TABLE_T
    COL_LIST
     COL_LIST_ITEM
      TYPE_NUM
      TYPEMD
       FLAGS
    BLOCKSIZE
    PART_OBJ
     PART_LIST or COMPART_LIST or SUBPARTS
      PART_LIST_ITEM or COMPART_LIST_ITEM or SUBPARTS_ITEM
       LOBS
        LOBS_ITEM	(current node)
         INTCOL_NUM

  Parameters:
   MetaType
     Lob         - lob column metadata in non-partitioned table
     PartLob     - table level defaults
     LobFrag     - actual partition- or subpartition-level lob attributes
     LobComppart - partition-level defaults
   Parttype	 - partition type: 1 = range, 2 = hash
   Subpartition	 - 0 = partition, 1 = subpartition
   ColList	 - column list node
   Intcolnum	 - intcolnum for lob column
   TabBlocksize	 - Table blocksize value
   XMLType_storage - 1 = emit xmltype storage syntax for xmltype table
                   (i.e., not for column)

  Lob name:
     For non-partitioned table, lobname is obj$.name.
     For partitioned table, for table-level default, lobname is obj$.name.
     For non-composite partitioned table, lobname at partition level
       is obj$.subname.
     For composite partitioned table, lobname at partition level
       is obj$.subname
     For composite partitioned table, lobname at subpartition level
       is obj$.subname
******************************************************************** -->
  <!-- do VARRAY or LOB or XMLTYPE clause depending on column type -->
  <xsl:variable name="Property">
   <xsl:choose>
    <xsl:when test="PROPERTY">
     <xsl:value-of select="PROPERTY"/>
    </xsl:when>
    <xsl:otherwise>
     <xsl:value-of select="DEFPRO"/>
    </xsl:otherwise>
   </xsl:choose>
  </xsl:variable>
  <xsl:choose>
   <!-- skip all of this if column is unused -->
   <xsl:when test="($ColList/COL_LIST_ITEM[INTCOL_NUM=$Intcolnum]/PROPERTY mod 65536)>=32768"/>
   <!-- VARRAY (type#=123) -->
   <xsl:when test="$ColList/COL_LIST_ITEM[INTCOL_NUM=$Intcolnum]/TYPE_NUM=123">
    <!-- The logic is appallingly complex -->
    <xsl:choose>
     <!-- First, see if we can skip the whole thing -->
     <!-- Don't generate VARRAY foo STORE AS LOB in the following 2 cases:
       1. collection storage is specified (coltype$.flags bit #x40)
	  and
	  the varray has a system-generated name (obj$.flags bit #x04)
	  and
	  this is not a TRANSPORTABLE export 
          and either
	   this is a hash partition (parttype=2) or
	   the user specified SEGMENT_ATTRIBUTES=0
          AND this is NOT a SecureFile
     -->
     <xsl:when test="
        (2048 > ($Property mod 4096))
        and
	$ColList/COL_LIST_ITEM[INTCOL_NUM=$Intcolnum]/TYPEMD/FLAGS mod 128 >=64
	and
	(SCHEMA_OBJ/FLAGS mod 8)>=4
	and
	$TRANSPORTABLE=0
	and
	($Parttype=2 or $SEGMENT_ATTRIBUTES=0)"/>
     <!-- 
       2. no collection storage specified (coltype$.flags bit #x40)
	  and
	   not TRANSPORTABLE export or
	   the user specified SEGMENT_ATTRIBUTES=0 or
	   we're at the default level
          AND this is NOT a SecureFile
     -->
     <xsl:when test="
        (2048 > ($Property mod 4096))
        and
	64>($ColList/COL_LIST_ITEM[INTCOL_NUM=$Intcolnum]/TYPEMD/FLAGS mod 128)
	and
	($TRANSPORTABLE=0 or $SEGMENT_ATTRIBUTES=0 or
	$MetaType='PartLob' or $MetaType='LobComppart')"/>
     <!--
      3. If this VARRAY is in an XMLTYPE column
         and
	  the varray has a system-generated name (obj$.flags bit #x04)
         and
          the storage wasn't explicitly specified.
      -->
     <xsl:when test="
        ($ColList/COL_LIST_ITEM[LOBMD/INTCOL_NUM=$Intcolnum]/OPQMD
	 and
         $ColList/COL_LIST_ITEM[LOBMD/INTCOL_NUM=$Intcolnum]/OPQMD/TYPE=1)
        and
	(SCHEMA_OBJ/FLAGS mod 8)>=4
        and
	64>($ColList/COL_LIST_ITEM[INTCOL_NUM=$Intcolnum]/TYPEMD/FLAGS mod 128)"/>
     <!-- we have to do it -->
     <xsl:otherwise>
      <!-- generate "VARRAY foo STORE AS LOB" -->
      <xsl:if test="$PRETTY=1">
       <xsl:text>&#xa;</xsl:text>
      </xsl:if>
      <xsl:text> VARRAY </xsl:text>
      <xsl:call-template name="ColNameOrAttr">
       <xsl:with-param name="ColItem" select="$ColList/COL_LIST_ITEM[INTCOL_NUM=$Intcolnum]"/>
      </xsl:call-template>
      <xsl:text> STORE AS </xsl:text>
      <xsl:call-template name="DoSecureFile">
       <xsl:with-param name="Property" select="PROPERTY | DEFPRO"/>
       <xsl:with-param name="Parttype" select="$Parttype"/>
       <xsl:with-param name="Subpartition" select="$Subpartition"/>
      </xsl:call-template>
      <xsl:text>LOB </xsl:text>
      <!-- anything to add? -->
      <xsl:choose>
       <!-- if no collection storage specified (coltype$.flags bit #x40)
               and NOT a SecureFile
	   then do the TRANSPORTABLE attributes
         -->
       <xsl:when test="
      64>($ColList/COL_LIST_ITEM[INTCOL_NUM=$Intcolnum]/TYPEMD/FLAGS mod 128)
      and (2048 > ($Property mod 4096))">
        <xsl:if test="$TRANSPORTABLE=1 and $SEGMENT_ATTRIBUTES=1">
         <xsl:text>(</xsl:text>
         <xsl:apply-templates select="STORAGE">
          <xsl:with-param name="Nested">1</xsl:with-param>
          <xsl:with-param name="BlkSize" select="../BLOCKSIZE | BLOCKSIZE"/>
          <xsl:with-param name="Dataobjnum" select="SCHEMA_OBJ/DATAOBJ_NUM"/>
         </xsl:apply-templates>
         <xsl:apply-templates select="LOBINDEX"/>
         <xsl:text>) </xsl:text>
        </xsl:if>
       </xsl:when>
       <!-- collection storage is specified -->
       <xsl:otherwise>
        <xsl:call-template name="PutLobname">
         <xsl:with-param name="MetaType" select="$MetaType"/>
        </xsl:call-template>
        <!-- more decisions... -->
        <xsl:choose>
         <!-- for hash (sub)partitions emit only transportable attributes -->
         <xsl:when test="$Parttype=2">
          <xsl:if test="$TRANSPORTABLE=1 and $SEGMENT_ATTRIBUTES=1">
           <xsl:text>(</xsl:text>
           <xsl:apply-templates select="STORAGE">
            <xsl:with-param name="Nested">1</xsl:with-param>
            <xsl:with-param name="BlkSize" select="../BLOCKSIZE | BLOCKSIZE"/>
            <xsl:with-param name="Dataobjnum" select="SCHEMA_OBJ/DATAOBJ_NUM"/>
           </xsl:apply-templates>
           <xsl:apply-templates select="LOBINDEX"/>
           <xsl:text>) </xsl:text>
          </xsl:if>
         </xsl:when>
         <!-- for everything else, emit the lob parameters -->
         <xsl:otherwise>
          <xsl:if test="$SEGMENT_ATTRIBUTES=1">
           <xsl:if test="$PRETTY=1">
            <xsl:text>&#xa;  </xsl:text>
           </xsl:if>
           <xsl:text>(</xsl:text>
           <xsl:call-template name="PutLOBParams">
            <xsl:with-param name="MetaType" select="$MetaType"/>
            <xsl:with-param name="TabBlocksize" select="$TabBlocksize"/>
           </xsl:call-template>
           <xsl:if test="$TRANSPORTABLE=1">
            <xsl:apply-templates select="LOBINDEX"/>
           </xsl:if>
           <xsl:text>) </xsl:text>
          </xsl:if>
         </xsl:otherwise>
        </xsl:choose>
       </xsl:otherwise>
      </xsl:choose>
     </xsl:otherwise>
    </xsl:choose>
   </xsl:when>
   <!-- CLOB (type#=112) or BLOB (type#113) -->
   <xsl:when test="($ColList/COL_LIST_ITEM[INTCOL_NUM=$Intcolnum]/TYPE_NUM=112)
              or ($ColList/COL_LIST_ITEM[INTCOL_NUM=$Intcolnum]/TYPE_NUM=113)">
    <!-- emit LOB STORE AS if $SEGMENT_ATTRIBUTES=1 or if
         $SEGMENT_ATTRIBUTES=0 and the user specified a lob segment name
         (meaning lob segement name is not system generated).
      -->
    <xsl:if test="
       $SEGMENT_ATTRIBUTES=1
       or
       ($SEGMENT_ATTRIBUTES=0 and 4>(SCHEMA_OBJ/FLAGS mod 8))">
     <!--
           Emit LOB STORE AS for
           (1) XMLType columns if transportable (bug 5152323)
           (2) non-XMLType columns
           xmltype column is indicated by LOBMD/OPQMD/TYPE=1
           in the COL_LIST_ITEM. Need to test for the
           existence of OPQMD before testing for TYPE=1 because some
           columns do not have an OPQMD entry.
       -->
     <xsl:if test="not($ColList/COL_LIST_ITEM[LOBMD/INTCOL_NUM=$Intcolnum]/OPQMD
         and
         $ColList/COL_LIST_ITEM[LOBMD/INTCOL_NUM=$Intcolnum]/OPQMD/TYPE=1)
         or
         ($ColList/COL_LIST_ITEM[LOBMD/INTCOL_NUM=$Intcolnum]/OPQMD
         and
         $ColList/COL_LIST_ITEM[LOBMD/INTCOL_NUM=$Intcolnum]/OPQMD/TYPE=1
         and
         $TRANSPORTABLE=1 and $MetaType='LobFrag')">
      <xsl:if test="$PRETTY=1">
       <xsl:text>&#xa;</xsl:text>
      </xsl:if>
      <xsl:text> LOB (</xsl:text>
      <xsl:choose>
       <xsl:when test="$ColList/COL_LIST_ITEM[LOBMD/INTCOL_NUM=$Intcolnum]/OPQMD
         and $ColList/COL_LIST_ITEM[LOBMD/INTCOL_NUM=$Intcolnum]/OPQMD/TYPE=1">
        <!-- For XMLType columns use the XMLtype col name ."XMLDATA" -->
        <xsl:call-template name="ColNameOrAttr">
         <xsl:with-param name="ColItem" select="$ColList/COL_LIST_ITEM[LOBMD/INTCOL_NUM=$Intcolnum]"/>
        </xsl:call-template>
        <xsl:text>."XMLDATA"</xsl:text>
       </xsl:when>
       <xsl:otherwise>
        <xsl:call-template name="ColNameOrAttr">
         <xsl:with-param name="ColItem" select="$ColList/COL_LIST_ITEM[INTCOL_NUM=$Intcolnum]"/>
        </xsl:call-template>
       </xsl:otherwise>
      </xsl:choose>
      <xsl:text>) STORE AS </xsl:text>
      <xsl:call-template name="DoSecureFile">
       <xsl:with-param name="Property" select="PROPERTY | DEFPRO"/>
       <xsl:with-param name="Parttype" select="$Parttype"/>
       <xsl:with-param name="Subpartition" select="$Subpartition"/>
      </xsl:call-template>
      <xsl:call-template name="PutLobname">
       <xsl:with-param name="MetaType" select="$MetaType"/>
      </xsl:call-template>
      <xsl:text>(</xsl:text>
      <xsl:choose>
       <xsl:when test="$MetaType='Lob' or $MetaType='LobFrag'">
        <xsl:choose>
         <xsl:when test="TS_NAME">
          <xsl:apply-templates select="TS_NAME"/>
         </xsl:when>
         <xsl:otherwise>
          <!-- No TS_NAME entry, so put out a cr -->
          <xsl:if test="$PRETTY=1">
           <xsl:text>&#xa;  </xsl:text>
          </xsl:if>
         </xsl:otherwise>
        </xsl:choose>
       </xsl:when>
       <xsl:otherwise>
        <xsl:choose>
         <xsl:when test="DEFTS_NAME">
          <xsl:apply-templates select="DEFTS_NAME"/>
         </xsl:when>
         <xsl:otherwise>
          <!-- No DEFTS_NAME entry, so put out a cr -->
          <xsl:if test="$PRETTY=1">
           <xsl:text>&#xa;  </xsl:text>
          </xsl:if>
         </xsl:otherwise>
        </xsl:choose>
       </xsl:otherwise>
      </xsl:choose>
      <!-- don't emit lob parameters for hash partitions or subpartitions -->
      <xsl:if test="$Parttype!=2 and $Subpartition=0">
       <xsl:call-template name="PutLOBParams">
        <xsl:with-param name="MetaType" select="$MetaType"/>
        <xsl:with-param name="TabBlocksize" select="$TabBlocksize"/>
       </xsl:call-template>
       <xsl:if test="$TRANSPORTABLE=1">
        <xsl:apply-templates select="LOBINDEX"/>
       </xsl:if>
      </xsl:if>
      <!-- generate transportable attributes for hash partitions and list subpartitions-->
      <xsl:if test="($Parttype=2 or ($Parttype=4 and $Subpartition=1)) and $TRANSPORTABLE=1">
       <xsl:apply-templates select="STORAGE">
        <xsl:with-param name="Nested">1</xsl:with-param>
        <xsl:with-param name="BlkSize" select="../BLOCKSIZE | BLOCKSIZE"/>
        <xsl:with-param name="Dataobjnum" select="SCHEMA_OBJ/DATAOBJ_NUM"/>
       </xsl:apply-templates>
       <xsl:apply-templates select="LOBINDEX"/>
      </xsl:if>
      <xsl:text>) </xsl:text>
     </xsl:if>
    </xsl:if>
   </xsl:when>
   <!-- OPAQUE (type#=58) -->
   <xsl:when test="$ColList/COL_LIST_ITEM[INTCOL_NUM=$Intcolnum]/TYPE_NUM=58">
    <!-- If SEGMENT_ATTRIBUTES=0, only emit LOB STORE AS
	if the user specified a lob segment name.
     -->
    <!-- bug 9235295: Subtypes of xmltype types generate column references
          with TREAT AS syntax. This is not currently supported SQL.
          Therefore, we will suppress these col refs for now.
     -->
    <xsl:if test="not($ColList/COL_LIST_ITEM[INTCOL_NUM=$Intcolnum]/ATTRNAME and
             contains($ColList/COL_LIST_ITEM[INTCOL_NUM=$Intcolnum]/ATTRNAME, 'TREAT(') and
             contains($ColList/COL_LIST_ITEM[INTCOL_NUM=$Intcolnum]/ATTRNAME, ' AS ') )">
     <xsl:if test="$SEGMENT_ATTRIBUTES=1 or 4>(SCHEMA_OBJ/FLAGS mod 8)">
      <xsl:if test="$PRETTY=1">
       <xsl:text>&#xa;</xsl:text>
      </xsl:if>
      <xsl:choose>
       <xsl:when test="$ColList/COL_LIST_ITEM[INTCOL_NUM=$Intcolnum]/OPQMD/TYPE=0">
        <xsl:choose>
         <xsl:when test="$MetaType='PartLob' or $MetaType='Lob'">
          <xsl:text> OPAQUE TYPE </xsl:text>
          <xsl:call-template name="ColNameOrAttr">
           <xsl:with-param name="ColItem" select="$ColList/COL_LIST_ITEM[INTCOL_NUM=$Intcolnum]"/>
          </xsl:call-template>
          <xsl:text> STORE AS </xsl:text>
          <xsl:call-template name="DoSecureFile">
           <xsl:with-param name="Property" select="PROPERTY | DEFPRO"/>
           <xsl:with-param name="Parttype" select="$Parttype"/>
           <xsl:with-param name="Subpartition" select="$Subpartition"/>
          </xsl:call-template>
          <xsl:text>LOB </xsl:text>
         </xsl:when>
         <xsl:when test="$MetaType='LobFrag' or $MetaType ='LobComppart'">
          <!-- Need parentheses around the lob name -->
          <xsl:text> LOB (</xsl:text>
          <xsl:call-template name="ColNameOrAttr">
           <xsl:with-param name="ColItem" select="$ColList/COL_LIST_ITEM[INTCOL_NUM=$Intcolnum]"/>
          </xsl:call-template>
          <xsl:text>) STORE AS </xsl:text>
          <xsl:call-template name="DoSecureFile">
           <xsl:with-param name="Property" select="PROPERTY | DEFPRO"/>
           <xsl:with-param name="Parttype" select="$Parttype"/>
           <xsl:with-param name="Subpartition" select="$Subpartition"/>
          </xsl:call-template>
         </xsl:when>
        </xsl:choose>
       </xsl:when>
       <xsl:when test="$MetaType='PartLob' and $TRANSPORTABLE=1
      and $ColList/COL_LIST_ITEM[INTCOL_NUM=$Intcolnum]/OPQMD/LOBCOL!=0">
        <!-- transportable and xmltype col stored as lob in partitioned table -->
        <xsl:text>LOB (</xsl:text>
        <xsl:call-template name="ColNameOrAttr">
         <xsl:with-param name="ColItem" select="$ColList/COL_LIST_ITEM[INTCOL_NUM=$Intcolnum]"/>
         <xsl:with-param name="InColDef">1</xsl:with-param>
        </xsl:call-template>
        <xsl:text>."XMLDATA") STORE AS </xsl:text>
        <xsl:call-template name="DoSecureFile">
         <xsl:with-param name="Property" select="PROPERTY | DEFPRO"/>
         <xsl:with-param name="Parttype" select="$Parttype"/>
         <xsl:with-param name="Subpartition" select="$Subpartition"/>
        </xsl:call-template>
       </xsl:when>
       <xsl:otherwise>
        <xsl:text> XMLTYPE</xsl:text>
        <xsl:if test="$XMLType_storage = 0">
         <xsl:text> COLUMN </xsl:text>
         <xsl:call-template name="ColNameOrAttr">
          <xsl:with-param name="ColItem" select="$ColList/COL_LIST_ITEM[INTCOL_NUM=$Intcolnum]"/>
         </xsl:call-template>
        </xsl:if>
        <xsl:choose>
         <xsl:when test="$ColList/COL_LIST_ITEM[INTCOL_NUM=$Intcolnum]/OPQMD/TYPE=1 and
          (($ColList/COL_LIST_ITEM[INTCOL_NUM=$Intcolnum]/OPQMD/FLAGS) mod 128 >=64)">
          <xsl:text> STORE AS </xsl:text>
          <xsl:call-template name="DoSecureFile">
           <xsl:with-param name="Property" select="PROPERTY | DEFPRO"/>
           <xsl:with-param name="Parttype" select="$Parttype"/>
           <xsl:with-param name="Subpartition" select="$Subpartition"/>
          </xsl:call-template>
          <xsl:text>BINARY XML </xsl:text>
         </xsl:when>
         <xsl:otherwise>
          <xsl:text> STORE AS </xsl:text>
          <xsl:call-template name="DoSecureFile">
           <xsl:with-param name="Property" select="PROPERTY | DEFPRO"/>
           <xsl:with-param name="Parttype" select="$Parttype"/>
           <xsl:with-param name="Subpartition" select="$Subpartition"/>
          </xsl:call-template>
          <xsl:text>CLOB </xsl:text>
         </xsl:otherwise>
        </xsl:choose>
       </xsl:otherwise>
      </xsl:choose>
      <xsl:call-template name="PutLobname">
       <xsl:with-param name="MetaType" select="$MetaType"/>
      </xsl:call-template>
      <xsl:choose>
       <!--for hash partitions or any subpartition, generate just LOB_partitioning_storage syntax-->
       <xsl:when test="$Parttype=2 or $Subpartition=1">
        <!-- tablespace name is all we may need -->
        <xsl:if test="TS_NAME">
         <xsl:text>(</xsl:text>
         <xsl:apply-templates select="TS_NAME"/>
         <xsl:text>) </xsl:text>
        </xsl:if>
       </xsl:when>
       <xsl:otherwise>
        <xsl:text>(</xsl:text>
        <xsl:choose>
         <!-- tablespace name not needed for opaques and anydata types (indicated
         by OPQMD/TYPE=0) except for hash partitioned table ($Partype=2) at
         partition level ($MetaType='LobFrag').
      -->
         <xsl:when test="$ColList/COL_LIST_ITEM[INTCOL_NUM=$Intcolnum]/OPQMD/TYPE=0
         and
         not($Parttype=2 and $MetaType='LobFrag')">
          <!-- tablespace name not need -->
          <xsl:if test="$PRETTY=1">
           <xsl:text>&#xa;  </xsl:text>
          </xsl:if>
         </xsl:when>
         <xsl:when test="$MetaType='Lob' or $MetaType='LobFrag'">
          <xsl:choose>
           <xsl:when test="TS_NAME">
            <xsl:apply-templates select="TS_NAME"/>
           </xsl:when>
           <xsl:otherwise>
            <!-- No TS_NAME entry, so put out a cr -->
            <xsl:if test="$PRETTY=1">
             <xsl:text>&#xa;  </xsl:text>
            </xsl:if>
           </xsl:otherwise>
          </xsl:choose>
         </xsl:when>
         <xsl:otherwise>
          <xsl:choose>
           <xsl:when test="DEFTS_NAME">
            <xsl:apply-templates select="DEFTS_NAME"/>
           </xsl:when>
           <xsl:otherwise>
            <!-- No DEFTS_NAME entry, so put out a cr -->
            <xsl:if test="$PRETTY=1">
             <xsl:text>&#xa;  </xsl:text>
            </xsl:if>
           </xsl:otherwise>
          </xsl:choose>
         </xsl:otherwise>
        </xsl:choose>
        <!-- Put out lob parameters if not a hash partition. -->
        <xsl:call-template name="PutLOBParams">
         <xsl:with-param name="MetaType" select="$MetaType"/>
         <xsl:with-param name="TabBlocksize" select="$TabBlocksize"/>
        </xsl:call-template>
        <xsl:if test="$TRANSPORTABLE=1">
         <xsl:apply-templates select="LOBINDEX"/>
        </xsl:if>
        <xsl:text>) </xsl:text>
       </xsl:otherwise>
      </xsl:choose>
      <!-- skip [DIS]ALLOW, etc., if this it xmltype table top level -->
      <!-- also skip if transportable and xmltype col stored as lob in partitioned table -->
      <xsl:choose>
       <xsl:when test="$XMLType_storage = 1"/>
       <xsl:when test="$MetaType='PartLob' and $TRANSPORTABLE=1
         and $ColList/COL_LIST_ITEM[INTCOL_NUM=$Intcolnum]/OPQMD/LOBCOL!=0"/>
       <xsl:when test="$ColList/COL_LIST_ITEM[INTCOL_NUM=$Intcolnum]/OPQMD/TYPE=1 and 
         (($ColList/COL_LIST_ITEM[INTCOL_NUM=$Intcolnum]/OPQMD/FLAGS) mod 128 >=64)">
        <xsl:choose>
         <xsl:when test="($ColList/COL_LIST_ITEM[INTCOL_NUM=$Intcolnum]/OPQMD/FLAGS) mod 512 >=256">
          <xsl:text>DISALLOW NONSCHEMA </xsl:text>
         </xsl:when>
         <xsl:otherwise>
          <xsl:text>ALLOW NONSCHEMA </xsl:text>
         </xsl:otherwise>
        </xsl:choose>
        <xsl:choose>
         <xsl:when test="($ColList/COL_LIST_ITEM[INTCOL_NUM=$Intcolnum]/OPQMD/FLAGS) mod 256 >=128">
          <xsl:text>ALLOW ANYSCHEMA  </xsl:text>
         </xsl:when>
         <xsl:otherwise>
          <xsl:if test="($ColList/COL_LIST_ITEM[INTCOL_NUM=$Intcolnum]/OPQMD/FLAGS) mod 512 &lt;256">
           <xsl:text>DISALLOW ANYSCHEMA </xsl:text>
          </xsl:if>
         </xsl:otherwise>
        </xsl:choose>
       </xsl:when>
      </xsl:choose>
     </xsl:if>
    </xsl:if>
   </xsl:when>
  </xsl:choose>
 </xsl:template>
 <xsl:template match="TLOBS_ITEM">
  <xsl:if test="$PRETTY=1">
   <xsl:text>&#xa;   </xsl:text>
  </xsl:if>
  <xsl:text> LOB (</xsl:text>
  <xsl:value-of select="COLNAME"/>
  <xsl:text>) STORE AS </xsl:text>
  <xsl:text>"</xsl:text>
  <xsl:value-of select="LOB_SPART_NAME"/>
  <xsl:text>"</xsl:text>
  <xsl:if test="TS_NAME">
   <xsl:text>(</xsl:text>
   <xsl:apply-templates select="TS_NAME"/>
   <xsl:text>) </xsl:text>
  </xsl:if>
 </xsl:template>
 <xsl:template name="PutLobname">
  <xsl:param name="MetaType">Lob</xsl:param>
  <xsl:if test="4>(SCHEMA_OBJ/FLAGS mod 8)">
   <!-- not sys-generated name -->
   <xsl:text>"</xsl:text>
   <xsl:choose>
    <xsl:when test="$MetaType='Lob' or $MetaType='PartLob'">
     <xsl:value-of select="SCHEMA_OBJ/NAME"/>
    </xsl:when>
    <xsl:otherwise>
     <xsl:value-of select="SCHEMA_OBJ/SUBNAME"/>
    </xsl:otherwise>
   </xsl:choose>
   <xsl:text>"</xsl:text>
  </xsl:if>
 </xsl:template>
 <xsl:template name="PutLOBParams">
  <xsl:param name="MetaType">Lob</xsl:param>
  <!-- see DoLOBStoreAs -->
  <xsl:param name="TabBlocksize">0</xsl:param>
  <xsl:choose>
   <xsl:when test="$MetaType='Lob' or $MetaType='LobFrag'">
    <xsl:call-template name="DoStorageInRow">
     <xsl:with-param name="Property" select="PROPERTY"/>
    </xsl:call-template>
    <xsl:apply-templates select="CHUNK">
     <xsl:with-param name="Blocksize" select="../BLOCKSIZE | BLOCKSIZE"/>
     <xsl:with-param name="TabBlocksize" select="$TabBlocksize"/>
    </xsl:apply-templates>
    <xsl:call-template name="DoRetention">
     <xsl:with-param name="Storage" select="STORAGE"/>
     <xsl:with-param name="DeferredStg" select="DEFERRED_STG"/>
     <xsl:with-param name="Property" select="PROPERTY"/>
     <xsl:with-param name="Flags" select="FLAGS"/>
     <xsl:with-param name="Retention" select="RETENTION"/>
     <xsl:with-param name="MinTime" select="STORAGE/GROUPS"/>
    </xsl:call-template>
    <xsl:apply-templates select="PCTVERSION">
     <xsl:with-param name="Flags" select="FLAGS"/>
     <xsl:with-param name="Property" select="PROPERTY"/>
    </xsl:apply-templates>
    <xsl:if test="$PRETTY=1">
     <xsl:text>&#xa; </xsl:text>
    </xsl:if>
    <!-- CACHE options -->
    <xsl:call-template name="DoCache">
     <xsl:with-param name="Flags" select="FLAGS"/>
     <xsl:with-param name="Property" select="PROPERTY"/>
    </xsl:call-template>
    <!-- storage -->
    <xsl:choose>
     <xsl:when test="DEFERRED_STG">
      <xsl:call-template name="DoDeferredStg">
       <xsl:with-param name="DeferredStg" select="DEFERRED_STG"/>
       <xsl:with-param name="ADT_type">LOB</xsl:with-param>
      </xsl:call-template>
     </xsl:when>
     <xsl:otherwise>
      <xsl:apply-templates select="STORAGE">
       <xsl:with-param name="Nested">1</xsl:with-param>
       <xsl:with-param name="BlkSize" select="../BLOCKSIZE | BLOCKSIZE"/>
       <xsl:with-param name="Dataobjnum" select="SCHEMA_OBJ/DATAOBJ_NUM"/>
      </xsl:apply-templates>
     </xsl:otherwise>
    </xsl:choose>
   </xsl:when>
   <!-- table level default in partitioned table -->
   <xsl:otherwise>
    <xsl:call-template name="DoStorageInRow">
     <xsl:with-param name="Property" select="DEFPRO"/>
    </xsl:call-template>
    <xsl:apply-templates select="DEFCHUNK">
     <xsl:with-param name="Blocksize" select="../DEFBLOCKSIZE | DEFBLOCKSIZE"/>
     <xsl:with-param name="TabBlocksize" select="$TabBlocksize"/>
    </xsl:apply-templates>
    <xsl:call-template name="DoRetention">
     <xsl:with-param name="Storage" select="STORAGE"/>
     <xsl:with-param name="DeferredStg" select="DEFERRED_STG"/>
     <xsl:with-param name="Property" select="DEFPRO"/>
     <xsl:with-param name="Flags" select="DEFFLAGS"/>
     <xsl:with-param name="Retention" select="DEFRETENTION"/>
     <xsl:with-param name="MinTime" select="DEFMINTIME"/>
    </xsl:call-template>
    <xsl:apply-templates select="DEFPCTVERSION">
     <xsl:with-param name="Flags" select="DEFFLAGS"/>
     <xsl:with-param name="Property" select="DEFPRO"/>
    </xsl:apply-templates>
    <xsl:if test="$PRETTY=1">
     <xsl:text>&#xa; </xsl:text>
    </xsl:if>
    <!-- CACHE options -->
    <xsl:call-template name="DoCache">
     <xsl:with-param name="Flags" select="DEFFLAGS"/>
     <xsl:with-param name="Property" select="DEFPRO"/>
    </xsl:call-template>
    <!-- storage -->
    <xsl:call-template name="DoDefStorage">
     <xsl:with-param name="Node" select="."/>
     <xsl:with-param name="BlkSize" select="$TabBlocksize"/>
    </xsl:call-template>
   </xsl:otherwise>
  </xsl:choose>
 </xsl:template>
 <xsl:template name="DoStorageInRow">
  <xsl:param name="Property" select="''"/>
  <xsl:choose>
   <xsl:when test="($Property mod 4)>=2">
    <xsl:text>ENABLE STORAGE IN ROW</xsl:text>
   </xsl:when>
   <xsl:otherwise>
    <xsl:text>DISABLE STORAGE IN ROW</xsl:text>
   </xsl:otherwise>
  </xsl:choose>
 </xsl:template>
 <xsl:template match="CHUNK | DEFCHUNK">
  <xsl:param name="Blocksize" select="''"/>
  <xsl:param name="TabBlocksize">0</xsl:param>
  <xsl:if test=".!=0">
   <xsl:text> CHUNK </xsl:text>
   <xsl:choose>
    <xsl:when test="$Blocksize">
     <xsl:value-of select="(.)*$Blocksize"/>
    </xsl:when>
    <xsl:otherwise>
     <xsl:value-of select="(.)*$TabBlocksize"/>
    </xsl:otherwise>
   </xsl:choose>
  </xsl:if>
 </xsl:template>
 <xsl:template match="PCTVERSION | DEFPCTVERSION">
  <xsl:param name="Flags" select="''"/>
  <xsl:param name="Property" select="''"/>
  <xsl:if test="(32 > ($Flags mod 64)) and 
                (2048 > ($Property mod 4096))">
   <xsl:text> PCTVERSION </xsl:text>
   <xsl:value-of select="."/>
  </xsl:if>
 </xsl:template>
 <xsl:template name="DoCache">
  <xsl:param name="Flags" select="''"/>
  <xsl:param name="Property" select="''"/>
  <!-- *******************************************************************
Template: DoCache
 The processing in DoCache parallels that in 
     exuglb.c routine 'put_lob_params'.  See also
     KKCBLATTR_ bit definitions in rdbms/src/server/dict/if/kkb.h
     (Note that CACHE NOLOGGING is illegal - SQL Ref Manual, logging_clause)
******************************************************************** -->
  <xsl:choose>
   <xsl:when test="($Flags mod 1024)>=512"> CACHE LOGGING </xsl:when>
   <xsl:when test="($Flags mod 512)>=256"> CACHE NOLOGGING </xsl:when>
   <xsl:when test="($Flags mod 32)>=16"> CACHE READS NOLOGGING </xsl:when>
   <xsl:when test="($Flags mod 16)>=8"> CACHE READS LOGGING </xsl:when>
   <xsl:when test="($Flags mod 4)>=2"> NOCACHE NOLOGGING </xsl:when>
   <xsl:when test="($Flags mod 2)>=1"> NOCACHE LOGGING </xsl:when>
   <xsl:otherwise> CACHE </xsl:otherwise>
  </xsl:choose>
  <xsl:if test="$VERSION>=1100000000">
   <!-- CSCE: ENCRYPTION, COMPRESSION, SHARING -->
   <!--  Leave ENCRYPT/NOENCRYPT OUT until partition spec is supported.
      The column spec will catch this

      Note:  This same commented out code exists in kustablc.xsl
-->
   <!--   <xsl:choose>
    <xsl:when test="($Flags mod 8192)>=4096"> ENCRYPT </xsl:when>
    <xsl:when test="($Property mod 4096)>=2048"> DECRYPT </xsl:when>
   </xsl:choose>
-->
   <xsl:choose>
    <xsl:when test="($Flags mod 16384)>=8192"> COMPRESS LOW </xsl:when>
    <xsl:when test="($Flags mod 32768)>=16384"> COMPRESS MEDIUM </xsl:when>
    <xsl:when test="($Flags mod 65536)>=32768"> COMPRESS HIGH </xsl:when>
    <xsl:when test="($Property mod 4096)>=2048"> NOCOMPRESS </xsl:when>
   </xsl:choose>
   <xsl:choose>
    <xsl:when test="($Flags mod 131072)>=65536"> DEDUPLICATE LOB </xsl:when>
    <xsl:when test="($Flags mod 262144)>=131072"> DEDUPLICATE OBJECT </xsl:when>
    <xsl:when test="($Property mod 4096)>=2048"> KEEP_DUPLICATES </xsl:when>
   </xsl:choose>
   <xsl:choose>
    <xsl:when test="($Flags mod 524288)>=262144"> VALIDATE </xsl:when>
   </xsl:choose>
  </xsl:if>
 </xsl:template>
 <xsl:template name="DoXMLTypeStorage">
  <xsl:param name="Property" select="''"/>
  <!-- *******************************************************************
Template: DoXMLTypeStorage
 Emit STORE AS CLOB for XMLSchema-based object table
 current node must be LOBMD 
******************************************************************** -->
  <xsl:choose>
   <xsl:when test="../OPQMD/FLAGS mod 128 >= 64">
    <xsl:text> STORE AS </xsl:text>
    <xsl:call-template name="DoSecureFile">
     <xsl:with-param name="Property" select="PROPERTY | DEFPRO"/>
    </xsl:call-template>
    <xsl:text>BINARY XML </xsl:text>
   </xsl:when>
   <xsl:otherwise>
    <xsl:text> STORE AS </xsl:text>
    <xsl:call-template name="DoSecureFile">
     <xsl:with-param name="Property" select="PROPERTY | DEFPRO"/>
    </xsl:call-template>
    <xsl:text>CLOB </xsl:text>
   </xsl:otherwise>
  </xsl:choose>
  <xsl:call-template name="PutLobname">
   <xsl:with-param name="MetaType">Lob</xsl:with-param>
  </xsl:call-template>
  <xsl:text> (</xsl:text>
  <xsl:choose>
   <xsl:when test="TS_NAME">
    <xsl:apply-templates select="TS_NAME"/>
   </xsl:when>
   <xsl:otherwise>
    <!-- No TS_NAME entry, so put out a cr -->
    <xsl:if test="$PRETTY=1">
     <xsl:text>&#xa;  </xsl:text>
    </xsl:if>
   </xsl:otherwise>
  </xsl:choose>
  <xsl:call-template name="PutLOBParams">
   <xsl:with-param name="MetaType">Lob</xsl:with-param>
   <xsl:with-param name="TabBlocksize" select="../BLOCKSIZE | BLOCKSIZE"/>
  </xsl:call-template>
  <!-- bug 3684091 - add this check and call for transportable. -->
  <xsl:if test="$TRANSPORTABLE=1">
   <xsl:apply-templates select="LOBINDEX"/>
  </xsl:if>
  <xsl:text>) </xsl:text>
 </xsl:template>
 <xsl:template match="LOBINDEX">
  <xsl:if test="$PRETTY=1">
   <xsl:text>&#xa;</xsl:text>
  </xsl:if>
  <xsl:text>  INDEX </xsl:text>
  <xsl:if test="4>(SCHEMA_OBJ/FLAGS mod 8)">
   <!-- not sys-generated name -->
   <xsl:text>"</xsl:text>
   <xsl:value-of select="SCHEMA_OBJ/NAME"/>
   <xsl:text>" </xsl:text>
  </xsl:if>
  <xsl:text>(</xsl:text>
  <xsl:text> INITRANS </xsl:text>
  <xsl:value-of select="INITRANS"/>
  <xsl:text> MAXTRANS </xsl:text>
  <xsl:value-of select="MAXTRANS"/>
  <xsl:apply-templates select="STORAGE">
   <xsl:with-param name="Nested">1</xsl:with-param>
   <xsl:with-param name="BlkSize" select="../BLOCKSIZE | BLOCKSIZE"/>
   <xsl:with-param name="Dataobjnum" select="SCHEMA_OBJ/DATAOBJ_NUM"/>
  </xsl:apply-templates>
  <xsl:text>) </xsl:text>
 </xsl:template>
 <!--*******************************************
  Template: DoSecureFile
  param: Property
  Emit SECUREFILE or BASICFILE as necessary
  -->
 <xsl:template name="DoSecureFile">
  <xsl:param name="Property" select="''"/>
  <xsl:param name="Parttype">0</xsl:param>
  <xsl:param name="Subpartition">0</xsl:param>
  <xsl:if test="$VERSION>=1100000000 ">
   <xsl:choose>
    <xsl:when test="($Property mod 4096)>=2048">
     <xsl:text>SECUREFILE </xsl:text>
    </xsl:when>
    <xsl:otherwise>
     <xsl:text>BASICFILE </xsl:text>
    </xsl:otherwise>
   </xsl:choose>
  </xsl:if>
 </xsl:template>
 <!--*******************************************
  Template: DoRetention
  param: Storage
  param: DeferredStg
  param: Property
  param: Flag
  param: Retention
  Emit SECUREFILE or BASICFILE as necessary
  -->
 <xsl:template name="DoRetention">
  <xsl:param name="Storage" select="''"/>
  <xsl:param name="DeferredStg" select="''"/>
  <xsl:param name="Property" select="''"/>
  <xsl:param name="Flags" select="''"/>
  <xsl:param name="Retention" select="''"/>
  <xsl:param name="MinTime" select="''"/>
  <xsl:choose>
   <xsl:when test="($Property mod 4096)>=2048 and
                             $VERSION>=1100000000">
    <xsl:variable name="LobRet">
     <xsl:choose>
      <xsl:when test="$DeferredStg and $DeferredStg/LOBRET_STG">
       <xsl:value-of select="$DeferredStg/LOBRET_STG"/>
      </xsl:when>
      <xsl:when test="$Storage/LISTS">
       <xsl:value-of select="$Storage/LISTS"/>
      </xsl:when>
      <xsl:otherwise>
       <xsl:value-of select="$Retention"/>
      </xsl:otherwise>
     </xsl:choose>
    </xsl:variable>
    <xsl:variable name="locMinTime">
     <xsl:choose>
      <xsl:when test="$DeferredStg and $DeferredStg/MINTIM_STG">
       <xsl:value-of select="$DeferredStg/MINTIM_STG"/>
      </xsl:when>
      <xsl:when test="$Storage/GROUPS">
       <xsl:value-of select="$Storage/GROUPS"/>
      </xsl:when>
      <xsl:otherwise>
       <xsl:value-of select="$MinTime"/>
      </xsl:otherwise>
     </xsl:choose>
    </xsl:variable>
    <xsl:call-template name="DoSFRETENTION">
     <!-- 11glob: LISTS => RETENTION, GROUPS => MIN RENTENTION TIME -->
     <xsl:with-param name="LobRet" select="$LobRet"/>
     <xsl:with-param name="MinTime" select="$locMinTime"/>
    </xsl:call-template>
   </xsl:when>
   <xsl:when test="($Flags mod 64) >= 32">
    <!-- RETENTION was specified -->
    <!-- Don't output 'RETENTION' if $EXPORT. 
     There is a bad behavior must support.
     If you have one dbms setup with AUM, and want to import this
     database to one without AUM, we currently work because the
     'RETENTION' keyword wasn't specified on export.  This is wrong
     because that means the resulting database will use PCTVERSION, 
     but, we can't change that now.  So, don't output RETENTION if
     $EXPORT, but we also won't output PCTVERSION either.  This
     allows us the possibility of getting retention on the destination
     because RETENTION is the default if AUM is on.-->
    <xsl:if test="$EXPORT=0">
     <xsl:text> RETENTION </xsl:text>
    </xsl:if>
   </xsl:when>
  </xsl:choose>
 </xsl:template>
 <xsl:template name="DoSFRETENTION">
  <!-- *******************************************************************
Template: DoSFRETENTION (SecureFiles ONLY)
Parameters:
 LobRet:   LOB Retention (NONE | AUTO | MIN integer | MAX)
 MinTime:  LOB MIN Retention time
******************************************************************** -->
  <xsl:param name="LobRet">0</xsl:param>
  <xsl:param name="MinTime">0</xsl:param>
  <xsl:if test="$VERSION>=1100000000">
   <xsl:choose>
    <!-- We need the '* 1's below to convert text to int -->
    <!-- RETENTION = NONE -->
    <xsl:when test="$LobRet = 0"> RETENTION NONE</xsl:when>
    <!-- RETENTION = AUTO -->
    <xsl:when test="$LobRet = 1"> RETENTION AUTO</xsl:when>
    <!-- RETENTION = MIN -->
    <xsl:when test="$LobRet = 2">
     <xsl:text> RETENTION MIN </xsl:text>
     <xsl:value-of select="$MinTime"/>
    </xsl:when>
    <!-- RETENTION = MAX -->
    <xsl:when test="$LobRet = 3"> RETENTION MAX</xsl:when>
    <xsl:otherwise>
     <xsl:text/>
    </xsl:otherwise>
   </xsl:choose>
  </xsl:if>
 </xsl:template>
</xsl:stylesheet>
