<?xml version="1.0"?>
<!-- 
 Copyright (c) 2000, 2009, Oracle and/or its affiliates.All rights reserved. 
NAME
    kuproc.xsl
DESCRIPTION
    XSLT stylesheet for XML => DDL conversion of md$_proc_t ADTs
NOTES
    Do NOT modify this file under any circumstance. Copy the file
    if you wish to use this stylesheet with an external XML/XSL parser

MODIFIED	MM/DD/YY
    lbarton     12/11/08 - bug 6269507: preserve text from source$
    lbarton     12/30/08 - Bug 7354560: procedure terminator
    rdecker     08/15/06 - Add PLSCOPE_SETTINGS 
    rapayne     11/02/05 - Bug 4715313: Reformat with XMLSpy
    htseng      06/21/04 - add support plsql_ccflags 
    lbarton     10/30/03 - ALTER_FUNCTION_T, etc. 
    htseng      09/22/03 - add alter compiler switch SPECIFICATION and BODY
    htseng      08/13/03 - compiler switch support - add alter session 
    lbarton     04/09/03 - Bug 2844111: DoSourceLines
    htseng      12/18/02 - add EXPORT parameter
    htseng      08/02/02 - add grantee parse param.,
    htseng      07/26/02 - add more parse params
    htseng      09/24/01 - fix missing kujob.xsl.
    htseng      09/04/01 - add for password varify function.
    lbarton     06/01/01 - remove oradb-style imports
    gclaborn    10/30/00 - Add external imports; change name
    lbarton     07/20/00 - use uriref in import
    lbarton	07/17/00 - bugfix: use DoTerminator
    gclaborn	07/07/00 - Set default param values
    lbarton	06/02/00 - support parsing
    lbarton	03/17/00 - Add module header
 -->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
 <!-- Import required scripts -->
 <xsl:import href="kucommon.xsl"/>
 <xsl:import href="kusource.xsl"/>
 <!-- Top-level parameters -->
 <xsl:param name="PRETTY">1</xsl:param>
 <xsl:param name="SQLTERMINATOR">0</xsl:param>
 <xsl:param name="EXPORT">0</xsl:param>
 <!-- params for parse -->
 <xsl:param name="PRS_DDL">0</xsl:param>
 <xsl:param name="PRS_DELIM">\{]`</xsl:param>
 <xsl:param name="PRS_VERB">0</xsl:param>
 <xsl:param name="PRS_OBJECT_TYPE">0</xsl:param>
 <xsl:param name="PRS_SCHEMA">0</xsl:param>
 <xsl:param name="PRS_NAME">0</xsl:param>
 <xsl:param name="PRS_GRANTEE">0</xsl:param>
 <xsl:param name="PRS_GRANTOR">0</xsl:param>
 <xsl:param name="PRS_BASE_OBJECT_SCHEMA">0</xsl:param>
 <xsl:param name="PRS_BASE_OBJECT_NAME">0</xsl:param>
 <xsl:param name="PRS_BASE_OBJECT_TYPE">0</xsl:param>
 <xsl:template match="PROCEDURE_T | FUNCTION_T | PACKAGE_T | PWDVFC_T">
  <xsl:call-template name="DoParse">
   <xsl:with-param name="Verb">CREATE</xsl:with-param>
   <xsl:with-param name="ObjectType">
    <xsl:choose>
     <xsl:when test="local-name(.)='PROCEDURE_T'">PROCEDURE</xsl:when>
     <xsl:when test="local-name(.)='FUNCTION_T'">FUNCTION</xsl:when>
     <xsl:when test="local-name(.)='PWDVFC_T'">FUNCTION</xsl:when>
     <xsl:when test="local-name(.)='PACKAGE_T'">PACKAGE</xsl:when>
     <xsl:otherwise>**NOT FOUND** </xsl:otherwise>
    </xsl:choose>
   </xsl:with-param>
   <xsl:with-param name="SchemaNode" select="SCHEMA_OBJ/OWNER_NAME"/>
   <xsl:with-param name="NameNode" select="SCHEMA_OBJ/NAME"/>
  </xsl:call-template>
  <xsl:choose>
   <xsl:when test="$EXPORT=0">
    <xsl:text>CREATE OR REPLACE </xsl:text>
    <xsl:call-template name="ProcObjType">
     <xsl:with-param name="NodeName" select="local-name(.)"/>
    </xsl:call-template>
    <xsl:text>&#x20;</xsl:text>
    <xsl:apply-templates select="SCHEMA_OBJ"/>
    <xsl:choose>
     <xsl:when test="VERS_MAJOR=1 and VERS_MINOR=0">
      <xsl:choose>
       <xsl:when test="local-name(.)='PACKAGE_T'">
        <xsl:apply-templates select="SOURCE_LINES"/>
       </xsl:when>
       <xsl:otherwise>
        <xsl:apply-templates select="SOURCE_LINES">
         <xsl:with-param name="OBJTYPE">1</xsl:with-param>
        </xsl:apply-templates>
       </xsl:otherwise>
      </xsl:choose>
     </xsl:when>
     <xsl:otherwise>
      <xsl:call-template name="DoSourceLines">
       <xsl:with-param name="SourceLines" select="SOURCE_LINES"/>
      </xsl:call-template>
     </xsl:otherwise>
    </xsl:choose>
   </xsl:when>
   <xsl:otherwise>
    <xsl:text>CREATE </xsl:text>
    <xsl:for-each select="SOURCE_LINES/SOURCE_LINES_ITEM">
     <xsl:value-of select="SOURCE"/>
    </xsl:for-each>
   </xsl:otherwise>
  </xsl:choose>
  <xsl:call-template name="DoTerminator">
   <xsl:with-param name="Text" select="SOURCE_LINES/SOURCE_LINES_ITEM[position()=last()]/SOURCE"/>
   <xsl:with-param name="TrailingNL" select="SOURCE_LINES/SOURCE_LINES_ITEM[position()=last()]/TRAILING_NL"/>
  </xsl:call-template>
 </xsl:template>
 <xsl:template match="ALTER_PROCEDURE_T | ALTER_FUNCTION_T |
                     ALTER_PACKAGE_SPEC_T | ALTER_PACKAGE_BODY_T">
  <!-- switch compiler info  -->
  <xsl:call-template name="DoParse">
   <xsl:with-param name="Verb">ALTER</xsl:with-param>
   <xsl:with-param name="ObjectType">
    <xsl:choose>
     <xsl:when test="local-name(.)='ALTER_PROCEDURE_T'">PROCEDURE</xsl:when>
     <xsl:when test="local-name(.)='ALTER_FUNCTION_T'">FUNCTION</xsl:when>
     <xsl:when test="local-name(.)='ALTER_PACKAGE_SPEC_T'">PACKAGE_SPEC</xsl:when>
     <xsl:when test="local-name(.)='ALTER_PACKAGE_BODY_T'">PACKAGE_BODY</xsl:when>
     <xsl:otherwise>**NOT FOUND** </xsl:otherwise>
    </xsl:choose>
   </xsl:with-param>
   <xsl:with-param name="SchemaNode" select="SCHEMA_OBJ/OWNER_NAME"/>
   <xsl:with-param name="NameNode" select="SCHEMA_OBJ/NAME"/>
  </xsl:call-template>
  <xsl:text>&#xa;</xsl:text>
  <xsl:text>ALTER </xsl:text>
  <xsl:call-template name="ProcObjType">
   <xsl:with-param name="NodeName" select="local-name(.)"/>
  </xsl:call-template>
  <xsl:text> </xsl:text>
  <xsl:apply-templates select="SCHEMA_OBJ"/>
  <xsl:if test="$PRETTY=1">
   <xsl:text>&#xa;</xsl:text>
  </xsl:if>
  <xsl:text>  COMPILE </xsl:text>
  <xsl:if test="COMPILER_INFO">
   <xsl:call-template name="COMPILER_SWITCH"/>
   <xsl:if test="$PRETTY=1">
    <xsl:text>&#xa;</xsl:text>
   </xsl:if>
  </xsl:if>
  <xsl:text> REUSE SETTINGS TIMESTAMP '</xsl:text>
  <xsl:value-of select="SCHEMA_OBJ/MTIME"/>
  <xsl:text>'</xsl:text>
  <xsl:if test="$SQLTERMINATOR=1">
   <xsl:text>&#xa;</xsl:text>
   <xsl:text>/</xsl:text>
   <!-- Terminate the SQL statement -->
  </xsl:if>
 </xsl:template>
 <xsl:template name="COMPILER_SWITCH">
  <xsl:choose>
   <xsl:when test="local-name(.)='ALTER_PACKAGE_SPEC_T' or 
		    local-name(.)='TYPE_T'">
    <xsl:text>SPECIFICATION </xsl:text>
   </xsl:when>
   <xsl:when test="local-name(.)='ALTER_PACKAGE_BODY_T' or 
		     local-name(.)='PACKAGE_BODY_T' or
		     local-name(.)='TYPE_BODY_T'">
    <xsl:text>BODY </xsl:text>
   </xsl:when>
  </xsl:choose>
  <xsl:if test="$PRETTY=1">
   <xsl:text>&#xa;</xsl:text>
  </xsl:if>
  <xsl:text>    PLSQL_OPTIMIZE_LEVEL=  </xsl:text>
  <xsl:value-of select="COMPILER_INFO/OPTLEVEL"/>
  <xsl:if test="$PRETTY=1">
   <xsl:text>&#xa;</xsl:text>
  </xsl:if>
  <xsl:text>    PLSQL_CODE_TYPE=  </xsl:text>
  <xsl:value-of select="COMPILER_INFO/CODETYPE"/>
  <xsl:if test="COMPILER_INFO/DEBUG">
   <xsl:if test="$PRETTY=1">
    <xsl:text>&#xa;</xsl:text>
   </xsl:if>
   <xsl:text>    PLSQL_DEBUG=  </xsl:text>
   <xsl:value-of select="COMPILER_INFO/DEBUG"/>
  </xsl:if>
  <xsl:if test="string-length(COMPILER_INFO/CCFLAGS) !=0">
   <xsl:if test="$PRETTY=1">
    <xsl:text>&#xa;</xsl:text>
   </xsl:if>
   <xsl:text>    PLSQL_CCFLAGS= '</xsl:text>
   <xsl:value-of select="COMPILER_INFO/CCFLAGS"/>
   <xsl:text>'</xsl:text>
  </xsl:if>
  <xsl:text>    PLSCOPE_SETTINGS=  '</xsl:text>
  <xsl:value-of select="COMPILER_INFO/PLSCOPE"/>
  <xsl:text>'</xsl:text>
  <xsl:if test="$PRETTY=1">
   <xsl:text>&#xa;</xsl:text>
  </xsl:if>
 </xsl:template>
 <xsl:template name="ProcObjType">
  <xsl:param name="NodeName" select="''"/>
  <xsl:choose>
   <xsl:when test="$NodeName='PROCEDURE_T'">PROCEDURE</xsl:when>
   <xsl:when test="$NodeName='FUNCTION_T'">FUNCTION</xsl:when>
   <xsl:when test="$NodeName='PWDVFC_T'">FUNCTION</xsl:when>
   <xsl:when test="$NodeName='PACKAGE_T'">PACKAGE</xsl:when>
   <xsl:when test="$NodeName='PACKAGE_SPEC_T'">PACKAGE</xsl:when>
   <xsl:when test="$NodeName='PACKAGE_BODY_T'">PACKAGE</xsl:when>
   <xsl:when test="$NodeName='ALTER_PROCEDURE_T'">PROCEDURE</xsl:when>
   <xsl:when test="$NodeName='ALTER_FUNCTION_T'">FUNCTION</xsl:when>
   <xsl:when test="$NodeName='ALTER_PACKAGE_SPEC_T'">PACKAGE</xsl:when>
   <xsl:when test="$NodeName='ALTER_PACKAGE_BODY_T'">PACKAGE</xsl:when>
   <xsl:when test="$NodeName='TYPE_BODY_T'">TYPE</xsl:when>
   <xsl:when test="$NodeName='TYPE_T'">TYPE</xsl:when>
   <xsl:otherwise>**NOT FOUND**</xsl:otherwise>
  </xsl:choose>
 </xsl:template>
</xsl:stylesheet>
