<?xml version="1.0"?>
<!-- 
 Copyright (c) 2006, 2009, Oracle and/or its affiliates. All rights reserved. 

NAME
    kuscommc.xsl
DESCRIPTION
    Templates for common and utility functions for both SXML-DDL conversion
    and ALTERXML generation.

MODIFIED        MM/DD/YY
    rapayne     11/01/09 - bug 8714709: process STORAGE(ENCRYPT) if appropriate.
    rapayne     10/10/09 - CM_SYNC: add PRS_COLUMN_ATTRIBUTE for CM 
    lbarton     07/10/09 - bug 8494344: archive compression
    rapayne     05/22/09 - bug 8391296: finish support for FLASH_CACHE and CELL_FLASH_CACHE
    adalee      04/16/09 - add FLASH_CACHE and CELL_FLASH_CACHE
    rapayne     01/12/09 - add CommentsOn template for CM.
    lbarton     07/08/08 - bug 5709159: move EscapeString to kuscommc
    rapayne     03/10/08 - Add SingleQuotedName template.
    lbarton     01/24/08 - Bug 6724820: move VERSION param to kuscommc.xsl
    lbarton     01/18/08 - Bug 6724820: table compression
    rapayne     11/01/07 - fix ddl generation for PUBLIC SYNONYMS,
    lbarton     10/09/06 - Initial version
 -->
<xsl:stylesheet version="1.0" xmlns:sxml="http://xmlns.oracle.com/ku" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
 <!-- Top level imports -->
<xsl:import href="kuscomm.xsl"/>
<!-- Top-level parameters -->
 <xsl:param name="VERSION">9999999999</xsl:param>
 <xsl:param name="PRS_COLUMN_ATTRIBUTE">0</xsl:param>
 <!-- Templates -->
 <xsl:template name="EscapeString">
  <xsl:param name="TheString" select="''"/>
  <!-- *******************************************************************
Template: EscapeString - emit a string escaping embedded single quotes
Parameters:
 TheString
******************************************************************** -->
  <xsl:variable name="SingleQuote">'</xsl:variable>
  <xsl:choose>
   <xsl:when test="contains($TheString,$SingleQuote)">
    <xsl:value-of select="substring-before($TheString,$SingleQuote)"/>
    <xsl:text>''</xsl:text>
    <xsl:call-template name="EscapeString">
     <xsl:with-param name="TheString" select="substring-after($TheString,$SingleQuote)"/>
    </xsl:call-template>
   </xsl:when>
   <xsl:otherwise>
    <xsl:value-of select="$TheString"/>
   </xsl:otherwise>
  </xsl:choose>
 </xsl:template>
 <xsl:template name="SchemaName">
  <xsl:param name="ParentNode" select="''"/>
  <!-- *******************************************************************
Template: SchemaName
 This template puts out "<schema>"."<name>"
Parameters:
 ParentNode - parent of SCHEMA and NAME
******************************************************************** -->
  <xsl:if test="$ParentNode/sxml:SCHEMA">
   <xsl:call-template name="SourceName">
    <xsl:with-param name="NameNode" select="$ParentNode/sxml:SCHEMA"/>
   </xsl:call-template>
   <xsl:text>.</xsl:text>
  </xsl:if>
  <xsl:call-template name="SourceName">
   <xsl:with-param name="NameNode" select="$ParentNode/sxml:NAME"/>
  </xsl:call-template>
 </xsl:template>
 <xsl:template name="SourceName">
  <xsl:param name="NameNode" select="''"/>
  <!-- *******************************************************************
Template: SourceName: emit the source name or schema.
 The schema/name values are from the value1 attribute, if present,
 otherwise the element content.  This lets the template handle the
 case of comparing object1 and object2 where the objects have different
 names or schemas.  The alter templates should always generate ALTERs
 to object1.  But if the objects have different names or schemas,
 object1's name and schema are in the value1 attribute rather than the
 element content, e.g.,
      <NAME value1="EMP1">EMP2</NAME>
Parameters:
 NameNode - NAME or SCHEMA node
******************************************************************** -->
  <xsl:choose>
   <xsl:when test="$NameNode/@value1">
    <xsl:call-template name="QuotedName">
     <xsl:with-param name="NameNode" select="$NameNode/@value1"/>
    </xsl:call-template>
   </xsl:when>
   <xsl:otherwise>
    <xsl:call-template name="QuotedName">
     <xsl:with-param name="NameNode" select="$NameNode"/>
    </xsl:call-template>
   </xsl:otherwise>
  </xsl:choose>
 </xsl:template>
 <xsl:template name="QuotedName">
  <xsl:param name="NameNode" select="''"/>
  <!-- *******************************************************************
Template: QuotedName
Parameters:
 NameNode - NAME node
******************************************************************** -->
  <xsl:if test="(not(contains($NameNode,'&quot;')))">"</xsl:if>
  <xsl:value-of select="$NameNode"/>
  <xsl:if test="(not(contains($NameNode,'&quot;')))">"</xsl:if>
 </xsl:template>
 <xsl:template name="SingleQuotedName">
  <xsl:param name="NameNode" select="''"/>
  <!-- *******************************************************************
Template: SingleQuotedName
Parameters:
 NameNode - NAME node
******************************************************************** -->
  <xsl:variable name="apos" select='"&apos;"'/>
  <xsl:if test="(not(contains($NameNode, $apos)))">'</xsl:if>
  <xsl:value-of select="$NameNode"/>
  <xsl:if test="(not(contains($NameNode, $apos)))">'</xsl:if>
 </xsl:template>
 <xsl:template name="TargetSchemaName">
  <xsl:param name="ParentNode" select="''"/>
  <!-- *******************************************************************
Template: TargetSchemaName
 This template puts out "<schema>"."<name>"
 It always uses the element text() value, never the @value1 attribute
Parameters:
 ParentNode - parent of SCHEMA and NAME
******************************************************************** -->
  <xsl:if test="$ParentNode/sxml:SCHEMA[not(@src='1')]">
   <xsl:call-template name="QuotedName">
    <xsl:with-param name="NameNode" select="$ParentNode/sxml:SCHEMA"/>
   </xsl:call-template>
   <xsl:text>.</xsl:text>
  </xsl:if>
  <xsl:call-template name="QuotedName">
   <xsl:with-param name="NameNode" select="$ParentNode/sxml:NAME"/>
  </xsl:call-template>
 </xsl:template>
 <xsl:template name="ColumnList">
  <xsl:param name="ColListNode" select="''"/>
  <xsl:param name="NoLog">0</xsl:param>
  <!-- *******************************************************************
Template: ColumnList
 This template puts out "<schema>"."<name>"
Parameters:
 ColListNode - COL_LIST
 NoLog - non-0 = output NO LOG if present
******************************************************************** -->
  <xsl:text>(</xsl:text>
  <xsl:for-each select="$ColListNode/sxml:COL_LIST_ITEM">
   <xsl:call-template name="QuotedName">
    <xsl:with-param name="NameNode" select="sxml:NAME"/>
   </xsl:call-template>
   <xsl:if test="($NoLog!=0) and sxml:NOLOG"> NO LOG</xsl:if>
   <xsl:if test="position()!=last()">,</xsl:if>
  </xsl:for-each>
  <xsl:text>)</xsl:text>
 </xsl:template>
 <xsl:template match="sxml:PARALLEL">
  <!-- *******************************************************************
Template: PARALLEL
******************************************************************** -->
  <xsl:if test="$PRETTY=1">
   <xsl:text>&#xa; </xsl:text>
  </xsl:if>
  <xsl:text> PARALLEL </xsl:text>
  <xsl:if test="not(.='AUTOMATIC')">
   <xsl:value-of select="."/>
  </xsl:if>
 </xsl:template>
 <xsl:template match="sxml:PARALLEL_DEGREE">
  <!-- *******************************************************************
Template: PARALLEL_DEGREE (old syntax)
******************************************************************** -->
  <xsl:if test="$PRETTY=1">
   <xsl:text>&#xa; </xsl:text>
  </xsl:if>
  <xsl:text> PARALLEL ( DEGREE </xsl:text>
  <xsl:value-of select="sxml:DEGREE"/>
  <xsl:if test="sxml:INSTANCES">
   <xsl:text> INSTANCES </xsl:text>
   <xsl:value-of select="sxml:INSTANCES"/>
  </xsl:if>
  <xsl:text>) </xsl:text>
 </xsl:template>
 <xsl:template name="SegmentAttributes">
  <xsl:param name="ParentNode" select="''"/>
  <!-- *******************************************************************
Template: SegmentAttributes
Parameters:
 ParentNode - Parent of PCTFREE, STORAGE, TABLESPACE, etc.
******************************************************************** -->
  <xsl:call-template name="PhysicalAttributes">
   <xsl:with-param name="ParentNode" select="$ParentNode"/>
  </xsl:call-template>
  <xsl:if test="$ParentNode/sxml:TABLESPACE">
   <xsl:if test="$PRETTY=1">
    <xsl:text>&#xa; </xsl:text>
   </xsl:if>
   <xsl:text> TABLESPACE "</xsl:text>
   <xsl:value-of select="$ParentNode/sxml:TABLESPACE"/>
   <xsl:text>" </xsl:text>
  </xsl:if>
  <!-- TBS: LOGGING -->
 </xsl:template>
 <xsl:template name="PhysicalAttributes">
  <xsl:param name="ParentNode" select="''"/>
  <!-- *******************************************************************
Template: PhysicalAttributes
Parameters:
 ParentNode - Parent of PCTFREE, STORAGE, TABLESPACE, etc.
******************************************************************** -->
  <xsl:if test="$ParentNode/sxml:PCTFREE">
   <xsl:text> PCTFREE </xsl:text>
   <xsl:value-of select="$ParentNode/sxml:PCTFREE"/>
  </xsl:if>
  <xsl:if test="$ParentNode/sxml:PCTUSED">
   <xsl:text> PCTUSED </xsl:text>
   <xsl:value-of select="$ParentNode/sxml:PCTUSED"/>
  </xsl:if>
  <xsl:if test="$ParentNode/sxml:INITRANS">
   <xsl:text> INITRANS </xsl:text>
   <xsl:value-of select="$ParentNode/sxml:INITRANS"/>
  </xsl:if>
  <xsl:if test="$ParentNode/sxml:LOGGING">
   <xsl:choose>
    <xsl:when test="$ParentNode/sxml:LOGGING='Y'"> LOGGING</xsl:when>
    <xsl:when test="$ParentNode/sxml:LOGGING='N'"> NOLOGGING</xsl:when>
   </xsl:choose>
  </xsl:if>
  <xsl:if test="$ParentNode/sxml:STORAGE">
   <xsl:call-template name="Storage">
    <xsl:with-param name="StorageNode" select="$ParentNode/sxml:STORAGE"/>
   </xsl:call-template>
  </xsl:if>
 </xsl:template>
 <xsl:template name="Storage">
  <xsl:param name="StorageNode" select="''"/>
  <!-- *******************************************************************
Template: Storage
Parameters:
 StorageNode - STORAGE
******************************************************************** -->
  <xsl:if test="$STORAGE!=0">
   <xsl:if test="$PRETTY=1">
    <xsl:text>&#xa; </xsl:text>
   </xsl:if>
   <xsl:text> STORAGE(</xsl:text>
   <xsl:if test="$StorageNode/sxml:INITIAL">
    <xsl:text>INITIAL </xsl:text>
    <xsl:value-of select="$StorageNode/sxml:INITIAL"/>
    <xsl:text> </xsl:text>
   </xsl:if>
   <xsl:if test="$StorageNode/sxml:NEXT">
    <xsl:text>NEXT </xsl:text>
    <xsl:value-of select="$StorageNode/sxml:NEXT"/>
    <xsl:text> </xsl:text>
   </xsl:if>
   <xsl:if test="$StorageNode/sxml:MINEXTENTS">
    <xsl:text>MINEXTENTS </xsl:text>
    <xsl:value-of select="$StorageNode/sxml:MINEXTENTS"/>
    <xsl:text> </xsl:text>
   </xsl:if>
   <xsl:if test="$StorageNode/sxml:MAXEXTENTS">
    <xsl:text>MAXEXTENTS </xsl:text>
    <xsl:value-of select="$StorageNode/sxml:MAXEXTENTS"/>
    <xsl:text> </xsl:text>
   </xsl:if>
   <xsl:if test="$PRETTY=1">
    <xsl:text>&#xa;  </xsl:text>
   </xsl:if>
   <xsl:if test="$StorageNode/sxml:PCTINCREASE">
    <xsl:text>PCTINCREASE </xsl:text>
    <xsl:value-of select="$StorageNode/sxml:PCTINCREASE"/>
    <xsl:text> </xsl:text>
   </xsl:if>
   <xsl:if test="$StorageNode/sxml:LOBRETENTION">
    <xsl:text>LOBRETENTION </xsl:text>
    <xsl:value-of select="$StorageNode/sxml:LOBRETENTION"/>
    <xsl:text> </xsl:text>
   </xsl:if>
   <xsl:if test="$StorageNode/sxml:LOBMINRETENT">
    <xsl:text>MIN </xsl:text>
    <xsl:value-of select="$StorageNode/sxml:LOBMINRETENT"/>
    <xsl:text> </xsl:text>
   </xsl:if>
   <xsl:if test="$StorageNode/sxml:MAXSIZE">
    <xsl:text>MAXSIZE </xsl:text>
    <xsl:value-of select="$StorageNode/sxml:MAXSIZE"/>
    <xsl:text> </xsl:text>
   </xsl:if>
   <xsl:if test="$StorageNode/sxml:FREELISTS">
    <xsl:text>FREELISTS </xsl:text>
    <xsl:value-of select="$StorageNode/sxml:FREELISTS"/>
    <xsl:text> </xsl:text>
   </xsl:if>
   <xsl:if test="$StorageNode/sxml:FREELIST_GROUPS">
    <xsl:text>FREELIST GROUPS </xsl:text>
    <xsl:value-of select="$StorageNode/sxml:FREELIST_GROUPS"/>
    <xsl:text> </xsl:text>
   </xsl:if>
   <xsl:if test="$StorageNode/sxml:BUFFER_POOL">
    <xsl:text>BUFFER_POOL </xsl:text>
    <xsl:value-of select="$StorageNode/sxml:BUFFER_POOL"/>
    <xsl:text> </xsl:text>
   </xsl:if>
   <xsl:if test="$StorageNode/sxml:FLASH_CACHE">
    <xsl:text>FLASH_CACHE </xsl:text>
    <xsl:value-of select="$StorageNode/sxml:FLASH_CACHE"/>
    <xsl:text> </xsl:text>
   </xsl:if>
   <xsl:if test="$StorageNode/sxml:CELL_FLASH_CACHE">
    <xsl:text>CELL_FLASH_CACHE </xsl:text>
    <xsl:value-of select="$StorageNode/sxml:CELL_FLASH_CACHE"/>
   </xsl:if>
   <xsl:text>)</xsl:text>
  </xsl:if>
 </xsl:template>
 <xsl:template name="DoCompressDDL">
  <xsl:param name="Compress" select="''"/>
  <xsl:param name="CompressLevel" select="''"/>
  <!-- *******************************************************************
Template: DoCompressDDL - emit compression syntax
Parameters:
  Compress - COMPRESS node
  CompressLevel - COMPRESS_LEVEL node
Note: DDL syntax differs depending on version
   11.2		11.1         10.x
   ========	====         ====
   OLTP		ALL
   BASIC	DIRECT_LOAD  omitted
   QUERY	NO
   ARCHIVE	NO

******************************************************************** -->
  <!-- When segment_attributes are disabled then we should not emit the COMPRESS clause -->
  <xsl:if test="$SEGMENT_ATTRIBUTES=1">
   <xsl:choose>
    <xsl:when test="$Compress='ALL' or $Compress='OLTP'">
     <xsl:choose>
      <xsl:when test="$VERSION>=1102000000"> COMPRESS FOR OLTP</xsl:when>
      <xsl:when test="$VERSION>=1100000000"> COMPRESS FOR ALL OPERATIONS</xsl:when>
      <xsl:otherwise> COMPRESS</xsl:otherwise>
     </xsl:choose>
    </xsl:when>
    <xsl:when test="$Compress='DIRECT_LOAD' or $Compress='BASIC'">
     <xsl:choose>
      <xsl:when test="$VERSION>=1102000000"> COMPRESS BASIC</xsl:when>
      <xsl:when test="$VERSION>=1100000000"> COMPRESS FOR DIRECT LOAD</xsl:when>
      <xsl:otherwise> COMPRESS</xsl:otherwise>
     </xsl:choose>
    </xsl:when>
    <xsl:when test="$Compress='QUERY' or $Compress='ARCHIVE'">
     <xsl:choose>
      <xsl:when test="$VERSION>=1102000000">
       <xsl:text> COMPRESS FOR </xsl:text>
       <xsl:value-of select="$Compress"/>
       <xsl:choose>
        <xsl:when test="$CompressLevel = 'LOW'"> LOW</xsl:when>
        <xsl:otherwise> HIGH</xsl:otherwise>
       </xsl:choose>
      </xsl:when>
      <xsl:otherwise> NOCOMPRESS</xsl:otherwise>
     </xsl:choose>
    </xsl:when>
    <xsl:when test="$Compress='N'">
     <xsl:choose>
      <xsl:when test="../sxml:ENCRYPT"> STORAGE (ENCRYPT)</xsl:when>
      <xsl:otherwise> NOCOMPRESS</xsl:otherwise>
     </xsl:choose>
    </xsl:when>
   </xsl:choose>
  </xsl:if>
 </xsl:template>
 <xsl:template match="sxml:KEYCOMPRESS">
  <!-- *******************************************************************
Template: KEYCOMPRESS
******************************************************************** -->
  <xsl:choose>
   <xsl:when test=".='N'"> NOCOMPRESS</xsl:when>
   <xsl:otherwise>
    <xsl:text> COMPRESS </xsl:text>
    <xsl:value-of select="."/>
   </xsl:otherwise>
  </xsl:choose>
 </xsl:template>
 <xsl:template match="sxml:SORT">
  <!-- *******************************************************************
Template: SORT
******************************************************************** -->
  <xsl:text> SORT</xsl:text>
 </xsl:template>
 <xsl:template match="sxml:XMLSCHEMA | sxml:ELEMENT">
  <!-- *******************************************************************
Template: XMLSCHEMA, ELEMENT
******************************************************************** -->
  <xsl:text> </xsl:text>
  <xsl:value-of select="local-name(.)"/>
  <xsl:text> "</xsl:text>
  <xsl:value-of select="."/>
  <xsl:text>"</xsl:text>
 </xsl:template>
 <xsl:template match="sxml:ID">
  <!-- *******************************************************************
Template: ID
******************************************************************** -->
  <xsl:text> </xsl:text>
  <xsl:value-of select="local-name(.)"/>
  <xsl:text> </xsl:text>
  <xsl:value-of select="."/>
  <xsl:text> </xsl:text>
 </xsl:template>
 <xsl:template name="CreSyn">
  <!-- *******************************************************************
Template: CreSyn
Current node: SYNONYM
  This template puts out
   - CREATE SYNONYM name
******************************************************************** -->
  <xsl:text> CREATE OR REPLACE </xsl:text>
  <xsl:choose>
   <xsl:when test="./sxml:SCHEMA = 'PUBLIC' and 
                    ./sxml:SCHEMA[not(@src='1')]">
    <xsl:text>PUBLIC SYNONYM </xsl:text>
    <xsl:call-template name="QuotedName">
     <xsl:with-param name="NameNode" select="./sxml:NAME"/>
    </xsl:call-template>
   </xsl:when>
   <xsl:otherwise>
    <xsl:text>SYNONYM </xsl:text>
    <xsl:call-template name="TargetSchemaName">
     <xsl:with-param name="ParentNode" select="."/>
    </xsl:call-template>
   </xsl:otherwise>
  </xsl:choose>
  <xsl:text> FOR </xsl:text>
  <xsl:if test="string-length(sxml:OBJECT_SCHEMA)!=0">
   <xsl:text>"</xsl:text>
   <xsl:value-of select="sxml:OBJECT_SCHEMA"/>
   <xsl:text>".</xsl:text>
  </xsl:if>
  <xsl:text>"</xsl:text>
  <xsl:value-of select="sxml:OBJECT_NAME"/>
  <xsl:text>"</xsl:text>
  <xsl:if test="string-length(sxml:DB_LINK)!=0">
   <xsl:text>@"</xsl:text>
   <xsl:value-of select="sxml:DB_LINK"/>
   <xsl:text>"</xsl:text>
  </xsl:if>
 </xsl:template>
 <xsl:template name="CommentsOn">
  <xsl:param name="ParentNode" select="."/>
  <xsl:param name="ObjectType" select="''"/>
  <!-- *******************************************************************
Template: CommentsOn
Current node: Parent of COMMENTS
  This template puts out
   COMMENT ON...
******************************************************************** -->
  <xsl:if test="$ParentNode/sxml:COMMENTS/sxml:OBJECT_COMMENT">
   <xsl:text>&#xa; </xsl:text>
   <xsl:text> COMMENT ON </xsl:text>
   <xsl:value-of select="$ObjectType"/>
   <xsl:text> </xsl:text>
   <xsl:call-template name="SchemaName">
    <xsl:with-param name="ParentNode" select="."/>
   </xsl:call-template>
   <xsl:text> IS '</xsl:text>
   <xsl:value-of select="$ParentNode/sxml:COMMENTS/sxml:OBJECT_COMMENT"/>
   <xsl:text>'</xsl:text>
  </xsl:if>
  <xsl:for-each select="$ParentNode/sxml:COMMENTS/sxml:COLUMN_COMMENT">
   <xsl:text>&#xa; </xsl:text>
   <xsl:text> COMMENT ON COLUMN </xsl:text>
   <xsl:call-template name="SchemaName">
    <xsl:with-param name="ParentNode" select="$ParentNode"/>
   </xsl:call-template>
   <xsl:text>.</xsl:text>
   <xsl:call-template name="QuotedName">
    <xsl:with-param name="NameNode" select="sxml:COL_LIST_ITEM"/>
   </xsl:call-template>
   <xsl:text> IS '</xsl:text>
   <xsl:value-of select="sxml:COMMENT"/>
   <xsl:text>'</xsl:text>
  </xsl:for-each>
 </xsl:template>
</xsl:stylesheet>
