<?xml version="1.0"?>
<!--
 Copyright (c) 2006, 2008, Oracle and/or its affiliates.All rights reserved. 
NAME
    kusmodtb.xsl
DESCRIPTION
    MODIFYSXML transform for TABLE SXML.

MODIFIED        MM/DD/YY
    rapayne     11/10/08 - bug 7393931: add transform param support for STORAGE, TABLESPACE, etc..
    lbarton     04/01/08 - bug 6857781: editioning view for mv logs
    lbarton     06/01/06 - Initial version
 -->
<xsl:stylesheet version="1.0" xmlns:sxml="http://xmlns.oracle.com/ku" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
 <!-- Top-level parameters -->
 <xsl:param name="REMAP_SCHEMAO1" select="''"/>
 <xsl:param name="REMAP_SCHEMAN1" select="''"/>
 <xsl:param name="REMAP_SCHEMAO2" select="''"/>
 <xsl:param name="REMAP_SCHEMAN2" select="''"/>
 <xsl:param name="REMAP_SCHEMAO3" select="''"/>
 <xsl:param name="REMAP_SCHEMAN3" select="''"/>
 <xsl:param name="REMAP_SCHEMAO4" select="''"/>
 <xsl:param name="REMAP_SCHEMAN4" select="''"/>
 <xsl:param name="REMAP_SCHEMAO5" select="''"/>
 <xsl:param name="REMAP_SCHEMAN5" select="''"/>
 <xsl:param name="REMAP_SCHEMAO6" select="''"/>
 <xsl:param name="REMAP_SCHEMAN6" select="''"/>
 <xsl:param name="REMAP_SCHEMAO7" select="''"/>
 <xsl:param name="REMAP_SCHEMAN7" select="''"/>
 <xsl:param name="REMAP_SCHEMAO8" select="''"/>
 <xsl:param name="REMAP_SCHEMAN8" select="''"/>
 <xsl:param name="REMAP_SCHEMAO9" select="''"/>
 <xsl:param name="REMAP_SCHEMAN9" select="''"/>
 <xsl:param name="REMAP_SCHEMAO10" select="''"/>
 <xsl:param name="REMAP_SCHEMAN10" select="''"/>
 <xsl:param name="REMAP_NAMEO1" select="''"/>
 <xsl:param name="REMAP_NAMEN1" select="''"/>
 <xsl:param name="REMAP_NAMEO2" select="''"/>
 <xsl:param name="REMAP_NAMEN2" select="''"/>
 <xsl:param name="REMAP_NAMEO3" select="''"/>
 <xsl:param name="REMAP_NAMEN3" select="''"/>
 <xsl:param name="REMAP_NAMEO4" select="''"/>
 <xsl:param name="REMAP_NAMEN4" select="''"/>
 <xsl:param name="REMAP_NAMEO5" select="''"/>
 <xsl:param name="REMAP_NAMEN5" select="''"/>
 <xsl:param name="REMAP_NAMEO6" select="''"/>
 <xsl:param name="REMAP_NAMEN6" select="''"/>
 <xsl:param name="REMAP_NAMEO7" select="''"/>
 <xsl:param name="REMAP_NAMEN7" select="''"/>
 <xsl:param name="REMAP_NAMEO8" select="''"/>
 <xsl:param name="REMAP_NAMEN8" select="''"/>
 <xsl:param name="REMAP_NAMEO9" select="''"/>
 <xsl:param name="REMAP_NAMEN9" select="''"/>
 <xsl:param name="REMAP_NAMEO10" select="''"/>
 <xsl:param name="REMAP_NAMEN10" select="''"/>
 <xsl:param name="REMAP_COLUMN_NAMEO1" select="''"/>
 <xsl:param name="REMAP_COLUMN_NAMEN1" select="''"/>
 <xsl:param name="REMAP_COLUMN_NAMEO2" select="''"/>
 <xsl:param name="REMAP_COLUMN_NAMEN2" select="''"/>
 <xsl:param name="REMAP_COLUMN_NAMEO3" select="''"/>
 <xsl:param name="REMAP_COLUMN_NAMEN3" select="''"/>
 <xsl:param name="REMAP_COLUMN_NAMEO4" select="''"/>
 <xsl:param name="REMAP_COLUMN_NAMEN4" select="''"/>
 <xsl:param name="REMAP_COLUMN_NAMEO5" select="''"/>
 <xsl:param name="REMAP_COLUMN_NAMEN5" select="''"/>
 <xsl:param name="REMAP_COLUMN_NAMEO6" select="''"/>
 <xsl:param name="REMAP_COLUMN_NAMEN6" select="''"/>
 <xsl:param name="REMAP_COLUMN_NAMEO7" select="''"/>
 <xsl:param name="REMAP_COLUMN_NAMEN7" select="''"/>
 <xsl:param name="REMAP_COLUMN_NAMEO8" select="''"/>
 <xsl:param name="REMAP_COLUMN_NAMEN8" select="''"/>
 <xsl:param name="REMAP_COLUMN_NAMEO9" select="''"/>
 <xsl:param name="REMAP_COLUMN_NAMEN9" select="''"/>
 <xsl:param name="REMAP_COLUMN_NAMEO10" select="''"/>
 <xsl:param name="REMAP_COLUMN_NAMEN10" select="''"/>
 <xsl:param name="REMAP_COLUMN_NAME_SCHEMAO1" select="''"/>
 <xsl:param name="REMAP_COLUMN_NAME_TABLEO1" select="''"/>
 <xsl:param name="REMAP_COLUMN_NAME_SCHEMAO2" select="''"/>
 <xsl:param name="REMAP_COLUMN_NAME_TABLEO2" select="''"/>
 <xsl:param name="REMAP_COLUMN_NAME_SCHEMAO3" select="''"/>
 <xsl:param name="REMAP_COLUMN_NAME_TABLEO3" select="''"/>
 <xsl:param name="REMAP_COLUMN_NAME_SCHEMAO4" select="''"/>
 <xsl:param name="REMAP_COLUMN_NAME_TABLEO4" select="''"/>
 <xsl:param name="REMAP_COLUMN_NAME_SCHEMAO5" select="''"/>
 <xsl:param name="REMAP_COLUMN_NAME_TABLEO5" select="''"/>
 <xsl:param name="REMAP_COLUMN_NAME_SCHEMAO6" select="''"/>
 <xsl:param name="REMAP_COLUMN_NAME_TABLEO6" select="''"/>
 <xsl:param name="REMAP_COLUMN_NAME_SCHEMAO7" select="''"/>
 <xsl:param name="REMAP_COLUMN_NAME_TABLEO7" select="''"/>
 <xsl:param name="REMAP_COLUMN_NAME_SCHEMAO8" select="''"/>
 <xsl:param name="REMAP_COLUMN_NAME_TABLEO8" select="''"/>
 <xsl:param name="REMAP_COLUMN_NAME_SCHEMAO9" select="''"/>
 <xsl:param name="REMAP_COLUMN_NAME_TABLEO9" select="''"/>
 <xsl:param name="REMAP_COLUMN_NAME_SCHEMAO10" select="''"/>
 <xsl:param name="REMAP_COLUMN_NAME_TABLEO10" select="''"/>
 <xsl:param name="CONSTRAINTS">1</xsl:param>
 <xsl:param name="REF_CONSTRAINTS">1</xsl:param>
 <xsl:param name="SEGMENT_ATTRIBUTES">1</xsl:param>
 <xsl:param name="STORAGE">1</xsl:param>
 <xsl:param name="TABLESPACE">1</xsl:param>
 <!-- Templates -->
 <xsl:template match="@*|node()">
  <!-- *******************************************************************
 copy everything from the input file
******************************************************************** -->
  <xsl:copy>
   <xsl:apply-templates select="@*|node()"/>
  </xsl:copy>
 </xsl:template>
 <xsl:template match="sxml:STORAGE">
  <!-- *******************************************************************
Template: copy STORAGE unless storage transform parameter is off.
******************************************************************** -->
  <xsl:if test="not($STORAGE = 0)">
   <xsl:copy>
    <xsl:apply-templates select="@*|node()"/>
   </xsl:copy>
  </xsl:if>
 </xsl:template>
 <xsl:template match="sxml:SEGMENT_ATTRIBUTES">
  <!-- *******************************************************************
Template: copy SEGMENT_ATTRIBUTES unless segattribute transform parameter is off.
******************************************************************** -->
  <xsl:if test="not($SEGMENT_ATTRIBUTES = 0)">
   <xsl:copy>
    <xsl:apply-templates select="@*|node()"/>
   </xsl:copy>
  </xsl:if>
 </xsl:template>
 <xsl:template match="sxml:TABLESPACE">
  <!-- *******************************************************************
Template: copy TABLESPACE unless tablespace transform parameter is off.
******************************************************************** -->
  <xsl:if test="not($TABLESPACE = 0)">
   <xsl:copy>
    <xsl:apply-templates select="@*|node()"/>
   </xsl:copy>
  </xsl:if>
 </xsl:template>
 <xsl:template match="sxml:CHECK_CONSTRAINT_LIST                | 
                                     sxml:PRIMARY_KEY_CONSTRAINT_LIST   |
                                     sxml:FOREIGN_KEY_CONSTRAINT_LIST    |
                                     sxml:SCOPE_KEY_CONSTRAINT_LIST       |
                                     sxml:ROWID_KEY_CONSTRAINT_LIST       |
                                     sxml:UNIQUE_KEY_CONSTRAINT_LIST">
  <!-- *******************************************************************
Template: copy CONSTRAINTS unless constraint transform parameter is off.
******************************************************************** -->
  <xsl:if test="not($CONSTRAINTS = 0)">
   <xsl:copy>
    <xsl:apply-templates select="@*|node()"/>
   </xsl:copy>
  </xsl:if>
 </xsl:template>
 <xsl:template match="sxml:FOREIGN_KEY_CONSTRAINT_LIST">
  <!-- *******************************************************************
Template: copy REF_CONSTRAINTS  unless ref_constraint transform parameter is off.
******************************************************************** -->
  <xsl:if test="not($REF_CONSTRAINTS = 0)">
   <xsl:copy>
    <xsl:apply-templates select="@*|node()"/>
   </xsl:copy>
  </xsl:if>
 </xsl:template>
 <xsl:template match="sxml:TABLE/sxml:SCHEMA |
                      sxml:RELATIONAL_TABLE/sxml:FOREIGN_KEY_CONSTRAINT_LIST/sxml:FOREIGN_KEY_CONSTRAINT_LIST_ITEM/sxml:REFERENCES/sxml:SCHEMA |
                      sxml:MATERIALIZED_VIEW_LOG/sxml:ON_TABLE/sxml:SCHEMA |
                      sxml:INDEX/sxml:TABLE_INDEX/sxml:ON_TABLE/sxml:SCHEMA |
                      sxml:INDEX/sxml:BITMAP_JOIN_INDEX/sxml:ON_TABLE/sxml:SCHEMA |
                      sxml:INDEX/sxml:BITMAP_JOIN_INDEX/sxml:COL_LIST/sxml:COL_LIST_ITEM/sxml:SCHEMA |
                      sxml:INDEX/sxml:BITMAP_JOIN_INDEX/sxml:JOIN_TABLE_LIST/sxml:JOIN_TABLE_LIST_ITEM/sxml:SCHEMA |
                      sxml:INDEX/sxml:BITMAP_JOIN_INDEX/sxml:WHERE_LIST/sxml:WHERE_LIST_ITEM/sxml:JOIN_LIST/sxml:JOIN_LIST_ITEM/sxml:SCHEMA |
                      sxml:COLUMN_REF/sxml:SCHEMA |
                      sxml:FROM_ITEM/sxml:SCHEMA">
  <!-- *******************************************************************
Template: SCHEMA - remap schemas
******************************************************************** -->
  <xsl:choose>
   <xsl:when test="string-length($REMAP_SCHEMAO1)=0">
    <xsl:copy>
     <xsl:apply-templates select="@*|node()"/>
    </xsl:copy>
   </xsl:when>
   <xsl:when test=".=$REMAP_SCHEMAO1">
    <xsl:element name="SCHEMA">
     <xsl:value-of select="$REMAP_SCHEMAN1"/>
    </xsl:element>
   </xsl:when>
   <xsl:when test=".=$REMAP_SCHEMAO2">
    <xsl:element name="SCHEMA">
     <xsl:value-of select="$REMAP_SCHEMAN2"/>
    </xsl:element>
   </xsl:when>
   <xsl:when test=".=$REMAP_SCHEMAO3">
    <xsl:element name="SCHEMA">
     <xsl:value-of select="$REMAP_SCHEMAN3"/>
    </xsl:element>
   </xsl:when>
   <xsl:when test=".=$REMAP_SCHEMAO4">
    <xsl:element name="SCHEMA">
     <xsl:value-of select="$REMAP_SCHEMAN4"/>
    </xsl:element>
   </xsl:when>
   <xsl:when test=".=$REMAP_SCHEMAO5">
    <xsl:element name="SCHEMA">
     <xsl:value-of select="$REMAP_SCHEMAN5"/>
    </xsl:element>
   </xsl:when>
   <xsl:when test=".=$REMAP_SCHEMAO6">
    <xsl:element name="SCHEMA">
     <xsl:value-of select="$REMAP_SCHEMAN6"/>
    </xsl:element>
   </xsl:when>
   <xsl:when test=".=$REMAP_SCHEMAO7">
    <xsl:element name="SCHEMA">
     <xsl:value-of select="$REMAP_SCHEMAN7"/>
    </xsl:element>
   </xsl:when>
   <xsl:when test=".=$REMAP_SCHEMAO8">
    <xsl:element name="SCHEMA">
     <xsl:value-of select="$REMAP_SCHEMAN8"/>
    </xsl:element>
   </xsl:when>
   <xsl:when test=".=$REMAP_SCHEMAO9">
    <xsl:element name="SCHEMA">
     <xsl:value-of select="$REMAP_SCHEMAN9"/>
    </xsl:element>
   </xsl:when>
   <xsl:when test=".=$REMAP_SCHEMAO10">
    <xsl:element name="SCHEMA">
     <xsl:value-of select="$REMAP_SCHEMAN10"/>
    </xsl:element>
   </xsl:when>
   <xsl:otherwise>
    <xsl:copy>
     <xsl:apply-templates select="@*|node()"/>
    </xsl:copy>
   </xsl:otherwise>
  </xsl:choose>
 </xsl:template>
 <xsl:template match="sxml:TABLE/sxml:NAME | 
                     sxml:TABLE/sxml:RELATIONAL_TABLE/sxml:FOREIGN_KEY_CONSTRAINT_LIST/sxml:FOREIGN_KEY_CONSTRAINT_LIST_ITEM/sxml:REFERENCES/sxml:NAME |
                     sxml:MATERIALIZED_VIEW_LOG/sxml:ON_TABLE/sxml:NAME |
                     sxml:INDEX/sxml:TABLE_INDEX/sxml:ON_TABLE/sxml:NAME |
                      sxml:INDEX/sxml:BITMAP_JOIN_INDEX/sxml:ON_TABLE/sxml:NAME |
                      sxml:INDEX/sxml:BITMAP_JOIN_INDEX/sxml:COL_LIST/sxml:COL_LIST_ITEM/sxml:NAME |
                      sxml:INDEX/sxml:BITMAP_JOIN_INDEX/sxml:JOIN_TABLE_LIST/sxml:JOIN_TABLE_LIST_ITEM/sxml:NAME |
                      sxml:INDEX/sxml:BITMAP_JOIN_INDEX/sxml:WHERE_LIST/sxml:WHERE_LIST_ITEM/sxml:JOIN_LIST/sxml:JOIN_LIST_ITEM/sxml:NAME">
  <!-- *******************************************************************
Template: NAME - remap names
******************************************************************** -->
  <xsl:choose>
   <xsl:when test="string-length($REMAP_NAMEO1)=0">
    <xsl:copy>
     <xsl:apply-templates select="@*|node()"/>
    </xsl:copy>
   </xsl:when>
   <xsl:when test=".=$REMAP_NAMEO1">
    <xsl:element name="NAME">
     <xsl:value-of select="$REMAP_NAMEN1"/>
    </xsl:element>
   </xsl:when>
   <xsl:when test=".=$REMAP_NAMEO2">
    <xsl:element name="NAME">
     <xsl:value-of select="$REMAP_NAMEN2"/>
    </xsl:element>
   </xsl:when>
   <xsl:when test=".=$REMAP_NAMEO3">
    <xsl:element name="NAME">
     <xsl:value-of select="$REMAP_NAMEN3"/>
    </xsl:element>
   </xsl:when>
   <xsl:when test=".=$REMAP_NAMEO4">
    <xsl:element name="NAME">
     <xsl:value-of select="$REMAP_NAMEN4"/>
    </xsl:element>
   </xsl:when>
   <xsl:when test=".=$REMAP_NAMEO5">
    <xsl:element name="NAME">
     <xsl:value-of select="$REMAP_NAMEN5"/>
    </xsl:element>
   </xsl:when>
   <xsl:when test=".=$REMAP_NAMEO6">
    <xsl:element name="NAME">
     <xsl:value-of select="$REMAP_NAMEN6"/>
    </xsl:element>
   </xsl:when>
   <xsl:when test=".=$REMAP_NAMEO7">
    <xsl:element name="NAME">
     <xsl:value-of select="$REMAP_NAMEN7"/>
    </xsl:element>
   </xsl:when>
   <xsl:when test=".=$REMAP_NAMEO8">
    <xsl:element name="NAME">
     <xsl:value-of select="$REMAP_NAMEN8"/>
    </xsl:element>
   </xsl:when>
   <xsl:when test=".=$REMAP_NAMEO9">
    <xsl:element name="NAME">
     <xsl:value-of select="$REMAP_NAMEN9"/>
    </xsl:element>
   </xsl:when>
   <xsl:when test=".=$REMAP_NAMEO10">
    <xsl:element name="NAME">
     <xsl:value-of select="$REMAP_NAMEN10"/>
    </xsl:element>
   </xsl:when>
   <xsl:otherwise>
    <xsl:copy>
     <xsl:apply-templates select="@*|node()"/>
    </xsl:copy>
   </xsl:otherwise>
  </xsl:choose>
 </xsl:template>
 <xsl:template match="sxml:COLUMN_REF/sxml:TABLE | sxml:FROM_ITEM/sxml:TABLE">
  <!-- *******************************************************************
       Template: COLUMN_REF/TABLE or FROM_ITEM/TABLE
******************************************************************** -->
  <xsl:choose>
   <xsl:when test="string-length($REMAP_NAMEO1)=0">
    <xsl:copy>
     <xsl:apply-templates select="@*|node()"/>
    </xsl:copy>
   </xsl:when>
   <xsl:when test=".=$REMAP_NAMEO1">
    <xsl:element name="TABLE">
     <xsl:value-of select="$REMAP_NAMEN1"/>
    </xsl:element>
   </xsl:when>
   <xsl:when test=".=$REMAP_NAMEO2">
    <xsl:element name="TABLE">
     <xsl:value-of select="$REMAP_NAMEN2"/>
    </xsl:element>
   </xsl:when>
   <xsl:when test=".=$REMAP_NAMEO3">
    <xsl:element name="TABLE">
     <xsl:value-of select="$REMAP_NAMEN3"/>
    </xsl:element>
   </xsl:when>
   <xsl:when test=".=$REMAP_NAMEO4">
    <xsl:element name="TABLE">
     <xsl:value-of select="$REMAP_NAMEN4"/>
    </xsl:element>
   </xsl:when>
   <xsl:when test=".=$REMAP_NAMEO5">
    <xsl:element name="TABLE">
     <xsl:value-of select="$REMAP_NAMEN5"/>
    </xsl:element>
   </xsl:when>
   <xsl:when test=".=$REMAP_NAMEO6">
    <xsl:element name="TABLE">
     <xsl:value-of select="$REMAP_NAMEN6"/>
    </xsl:element>
   </xsl:when>
   <xsl:when test=".=$REMAP_NAMEO7">
    <xsl:element name="TABLE">
     <xsl:value-of select="$REMAP_NAMEN7"/>
    </xsl:element>
   </xsl:when>
   <xsl:when test=".=$REMAP_NAMEO8">
    <xsl:element name="TABLE">
     <xsl:value-of select="$REMAP_NAMEN8"/>
    </xsl:element>
   </xsl:when>
   <xsl:when test=".=$REMAP_NAMEO9">
    <xsl:element name="TABLE">
     <xsl:value-of select="$REMAP_NAMEN9"/>
    </xsl:element>
   </xsl:when>
   <xsl:when test=".=$REMAP_NAMEO10">
    <xsl:element name="TABLE">
     <xsl:value-of select="$REMAP_NAMEN10"/>
    </xsl:element>
   </xsl:when>
   <xsl:otherwise>
    <xsl:copy>
     <xsl:apply-templates select="@*|node()"/>
    </xsl:copy>
   </xsl:otherwise>
  </xsl:choose>
 </xsl:template>
 <xsl:template match="sxml:RELATIONAL_TABLE/sxml:COL_LIST/sxml:COL_LIST_ITEM/sxml:NAME |
                      sxml:TABLE_INDEX/sxml:COL_LIST/sxml:COL_LIST_ITEM/sxml:NAME |
                      sxml:MATERIALIZED_VIEW_LOG/sxml:RECORDS/sxml:COL_LIST/sxml:COL_LIST_ITEM/sxml:NAME">
  <!-- *******************************************************************
       Template: COL_LIST_ITEM/NAME - remap names
******************************************************************** -->
  <xsl:choose>
   <xsl:when test="string-length($REMAP_COLUMN_NAMEO1)=0">
    <xsl:copy>
     <xsl:apply-templates select="@*|node()"/>
    </xsl:copy>
   </xsl:when>
   <xsl:when test=".=$REMAP_COLUMN_NAMEO1">
    <xsl:element name="NAME">
     <xsl:value-of select="$REMAP_COLUMN_NAMEN1"/>
    </xsl:element>
   </xsl:when>
   <xsl:when test=".=$REMAP_COLUMN_NAMEO2">
    <xsl:element name="NAME">
     <xsl:value-of select="$REMAP_COLUMN_NAMEN2"/>
    </xsl:element>
   </xsl:when>
   <xsl:when test=".=$REMAP_COLUMN_NAMEO3">
    <xsl:element name="NAME">
     <xsl:value-of select="$REMAP_COLUMN_NAMEN3"/>
    </xsl:element>
   </xsl:when>
   <xsl:when test=".=$REMAP_COLUMN_NAMEO4">
    <xsl:element name="NAME">
     <xsl:value-of select="$REMAP_COLUMN_NAMEN4"/>
    </xsl:element>
   </xsl:when>
   <xsl:when test=".=$REMAP_COLUMN_NAMEO5">
    <xsl:element name="NAME">
     <xsl:value-of select="$REMAP_COLUMN_NAMEN5"/>
    </xsl:element>
   </xsl:when>
   <xsl:when test=".=$REMAP_COLUMN_NAMEO6">
    <xsl:element name="NAME">
     <xsl:value-of select="$REMAP_COLUMN_NAMEN6"/>
    </xsl:element>
   </xsl:when>
   <xsl:when test=".=$REMAP_COLUMN_NAMEO7">
    <xsl:element name="NAME">
     <xsl:value-of select="$REMAP_COLUMN_NAMEN7"/>
    </xsl:element>
   </xsl:when>
   <xsl:when test=".=$REMAP_COLUMN_NAMEO8">
    <xsl:element name="NAME">
     <xsl:value-of select="$REMAP_COLUMN_NAMEN8"/>
    </xsl:element>
   </xsl:when>
   <xsl:when test=".=$REMAP_COLUMN_NAMEO9">
    <xsl:element name="NAME">
     <xsl:value-of select="$REMAP_COLUMN_NAMEN9"/>
    </xsl:element>
   </xsl:when>
   <xsl:when test=".=$REMAP_COLUMN_NAMEO10">
    <xsl:element name="NAME">
     <xsl:value-of select="$REMAP_COLUMN_NAMEN10"/>
    </xsl:element>
   </xsl:when>
   <xsl:otherwise>
    <xsl:copy>
     <xsl:apply-templates select="@*|node()"/>
    </xsl:copy>
   </xsl:otherwise>
  </xsl:choose>
 </xsl:template>
 <xsl:template match="sxml:BITMAP_JOIN_INDEX/sxml:COL_LIST/sxml:COL_LIST_ITEM/sxml:COL |
                      sxml:BITMAP_JOIN_INDEX/sxml:WHERE_LIST/sxml:WHERE_LIST_ITEM/sxml:JOIN_LIST/sxml:JOIN_LIST_ITEM/sxml:COL">
  <!-- *******************************************************************
       Template: BITMAP_JOIN_INDEX/COL_LIST/COL_LIST_ITEM/COL - remap names
******************************************************************** -->
  <xsl:choose>
   <xsl:when test="string-length($REMAP_COLUMN_NAMEO1)=0">
    <xsl:copy>
     <xsl:apply-templates select="@*|node()"/>
    </xsl:copy>
   </xsl:when>
   <xsl:when test=".=$REMAP_COLUMN_NAMEO1
                   and ../sxml:SCHEMA=$REMAP_COLUMN_NAME_SCHEMAO1
                   and ../sxml:NAME=$REMAP_COLUMN_NAME_TABLEO1">
    <xsl:element name="COL">
     <xsl:value-of select="$REMAP_COLUMN_NAMEN1"/>
    </xsl:element>
   </xsl:when>
   <xsl:when test=".=$REMAP_COLUMN_NAMEO2
                   and ../sxml:SCHEMA=$REMAP_COLUMN_NAME_SCHEMAO2
                   and ../sxml:NAME=$REMAP_COLUMN_NAME_TABLEO2">
    <xsl:element name="COL">
     <xsl:value-of select="$REMAP_COLUMN_NAMEN2"/>
    </xsl:element>
   </xsl:when>
   <xsl:when test=".=$REMAP_COLUMN_NAMEO3
                   and ../sxml:SCHEMA=$REMAP_COLUMN_NAME_SCHEMAO3
                   and ../sxml:NAME=$REMAP_COLUMN_NAME_TABLEO3">
    <xsl:element name="COL">
     <xsl:value-of select="$REMAP_COLUMN_NAMEN3"/>
    </xsl:element>
   </xsl:when>
   <xsl:when test=".=$REMAP_COLUMN_NAMEO4
                   and ../sxml:SCHEMA=$REMAP_COLUMN_NAME_SCHEMAO4
                   and ../sxml:NAME=$REMAP_COLUMN_NAME_TABLEO4">
    <xsl:element name="COL">
     <xsl:value-of select="$REMAP_COLUMN_NAMEN4"/>
    </xsl:element>
   </xsl:when>
   <xsl:when test=".=$REMAP_COLUMN_NAMEO5
                   and ../sxml:SCHEMA=$REMAP_COLUMN_NAME_SCHEMAO5
                   and ../sxml:NAME=$REMAP_COLUMN_NAME_TABLEO5">
    <xsl:element name="COL">
     <xsl:value-of select="$REMAP_COLUMN_NAMEN5"/>
    </xsl:element>
   </xsl:when>
   <xsl:when test=".=$REMAP_COLUMN_NAMEO6
                   and ../sxml:SCHEMA=$REMAP_COLUMN_NAME_SCHEMAO6
                   and ../sxml:NAME=$REMAP_COLUMN_NAME_TABLEO6">
    <xsl:element name="COL">
     <xsl:value-of select="$REMAP_COLUMN_NAMEN6"/>
    </xsl:element>
   </xsl:when>
   <xsl:when test=".=$REMAP_COLUMN_NAMEO7
                   and ../sxml:SCHEMA=$REMAP_COLUMN_NAME_SCHEMAO7
                   and ../sxml:NAME=$REMAP_COLUMN_NAME_TABLEO7">
    <xsl:element name="COL">
     <xsl:value-of select="$REMAP_COLUMN_NAMEN7"/>
    </xsl:element>
   </xsl:when>
   <xsl:when test=".=$REMAP_COLUMN_NAMEO8
                   and ../sxml:SCHEMA=$REMAP_COLUMN_NAME_SCHEMAO8
                   and ../sxml:NAME=$REMAP_COLUMN_NAME_TABLEO8">
    <xsl:element name="COL">
     <xsl:value-of select="$REMAP_COLUMN_NAMEN8"/>
    </xsl:element>
   </xsl:when>
   <xsl:when test=".=$REMAP_COLUMN_NAMEO9
                   and ../sxml:SCHEMA=$REMAP_COLUMN_NAME_SCHEMAO9
                   and ../sxml:NAME=$REMAP_COLUMN_NAME_TABLEO9">
    <xsl:element name="COL">
     <xsl:value-of select="$REMAP_COLUMN_NAMEN9"/>
    </xsl:element>
   </xsl:when>
   <xsl:when test=".=$REMAP_COLUMN_NAMEO10
                   and ../sxml:SCHEMA=$REMAP_COLUMN_NAME_SCHEMAO10
                   and ../sxml:NAME=$REMAP_COLUMN_NAME_TABLEO10">
    <xsl:element name="COL">
     <xsl:value-of select="$REMAP_COLUMN_NAMEN10"/>
    </xsl:element>
   </xsl:when>
   <xsl:otherwise>
    <xsl:copy>
     <xsl:apply-templates select="@*|node()"/>
    </xsl:copy>
   </xsl:otherwise>
  </xsl:choose>
 </xsl:template>
 <xsl:template match="sxml:RELATIONAL_TABLE/sxml:FOREIGN_KEY_CONSTRAINT_LIST/sxml:FOREIGN_KEY_CONSTRAINT_LIST_ITEM/sxml:COL_LIST/sxml:COL_LIST_ITEM/sxml:NAME">
  <!-- *******************************************************************
     Template: FOREIGN_KEY_CONSTRAINT_LIST/../COL_LIST_ITEM/NAME - remap names
******************************************************************** -->
  <xsl:choose>
   <xsl:when test="string-length($REMAP_COLUMN_NAMEO1)=0">
    <xsl:copy>
     <xsl:apply-templates select="@*|node()"/>
    </xsl:copy>
   </xsl:when>
   <xsl:when test=".=$REMAP_COLUMN_NAMEO1
                   and /sxml:TABLE/sxml:SCHEMA=$REMAP_COLUMN_NAME_SCHEMAO1
                   and /sxml:TABLE/sxml:NAME=$REMAP_COLUMN_NAME_TABLEO1">
    <xsl:element name="NAME">
     <xsl:value-of select="$REMAP_COLUMN_NAMEN1"/>
    </xsl:element>
   </xsl:when>
   <xsl:when test=".=$REMAP_COLUMN_NAMEO2
                   and /sxml:TABLE/sxml:SCHEMA=$REMAP_COLUMN_NAME_SCHEMAO2
                   and /sxml:TABLE/sxml:NAME=$REMAP_COLUMN_NAME_TABLEO2">
    <xsl:element name="NAME">
     <xsl:value-of select="$REMAP_COLUMN_NAMEN2"/>
    </xsl:element>
   </xsl:when>
   <xsl:when test=".=$REMAP_COLUMN_NAMEO3
                   and /sxml:TABLE/sxml:SCHEMA=$REMAP_COLUMN_NAME_SCHEMAO3
                   and /sxml:TABLE/sxml:NAME=$REMAP_COLUMN_NAME_TABLEO3">
    <xsl:element name="NAME">
     <xsl:value-of select="$REMAP_COLUMN_NAMEN3"/>
    </xsl:element>
   </xsl:when>
   <xsl:when test=".=$REMAP_COLUMN_NAMEO4
                   and /sxml:TABLE/sxml:SCHEMA=$REMAP_COLUMN_NAME_SCHEMAO4
                   and /sxml:TABLE/sxml:NAME=$REMAP_COLUMN_NAME_TABLEO4">
    <xsl:element name="NAME">
     <xsl:value-of select="$REMAP_COLUMN_NAMEN4"/>
    </xsl:element>
   </xsl:when>
   <xsl:when test=".=$REMAP_COLUMN_NAMEO5
                   and /sxml:TABLE/sxml:SCHEMA=$REMAP_COLUMN_NAME_SCHEMAO5
                   and /sxml:TABLE/sxml:NAME=$REMAP_COLUMN_NAME_TABLEO5">
    <xsl:element name="NAME">
     <xsl:value-of select="$REMAP_COLUMN_NAMEN5"/>
    </xsl:element>
   </xsl:when>
   <xsl:when test=".=$REMAP_COLUMN_NAMEO6
                   and /sxml:TABLE/sxml:SCHEMA=$REMAP_COLUMN_NAME_SCHEMAO6
                   and /sxml:TABLE/sxml:NAME=$REMAP_COLUMN_NAME_TABLEO6">
    <xsl:element name="NAME">
     <xsl:value-of select="$REMAP_COLUMN_NAMEN6"/>
    </xsl:element>
   </xsl:when>
   <xsl:when test=".=$REMAP_COLUMN_NAMEO7
                   and /sxml:TABLE/sxml:SCHEMA=$REMAP_COLUMN_NAME_SCHEMAO7
                   and /sxml:TABLE/sxml:NAME=$REMAP_COLUMN_NAME_TABLEO7">
    <xsl:element name="NAME">
     <xsl:value-of select="$REMAP_COLUMN_NAMEN7"/>
    </xsl:element>
   </xsl:when>
   <xsl:when test=".=$REMAP_COLUMN_NAMEO8
                   and /sxml:TABLE/sxml:SCHEMA=$REMAP_COLUMN_NAME_SCHEMAO8
                   and /sxml:TABLE/sxml:NAME=$REMAP_COLUMN_NAME_TABLEO8">
    <xsl:element name="NAME">
     <xsl:value-of select="$REMAP_COLUMN_NAMEN8"/>
    </xsl:element>
   </xsl:when>
   <xsl:when test=".=$REMAP_COLUMN_NAMEO9
                   and /sxml:TABLE/sxml:SCHEMA=$REMAP_COLUMN_NAME_SCHEMAO9
                   and /sxml:TABLE/sxml:NAME=$REMAP_COLUMN_NAME_TABLEO9">
    <xsl:element name="NAME">
     <xsl:value-of select="$REMAP_COLUMN_NAMEN9"/>
    </xsl:element>
   </xsl:when>
   <xsl:when test=".=$REMAP_COLUMN_NAMEO10
                   and /sxml:TABLE/sxml:SCHEMA=$REMAP_COLUMN_NAME_SCHEMAO10
                   and /sxml:TABLE/sxml:NAME=$REMAP_COLUMN_NAME_TABLEO10">
    <xsl:element name="NAME">
     <xsl:value-of select="$REMAP_COLUMN_NAMEN10"/>
    </xsl:element>
   </xsl:when>
   <xsl:otherwise>
    <xsl:copy>
     <xsl:apply-templates select="@*|node()"/>
    </xsl:copy>
   </xsl:otherwise>
  </xsl:choose>
 </xsl:template>
 <xsl:template match="sxml:RELATIONAL_TABLE/sxml:FOREIGN_KEY_CONSTRAINT_LIST/sxml:FOREIGN_KEY_CONSTRAINT_LIST_ITEM/sxml:REFERENCES/sxml:COL_LIST/sxml:COL_LIST_ITEM/sxml:NAME">
  <!-- *******************************************************************
  Template: ../REFERENCES/COL_LIST_ITEM/NAME - remap names
******************************************************************** -->
  <xsl:choose>
   <xsl:when test="string-length($REMAP_COLUMN_NAMEO1)=0">
    <xsl:copy>
     <xsl:apply-templates select="@*|node()"/>
    </xsl:copy>
   </xsl:when>
   <xsl:when test=".=$REMAP_COLUMN_NAMEO1
                   and ../../../sxml:SCHEMA=$REMAP_COLUMN_NAME_SCHEMAO1
                   and ../../../sxml:NAME=$REMAP_COLUMN_NAME_TABLEO1">
    <xsl:element name="NAME">
     <xsl:value-of select="$REMAP_COLUMN_NAMEN1"/>
    </xsl:element>
   </xsl:when>
   <xsl:when test=".=$REMAP_COLUMN_NAMEO2
                   and ../../../sxml:SCHEMA=$REMAP_COLUMN_NAME_SCHEMAO2
                   and ../../../sxml:NAME=$REMAP_COLUMN_NAME_TABLEO2">
    <xsl:element name="NAME">
     <xsl:value-of select="$REMAP_COLUMN_NAMEN2"/>
    </xsl:element>
   </xsl:when>
   <xsl:when test=".=$REMAP_COLUMN_NAMEO3
                   and ../../../sxml:SCHEMA=$REMAP_COLUMN_NAME_SCHEMAO3
                   and ../../../sxml:NAME=$REMAP_COLUMN_NAME_TABLEO3">
    <xsl:element name="NAME">
     <xsl:value-of select="$REMAP_COLUMN_NAMEN3"/>
    </xsl:element>
   </xsl:when>
   <xsl:when test=".=$REMAP_COLUMN_NAMEO4
                   and ../../../sxml:SCHEMA=$REMAP_COLUMN_NAME_SCHEMAO4
                   and ../../../sxml:NAME=$REMAP_COLUMN_NAME_TABLEO4">
    <xsl:element name="NAME">
     <xsl:value-of select="$REMAP_COLUMN_NAMEN4"/>
    </xsl:element>
   </xsl:when>
   <xsl:when test=".=$REMAP_COLUMN_NAMEO5
                   and ../../../sxml:SCHEMA=$REMAP_COLUMN_NAME_SCHEMAO5
                   and ../../../sxml:NAME=$REMAP_COLUMN_NAME_TABLEO5">
    <xsl:element name="NAME">
     <xsl:value-of select="$REMAP_COLUMN_NAMEN5"/>
    </xsl:element>
   </xsl:when>
   <xsl:when test=".=$REMAP_COLUMN_NAMEO6
                   and ../../../sxml:SCHEMA=$REMAP_COLUMN_NAME_SCHEMAO6
                   and ../../../sxml:NAME=$REMAP_COLUMN_NAME_TABLEO6">
    <xsl:element name="NAME">
     <xsl:value-of select="$REMAP_COLUMN_NAMEN6"/>
    </xsl:element>
   </xsl:when>
   <xsl:when test=".=$REMAP_COLUMN_NAMEO7
                   and ../../../sxml:SCHEMA=$REMAP_COLUMN_NAME_SCHEMAO7
                   and ../../../sxml:NAME=$REMAP_COLUMN_NAME_TABLEO7">
    <xsl:element name="NAME">
     <xsl:value-of select="$REMAP_COLUMN_NAMEN7"/>
    </xsl:element>
   </xsl:when>
   <xsl:when test=".=$REMAP_COLUMN_NAMEO8
                   and ../../../sxml:SCHEMA=$REMAP_COLUMN_NAME_SCHEMAO8
                   and ../../../sxml:NAME=$REMAP_COLUMN_NAME_TABLEO8">
    <xsl:element name="NAME">
     <xsl:value-of select="$REMAP_COLUMN_NAMEN8"/>
    </xsl:element>
   </xsl:when>
   <xsl:when test=".=$REMAP_COLUMN_NAMEO9
                   and ../../../sxml:SCHEMA=$REMAP_COLUMN_NAME_SCHEMAO9
                   and ../../../sxml:NAME=$REMAP_COLUMN_NAME_TABLEO9">
    <xsl:element name="NAME">
     <xsl:value-of select="$REMAP_COLUMN_NAMEN9"/>
    </xsl:element>
   </xsl:when>
   <xsl:when test=".=$REMAP_COLUMN_NAMEO10
                   and ../../../sxml:SCHEMA=$REMAP_COLUMN_NAME_SCHEMAO10
                   and ../../../sxml:NAME=$REMAP_COLUMN_NAME_TABLEO10">
    <xsl:element name="NAME">
     <xsl:value-of select="$REMAP_COLUMN_NAMEN10"/>
    </xsl:element>
   </xsl:when>
   <xsl:otherwise>
    <xsl:copy>
     <xsl:apply-templates select="@*|node()"/>
    </xsl:copy>
   </xsl:otherwise>
  </xsl:choose>
 </xsl:template>
 <xsl:template match="sxml:COLUMN_REF/sxml:COLUMN">
  <!-- *******************************************************************
       Template: ../COLUMN_REF/COLUMN - remap column names
******************************************************************** -->
  <xsl:choose>
   <xsl:when test="string-length($REMAP_COLUMN_NAMEO1)=0">
    <xsl:copy>
     <xsl:apply-templates select="@*|node()"/>
    </xsl:copy>
   </xsl:when>
   <xsl:when test=".=$REMAP_COLUMN_NAMEO1
                   and 
                (../sxml:SCHEMA and ../sxml:SCHEMA=$REMAP_COLUMN_NAME_SCHEMAO1
                   or
                 /*/sxml:SCHEMA=$REMAP_COLUMN_NAME_SCHEMAO1)
                   and ../sxml:TABLE=$REMAP_COLUMN_NAME_TABLEO1">
    <xsl:element name="COLUMN">
     <xsl:value-of select="$REMAP_COLUMN_NAMEN1"/>
    </xsl:element>
   </xsl:when>
   <xsl:when test=".=$REMAP_COLUMN_NAMEO2
                   and 
                (../sxml:SCHEMA and ../sxml:SCHEMA=$REMAP_COLUMN_NAME_SCHEMAO2
                   or
                 /*/sxml:SCHEMA=$REMAP_COLUMN_NAME_SCHEMAO2)
                   and ../sxml:TABLE=$REMAP_COLUMN_NAME_TABLEO2">
    <xsl:element name="COLUMN">
     <xsl:value-of select="$REMAP_COLUMN_NAMEN2"/>
    </xsl:element>
   </xsl:when>
   <xsl:when test=".=$REMAP_COLUMN_NAMEO3
                   and 
                (../sxml:SCHEMA and ../sxml:SCHEMA=$REMAP_COLUMN_NAME_SCHEMAO3
                   or
                 /*/sxml:SCHEMA=$REMAP_COLUMN_NAME_SCHEMAO3)
                   and ../sxml:TABLE=$REMAP_COLUMN_NAME_TABLEO3">
    <xsl:element name="COLUMN">
     <xsl:value-of select="$REMAP_COLUMN_NAMEN3"/>
    </xsl:element>
   </xsl:when>
   <xsl:when test=".=$REMAP_COLUMN_NAMEO4
                   and 
                (../sxml:SCHEMA and ../sxml:SCHEMA=$REMAP_COLUMN_NAME_SCHEMAO4
                   or
                 /*/sxml:SCHEMA=$REMAP_COLUMN_NAME_SCHEMAO4)
                   and ../sxml:TABLE=$REMAP_COLUMN_NAME_TABLEO4">
    <xsl:element name="COLUMN">
     <xsl:value-of select="$REMAP_COLUMN_NAMEN4"/>
    </xsl:element>
   </xsl:when>
   <xsl:when test=".=$REMAP_COLUMN_NAMEO5
                   and 
                (../sxml:SCHEMA and ../sxml:SCHEMA=$REMAP_COLUMN_NAME_SCHEMAO5
                   or
                 /*/sxml:SCHEMA=$REMAP_COLUMN_NAME_SCHEMAO5)
                   and ../sxml:TABLE=$REMAP_COLUMN_NAME_TABLEO5">
    <xsl:element name="COLUMN">
     <xsl:value-of select="$REMAP_COLUMN_NAMEN5"/>
    </xsl:element>
   </xsl:when>
   <xsl:when test=".=$REMAP_COLUMN_NAMEO6
                   and 
                (../sxml:SCHEMA and ../sxml:SCHEMA=$REMAP_COLUMN_NAME_SCHEMAO6
                   or
                 /*/sxml:SCHEMA=$REMAP_COLUMN_NAME_SCHEMAO6)
                   and ../sxml:TABLE=$REMAP_COLUMN_NAME_TABLEO6">
    <xsl:element name="COLUMN">
     <xsl:value-of select="$REMAP_COLUMN_NAMEN6"/>
    </xsl:element>
   </xsl:when>
   <xsl:when test=".=$REMAP_COLUMN_NAMEO7
                   and 
                (../sxml:SCHEMA and ../sxml:SCHEMA=$REMAP_COLUMN_NAME_SCHEMAO7
                   or
                 /*/sxml:SCHEMA=$REMAP_COLUMN_NAME_SCHEMAO7)
                   and ../sxml:TABLE=$REMAP_COLUMN_NAME_TABLEO7">
    <xsl:element name="COLUMN">
     <xsl:value-of select="$REMAP_COLUMN_NAMEN7"/>
    </xsl:element>
   </xsl:when>
   <xsl:when test=".=$REMAP_COLUMN_NAMEO8
                   and 
                (../sxml:SCHEMA and ../sxml:SCHEMA=$REMAP_COLUMN_NAME_SCHEMAO8
                   or
                 /*/sxml:SCHEMA=$REMAP_COLUMN_NAME_SCHEMAO8)
                   and ../sxml:TABLE=$REMAP_COLUMN_NAME_TABLEO8">
    <xsl:element name="COLUMN">
     <xsl:value-of select="$REMAP_COLUMN_NAMEN8"/>
    </xsl:element>
   </xsl:when>
   <xsl:when test=".=$REMAP_COLUMN_NAMEO9
                   and 
                (../sxml:SCHEMA and ../sxml:SCHEMA=$REMAP_COLUMN_NAME_SCHEMAO9
                   or
                 /*/sxml:SCHEMA=$REMAP_COLUMN_NAME_SCHEMAO9)
                   and ../sxml:TABLE=$REMAP_COLUMN_NAME_TABLEO9">
    <xsl:element name="COLUMN">
     <xsl:value-of select="$REMAP_COLUMN_NAMEN9"/>
    </xsl:element>
   </xsl:when>
   <xsl:when test=".=$REMAP_COLUMN_NAMEO10
                   and 
                (../sxml:SCHEMA and ../sxml:SCHEMA=$REMAP_COLUMN_NAME_SCHEMAO10
                   or
                 /*/sxml:SCHEMA=$REMAP_COLUMN_NAME_SCHEMAO10)
                   and ../sxml:TABLE=$REMAP_COLUMN_NAME_TABLEO10">
    <xsl:element name="COLUMN">
     <xsl:value-of select="$REMAP_COLUMN_NAMEN10"/>
    </xsl:element>
   </xsl:when>
   <xsl:otherwise>
    <xsl:copy>
     <xsl:apply-templates select="@*|node()"/>
    </xsl:copy>
   </xsl:otherwise>
  </xsl:choose>
 </xsl:template>
</xsl:stylesheet>
