<?xml version="1.0"?>
<!-- Copyright (c) 2005, 2009, Oracle and/or its affiliates. 
All rights reserved. -->
<!--
NAME
    kuspard.xsl
DESCRIPTION
    Convert *_PARTITIONING in TABLE document (SXML) to creation DDL.
    Convert TABLE document (SXML) to creation DDL.

MODIFIED        MM/DD/YY
    lbarton     07/10/09 - bug 8494344: archive compression
    rapayne     12/24/08 - bug 759589: add $STATISTICS support from CM code stream.
    lbarton     02/11/08 - reference/system partitioning
    lbarton     01/15/08 - Bug 6724820: table compression
    lbarton     12/15/06 - Changes to securefile
    rapayne     10/13/06 - Add support to allow ADD PARTITION to be common
                                        (i.e., diff/alter support)
    lbarton     10/09/06 - interval partitioning
    lbarton     08/29/06 - All composite partitioning combinations
    lbarton     11/21/05 - Bug 4724986: transform params 
    sdavidso    11/02/05 - fix inconsistent stylesheet format 
    lbarton     09/30/05 - lbarton_mddiff2
    sdavidso    09/29/05 - NOCOMPRESS for partitions in compressed index 
    lbarton     08/10/05 - lbarton_mddiff
    lbarton     03/11/05 - Initial version
 -->
<xsl:stylesheet version="1.0" xmlns:sxml="http://xmlns.oracle.com/ku" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
 <!-- Top level imports -->
 <xsl:import href="kuscommc.xsl"/>
 <xsl:import href="kustbphd.xsl"/>
 <!-- Top-level parameters -->
<xsl:param name="STATISTICS">0</xsl:param>
 <!-- Templates -->
 <xsl:template name="TableRangePartitioning">
  <xsl:param name="PartitioningNode" select="''"/>
  <!-- *******************************************************************
Template: TableRangePartitioning
  PartitioningNode: RANGE_PARTITIONING
******************************************************************** -->
  <xsl:if test="$PRETTY=1">
   <xsl:text>&#xa; </xsl:text>
  </xsl:if>
  <xsl:text> PARTITION BY RANGE </xsl:text>
  <xsl:call-template name="ColumnList">
   <xsl:with-param name="ColListNode" select="$PartitioningNode/sxml:COL_LIST"/>
  </xsl:call-template>
  <xsl:apply-templates select="$PartitioningNode/sxml:INTERVAL"/>
  <xsl:apply-templates select="$PartitioningNode/sxml:STORE_IN"/>
  <xsl:apply-templates select="$PartitioningNode/sxml:HASH_SUBPARTITIONING"/>
  <xsl:apply-templates select="$PartitioningNode/sxml:LIST_SUBPARTITIONING"/>
  <xsl:apply-templates select="$PartitioningNode/sxml:RANGE_SUBPARTITIONING"/>
  <xsl:apply-templates select="$PartitioningNode/sxml:PARTITION_LIST">
   <xsl:with-param name="PartitionType">RANGE</xsl:with-param>
   <xsl:with-param name="SubpartitionType">
    <xsl:choose>
     <xsl:when test="$PartitioningNode/sxml:HASH_SUBPARTITIONING">HASH</xsl:when>
     <xsl:when test="$PartitioningNode/sxml:LIST_SUBPARTITIONING">LIST</xsl:when>
     <xsl:when test="$PartitioningNode/sxml:RANGE_SUBPARTITIONING">RANGE</xsl:when>
    </xsl:choose>
   </xsl:with-param>
  </xsl:apply-templates>
 </xsl:template>
 <xsl:template match="sxml:INTERVAL">
  <!-- *******************************************************************
Template: INTERVAL
******************************************************************** -->
  <xsl:text> INTERVAL (</xsl:text>
  <xsl:value-of select="."/>
  <xsl:text>)</xsl:text>
 </xsl:template>
 <xsl:template match="sxml:STORE_IN">
  <!-- *******************************************************************
Template: STORE_IN
******************************************************************** -->
  <xsl:text> STORE IN (</xsl:text>
  <xsl:for-each select="sxml:STORE_IN_ITEM">
   <xsl:call-template name="QuotedName">
    <xsl:with-param name="NameNode" select="."/>
   </xsl:call-template>
   <xsl:if test="position()!=last()">
    <xsl:text>, </xsl:text>
   </xsl:if>
  </xsl:for-each>
  <xsl:text>)</xsl:text>
 </xsl:template>
 <xsl:template name="TableListPartitioning">
  <xsl:param name="PartitioningNode" select="''"/>
  <!-- *******************************************************************
Template: TableListPartitioning
  PartitioningNode: LIST_PARTITIONING
******************************************************************** -->
  <xsl:if test="$PRETTY=1">
   <xsl:text>&#xa; </xsl:text>
  </xsl:if>
  <xsl:text> PARTITION BY LIST </xsl:text>
  <xsl:call-template name="ColumnList">
   <xsl:with-param name="ColListNode" select="$PartitioningNode/sxml:COL_LIST"/>
  </xsl:call-template>
  <!-- In 10g list partitions can't have subpartitions, but they
      plan to lift this restriction in 11g. -->
  <xsl:apply-templates select="$PartitioningNode/sxml:HASH_SUBPARTITIONING"/>
  <xsl:apply-templates select="$PartitioningNode/sxml:LIST_SUBPARTITIONING"/>
  <xsl:apply-templates select="$PartitioningNode/sxml:RANGE_SUBPARTITIONING"/>
  <xsl:apply-templates select="$PartitioningNode/sxml:PARTITION_LIST">
   <xsl:with-param name="PartitionType">LIST</xsl:with-param>
   <xsl:with-param name="SubpartitionType">
    <xsl:choose>
     <xsl:when test="$PartitioningNode/sxml:HASH_SUBPARTITIONING">HASH</xsl:when>
     <xsl:when test="$PartitioningNode/sxml:LIST_SUBPARTITIONING">LIST</xsl:when>
     <xsl:when test="$PartitioningNode/sxml:RANGE_SUBPARTITIONING">RANGE</xsl:when>
    </xsl:choose>
   </xsl:with-param>
  </xsl:apply-templates>
 </xsl:template>
 <xsl:template name="TableHashPartitioning">
  <xsl:param name="PartitioningNode" select="''"/>
  <!-- *******************************************************************
Template: TableHashPartitioning
  PartitioningNode: HASH_PARTITIONING
******************************************************************** -->
  <xsl:if test="$PRETTY=1">
   <xsl:text>&#xa; </xsl:text>
  </xsl:if>
  <xsl:text> PARTITION BY HASH </xsl:text>
  <xsl:call-template name="ColumnList">
   <xsl:with-param name="ColListNode" select="$PartitioningNode/sxml:COL_LIST"/>
  </xsl:call-template>
  <xsl:apply-templates select="$PartitioningNode/sxml:PARTITION_LIST">
   <xsl:with-param name="PartitionType">HASH</xsl:with-param>
  </xsl:apply-templates>
 </xsl:template>
 <xsl:template name="TableSystemPartitioning">
  <xsl:param name="PartitioningNode" select="''"/>
  <!-- *******************************************************************
Template: TableSystemPartitioning
  PartitioningNode: SYSTEM_PARTITIONING
******************************************************************** -->
  <xsl:if test="$PRETTY=1">
   <xsl:text>&#xa; </xsl:text>
  </xsl:if>
  <xsl:text> PARTITION BY SYSTEM </xsl:text>
  <xsl:apply-templates select="$PartitioningNode/sxml:PARTITION_LIST">
   <xsl:with-param name="PartitionType">SYSTEM</xsl:with-param>
  </xsl:apply-templates>
 </xsl:template>
 <xsl:template name="TableReferencePartitioning">
  <xsl:param name="PartitioningNode" select="''"/>
  <!-- *******************************************************************
Template: TableReferencePartitioning
  PartitioningNode: REFERENCE_PARTITIONING
******************************************************************** -->
  <xsl:if test="$PRETTY=1">
   <xsl:text>&#xa; </xsl:text>
  </xsl:if>
  <xsl:text> PARTITION BY REFERENCE ("</xsl:text>
  <xsl:value-of select="$PartitioningNode/sxml:CONSTRAINT"/>
  <xsl:text>") </xsl:text>
  <xsl:apply-templates select="$PartitioningNode/sxml:PARTITION_LIST">
   <xsl:with-param name="PartitionType">REFERENCE</xsl:with-param>
  </xsl:apply-templates>
 </xsl:template>
 <xsl:template match="sxml:PARTITION_LIST">
  <xsl:param name="PartitionType" select="''"/>
  <xsl:param name="SubpartitionType" select="''"/>
  <!-- *******************************************************************
Template: PARTITION_LIST
Parameters:
 PartitionType - RANGE, HASH, LIST or ''
 SubpartitionType - RANGE, HASH, LIST or ''
******************************************************************** -->
  <xsl:choose>
   <xsl:when test="$STATISTICS=1">
     <xsl:call-template name="CreateStatistics"/>   
   </xsl:when>
  <xsl:otherwise>
  <xsl:if test="$PRETTY=1">
   <xsl:text>&#xa; </xsl:text>
  </xsl:if>
  <xsl:text>(</xsl:text>
  <xsl:for-each select="sxml:PARTITION_LIST_ITEM">
   <xsl:call-template name="BeginAddPartition">
    <xsl:with-param name="PartitionType" select="$PartitionType"/>
    <xsl:with-param name="PartitionItem" select="."/>
   </xsl:call-template>
   <xsl:call-template name="CompleteAddPartition">
    <xsl:with-param name="ParentNode" select="."/>
    <xsl:with-param name="PartitionType" select="$PartitionType"/>
    <xsl:with-param name="SubpartitionType" select="$SubpartitionType"/>
   </xsl:call-template>
  </xsl:for-each>
  <xsl:text>)</xsl:text>
  </xsl:otherwise>
  </xsl:choose>
 </xsl:template>
 <xsl:template name="CompleteAddPartition">
  <xsl:param name="ParentNode" select="''"/>
  <xsl:param name="PartitionType" select="''"/>
  <xsl:param name="SubpartitionType" select="''"/>
  <xsl:param name="Punctuate">Y</xsl:param>
  <!-- *******************************************************************
Template: CompleteAddPartition
Parameters:
 ParentNode - PARTITION_LIST
 PartitionType - RANGE, HASH, LIST or ''
 SubpartitionType - RANGE, HASH, LIST or ''
 Punctuate - 'Y' = append comma if necessary
******************************************************************** -->
  <xsl:choose>
   <!-- HASH partitions -->
   <xsl:when test="$PartitionType='HASH'">
    <xsl:apply-templates select="$ParentNode/sxml:COLUMN_PROPERTIES">
     <xsl:with-param name="PartitionType" select="$PartitionType"/>
    </xsl:apply-templates>
    <xsl:apply-templates select="$ParentNode/sxml:SEGMENT_ATTRIBUTES"/>
   </xsl:when>
   <!-- list or range partitions -->
   <xsl:otherwise>
    <xsl:if test="$PRETTY=1 and 
                         $ParentNode/sxml:PHYSICAL_PROPERTIES/*/sxml:SEGMENT_ATTRIBUTES and 
                         $SEGMENT_ATTRIBUTES!=0">
     <xsl:text>&#xa; </xsl:text>
    </xsl:if>
    <xsl:apply-templates select="
 $ParentNode/sxml:PHYSICAL_PROPERTIES/sxml:HEAP_TABLE/sxml:SEGMENT_ATTRIBUTES |
 $ParentNode/sxml:PHYSICAL_PROPERTIES/sxml:INDEX_ORGANIZED_TABLE/sxml:SEGMENT_ATTRIBUTES"/>
    <xsl:apply-templates select="$ParentNode/sxml:COLUMN_PROPERTIES">
     <xsl:with-param name="PartitionType" select="$PartitionType"/>
    </xsl:apply-templates>
    <xsl:apply-templates select="
          $ParentNode/sxml:PHYSICAL_PROPERTIES/sxml:INDEX_ORGANIZED_TABLE/sxml:OVERFLOW"/>
    <!-- can't specify compression for hash partition -->
    <xsl:choose>
     <xsl:when test="$PartitionType='HASH'"/>
     <xsl:when test="$ParentNode/sxml:PHYSICAL_PROPERTIES/sxml:HEAP_TABLE">
      <xsl:call-template name="DoCompressDDL">
       <xsl:with-param name="Compress" select="
                      $ParentNode/sxml:PHYSICAL_PROPERTIES/sxml:HEAP_TABLE/sxml:COMPRESS"/>
       <xsl:with-param name="CompressLevel" select="
                      $ParentNode/sxml:PHYSICAL_PROPERTIES/sxml:HEAP_TABLE/sxml:COMPRESS_LEVEL"/>
      </xsl:call-template>
     </xsl:when>
     <xsl:when test="$ParentNode/sxml:PHYSICAL_PROPERTIES/sxml:INDEX_ORGANIZED_TABLE">
      <xsl:apply-templates select="
 $ParentNode/sxml:PHYSICAL_PROPERTIES/sxml:INDEX_ORGANIZED_TABLE/sxml:KEYCOMPRESS"/>
     </xsl:when>
    </xsl:choose>
   </xsl:otherwise>
  </xsl:choose>
  <xsl:apply-templates select="$ParentNode/sxml:SUBPARTITION_LIST">
   <xsl:with-param name="SubpartitionType" select="$SubpartitionType"/>
  </xsl:apply-templates>
  <xsl:if test="$Punctuate='Y' and position()!=last()">
   <xsl:text>, </xsl:text>
   <xsl:if test="$PRETTY=1">
    <xsl:text>&#xa; </xsl:text>
   </xsl:if>
  </xsl:if>
 </xsl:template>
 <xsl:template match="sxml:SUBPARTITION_LIST">
  <xsl:param name="SubpartitionType" select="''"/>
  <!-- *******************************************************************
Template: SUBPARTITION_LIST
Parameters:
 SubpartitionType - RANGE, HASH, LIST or ''
******************************************************************** -->
  <xsl:if test="$PRETTY=1">
   <xsl:text>&#xa; </xsl:text>
  </xsl:if>
  <xsl:text>(</xsl:text>
  <xsl:for-each select="sxml:SUBPARTITION_LIST_ITEM">
   <xsl:text>SUBPARTITION "</xsl:text>
   <xsl:value-of select="sxml:NAME"/>
   <xsl:text>" </xsl:text>
   <xsl:choose>
    <xsl:when test="$SubpartitionType='LIST'">
     <xsl:text>VALUES (</xsl:text>
     <xsl:value-of select="sxml:VALUES"/>
     <xsl:text>) </xsl:text>
     <xsl:apply-templates select="sxml:COLUMN_PROPERTIES">
      <xsl:with-param name="PartitionType">LIST</xsl:with-param>
      <xsl:with-param name="Subpartition">1</xsl:with-param>
     </xsl:apply-templates>
    </xsl:when>
    <xsl:when test="$SubpartitionType='RANGE'">
     <xsl:text>VALUES LESS THAN (</xsl:text>
     <xsl:value-of select="sxml:VALUES"/>
     <xsl:text>) </xsl:text>
     <xsl:apply-templates select="sxml:COLUMN_PROPERTIES">
      <xsl:with-param name="PartitionType">RANGE</xsl:with-param>
      <xsl:with-param name="Subpartition">1</xsl:with-param>
     </xsl:apply-templates>
    </xsl:when>
    <xsl:otherwise>
     <xsl:apply-templates select="sxml:COLUMN_PROPERTIES">
      <xsl:with-param name="PartitionType">HASH</xsl:with-param>
      <xsl:with-param name="Subpartition">1</xsl:with-param>
     </xsl:apply-templates>
    </xsl:otherwise>
   </xsl:choose>
   <xsl:if test="$PRETTY=1 and sxml:TABLESPACE">
    <xsl:text>&#xa; </xsl:text>
    <xsl:apply-templates select="sxml:TABLESPACE"/>
   </xsl:if>
   <xsl:choose>
    <xsl:when test="$SubpartitionType='HASH'"/>
    <xsl:otherwise>
     <xsl:call-template name="DoCompressDDL">
      <xsl:with-param name="Compress" select="sxml:COMPRESS"/>
      <xsl:with-param name="CompressLevel" select="sxml:COMPRESS_LEVEL"/>
     </xsl:call-template>
    </xsl:otherwise>
   </xsl:choose>
   <xsl:if test="position()!=last()">
    <xsl:text>, </xsl:text>
    <xsl:if test="$PRETTY=1">
     <xsl:text>&#xa; </xsl:text>
    </xsl:if>
   </xsl:if>
  </xsl:for-each>
  <xsl:text>)</xsl:text>
 </xsl:template>
 <xsl:template match="sxml:HASH_SUBPARTITIONING">
  <!-- *******************************************************************
Template: HASH_SUBPARTITIONING
******************************************************************** -->
  <xsl:if test="$PRETTY=1">
   <xsl:text>&#xa; </xsl:text>
  </xsl:if>
  <xsl:text> SUBPARTITION BY HASH </xsl:text>
  <xsl:call-template name="ColumnList">
   <xsl:with-param name="ColListNode" select="sxml:COL_LIST"/>
  </xsl:call-template>
  <xsl:apply-templates select="sxml:SUBPARTITION_COUNT"/>
  <xsl:apply-templates select="sxml:SUBPARTITION_TEMPLATE">
   <xsl:with-param name="SubpartitionType">HASH</xsl:with-param>
  </xsl:apply-templates>
 </xsl:template>
 <xsl:template match="sxml:LIST_SUBPARTITIONING">
  <!-- *******************************************************************
Template: LIST_SUBPARTITIONING
******************************************************************** -->
  <xsl:if test="$PRETTY=1">
   <xsl:text>&#xa; </xsl:text>
  </xsl:if>
  <xsl:text> SUBPARTITION BY LIST </xsl:text>
  <xsl:call-template name="ColumnList">
   <xsl:with-param name="ColListNode" select="sxml:COL_LIST"/>
  </xsl:call-template>
  <xsl:apply-templates select="sxml:SUBPARTITION_TEMPLATE">
   <xsl:with-param name="SubpartitionType">LIST</xsl:with-param>
  </xsl:apply-templates>
 </xsl:template>
 <xsl:template match="sxml:RANGE_SUBPARTITIONING">
  <!-- *******************************************************************
Template: RANGE_SUBPARTITIONING
******************************************************************** -->
  <xsl:if test="$PRETTY=1">
   <xsl:text>&#xa; </xsl:text>
  </xsl:if>
  <xsl:text> SUBPARTITION BY RANGE </xsl:text>
  <xsl:call-template name="ColumnList">
   <xsl:with-param name="ColListNode" select="sxml:COL_LIST"/>
  </xsl:call-template>
  <xsl:apply-templates select="sxml:SUBPARTITION_TEMPLATE">
   <xsl:with-param name="SubpartitionType">RANGE</xsl:with-param>
  </xsl:apply-templates>
 </xsl:template>
 <xsl:template match="sxml:SUBPARTITION_COUNT">
  <!-- *******************************************************************
Template: SUBPARTITION_COUNT
******************************************************************** -->
  <xsl:if test="$PRETTY=1">
   <xsl:text>&#xa; </xsl:text>
  </xsl:if>
  <xsl:text> SUBPARTITIONS </xsl:text>
  <xsl:value-of select="."/>
 </xsl:template>
 <xsl:template match="sxml:SUBPARTITION_TEMPLATE">
  <xsl:param name="SubpartitionType" select="''"/>
  <!-- *******************************************************************
Template: SUBPARTITION_TEMPLATE
Parameters:
 SubpartitionType - RANGE, HASH, LIST or ''
******************************************************************** -->
  <xsl:if test="$PRETTY=1">
   <xsl:text>&#xa; </xsl:text>
  </xsl:if>
  <xsl:text> SUBPARTITION TEMPLATE </xsl:text>
  <xsl:apply-templates select="sxml:SUBPARTITION_LIST">
   <xsl:with-param name="SubpartitionType" select="$SubpartitionType"/>
  </xsl:apply-templates>
 </xsl:template>
 <xsl:template name="BeginAddPartition">
  <xsl:param name="PartitionType" select="''"/>
  <xsl:param name="PartitionItem" select="''"/>
  <!-- *******************************************************************
Template: BeginAddPartition
Parameters:
 PartitionType - RANGE, HASH, LIST or ''
 PartitionItem - PARTITION_ITEM node
******************************************************************** -->
  <xsl:text>PARTITION "</xsl:text>
  <xsl:value-of select="sxml:NAME"/>
  <xsl:text>" </xsl:text>
  <xsl:choose>
   <xsl:when test="$PartitionType='RANGE'">
    <xsl:text>VALUES LESS THAN (</xsl:text>
    <xsl:value-of select="$PartitionItem/sxml:VALUES"/>
    <xsl:text>) </xsl:text>
   </xsl:when>
   <xsl:when test="$PartitionType='LIST'">
    <xsl:text>VALUES (</xsl:text>
    <xsl:value-of select="$PartitionItem/sxml:VALUES"/>
    <xsl:text>) </xsl:text>
   </xsl:when>
  </xsl:choose>
 </xsl:template>
 <xsl:template name="CreateTablePartStats">
  <!-- *******************************************************************
Template:CreateTablePartStats
Calls the Different templates for different Table types
******************************************************************** -->
  <xsl:apply-templates select="sxml:RELATIONAL_TABLE/sxml:TABLE_PROPERTIES"/>
  <xsl:apply-templates select="sxml:OBJECT_TABLE/sxml:TABLE_PROPERTIES"/>
  <xsl:apply-templates select="sxml:XMLTYPE_TABLE/sxml:TABLE_PROPERTIES"/>
 </xsl:template>
 <!-- *******************************************************************
Template:CreateStatistics
Creates TableStatistics .Called from Templates matching PARTITION_LIST
******************************************************************** -->
<xsl:template name="CreateStatistics">
 <xsl:if test="$STATISTICS=1 and sxml:PARTITION_LIST_ITEM/sxml:STATISTICS">
  <xsl:for-each select="sxml:PARTITION_LIST_ITEM">
  <xsl:if test="string(sxml:STATISTICS/sxml:ROWCNT)">
  <xsl:text>DBMS_STATS.SET_TABLE_STATS(OWNNAME=>'</xsl:text>
  <xsl:value-of select="//sxml:SCHEMA"/>
  <xsl:text>', </xsl:text>
  <xsl:text>TABNAME=>'</xsl:text>
  <xsl:value-of select="//sxml:NAME"/>
  <xsl:text>', </xsl:text>
  <xsl:text>PARTNAME=>'</xsl:text>
  <xsl:value-of select="sxml:NAME"/>
  <xsl:text>', </xsl:text>
  <xsl:text>NUMROWS=></xsl:text>
  <xsl:value-of select="sxml:STATISTICS/sxml:ROWCNT"/>
  <xsl:text>, </xsl:text>
  <xsl:text>NUMBLKS=></xsl:text>
  <xsl:value-of select="sxml:STATISTICS/sxml:BLKCNT"/>
  <xsl:text>, </xsl:text>
  <xsl:text>AVGRLEN=></xsl:text>
  <xsl:value-of select="sxml:STATISTICS/sxml:AVGRLN"/>
  <xsl:text>) ;</xsl:text>
  <xsl:text>&#10;</xsl:text>
  </xsl:if>
  </xsl:for-each>
 </xsl:if>
 </xsl:template>
<xsl:template name ="CreateIndexPartStats" >
<xsl:param name="PartitioningNode" select = "''"/>
<!-- *******************************************************************
Template:CreateIndexPartStats
******************************************************************** -->
<xsl:if test="$STATISTICS=1 and $PartitioningNode/sxml:PARTITION_LIST_ITEM/sxml:STATISTICS">
  <xsl:for-each select="$PartitioningNode/sxml:PARTITION_LIST_ITEM">
  <xsl:if test="string($PartitioningNode/sxml:PARTITION_LIST_ITEM/sxml:STATISTICS/sxml:ROWCNT)">
  <xsl:text>DBMS_STATS.SET_INDEX_STATS(OWNNAME=>'</xsl:text>
  <xsl:value-of select="//sxml:SCHEMA"/>
  <xsl:text>', </xsl:text>
  <xsl:text>INDNAME=>'</xsl:text>
  <xsl:value-of select="//sxml:NAME"/>
  <xsl:text>', </xsl:text>
  <xsl:text>PARTNAME=>'</xsl:text>
  <xsl:value-of select="sxml:NAME"/>
  <xsl:text>', </xsl:text>
  <xsl:text>NUMROWS=></xsl:text>
  <xsl:value-of select="sxml:STATISTICS/sxml:ROWCNT"/>
  <xsl:text>, </xsl:text>
  <xsl:text>NUMLBLKS=></xsl:text>
  <xsl:value-of select="sxml:STATISTICS/sxml:LEAFCNT"/>
  <xsl:text>, </xsl:text>
  <xsl:text>NUMDIST=></xsl:text>
  <xsl:value-of select="sxml:STATISTICS/sxml:DISTKEY"/>
  <xsl:text>, </xsl:text>
  <xsl:text>AVGLBLK=></xsl:text>
  <xsl:value-of select="sxml:STATISTICS/sxml:LBLKKEY"/>
  <xsl:text>, </xsl:text>
  <xsl:text>AVGDBLK=></xsl:text>
  <xsl:value-of select="sxml:STATISTICS/sxml:DBLKKEY"/>
  <xsl:text>, </xsl:text>
  <xsl:text>CLSTFCT=></xsl:text>
  <xsl:value-of select="sxml:STATISTICS/sxml:CLUFAC"/>
  <xsl:text>) ;</xsl:text>
  <xsl:text>&#10;</xsl:text>
  </xsl:if>
  </xsl:for-each>
 </xsl:if>
 </xsl:template>
<xsl:template name ="CallIndexPartStats" >
<xsl:param name="IndNode" select = "''"/>
<!-- *******************************************************************
Template:CallIndexPartStats
********************************************************************-->
   <xsl:if test=" $PARTITIONING=1 and $IndNode/sxml:GLOBAL_PARTITIONING/sxml:HASH_PARTITIONING">
    <xsl:call-template name="CreateIndexPartStats">
     <xsl:with-param name="PartitioningNode" select="$IndNode/sxml:GLOBAL_PARTITIONING/sxml:HASH_PARTITIONING/sxml:PARTITION_LIST"/>
    </xsl:call-template>
   </xsl:if>
   <xsl:if test="$IndNode/sxml:GLOBAL_PARTITIONING/sxml:RANGE_PARTITIONING">
    <xsl:call-template name="CreateIndexPartStats">
     <xsl:with-param name="PartitioningNode" select="$IndNode/sxml:GLOBAL_PARTITIONING/sxml:RANGE_PARTITIONING/sxml:PARTITION_LIST"/>
    </xsl:call-template>
   </xsl:if>
   <xsl:if test="$PARTITIONING=1 and $IndNode/sxml:LOCAL_PARTITIONING">
     <xsl:call-template name="CreateIndexPartStats">
      <xsl:with-param name="PartitioningNode" select="$IndNode/sxml:LOCAL_PARTITIONING/sxml:PARTITION_LIST"/>
     </xsl:call-template>
    </xsl:if>
 </xsl:template>
</xsl:stylesheet>
