<?xml version="1.0"?>
<!--
NAME
    kusrole.xsl
DESCRIPTION
    Convert mdapi ROLE_T document to ROLE document (SXML)

MODIFIED        MM/DD/YY
    lbarton     11/09/05 - bug 4724986: fix handling of xmlns 
    sdavidso    11/02/05 - fix inconsistent stylesheet format 
    htseng     25/02/05 - Initial version
 -->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns="http://xmlns.oracle.com/ku">
 <!-- Top level imports -->
 <!-- Top-level parameters -->
 <xsl:param name="LRG">0</xsl:param>
 <!-- *******************************************************************
Template: ROLE_T - top-level template for ROLE.
  This template puts out
   - the opening ROLE element (with xmlns and version attributes)
   - NAME elements

******************************************************************** -->
 <xsl:template match="ROLE_T">
  <xsl:element name="ROLE">
  <!-- See note about xmlns attribute in kustable.xsl --> 
   <xsl:attribute name="xmlns">http://xmlns.oracle.com/ku</xsl:attribute>
   <xsl:attribute name="version">1.0</xsl:attribute>
   <xsl:element name="NAME">
    <xsl:value-of select="NAME"/>
   </xsl:element>
   <xsl:choose>
    <xsl:when test="PASSWORD">
     <xsl:choose>
      <xsl:when test="PASSWORD='APPLICATION'">
       <xsl:element name="TYPE">APPLICATION</xsl:element>
      </xsl:when>
      <xsl:when test="PASSWORD='GLOBAL'">
       <xsl:element name="TYPE">GLOBAL</xsl:element>
      </xsl:when>
      <xsl:when test="PASSWORD='EXTERNAL'">
       <xsl:element name="TYPE">EXTERNAL</xsl:element>
      </xsl:when>
      <xsl:otherwise>
       <xsl:element name="TYPE">LOCAL</xsl:element>
       <!-- undocumented VALUE element required for reg tests -->
       <xsl:if test="$LRG!=0">
        <xsl:element name="VALUE">
         <xsl:value-of select="PASSWORD"/>
        </xsl:element>
       </xsl:if>
      </xsl:otherwise>
     </xsl:choose>
    </xsl:when>
    <xsl:otherwise>
     <xsl:element name="TYPE">
      <xsl:text>NOT_IDENTIFIED</xsl:text>
     </xsl:element>
    </xsl:otherwise>
   </xsl:choose>
   <xsl:if test="PACKAGE">
    <xsl:element name="PACKAGE">
     <xsl:element name="SCHEMA">
      <xsl:value-of select="SCHEMA"/>
     </xsl:element>
     <xsl:element name="NAME">
      <xsl:value-of select="PACKAGE"/>
     </xsl:element>
    </xsl:element>
   </xsl:if>
  </xsl:element>
 </xsl:template>
</xsl:stylesheet>
