<?xml version="1.0" encoding="utf-8"?>
<!--

 Copyright (c) 2006, 2009, Oracle and/or its affiliates. All rights reserved. 

NAME
    kustablc.xsl
DESCRIPTION
    Templates for common and utility functions used by both kustabld.xsl
    and kuatable.xsl

MODIFIED        MM/DD/YY
    abodge     09/22/09 - CONSOLIDATE STYLESHEETS: TargetSchemaName
    ebatbout   12/12/08 - fix problem with TIME WITH TIMEZONE datatype in 
                          template, datatype   
    rapayne    11/15/08 - bug 7595899:fix number datatype when PRECISION has been 'deleted'.
    rapayne    10/07/08 - account for CHAR_SEMANTIC diffs
    lbarton    08/28/08 - xmltype virtual columns
    rapayne    07/15/08 - account for difdoc attributes before processing SECUREFILE lobs.
                           i.e., don't process if /sxml:SECUREFILE/@src=1
    lbarton     02/11/08 - reference/system partitioning
    rapayne     01/10/09 - Handle dif doc case in which both PCTVERSION
                                        are RETENTION are present.
    lbarton     02/02/08 - bug 6789892: fix alter number precision support.
    ebatbout    01/10/08 - bug 6568074: comment out encrypt/decrypt & support 
                           compress & deduplicates defaults in LobProperties
    rapayne     12/12/07 - Support CHAR_SEMANTICS
    lbarton     12/12/07 - bug 6682373: char semantics
    rapayne     12/07/07 - Bug 6677390: fix RETENTION processing for
                           basicfile lobs.
    slynn       02/25/07 - Backout changes that removed dedup validate.
    rapayne     02/08/07 - merge slynn removal of (A)SYNC and VALIDATE
    lbarton     09/28/06 - modify ENABLE, etc. to exclude src=1
    lbarton     05/25/06 - Initial version
 -->
<xsl:stylesheet version="1.0" xmlns:sxml="http://xmlns.oracle.com/ku" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
 <xsl:template name="Datatype">
  <xsl:param name="TypeObj">0</xsl:param>
  <!-- *******************************************************************
Template: Datatype - emit column datatype
Current node: COL_LIST/COL_LIST_ITEM
TypeObj - Number table columns allow col1 number(*,2)
     However, this is not support for type columns.
******************************************************************** -->
  <xsl:choose>
   <xsl:when test="sxml:DATATYPE='CHAR' or
                   sxml:DATATYPE='VARCHAR2' or
                   sxml:DATATYPE='NCHAR' or
                   sxml:DATATYPE='NVARCHAR2' or
                   sxml:DATATYPE='RAW' or
                   sxml:DATATYPE='UROWID'">
    <xsl:value-of select="sxml:DATATYPE"/>
    <xsl:if test="sxml:LENGTH">
     <xsl:text>(</xsl:text>
     <xsl:value-of select="sxml:LENGTH"/>
     <xsl:apply-templates select="sxml:CHAR_SEMANTICS"/>
     <xsl:text>)</xsl:text>
    </xsl:if>
   </xsl:when>
   <xsl:when test="sxml:DATATYPE='NUMBER' or
                   sxml:DATATYPE='FLOAT' or
                   sxml:DATATYPE='DECIMAL'">
    <xsl:value-of select="sxml:DATATYPE"/>
    <!-- if PRECISION and its not a TYPE object -->
    <xsl:if test="(sxml:PRECISION and not (sxml:PRECISION/@src='1')) or
                  (sxml:SCALE and not (sxml:SCALE/@src='1') and $TypeObj ='0')">
     <xsl:text>(</xsl:text>
     <xsl:choose>
      <xsl:when test="sxml:PRECISION and not (sxml:PRECISION/@src='1')">
       <xsl:value-of select="sxml:PRECISION"/>
      </xsl:when>
      <xsl:otherwise>*</xsl:otherwise>
     </xsl:choose>
     <xsl:if test="sxml:SCALE and not (sxml:SCALE/@src='1') and 
                        (sxml:DATATYPE='NUMBER' or sxml:DATATYPE='DECIMAL')">
      <xsl:text>,</xsl:text>
      <xsl:value-of select="sxml:SCALE"/>
     </xsl:if>
     <xsl:text>)</xsl:text>
    </xsl:if>
   </xsl:when>
   <xsl:when test="sxml:DATATYPE='TIME' or
                   sxml:DATATYPE='TIMESTAMP'">
    <xsl:value-of select="sxml:DATATYPE"/>
    <xsl:if test="sxml:SCALE and not(sxml:SCALE/@src='1')">
     <xsl:text>(</xsl:text>
     <xsl:value-of select="sxml:SCALE"/>
     <xsl:text>)</xsl:text>
    </xsl:if>
   </xsl:when>
   <xsl:when test="sxml:DATATYPE='TIME_WITH_TIMEZONE'">
    <xsl:text>TIME </xsl:text>
    <xsl:if test="sxml:SCALE and not(sxml:SCALE/@src='1')">
     <xsl:text>(</xsl:text>
     <xsl:value-of select="sxml:SCALE"/>
     <xsl:text>) </xsl:text>
    </xsl:if>
    <xsl:text>WITH TIME ZONE</xsl:text>
   </xsl:when>
   <xsl:when test="sxml:DATATYPE='TIMESTAMP_WITH_TIMEZONE'">
    <xsl:text>TIMESTAMP </xsl:text>
    <xsl:if test="sxml:SCALE and not(sxml:SCALE/@src='1')">
     <xsl:text>(</xsl:text>
     <xsl:value-of select="sxml:SCALE"/>
     <xsl:text>) </xsl:text>
    </xsl:if>
    <xsl:text>WITH TIME ZONE</xsl:text>
   </xsl:when>
   <xsl:when test="sxml:DATATYPE='INTERVAL_YEAR_TO_MONTH'">
    <xsl:text>INTERVAL YEAR </xsl:text>
    <xsl:if test="sxml:PRECISION and not(sxml:PRECISION/@src='1')">
     <xsl:text>(</xsl:text>
     <xsl:value-of select="sxml:PRECISION"/>
     <xsl:text>) </xsl:text>
    </xsl:if>
    <xsl:text>TO MONTH</xsl:text>
   </xsl:when>
   <xsl:when test="sxml:DATATYPE='INTERVAL_DAY_TO_SECOND'">
    <xsl:text>INTERVAL DAY </xsl:text>
    <xsl:if test="sxml:PRECISION  and not(sxml:PRECISION/@src='1')">
     <xsl:text>(</xsl:text>
     <xsl:value-of select="sxml:PRECISION"/>
     <xsl:text>) </xsl:text>
    </xsl:if>
    <xsl:text>TO SECOND</xsl:text>
    <xsl:if test="sxml:SCALE and not(sxml:SCALE/@src='1')">
     <xsl:text> (</xsl:text>
     <xsl:value-of select="sxml:SCALE"/>
     <xsl:text>) </xsl:text>
    </xsl:if>
   </xsl:when>
   <xsl:when test="sxml:DATATYPE='TIMESTAMP_WITH_LOCAL_TIMEZONE'">
    <xsl:text>TIMESTAMP </xsl:text>
    <xsl:if test="sxml:SCALE and not(sxml:SCALE/@src='1')">
     <xsl:text>(</xsl:text>
     <xsl:value-of select="sxml:SCALE"/>
     <xsl:text>) </xsl:text>
    </xsl:if>
    <xsl:text>WITH LOCAL TIME ZONE</xsl:text>
   </xsl:when>
   <xsl:when test="sxml:DATATYPE='UDT' or
                   sxml:DATATYPE='NESTED_TABLE' or
                   sxml:DATATYPE='VARRAY' or
                   sxml:DATATYPE='OPAQUE' or
                   sxml:DATATYPE='XMLTYPE' or
                   sxml:DATATYPE='REF'">
    <xsl:if test="sxml:DATATYPE='REF'">REF </xsl:if>
    <xsl:choose>
     <xsl:when test="$CM_MODE=1">
      <xsl:call-template name="TargetSchemaName">
       <xsl:with-param name="ParentNode" select="sxml:TYPE_PROPERTIES"/>
      </xsl:call-template>
     </xsl:when>
     <xsl:otherwise>
      <xsl:call-template name="SchemaName">
       <xsl:with-param name="ParentNode" select="sxml:TYPE_PROPERTIES"/>
      </xsl:call-template>
     </xsl:otherwise>
    </xsl:choose>
   </xsl:when>
   <xsl:when test="sxml:DATATYPE='LONG_RAW'">LONG RAW</xsl:when>
   <xsl:otherwise>
    <xsl:value-of select="sxml:DATATYPE"/>
   </xsl:otherwise>
  </xsl:choose>
 </xsl:template>
 <xsl:template match="sxml:CHAR_SEMANTICS">
  <!-- *******************************************************************
Template: CHAR_SEMANTICS
Current node: CHAR_SEMANTICS
******************************************************************** -->
  <!-- If we are processing a diff doc and char_semantics have been removed (i.e., src=1) then simply omit and the byte semantic default will be applied
-->
  <xsl:if test="not(./@src='1')">
   <xsl:text> CHAR</xsl:text>
  </xsl:if>
 </xsl:template>
 <xsl:template match="sxml:VIRTUAL">
  <!-- *******************************************************************
Template: VIRTUAL
Current node: VIRTUAL
******************************************************************** -->
  <xsl:text> GENERATED ALWAYS AS (</xsl:text>
  <xsl:value-of select="."/>
  <xsl:text>) VIRTUAL</xsl:text>
 </xsl:template>
 <xsl:template match="sxml:HIDDEN">
  <!-- *******************************************************************
Template: HIDDEN
Current node: HIDDEN
******************************************************************** -->
  <xsl:text> HIDDEN</xsl:text>
 </xsl:template>
 <xsl:template match="sxml:DEFAULT">
  <!-- *******************************************************************
Template: DEFAULT
Current node: DEFAULT
******************************************************************** -->
  <xsl:text> DEFAULT </xsl:text>
  <xsl:value-of select="."/>
 </xsl:template>
 <xsl:template match="sxml:ENCRYPT">
  <!-- *******************************************************************
Template: ENCRYPT
Current node: ENCRYPT
******************************************************************** -->
  <xsl:text> ENCRYPT USING '</xsl:text>
  <xsl:value-of select="sxml:USING"/>
  <xsl:text>'</xsl:text>
  <xsl:if test="sxml:NOSALT">
   <xsl:text> NO SALT</xsl:text>
  </xsl:if>
 </xsl:template>
 <xsl:template match="sxml:TABLE_PROPERTIES">
  <!-- *******************************************************************
Template: TABLE_PROPERTIES
******************************************************************** -->
  <!-- if table is partitioned, default physical properties should
      precede column properties -->
  <xsl:choose>
   <xsl:when test="$STATISTICS=1">
    <xsl:apply-templates select="sxml:RANGE_PARTITIONING/sxml:PARTITION_LIST"/>
    <xsl:apply-templates select="sxml:LIST_PARTITIONING/sxml:PARTITION_LIST"/>
    <xsl:apply-templates select="sxml:HASH_PARTITIONING/sxml:PARTITION_LIST"/>
   </xsl:when>
   <xsl:otherwise>
    <xsl:apply-templates select="sxml:RANGE_PARTITIONING/sxml:DEFAULT_PHYSICAL_PROPERTIES"/>
    <xsl:apply-templates select="sxml:HASH_PARTITIONING/sxml:DEFAULT_PHYSICAL_PROPERTIES"/>
    <xsl:apply-templates select="sxml:LIST_PARTITIONING/sxml:DEFAULT_PHYSICAL_PROPERTIES"/>
    <xsl:apply-templates select="sxml:SYSTEM_PARTITIONING/sxml:DEFAULT_PHYSICAL_PROPERTIES"/>
    <xsl:apply-templates select="sxml:REFERENCE_PARTITIONING/sxml:DEFAULT_PHYSICAL_PROPERTIES"/>
    <xsl:apply-templates select="sxml:COLUMN_PROPERTIES"/>
    <xsl:apply-templates select="sxml:XMLTYPE_VIRTUAL_COLUMNS"/>
    <xsl:if test="$PARTITIONING=1">
     <xsl:if test="sxml:RANGE_PARTITIONING">
      <xsl:call-template name="TableRangePartitioning">
       <xsl:with-param name="PartitioningNode" select="sxml:RANGE_PARTITIONING"/>
      </xsl:call-template>
     </xsl:if>
     <xsl:if test="sxml:LIST_PARTITIONING">
      <xsl:call-template name="TableListPartitioning">
       <xsl:with-param name="PartitioningNode" select="sxml:LIST_PARTITIONING"/>
      </xsl:call-template>
     </xsl:if>
     <xsl:if test="sxml:HASH_PARTITIONING">
      <xsl:call-template name="TableHashPartitioning">
       <xsl:with-param name="PartitioningNode" select="sxml:HASH_PARTITIONING"/>
      </xsl:call-template>
     </xsl:if>
     <xsl:if test="sxml:REFERENCE_PARTITIONING">
      <xsl:call-template name="TableReferencePartitioning">
       <xsl:with-param name="PartitioningNode" select="sxml:REFERENCE_PARTITIONING"/>
      </xsl:call-template>
     </xsl:if>
     <xsl:if test="sxml:SYSTEM_PARTITIONING">
      <xsl:call-template name="TableSystemPartitioning">
       <xsl:with-param name="PartitioningNode" select="sxml:SYSTEM_PARTITIONING"/>
      </xsl:call-template>
     </xsl:if>
    </xsl:if>
    <!-- cache -->
    <xsl:if test="sxml:CACHE"> CACHE</xsl:if>
    <!-- parallel -->
    <xsl:apply-templates select="sxml:PARALLEL"/>
    <!-- row dependencies -->
    <xsl:if test="sxml:ROW_DEPENDENCIES"> ROWDEPENDENCIES</xsl:if>
    <!-- row movement -->
    <xsl:if test="sxml:ROW_MOVEMENT"> ENABLE ROW MOVEMENT</xsl:if>
    <xsl:apply-templates select="sxml:FLASHBACK_ARCHIVE"/>
   </xsl:otherwise>
  </xsl:choose>
 </xsl:template>
 <xsl:template match="sxml:COLUMN_PROPERTIES">
  <xsl:param name="PartitionType" select="''"/>
  <xsl:param name="Subpartition">0</xsl:param>
  <!-- *******************************************************************
Template: COLUMN_PROPERTIES
 PartitionType - RANGE, HASH, LIST or ''
 Subpartition  1 = this is a subpartition (0 = it isn't)
******************************************************************** -->
  <xsl:for-each select="sxml:COL_LIST/sxml:COL_LIST_ITEM">
   <xsl:choose>
    <xsl:when test="sxml:DATATYPE='UDT'">
     <xsl:call-template name="SubstitutableColProperties">
      <xsl:with-param name="ColListItem" select="."/>
     </xsl:call-template>
    </xsl:when>
    <xsl:when test="sxml:DATATYPE='NESTED_TABLE'">
     <xsl:call-template name="NestedTableColProperties">
      <xsl:with-param name="ColNameNode" select="sxml:NAME"/>
      <xsl:with-param name="ColProperties" select="../.."/>
     </xsl:call-template>
    </xsl:when>
    <xsl:when test="sxml:DATATYPE='VARRAY'">
     <xsl:call-template name="VarrayColProperties">
      <xsl:with-param name="ColNameNode" select="sxml:NAME"/>
      <xsl:with-param name="ColProperties" select="../.."/>
     </xsl:call-template>
    </xsl:when>
    <xsl:when test="sxml:DATATYPE='OPAQUE'">
     <!-- yucky complexity -->
     <xsl:choose>
      <xsl:when test="local-name(../../..)='PARTITION_LIST_ITEM'">
       <xsl:call-template name="LobColProperties">
        <xsl:with-param name="ColListItem" select="."/>
        <xsl:with-param name="DataType" select="sxml:DATATYPE"/>
        <xsl:with-param name="PartitionType" select="$PartitionType"/>
       </xsl:call-template>
      </xsl:when>
      <xsl:otherwise>
       <xsl:call-template name="OpaqueColProperties">
        <xsl:with-param name="ColNameNode" select="sxml:NAME"/>
        <xsl:with-param name="ColProperties" select="../.."/>
       </xsl:call-template>
      </xsl:otherwise>
     </xsl:choose>
    </xsl:when>
    <xsl:when test="sxml:DATATYPE='CLOB' or
                   sxml:DATATYPE='BLOB' or
                   sxml:DATATYPE='NCLOB'">
     <xsl:call-template name="LobColProperties">
      <xsl:with-param name="ColListItem" select="."/>
      <xsl:with-param name="DataType" select="sxml:DATATYPE"/>
      <xsl:with-param name="PartitionType" select="$PartitionType"/>
      <xsl:with-param name="Subpartition" select="$Subpartition"/>
     </xsl:call-template>
    </xsl:when>
    <xsl:when test="sxml:DATATYPE='XMLTYPE'">
     <xsl:call-template name="XMLTypeColProperties">
      <xsl:with-param name="ColNameNode" select="sxml:NAME"/>
      <xsl:with-param name="ColProperties" select="../.."/>
     </xsl:call-template>
    </xsl:when>
    <xsl:otherwise>
     <xsl:text>
 **** ERROR: kustabld.xsl UNRECOGNIZED COLUMN PROPERTIES: name = </xsl:text>
     <xsl:value-of select="sxml:NAME"/>
     <xsl:text> datatype = </xsl:text>
     <xsl:value-of select="sxml:DATATYPE"/>
     <xsl:text> ****
</xsl:text>
    </xsl:otherwise>
   </xsl:choose>
  </xsl:for-each>
 </xsl:template>
 <xsl:template match="sxml:FLASHBACK_ARCHIVE">
  <!-- *******************************************************************
Template: FLASHBACK_ARCHIVE
******************************************************************** -->
  <xsl:text> FLASHBACK ARCHIVE "</xsl:text>
  <xsl:value-of select="."/>
  <xsl:text>"</xsl:text>
 </xsl:template>
 <xsl:template name="SubstitutableColProperties">
  <xsl:param name="ColListItem" select="''"/>
  <!-- *******************************************************************
Template: SubstitutableColProperties
Parameters:
 ColListItem: TABLE/TABLE_PROPERTIES/COLUMN_PROPERTIES/COL_LIST/COL_LIST_ITEM
******************************************************************** -->
  <xsl:if test="$ColListItem/sxml:OF_TYPE or $ColListItem/sxml:SUBSTITUTABLE">
   <xsl:if test="$PRETTY=1">
    <xsl:text>&#xa;</xsl:text>
   </xsl:if>
   <xsl:text> COLUMN "</xsl:text>
   <xsl:value-of select="$ColListItem/sxml:NAME"/>
   <xsl:text>"</xsl:text>
   <xsl:apply-templates select="$ColListItem/sxml:OF_TYPE"/>
   <xsl:apply-templates select="$ColListItem/sxml:SUBSTITUTABLE"/>
  </xsl:if>
 </xsl:template>
 <xsl:template match="sxml:OF_TYPE">
  <!-- *******************************************************************
Template: OF_TYPE
******************************************************************** -->
  <xsl:text> IS OF TYPE (ONLY </xsl:text>
  <xsl:value-of select="."/>
  <xsl:text>)</xsl:text>
 </xsl:template>
 <xsl:template match="sxml:SUBSTITUTABLE">
  <!-- *******************************************************************
Template: SUBSTITUTABLE
******************************************************************** -->
  <xsl:if test=".='N'"> NOT</xsl:if>
  <xsl:text> SUBSTITUTABLE AT ALL LEVELS</xsl:text>
 </xsl:template>
 <xsl:template name="NestedTableColProperties">
  <xsl:param name="ColNameNode" select="''"/>
  <xsl:param name="ColProperties" select="''"/>
  <!-- *******************************************************************
Template: NestedTableColProperties
Parameters:
 ColNameNode   - column name
 ColProperties - TABLE_PROPERTIES/COLUMN_PROPERTIES
******************************************************************** -->
  <xsl:if test="$PRETTY=1">
   <xsl:text>&#xa;</xsl:text>
  </xsl:if>
  <xsl:text> NESTED TABLE </xsl:text>
  <xsl:choose>
   <xsl:when test="$ColNameNode='COLUMN_VALUE'">COLUMN_VALUE</xsl:when>
   <xsl:otherwise>
    <xsl:call-template name="QuotedName">
     <xsl:with-param name="NameNode" select="$ColNameNode"/>
    </xsl:call-template>
   </xsl:otherwise>
  </xsl:choose>
  <xsl:apply-templates select="$ColProperties/sxml:COL_LIST/sxml:COL_LIST_ITEM[sxml:NAME=$ColNameNode]/sxml:NESTED_TABLE_PROPERTIES"/>
 </xsl:template>
 <xsl:template match="sxml:NESTED_TABLE_PROPERTIES">
  <!-- *******************************************************************
Template: NESTED_TABLE_PROPERTIES
******************************************************************** -->
  <xsl:text> STORE AS "</xsl:text>
  <xsl:value-of select="sxml:STORAGE_TABLE/sxml:NAME"/>
  <xsl:text>"</xsl:text>
  <xsl:if test="$PRETTY=1">
   <xsl:text>&#xa;</xsl:text>
  </xsl:if>
  <xsl:if test="(sxml:STORAGE_TABLE/sxml:PRIMARY_KEY_CONSTRAINT_LIST or
                       sxml:STORAGE_TABLE/sxml:PHYSICAL_PROPERTIES//sxml:SEGMENT_ATTRIBUTES or
                       sxml:STORAGE_TABLE/sxml:TABLE_PROPERTIES)
                       and $SEGMENT_ATTRIBUTES!=0">
   <xsl:text> (</xsl:text>
   <xsl:if test="sxml:STORAGE_TABLE/sxml:PRIMARY_KEY_CONSTRAINT_LIST">
    <xsl:text> (</xsl:text>
    <xsl:call-template name="Constraints">
     <xsl:with-param name="ParentNode" select="sxml:STORAGE_TABLE"/>
     <xsl:with-param name="IOT">
      <xsl:choose>
       <xsl:when test="sxml:STORAGE_TABLE/sxml:PHYSICAL_PROPERTIES/sxml:INDEX_ORGANIZED_TABLE">1</xsl:when>
       <xsl:otherwise>0</xsl:otherwise>
      </xsl:choose>
     </xsl:with-param>
    </xsl:call-template>
    <xsl:text>)</xsl:text>
    <xsl:if test="$PRETTY=1">
     <xsl:text>&#xa;</xsl:text>
    </xsl:if>
   </xsl:if>
   <xsl:apply-templates select="sxml:STORAGE_TABLE/sxml:PHYSICAL_PROPERTIES">
    <xsl:with-param name="DoCompress">N</xsl:with-param>
   </xsl:apply-templates>
   <xsl:apply-templates select="sxml:STORAGE_TABLE/sxml:TABLE_PROPERTIES"/>
   <xsl:text> )</xsl:text>
  </xsl:if>
  <xsl:apply-templates select="sxml:RETURN_AS"/>
 </xsl:template>
 <xsl:template name="VarrayColProperties">
  <xsl:param name="ColNameNode" select="''"/>
  <xsl:param name="ColProperties" select="''"/>
  <!-- *******************************************************************
Template: VarrayColProperties
Parameters:
 ColNameNode   - column name
 ColProperties - TABLE_PROPERTIES/COLUMN_PROPERTIES
******************************************************************** -->
  <xsl:if test="$ColProperties/sxml:COL_LIST/sxml:COL_LIST_ITEM[sxml:NAME=$ColNameNode]/sxml:VARRAY_PROPERTIES/*/sxml:STORAGE_TABLE/sxml:NAME or
             (($ColProperties/sxml:COL_LIST/sxml:COL_LIST_ITEM[sxml:NAME=$ColNameNode]/sxml:VARRAY_PROPERTIES/sxml:LOB_PROPERTIES/sxml:STORAGE_TABLE/sxml:TABLESPACE or
                $ColProperties/sxml:COL_LIST/sxml:COL_LIST_ITEM[sxml:NAME=$ColNameNode]/sxml:VARRAY_PROPERTIES/sxml:LOB_PROPERTIES/sxml:STORAGE_TABLE/sxml:STORAGE_IN_ROW or
                $ColProperties/sxml:COL_LIST/sxml:COL_LIST_ITEM[sxml:NAME=$ColNameNode]/sxml:VARRAY_PROPERTIES/sxml:LOB_PROPERTIES/sxml:STORAGE_TABLE/sxml:SECUREFILE or
                $ColProperties/sxml:COL_LIST/sxml:COL_LIST_ITEM[sxml:NAME=$ColNameNode]/sxml:VARRAY_PROPERTIES/sxml:LOB_PROPERTIES/sxml:STORAGE_TABLE/sxml:CHUNK or
                $ColProperties/sxml:COL_LIST/sxml:COL_LIST_ITEM[sxml:NAME=$ColNameNode]/sxml:VARRAY_PROPERTIES/sxml:LOB_PROPERTIES/sxml:STORAGE_TABLE/sxml:PCTVERSION or
                $ColProperties/sxml:COL_LIST/sxml:COL_LIST_ITEM[sxml:NAME=$ColNameNode]/sxml:VARRAY_PROPERTIES/sxml:LOB_PROPERTIES/sxml:STORAGE_TABLE/sxml:STORAGE or
                $ColProperties/sxml:COL_LIST/sxml:COL_LIST_ITEM[sxml:NAME=$ColNameNode]/sxml:VARRAY_PROPERTIES/sxml:LOB_PROPERTIES/sxml:STORAGE_TABLE/sxml:CACHE or
                $ColProperties/sxml:COL_LIST/sxml:COL_LIST_ITEM[sxml:NAME=$ColNameNode]/sxml:VARRAY_PROPERTIES/sxml:NESTED_TABLE_PROPERTIES/sxml:STORAGE_TABLE/sxml:PHYSICAL_PROPERTIES)
                and $SEGMENT_ATTRIBUTES!=0)">
   <xsl:if test="$PRETTY=1">
    <xsl:text>&#xa;</xsl:text>
   </xsl:if>
   <xsl:text> VARRAY "</xsl:text>
   <xsl:value-of select="$ColNameNode"/>
   <xsl:text>"</xsl:text>
   <xsl:apply-templates select="$ColProperties/sxml:COL_LIST/sxml:COL_LIST_ITEM[sxml:NAME=$ColNameNode]/sxml:VARRAY_PROPERTIES"/>
  </xsl:if>
 </xsl:template>
 <xsl:template match="sxml:VARRAY_PROPERTIES">
  <!-- *******************************************************************
Template: VARRAY_PROPERTIES
******************************************************************** -->
  <xsl:text> STORE AS </xsl:text>
  <xsl:choose>
   <xsl:when test="sxml:STORE_AS='TABLE'">
    <xsl:text>TABLE </xsl:text>
    <xsl:if test="sxml:NESTED_TABLE_PROPERTIES/sxml:STORAGE_TABLE/sxml:NAME">
     <xsl:text> "</xsl:text>
     <xsl:value-of select="sxml:NESTED_TABLE_PROPERTIES/sxml:STORAGE_TABLE/sxml:NAME"/>
     <xsl:text>"</xsl:text>
    </xsl:if>
    <xsl:if test="sxml:NESTED_TABLE_PROPERTIES/sxml:STORAGE_TABLE/sxml:PHYSICAL_PROPERTIES and $SEGMENT_ATTRIBUTES!=0">
     <xsl:if test="$PRETTY=1">
      <xsl:text>&#xa;</xsl:text>
     </xsl:if>
     <xsl:text> (</xsl:text>
     <xsl:apply-templates select="sxml:NESTED_TABLE_PROPERTIES/sxml:STORAGE_TABLE/sxml:PHYSICAL_PROPERTIES"/>
     <xsl:text>)</xsl:text>
    </xsl:if>
    <xsl:apply-templates select="sxml:NESTED_TABLE_PROPERTIES/sxml:RETURN_AS"/>
   </xsl:when>
   <xsl:otherwise>
    <!-- store as LOB -->
    <xsl:if test="$VERSION>=1100000000">
     <xsl:choose>
      <xsl:when test="sxml:LOB_PROPERTIES/sxml:STORAGE_TABLE/sxml:SECUREFILE">
       <xsl:text>SECUREFILE </xsl:text>
      </xsl:when>
      <xsl:otherwise>
       <xsl:text>BASICFILE </xsl:text>
      </xsl:otherwise>
     </xsl:choose>
    </xsl:if>
    <xsl:text>LOB </xsl:text>
    <xsl:if test="sxml:LOB_PROPERTIES/sxml:STORAGE_TABLE/sxml:NAME">
     <xsl:text> "</xsl:text>
     <xsl:value-of select="sxml:LOB_PROPERTIES/sxml:STORAGE_TABLE/sxml:NAME"/>
     <xsl:text>"</xsl:text>
    </xsl:if>
    <xsl:if test="(sxml:LOB_PROPERTIES/sxml:STORAGE_TABLE/sxml:TABLESPACE or
                sxml:LOB_PROPERTIES/sxml:STORAGE_TABLE/sxml:STORAGE_IN_ROW or
                sxml:LOB_PROPERTIES/sxml:STORAGE_TABLE/sxml:CHUNK or
                sxml:LOB_PROPERTIES/sxml:STORAGE_TABLE/sxml:PCTVERSION or
                sxml:LOB_PROPERTIES/sxml:STORAGE_TABLE/sxml:RETENTION or
                sxml:LOB_PROPERTIES/sxml:STORAGE_TABLE/sxml:STORAGE or
                sxml:LOB_PROPERTIES/sxml:STORAGE_TABLE/sxml:CACHE or
                sxml:LOB_PROPERTIES/sxml:STORAGE_TABLE/sxml:LOBENCRYPT or
                sxml:LOB_PROPERTIES/sxml:STORAGE_TABLE/sxml:LOBCOMPRESS or
                sxml:LOB_PROPERTIES/sxml:STORAGE_TABLE/sxml:DEDUPLICATE or
                sxml:LOB_PROPERTIES/sxml:STORAGE_TABLE/sxml:VALIDATE)
                and $SEGMENT_ATTRIBUTES!=0">
     <xsl:if test="$PRETTY=1">
      <xsl:text>&#xa;</xsl:text>
     </xsl:if>
     <xsl:text> (</xsl:text>
     <xsl:call-template name="LobProperties">
      <xsl:with-param name="StorageTable" select="sxml:LOB_PROPERTIES/sxml:STORAGE_TABLE"/>
     </xsl:call-template>
     <xsl:text>)</xsl:text>
    </xsl:if>
   </xsl:otherwise>
  </xsl:choose>
 </xsl:template>
 <xsl:template name="OpaqueColProperties">
  <xsl:param name="ColNameNode" select="''"/>
  <xsl:param name="ColProperties" select="''"/>
  <!-- *******************************************************************
Template: OpaqueColProperties
Current node: TABLE/TABLE_PROPERTIES/COLUMN_PROPERTIES/COL_LIST/COL_LIST_ITEM
Parameters:
 ColNameNode   - column name
 ColProperties - TABLE_PROPERTIES/COLUMN_PROPERTIES
******************************************************************** -->
  <xsl:if test="$PRETTY=1">
   <xsl:text>&#xa;</xsl:text>
  </xsl:if>
  <xsl:text> OPAQUE TYPE </xsl:text>
  <xsl:call-template name="QuotedName">
   <xsl:with-param name="NameNode" select="$ColNameNode"/>
  </xsl:call-template>
  <xsl:text> STORE AS </xsl:text>
  <xsl:if test="$VERSION>=1100000000">
   <xsl:choose>
    <xsl:when test="$ColProperties/sxml:COL_LIST/sxml:COL_LIST_ITEM[sxml:NAME=$ColNameNode]/sxml:LOB_PROPERTIES/sxml:STORAGE_TABLE/sxml:SECUREFILE">
     <xsl:text>SECUREFILE </xsl:text>
    </xsl:when>
    <xsl:otherwise>
     <xsl:text>BASICFILE </xsl:text>
    </xsl:otherwise>
   </xsl:choose>
  </xsl:if>
  <xsl:text> LOB </xsl:text>
  <xsl:if test="$ColProperties/sxml:COL_LIST/sxml:COL_LIST_ITEM[sxml:NAME=$ColNameNode]/sxml:LOB_PROPERTIES/sxml:STORAGE_TABLE/sxml:NAME">
   <xsl:call-template name="QuotedName">
    <xsl:with-param name="NameNode" select="$ColProperties/sxml:COL_LIST/sxml:COL_LIST_ITEM[sxml:NAME=$ColNameNode]/sxml:LOB_PROPERTIES/sxml:STORAGE_TABLE/sxml:NAME"/>
   </xsl:call-template>
  </xsl:if>
  <xsl:text> (</xsl:text>
  <xsl:if test="$PRETTY=1">
   <xsl:text>&#xa; </xsl:text>
  </xsl:if>
  <xsl:call-template name="LobProperties">
   <xsl:with-param name="StorageTable" select="$ColProperties/sxml:COL_LIST/sxml:COL_LIST_ITEM[sxml:NAME=$ColNameNode]/sxml:LOB_PROPERTIES/sxml:STORAGE_TABLE"/>
  </xsl:call-template>
  <xsl:text>)</xsl:text>
 </xsl:template>
 <xsl:template name="LobColProperties">
  <xsl:param name="ColListItem" select="''"/>
  <xsl:param name="DataType" select="''"/>
  <xsl:param name="PartitionType" select="''"/>
  <xsl:param name="Subpartition">0</xsl:param>
  <xsl:param name="ModifyLobStorage">0</xsl:param>
  <!-- *******************************************************************
Template: LobColProperties
Parameters:
 ColListItem: TABLE/TABLE_PROPERTIES/COLUMN_PROPERTIES/COL_LIST/COL_LIST_ITEM
 DataType
 PartitionType - RANGE, HASH, LIST or ''
 Subpartition  1 = this is a subpartition (0 = it isn't)
 ModifyLobStorage - 1 = generating ALTER TABLE MODIFY LOB
******************************************************************** -->
  <xsl:if test="($ColListItem/sxml:LOB_PROPERTIES/sxml:STORAGE_TABLE/sxml:NAME or
                $ColListItem/sxml:LOB_PROPERTIES/sxml:STORAGE_TABLE/sxml:TABLESPACE or
                $ColListItem/sxml:LOB_PROPERTIES/sxml:STORAGE_TABLE/sxml:STORAGE_IN_ROW or
                $ColListItem/sxml:LOB_PROPERTIES/sxml:STORAGE_TABLE/sxml:SECUREFILE or
                $ColListItem/sxml:LOB_PROPERTIES/sxml:STORAGE_TABLE/sxml:CHUNK or
                $ColListItem/sxml:LOB_PROPERTIES/sxml:STORAGE_TABLE/sxml:PCTVERSION or
                $ColListItem/sxml:LOB_PROPERTIES/sxml:STORAGE_TABLE/sxml:RETENTION or
                $ColListItem/sxml:LOB_PROPERTIES/sxml:STORAGE_TABLE/sxml:STORAGE or
                $ColListItem/sxml:LOB_PROPERTIES/sxml:STORAGE_TABLE/sxml:CACHE or
                $ColListItem/sxml:LOB_PROPERTIES/sxml:STORAGE_TABLE/sxml:LOBENCRYPT or
                $ColListItem/sxml:LOB_PROPERTIES/sxml:STORAGE_TABLE/sxml:LOBCOMPRESS or
                $ColListItem/sxml:LOB_PROPERTIES/sxml:STORAGE_TABLE/sxml:DEDUPLICATE or
                $ColListItem/sxml:LOB_PROPERTIES/sxml:STORAGE_TABLE/sxml:VALIDATE)
                and $SEGMENT_ATTRIBUTES!=0">
   <xsl:if test="$PRETTY=1">
    <xsl:text>&#xa;</xsl:text>
   </xsl:if>
   <xsl:text> LOB (</xsl:text>
   <xsl:call-template name="QuotedName">
    <xsl:with-param name="NameNode" select="$ColListItem/sxml:NAME"/>
   </xsl:call-template>
   <xsl:text>)</xsl:text>
   <xsl:text> STORE AS </xsl:text>
   <xsl:if test="$VERSION>=1100000000">
    <xsl:choose>
     <xsl:when test="$ColListItem/sxml:LOB_PROPERTIES/sxml:STORAGE_TABLE/sxml:SECUREFILE">
      <xsl:text>SECUREFILE </xsl:text>
     </xsl:when>
     <xsl:otherwise>
      <xsl:text>BASICFILE </xsl:text>
     </xsl:otherwise>
    </xsl:choose>
   </xsl:if>
   <xsl:if test="$ColListItem/sxml:LOB_PROPERTIES/sxml:STORAGE_TABLE/sxml:NAME">
    <xsl:call-template name="QuotedName">
     <xsl:with-param name="NameNode" select="$ColListItem/sxml:LOB_PROPERTIES/sxml:STORAGE_TABLE/sxml:NAME"/>
    </xsl:call-template>
   </xsl:if>
   <xsl:apply-templates select="$ColListItem/sxml:LOB_PROPERTIES">
    <xsl:with-param name="DataType" select="$DataType"/>
    <xsl:with-param name="PartitionType" select="$PartitionType"/>
    <xsl:with-param name="Subpartition" select="$Subpartition"/>
    <xsl:with-param name="ModifyLobStorage" select="$ModifyLobStorage"/>
   </xsl:apply-templates>
  </xsl:if>
 </xsl:template>
 <xsl:template match="sxml:LOB_PROPERTIES">
  <xsl:param name="DataType" select="''"/>
  <xsl:param name="PartitionType" select="''"/>
  <xsl:param name="Subpartition">0</xsl:param>
  <xsl:param name="ModifyLobStorage">0</xsl:param>
  <!-- *******************************************************************
Template: LOB_PROPERTIES
 DataType
 PartitionType - RANGE, HASH, LIST or ''
 Subpartition  1 = this is a subpartition (0 = it isn't)
 ModifyLobStorage - 1 = generating ALTER TABLE MODIFY LOB
******************************************************************** -->
  <xsl:if test="((sxml:STORAGE_TABLE/sxml:TABLESPACE 
                and $TABLESPACE!=0) or
                sxml:STORAGE_TABLE/sxml:STORAGE_IN_ROW or
                sxml:STORAGE_TABLE/sxml:CHUNK or
                sxml:STORAGE_TABLE/sxml:PCTVERSION or
                sxml:STORAGE_TABLE/sxml:RETENTION or
                sxml:STORAGE_TABLE/sxml:STORAGE or
                sxml:STORAGE_TABLE/sxml:CACHE or
                sxml:STORAGE_TABLE/sxml:LOBENCRYPT or
                sxml:STORAGE_TABLE/sxml:LOBCOMPRESS or
                sxml:STORAGE_TABLE/sxml:DEDUPLICATE or
                sxml:STORAGE_TABLE/sxml:VALIDATE)
                and $SEGMENT_ATTRIBUTES!=0">
   <xsl:text> (</xsl:text>
   <xsl:if test="$PRETTY=1">
    <xsl:text>&#xa; </xsl:text>
   </xsl:if>
   <!-- mystery: why doesn't mdapi specify tablespace for varray store as lob?
     -->
   <xsl:choose>
    <!-- tablespace name not needed for opaques and anydata types
         except for hash partitioned table at partition level -->
    <xsl:when test="$DataType='OPAQUE' and $PartitionType!='HASH'"/>
    <xsl:otherwise>
     <xsl:if test="$TABLESPACE!=0 and $ModifyLobStorage=0">
      <xsl:apply-templates select="sxml:STORAGE_TABLE/sxml:TABLESPACE"/>
     </xsl:if>
    </xsl:otherwise>
   </xsl:choose>
   <!-- for subpartitions and hash partitions only TABLESPACE is valid -->
   <xsl:if test="$PartitionType!='HASH' and $Subpartition='0'">
    <xsl:call-template name="LobProperties">
     <xsl:with-param name="StorageTable" select="sxml:STORAGE_TABLE"/>
     <xsl:with-param name="ModifyLobStorage" select="$ModifyLobStorage"/>
    </xsl:call-template>
   </xsl:if>
   <xsl:text>)</xsl:text>
  </xsl:if>
 </xsl:template>
 <xsl:template name="XMLTypeColProperties">
  <xsl:param name="ColNameNode" select="''"/>
  <xsl:param name="ColProperties" select="''"/>
  <!-- *******************************************************************
Template: XMLTypeColProperties
Current node: TABLE/TABLE_PROPERTIES/COLUMN_PROPERTIES/COL_LIST/COL_LIST_ITEM
Parameters:
 ColNameNode   - column name
 ColProperties - TABLE_PROPERTIES/COLUMN_PROPERTIES
******************************************************************** -->
  <xsl:if test="$PRETTY=1">
   <xsl:text>&#xa;</xsl:text>
  </xsl:if>
  <xsl:text> XMLTYPE COLUMN </xsl:text>
  <xsl:call-template name="QuotedName">
   <xsl:with-param name="NameNode" select="$ColNameNode"/>
  </xsl:call-template>
  <xsl:text> </xsl:text>
  <xsl:apply-templates select="$ColProperties/sxml:COL_LIST/sxml:COL_LIST_ITEM[sxml:NAME=$ColNameNode]/sxml:XMLTYPE_PROPERTIES"/>
 </xsl:template>
 <xsl:template match="sxml:XMLTYPE_PROPERTIES">
  <!-- *******************************************************************
Template: XMLTYPE_PROPERTIES
******************************************************************** -->
  <xsl:apply-templates select="sxml:XMLTYPE_STORAGE"/>
  <xsl:apply-templates select="sxml:XMLSCHEMA"/>
  <xsl:apply-templates select="sxml:ELEMENT"/>
  <xsl:apply-templates select="sxml:ID"/>
  <xsl:call-template name="XMLTypeAllowDisallowDDL"/>
 </xsl:template>
 <xsl:template match="sxml:XMLTYPE_STORAGE">
  <!-- *******************************************************************
Template: XMLTYPE_STORAGE
******************************************************************** -->
  <xsl:choose>
   <xsl:when test="sxml:STORE_AS='LOB' or sxml:STORE_AS='BINARY_XML'">
    <xsl:text> STORE AS </xsl:text>
    <xsl:if test="$VERSION>=1100000000">
     <xsl:choose>
      <xsl:when test="sxml:LOB_PROPERTIES/sxml:STORAGE_TABLE/sxml:SECUREFILE">
       <xsl:text>SECUREFILE </xsl:text>
      </xsl:when>
      <xsl:otherwise>
       <xsl:text>BASICFILE </xsl:text>
      </xsl:otherwise>
     </xsl:choose>
    </xsl:if>
    <xsl:choose>
     <xsl:when test="sxml:STORE_AS='LOB'">CLOB</xsl:when>
     <xsl:when test="sxml:STORE_AS='BINARY_XML'">BINARY XML</xsl:when>
    </xsl:choose>
    <xsl:if test="sxml:LOB_PROPERTIES/sxml:STORAGE_TABLE/sxml:NAME">
     <xsl:text> "</xsl:text>
     <xsl:value-of select="sxml:LOB_PROPERTIES/sxml:STORAGE_TABLE/sxml:NAME"/>
     <xsl:text>"</xsl:text>
    </xsl:if>
    <xsl:text> (</xsl:text>
    <xsl:if test="$PRETTY=1">
     <xsl:text>&#xa; </xsl:text>
    </xsl:if>
    <xsl:apply-templates select="sxml:LOB_PROPERTIES/sxml:STORAGE_TABLE/sxml:TABLESPACE"/>
    <xsl:call-template name="LobProperties">
     <xsl:with-param name="StorageTable" select="sxml:LOB_PROPERTIES/sxml:STORAGE_TABLE"/>
    </xsl:call-template>
    <xsl:text>)</xsl:text>
   </xsl:when>
   <xsl:when test="sxml:STORE_AS='OBJECT_RELATIONAL'">
    <!--xsl:text> STORE AS OBJECT RELATIONAL</xsl:text-->
   </xsl:when>
  </xsl:choose>
 </xsl:template>
 <xsl:template name="XMLTypeAllowDisallowDDL">
  <!-- *******************************************************************
Template: XMLTypeAllowDisallowDDL
Current Node: XMLTYPE_PROPERTIES
******************************************************************** -->
  <xsl:if test="sxml:XMLTYPE_STORAGE/sxml:STORE_AS='BINARY_XML'">
   <xsl:choose>
    <xsl:when test="sxml:DISALLOW_NONSCHEMA"> DISALLOW NONSCHEMA</xsl:when>
    <xsl:otherwise> ALLOW NONSCHEMA</xsl:otherwise>
   </xsl:choose>
   <xsl:choose>
    <xsl:when test="sxml:ALLOW_ANYSCHEMA"> ALLOW ANYSCHEMA</xsl:when>
    <xsl:otherwise> DISALLOW ANYSCHEMA</xsl:otherwise>
   </xsl:choose>
  </xsl:if>
 </xsl:template>
 <xsl:template match="sxml:XMLTYPE_VIRTUAL_COLUMNS">
  <!-- *******************************************************************
Template: XMLTYPE_VIRTUAL_COLUMNS
******************************************************************** -->
  <xsl:for-each select="sxml:COL_LIST/sxml:COL_LIST_ITEM">
   <xsl:if test="position()=1">
    <xsl:if test="$PRETTY=1">
     <xsl:text>&#xa;</xsl:text>
    </xsl:if>
    <xsl:text> VIRTUAL COLUMNS (</xsl:text>
   </xsl:if>
   <xsl:text>"</xsl:text>
   <xsl:value-of select="sxml:NAME"/>
   <xsl:text>" AS (</xsl:text>
   <xsl:value-of select="sxml:VIRTUAL"/>
   <xsl:text>)</xsl:text>
   <xsl:choose>
    <xsl:when test="position()!=last()">
     <xsl:text>,</xsl:text>
     <xsl:if test="$PRETTY=1">
      <xsl:text>&#xa;</xsl:text>
     </xsl:if>
    </xsl:when>
    <xsl:otherwise>)</xsl:otherwise>
   </xsl:choose>
  </xsl:for-each>
 </xsl:template>
 <xsl:template name="LobProperties">
  <xsl:param name="StorageTable" select="''"/>
  <xsl:param name="ModifyLobStorage">0</xsl:param>
  <!-- *******************************************************************
Template: LobProperties
Parameters:
 StorageTable
 ModifyLobStorage - 1 = generating ALTER TABLE MODIFY LOB
******************************************************************** -->
  <xsl:if test="$ModifyLobStorage=0">
   <xsl:choose>
    <!--  If the element has the src attribute set to '1',
          we know the element is in a diff doc and came from document 1.
          We only want the value from document 2. -->
    <xsl:when test="$StorageTable/sxml:STORAGE_IN_ROW">
     <xsl:choose>
      <xsl:when test="$StorageTable/sxml:STORAGE_IN_ROW/@src='1'"> DISABLE STORAGE IN ROW</xsl:when>
      <xsl:otherwise> ENABLE STORAGE IN ROW</xsl:otherwise>
     </xsl:choose>
    </xsl:when>
    <xsl:otherwise> DISABLE STORAGE IN ROW</xsl:otherwise>
   </xsl:choose>
   <xsl:apply-templates select="$StorageTable/sxml:CHUNK"/>
  </xsl:if>
  <!-- Process RETENTION for both BASICFILE and SECUREFILE lobs. -->
  <xsl:choose>
   <xsl:when test="$StorageTable/sxml:RETENTION [not(@src='1')]">
    <xsl:apply-templates select="$StorageTable/sxml:RETENTION"/>
   </xsl:when>
   <!-- PCTVERSION is only applicable for BASICFILE lobs and should
      only be present if RETENTION was not. PCTVERSION should 
      never be present in a SECUREFILE lob!
      However, PCTVERSION and RETENTION can both occur in a diff
      doc and therefore we need to decide which is appropriate for these
      cases.
-->
   <xsl:when test="$StorageTable/sxml:PCTVERSION[not(@src='1')]">
    <xsl:apply-templates select="$StorageTable/sxml:PCTVERSION"/>
   </xsl:when>
  </xsl:choose>
  <xsl:if test="$StorageTable/sxml:CACHE
            or $StorageTable/sxml:LOGGING
            or $StorageTable/sxml:LOBENCRYPT
            or $StorageTable/sxml:LOBCOMPRESS
            or $StorageTable/sxml:DEDUPLICATE
            or $StorageTable/sxml:VALIDATE
            or $StorageTable/sxml:STORAGE">
   <xsl:if test="$PRETTY=1">
    <xsl:text>&#xa; </xsl:text>
   </xsl:if>
  </xsl:if>
  <xsl:apply-templates select="$StorageTable/sxml:CACHE"/>
  <xsl:apply-templates select="$StorageTable/sxml:LOGGING"/>
  <!-- We must account for alterxml transforms as well. Therefore it not enough 
         just to check for SECUREFILE because it might indicate 'delete' within a 
         diff doc (i.e., /sxml:SECUREFILE/@src=1)
-->
  <xsl:if test="($ModifyLobStorage=0 and $StorageTable/sxml:SECUREFILE) and
            not($StorageTable/sxml:SECUREFILE/@src='1')">
   <!-- Leave ENCRYPT/DECRYPT out until partition spec is supported.
     The column spec will catch this
    
     Note:  This commented out code also exists in kulob.xsl
    <xsl:choose>
     <xsl:when test="$StorageTable/sxml:LOBENCRYPT"> ENCRYPT</xsl:when>
     <xsl:otherwise> DECRYPT</xsl:otherwise>
    </xsl:choose>
-->
   <xsl:choose>
    <xsl:when test="sxml:STORAGE_TABLE/sxml:LOBCOMPRESS">
     <xsl:apply-templates select="$StorageTable/sxml:LOBCOMPRESS"/>
    </xsl:when>
    <xsl:otherwise>
     <xsl:text> NOCOMPRESS </xsl:text>
    </xsl:otherwise>
   </xsl:choose>
   <xsl:apply-templates select="$StorageTable/sxml:VALIDATE"/>
   <xsl:choose>
    <xsl:when test="sxml:STORAGE_TABLE/sxml:DEDUPLICATE">
     <xsl:apply-templates select="$StorageTable/sxml:DEDUPLICATE"/>
    </xsl:when>
    <xsl:otherwise>
     <xsl:text>KEEP_DUPLICATES </xsl:text>
    </xsl:otherwise>
   </xsl:choose>
  </xsl:if>
  <xsl:apply-templates select="$StorageTable/sxml:STORAGE"/>
 </xsl:template>
 <xsl:template match="sxml:RETENTION">
  <!-- *******************************************************************
Template: RETENTION
       Process RETENTION for both SECUREFILE and BASICFILE lobs.
       If present RETENTION will never have a value for Basicfile lobs.
      However, for SECUREFILE lobs retention can be valueless or
      one of the following values:
            MAX
            MIN  integer
            AUTO
            NONE
******************************************************************** -->
  <xsl:text> RETENTION </xsl:text>
  <xsl:value-of select="."/>
  <xsl:apply-templates select="../sxml:MINTIME"/>
 </xsl:template>
 <xsl:template match="sxml:CACHE">
  <!-- *******************************************************************
Template: CACHE
******************************************************************** -->
  <xsl:choose>
   <xsl:when test=".='Y'"> CACHE</xsl:when>
   <xsl:when test=".='N'"> NOCACHE</xsl:when>
   <xsl:when test=".='READS'"> CACHE READS</xsl:when>
  </xsl:choose>
 </xsl:template>
 <xsl:template match="sxml:LOBCOMPRESS">
  <!-- *******************************************************************
Template: LOBCOMPRESS
******************************************************************** -->
  <xsl:choose>
   <xsl:when test=".='HIGH'"> COMPRESS HIGH </xsl:when>
   <xsl:when test=".='MEDIUM'"> COMPRESS MEDIUM </xsl:when>
   <xsl:when test=".='LOW'"> COMPRESS LOW </xsl:when>
   <xsl:when test=".='N'"> NOCOMPRESS </xsl:when>
  </xsl:choose>
 </xsl:template>
 <xsl:template match="sxml:DEDUPLICATE">
  <!-- *******************************************************************
Template: DEDUPLICATE
******************************************************************** -->
  <xsl:choose>
   <xsl:when test=".='OBJECT'"> DEDUPLICATE OBJECT</xsl:when>
   <xsl:when test=".='LOB'"> DEDUPLICATE LOB</xsl:when>
   <xsl:when test=".='N'"> KEEP_DUPLICATES</xsl:when>
  </xsl:choose>
 </xsl:template>
 <xsl:template match="sxml:VALIDATE">
  <!-- *******************************************************************
Template: VALIDATE
******************************************************************** -->
  <xsl:choose>
   <xsl:when test=".='Y'"> VALIDATE</xsl:when>
  </xsl:choose>
 </xsl:template>
 <xsl:template match="sxml:MINTIME">
  <!-- *******************************************************************
Template: MIN Parameter for RETENTION
******************************************************************** -->
  <xsl:if test=". != 0">
   <xsl:value-of select="."/>
  </xsl:if>
 </xsl:template>
</xsl:stylesheet>
