<?xml version="1.0"?>
<!--
 Copyright (c) 2004, 2010, Oracle and/or its affiliates. All rights reserved. 
NAME
    kustable.xsl
DESCRIPTION
    Convert mdapi TABLE_T document to TABLE document (SXML)

MODIFIED        MM/DD/YY
    ebatbout    03/28/10 - Refine prior edit to take into account stream meta-
                           data version when add suffix, '.NESTED_TABLE_SETID$'
    ebatbout    01/25/10 - bug 8465341: When HIDDEN_COLUMNS param set(by Data 
                           Pump data layer (prvtbpd.sql):
                           In template,CreObjTable, create unique name for
                           nested table setid col(instead of system generated
                           generated name)
                           Add the elements, stream_major_version & stream_
                           minor_version, to the sxml document.
    lbarton     11/04/09 - deferred segment creation for partitions
    abodge      09/21/09 - CONSOLIDATE STYLESHEETS: MAKE_DIFF_READY -> CM_MODE
    ebatbout    12/16/08 - bug 6075698: add support for hidden_columns param
                           and recognize STRMTABLE_T keyword
    rapayne     12/24/08 - bug 759589: add $STATISTICS support from CM code stream.
    lbarton     08/28/08 - xmltype virtual columns
    lbarton     02/14/08 - flashback archive
    lbarton     03/19/08 - deferred segment creation
    abodge      01/22/07 - add COL_NUM attribute when MAKE_DIFF_READY is set.
    rapayne     11/27/06 - Integrate EM specific changes
    rapayne     07/14/06 - Sort by column name
    lbarton     06/23/06 - PARSE_EXPRESSIONS param 
    htseng      05/24/06 - virtual hidden support 
    lbarton     03/27/06 - bug 5118027: CONSTRAINTS and REF_CONSTRAINTS params 
                           for SXML 
    htseng      12/16/05 - add transform param 
    lbarton     11/08/05 - bug 4724986: fix handling of xmlns 
    sdavidso    11/02/05 - fix inconsistent stylesheet format 
    lbarton     09/14/05 - SXML syntax changes required by XML schema 
    lbarton     08/10/05 - lbarton_mddiff
    htseng      05/27/05 - pass PROPERTY to TablePhysicalProperties 
    lbarton     11/01/04 - Initial version
 -->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns="http://xmlns.oracle.com/ku">
 <!-- Top level imports -->
 <xsl:import href="kuscomm.xsl"/>
 <xsl:import href="kuscnstr.xsl"/>
 <xsl:import href="kustbphy.xsl"/>
 <xsl:import href="kuspar.xsl"/>
 <!-- Top-level parameters -->
 <xsl:param name="PHYSICAL_PROPERTIES">1</xsl:param>
 <xsl:param name="SEGMENT_ATTRIBUTES">1</xsl:param>
 <xsl:param name="STORAGE">1</xsl:param>
 <xsl:param name="TABLESPACE">1</xsl:param>
 <xsl:param name="CONSTRAINTS">1</xsl:param>
 <xsl:param name="REF_CONSTRAINTS">1</xsl:param>
 <xsl:param name="PARTITIONING">1</xsl:param>
 <xsl:param name="OID">1</xsl:param>
 <xsl:param name="PARSE_EXPRESSIONS">0</xsl:param>
 <xsl:param name="STATISTICS">0</xsl:param>
 <xsl:param name="HIDDEN_COLUMNS">0</xsl:param>
 <xsl:param name="STREAMD_VERSION">2</xsl:param>
 <!-- Templates -->
 <xsl:template match="TABLE_T | STRMTABLE_T">
  <!-- *******************************************************************
Template: TABLE_T - top-level template for tables.
  This template puts out
   - the opening TABLE element (with xmlns and version attributes)
   - SCHEMA and NAME elements
  then calls one of
   - CreObjTable - for object tables and XMLType tables
   - CreRelTable - for relational tables
******************************************************************** -->
  <xsl:element name="TABLE">
   <!-- XMLSpy and the lpx XSL processor have different ways of
      generating the xmlns attribute for the top-level item.
      XMLSpy, citing http://www.w3.org/TR/xslt#creating-attributes,
      does it by inheriting the default target namespace from the stylesheet
      element, and ignoring any xsl:attribute whose name is"xmlns".
      The lpx XSL processor, which DBMS_METADATA uses, does
      the exact reverse. This stylesheet is coded to work in both environments.
      It's possible it may fail when run on other processors.
-->
   <xsl:attribute name="xmlns">http://xmlns.oracle.com/ku</xsl:attribute>
   <xsl:attribute name="version">1.0</xsl:attribute>
   <xsl:if test="(PROPERTY mod 8388608)>=4194304">
    <xsl:element name="GLOBAL_TEMPORARY"/>
   </xsl:if>
   <xsl:apply-templates select="SCHEMA_OBJ"/>
   <!-- HIDDEN_COLUMNS is set by the Data Pump data layer (prvtbpd.sql) when
        converting table and stream xml documents to sxml.
     -->
   <xsl:if test="$HIDDEN_COLUMNS = 1">
    <xsl:choose>
     <!-- For sxml document of the current table, set stream metadata version
          to 1.2 (first valid version that supports field, base_col_name) -->
     <xsl:when test="local-name(.)='TABLE_T'">
      <xsl:element name="STREAM_MAJOR_VERSION">
       <xsl:text>1</xsl:text>
      </xsl:element>
      <xsl:element name="STREAM_MINOR_VERSION">
       <xsl:text>2</xsl:text>
      </xsl:element>
     </xsl:when>
     <xsl:otherwise>
      <!-- Extract the stream version from the stream metadata document --> 
      <xsl:element name="STREAM_MAJOR_VERSION">
       <xsl:value-of select="VERS_MAJOR"/>
      </xsl:element>
      <xsl:element name="STREAM_MINOR_VERSION">
       <xsl:value-of select="VERS_MINOR"/>
      </xsl:element>
     </xsl:otherwise>
    </xsl:choose>
   </xsl:if>
   <xsl:choose>
    <xsl:when test="(PROPERTY mod 2)=1">
     <!-- object or XMLType table -->
     <xsl:choose>
      <xsl:when test="COL_LIST/COL_LIST_ITEM[NAME='SYS_NC_ROWINFO$']/TYPEMD/SCHEMA_OBJ/NAME='XMLTYPE'
              or 
         COL_LIST/COL_LIST_ITEM[NAME='SYS_NC_ROWINFO$']/TYPEMD/NAME='XMLTYPE'">
       <xsl:element name="XMLTYPE_TABLE">
        <xsl:call-template name="CreObjTable"/>
       </xsl:element>
      </xsl:when>
      <xsl:otherwise>
       <xsl:element name="OBJECT_TABLE">
        <xsl:call-template name="CreObjTable"/>
       </xsl:element>
      </xsl:otherwise>
     </xsl:choose>
    </xsl:when>
    <xsl:otherwise>
     <xsl:element name="RELATIONAL_TABLE">
      <xsl:call-template name="CreRelTable"/>
     </xsl:element>
    </xsl:otherwise>
   </xsl:choose>
   <xsl:if test="(string(ROWCNT) and not ($STATISTICS=0))">
    <xsl:element name="STATISTICS">
     <xsl:call-template name="CreTblStats"/>
    </xsl:element>
   </xsl:if>
  </xsl:element>
 </xsl:template>
 <xsl:template name="CreTblStats">
  <!-- *******************************************************************
Template: CreTblStats - processing table stats
Current node: TABLE_T
  Emit the following:
 ROWCNT
 BLKCNT
 EMPCNT
 AVGSPC
 CHNCNT
 AVGRLN
 AVGSPC_FLB
 FLBCNT
 ANALYZETIME
 SAMPLESIZE
 INTCOLS
 KERNELCOLS
 PROPERTY
 PROPERTY2
 XMLSCHEMACOLS
 TRIGFLAG
 SPARE1
 SPARE6
******************************************************************** -->
  <xsl:element name="ROWCNT">
   <xsl:value-of select="ROWCNT"/>
  </xsl:element>
  <xsl:element name="BLKCNT">
   <xsl:value-of select="BLKCNT"/>
  </xsl:element>
  <xsl:element name="EMPCNT">
   <xsl:value-of select="EMPCNT"/>
  </xsl:element>
  <xsl:element name="AVGSPC">
   <xsl:value-of select="AVGSPC"/>
  </xsl:element>
  <xsl:element name="CHNCNT">
   <xsl:value-of select="CHNCNT"/>
  </xsl:element>
  <xsl:element name="AVGRLN">
   <xsl:value-of select="AVGRLN"/>
  </xsl:element>
  <xsl:element name="AVGSPC_FLB">
   <xsl:value-of select="AVGSPC_FLB"/>
  </xsl:element>
  <xsl:element name="FLBCNT">
   <xsl:value-of select="FLBCNT"/>
  </xsl:element>
  <xsl:element name="ANALYZETIME">
   <xsl:value-of select="ANALYZETIME"/>
  </xsl:element>
  <xsl:element name="SAMPLESIZE">
   <xsl:value-of select="SAMPLESIZE"/>
  </xsl:element>
 </xsl:template>
 <xsl:template name="CreRelTable">
  <!-- *******************************************************************
Template: CreRelTable - processing for relational tables
Current node: TABLE_T
  Emit the following:
   - column list
   - constraints
   - supplemental logging
   - on commit
   - physical properties (non-partitioned tables only)
   - table properties
   - column properties
   - table partitioning
   - CACHE
   - parallel clause
   - row dependencies
   - row movement
******************************************************************** -->
  <!-- column list -->
  <xsl:element name="COL_LIST">
   <!-- If the differ specific CM_MODE parameter is set then make
        a pass thru and sort all of the columns by name)
     -->
   <xsl:choose>
    <xsl:when test="$CM_MODE=1">
     <xsl:for-each select="COL_LIST/COL_LIST_ITEM[(PROPERTY mod 64)&lt;32
	     or ((PROPERTY mod 512)&lt;256 and (PROPERTY mod 131072)>= 65536)  
             or (PROPERTY mod 2097152)>=1048576
             or (PROPERTY mod 8388608)>=4194304]">
      <xsl:sort select="NAME" data-type="text" lang="en"/>
      <xsl:element name="COL_LIST_ITEM">
       <!-- Include column name as an attribute for diffing -->
       <xsl:attribute name="NAME"><xsl:value-of select="NAME"/></xsl:attribute>
       <!-- Include column number as attribute to allow re-ordering of
           columns before generating create DDL  -->
       <xsl:attribute name="col-num"><xsl:value-of select="COL_NUM"/></xsl:attribute>
       <xsl:call-template name="ColumnDefinition"/>
      </xsl:element>
     </xsl:for-each>
    </xsl:when>
    <xsl:otherwise>
     <!-- exclude hidden columns                            - prop bit 0x000020
        (but do include hidden snapshot base table column - prop bit 0x100000
         and do include RLS hidden column                 - prop bit 0x800000
	 and virtual columns that is not                  - prop bit 0x010000
	     system-generated column                      - prop bit 0x000100)
     -->
     <xsl:for-each select="COL_LIST/COL_LIST_ITEM[(PROPERTY mod 64)&lt;32
             or (not($HIDDEN_COLUMNS=0) and ((PROPERTY mod 64)>=32))
	     or ((PROPERTY mod 512)&lt;256 and (PROPERTY mod 131072)>= 65536)  
                      or (PROPERTY mod 2097152)>=1048576
                      or (PROPERTY mod 8388608)>=4194304]">
      <xsl:element name="COL_LIST_ITEM">
       <xsl:call-template name="ColumnDefinition">
        <xsl:with-param name="ExternalTable" select="$HIDDEN_COLUMNS"/>
       </xsl:call-template>
      </xsl:element>
     </xsl:for-each>
    </xsl:otherwise>
   </xsl:choose>
  </xsl:element>
  <!-- constraints -->
  <xsl:call-template name="TableConstraints"/>
  <!-- supplemental logging -->
  <xsl:call-template name="SupplementalLogging"/>
  <xsl:choose>
   <xsl:when test="(PROPERTY mod 8388608)>=4194304">
    <!-- temporary table -->
    <!-- on commit -->
    <xsl:call-template name="OnCommit">
     <xsl:with-param name="Property" select="PROPERTY"/>
    </xsl:call-template>
   </xsl:when>
   <xsl:otherwise>
    <!-- physical properties (non-partitioned tables only) -->
    <xsl:if test="(PROPERTY mod 64)&lt;32">
     <xsl:call-template name="TablePhysicalProperties">
      <xsl:with-param name="PROPERTY" select="PROPERTY"/>
      <xsl:with-param name="PROPERTY2" select="PROPERTY2"/>
     </xsl:call-template>
    </xsl:if>
    <!-- table properties -->
    <xsl:call-template name="TableProperties"/>
   </xsl:otherwise>
  </xsl:choose>
 </xsl:template>
 <xsl:template name="OnCommit">
  <xsl:param name="Property">0</xsl:param>
  <!-- *******************************************************************
Template: OnCommit
Parameters:
 Property - value of table PROPERTY
******************************************************************** -->
  <xsl:if test="($Property mod 8388608)>=4194304">
   <!-- temporary table -->
   <xsl:element name="ON_COMMIT">
    <xsl:choose>
     <xsl:when test="($Property mod 16777216)>=8388608">
      <xsl:text>PRESERVE</xsl:text>
     </xsl:when>
     <xsl:otherwise>
      <xsl:text>DELETE</xsl:text>
     </xsl:otherwise>
    </xsl:choose>
   </xsl:element>
  </xsl:if>
 </xsl:template>
 <xsl:template name="TableProperties">
  <!-- *******************************************************************
Template: TableProperties
Current node: TABLE_T
  Emit the following:
   - column properties
   - XMLType virtual columns
   - table partitioning
   - CACHE
   - parallel clause
   - row dependencies
   - row movement
******************************************************************** -->
  <!-- See if TABLE_PROPERTIES can be skipped altogether.
      The first 7 tests are reproduced from kustbphy.xsl.
                              and 32>(PROPERTY mod 64)]/OPQMD)
 -->
  <xsl:if test="(COL_LIST/COL_LIST_ITEM[(TYPE_NUM=121)
          and not (NAME='SYS_NC_ROWINFO$')
          and (32768>(PROPERTY mod 65536))
          and ((TYPEMD/FLAGS mod 4096)>= 2048 or
               (TYPEMD/FLAGS mod 2048)>= 1024 or
               (TYPEMD/SUBTYPE_LIST/SUBTYPE_LIST_ITEM/FLAGS mod 4)=3)])
        or
        (COL_LIST/COL_LIST_ITEM[(TYPE_NUM=122)
                              and (32768>(PROPERTY mod 65536))])
        or
        (COL_LIST/COL_LIST_ITEM[(TYPE_NUM=123)
                              and (256>(PROPERTY mod 512))
                              and (32768>(PROPERTY mod 65536))
                              and (((TYPEMD/FLAGS mod 128)>=64)
                              or   ((TYPEMD/FLAGS mod 8)>=4))])
        or
        (COL_LIST/COL_LIST_ITEM[(TYPE_NUM=112 or TYPE_NUM=113)
                              and (32768>(PROPERTY mod 65536))
                              and (256>(PROPERTY mod 512))]
                              and not ($SEGMENT_ATTRIBUTES=0)
                              and not ($PHYSICAL_PROPERTIES=0)
                              and not ($TABLESPACE=0))
        or
        (COL_LIST/COL_LIST_ITEM[(TYPE_NUM=58) 
                              and (32768>(PROPERTY mod 65536))
                              and (256>(PROPERTY mod 512))
                              and not ((OPQMD/FLAGS mod 4)>=2)]/LOBMD)
        or
        (COL_LIST/COL_LIST_ITEM[(TYPE_NUM=58)
                              and not (NAME='SYS_NC_ROWINFO$')
                              and (32768>(PROPERTY mod 65536))
                              and (TYPEMD/SCHEMA_OBJ/OWNER_NAME='SYS')
                              and (TYPEMD/SCHEMA_OBJ/NAME='XMLTYPE')
                              and (OPQMD/SCHEMA_ELMT)])
        or
        (COL_LIST/COL_LIST_ITEM[(PROPERTY mod 16 >= 8) and
           (PROPERTY mod 64 >= 32) and
           (PROPERTY mod 131052 >= 65536) and
           (256 > (PROPERTY mod 512)) and
           (512 > (PROPERTY mod 1024)) and
           (16384 > (PROPERTY mod 32768))])
        or
        (PART_OBJ)
        or
        (FLAGS mod 16)>=8
        or
        DEGREE
        or
        (FLAGS mod 16777216)>=8388608
        or
        (FLAGS mod 262144)>=131072
        or
        FBA">
   <!-- There are some table properties -->
   <xsl:element name="TABLE_PROPERTIES">
    <!-- Column properties -->
    <xsl:call-template name="TableColumnProperties">
     <xsl:with-param name="ColListParent" select="."/>
     <xsl:with-param name="NTNode" select="NT"/>
     <xsl:with-param name="TabBlocksize" select="BLOCKSIZE"/>
    </xsl:call-template>
    <!-- XMLType virtual columns -->
    <xsl:call-template name="XMLTypeVirtualColumns">
     <xsl:with-param name="VirtualCols" select="COL_LIST/COL_LIST_ITEM[(PROPERTY mod 16 >= 8) and
           (PROPERTY mod 64 >= 32) and
           (PROPERTY mod 131052 >= 65536) and
           (256 > (PROPERTY mod 512)) and
           (512 > (PROPERTY mod 1024)) and
           (16384 > (PROPERTY mod 32768))]"/>
    </xsl:call-template>
    <!-- table partitioning -->
    <xsl:if test="PART_OBJ">
     <xsl:call-template name="TablePartitioning">
      <xsl:with-param name="PartobjNode" select="PART_OBJ"/>
      <xsl:with-param name="PropertyNode" select="PROPERTY"/>
      <xsl:with-param name="ColListNode" select="COL_LIST"/>
      <xsl:with-param name="TabBlocksize" select="BLOCKSIZE"/>
      <xsl:with-param name="TableNode" select="."/>
     </xsl:call-template>
    </xsl:if>
    <!-- CACHE -->
    <xsl:if test="(FLAGS mod 16)>=8">
     <xsl:element name="CACHE"/>
    </xsl:if>
    <!-- parallel clause -->
    <xsl:call-template name="ParallelClause">
     <xsl:with-param name="ParentNode" select="."/>
    </xsl:call-template>
    <!-- row dependencies -->
    <xsl:if test="(FLAGS mod 16777216)>=8388608">
     <xsl:element name="ROW_DEPENDENCIES"/>
    </xsl:if>
    <!-- row movement -->
    <xsl:if test="(FLAGS mod 262144)>=131072">
     <xsl:element name="ROW_MOVEMENT"/>
    </xsl:if>
    <!-- flashback archive -->
    <xsl:apply-templates select="FBA"/>
   </xsl:element>
  </xsl:if>
 </xsl:template>
 <xsl:template match="FBA">
  <!-- *******************************************************************
Template: FBA - for flashback archive enabled tables
******************************************************************** -->
  <xsl:element name="FLASHBACK_ARCHIVE">
   <xsl:value-of select="FA_NAME"/>
  </xsl:element>
 </xsl:template>
 <xsl:template name="CreObjTable">
  <!-- *******************************************************************
Template: CreObjTable - processing for object and XMLType tables
Current node: TABLE_T
  Emit the following:
   - OF_TYPE
   - object table substitution (object tables only)
   - column defaults
   - constraints
   - XMLType storage           (XMLType tables only)
   - XMLSchema spec            (XMLType tables only)
   - on commit
   - OID clause
   - OID index clause
   - physical properties
   - table properties
******************************************************************** -->
  <!-- there is only one column named SYS_NC_ROWINFO$
      and it contains the type metadata -->
  <xsl:for-each select="COL_LIST/COL_LIST_ITEM[NAME='SYS_NC_ROWINFO$']/TYPEMD">
   <!-- OF_TYPE -->
   <xsl:element name="OF_TYPE">
    <xsl:choose>
     <xsl:when test="SYN_NAME">
      <xsl:if test="SYN_OWNER">
       <xsl:element name="SCHEMA">
        <xsl:value-of select="SYN_OWNER"/>
       </xsl:element>
      </xsl:if>
      <xsl:element name="NAME">
       <xsl:value-of select="SYN_NAME"/>
      </xsl:element>
     </xsl:when>
     <xsl:otherwise>
      <xsl:apply-templates select="SCHEMA_OBJ"/>
     </xsl:otherwise>
    </xsl:choose>
   </xsl:element>
   <!-- object table substitution -->
   <xsl:choose>
    <!--  0x800 - SUBSTITUTABLE specified explicitly -->
    <xsl:when test="(FLAGS mod 4096)>= 2048">
     <xsl:element name="SUBSTITUTABLE">Y</xsl:element>
    </xsl:when>
    <!--  0x400 - NOT SUBSTITUTABLE specified explicitly -->
    <xsl:when test="(FLAGS mod 2048)>=1024">
     <xsl:element name="SUBSTITUTABLE">N</xsl:element>
    </xsl:when>
   </xsl:choose>
  </xsl:for-each>
  <!-- column defaults -->
  <xsl:if test="(COL_LIST/COL_LIST_ITEM[(DEFLENGTH!=0 or ($HIDDEN_COLUMNS=1))
                and (($HIDDEN_COLUMNS=1) or (32 > (PROPERTY mod 64)))   
		and (1024 > (PROPERTY mod 1024))]) or
              (COL_LIST/COL_LIST_ITEM[CON/CONTYPE='7' or CON/CONTYPE='11'])">
   <xsl:element name="OBJECT_COLUMN_PROPERTIES">
    <xsl:element name="COL_LIST">
     <xsl:for-each select="(COL_LIST/COL_LIST_ITEM[(
                       (DEFLENGTH != 0 or ($HIDDEN_COLUMNS=1)) and
                      (($HIDDEN_COLUMNS=1) or (32 > (PROPERTY mod 64)))   
		      and (1024 > (PROPERTY mod 1024))) or
                      (CON/CONTYPE='7' or CON/CONTYPE='11')])">
      <xsl:element name="COL_LIST_ITEM">
       <xsl:element name="NAME">
        <xsl:choose>
         <xsl:when test="$HIDDEN_COLUMNS=0">
          <xsl:value-of select="NAME"/> 
         </xsl:when>
         <xsl:otherwise>
          <xsl:choose>
           <!-- Append suffix,'.NESTED_TABLE_SETID$'.  The purpose is to create
             a unique name for this column in case the document will be diff'ed
             -->
           <xsl:when test="((PROPERTY mod 2048)>=1024) and BASE_COL_NAME and
                            ($STREAMD_VERSION >= 2)">
            <xsl:value-of select="concat(BASE_COL_NAME,'.NESTED_TABLE_SETID$')"/>
           </xsl:when>
           <xsl:when test="((PROPERTY mod 2048)>=1024) and ATTRNAME and
                            ($STREAMD_VERSION >= 2)">
            <xsl:value-of select="concat(ATTRNAME,'.NESTED_TABLE_SETID$')"/>
           </xsl:when>
           <xsl:when test="ATTRNAME">
            <xsl:value-of select="ATTRNAME"/>
           </xsl:when>
           <xsl:otherwise>
            <xsl:value-of select="NAME"/> 
           </xsl:otherwise>
          </xsl:choose>
         </xsl:otherwise>
        </xsl:choose>
       </xsl:element>
       <xsl:if test="DEFAULT_VAL">
        <xsl:element name="DEFAULT">
         <xsl:apply-templates select="DEFAULT_VAL"/>
        </xsl:element>
       </xsl:if>
       <xsl:if test="TYPE_NUM and (not($HIDDEN_COLUMNS=0))">
        <xsl:apply-templates select="TYPE_NUM">
         <xsl:with-param name="ParentNode" select="."/>
        </xsl:apply-templates>
       </xsl:if>
       <xsl:if test="CON/CONTYPE='7' or CON/CONTYPE='11'">
        <xsl:element name="NOT_NULL">
         <xsl:if test="(CON/FLAGS mod 16)&lt;8">
          <NAME>
           <xsl:value-of select="CON/NAME"/>
          </NAME>
         </xsl:if>
         <xsl:call-template name="EnableDisable">
          <xsl:with-param name="ConNode" select="CON"/>
         </xsl:call-template>
        </xsl:element>
       </xsl:if>
       <xsl:if test="$HIDDEN_COLUMNS = 1">
        <xsl:if test="SEGCOL_NUM">
         <xsl:element name="SEGCOL_NUM">
          <xsl:value-of select="SEGCOL_NUM"/>
         </xsl:element>
        </xsl:if>
        <xsl:if test="INTCOL_NUM">
         <xsl:element name="INTCOL_NUM">
          <xsl:value-of select="INTCOL_NUM"/>
         </xsl:element>
         <xsl:if test="(PROPERTY mod 131072)>=65536">
          <xsl:element name="VIRTUAL"/>
         </xsl:if>
        </xsl:if>
        <xsl:if test="ATTRNAME or (PROPERTY mod 2048)>=1024">
         <xsl:element name="INTERNAL_NAME">
          <xsl:value-of select="NAME"/>
         </xsl:element>
         <xsl:if test="((PROPERTY mod 2048)>=1024)">
          <xsl:element name="NESTED_TABLE_SETID"/>
         </xsl:if>
        </xsl:if>
       </xsl:if>
      </xsl:element>
     </xsl:for-each>
    </xsl:element>
   </xsl:element>
  </xsl:if>
  <!-- constraints -->
  <xsl:call-template name="TableConstraints"/>
  <xsl:if test="COL_LIST/COL_LIST_ITEM[NAME='SYS_NC_ROWINFO$']/OPQMD/SCHEMA_ELMT">
   <!-- XMLType storage           (XMLType tables only) -->
   <!-- XML structure is
       COL_LIST
        COL_LIST_ITEM (ku$_column_t)
         LOBMD        (ku$_lob_t     - null if not lob)
         OPQMD        (ku$_opqtype_t - null if not opaque)
          SCHEMA_ELMT (ku$_xmlschema_elmt_t)
  -->
   <xsl:call-template name="XMLTypeStorage">
    <xsl:with-param name="ColNode" select="COL_LIST/COL_LIST_ITEM[NAME='SYS_NC_ROWINFO$']"/>
    <xsl:with-param name="TabBlocksize" select="BLOCKSIZE"/>
   </xsl:call-template>
   <!-- XMLSchema spec            (XMLType tables only) -->
   <xsl:call-template name="XMLSchemaSpec">
    <xsl:with-param name="ColNode" select="COL_LIST/COL_LIST_ITEM[NAME='SYS_NC_ROWINFO$']"/>
   </xsl:call-template>
  </xsl:if>
  <!-- on commit -->
  <xsl:if test="(PROPERTY mod 8388608)>=4194304">
   <!-- temporary table -->
   <xsl:call-template name="OnCommit">
    <xsl:with-param name="Property" select="PROPERTY"/>
   </xsl:call-template>
  </xsl:if>
  <!-- OID clause -->
  <xsl:choose>
   <!-- User requested -->
   <xsl:when test="$OID!=1">
    <xsl:element name="OID">
     <xsl:value-of select="SCHEMA_OBJ/OID"/>
    </xsl:element>
   </xsl:when>
   <xsl:when test="CON1_LIST/CON1_LIST_ITEM[CONTYPE='2']">
    <xsl:element name="OID">
     <xsl:choose>
      <!-- has primary-key OID -->
      <xsl:when test="(PROPERTY mod 8192)>=4096">PRIMARY_KEY</xsl:when>
      <!-- ???? can we do this along with OID index ??? -->
      <xsl:otherwise>SYSTEM_GENERATED</xsl:otherwise>
     </xsl:choose>
    </xsl:element>
   </xsl:when>
  </xsl:choose>
  <!-- OID index clause (not for schema-based XMLType tables -->
  <xsl:if test="COL_LIST/COL_LIST_ITEM/OIDINDEX
                 and not
       (COL_LIST/COL_LIST_ITEM[NAME='SYS_NC_ROWINFO$']/OPQMD and
       COL_LIST/COL_LIST_ITEM[NAME='SYS_NC_ROWINFO$']/OPQMD/SCHEMA_ELMT)">
   <xsl:call-template name="OidIndex">
    <xsl:with-param name="ColNode" select="COL_LIST/COL_LIST_ITEM[OIDINDEX]"/>
    <xsl:with-param name="TabProperty" select="PROPERTY"/>
   </xsl:call-template>
  </xsl:if>
  <xsl:if test="4194304>(PROPERTY mod 8388608)">
   <!-- not temporary table -->
   <!-- physical properties (non-partitioned tables only) -->
   <xsl:if test="(PROPERTY mod 64)&lt;32">
    <xsl:call-template name="TablePhysicalProperties">
     <xsl:with-param name="PROPERTY" select="PROPERTY"/>
    </xsl:call-template>
   </xsl:if>
   <!-- table properties -->
   <xsl:call-template name="TableProperties"/>
  </xsl:if>
 </xsl:template>
 <xsl:template name="OidIndex">
  <xsl:param name="ColNode" select="''"/>
  <xsl:param name="TabProperty">0</xsl:param>
  <!-- *******************************************************************
Template: OidIndex 
Parameters:
  ColNode - COL_LIST_ITEM node with OIDINDEX child
  TabProperty - value of TABLE_T/PROPERTY
******************************************************************** -->
  <xsl:if test="not ($SEGMENT_ATTRIBUTES=0) and not ($PHYSICAL_PROPERTIES=0)">
   <!-- emit OIDINDEX if either (1) not a temporary table or 
      (2) name not system-generated -->
   <xsl:if test="4194304>(PROPERTY mod 8388608) or
               (($ColNode/OIDINDEX/FLAGS mod 16) &lt; 8)">
    <xsl:element name="OIDINDEX">
     <!-- put out name if not system-generated -->
     <xsl:if test="($ColNode/OIDINDEX/FLAGS mod 16) &lt; 8">
      <xsl:call-template name="ColName">
       <xsl:with-param name="ColNode" select="$ColNode/OIDINDEX"/>
      </xsl:call-template>
     </xsl:if>
     <!-- put out physical attributes and tablespace if not temporary table -->
     <xsl:if test="($TabProperty mod 8388608) &lt; 4194304">
      <xsl:call-template name="PhysicalAttributes">
       <xsl:with-param name="ParentNode" select="$ColNode/OIDINDEX"/>
       <xsl:with-param name="Partitioned" select="0"/>
       <xsl:with-param name="ObjType" select="TABLE"/>
      </xsl:call-template>
      <xsl:call-template name="Tablespace">
       <xsl:with-param name="ParentNode" select="$ColNode/OIDINDEX"/>
      </xsl:call-template>
     </xsl:if>
    </xsl:element>
   </xsl:if>
  </xsl:if>
 </xsl:template>
</xsl:stylesheet>
