<?xml version="1.0"?>
<!--

 Copyright (c) 2005, 2009, Oracle and/or its affiliates. All rights reserved. 

NAME
    kustblsd.xsl
DESCRIPTION
    Convert TABLESPACE document (SXML) to creation DDL.

MODIFIED        MM/DD/YY
    rapayne     11/01/09 - bug 8714709: fix encrypted tablespace support.
    lbarton     07/10/09 - bug 8494344: archive compression
    rapayne     02/24/09 - lrg 3784210: add REUSE transform parameter. In the 
                           tkmadftbs test, this will allow us to avoid a race
                           condition that currently causes intermittent failures 
                           on  WINDOWs.
    lbarton     01/17/08 - Bug 6724820: table compression
    lbarton     02/20/06 - bug 4752442: BIGFILE 
    sdavidso    11/02/05 - fix inconsistent stylesheet format 
    sdavidso   08/29/05 - handle OMF datafiles in tablespaces 
    lbarton    08/10/05 - lbarton_mddiff
    htseng     03/21/05 - Initial version
 -->
<xsl:stylesheet version="1.0" xmlns:sxml="http://xmlns.oracle.com/ku" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
 <!-- Top level imports -->
 <xsl:import href="kuscommd.xsl"/>
 <xsl:import href="kusindxd.xsl"/>
 <xsl:import href="kustbphd.xsl"/>
 <!-- Top-level parameters -->
 <!-- Parameters for DDL generation -->
 <xsl:param name="PRETTY">1</xsl:param>
 <xsl:param name="SQLTERMINATOR">0</xsl:param>
 <xsl:param name="REUSE">0</xsl:param>
 <!-- Templates -->
 <xsl:template match="sxml:TABLESPACE">
  <!-- *******************************************************************
Template: TABLESPACE - top-level template for tables.
  This template calls one of
   - DoUndoTS
   - DoPermanentTS
   - DoTemporaryTS
******************************************************************** -->
  <xsl:choose>
   <xsl:when test="sxml:TYPE='UNDO'">
    <xsl:call-template name="DoUndoTS"/>
   </xsl:when>
   <xsl:when test="sxml:TYPE='TEMPORARY'">
    <xsl:call-template name="DoTemporaryTS"/>
   </xsl:when>
   <xsl:when test="sxml:TYPE='PERMANENT'">
    <xsl:call-template name="DoPermanentTS"/>
   </xsl:when>
   <xsl:otherwise>
    <xsl:text>??? Unknown tablespace type: </xsl:text>
    <xsl:value-of select="sxml:TYPE"/>
   </xsl:otherwise>
  </xsl:choose>
  <xsl:if test="$SQLTERMINATOR=1">
   <xsl:text>;</xsl:text>
   <!-- Terminate the SQL statement -->
  </xsl:if>
 </xsl:template>
 <xsl:template name="DoUndoTS">
  <!-- *******************************************************************
Template: DoUndoTS
Current node: TABLESPACE
******************************************************************** -->
  <xsl:call-template name="DoCreateVerb"/>
  <xsl:text>UNDO TABLESPACE "</xsl:text>
  <xsl:value-of select="sxml:NAME"/>
  <xsl:text>" DATAFILE </xsl:text>
  <xsl:apply-templates select="sxml:DATAFILE_LIST"/>
  <xsl:apply-templates select="sxml:EXTENT_MANAGEMENT"/>
  <xsl:apply-templates select="sxml:RETENTION_GUARANTEE"/>
 </xsl:template>
 <xsl:template name="DoCreateVerb">
  <!-- *******************************************************************
 Template: DoCreateVerb
     Output CREATE [BIGFILE]
******************************************************************** -->
  <xsl:text> CREATE </xsl:text>
  <xsl:apply-templates select="sxml:BIGFILE"/>
 </xsl:template>
 <xsl:template match="sxml:BIGFILE">
  <!-- *******************************************************************
 Template: BIGFILE
     Output BIGFILE
******************************************************************** -->
  <xsl:text>BIGFILE </xsl:text>
 </xsl:template>
 <xsl:template match="sxml:ENCRYPT">
  <!-- *******************************************************************
 Template: ENCRYPT
******************************************************************** -->
  <xsl:text> ENCRYPTION</xsl:text>
 </xsl:template>
 <xsl:template name="DoTemporaryTS">
  <!-- *******************************************************************
Template: DoTemporaryTS
Current node: TABLESPACE
******************************************************************** -->
  <xsl:call-template name="DoCreateVerb"/>
  <xsl:text>TEMPORARY TABLESPACE "</xsl:text>
  <xsl:value-of select="sxml:NAME"/>
  <xsl:text>" TEMPFILE </xsl:text>
  <xsl:apply-templates select="sxml:DATAFILE_LIST"/>
  <xsl:apply-templates select="sxml:TABLESPACE_GROUP"/>
  <xsl:apply-templates select="sxml:EXTENT_MANAGEMENT"/>
 </xsl:template>
 <xsl:template name="DoPermanentTS">
  <!-- *******************************************************************
Template: DoPermanentTS
Current node: TABLESPACE
******************************************************************** -->
  <xsl:call-template name="DoCreateVerb"/>
  <xsl:text>TABLESPACE "</xsl:text>
  <xsl:value-of select="sxml:NAME"/>
  <xsl:text>" DATAFILE </xsl:text>
  <xsl:apply-templates select="sxml:DATAFILE_LIST"/>
  <xsl:if test="$PRETTY=1">
   <xsl:text>&#xa; </xsl:text>
  </xsl:if>
  <xsl:apply-templates select="sxml:MINIMUM_EXTENT"/>
  <xsl:apply-templates select="sxml:LOGGING"/>
  <xsl:choose>
   <xsl:when test="sxml:OFFLINE"> OFFLINE</xsl:when>
   <xsl:otherwise> ONLINE</xsl:otherwise>
  </xsl:choose>
  <xsl:apply-templates select="sxml:BLOCKSIZE"/>
  <xsl:apply-templates select="sxml:FORCE_LOGGING"/>
  <xsl:apply-templates select="sxml:EXTENT_MANAGEMENT"/>
  <xsl:apply-templates select="sxml:DEFAULT"/>
  <xsl:apply-templates select="sxml:SEGMENT_SPACE_MANAGEMENT"/>
 </xsl:template>
 <xsl:template match="sxml:DATAFILE_LIST">
  <!-- *******************************************************************
Template: DATAFILE_LIST
******************************************************************** -->
  <xsl:for-each select="sxml:DATAFILE_LIST_ITEM">
   <xsl:if test="$PRETTY=1">
    <xsl:text>&#xa;   </xsl:text>
   </xsl:if>
   <xsl:if test="sxml:NAME">
    <xsl:text>'</xsl:text>
    <xsl:value-of select="sxml:NAME"/>
    <xsl:text>'</xsl:text>
   </xsl:if>
   <xsl:if test="sxml:SIZE">
    <xsl:text> SIZE </xsl:text>
    <xsl:value-of select="sxml:SIZE"/>
   </xsl:if>
   <xsl:if test="sxml:NAME and (sxml:REUSE or $REUSE)">
    <xsl:text> REUSE</xsl:text>
   </xsl:if>
   <xsl:if test="sxml:AUTOEXTEND">
    <xsl:if test="$PRETTY=1">
     <xsl:text>&#xa;   </xsl:text>
    </xsl:if>
    <xsl:text> AUTOEXTEND ON</xsl:text>
    <xsl:if test="sxml:AUTOEXTEND/sxml:NEXT">
     <xsl:text> NEXT </xsl:text>
     <xsl:value-of select="sxml:AUTOEXTEND/sxml:NEXT"/>
    </xsl:if>
    <xsl:if test="sxml:AUTOEXTEND/sxml:MAXSIZE">
     <xsl:text> MAXSIZE </xsl:text>
     <xsl:value-of select="sxml:AUTOEXTEND/sxml:MAXSIZE"/>
    </xsl:if>
   </xsl:if>
   <xsl:if test="position()!=last()">
    <xsl:if test="$PRETTY=1">
     <xsl:text>,</xsl:text>
    </xsl:if>
   </xsl:if>
  </xsl:for-each>
 </xsl:template>
 <xsl:template match="sxml:EXTENT_MANAGEMENT">
  <!-- *******************************************************************
Template: EXTENT_MANAGEMENT
******************************************************************** -->
  <xsl:if test="$PRETTY=1">
   <xsl:text>&#xa; </xsl:text>
  </xsl:if>
  <xsl:text> EXTENT MANAGEMENT </xsl:text>
  <xsl:value-of select="sxml:TYPE"/>
  <xsl:if test="sxml:ALLOCATION_TYPE">
   <xsl:text> </xsl:text>
   <xsl:value-of select="sxml:ALLOCATION_TYPE"/>
  </xsl:if>
  <xsl:if test="sxml:SIZE">
   <xsl:text> SIZE </xsl:text>
   <xsl:value-of select="sxml:SIZE"/>
  </xsl:if>
  <xsl:apply-templates select="../sxml:ENCRYPT"/>
 </xsl:template>
 <xsl:template match="sxml:RETENTION_GUARANTEE">
  <!-- *******************************************************************
Template: RETENTION_GUARANTEE
******************************************************************** -->
  <xsl:text> RETENTION GUARANTEE</xsl:text>
 </xsl:template>
 <xsl:template match="sxml:TABLESPACE_GROUP">
  <!-- *******************************************************************
Template: TABLESPACE_GROUP
******************************************************************** -->
  <xsl:text> TABLESPACE GROUP </xsl:text>
  <xsl:value-of select="."/>
 </xsl:template>
 <xsl:template match="sxml:MINIMUM_EXTENT">
  <!-- *******************************************************************
Template: MINIMUM_EXTENT
******************************************************************** -->
  <xsl:text> MINIMUM EXTENT </xsl:text>
  <xsl:value-of select="."/>
 </xsl:template>
 <xsl:template match="sxml:BLOCKSIZE">
  <!-- *******************************************************************
Template: BLOCKSIZE
******************************************************************** -->
  <xsl:text> PERMANENT BLOCKSIZE </xsl:text>
  <xsl:value-of select="."/>
 </xsl:template>
 <xsl:template match="sxml:FORCE_LOGGING">
  <!-- *******************************************************************
Template: FORCE_LOGGING
******************************************************************** -->
  <xsl:text> FORCE LOGGING </xsl:text>
 </xsl:template>
 <xsl:template match="sxml:DEFAULT">
  <!-- *******************************************************************
Template: DEFAULT
******************************************************************** -->
  <xsl:text> DEFAULT</xsl:text>
  <xsl:call-template name="DoCompressDDL">
   <xsl:with-param name="Compress" select="sxml:COMPRESS"/>
   <xsl:with-param name="CompressLevel" select="sxml:COMPRESS_LEVEL"/>
  </xsl:call-template>
  <xsl:apply-templates select="sxml:STORAGE"/>
 </xsl:template>
 <xsl:template match="sxml:SEGMENT_SPACE_MANAGEMENT">
  <!-- *******************************************************************
Template: SEGMENT_SPACE_MANAGEMENT
******************************************************************** -->
  <xsl:text> SEGMENT SPACE MANAGEMENT </xsl:text>
  <xsl:value-of select="."/>
 </xsl:template>
</xsl:stylesheet>
