<?xml version="1.0" encoding="utf-8"?>
<!--
 Copyright (c) 2007, 2009, Oracle and/or its affiliates. All rights reserved. 
NAME
    kustyped.xsl
DESCRIPTION
    Convert mdapi TYPE_T document (SXML) to creation DDL.

MODIFIED        MM/DD/YY
    sdavidso    11/05/09 - bug 8477142: constraints and ref partitioning
    rapayne     10/30/08 - bug 7506545: fix CONSTRUCTOR function and make
                           parameter and element list optional.
    rapayne     10/09/08 - bug 7438241: Fix RETURN datatype processing. 
                         - quote method name.
    rapayne     10/25/07 - Initial version
 -->
<xsl:stylesheet version="1.0" xmlns:sxml="http://xmlns.oracle.com/ku" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
 <!-- Top level imports -->
 <xsl:import href="kuscomm.xsl"/>
 <xsl:import href="kuscommd.xsl"/>
 <xsl:import href="kustablc.xsl"/>
 <!-- Top-level parameters -->
 <xsl:param name="PRETTY">1</xsl:param>
 <xsl:param name="DoLF">1</xsl:param>
 <xsl:param name="SQLTERMINATOR">1</xsl:param>
 <xsl:param name="SPECIFICATION">1</xsl:param>
 <xsl:param name="BODY">1</xsl:param>
 <xsl:param name="OID">0</xsl:param>
 <!-- Templates -->
 <xsl:template match="sxml:TYPE_SPEC">
  <!-- *******************************************************************
Template: TYPE_SPEC - top-level template for type objects.
******************************************************************** -->
  <xsl:text>  CREATE OR REPLACE TYPE </xsl:text>
  <xsl:call-template name="SchemaName">
   <xsl:with-param name="ParentNode" select="."/>
  </xsl:call-template>
  <xsl:text> </xsl:text>
  <!-- Only generate OID clause if the oid transform param is set and we have an OID node in the sxml doc.
-->
  <xsl:if test="$OID!=0 and ./sxml:OID">
   <xsl:if test="$PRETTY=1">
    <xsl:text>&#xa; </xsl:text>
   </xsl:if>
   <xsl:text> OID '</xsl:text>
   <xsl:value-of select="./sxml:OID"/>
   <xsl:text>' </xsl:text>
  </xsl:if>
  <!-- There are only 3 basic types. Therefore we can dispatch via apply-templates:
   - OBJECT
   - VARRAY
   - NESTED_TABLE
-->
  <xsl:choose>
   <xsl:when test="sxml:VARRAY">
    <xsl:apply-templates select="sxml:VARRAY"/>
   </xsl:when>
   <xsl:when test="sxml:OBJECT">
    <xsl:apply-templates select="sxml:OBJECT"/>
   </xsl:when>
   <xsl:when test="sxml:NESTED_TABLE">
    <xsl:apply-templates select="sxml:NESTED_TABLE"/>
   </xsl:when>
   <xsl:when test="sxml:INCOMPLETE">
   </xsl:when>
  </xsl:choose>
  <xsl:if test="$SQLTERMINATOR=1">
   <xsl:text>
/</xsl:text>
  </xsl:if>
 </xsl:template>
 <xsl:template match="sxml:NESTED_TABLE">
  <!-- *******************************************************************
Template: NESTED_TABLE -
Generate create DDL for NESTED_TABLE  types, e.g.,:
    create type as table of number
******************************************************************** -->
  <xsl:text>AS TABLE OF </xsl:text>
  <xsl:call-template name="Datatype">
   <xsl:with-param name="TypeObj">1</xsl:with-param>
  </xsl:call-template>
 </xsl:template>
 <xsl:template match="sxml:VARRAY">
  <!-- *******************************************************************
Template: VARRAY -
Generate create DDL for varray types, e.g.,:
    create type as varray (100) of number
******************************************************************** -->
  <xsl:text>AS VARYING ARRAY</xsl:text>
  <xsl:text>(</xsl:text>
  <xsl:value-of select="./sxml:LIMIT"/>
  <xsl:text>)</xsl:text>
  <xsl:text> OF </xsl:text>
  <xsl:call-template name="Datatype">
   <xsl:with-param name="TypeObj">1</xsl:with-param>
  </xsl:call-template>
 </xsl:template>
 <xsl:template match="sxml:OBJECT">
  <!-- *******************************************************************
Template: OBJECT - process OBJECT types
Generate create DDL for OBJECT types, e.g.,:
    create type as object(c1 number, c2 varchar2(30));
******************************************************************** -->
  <xsl:if test="./sxml:AUTHID_CURRENT_USER">
   <xsl:if test="$PRETTY=1">
    <xsl:text>&#xa; </xsl:text>
   </xsl:if>
   <xsl:text> AUTHID CURRENT_USER </xsl:text>
  </xsl:if>
  <xsl:choose>
   <xsl:when test="sxml:UNDER">
    <xsl:text>UNDER </xsl:text>
    <xsl:call-template name="SchemaName">
     <xsl:with-param name="ParentNode" select="sxml:UNDER"/>
    </xsl:call-template>
   </xsl:when>
   <xsl:otherwise>AS OBJECT </xsl:otherwise>
  </xsl:choose>
  <xsl:if test="$PRETTY=1">
   <xsl:text>&#xa;</xsl:text>
  </xsl:if>
  <!-- Process optional SQLJ _OBJECT_TYPE clause -->
  <xsl:if test="sxml:SQLJ_OBJECT_TYPE">
   <xsl:call-template name="DoSQLJClause">
    <xsl:with-param name="sqljNode" select="./sxml:SQLJ_OBJECT_TYPE"/>
   </xsl:call-template>
  </xsl:if>
  <xsl:text>   (</xsl:text>
  <xsl:for-each select="./sxml:ATTRIBUTE_LIST/sxml:ATTRIBUTE_LIST_ITEM">
   <xsl:call-template name="DoAttribute">
    <xsl:with-param name="AttrNode" select="."/>
   </xsl:call-template>
  </xsl:for-each>
  <!-- generate METHOD information -->
  <xsl:variable name="NeedComma">
   <xsl:choose>
    <xsl:when test="./sxml:ATTRIBUTE_LIST">1</xsl:when>
    <xsl:otherwise>0</xsl:otherwise>
   </xsl:choose>
  </xsl:variable>
  <xsl:call-template name="DoElementList">
   <xsl:with-param name="ObjectNode" select="."/>
   <xsl:with-param name="ListNode" select="sxml:ELEMENT_LIST"/>
   <xsl:with-param name="NeedComma" select="$NeedComma"/>
  </xsl:call-template>
  <xsl:text>&#xa;</xsl:text>
  <xsl:text>   ) </xsl:text>
  <!-- Take care of the end properties for object types:
      (i.e., NOT FINAL and NOT INSTANTIABLE -->
  <xsl:if test="sxml:NOT_FINAL">NOT FINAL </xsl:if>
  <xsl:if test="sxml:NOT_INSTANTIABLE">NOT INSTANTIABLE </xsl:if>
 </xsl:template>
 <xsl:template name="DoAttribute">
  <xsl:param name="AttrNode" select="''"/>
  <!-- *******************************************************************
Template: DoAttribute - process specific type attribute
Parameters:
     AttrNode  - <ARGUMENT_LIST_ITEM>
******************************************************************** -->
  <xsl:if test="$PRETTY=1 and $DoLF=1">
   <xsl:text>	</xsl:text>
  </xsl:if>
  <xsl:call-template name="QuotedName">
   <xsl:with-param name="NameNode" select="$AttrNode/sxml:NAME"/>
  </xsl:call-template>
  <xsl:text> </xsl:text>
  <xsl:call-template name="Datatype">
   <xsl:with-param name="TypeObj">1</xsl:with-param>
  </xsl:call-template>
  <xsl:if test="$AttrNode/sxml:EXTERNAL_NAME">
   <xsl:text> EXTERNAL NAME '</xsl:text>
   <xsl:value-of select="$AttrNode/sxml:EXTERNAL_NAME"/>
   <xsl:text>'</xsl:text>
  </xsl:if>
  <xsl:if test="not(position()=last())">
   <xsl:text>, </xsl:text>
   <xsl:if test="$PRETTY=1">
    <xsl:text>&#xa;</xsl:text>
   </xsl:if>
  </xsl:if>
 </xsl:template>
 <xsl:template name="DoSQLJClause">
  <xsl:param name="sqljNode" select="''"/>
  <!-- *******************************************************************
Template: DoSQLJClause - process SQLJ_OBJECT_TYPE clause
Parameters:
     sqljNode  - <SQLJ_OBJECT_TYPE>
******************************************************************** -->
  <xsl:if test="$PRETTY=1 and $DoLF=1">
   <xsl:text>	</xsl:text>
  </xsl:if>
  <xsl:text>EXTERNAL NAME </xsl:text>
  <xsl:call-template name="SingleQuotedName">
   <xsl:with-param name="NameNode" select="$sqljNode/sxml:NAME"/>
  </xsl:call-template>
  <xsl:call-template name="EmitLFTab"/>
  <xsl:text>LANGUAGE JAVA </xsl:text>
  <xsl:call-template name="EmitLFTab"/>
  <xsl:text>USING </xsl:text>
  <xsl:if test="$sqljNode/sxml:SQLDATA">SQLData</xsl:if>
  <xsl:if test="$sqljNode/sxml:CUSTOMDATUM">CUSTOMDATUM</xsl:if>
  <xsl:if test="$sqljNode/sxml:ORADATA">ORADATA</xsl:if>
 </xsl:template>
 <xsl:template name="EmitLFTab">
  <!-- *******************************************************************
Template: EmitLFTab
 Emit a linefeed and a tab spacer
Parameters:
******************************************************************** -->
  <xsl:if test="$PRETTY=1">
   <xsl:text>&#xa;	</xsl:text>
  </xsl:if>
 </xsl:template>
 <xsl:template name="DoElementList">
  <xsl:param name="ObjectNode">0</xsl:param>
  <xsl:param name="ListNode">0</xsl:param>
  <xsl:param name="NeedComma">1</xsl:param>
  <!-- *******************************************************************
Template:DoElementList -  process all of the methods that make
     up this type. This is analogous to the xml DoMethodList template.
Parameters:
  ObjectNode - <OBJECT>
  ListNode - <ELEMENT_LIST>
  NeedComma - if null ATTRIBUTE_LIST then we don't need a comma
******************************************************************** -->
  <xsl:for-each select="$ListNode/sxml:ELEMENT_LIST_ITEM">
   <!-- We only are going to process local methods and NOT ones
that have been inherited from a supertype. 
We must retain the characteristic of a subtype.
-->
   <xsl:if test="$NeedComma=1">
    <xsl:text>, </xsl:text>
    <xsl:if test="$PRETTY=1">
     <xsl:text>&#xa;</xsl:text>
    </xsl:if>
    <xsl:if test="$PRETTY=1">
     <xsl:text>	</xsl:text>
    </xsl:if>
   </xsl:if>
   <!-- generate Inheritance clause flags:
      - FINAL
      - NOT INSTANTIABLE
      - OVERRIDING
-->
   <xsl:if test="sxml:FINAL">FINAL </xsl:if>
   <xsl:if test="sxml:OVERRIDING">OVERRIDING </xsl:if>
   <xsl:if test="sxml:NOT_INSTANTIABLE">NOT INSTANTIABLE </xsl:if>
   <xsl:choose>
    <!-- generate method qualifers -->
    <xsl:when test="sxml:MEMBER">
     <xsl:text>MEMBER </xsl:text>
     <xsl:call-template name="DoSubprogram">
      <xsl:with-param name="ProgramParent" select="sxml:MEMBER"/>
     </xsl:call-template>
    </xsl:when>
    <xsl:when test="sxml:STATIC">
     <xsl:text>STATIC </xsl:text>
     <xsl:call-template name="DoSubprogram">
      <xsl:with-param name="ProgramParent" select="sxml:STATIC"/>
     </xsl:call-template>
    </xsl:when>
    <xsl:when test="sxml:MAP_MEMBER">
     <xsl:text>MAP MEMBER </xsl:text>
     <xsl:call-template name="DoSubprogram">
      <xsl:with-param name="ProgramParent" select="sxml:MAP_MEMBER"/>
     </xsl:call-template>
    </xsl:when>
    <xsl:when test="sxml:ORDER_MEMBER">
     <xsl:text>ORDER MEMBER </xsl:text>
     <xsl:call-template name="DoSubprogram">
      <xsl:with-param name="ProgramParent" select="sxml:ORDER_MEMBER"/>
     </xsl:call-template>
    </xsl:when>
    <xsl:when test="sxml:CONSTRUCTOR_FUNCTION">
     <xsl:call-template name="DoConstructor">
      <xsl:with-param name="TypeNode" select="$ObjectNode/.."/>
      <xsl:with-param name="ElementNode" select="./sxml:CONSTRUCTOR_FUNCTION"/>
     </xsl:call-template>
    </xsl:when>
   </xsl:choose>
  </xsl:for-each>
 </xsl:template>
 <xsl:template name="DoSubprogram">
  <xsl:param name="ProgramParent" select="''"/>
  <!-- *******************************************************************
Template:DoSubprogram -  process current method, FUNCTION or PROCEDURE
     
Parameters:
  ProgramParent- e.g., <MEMBER  || STATIC || MAP_MEMBER || ORDER_MEMBER>
                                         FUNCTION> || <PROCEDURE> 
******************************************************************** -->
  <xsl:choose>
   <xsl:when test="$ProgramParent/sxml:FUNCTION">
    <xsl:call-template name="DoElement">
     <xsl:with-param name="ElementType">FUNCTION</xsl:with-param>
     <xsl:with-param name="ElementNode" select="$ProgramParent/sxml:FUNCTION"/>
    </xsl:call-template>
    <!-- Call out to process RETURN clause -->
    <xsl:call-template name="DoReturn">
     <xsl:with-param name="ReturnNode" select="$ProgramParent/sxml:FUNCTION/sxml:RETURN"/>
    </xsl:call-template>
   </xsl:when>
   <xsl:otherwise>
    <xsl:call-template name="DoElement">
     <xsl:with-param name="ElementType">PROCEDURE</xsl:with-param>
     <xsl:with-param name="ElementNode" select="$ProgramParent/sxml:PROCEDURE"/>
    </xsl:call-template>
   </xsl:otherwise>
  </xsl:choose>
 </xsl:template>
 <xsl:template name="DoConstructor">
  <xsl:param name="TypeNode" select="''"/>
  <xsl:param name="ElementNode" select="''"/>
  <!-- *******************************************************************
Template:DoConstructor-  Process CONSTRUCTOR_FUNCTION.
Parameters:
  TypeNode   - <OBJECT> - the constructor name will be the same as the object
  ElementNode- <CONSTRUCTOR_FUNCTION>
******************************************************************** -->
  <xsl:text>CONSTRUCTOR FUNCTION </xsl:text>
  <xsl:call-template name="QuotedName">
   <xsl:with-param name="NameNode" select="$TypeNode/sxml:NAME"/>
  </xsl:call-template>
  <xsl:if test="$ElementNode/sxml:RETURN_SELF">
   <xsl:text> RETURN SELF AS RESULT</xsl:text>
  </xsl:if>
 </xsl:template>
 <xsl:template name="DoElement">
  <xsl:param name="ElementType" select="''"/>
  <xsl:param name="ElementNode" select="''"/>
  <!-- *******************************************************************
Template:DoElement-  Process PARAMETER_LIST for current PROCEDURE or FUNCTION.
Parameters:
  ElementType  - 'FUNCTION' || 'PROCEDURE'
  ElementNode - <FUNCTION> || <PROCEDURE>
******************************************************************** -->
  <xsl:value-of select="$ElementType"/>
  <xsl:text> </xsl:text>
  <xsl:call-template name="QuotedName">
   <xsl:with-param name="NameNode" select="$ElementNode/sxml:NAME"/>
  </xsl:call-template>
  <xsl:text> </xsl:text>
  <!-- Parse all of the arguments for current function if present-->
  <xsl:if test="$ElementNode/sxml:PARAMETER_LIST/sxml:PARAMETER_LIST_ITEM">
   <xsl:text> (</xsl:text>
   <xsl:for-each select="$ElementNode/sxml:PARAMETER_LIST/sxml:PARAMETER_LIST_ITEM">
    <xsl:call-template name="QuotedName">
     <xsl:with-param name="NameNode" select="./sxml:NAME"/>
    </xsl:call-template>
    <xsl:text> </xsl:text>
    <xsl:if test="sxml:OUT">OUT </xsl:if>
    <xsl:if test="sxml:IN_OUT">IN OUT </xsl:if>
    <xsl:if test="sxml:NO_COPY">NOCOPY </xsl:if>
    <xsl:call-template name="Datatype">
     <xsl:with-param name="TypeObj">1</xsl:with-param>
    </xsl:call-template>
    <!-- if its NOT the last argument then display a command and crlf before
             processing the next argument
-->
    <xsl:choose>
     <xsl:when test="position()=last()">
      <xsl:text>) </xsl:text>
     </xsl:when>
     <xsl:otherwise>
      <xsl:text>, </xsl:text>
      <xsl:if test="$PRETTY=1 and $DoLF=1">
       <xsl:text>&#xa;</xsl:text>
      </xsl:if>
      <!-- TAB space the next procedure arg -->
      <xsl:if test="$PRETTY=1">
       <xsl:text>	</xsl:text>
      </xsl:if>
     </xsl:otherwise>
    </xsl:choose>
   </xsl:for-each>
  </xsl:if>
 </xsl:template>
 <xsl:template name="DoReturn">
  <xsl:param name="ReturnNode" select="''"/>
  <!-- *******************************************************************
Template:DoReturn -  process the current RETURN_CLAUSE
Parameters:
  ReturnNode - <RETURN>
******************************************************************** -->
  <xsl:text>RETURN </xsl:text>
  <xsl:choose>
   <xsl:when test="$ReturnNode/sxml:TYPE_PROPERTIES">
    <xsl:call-template name="SchemaName">
     <xsl:with-param name="ParentNode" select="$ReturnNode/sxml:TYPE_PROPERTIES"/>
    </xsl:call-template>
   </xsl:when>
   <xsl:otherwise>
    <xsl:value-of select="$ReturnNode/sxml:DATATYPE" disable-output-escaping="yes"/>
   </xsl:otherwise>
  </xsl:choose>
 </xsl:template>
 <xsl:template match="sxml:TYPE_BODY">
  <!-- *******************************************************************
Template: TYPE_BODY- top-level template for type body objects.
******************************************************************** -->
  <xsl:if test="$PRETTY=1">
   <xsl:text>&#xa;  </xsl:text>
  </xsl:if>
  <xsl:text>CREATE OR REPLACE TYPE BODY </xsl:text>
  <xsl:call-template name="SchemaName">
   <xsl:with-param name="ParentNode" select="."/>
  </xsl:call-template>
  <xsl:value-of select="sxml:PLSQL_BLOCK"/>
 </xsl:template>
</xsl:stylesheet>
