<?xml version="1.0"?>
<!--
NAME
    kususerd.xsl
DESCRIPTION
    Convert USER document (SXML) to creation DDL.

MODIFIED        MM/DD/YY
    sdavidso   11/02/05 - fix inconsistent stylesheet format 
    lbarton    08/10/05 - lbarton_mddiff
    lbarton    07/11/05 - 
    htseng     03/16/05 - Initial version
 -->
<xsl:stylesheet version="1.0" xmlns:sxml="http://xmlns.oracle.com/ku" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
 <!-- Top level imports -->
 <xsl:import href="kuscommd.xsl"/>
 <xsl:import href="kusindxd.xsl"/>
 <!-- Top-level parameters -->
 <!-- Parameters for DDL generation -->
 <xsl:param name="PRETTY">1</xsl:param>
 <xsl:param name="SQLTERMINATOR">0</xsl:param>
 <!-- *******************************************************************
Template: USER - top-level template for tables.
  This template puts out
   - CREATE USER name
  then calls one of
   - CreObjTable - for object tables and XMLType tables
   - CreRelTable - for relational tables
******************************************************************** -->
 <xsl:template match="sxml:USER">
  <xsl:choose>
   <xsl:when test="sxml:NAME='SYS' or sxml:NAME='SYSTEM'">
    <xsl:text> ALTER USER </xsl:text>
   </xsl:when>
   <xsl:otherwise>
    <xsl:text> CREATE USER </xsl:text>
   </xsl:otherwise>
  </xsl:choose>
  <xsl:text>"</xsl:text>
  <xsl:value-of select="sxml:NAME"/>
  <xsl:text>" </xsl:text>
  <xsl:choose>
   <xsl:when test="sxml:TYPE='GLOBAL'">
    <xsl:text> IDENTIFIED GLOBALLY AS '</xsl:text>
    <xsl:value-of select="sxml:EXTERNAL_NAME"/>
    <xsl:text>'</xsl:text>
   </xsl:when>
   <xsl:when test="sxml:TYPE='EXTERNAL'">
    <xsl:text> IDENTIFIED EXTERNALLY </xsl:text>
   </xsl:when>
   <xsl:when test="sxml:TYPE='LOCAL' and sxml:VALUE">
    <xsl:text> IDENTIFIED BY VALUES '</xsl:text>
    <xsl:value-of select="sxml:VALUE"/>
    <xsl:text>'</xsl:text>
   </xsl:when>
   <xsl:when test="sxml:TYPE='LOCAL' and sxml:PASSWORD">
    <xsl:text>IDENTIFIED BY </xsl:text>
    <xsl:value-of select="sxml:PASSWORD"/>
   </xsl:when>
  </xsl:choose>
  <xsl:if test="sxml:DEFAULT_TABLESPACE">
   <xsl:if test="$PRETTY=1">
    <xsl:text>&#xa;   </xsl:text>
   </xsl:if>
   <xsl:text> DEFAULT TABLESPACE "</xsl:text>
   <xsl:value-of select="sxml:DEFAULT_TABLESPACE"/>
   <xsl:text>"</xsl:text>
  </xsl:if>
  <xsl:if test="sxml:TEMPORARY_TABLESPACE">
   <xsl:if test="$PRETTY=1">
    <xsl:text>&#xa;   </xsl:text>
   </xsl:if>
   <xsl:text> TEMPORARY TABLESPACE "</xsl:text>
   <xsl:value-of select="sxml:TEMPORARY_TABLESPACE"/>
   <xsl:text>"</xsl:text>
  </xsl:if>
  <xsl:if test="sxml:PROFILE">
   <xsl:if test="$PRETTY=1">
    <xsl:text>&#xa;   </xsl:text>
   </xsl:if>
   <xsl:text> PROFILE "</xsl:text>
   <xsl:value-of select="sxml:PROFILE"/>
   <xsl:text>"</xsl:text>
  </xsl:if>
  <xsl:if test="sxml:PASSWORD_EXPIRE">
   <xsl:if test="$PRETTY=1">
    <xsl:text>&#xa;   </xsl:text>
   </xsl:if>
   <xsl:text> PASSWORD EXPIRE </xsl:text>
  </xsl:if>
  <xsl:if test="sxml:ACCOUNT_LOCK='Y'">
   <xsl:if test="$PRETTY=1">
    <xsl:text>&#xa;   </xsl:text>
   </xsl:if>
   <xsl:text> ACCOUNT LOCK</xsl:text>
  </xsl:if>
  <xsl:if test="$SQLTERMINATOR=1">
   <xsl:text>;</xsl:text>
   <!-- Terminate the SQL statement -->
  </xsl:if>
 </xsl:template>
</xsl:stylesheet>
