<?xml version="1.0"?>
<!--
 Copyright (c) 2000, 2009, Oracle and/or its affiliates. All rights reserved. 
 
NAME
    kutabcon.xsl
DESCRIPTION
    XSLT stylesheet for XML => DDL conversion of table constraints
    (broken out of kutable.xsl for code hygiene)
NOTES
    Do NOT modify this file under any circumstance. Copy the file
    if you wish to use this stylesheet with an external XML/XSL parser

MODIFIED        MM/DD/YY
    tbhukya     11/24/09 - Bug 8822995: Generated OID for classic export also 
                           for xml schema tables with REF SCOPE columns.
    sdavidso    10/23/09 - bug 8477142 more care with refpar constraints
    mjangir     02/07/08 - Bug 6676049: filter xmltype columns with rowid 
    sdavidso    01/15/08 - no FK constraint for nested table
    sdavidso    08/01/06 - include refpar constraints
    emagrath    02/22/06 - Add SYSTEM_DEFINED clause for Import sOID SCOPE
    lbarton     01/20/06 - partition transportable 
 -->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
 <!-- Top level imports -->
 <xsl:import href="kucommon.xsl"/>
 <xsl:import href="kuconstr.xsl"/>
 <!-- Top level parameters -->
 <xsl:param name="OLDEXPORT">0</xsl:param>
 <!-- Templates -->
 <xsl:template name="GenTableConstraints">
  <xsl:param name="SchemaObjParent" select="''"/>
  <xsl:param name="ListParent" select="''"/>
  <xsl:param name="InColList">0</xsl:param>
  <xsl:param name="CommaNeeded">0</xsl:param>
  <xsl:param name="Property">0</xsl:param>
  <xsl:param name="Nested">0</xsl:param>
  <!-- *******************************************************************
Template: GenTableConstraints -  Generate Table Constraints 
Parameters:
  SchemaObjParent - parent of SCHEMA_OBJ node
  ListParent - parent node of constraint list (e.g., CON1_LIST, CON2_LIST)
  InColList - 1 = generating constraints after column list in CREATE TABLE
              0 = adding constraint in ALTER TABLE
  CommaNeeded - 1 = comma needed before first constraint
                    (e.g., when columns have been emitted and we must
                     emit a comma before putting out the constraints
  Property - value of table PROPERTY
  Nested - 1 = generating DDL for a nested table
Global Parameters:
  CONSTRAINTS - 1 = emit constraints
  REF_CONSTRAINTS - 1 = emit referential constraints
  CONSTRAINTS_AS_ALTER - 1 = emit constraints as ALTER TABLE statements
  EXPORT - 1 = generate export-specific DDL
  SQLTERMINATOR - 1 = emit SQL terminator (;) after statement
  PRETTY - 1 = pretty-print output
Notes:
   A hierarchy of templates is invoked - each template decides when
     and how each 'class' of constraint can be generated.
     MUST keep the hierarchy of conditions in synch with template
     TablePropertyParen!!!

     Constraint types handled:
      1 - Table Check                 - General   - named, no Key cols, expr
                                                    (deferred Not NULL also)
      2 - Primary Key                 - Idx cols  - named, Key cols
      3 - Unique Key                  - Idx cols  - named, Key cols
      4 - Referential (Foreign Key)   - Col match - named, Key cols (2 sets)
      5 - View WITH CHECK OPTION      - View ctrl - named, clause in query
      6 - View WITH READ ONLY         - View ctrl - unnamed, clause in query
      7 - Column Not Null             - Col value - named, no Key cols
      8 - Cluster hash expression     - Hash expr - unnamed, ignored
      9 - Scoped REF                  - REF match - unnamed, in REFCON, ignored
     10 - REF with ROWID              - REF value - unnamed, in REFCON, ignored
     11 - REF/Attribute Not Null      - Col value - named, no Key cols
     12 - Log groups supp. logging    - Log ctrl  - named, Key cols, col attr.
     13 - Allow PKref vals in REF col - REF value - unnamed, in REFCON, ignored
     14 - Primary Key supp. logging   - Log ctrl  - unnamed, implied Key cols
     15 - Unique Key supp. logging    - Log ctrl  - unnamed, implied Key cols
     16 - Foreign Key supp. logging   - Log ctrl  - unnamed, implied Key cols
     17 - ALL column supp. logging    - Log ctrl  - unnamed, implied Key cols

  The following classes of constraints are generated in the following order
   according to these rules:
   [key:  CON (CONSTRAINTS), EXP (EXPORT), REF_CON (REF_CONSTRAINTS)]
     Class                          rule
     ============================   ==========================================
     Object tbl col/attr NOT NULL - if CON / EXP, in CREATE          (COL/CON0)
     Primary keys for Iots/PkOIDs - always,       in CREATE          (CON1)
     REFs, PkREFs                 - always,       in CREATE or ALTER (PKREF)
                                                  ALTER only for Nested Tables
     Non keyed, excluding NOT NULL- if CON,       in CREATE or ALTER (CON0) 
     Other Primary keys           - if CON,       in CREATE or ALTER (CON1)
     Unique keys/Table Check      - if CON,       in CREATE or ALTER (CON1)
     Supplemental Log Groups/Data - if CON,       in CREATE or ALTER (CON1)
     Referential                  - if REF_CON,   in CREATE or ALTER (CON2)
                                                  ALTER only for Nested Tables
******************************************************************** -->
  <!--
       NOT NULL constraints for object tables.
       (Relational Table NOT NULLs are generated as part of Column defs,
        see kucolumn.xsl)
       (bit 0x0001 (01) of tab$.property = object table
        bit 0x0020 (32) of col$.property = hidden column)

       If Non-referential constraints or Export behavior -
       Outer tbl: always in CREATE (could be in ALTER TABLE).
       Nestd tbl: only in CREATE.
       Note: The Schema Object Parent node has the COL_LIST
-->
  <xsl:if test="($Property mod 2)=1 and (($CONSTRAINTS=1 or ($SchemaObjParent/PART_OBJ/PARTOBJ/FLAGS mod 64) >=32) or $EXPORT=1) and
                $InColList=1">
   <xsl:for-each select="$SchemaObjParent/COL_LIST/COL_LIST_ITEM[(PROPERTY mod 64)&lt;32]//CON">
    <xsl:call-template name="DoCON_LIST_ITEM">
     <xsl:with-param name="SchemaObjParent" select="$SchemaObjParent"/>
     <xsl:with-param name="InColList">1</xsl:with-param>
     <xsl:with-param name="CommaNeeded" select="$CommaNeeded"/>
     <xsl:with-param name="Property" select="$Property"/>
     <xsl:with-param name="Position" select="position()"/>
    </xsl:call-template>
   </xsl:for-each>
  </xsl:if>
  <xsl:choose>
   <!-- comma needed test for any next constraints -->
   <xsl:when test="($Property mod 2)=1 and (($CONSTRAINTS=1 or ($SchemaObjParent/PART_OBJ/PARTOBJ/FLAGS mod 64) >=32) or $EXPORT=1) and
                   $InColList=1 and
        $SchemaObjParent/COL_LIST/COL_LIST_ITEM[(PROPERTY mod 64)&lt;32]/CON">
    <xsl:call-template name="GenCON1s_Pass1">
     <xsl:with-param name="SchemaObjParent" select="$SchemaObjParent"/>
     <xsl:with-param name="ListParent" select="$ListParent"/>
     <xsl:with-param name="InColList">1</xsl:with-param>
     <xsl:with-param name="CommaNeeded">1</xsl:with-param>
     <xsl:with-param name="Property" select="$Property"/>
     <xsl:with-param name="Nested" select="$Nested"/>
    </xsl:call-template>
   </xsl:when>
   <xsl:otherwise>
    <xsl:call-template name="GenCON1s_Pass1">
     <xsl:with-param name="SchemaObjParent" select="$SchemaObjParent"/>
     <xsl:with-param name="ListParent" select="$ListParent"/>
     <xsl:with-param name="InColList" select="$InColList"/>
     <xsl:with-param name="CommaNeeded" select="$CommaNeeded"/>
     <xsl:with-param name="Property" select="$Property"/>
     <xsl:with-param name="Nested" select="$Nested"/>
    </xsl:call-template>
   </xsl:otherwise>
  </xsl:choose>
 </xsl:template>
 <xsl:template name="GenCON1s_Pass1">
  <xsl:param name="SchemaObjParent" select="''"/>
  <xsl:param name="ListParent" select="''"/>
  <xsl:param name="InColList">0</xsl:param>
  <xsl:param name="CommaNeeded">0</xsl:param>
  <xsl:param name="Property">0</xsl:param>
  <xsl:param name="Nested">0</xsl:param>
  <!-- *******************************************************************
Template: GenCON1s_Pass1 - PRIMARY KEY for IOTs/pkOIDs (CON1_LIST)
Parameters:
  SchemaObjParent - parent of SCHEMA_OBJ node
  ListParent - parent node of constraint list (e.g., CON1_LIST, CON2_LIST)
  InColList - 1 = generating constraints after column list in CREATE TABLE
              0 = adding constraint in ALTER TABLE
  CommaNeeded - 1 = comma needed before first constraint
                    (e.g., when columns have been emitted and we must
                     emit a comma before putting out the constraints
  Property - value of table PROPERTY
  Nested - 1 = generating DDL for a nested table
******************************************************************** -->
  <!-- For all IOTs or PkOIDs.
       All tbl: in CREATE.
       tab$.property bit 0x0040 (64) - IOT
                     bit 0x1000 (4096) - has pkoid column
       contype 2 = primary key
    -->
  <xsl:if test="$InColList=1 and
                (($Property mod 128)>=64 or ($Property mod 8192)>=4096)">
   <xsl:for-each select="$ListParent/CON1_LIST/CON1_LIST_ITEM[CONTYPE='2']">
    <xsl:call-template name="DoCON_LIST_ITEM">
     <xsl:with-param name="SchemaObjParent" select="$SchemaObjParent"/>
     <xsl:with-param name="InColList">1</xsl:with-param>
     <xsl:with-param name="CommaNeeded" select="$CommaNeeded"/>
     <xsl:with-param name="Property" select="$Property"/>
     <xsl:with-param name="Position" select="position()"/>
    </xsl:call-template>
   </xsl:for-each>
  </xsl:if>
  <xsl:choose>
   <!-- comma needed test for any next constraints -->
   <xsl:when test="$InColList=1 and
                   (($Property mod 128)>=64 or ($Property mod 8192)>=4096) and
                   $ListParent/CON1_LIST/CON1_LIST_ITEM[CONTYPE='2']">
    <xsl:call-template name="GenPKREFs">
     <xsl:with-param name="SchemaObjParent" select="$SchemaObjParent"/>
     <xsl:with-param name="ListParent" select="$ListParent"/>
     <xsl:with-param name="InColList">1</xsl:with-param>
     <xsl:with-param name="CommaNeeded">1</xsl:with-param>
     <xsl:with-param name="Property" select="$Property"/>
     <xsl:with-param name="Nested" select="$Nested"/>
    </xsl:call-template>
   </xsl:when>
   <xsl:otherwise>
    <xsl:call-template name="GenPKREFs">
     <xsl:with-param name="SchemaObjParent" select="$SchemaObjParent"/>
     <xsl:with-param name="ListParent" select="$ListParent"/>
     <xsl:with-param name="InColList" select="$InColList"/>
     <xsl:with-param name="CommaNeeded" select="$CommaNeeded"/>
     <xsl:with-param name="Property" select="$Property"/>
     <xsl:with-param name="Nested" select="$Nested"/>
    </xsl:call-template>
   </xsl:otherwise>
  </xsl:choose>
 </xsl:template>
 <xsl:template name="GenPKREFs">
  <xsl:param name="SchemaObjParent" select="''"/>
  <xsl:param name="ListParent" select="''"/>
  <xsl:param name="InColList">0</xsl:param>
  <xsl:param name="CommaNeeded">0</xsl:param>
  <xsl:param name="Property">0</xsl:param>
  <xsl:param name="Nested">0</xsl:param>
  <!-- *******************************************************************
Template: GenPKREFs -  REFs and PKREFs (PKREF_LIST)
Parameters:
  SchemaObjParent - parent of SCHEMA_OBJ node
  ListParent - parent node of constraint list (e.g., CON1_LIST, CON2_LIST)
  InColList - 1 = generating constraints after column list in CREATE TABLE
              0 = adding constraint in ALTER TABLE
  CommaNeeded - 1 = comma needed before first constraint
                    (e.g., when columns have been emitted and we must
                     emit a comma before putting out the constraints
  Property - value of table PROPERTY
  Nested - 1 = generating DDL for a nested table
******************************************************************** -->
  <!-- Always generated.
       Outer tbl: in CREATE or ALTER TABLE.
       Nestd tbl: only in ALTER TABLE (Due to Scoped REFs).
       Only non 0 type, excluding SCOPEd REF in CREATE if also a Foreign Key
        and dumping Referential constraints
    -->
  <xsl:if test="($Nested=0 and $InColList!=$CONSTRAINTS_AS_ALTER) or
                ($Nested=1 and $InColList=0)">
   <xsl:for-each select="$ListParent/PKREF_LIST/PKREF_LIST_ITEM[
                           (REFTYP mod 16)>0 and
                           not ((REFTYP mod 2)=1 and ($REF_CONSTRAINTS=1 or $SchemaObjParent/REFPAR_LEVEL>0) and
                           $InColList=1 and FOREIGNKEY=1) and
                           not ((REFTYP mod 32)>16 and (PROPERTY mod 64)>=32)]">
    <xsl:sort select="INTCOL_NUM" data-type="number"/>
    <xsl:call-template name="DoPKREF_LIST_ITEM">
     <xsl:with-param name="SchemaObjParent" select="$SchemaObjParent"/>
     <xsl:with-param name="ListParent" select="$ListParent"/>
     <xsl:with-param name="InColList" select="$InColList"/>
     <xsl:with-param name="CommaNeeded" select="$CommaNeeded"/>
     <xsl:with-param name="Position" select="position()"/>
    </xsl:call-template>
   </xsl:for-each>
  </xsl:if>
  <xsl:choose>
   <!-- comma needed test for any next constraints -->
   <xsl:when test="($Nested=0 and $InColList=1 and $CONSTRAINTS_AS_ALTER=0) and
                   $ListParent/PKREF_LIST/PKREF_LIST_ITEM[(REFTYP mod 16)>0 and
                    not ((REFTYP mod 32) > 16 and (PROPERTY mod 64)>=32 ) and
                          not ((REFTYP mod 2)=1 and ($REF_CONSTRAINTS=1 or $SchemaObjParent/REFPAR_LEVEL>0) and
                               $InColList=1 and FOREIGNKEY=1)]">
    <xsl:call-template name="GenCON0s">
     <xsl:with-param name="SchemaObjParent" select="$SchemaObjParent"/>
     <xsl:with-param name="ListParent" select="$ListParent"/>
     <xsl:with-param name="InColList">1</xsl:with-param>
     <xsl:with-param name="CommaNeeded">1</xsl:with-param>
     <xsl:with-param name="Property" select="$Property"/>
     <xsl:with-param name="Nested" select="$Nested"/>
    </xsl:call-template>
   </xsl:when>
   <xsl:otherwise>
    <xsl:call-template name="GenCON0s">
     <xsl:with-param name="SchemaObjParent" select="$SchemaObjParent"/>
     <xsl:with-param name="ListParent" select="$ListParent"/>
     <xsl:with-param name="InColList" select="$InColList"/>
     <xsl:with-param name="CommaNeeded" select="$CommaNeeded"/>
     <xsl:with-param name="Property" select="$Property"/>
     <xsl:with-param name="Nested" select="$Nested"/>
    </xsl:call-template>
   </xsl:otherwise>
  </xsl:choose>
 </xsl:template>
 <xsl:template name="GenCON0s">
  <xsl:param name="SchemaObjParent" select="''"/>
  <xsl:param name="ListParent" select="''"/>
  <xsl:param name="InColList">0</xsl:param>
  <xsl:param name="CommaNeeded">0</xsl:param>
  <xsl:param name="Property">0</xsl:param>
  <xsl:param name="Nested">0</xsl:param>
  <!-- *******************************************************************
Template: GenCON0s - 'Non key' constraints (CON0_LIST) 
Parameters:
  SchemaObjParent - parent of SCHEMA_OBJ node
  ListParent - parent node of constraint list (e.g., CON1_LIST, CON2_LIST)
  InColList - 1 = generating constraints after column list in CREATE TABLE
              0 = adding constraint in ALTER TABLE
  CommaNeeded - 1 = comma needed before first constraint
                    (e.g., when columns have been emitted and we must
                     emit a comma before putting out the constraints
  Property - value of table PROPERTY
  Nested - 1 = generating DDL for a nested table
******************************************************************** -->
  <!-- Only if Non referential constraints.
       All tbl: in CREATE or ALTER TABLE.
       (NOT NULLs have already been excluded, so presently none for tables)
    -->
  <xsl:if test="($CONSTRAINTS=1 or ($SchemaObjParent/PART_OBJ/PARTOBJ/FLAGS mod 64) >=32) and $InColList!=$CONSTRAINTS_AS_ALTER">
   <xsl:for-each select="$ListParent/CON0_LIST/CON0_LIST_ITEM">
    <xsl:sort select="CON_NUM" data-type="number"/>
    <xsl:call-template name="DoCON_LIST_ITEM">
     <xsl:with-param name="SchemaObjParent" select="$SchemaObjParent"/>
     <xsl:with-param name="InColList" select="$InColList"/>
     <xsl:with-param name="CommaNeeded" select="$CommaNeeded"/>
     <xsl:with-param name="Property" select="$Property"/>
     <xsl:with-param name="Position" select="position()"/>
    </xsl:call-template>
   </xsl:for-each>
  </xsl:if>
  <xsl:choose>
   <!-- comma needed test for any next constraints -->
   <xsl:when test="($CONSTRAINTS=1 or ($SchemaObjParent/PART_OBJ/PARTOBJ/FLAGS mod 64) >=32) and $InColList=1 and
                   $CONSTRAINTS_AS_ALTER=0 and
                   $ListParent/CON0_LIST/CON0_LIST_ITEM">
    <xsl:call-template name="GenCON1s_Pass2">
     <xsl:with-param name="SchemaObjParent" select="$SchemaObjParent"/>
     <xsl:with-param name="ListParent" select="$ListParent"/>
     <xsl:with-param name="InColList">1</xsl:with-param>
     <xsl:with-param name="CommaNeeded">1</xsl:with-param>
     <xsl:with-param name="Property" select="$Property"/>
     <xsl:with-param name="Nested" select="$Nested"/>
    </xsl:call-template>
   </xsl:when>
   <xsl:otherwise>
    <xsl:call-template name="GenCON1s_Pass2">
     <xsl:with-param name="SchemaObjParent" select="$SchemaObjParent"/>
     <xsl:with-param name="ListParent" select="$ListParent"/>
     <xsl:with-param name="InColList" select="$InColList"/>
     <xsl:with-param name="CommaNeeded" select="$CommaNeeded"/>
     <xsl:with-param name="Property" select="$Property"/>
     <xsl:with-param name="Nested" select="$Nested"/>
    </xsl:call-template>
   </xsl:otherwise>
  </xsl:choose>
 </xsl:template>
 <xsl:template name="GenCON1s_Pass2">
  <xsl:param name="SchemaObjParent" select="''"/>
  <xsl:param name="ListParent" select="''"/>
  <xsl:param name="InColList">0</xsl:param>
  <xsl:param name="CommaNeeded">0</xsl:param>
  <xsl:param name="Property">0</xsl:param>
  <xsl:param name="Nested">0</xsl:param>
  <!-- *******************************************************************
Template: GenCON1s_Pass2 
- Table check, Unique, Primary Key for non IOT/PkOID (CON1_LIST)
Parameters:
  SchemaObjParent - parent of SCHEMA_OBJ node
  ListParent - parent node of constraint list (e.g., CON1_LIST, CON2_LIST)
  InColList - 1 = generating constraints after column list in CREATE TABLE
              0 = adding constraint in ALTER TABLE
  CommaNeeded - 1 = comma needed before first constraint
                    (e.g., when columns have been emitted and we must
                     emit a comma before putting out the constraints
  Property - value of table PROPERTY
  Nested - 1 = generating DDL for a nested table
******************************************************************** -->
  <xsl:choose>
   <xsl:when test="$CONSTRAINTS=1  and $InColList!=$CONSTRAINTS_AS_ALTER">
    <!--if constraints are to be included-->
    <!-- and we are in the proper context for constraints (either in column list, or as alter statements)-->
    <xsl:for-each select="$ListParent/CON1_LIST/CON1_LIST_ITEM[
                        COL_LIST/COL_LIST_ITEM/OID_OR_SETID=0 and
                        not ((CONTYPE='2' and
                                (($Property mod 128)>=64 or
                                 ($Property mod 8192)>=4096)) or
                              CONTYPE='12' or CONTYPE='14' or CONTYPE='15' or
                              CONTYPE='16' or CONTYPE='17')]">
     <!-- Only Non (OID or SETID) UNIQUE constraints -->
     <xsl:sort select="CON_NUM" data-type="number"/>
     <xsl:call-template name="DoCON_LIST_ITEM">
      <xsl:with-param name="SchemaObjParent" select="$SchemaObjParent"/>
      <xsl:with-param name="InColList" select="$InColList"/>
      <xsl:with-param name="CommaNeeded" select="$CommaNeeded"/>
      <xsl:with-param name="Property" select="$Property"/>
      <xsl:with-param name="Position" select="position()"/>
     </xsl:call-template>
    </xsl:for-each>
   </xsl:when>
   <xsl:when test="$CONSTRAINTS=0  and (($SchemaObjParent/PART_OBJ/PARTOBJ/FLAGS mod 64) >=32) and $InColList=1">
    <!--if constraints are excluded above, we force inclusion of primary/unique constraints-->
    <!-- needed for reference partitioning parent tables, as constraints in the column list.-->
    <!--Note that we must eclude equipartitioned nested tables, as those are implicitly created!-->
    <xsl:for-each select="$ListParent/CON1_LIST/CON1_LIST_ITEM[COL_LIST/COL_LIST_ITEM/OID_OR_SETID=0 and 
                                                                   ((FLAGS mod 2048) &gt;= 1024)]">
     <xsl:sort select="CON_NUM" data-type="number"/>
     <xsl:call-template name="DoCON_LIST_ITEM">
      <xsl:with-param name="SchemaObjParent" select="$SchemaObjParent"/>
      <xsl:with-param name="InColList" select="$InColList"/>
      <xsl:with-param name="CommaNeeded" select="$CommaNeeded"/>
      <xsl:with-param name="Property" select="$Property"/>
      <xsl:with-param name="Position" select="position()"/>
     </xsl:call-template>
    </xsl:for-each>
   </xsl:when>
  </xsl:choose>
  <xsl:choose>
   <!-- comma needed test for any next constraints -->
   <xsl:when test="($CONSTRAINTS=1 or ($SchemaObjParent/PART_OBJ/PARTOBJ/FLAGS mod 64) >=32) and $InColList=1 and
                   $CONSTRAINTS_AS_ALTER=0 and
                   $ListParent/CON1_LIST/CON1_LIST_ITEM[
                       COL_LIST/COL_LIST_ITEM/OID_OR_SETID=0 and
                        not ((CONTYPE='2' and
                              (($Property mod 128)>=64 or
                               ($Property mod 8192)>=4096)) or
                             CONTYPE='12' or CONTYPE='14' or CONTYPE='15' or
                             CONTYPE='16' or CONTYPE='17')]">
    <xsl:call-template name="GenCON1s_Pass3">
     <xsl:with-param name="SchemaObjParent" select="$SchemaObjParent"/>
     <xsl:with-param name="ListParent" select="$ListParent"/>
     <xsl:with-param name="InColList">1</xsl:with-param>
     <xsl:with-param name="CommaNeeded">1</xsl:with-param>
     <xsl:with-param name="Property" select="$Property"/>
     <xsl:with-param name="Nested" select="$Nested"/>
    </xsl:call-template>
   </xsl:when>
   <xsl:otherwise>
    <xsl:call-template name="GenCON1s_Pass3">
     <xsl:with-param name="SchemaObjParent" select="$SchemaObjParent"/>
     <xsl:with-param name="ListParent" select="$ListParent"/>
     <xsl:with-param name="InColList" select="$InColList"/>
     <xsl:with-param name="CommaNeeded" select="$CommaNeeded"/>
     <xsl:with-param name="Property" select="$Property"/>
     <xsl:with-param name="Nested" select="$Nested"/>
    </xsl:call-template>
   </xsl:otherwise>
  </xsl:choose>
 </xsl:template>
 <xsl:template name="GenCON1s_Pass3">
  <xsl:param name="SchemaObjParent" select="''"/>
  <xsl:param name="ListParent" select="''"/>
  <xsl:param name="InColList">0</xsl:param>
  <xsl:param name="CommaNeeded">0</xsl:param>
  <xsl:param name="Property">0</xsl:param>
  <xsl:param name="Nested">0</xsl:param>
  <!-- *******************************************************************
Template: GenCON1s_Pass3 - Supplemental Log Groups/Log Data (CON1_LIST)
Parameters:
  SchemaObjParent - parent of SCHEMA_OBJ node
  ListParent - parent node of constraint list (e.g., CON1_LIST, CON2_LIST)
  InColList - 1 = generating constraints after column list in CREATE TABLE
              0 = adding constraint in ALTER TABLE
  CommaNeeded - 1 = comma needed before first constraint
                    (e.g., when columns have been emitted and we must
                     emit a comma before putting out the constraints
  Property - value of table PROPERTY
  Nested - 1 = generating DDL for a nested table
******************************************************************** -->
  <!-- Separate for planned own object-type, transform parameter -->
  <!-- Only if Non referential constraints.
       All tbl: in CREATE or ALTER TABLE.
    -->
  <xsl:if test="($CONSTRAINTS=1 or ($SchemaObjParent/PART_OBJ/PARTOBJ/FLAGS mod 64) >=32) and $InColList!=$CONSTRAINTS_AS_ALTER">
   <xsl:for-each select="$ListParent/CON1_LIST/CON1_LIST_ITEM[CONTYPE='12' or
                         CONTYPE='14' or CONTYPE='15' or CONTYPE='16' or
                         CONTYPE='17']">
    <xsl:sort select="CON_NUM" data-type="number"/>
    <xsl:call-template name="DoCON_LIST_ITEM">
     <xsl:with-param name="SchemaObjParent" select="$SchemaObjParent"/>
     <xsl:with-param name="InColList" select="$InColList"/>
     <xsl:with-param name="CommaNeeded" select="$CommaNeeded"/>
     <xsl:with-param name="Property" select="$Property"/>
     <xsl:with-param name="Position" select="position()"/>
    </xsl:call-template>
   </xsl:for-each>
  </xsl:if>
  <xsl:choose>
   <!-- comma needed test for any next constraints -->
   <xsl:when test="($CONSTRAINTS=1 or ($SchemaObjParent/PART_OBJ/PARTOBJ/FLAGS mod 64) >=32) and $InColList=1 and
                   $CONSTRAINTS_AS_ALTER=0 and
                   $ListParent/CON1_LIST/CON1_LIST_ITEM[CONTYPE='12' or
                   CONTYPE='14' or CONTYPE='15' or CONTYPE='16' or
                   CONTYPE='17']">
    <xsl:call-template name="GenCON2s">
     <xsl:with-param name="SchemaObjParent" select="$SchemaObjParent"/>
     <xsl:with-param name="ListParent" select="$ListParent"/>
     <xsl:with-param name="InColList">1</xsl:with-param>
     <xsl:with-param name="CommaNeeded">1</xsl:with-param>
     <xsl:with-param name="Property" select="$Property"/>
     <xsl:with-param name="Nested" select="$Nested"/>
    </xsl:call-template>
   </xsl:when>
   <xsl:otherwise>
    <xsl:call-template name="GenCON2s">
     <xsl:with-param name="SchemaObjParent" select="$SchemaObjParent"/>
     <xsl:with-param name="ListParent" select="$ListParent"/>
     <xsl:with-param name="InColList" select="$InColList"/>
     <xsl:with-param name="CommaNeeded" select="$CommaNeeded"/>
     <xsl:with-param name="Property" select="$Property"/>
     <xsl:with-param name="Nested" select="$Nested"/>
    </xsl:call-template>
   </xsl:otherwise>
  </xsl:choose>
 </xsl:template>
 <xsl:template name="GenCON2s">
  <xsl:param name="SchemaObjParent" select="''"/>
  <xsl:param name="ListParent" select="''"/>
  <xsl:param name="InColList">0</xsl:param>
  <xsl:param name="CommaNeeded">0</xsl:param>
  <xsl:param name="Property">0</xsl:param>
  <xsl:param name="Nested">0</xsl:param>
  <!-- *******************************************************************
Template: GenCON2s - Referential constraints (CON2_LIST)
Parameters:
  SchemaObjParent - parent of SCHEMA_OBJ node
  ListParent - parent node of constraint list (e.g., CON1_LIST, CON2_LIST)
  InColList - 1 = generating constraints after column list in CREATE TABLE
              0 = adding constraint in ALTER TABLE
  CommaNeeded - 1 = comma needed before first constraint
                    (e.g., when columns have been emitted and we must
                     emit a comma before putting out the constraints
  Property - value of table PROPERTY
  Nested - 1 = generating DDL for a nested table
******************************************************************** -->
  <!-- Only if referential constraints.
       Outer tbl: in CREATE or ALTER TABLE
       Nestd tbl: only in ALTER TABLE (NESTED_TABLE_ID refs SETID of self)
    -->
  <xsl:choose>
   <xsl:when test="($REF_CONSTRAINTS=1) and
                (($Nested=0 and $InColList!=$CONSTRAINTS_AS_ALTER) or
                 ($Nested=1 and $InColList=0))">
    <!-- and we are in the proper context for constraints (either in column list, or as alter statements)-->
    <xsl:for-each select="$ListParent/CON2_LIST/CON2_LIST_ITEM[$Nested=0 or ((FLAGS mod 1024) &lt; 512)]">
     <!-- Only Non (OID or SETID) UNIQUE constraints -->
     <xsl:sort select="CON_NUM" data-type="number"/>
     <xsl:call-template name="DoCON_LIST_ITEM">
      <xsl:with-param name="SchemaObjParent" select="$SchemaObjParent"/>
      <xsl:with-param name="InColList" select="$InColList"/>
      <xsl:with-param name="CommaNeeded" select="$CommaNeeded"/>
      <xsl:with-param name="Property" select="$Property"/>
      <xsl:with-param name="Position" select="position()"/>
     </xsl:call-template>
    </xsl:for-each>
   </xsl:when>
   <xsl:when test="$REF_CONSTRAINTS=0  and $SchemaObjParent/REFPAR_LEVEL>0   and $InColList=1">
    <!--if Non referential constraints are excluded, we force inclusion of primary/unique constraints-->
    <!-- needed for reference partitioning parent tables, as constraints in the column list.-->
    <xsl:for-each select="$ListParent/CON2_LIST/CON2_LIST_ITEM[$SchemaObjParent/REFPAR_LEVEL>0 and
   (FLAGS mod 1024) &gt;= 512 ]">
     <xsl:sort select="CON_NUM" data-type="number"/>
     <xsl:call-template name="DoCON_LIST_ITEM">
      <xsl:with-param name="SchemaObjParent" select="$SchemaObjParent"/>
      <xsl:with-param name="InColList" select="$InColList"/>
      <xsl:with-param name="CommaNeeded" select="$CommaNeeded"/>
      <xsl:with-param name="Property" select="$Property"/>
      <xsl:with-param name="Position" select="position()"/>
     </xsl:call-template>
    </xsl:for-each>
   </xsl:when>
  </xsl:choose>
 </xsl:template>
 <xsl:template name="DoCON_LIST_ITEM">
  <xsl:param name="SchemaObjParent" select="''"/>
  <xsl:param name="InColList">0</xsl:param>
  <xsl:param name="CommaNeeded">0</xsl:param>
  <xsl:param name="Property">0</xsl:param>
  <xsl:param name="Position">0</xsl:param>
  <!-- *******************************************************************
Template: DoCON_LIST_ITEM
 Gen. out-of-line constraint as ALTER TABLE ADD or in CREATE TABLE
     (all constraints other than REFs/pkREFs).
     Provides statement termination, list item comma separation,
      object name for NOT NULL.
Parameters:
  SchemaObjParent - parent of SCHEMA_OBJ node
  InColList - 1 = generating constraints after column list in CREATE TABLE
              0 = adding constraint in ALTER TABLE
  CommaNeeded - 1 = comma needed before first constraint
                    (e.g., when columns have been emitted and we must
                     emit a comma before putting out the constraints
  Property - value of table PROPERTY
  Position - position of COL_LIST_ITEM in COL_LIST
******************************************************************** -->
  <xsl:choose>
   <xsl:when test="$InColList=0">
    <!-- ALTER TABLE ADD -->
    <xsl:call-template name="DoParse">
     <xsl:with-param name="Verb">ALTER</xsl:with-param>
     <xsl:with-param name="ObjectType">TABLE</xsl:with-param>
     <xsl:with-param name="SchemaNode" select="$SchemaObjParent/SCHEMA_OBJ/OWNER_NAME"/>
     <xsl:with-param name="NameNode" select="$SchemaObjParent/SCHEMA_OBJ/NAME"/>
    </xsl:call-template>
    <xsl:text>
  ALTER TABLE </xsl:text>
    <xsl:apply-templates select="$SchemaObjParent/SCHEMA_OBJ"/>
    <xsl:text>ADD</xsl:text>
    <xsl:call-template name="DoConstraint">
     <xsl:with-param name="TAB_CONSTRAINT">1</xsl:with-param>
     <xsl:with-param name="Property" select="$Property"/>
     <xsl:with-param name="ConstraintNode" select="current()"/>
     <xsl:with-param name="ColListNode" select="$SchemaObjParent/COL_LIST"/>
    </xsl:call-template>
    <xsl:if test="$SQLTERMINATOR=1">
     <xsl:text>;</xsl:text>
     <!-- Terminate the SQL statement -->
    </xsl:if>
   </xsl:when>
   <xsl:otherwise>
    <!-- CREATE TABLE  (In column list) -->
    <xsl:if test="$CommaNeeded=1 and $Position=1">
     <xsl:text>, </xsl:text>
     <xsl:if test="$PRETTY=1">
      <xsl:text>&#xa;	</xsl:text>
     </xsl:if>
    </xsl:if>
    <!-- Object table column/attribute name for NOT NULL -->
    <xsl:if test="CONTYPE='7' or CONTYPE='11'">
     <xsl:text> </xsl:text>
     <xsl:call-template name="ColNameOrAttr">
      <xsl:with-param name="ColItem" select=".."/>
     </xsl:call-template>
    </xsl:if>
    <xsl:call-template name="DoConstraint">
     <xsl:with-param name="TAB_CONSTRAINT">1</xsl:with-param>
     <xsl:with-param name="Property" select="$Property"/>
     <xsl:with-param name="ConstraintNode" select="current()"/>
     <xsl:with-param name="ColListNode" select="$SchemaObjParent/COL_LIST"/>
    </xsl:call-template>
    <xsl:if test="not($Position=last())">
     <xsl:text>, </xsl:text>
     <xsl:if test="$PRETTY=1">
      <xsl:text>&#xa;	</xsl:text>
     </xsl:if>
    </xsl:if>
   </xsl:otherwise>
  </xsl:choose>
 </xsl:template>
 <xsl:template name="DoPKREF_LIST_ITEM">
  <xsl:param name="SchemaObjParent" select="''"/>
  <xsl:param name="ListParent" select="''"/>
  <xsl:param name="InColList">0</xsl:param>
  <xsl:param name="CommaNeeded">0</xsl:param>
  <xsl:param name="Position">0</xsl:param>
  <!-- *******************************************************************
Template: DoPKREF_LIST_ITEM
 Gen. out-of-line REF/pkREF constr. as ALTER TABLE ADD or in CREATE TABLE.
     Provides statement termination, list item comma separation,
     special formatting.
     (This is DoCON_LIST_ITEM/DoConstraint combined for REFs).
Parameters:
  SchemaObjParent - parent of SCHEMA_OBJ node
  ListParent - parent node of constraint list (e.g., CON1_LIST, CON2_LIST)
  InColList - 1 = generating constraints after column list in CREATE TABLE
              0 = adding constraint in ALTER TABLE
  CommaNeeded - 1 = comma needed before first constraint
                    (e.g., when columns have been emitted and we must
                     emit a comma before putting out the constraints
  Property - value of table PROPERTY
  Position - position of PKREF_LIST_ITEM in PKREF_LIST
******************************************************************** -->
  <!--
       ... All REFs with non 0 type add REF constraints ...
       reftyp    number not null                          /* REF type flag */
                                                   /* 0x01 = REF is scoped */
                                           /* 0x02 = REF stored with rowid */
                                           /* 0x04 = Primary key based ref */
                            /* 0x08 = Allow unscoped Primary key based ref */
  ... Except that SCOPE is skipped if col. list FOREIGN KEY for that REF ...

    -->
  <xsl:if test="$InColList=1">
   <!-- Setup if In column list -->
   <xsl:if test="$CommaNeeded=1 and $Position=1">
    <xsl:text>, </xsl:text>
    <xsl:if test="$PRETTY=1">
     <xsl:text>&#xa;</xsl:text>
    </xsl:if>
   </xsl:if>
  </xsl:if>
  <xsl:choose>
   <xsl:when test="(REFTYP mod 2)=1">
    <!-- Scoped, possibly pkREF -->
    <xsl:choose>
     <!-- In column list or stand alone -->
     <xsl:when test="$InColList=0">
      <!-- Stand alone -->
      <xsl:call-template name="DoParse">
       <xsl:with-param name="Verb">ALTER</xsl:with-param>
       <xsl:with-param name="ObjectType">TABLE</xsl:with-param>
       <xsl:with-param name="SchemaNode" select="$SchemaObjParent/SCHEMA_OBJ/OWNER_NAME"/>
       <xsl:with-param name="NameNode" select="$SchemaObjParent/SCHEMA_OBJ/NAME"/>
      </xsl:call-template>
      <xsl:text>
  ALTER TABLE </xsl:text>
      <xsl:apply-templates select="$SchemaObjParent/SCHEMA_OBJ"/>
      <xsl:text>ADD SCOPE FOR (</xsl:text>
      <xsl:call-template name="ColNameOrAttr">
       <xsl:with-param name="ColItem" select="current()"/>
      </xsl:call-template>
      <xsl:text>) IS </xsl:text>
      <xsl:choose>
       <!-- Refer to Scope by OID or Name -->
       <!-- Classic export also uses MdApi to export xml schema tables -->
       <xsl:when test="$EXPORT=1 or $OLDEXPORT=1">
        <!-- OID for Export -->
        <xsl:text>OID '</xsl:text>
        <xsl:value-of select="SCHEMA_OBJ/OID"/>
        <xsl:text>'</xsl:text>
        <xsl:choose>
         <xsl:when test="(REFTYP mod 8)>=5">
          <!-- pkREF requires pkey cols -->
          <xsl:text> USER_DEFINED (</xsl:text>
          <xsl:for-each select="PK_COL_LIST/PK_COL_LIST_ITEM">
           <xsl:call-template name="ColNameOrAttr">
            <xsl:with-param name="ColItem" select="current()"/>
           </xsl:call-template>
           <xsl:if test="not(position()=last())">
            <xsl:text>, </xsl:text>
           </xsl:if>
          </xsl:for-each>
          <xsl:text>)</xsl:text>
         </xsl:when>
         <xsl:otherwise>
          <xsl:if test="FOREIGNKEY=1">
           <!-- sREF with FOREIGN KEY constraint requires exploded cols -->
           <xsl:text> SYSTEM_DEFINED</xsl:text>
          </xsl:if>
         </xsl:otherwise>
        </xsl:choose>
       </xsl:when>
       <xsl:otherwise>
        <!-- Scope is table name for others -->
        <xsl:apply-templates select="SCHEMA_OBJ"/>
       </xsl:otherwise>
      </xsl:choose>
      <xsl:if test="$SQLTERMINATOR=1">
       <xsl:text>;</xsl:text>
       <!-- Terminate the SQL statement -->
      </xsl:if>
     </xsl:when>
     <!-- Stand alone -->
     <xsl:otherwise>
      <!-- Scoped, In column list -->
      <xsl:if test="$PRETTY=1">
       <xsl:text>	</xsl:text>
      </xsl:if>
      <xsl:text>SCOPE FOR (</xsl:text>
      <xsl:call-template name="ColNameOrAttr">
       <xsl:with-param name="ColItem" select="current()"/>
      </xsl:call-template>
      <xsl:text>) IS </xsl:text>
      <xsl:choose>
       <!--Scope by OID or Name (see above) -->
       <xsl:when test="$EXPORT=1">
        <xsl:text>OID '</xsl:text>
        <xsl:value-of select="SCHEMA_OBJ/OID"/>
        <xsl:text>'</xsl:text>
        <xsl:choose>
         <xsl:when test="(REFTYP mod 8)>=5">
          <xsl:if test="$PRETTY=1">
           <xsl:text>&#xa;	 </xsl:text>
          </xsl:if>
          <xsl:text> USER_DEFINED (</xsl:text>
          <xsl:for-each select="PK_COL_LIST/PK_COL_LIST_ITEM">
           <xsl:call-template name="ColNameOrAttr">
            <xsl:with-param name="ColItem" select="current()"/>
           </xsl:call-template>
           <xsl:if test="not(position()=last())">
            <xsl:text>, </xsl:text>
           </xsl:if>
          </xsl:for-each>
          <xsl:text>)</xsl:text>
         </xsl:when>
         <xsl:otherwise>
          <xsl:if test="FOREIGNKEY=1">
           <xsl:if test="$PRETTY=1">
            <xsl:text>&#xa;	 </xsl:text>
           </xsl:if>
           <xsl:text> SYSTEM_DEFINED</xsl:text>
          </xsl:if>
         </xsl:otherwise>
        </xsl:choose>
       </xsl:when>
       <xsl:otherwise>
        <xsl:apply-templates select="SCHEMA_OBJ"/>
       </xsl:otherwise>
      </xsl:choose>
      <xsl:if test="not($Position=last())">
       <xsl:text>, </xsl:text>
       <xsl:if test="$PRETTY=1">
        <xsl:text>&#xa;</xsl:text>
       </xsl:if>
      </xsl:if>
     </xsl:otherwise>
     <!-- In column list -->
    </xsl:choose>
   </xsl:when>
   <!-- Scoped -->
   <xsl:otherwise>
    <!-- Not scoped -->
    <xsl:if test="(REFTYP mod 4)=2">
     <!-- ROWID hint -->
     <xsl:choose>
      <!-- In column list or stand alone -->
      <xsl:when test="$InColList=0">
       <!-- Stand alone -->
       <xsl:call-template name="DoParse">
        <xsl:with-param name="Verb">ALTER</xsl:with-param>
        <xsl:with-param name="ObjectType">TABLE</xsl:with-param>
        <xsl:with-param name="SchemaNode" select="$SchemaObjParent/SCHEMA_OBJ/OWNER_NAME"/>
        <xsl:with-param name="NameNode" select="$SchemaObjParent/SCHEMA_OBJ/NAME"/>
       </xsl:call-template>
       <xsl:text>
  ALTER TABLE </xsl:text>
       <xsl:apply-templates select="$SchemaObjParent/SCHEMA_OBJ"/>
       <xsl:text>ADD REF (</xsl:text>
       <xsl:call-template name="ColNameOrAttr">
        <xsl:with-param name="ColItem" select="current()"/>
       </xsl:call-template>
       <xsl:text>) WITH ROWID</xsl:text>
       <xsl:if test="$SQLTERMINATOR=1">
        <xsl:text>;</xsl:text>
        <!-- Terminate the SQL statement -->
       </xsl:if>
      </xsl:when>
      <xsl:otherwise>
       <!-- ROWID, In column list -->
       <xsl:if test="$PRETTY=1">
        <xsl:text>	</xsl:text>
       </xsl:if>
       <xsl:text>REF (</xsl:text>
       <xsl:call-template name="ColNameOrAttr">
        <xsl:with-param name="ColItem" select="current()"/>
       </xsl:call-template>
       <xsl:text>) WITH ROWID</xsl:text>
       <xsl:choose>
        <xsl:when test="(REFTYP mod 16)=10">
         <!-- ALLOW also? -->
         <xsl:text>, </xsl:text>
         <!-- Yes, always comma seperate -->
         <xsl:if test="$PRETTY=1">
          <xsl:text>&#xa;</xsl:text>
         </xsl:if>
        </xsl:when>
        <xsl:otherwise>
         <!-- No - prepare for any next REF item -->
         <xsl:if test="not($Position=last())">
          <xsl:text>, </xsl:text>
          <xsl:if test="$PRETTY=1">
           <xsl:text>&#xa;</xsl:text>
          </xsl:if>
         </xsl:if>
        </xsl:otherwise>
       </xsl:choose>
      </xsl:otherwise>
      <!-- In column list -->
     </xsl:choose>
    </xsl:if>
    <!-- ROWID syntax -->
    <xsl:if test="(REFTYP mod 16)>=8">
     <!-- ALLOW PRIMARY KEY -->
     <xsl:choose>
      <!-- In column list or stand alone -->
      <xsl:when test="$InColList=0">
       <!-- Stand alone -->
       <xsl:call-template name="DoParse">
        <xsl:with-param name="Verb">ALTER</xsl:with-param>
        <xsl:with-param name="ObjectType">TABLE</xsl:with-param>
        <xsl:with-param name="SchemaNode" select="$SchemaObjParent/SCHEMA_OBJ/OWNER_NAME"/>
        <xsl:with-param name="NameNode" select="$SchemaObjParent/SCHEMA_OBJ/NAME"/>
       </xsl:call-template>
       <xsl:text>
  ALTER TABLE </xsl:text>
       <xsl:apply-templates select="$SchemaObjParent/SCHEMA_OBJ"/>
       <xsl:text>ADD REF (</xsl:text>
       <xsl:call-template name="ColNameOrAttr">
        <xsl:with-param name="ColItem" select="current()"/>
       </xsl:call-template>
       <xsl:text>) ALLOW PRIMARY KEY</xsl:text>
       <xsl:if test="$SQLTERMINATOR=1">
        <xsl:text>;</xsl:text>
       </xsl:if>
      </xsl:when>
      <xsl:otherwise>
       <!-- In column list -->
       <xsl:if test="$PRETTY=1">
        <xsl:text>	</xsl:text>
       </xsl:if>
       <xsl:text>REF (</xsl:text>
       <xsl:call-template name="ColNameOrAttr">
        <xsl:with-param name="ColItem" select="current()"/>
       </xsl:call-template>
       <xsl:text>) ALLOW PRIMARY KEY</xsl:text>
       <xsl:if test="not($Position=last())">
        <xsl:text>, </xsl:text>
        <xsl:if test="$PRETTY=1">
         <xsl:text>&#xa;</xsl:text>
        </xsl:if>
       </xsl:if>
      </xsl:otherwise>
      <!-- In column list -->
     </xsl:choose>
    </xsl:if>
    <!-- ALLOW syntax -->
   </xsl:otherwise>
   <!-- Not scoped -->
  </xsl:choose>
 </xsl:template>
 <xsl:template name="TablePropertyParen">
  <xsl:param name="OpenParen">1</xsl:param>
  <xsl:param name="SchemaObjParent" select="''"/>
  <xsl:param name="ListParent" select="''"/>
  <xsl:param name="Property">0</xsl:param>
  <xsl:param name="Nested">0</xsl:param>
  <xsl:param name="Storage">0</xsl:param>
  <!-- *******************************************************************
Template: TablePropertyParen
  Determine if table property paren needed for constraints and emits it if so.
     Handles needed parens for relational tables and determining if there
     are constraints that will require them for object tables.
     Also used to generate Nested Table storage clause parens.
     Tries to maintain the historical formatting before/after parens.

     The conditions tested MUST CORRESPOND EXACTLY to the hierarchy of
     conditions tested in the templates from GenTableConstraints down
     (first level to CON2).
Parameters:
 OpenParen - 1 = emit '('
             else ')'
  SchemaObjParent - parent of SCHEMA_OBJ node
  ListParent - parent node of constraint list (e.g., CON1_LIST, CON2_LIST)
  Property - value of table PROPERTY
  Nested - 1 = generating DDL for a nested table
  Storage - 1 = emitting storage table properties for nested table
******************************************************************** -->
  <xsl:if test="($Nested=0 and ($Property mod 2)=0) or
               ($Property mod 128)>=64 or ($Property mod 8192)>=4096 or
               ((($CONSTRAINTS=1 or ($SchemaObjParent/PART_OBJ/PARTOBJ/FLAGS mod 64) >=32) or $EXPORT=1) and
     $SchemaObjParent/COL_LIST/COL_LIST_ITEM[(PROPERTY mod 64)&lt;32]/CON) or
               ($CONSTRAINTS_AS_ALTER=0 and
                   (($Nested=0 and
                     $ListParent/PKREF_LIST/PKREF_LIST_ITEM[ 
                      not ((REFTYP mod 32) > 16 and (PROPERTY mod 64)>=32)] and
                     $ListParent/PKREF_LIST/PKREF_LIST_ITEM[
                                             (REFTYP mod 16)>0]) or
                    (($CONSTRAINTS=1 or ($SchemaObjParent/PART_OBJ/PARTOBJ/FLAGS mod 64) >=32) and
                     ($ListParent/CON0_LIST/CON0_LIST_ITEM or
                      $ListParent/CON1_LIST/CON1_LIST_ITEM[
                            COL_LIST/COL_LIST_ITEM/OID_OR_SETID=0])) or
                    (($REF_CONSTRAINTS=1 or $SchemaObjParent/REFPAR_LEVEL>0) and $Nested=0 and
                     $ListParent/CON2_LIST/CON2_LIST_ITEM)))">
   <xsl:if test="$Nested=0 and $Storage=0 and $PRETTY=1">
    <xsl:choose>
     <xsl:when test="$OpenParen=1">
      <xsl:text>  </xsl:text>
     </xsl:when>
     <xsl:otherwise>
      <xsl:text>&#xa;   </xsl:text>
     </xsl:otherwise>
    </xsl:choose>
   </xsl:if>
   <xsl:call-template name="EmitParen">
    <xsl:with-param name="OpenParen" select="$OpenParen"/>
   </xsl:call-template>
   <xsl:if test="$Nested=1 and $Storage=0 and $OpenParen=0 and $PRETTY=1">
    <xsl:text>&#xa;</xsl:text>
   </xsl:if>
  </xsl:if>
 </xsl:template>
 <xsl:template name="EmitParen">
  <xsl:param name="OpenParen">1</xsl:param>
  <!-- *******************************************************************
Template: EmitParen
 Emit open or close paren for table properties/nested storage
Parameters:
 OpenParen - 1 = emit '('
             else ')'
******************************************************************** -->
  <xsl:choose>
   <xsl:when test="$OpenParen=1">(</xsl:when>
   <xsl:otherwise>) </xsl:otherwise>
  </xsl:choose>
 </xsl:template>
</xsl:stylesheet>
