/*
This file is part of PacketDotNet0200

PacketDotNet0200 is free software: you can redistribute it and/or modify
it under the terms of the GNU Lesser General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

PacketDotNet0200 is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU Lesser General Public License for more details.

You should have received a copy of the GNU Lesser General Public License
along with PacketDotNet0200.  If not, see <http://www.gnu.org/licenses/>.
*/
/*
 *  Copyright 2010 Evan Plaice <evanplaice@gmail.com>
 *  Copyright 2010 Chris Morgan <chmorgan@gmail.com>
 */

namespace PacketDotNet0200.LLDP
{
    /// <summary>
    /// Interface Numbering Types
    /// </summary>
    /// <remarks>Source IETF RFC 802.1AB</remarks>
    public enum InterfaceNumbering
    {
        /// <summary>Unknown</summary>
        Unknown,

        /// <summary>Interface Index</summary>
        IfIndex,

        /// <summary>System Port Number</summary>
        SystemPortNumber
    }
}