/*
This file is part of PacketDotNet0200

PacketDotNet0200 is free software: you can redistribute it and/or modify
it under the terms of the GNU Lesser General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

PacketDotNet0200 is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU Lesser General Public License for more details.

You should have received a copy of the GNU Lesser General Public License
along with PacketDotNet0200.  If not, see <http://www.gnu.org/licenses/>.
*/
/*
 *  Copyright 2010 Evan Plaice <evanplaice@gmail.com>
 *  Copyright 2010 Chris Morgan <chmorgan@gmail.com>
 */

using System;

namespace PacketDotNet0200.LLDP
{
    /// <summary>
    /// A System Name TLV
    /// </summary>
    [Serializable]
    public class SystemName : StringTLV
    {
        #region Properties

        /// <value>
        /// A textual Name of the system
        /// </value>
        public String Name
        {
            get => StringValue;
            set => StringValue = value;
        }

        #endregion


        #region Constructors

        /// <summary>
        /// Creates a System Name TLV
        /// </summary>
        /// <param name="bytes">
        /// </param>
        /// <param name="offset">
        /// The System Name TLV's offset from the
        /// origin of the LLDP
        /// </param>
        public SystemName(Byte[] bytes, Int32 offset) :
            base(bytes, offset)
        { }

        /// <summary>
        /// Creates a System Name TLV and sets it value
        /// </summary>
        /// <param name="name">
        /// A textual Name of the system
        /// </param>
        public SystemName(String name) : base(TLVTypes.SystemName, name)
        { }

        #endregion
    }
}