%define dvendor	qlgc
%define vendor %{dvendor}
%define driver_name fastlinq
%define dist_version	8.53.0.3
%define fw_version	8.50.16.0
%define d_version	%( echo "%{dist_version}" | tr '-' '_' )
%define qed_ver	8.53.0.0
%define qede_ver	8.53.0.0
%define qedr_ver	8.53.0.0
%define qedf_ver	8.53.0.1
%define qedi_ver	8.53.0.3


%define dist_str	sles12sp5
%define dist sles 
%define distver 12
%define release	1

%define mod_sign_files /home/sign
%define module_key %{mod_sign_files}/qlgc_module_signing_key.priv
%define module_cer %{mod_sign_files}/qlgc_module.cer
%define sourceinfo "SRPMS available at http://ldriver.qlogic.com/driver-srpms/"
%define gpginfo "RPM public key available at http://ldriver.qlogic.com/RPM-public-key/ and Module public key available at http://ldriver.qlogic.com/Module-public-key/"



Name	: %{vendor}-%{driver_name}
Version  : %{d_version}
Release  : %{release}.%{?dist_str}
Group    : System Environment/Base
Vendor   : QLogic Corporation
URL	 : http://www.qlogic.com
License  : GPLv2
Source0  : %{driver_name}-%{d_version}.tgz
Source1  : %{driver_name}.files
Source2  : qed_init_values_zipped-%{fw_version}.bin
Source3  : dracut.fastlinq.conf
BuildRoot: %{_tmppath}/%{name}-buildroot
BuildRequires: kernel-source kernel-syms
Summary  : QLogic fastlinq CNA drivers
Packager: QLogic Corporation


%define kverrel %(uname -r | awk -F"-" '{print $1"-"$2}')
%define verrel %(rpm -qa|grep %{kverrel}|head -n 1|awk -F%{kverrel} '{print "%{kverrel}"$2}')
%define default %(rpm -q kernel-default-devel-%{verrel}|head -n 1)
%define xen %(rpm -q kernel-xen-devel-%{verrel}|head -n 1)
%define pae %(rpm -q kernel-pae-devel-%{verrel}|head -n 1)
%define arch %(uname -m)

%suse_kernel_module_package trace -f %{SOURCE1}

%description
SLES12.x Driver Update package for FastlinQ Adapter.
Public key available at http://ldriver.qlogic.com/RPM-public-key/
SRPMS available at http://ldriver.qlogic.com/driver-srpms/

%package KMP
Summary: Update for QLogic qla4xxx driver
Group: System/Kernel

%description KMP
SLES12.x Driver Update package for FastlinQ Adapter.
Public key available at http://ldriver.qlogic.com/RPM-public-key/
SRPMS available at http://ldriver.qlogic.com/driver-srpms/

%description kmp-default
SLES12.x Driver Update package for FastlinQ Adapter.
Public key available at http://ldriver.qlogic.com/RPM-public-key/
SRPMS available at http://ldriver.qlogic.com/driver-srpms/

%if "%{xen}" == "kernel-xen-devel-%{verrel}"
%description kmp-xen
SLES12.x Driver Update package for FastlinQ Adapter.
Public key available at http://ldriver.qlogic.com/RPM-public-key/
SRPMS available at http://ldriver.qlogic.com/driver-srpms/
%endif

%prep
%setup -n %{driver_name}-%{d_version}
set -- *
mkdir source
mv "$@" source/
mkdir obj
cd source
cp %{S:2} .

%build
export KVER=%{kverrel}
export EXTRA_CFLAGS='-DVERSION="%d_version"'
for flavor in %flavors_to_build; do
	rm -rf obj/$flavor
	cp -r source obj/$flavor
	cd obj/$flavor
	kernel_flavor=${KVER}-${flavor}
	make -C $PWD KVER=$kernel_flavor
	cd ../..
done

%install
export KVER=%{kverrel}

for flavor in %{flavors_to_build};
do

if [ -f %{module_key} ] && [ -f %{module_cer} ]; then
	if [ -f /usr/src/linux/scripts/sign-file ]; then
		perl /usr/src/linux/scripts/sign-file sha256 %{module_key} %{module_cer}  $PWD/obj/$flavor/qed-%{qed_ver}/src/qed.ko
		perl /usr/src/linux/scripts/sign-file sha256 %{module_key} %{module_cer}  $PWD/obj/$flavor/qede-%{qede_ver}/src/qede.ko
		if [ -f obj/${flavor}/qedr-%{qedr_ver}/src/qedr.ko ]; then
			 perl /usr/src/linux/scripts/sign-file sha256 %{module_key} %{module_cer}  $PWD/obj/${flavor}/qedr-%{qedr_ver}/src/qedr.ko
		fi

		if [ -f obj/${flavor}/qedi-%{qedi_ver}/qedi.ko ]; then
			 perl /usr/src/linux/scripts/sign-file sha256 %{module_key} %{module_cer}  $PWD/obj/${flavor}/qedi-%{qedi_ver}/qedi.ko
		fi

		if [ -f obj/${flavor}/qedf-%{qedf_ver}/qedf.ko ]; then
			 perl /usr/src/linux/scripts/sign-file sha256 %{module_key} %{module_cer}  $PWD/obj/${flavor}/qedf-%{qedf_ver}/qedf.ko
		fi
	else
		/usr/src/linux-%{kverrel}-obj/%{arch}/default/scripts/sign-file sha256 %{module_key} %{module_cer}  $PWD/obj/$flavor/qed-%{qed_ver}/src/qed.ko
		/usr/src/linux-%{kverrel}-obj/%{arch}/default/scripts/sign-file sha256 %{module_key} %{module_cer}  $PWD/obj/$flavor/qede-%{qede_ver}/src/qede.ko
		if [ -f obj/${flavor}/qedr-%{qedr_ver}/src/qedr.ko ]; then
			 /usr/src/linux-%{kverrel}-obj/%{arch}/default/scripts/sign-file sha256 %{module_key} %{module_cer}  $PWD/obj/${flavor}/qedr-%{qedr_ver}/src/qedr.ko
		fi

		if [ -f obj/${flavor}/qedi-%{qedi_ver}/qedi.ko ]; then
			 /usr/src/linux-%{kverrel}-obj/%{arch}/default/scripts/sign-file sha256 %{module_key} %{module_cer}  $PWD/obj/${flavor}/qedi-%{qedi_ver}/qedi.ko
		fi

		if [ -f obj/${flavor}/qedf-%{qedf_ver}/qedf.ko ]; then
			 /usr/src/linux-%{kverrel}-obj/%{arch}/default/scripts/sign-file sha256 %{module_key} %{module_cer}  $PWD/obj/${flavor}/qedf-%{qedf_ver}/qedf.ko
		fi
	
	fi
fi
	kernel_flavor=${KVER}-${flavor}

	dest_dir=${RPM_BUILD_ROOT}/lib/modules/${kernel_flavor}/updates/%{name}

	mkdir -p $dest_dir
	install -m 444 obj/${flavor}/qed-%{qed_ver}/src/qed.ko $dest_dir
	install -m 444 obj/${flavor}/qede-%{qede_ver}/src/qede.ko $dest_dir
	if [ -f obj/${flavor}/qedr-%{qedr_ver}/src/qedr.ko ]; then
		install -m 444 obj/${flavor}/qedr-%{qedr_ver}/src/qedr.ko $dest_dir
	fi

	if [ -f obj/${flavor}/qedi-%{qedi_ver}/qedi.ko ]; then
		install -m 444 obj/${flavor}/qedi-%{qedi_ver}/qedi.ko $dest_dir
	fi

	if [ -f obj/${flavor}/qedf-%{qedf_ver}/qedf.ko ]; then
		install -m 444 obj/${flavor}/qedf-%{qedf_ver}/qedf.ko $dest_dir
	fi

done
mkdir -p $RPM_BUILD_ROOT/lib/firmware/qed
if [ ! -f $RPM_BUILD_ROOT/lib/firmware/qed/qed_init_values_zipped-%{fw_version}.bin ]; then
	install -m 644 -D source/qed_init_values_zipped-%{fw_version}.bin $RPM_BUILD_ROOT/lib/firmware/qed/qed_init_values_zipped-%{fw_version}.bin
fi
install -m 644 -D %{SOURCE3} $RPM_BUILD_ROOT/etc/dracut.conf.d/fastlinq.conf


%clean
rm -rf %{buildroot}
rm -rf $RPM_BUILD_ROOT

%changelog
* Thu Mar 23 2017 QLogic Cavium Build environment
- Version 8.18.18.0
- Added missing support to configure 1G speed via ethtool
- Fixed calculation of number of ooo rx buffers and limit to 16K

- Version 8.18.17.0-1
- iWARP - Handle flush completion on unaligned ll2 connection
- Add dp_module, dp_level as modparams
- Add Kconfig file for upstream builds

- Version 8.18.16.0-1
- Fix missing return error code check on call to qedi_setup_int
- Modify different module params
- Add log message in the driver unload path
- Fail all non-timesync related ioctls

- Version 8.18.15.0-1
- Added wwpn and wwnn to the FCoE dev-info
- Validate chap and mutual chap auth correctly

- Version 8.18.14.0-1
- Fix error handling flow in TX path
- Fix error handling flow in RX path
- Implement get_protocol_tlv_data callback

