
Summary: iscsiuio daemon program
Name: iscsiuio
Version: 2.11.5.13
Release: 3.rhel8u0
Source0: iscsiuio-%{version}.tar.gz
Vendor:  QLogic Corporation
Packager: QLogic Corporation


Group: System Environment/Daemons
License: GPLv2+
URL: http://www.broadcom.com
Buildroot: %{_tmppath}/%{name}-%{version}%(%{__id_u} -n)

%define sourceinfo "SRPMS available at http://ldriver.qlogic.com/driver-srpms/"
%define gpginfo "RPM public key available at http://ldriver.qlogic.com/RPM-public-key/ and Module public key available at http://ldriver.qlogic.com/Module-public-key/"

%description
The iscsi package provides the server iscsiuio daemon for QLogic's
iSCSI offload solution. iSCSI is a protocol for distributed disk access
using SCSI commands sent over Internet Protocol networks.
%{sourceinfo}
%{gpginfo}

%define debug_package %{nil}

%prep
%setup -q -n iscsiuio-%{version}

%build
./configure
make

%pre
mkdir -p /var/qlogic
if [ -f /usr/lib/systemd/system/iscsiuio.service ]; then
	cp /usr/lib/systemd/system/iscsiuio.service /var/qlogic/
fi

if [ -f /usr/lib/systemd/system/iscsiuio.socket ]; then
	cp /usr/lib/systemd/system/iscsiuio.socket /var/qlogic/
fi


%install
rm -rf $RPM_BUILD_ROOT
mkdir -p $RPM_BUILD_ROOT/sbin
mkdir -p ${RPM_BUILD_ROOT}%{_mandir}/man8
mkdir -p $RPM_BUILD_ROOT/etc/logrotate.d

install -m 755 src/unix/iscsiuio $RPM_BUILD_ROOT/sbin/iscsiuio
install -p -m 644 docs/iscsiuio.8 $RPM_BUILD_ROOT/%{_mandir}/man8/iscsiuio.8
install -p -m 644 iscsiuiolog $RPM_BUILD_ROOT%{_sysconfdir}/logrotate.d/iscsiuiolog

%posttrans
%if "%{_host_vendor}" == "suse"
	%define suse_release %(cat /etc/issue | grep SUSE | cut -d " " -f 7)
%endif

%if  "%{_host_vendor}" == "suse" && "%{suse_release}" == "12"
	if [ -f /var/qlogic/iscsiuio.service ]; then
		cp /var/qlogic/iscsiuio.service /usr/lib/systemd/system/iscsiuio.service
	fi

	if [ -f /var/qlogic/iscsiuio.socket ]; then
		cp /var/qlogic/iscsiuio.socket /usr/lib/systemd/system/iscsiuio.socket
	fi
	systemctl restart iscsiuio
	dracut -f
%endif

%if "%{_host_vendor}" == "redhat"
	dracut -f
%endif
echo "
Cavium iscsiuio RPM updated following files as part of its iSCSI functionality.

/etc/logrotate.d/iscsiuiolog
/sbin/iscsiuio
/usr/share/man/man8/iscsiuio.8.gz
 
These updated files may be flagged in software audit logs as unknown/unexpected,
such messages can be safely ignored.
"

logger " Cavium iscsiuio RPM updated some files as part of its iSCSI functionality. These updated files may be flagged in software audit logs as unknown/unexpected, such messages can be safely ignored. filenames: /etc/logrotate.d/iscsiuiolog /sbin/iscsiuio /usr/share/man/man8/iscsiuio.8.gz"

rm -rf /var/qlogic


%clean
rm -rf $RPM_BUILD_ROOT

%files
%defattr(-,root,root)
/sbin/*
%{_mandir}/man8/iscsiuio.8.gz
/etc/logrotate.d/iscsiuiolog


%changelog
* Wed Apr 25 2018 Nilesh Javali <nilesh.javali@cavium.com>
- Fix dracut command which incorrectly builds initrd image
  instead of initramfs image.

* Mon Feb 12 2018 Sarang Radke <sarang.radke@cavium.com>
- Implement posttrans logic to handle update correctly.

* Mon Jun 25 2013 Eddie Wai <eddie.wai@broadcom.com> - 0.7.8.1b
- First release
