/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.aueframework.common;

import java.util.Hashtable;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import se.ericsson.cello.aueframework.common.AueException;
import se.ericsson.cello.aueframework.common.Edge;
import se.ericsson.cello.aueframework.common.RevisionApproximator;
import se.ericsson.cello.aueframework.common.StrictRevisionApproximator;

public class DirectedRevisionGraph {
    private RevisionApproximator approximator;
    private Hashtable graph;
    private static final int INFINITE_DISTANCE = -1;

    public DirectedRevisionGraph(Edge[] edgeArray, RevisionApproximator revisionApproximator) {
        this.approximator = revisionApproximator;
        this.buildGraph(edgeArray);
    }

    public DirectedRevisionGraph(Edge[] edgeArray) {
        this(edgeArray, new StrictRevisionApproximator());
    }

    public List findShortestPath(String string, String string2) throws AueException {
        String string3 = this.approximateRevision("from", string);
        String string4 = this.approximateRevision("to", string2);
        List list = this.determineShortestPath(string3, string4);
        return list;
    }

    private void buildGraph(Edge[] edgeArray) {
        Object var2_2 = null;
        String string = null;
        String string2 = null;
        this.graph = new Hashtable();
        for (int i = 0; i < edgeArray.length; ++i) {
            Edge edge = edgeArray[i];
            string = edge.getFromRevision();
            string2 = edge.getToRevision();
            this.addEdge(string, edge);
            this.addEdge(string2, null);
        }
    }

    private void addEdge(String string, Edge edge) {
        LinkedList<Edge> linkedList = (LinkedList<Edge>)this.graph.get(string);
        if (linkedList == null) {
            linkedList = new LinkedList<Edge>();
            this.graph.put(string, linkedList);
        }
        if (edge != null) {
            linkedList.add(edge);
        }
    }

    private List determineShortestPath(String string, String string2) throws AueException {
        if (string.equals(string2)) {
            return new LinkedList();
        }
        String string3 = null;
        Hashtable<String, Integer> hashtable = new Hashtable<String, Integer>();
        Object object = this.graph.keys();
        while (object.hasMoreElements()) {
            string3 = (String)object.nextElement();
            hashtable.put(string3, new Integer(-1));
        }
        object = new Hashtable();
        ListIterator listIterator = null;
        Edge edge = null;
        String string4 = null;
        int n = 0;
        int n2 = 0;
        String string5 = null;
        boolean bl = false;
        hashtable.put(string, new Integer(0));
        LinkedList<String> linkedList = new LinkedList<String>();
        linkedList.addLast(string);
        block1: while (!linkedList.isEmpty() && !bl) {
            string5 = (String)linkedList.removeFirst();
            listIterator = ((LinkedList)this.graph.get(string5)).listIterator(0);
            n = (Integer)hashtable.get(string5);
            while (listIterator.hasNext()) {
                edge = (Edge)listIterator.next();
                string4 = edge.getToRevision();
                n2 = (Integer)hashtable.get(string4);
                if (n2 != -1) continue;
                hashtable.put(string4, new Integer(n + 1));
                linkedList.addLast(string4);
                ((Hashtable)object).put(string4, edge);
                if (!string4.equalsIgnoreCase(string2)) continue;
                bl = true;
                continue block1;
            }
        }
        if (!bl) {
            throw new AueException("Unable to find upgrade path between " + string + " and " + string2 + ".");
        }
        string5 = string2;
        LinkedList<Edge> linkedList2 = new LinkedList<Edge>();
        edge = (Edge)((Hashtable)object).get(string5);
        while (edge != null) {
            linkedList2.addFirst(edge);
            string5 = edge.getFromRevision();
            edge = (Edge)((Hashtable)object).get(string5);
        }
        return linkedList2;
    }

    private String approximateRevision(String string, String string2) throws AueException {
        String string3 = this.approximator.getApproximation(string2, this.graph.keySet());
        if (string3 == null) {
            throw new AueException(string + "-revision " + string2 + " not supported.");
        }
        return string3;
    }
}

