/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.aueframework.common;

import se.ericsson.cello.aueframework.common.AueContext;
import se.ericsson.cello.aueframework.common.AueException;
import se.ericsson.cello.aueframework.common.TransactionWrapper;
import se.ericsson.cello.transaction.Control;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.cello.transaction.TransactionRolledBackException;
import se.ericsson.cello.transaction.TransactionService;

public class TransactionWrapperImpl
implements TransactionWrapper {
    private Control control = null;
    private Coordinator coordinator = null;
    public static final int DEFAULT_TIMEOUT = 1800;
    public static final long RETRY_INTERVAL = 10L;

    public TransactionWrapperImpl(TransactionService transactionService, AueContext aueContext) throws AueException {
        this(transactionService, aueContext, 1800);
    }

    public TransactionWrapperImpl(TransactionService transactionService, AueContext aueContext, int n) throws AueException {
        try {
            this.control = this.createTransaction(transactionService, n);
        }
        catch (TransactionRolledBackException transactionRolledBackException) {
            aueContext.getLogger().error(this.getClass(), " Instantiation failed on first attempt. Retrying in 10s.", transactionRolledBackException);
            try {
                aueContext.getEnvironment().sleep(10000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            try {
                this.control = this.createTransaction(transactionService, n);
            }
            catch (TransactionRolledBackException transactionRolledBackException2) {
                throw new AueException("Unable to start transaction.", transactionRolledBackException2);
            }
            aueContext.getLogger().info(this.getClass(), " Instantiation succeeded on second attempt.");
        }
        this.coordinator = this.control.getCoordinator();
    }

    private Control createTransaction(TransactionService transactionService, int n) throws TransactionRolledBackException {
        return transactionService.getTransactionFactory().create(n);
    }

    public void commit() throws AueException {
        try {
            this.control.getTerminator().commit();
        }
        catch (Exception exception) {
            throw new AueException("Unable to commit transaction" + (this.coordinator == null ? "" : " (id=" + this.getID() + ")") + ".", exception);
        }
    }

    public Coordinator getCoordinator() {
        return this.coordinator;
    }

    public int getID() {
        return this.coordinator.getTransactionID();
    }
}

