/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.aueframework.converter;

import java.util.Collection;
import java.util.Iterator;
import java.util.Vector;
import se.ericsson.cello.aueframework.common.AueException;
import se.ericsson.cello.aueframework.common.TransactionWrapper;
import se.ericsson.cello.aueframework.converter.ConverterContext;
import se.ericsson.cello.aueframework.converter.MoDataAction;
import se.ericsson.cello.aueframework.converter.MoDataFilter;
import se.ericsson.cello.aueframework.converter.MoDataHandler;
import se.ericsson.cello.aueframework.converter.MoDataWrapper;
import se.ericsson.cello.moframework.MoData;

public class SimpleMoDataHandler
implements MoDataHandler {
    private MoDataFilter filter;
    private int txSize;
    private Collection actions = new Vector();
    private Collection mos = null;

    public SimpleMoDataHandler(MoDataFilter moDataFilter) {
        this(moDataFilter, 1);
    }

    public SimpleMoDataHandler(Collection collection) {
        this(null, 1);
        this.mos = collection;
    }

    public SimpleMoDataHandler(MoDataFilter moDataFilter, int n) {
        this.filter = moDataFilter;
        this.txSize = n;
    }

    public void add(MoDataAction moDataAction) {
        this.actions.add(moDataAction);
    }

    public void execute(ConverterContext converterContext) throws AueException {
        if (this.mos == null) {
            this.mos = converterContext.getMoDataAccessor().find(this.filter);
        }
        int n = 0;
        TransactionWrapper transactionWrapper = null;
        Iterator iterator = this.mos.iterator();
        while (iterator.hasNext()) {
            MoDataWrapper moDataWrapper = (MoDataWrapper)iterator.next();
            if (transactionWrapper == null) {
                transactionWrapper = converterContext.getTransactionWrapperFactory().create();
            }
            Iterator iterator2 = this.actions.iterator();
            while (iterator2.hasNext()) {
                MoDataAction moDataAction = (MoDataAction)iterator2.next();
                moDataAction.perform(moDataWrapper, converterContext, transactionWrapper.getCoordinator());
            }
            if (!moDataWrapper.isDeleted()) {
                moDataWrapper.handleTransaction(transactionWrapper.getCoordinator(), MoData.WRITE_ACCESS);
            }
            if (++n < this.txSize && iterator.hasNext()) continue;
            transactionWrapper.commit();
            transactionWrapper = null;
            n = 0;
        }
    }
}

