/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.emas.sm.applications;

import se.ericsson.cello.emas.sm.applications.LicenseLogicController;
import se.ericsson.cello.emas.sm.applications.LicenseLogicControllerImpl;
import se.ericsson.cello.support.gui.guilib.comp.Log;
import se.ericsson.cello.support.mgr.AbstractConfirmApplicationController;
import se.ericsson.cello.support.proxy.CSException;
import se.ericsson.cello.support.proxy.Struct;

public class LicenseSetEmergencyStateController
extends AbstractConfirmApplicationController {
    private static final String CLASS_NAME = "LicenseSetEmergencyStateController";
    private LicenseLogicController theLicensingMo = null;
    private static final String STATE = "state";
    private static final int NEVER_USED = 0;
    private static final int ACTIVE = 1;
    private static final int USE_DEGRADED = 2;
    private static final int ACTIVE_AGAIN = 3;
    private static final int USE_DISABLED = 4;

    public void performAction() {
        Log.logNotify((String)"LicenseSetEmergencyStateController.performAction()");
        try {
            this.theLicensingMo = new LicenseLogicControllerImpl();
            boolean quit = false;
            String sMsg = null;
            String sTitle = null;
            int emergencyState = this.getEmergencyState();
            if (emergencyState != 0) {
                if (emergencyState == 1) {
                    sMsg = "EMERGENCY_STATE_ACTIVE_MSG";
                    sTitle = "CURR_EMERGENCY_STATE_TITLE";
                    quit = true;
                } else if (emergencyState == 2) {
                    sMsg = "EMERGENCY_STATE_USE_DEGRADED_MSG";
                    sTitle = "CURR_EMERGENCY_STATE_TITLE";
                } else if (emergencyState == 3) {
                    sMsg = "EMERGENCY_STATE_ACTIVE_AGAIN_MSG";
                    sTitle = "CURR_EMERGENCY_STATE_TITLE";
                    quit = true;
                } else if (emergencyState == 4) {
                    sMsg = "EMERGENCY_STATE_USE_DISABLED_MSG";
                    sTitle = "CURR_EMERGENCY_STATE_TITLE";
                    quit = true;
                }
            }
            if (sMsg != null && sTitle != null) {
                this.showMessageDialog(sMsg, null, sTitle, null, 1, null);
            }
            if (quit) {
                return;
            }
            if (0 == this.showConfirmDialog("SET_EMERGENCY_STATE_CONFIRM_MSG2", null, "SET_EMERGENCY_STATE_CONFIRM_TITLE2", null, 0, 3, null)) {
                this.theLicensingMo.actionSetEmergencyState();
            }
        }
        catch (CSException e) {
            this.reportException((Exception)((Object)e), "LICENSING_MO_ERROR_MSG", null);
        }
    }

    private int getEmergencyState() throws CSException {
        Struct emergencyStateInfo = this.theLicensingMo.getEmergencyStateInfo();
        Integer emergencyState = null;
        try {
            emergencyState = (Integer)emergencyStateInfo.getElementValue(STATE);
            if (emergencyState < 0 || emergencyState > 4) {
                throw new CSException("Emergency state value is out of bounds in Licensing MO.");
            }
        }
        catch (NoSuchFieldException e) {
            throw new CSException("The state field was not in the emergencyStateInfo struct as expected.");
        }
        return emergencyState;
    }
}

