/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.emas.sm.applications;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.JList;
import se.ericsson.cello.emas.sm.applications.EmasDialogController;
import se.ericsson.cello.emas.sm.applications.SlotSelectView;
import se.ericsson.cello.emas.sm.services.SlotNameFactory;
import se.ericsson.cello.support.gui.guilib.comp.Log;
import se.ericsson.cello.support.proxy.CSException;
import se.ericsson.cello.support.proxy.MOProxy;
import se.ericsson.cello.support.proxy.Transaction;

public class SlotSelectController
extends EmasDialogController
implements ActionListener {
    private SlotSelectView view;
    private TreeMap availableSlotsTable = null;
    private TreeMap selectedSlotsTable = new TreeMap();
    private int selectionMode = 2;
    private boolean selectionMandatory = false;
    private static final int AVAILABLE_SLOTS = 0;
    private static final int SELECTED_SLOTS = 1;
    private static final int NO_SELECTION = 2;
    private static final int TIME_OUT_PERIOD = 600;
    private CSException error;
    private String dialogMessage = "";

    protected void init() {
        this.view = (SlotSelectView)this.getView();
        this.view.setActionListener(this);
        this.getSlotsFromServer();
        this.updateTables();
        this.setSelections(2);
        this.setDialogTitle("SLOT_SELECT_TITLE", null);
    }

    protected void afterVisible() {
        if (this.error != null) {
            this.reportException((Exception)((Object)this.error), "ERROR_EDIT_SLOTS", null);
            this.notifyAll(new ActionEvent(this, 0, "ERROR"));
        } else {
            ((JList)this.view.availableSlots.getFieldComponent()).setSelectionMode(this.selectionMode);
            ((JList)this.view.selectedSlots.getFieldComponent()).setSelectionMode(this.selectionMode);
        }
    }

    private void getSlotsFromServer() {
        String slotName = null;
        String key = null;
        Transaction transaction = null;
        boolean isSwAllocationSlots = false;
        if ("SwAllocationSlots".equals(this.getParameter("SWALLOCAATION_SLOTS"))) {
            isSwAllocationSlots = true;
        }
        this.availableSlotsTable = new TreeMap();
        try {
            transaction = new Transaction(600);
            Hashtable slots = SlotNameFactory.getAllSlots(transaction);
            if (isSwAllocationSlots) {
                MOProxy rootMo = MOProxy.getRoot();
                MOProxy[] mo = rootMo.getChildren(2, "Jvm", "", null);
                slots.put(mo[0].getLastRDN(), mo[0]);
                mo = rootMo.getChildren(2, "WebServer", "", null);
                slots.put(mo[0].getLastRDN(), mo[0]);
            }
            Enumeration keys = slots.keys();
            while (keys.hasMoreElements()) {
                slotName = (String)keys.nextElement();
                this.availableSlotsTable.put(slotName, slots.get(slotName));
            }
            transaction.commit();
            transaction.end();
        }
        catch (CSException e) {
            this.error = e;
            try {
                transaction.rollback();
                transaction.end();
            }
            catch (CSException e1) {
                Log.logError((String)"Error rolling back transaction");
            }
            return;
        }
        TreeMap selectedSlots = (TreeMap)((TreeMap)this.getParameter("SLOT_LIST")).clone();
        for (Map.Entry elem : selectedSlots.entrySet()) {
            key = (String)elem.getKey();
            this.availableSlotsTable.remove(key);
            this.selectedSlotsTable.put(key, elem.getValue());
        }
    }

    public void actionPerformed(ActionEvent event) {
        JList availableSlotsList = (JList)this.view.availableSlots.getFieldComponent();
        JList selectedSlotsList = (JList)this.view.selectedSlots.getFieldComponent();
        if (event.getActionCommand().equals("ENTRYFIELD_FILLEDIN")) {
            if (availableSlotsList.hasFocus()) {
                selectedSlotsList.clearSelection();
                this.view.shiftRightButton.setEnabled(true);
                this.view.shiftLeftButton.setEnabled(false);
            } else if (selectedSlotsList.hasFocus()) {
                availableSlotsList.clearSelection();
                this.view.shiftRightButton.setEnabled(false);
                this.view.shiftLeftButton.setEnabled(true);
            }
        } else if (event.getActionCommand().equals("SHIFT_RIGHT")) {
            Object[] selectedItems = availableSlotsList.getSelectedValues();
            if (this.selectionMode == 0) {
                Object[] selectedSlots = new Object[this.selectedSlotsTable.size()];
                this.removeFromSelectedItems(this.selectedSlotsTable.keySet().toArray());
            }
            this.addToSelectedItems(selectedItems);
            this.view.applyButton.setEnabled(this.canDismiss());
            this.view.okButton.setEnabled(this.canDismiss());
        } else if (event.getActionCommand().equals("SHIFT_ALL_RIGHT")) {
            Iterator allSlots = this.availableSlotsTable.keySet().iterator();
            Object[] selectedItems = new Object[this.availableSlotsTable.size()];
            for (int i = 0; i < selectedItems.length; ++i) {
                selectedItems[i] = allSlots.next();
            }
            this.addToSelectedItems(selectedItems);
            this.setSelections(1);
            this.view.applyButton.setEnabled(this.canDismiss());
            this.view.okButton.setEnabled(this.canDismiss());
        } else if (event.getActionCommand().equals("SHIFT_LEFT")) {
            Object[] selectedItems = selectedSlotsList.getSelectedValues();
            this.removeFromSelectedItems(selectedItems);
            this.view.applyButton.setEnabled(this.canDismiss());
            this.view.okButton.setEnabled(this.canDismiss());
        } else if (event.getActionCommand().equals("SHIFT_ALL_LEFT")) {
            boolean count = false;
            Object[] selectedItems = new Object[this.selectedSlotsTable.size()];
            this.removeFromSelectedItems(this.selectedSlotsTable.keySet().toArray());
            this.view.applyButton.setEnabled(this.canDismiss());
            this.view.okButton.setEnabled(this.canDismiss());
        } else if (event.getActionCommand().equals("APPLY")) {
            if (this.askTheUserToConfirm() == 0) {
                this.updateTables();
                this.view.applyButton.setEnabled(false);
                this.notifyAll(new ActionEvent(this, event.getID(), event.getActionCommand()));
            }
        } else if (event.getActionCommand().equals("OK")) {
            if (this.view.applyButton.isEnabled()) {
                if (this.askTheUserToConfirm() == 0) {
                    this.notifyAll(new ActionEvent(this, event.getID(), event.getActionCommand()));
                }
            } else {
                this.notifyAll(new ActionEvent(this, event.getID(), event.getActionCommand()));
            }
        } else if (event.getActionCommand().equals("CANCEL")) {
            this.notifyAll(new ActionEvent(this, event.getID(), event.getActionCommand()));
        }
    }

    public void enableApplyButton(boolean flag) {
        this.view.applyButton.setEnabled(flag);
    }

    private void updateTables() {
        String[] items = this.availableSlotsTable.keySet().toArray(new String[0]);
        this.view.availableSlots.removeAllItems();
        this.view.availableSlots.addItems(items);
        items = this.selectedSlotsTable.keySet().toArray(new String[0]);
        this.view.selectedSlots.removeAllItems();
        this.view.selectedSlots.addItems(items);
        ((JList)this.view.availableSlots.getFieldComponent()).setSelectionMode(this.selectionMode);
        ((JList)this.view.selectedSlots.getFieldComponent()).setSelectionMode(this.selectionMode);
    }

    private void setSelections(int type) {
        JList availableSlotsList = (JList)this.view.availableSlots.getFieldComponent();
        JList selectedSlotsList = (JList)this.view.selectedSlots.getFieldComponent();
        if (type == 2) {
            availableSlotsList.clearSelection();
            selectedSlotsList.clearSelection();
            this.view.shiftLeftButton.setEnabled(false);
            this.view.shiftRightButton.setEnabled(false);
        } else if (type == 0) {
            if (this.availableSlotsTable.size() > 0) {
                availableSlotsList.setSelectedIndex(1);
                selectedSlotsList.clearSelection();
                this.view.shiftLeftButton.setEnabled(false);
                this.view.shiftRightButton.setEnabled(true);
            } else {
                this.view.shiftLeftButton.setEnabled(false);
                this.view.shiftRightButton.setEnabled(false);
            }
        } else if (type == 1) {
            if (this.selectedSlotsTable.size() > 0) {
                selectedSlotsList.setSelectedIndex(1);
                availableSlotsList.clearSelection();
                this.view.shiftLeftButton.setEnabled(true);
                this.view.shiftRightButton.setEnabled(false);
            } else {
                this.view.shiftLeftButton.setEnabled(false);
                this.view.shiftRightButton.setEnabled(false);
            }
        }
    }

    public void setSelectionMode(int selectionMode, boolean mandatory) {
        this.selectionMode = selectionMode;
        this.selectionMandatory = mandatory;
        ((JList)this.view.availableSlots.getFieldComponent()).setSelectionMode(selectionMode);
        ((JList)this.view.selectedSlots.getFieldComponent()).setSelectionMode(selectionMode);
    }

    public boolean canDismiss() {
        boolean retVal = true;
        if (this.selectionMandatory && this.selectedSlotsTable.isEmpty()) {
            retVal = false;
        } else if (this.selectionMode == 0 && this.selectedSlotsTable.size() > 1) {
            retVal = false;
        }
        return retVal;
    }

    public TreeMap getSelectedSlots() {
        return (TreeMap)this.selectedSlotsTable.clone();
    }

    public void setSelectedSlots(TreeMap selection) {
        this.selectedSlotsTable.clear();
        this.selectedSlotsTable.putAll(selection);
        this.updateTables();
    }

    private void addToSelectedItems(Object[] selection) {
        int numberOfItems = selection.length;
        MOProxy slot = null;
        String slotName = null;
        for (int i = 0; i < numberOfItems; ++i) {
            slotName = (String)selection[i];
            slot = (MOProxy)this.availableSlotsTable.get(slotName);
            this.selectedSlotsTable.put(slotName, slot);
            this.availableSlotsTable.remove(slotName);
        }
        this.updateTables();
    }

    private void removeFromSelectedItems(Object[] selection) {
        int numberOfItems = selection.length;
        MOProxy slot = null;
        String slotName = null;
        for (int i = 0; i < numberOfItems; ++i) {
            slotName = (String)selection[i];
            slot = (MOProxy)this.selectedSlotsTable.get(slotName);
            this.availableSlotsTable.put(slotName, slot);
            this.selectedSlotsTable.remove(slotName);
        }
        this.updateTables();
    }

    public void setDialogMessage(String mesg) {
        this.dialogMessage = mesg;
    }

    private int askTheUserToConfirm() {
        return this.showConfirmDialog(this.dialogMessage, null, "SOFTWARE_ALLOCATIONS", null, 0, 3, null);
    }
}

