/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.emas.sm.applications;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.TreeMap;
import java.util.Vector;
import javax.swing.JList;
import javax.swing.JTextField;
import se.ericsson.cello.emas.sm.applications.FanSelectController;
import se.ericsson.cello.emas.sm.applications.FanSelectView;
import se.ericsson.cello.emas.sm.applications.RepertoireSelectController;
import se.ericsson.cello.emas.sm.applications.RepertoireSelectView;
import se.ericsson.cello.emas.sm.applications.SlotSelectController;
import se.ericsson.cello.emas.sm.applications.SlotSelectView;
import se.ericsson.cello.emas.sm.applications.SoftwareAllocationPropertiesView;
import se.ericsson.cello.emas.sm.services.FanNameFactory;
import se.ericsson.cello.emas.sm.services.SlotNameFactory;
import se.ericsson.cello.support.gui.guilib.comp.Log;
import se.ericsson.cello.support.gui.guilib.infra.AbstractApplicationController;
import se.ericsson.cello.support.proxy.CSException;
import se.ericsson.cello.support.proxy.MOProxy;
import se.ericsson.cello.support.proxy.NameValue;
import se.ericsson.cello.support.proxy.Transaction;

public class SoftwareAllocationPropertiesController
extends AbstractApplicationController
implements ActionListener,
KeyListener {
    private SoftwareAllocationPropertiesView view;
    private MOProxy swAllocationMO = null;
    private MOProxy swManagementMO = null;
    private JList repList;
    private JList slotList;
    private JList fanList;
    private Vector slotVector;
    private Vector fanVector;
    private TreeMap repertoireTable = new TreeMap();
    private TreeMap slotTable = new TreeMap();
    private TreeMap fanTable = new TreeMap();
    private SlotSelectController slotSelectController = null;
    private RepertoireSelectController repertoireSelectController = null;
    private FanSelectController fanSelectController = null;
    protected Exception exception = null;
    private SlotDialogListener slotListener = new SlotDialogListener();
    private FanDialogListener fanListener = new FanDialogListener();
    private boolean somethingChanged = false;
    private RepertoireDialogListener repertoireListener = new RepertoireDialogListener();

    protected void init() {
        String title;
        this.view = (SoftwareAllocationPropertiesView)this.getView();
        this.setButtonListeners();
        this.setActionListeners();
        this.getSoftwareAllocationProperties();
        this.view.softwareAllocationField.requestFocus();
        if (this.getParameter("LDNLIST") == null) {
            this.view.okButton.setEnabled(false);
            title = "ADD_SWALLOCATION_TITLE";
        } else {
            title = "SOFTWARE_ALLOCATION_PROPERTIES_TITLE";
            this.view.okButton.setEnabled(true);
        }
        this.getApplication().setTitle(title, null);
        this.view.removeRepositoryButton.setEnabled(false);
        this.view.removeSlotButton.setEnabled(false);
        this.view.removeFanButton.setEnabled(false);
    }

    protected void beforeVisible() {
        this.view.setToolTipsOnLabels();
    }

    protected void afterVisible() {
        if (this.exception != null) {
            this.reportException(this.exception, "ERROR_GET", null);
            this.getApplication().stopApplication();
        }
    }

    protected void getSoftwareAllocationProperties() {
        Transaction transaction = null;
        try {
            String ldn = (String)this.getParameter("LDNLIST");
            if (ldn != null) {
                int i;
                transaction = new Transaction();
                this.swAllocationMO = new MOProxy(ldn);
                String value = (String)this.swAllocationMO.getAttribute("role", transaction.session);
                this.view.softwareAllocationField.setValue(value);
                this.view.ldn.setValue(this.swAllocationMO.getDN());
                this.view.ldn.setVisible(true);
                MOProxy[] repertoireListMo = (MOProxy[])this.swAllocationMO.getAttribute("repertoireList", transaction.session);
                String[] repArray = new String[repertoireListMo.length];
                for (int i2 = 0; i2 < repertoireListMo.length; ++i2) {
                    repArray[i2] = (String)repertoireListMo[i2].getAttribute("name", transaction.session);
                    this.repertoireTable.put(repArray[i2], repertoireListMo[i2]);
                }
                this.slotVector = new Vector(0, 1);
                this.fanVector = new Vector(0, 1);
                MOProxy[] slotListMo = (MOProxy[])this.swAllocationMO.getAttribute("slotList", transaction.session);
                for (int i3 = 0; i3 < slotListMo.length; ++i3) {
                    if (slotListMo[i3].getType().equals("Fan")) {
                        this.fanVector.add(slotListMo[i3]);
                        continue;
                    }
                    this.slotVector.add(slotListMo[i3]);
                }
                if (this.slotVector.size() != 0) {
                    MOProxy[] slotArrayMos = this.slotVector.toArray(new MOProxy[0]);
                    String[] slotArray = new String[slotArrayMos.length];
                    for (i = 0; i < slotArrayMos.length; ++i) {
                        slotArray[i] = SlotNameFactory.getSlotName(slotArrayMos[i]);
                        this.slotTable.put(slotArray[i], slotArrayMos[i]);
                    }
                }
                if (this.fanVector.size() != 0) {
                    MOProxy[] fanArrayMos = this.fanVector.toArray(new MOProxy[0]);
                    String[] fanArray = new String[fanArrayMos.length];
                    for (i = 0; i < fanArrayMos.length; ++i) {
                        fanArray[i] = FanNameFactory.getFanName(fanArrayMos[i]);
                        this.fanTable.put(fanArray[i], fanArrayMos[i]);
                    }
                }
                transaction.commit();
                transaction.end();
                this.updateTables();
            }
            this.swManagementMO = MOProxy.getRoot().getChildren(1, "SwManagement", "")[0];
        }
        catch (CSException e) {
            this.exception = e;
            try {
                if (transaction != null) {
                    transaction.rollback();
                    transaction.end();
                }
            }
            catch (CSException be) {
                Log.logError((String)"Error in rollback transaction", (Throwable)be);
            }
        }
    }

    private void setButtonListeners() {
        this.view.editListButtonRepertoire.setActionListener((ActionListener)this, "EDIT_LIST_BUTTON_REPERTOIRE");
        this.view.editListButtonSlot.setActionListener((ActionListener)this, "EDIT_LIST_BUTTON_SLOT");
        this.view.editListButtonFan.setActionListener((ActionListener)this, "EDIT_LIST_BUTTON_FAN");
        this.view.removeRepositoryButton.setActionListener((ActionListener)this, "REMOVE_REPOSITORY_BUTTON");
        this.view.removeSlotButton.setActionListener((ActionListener)this, "REMOVE_SLOT_BUTTON");
        this.view.removeFanButton.setActionListener((ActionListener)this, "REMOVE_FAN_BUTTON");
        this.view.okButton.setActionListener((ActionListener)this, "OK");
        this.view.applyButton.setActionListener((ActionListener)this, "APPLY");
        this.view.cancelButton.setActionListener((ActionListener)this, "CANCEL");
    }

    private void setActionListeners() {
        this.view.repertoireList.setActionListener((ActionListener)this, "REPERTOIRE_LIST_CHANGED");
        this.view.slotList.setActionListener((ActionListener)this, "SLOT_LIST_CHANGED");
        this.view.fanList.setActionListener((ActionListener)this, "FAN_LIST_CHANGED");
        this.view.softwareAllocationField.setActionListener((ActionListener)this, "SWA_ROLE_CHANGED");
        ((JTextField)this.view.softwareAllocationField.getFieldComponent()).addKeyListener(this);
    }

    public void actionPerformed(ActionEvent event) {
        this.repList = (JList)this.view.repertoireList.getFieldComponent();
        this.slotList = (JList)this.view.slotList.getFieldComponent();
        this.fanList = (JList)this.view.fanList.getFieldComponent();
        if (event.getActionCommand().equals("ENTRYFIELD_FILLEDIN")) {
            if (this.repList.hasFocus()) {
                Object selections = this.repList.getSelectedValue();
                if (selections == null) {
                    this.view.removeRepositoryButton.setEnabled(false);
                } else {
                    this.view.removeRepositoryButton.setEnabled(true);
                }
            } else if (this.slotList.hasFocus()) {
                Object selections = this.slotList.getSelectedValue();
                if (selections == null) {
                    this.view.removeSlotButton.setEnabled(false);
                } else {
                    this.view.removeSlotButton.setEnabled(true);
                }
            } else if (this.fanList.hasFocus()) {
                Object selections = this.fanList.getSelectedValue();
                if (selections == null) {
                    this.view.removeFanButton.setEnabled(false);
                } else {
                    this.view.removeFanButton.setEnabled(true);
                }
            }
        } else if (event.getActionCommand().equals("EDIT_LIST_BUTTON_REPERTOIRE")) {
            Object[][] params = new Object[][]{{"LDNLIST", this.swManagementMO.getDN()}, {"REPERTOIRE_LIST", this.repertoireTable}};
            this.repertoireSelectController = (RepertoireSelectController)this.startDialog(false, "REPERTOIRE_SELECT_TITLE", null, RepertoireSelectView.class, RepertoireSelectController.class, params);
            this.repertoireSelectController.addActionListener(this.repertoireListener);
        } else if (event.getActionCommand().equals("EDIT_LIST_BUTTON_SLOT")) {
            Object[][] params = new Object[][]{{"SLOT_LIST", this.slotTable}, {"SWALLOCAATION_SLOTS", "SwAllocationSlots"}};
            this.slotSelectController = (SlotSelectController)this.startDialog(false, "SLOT_SELECT_TITLE", null, SlotSelectView.class, SlotSelectController.class, params);
            this.slotSelectController.addActionListener(this.slotListener);
            this.slotSelectController.setDialogMessage("CONFIRM_EDIT_SLOTS_SOFTWARE_ALLOCATION");
        } else if (event.getActionCommand().equals("EDIT_LIST_BUTTON_FAN")) {
            Object[][] params = new Object[][]{{"FAN_LIST", this.fanTable}};
            this.fanSelectController = (FanSelectController)this.startDialog(false, "FAN_SELECT_TITLE", null, FanSelectView.class, FanSelectController.class, params);
            this.fanSelectController.addActionListener(this.fanListener);
        } else if (event.getActionCommand().equals("REMOVE_REPOSITORY_BUTTON")) {
            this.removeRepertoires(this.repList);
            this.view.applyButton.setEnabled(this.canDismiss());
            this.view.removeRepositoryButton.setEnabled(false);
            this.somethingChanged = this.canDismiss();
        } else if (event.getActionCommand().equals("REMOVE_SLOT_BUTTON")) {
            this.removeSlots(this.slotList);
            this.view.applyButton.setEnabled(this.canDismiss());
            this.view.removeSlotButton.setEnabled(false);
            this.somethingChanged = this.canDismiss();
        } else if (event.getActionCommand().equals("REMOVE_FAN_BUTTON")) {
            this.removeFans(this.fanList);
            this.view.applyButton.setEnabled(this.canDismiss());
            this.view.removeFanButton.setEnabled(false);
            this.somethingChanged = this.canDismiss();
        } else if (event.getActionCommand().equals("OK")) {
            if (this.canDismiss() && this.updateSoftwareAllocationProperties()) {
                this.getApplication().stopApplication();
            }
        } else if (event.getActionCommand().equals("APPLY")) {
            if (this.canDismiss()) {
                if (this.updateSoftwareAllocationProperties()) {
                    this.view.applyButton.setEnabled(false);
                    this.somethingChanged = false;
                }
            } else {
                this.view.softwareAllocationField.requestFocus();
            }
        } else if (event.getActionCommand().equals("CANCEL")) {
            this.getApplication().stopApplication();
        } else if (event.getActionCommand().equals("SWA_ROLE_CHANGED")) {
            this.somethingChanged = true;
        } else {
            Log.trace((String)(this.getClass().getName() + "wrong event: " + event.getActionCommand()));
        }
    }

    private boolean updateSoftwareAllocationProperties() {
        boolean success = true;
        if (this.somethingChanged) {
            String role = this.view.softwareAllocationField.getValue();
            Transaction transaction = null;
            try {
                transaction = new Transaction();
                if (this.swAllocationMO != null) {
                    this.swAllocationMO.setAttribute("role", (Object)role, transaction.session);
                } else {
                    this.swAllocationMO = this.createSwAllocation(role, transaction);
                }
                this.swAllocationMO.action("deleteAllRepertoires", new NameValue[0], transaction.session);
                NameValue[] nameValue = new NameValue[1];
                MOProxy[] reps = this.repertoireTable.values().toArray(new MOProxy[0]);
                nameValue[0] = new NameValue("param", (Object)reps);
                this.swAllocationMO.action("addRepertoires", nameValue, transaction.session);
                this.swAllocationMO.action("deleteAllSlots", new NameValue[0], transaction.session);
                Vector collection = new Vector(this.slotTable.values());
                for (Object obj : this.fanTable.values()) {
                    collection.addElement(obj);
                }
                MOProxy[] moList = collection.toArray(new MOProxy[0]);
                nameValue[0] = new NameValue("param", (Object)moList);
                this.swAllocationMO.action("addSlots", nameValue, transaction.session);
                transaction.commit();
                transaction.end();
            }
            catch (CSException e) {
                success = false;
                this.exception = e;
                try {
                    transaction.rollback();
                    transaction.end();
                }
                catch (CSException be) {
                    Log.logError((String)"Error in rollback transaction", (Throwable)be);
                }
                this.reportException((Exception)((Object)e), "ERROR_SET", null);
            }
        }
        return success;
    }

    private void removeRepertoires(JList repList) {
        Object[] selections = repList.getSelectedValues();
        if (selections != null) {
            for (int i = 0; i < selections.length; ++i) {
                this.repertoireTable.remove((String)selections[i]);
            }
            this.updateTables();
        }
    }

    private void removeSlots(JList slotList) {
        Object[] selections = slotList.getSelectedValues();
        if (selections != null) {
            for (int i = 0; i < selections.length; ++i) {
                this.slotTable.remove((String)selections[i]);
            }
            this.updateTables();
        }
    }

    private void removeFans(JList fanList) {
        Object[] selections = fanList.getSelectedValues();
        if (selections != null) {
            for (int i = 0; i < selections.length; ++i) {
                this.fanTable.remove((String)selections[i]);
            }
            this.updateTables();
        }
    }

    private void updateTables() {
        String[] items = this.repertoireTable.keySet().toArray(new String[0]);
        this.view.repertoireList.removeAllItems();
        this.view.repertoireList.addItems(items);
        items = this.slotTable.keySet().toArray(new String[0]);
        this.view.slotList.removeAllItems();
        this.view.slotList.addItems(items);
        items = this.fanTable.keySet().toArray(new String[0]);
        this.view.fanList.removeAllItems();
        this.view.fanList.addItems(items);
    }

    public void setSelectedRepertoires(TreeMap selectedRepertoires) {
        this.repertoireTable = selectedRepertoires;
        String[] items = this.repertoireTable.keySet().toArray(new String[0]);
        this.view.repertoireList.removeAllItems();
        this.view.repertoireList.addItems(items);
        this.somethingChanged = true;
    }

    public void setSelectedSlots(TreeMap selectedSlots) {
        this.slotTable = selectedSlots;
        String[] items = this.slotTable.keySet().toArray(new String[0]);
        this.view.slotList.removeAllItems();
        this.view.slotList.addItems(items);
        this.somethingChanged = true;
    }

    public void setSelectedFans(TreeMap selectedFans) {
        this.fanTable = selectedFans;
        String[] items = this.fanTable.keySet().toArray(new String[0]);
        this.view.fanList.removeAllItems();
        this.view.fanList.addItems(items);
        this.somethingChanged = true;
    }

    public boolean canStop() {
        return true;
    }

    private MOProxy createSwAllocation(String roleName, Transaction transaction) throws CSException {
        String ldn = MOProxy.genLDN((String)this.swManagementMO.getDN(), (String)"SwAllocation");
        MOProxy swa = new MOProxy(ldn);
        NameValue[] createArgs = new NameValue[]{new NameValue("role", (Object)roleName)};
        swa.create(createArgs, transaction.session);
        return swa;
    }

    private boolean canDismiss() {
        return this.view.softwareAllocationField.isFilledIn();
    }

    public void keyPressed(KeyEvent event) {
    }

    public void keyTyped(KeyEvent event) {
    }

    public void keyReleased(KeyEvent event) {
        this.view.applyButton.setEnabled(this.canDismiss());
        this.view.okButton.setEnabled(this.canDismiss());
    }

    private class RepertoireDialogListener
    implements ActionListener {
        private RepertoireDialogListener() {
        }

        public void actionPerformed(ActionEvent event) {
            if ("OK".equals(event.getActionCommand())) {
                SoftwareAllocationPropertiesController.this.setSelectedRepertoires(SoftwareAllocationPropertiesController.this.repertoireSelectController.getSelectedRepertoires());
                SoftwareAllocationPropertiesController.this.repertoireSelectController.stopDialog();
                ((SoftwareAllocationPropertiesController)SoftwareAllocationPropertiesController.this).view.applyButton.setEnabled(true);
                ((SoftwareAllocationPropertiesController)SoftwareAllocationPropertiesController.this).view.removeSlotButton.setEnabled(false);
                ((SoftwareAllocationPropertiesController)SoftwareAllocationPropertiesController.this).view.removeRepositoryButton.setEnabled(false);
                ((SoftwareAllocationPropertiesController)SoftwareAllocationPropertiesController.this).view.removeFanButton.setEnabled(false);
            } else if ("APPLY".equals(event.getActionCommand())) {
                SoftwareAllocationPropertiesController.this.setSelectedRepertoires(SoftwareAllocationPropertiesController.this.repertoireSelectController.getSelectedRepertoires());
                ((SoftwareAllocationPropertiesController)SoftwareAllocationPropertiesController.this).view.applyButton.setEnabled(true);
            } else if ("CANCEL".equals(event.getActionCommand())) {
                SoftwareAllocationPropertiesController.this.repertoireSelectController.stopDialog();
            } else if ("ERROR".equals(event.getActionCommand())) {
                SoftwareAllocationPropertiesController.this.repertoireSelectController.stopDialog();
            }
        }
    }

    private class FanDialogListener
    implements ActionListener {
        private FanDialogListener() {
        }

        public void actionPerformed(ActionEvent event) {
            if ("OK".equals(event.getActionCommand())) {
                if (SoftwareAllocationPropertiesController.this.fanSelectController.canDismiss()) {
                    SoftwareAllocationPropertiesController.this.setSelectedFans(SoftwareAllocationPropertiesController.this.fanSelectController.getSelectedFans());
                    SoftwareAllocationPropertiesController.this.fanSelectController.stopDialog();
                    ((SoftwareAllocationPropertiesController)SoftwareAllocationPropertiesController.this).view.applyButton.setEnabled(SoftwareAllocationPropertiesController.this.canDismiss());
                    ((SoftwareAllocationPropertiesController)SoftwareAllocationPropertiesController.this).view.removeFanButton.setEnabled(false);
                    ((SoftwareAllocationPropertiesController)SoftwareAllocationPropertiesController.this).view.removeRepositoryButton.setEnabled(false);
                    ((SoftwareAllocationPropertiesController)SoftwareAllocationPropertiesController.this).view.removeSlotButton.setEnabled(false);
                }
            } else if ("APPLY".equals(event.getActionCommand())) {
                SoftwareAllocationPropertiesController.this.setSelectedFans(SoftwareAllocationPropertiesController.this.fanSelectController.getSelectedFans());
                ((SoftwareAllocationPropertiesController)SoftwareAllocationPropertiesController.this).view.applyButton.setEnabled(false);
            } else if ("CANCEL".equals(event.getActionCommand())) {
                SoftwareAllocationPropertiesController.this.fanSelectController.stopDialog();
            }
            if ("ERROR".equals(event.getActionCommand())) {
                SoftwareAllocationPropertiesController.this.fanSelectController.stopDialog();
            }
        }
    }

    private class SlotDialogListener
    implements ActionListener {
        private SlotDialogListener() {
        }

        public void actionPerformed(ActionEvent event) {
            if ("OK".equals(event.getActionCommand())) {
                if (SoftwareAllocationPropertiesController.this.slotSelectController.canDismiss()) {
                    SoftwareAllocationPropertiesController.this.setSelectedSlots(SoftwareAllocationPropertiesController.this.slotSelectController.getSelectedSlots());
                    SoftwareAllocationPropertiesController.this.slotSelectController.stopDialog();
                    ((SoftwareAllocationPropertiesController)SoftwareAllocationPropertiesController.this).view.applyButton.setEnabled(SoftwareAllocationPropertiesController.this.canDismiss());
                    ((SoftwareAllocationPropertiesController)SoftwareAllocationPropertiesController.this).view.removeSlotButton.setEnabled(false);
                    ((SoftwareAllocationPropertiesController)SoftwareAllocationPropertiesController.this).view.removeRepositoryButton.setEnabled(false);
                    ((SoftwareAllocationPropertiesController)SoftwareAllocationPropertiesController.this).view.removeFanButton.setEnabled(false);
                }
            } else if ("APPLY".equals(event.getActionCommand())) {
                SoftwareAllocationPropertiesController.this.setSelectedSlots(SoftwareAllocationPropertiesController.this.slotSelectController.getSelectedSlots());
                ((SoftwareAllocationPropertiesController)SoftwareAllocationPropertiesController.this).view.applyButton.setEnabled(false);
            } else if ("CANCEL".equals(event.getActionCommand())) {
                SoftwareAllocationPropertiesController.this.slotSelectController.stopDialog();
            }
            if ("ERROR".equals(event.getActionCommand())) {
                SoftwareAllocationPropertiesController.this.slotSelectController.stopDialog();
            }
        }
    }
}

