/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.emas.sm.elements;

import java.lang.reflect.Constructor;
import java.util.Properties;
import java.util.Vector;
import se.ericsson.cello.emas.sm.elements.EmasElementCreator;
import se.ericsson.cello.support.gui.AbstractViewElement;
import se.ericsson.cello.support.gui.guilib.comp.Log;
import se.ericsson.cello.support.mgr.AttributeBuffer;
import se.ericsson.cello.support.mgr.EmasViewElement;
import se.ericsson.cello.support.mgr.EmasViewElementInterface;
import se.ericsson.cello.support.mgr.MOComposite;
import se.ericsson.cello.support.proxy.CSException;
import se.ericsson.cello.support.proxy.MOProxy;
import se.ericsson.cello.support.proxy.NameValue;

public class RPUSlotElementCreator
extends EmasElementCreator {
    private MOProxy rpuMO;

    public RPUSlotElementCreator(Properties p) {
        super(p);
    }

    public AbstractViewElement[] createInstances(AbstractViewElement aParent) {
        EmasViewElementInterface parentElement = (EmasViewElementInterface)aParent;
        this.rpuMO = ((EmasViewElement)parentElement).getMO("ReliableProgramUniter");
        String dn = this.rpuMO.getDN();
        if (this.parentElements.containsKey(dn)) {
            Log.trace((String)"Parent already registered.");
        } else {
            this.parentElements.put(dn, parentElement);
            this.rpuMO.addMOListener((MOProxy.MOListener)this);
            Log.trace((String)("addMOListener to LDN=" + dn));
        }
        MOProxy slot = null;
        Vector<EmasViewElementInterface> newElements = new Vector<EmasViewElementInterface>();
        EmasViewElementInterface newElement = null;
        try {
            String[] moAttributes = new String[]{"admActiveSlot", "admPassiveSlot"};
            Object[] moValues = null;
            moValues = this.rpuMO.getAttributes(moAttributes, null);
            AttributeBuffer bufferValues = new AttributeBuffer(moAttributes, moValues);
            slot = (MOProxy)bufferValues.getAttribute("admActiveSlot");
            if (slot != null && (newElement = this.createSlotElement(slot)) != null) {
                newElements.addElement(newElement);
            }
            if ((slot = (MOProxy)bufferValues.getAttribute("admPassiveSlot")) != null && slot.getDN() != null && (newElement = this.createSlotElement(slot)) != null) {
                newElements.addElement(newElement);
            }
        }
        catch (CSException e) {
            Log.logError((String)(((Object)((Object)this)).getClass().getName() + "::createInstances failed"), (Throwable)e);
            return newElements.toArray(new AbstractViewElement[0]);
        }
        return newElements.toArray(new AbstractViewElement[0]);
    }

    public void attributesChanged(MOProxy anMO, NameValue[] nameValue) {
        EmasViewElementInterface newElement = null;
        boolean updateNeeded = false;
        try {
            for (int j = 0; j < nameValue.length; ++j) {
                if (!nameValue[j].name.equals("admActiveSlot") && !nameValue[j].name.equals("admPassiveSlot")) continue;
                updateNeeded = true;
            }
            if (updateNeeded) {
                AbstractViewElement parentVe = (AbstractViewElement)this.parentElements.get(anMO.getDN());
                AbstractViewElement[] children = parentVe.getChildren();
                for (int i = 0; i < children.length; ++i) {
                    parentVe.removeChild(children[i]);
                    this.deleteElement((EmasViewElementInterface)children[i]);
                }
                MOProxy slot = (MOProxy)anMO.getAttribute("admActiveSlot", null);
                if (slot != null && (newElement = this.createSlotElement(slot)) != null) {
                    parentVe.addChild((AbstractViewElement)newElement);
                    this.addElement(newElement);
                }
                if ((slot = (MOProxy)anMO.getAttribute("admPassiveSlot", null)) != null && slot.getDN() != null && (newElement = this.createSlotElement(slot)) != null) {
                    parentVe.addChild((AbstractViewElement)newElement);
                    this.addElement(newElement);
                }
            }
        }
        catch (Exception e) {
            Log.logError((String)"update failed", (Throwable)e);
        }
    }

    private EmasViewElementInterface createSlotElement(MOProxy aSlot) {
        EmasViewElementInterface newElement = null;
        try {
            MOComposite moc = new MOComposite();
            moc.add(aSlot);
            Object[] args = new Object[]{moc, this.getProperties(), this};
            Class<?> c = Class.forName(this.getClassName());
            Vector v = new Vector();
            for (int i = 0; i < args.length; ++i) {
                v.add(args[i].getClass());
            }
            Constructor<?> constructor = c.getConstructor(v.toArray(new Class[0]));
            newElement = (EmasViewElementInterface)constructor.newInstance(args);
            this.addElement(newElement);
        }
        catch (Exception e) {
            Log.logError((String)("Slot Element " + this.getClassName() + " could not be created"), (Throwable)e);
        }
        return newElement;
    }
}

