/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.ipsec;

import se.ericsson.cello.mao.IpAddress;
import se.ericsson.cello.mao.MoAttributeValidator;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.Struct;
import se.ericsson.cello.moframework.ValueOutOfRangeException;
import se.ericsson.cello.moframework.WrongAttributeTypeException;

public class IpSecAccountInfo {
    private String remoteHost = null;
    private String userID = null;
    private String password = null;

    public IpSecAccountInfo(Struct struct) throws MoAccessException {
        String[] stringArray = struct.getNames();
        if (stringArray.length != 3) {
            throw new ValueOutOfRangeException("Missing member in ipSecAccountInfo", "IpSec");
        }
        if (!(struct.getValue("password") instanceof String)) {
            throw new WrongAttributeTypeException("password", "IpSec");
        }
        MoAttributeValidator.validateForIllegalCharacters((String)"password", (String)((String)struct.getValue("password")), (String)"IpSec");
        this.password = (String)struct.getValue("password");
        if (!(struct.getValue("remoteHost") instanceof String)) {
            throw new WrongAttributeTypeException("remoteHost", "IpSec");
        }
        this.remoteHost = (String)struct.getValue("remoteHost");
        if (!(struct.getValue("userID") instanceof String)) {
            throw new WrongAttributeTypeException("userID", "IpSec");
        }
        this.userID = (String)struct.getValue("userID");
        this.check();
    }

    protected String getRemoteHost() {
        return this.remoteHost;
    }

    protected String getUserID() {
        return this.userID;
    }

    protected String getPassword() {
        return this.password;
    }

    private void check() throws MoAccessException {
        if (this.remoteHost == null) {
            throw new ValueOutOfRangeException("remoteHost String is NULL", "IpSec");
        }
        new IpAddress(this.remoteHost);
        if (this.userID == null || this.userID.length() > 21 || this.userID.length() < 1) {
            throw new ValueOutOfRangeException("userID String too long/empty", "IpSec");
        }
        if (this.password == null || this.password.length() > 21 || this.password.length() < 0) {
            throw new ValueOutOfRangeException("password String too long/empty", "IpSec");
        }
    }
}

