/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.ipsec;

import se.ericsson.cello.equipment.PiuUtils;
import se.ericsson.cello.indications.fropxy.MaoFroIndicationHandler;
import se.ericsson.cello.ipsec.IkePeerMo;
import se.ericsson.cello.ipsec.IpSecMo;
import se.ericsson.cello.ipsec.IpSecTunnelMoGen;
import se.ericsson.cello.ipsec.StructChildSaTransformImpl;
import se.ericsson.cello.ipsec.StructTsIpAddressRangeImpl;
import se.ericsson.cello.ipsec.VpnInterfaceMo;
import se.ericsson.cello.iptransport.IpAccessHostEtMo;
import se.ericsson.cello.iptransport.IpInterfaceMo;
import se.ericsson.cello.iptransport.Ipv6InterfaceMo;
import se.ericsson.cello.mao.ConfigurationMismatchException;
import se.ericsson.cello.mao.GetRequestContext;
import se.ericsson.cello.mao.IllegalAttributeValueException;
import se.ericsson.cello.mao.IpAddressValidation;
import se.ericsson.cello.mao.IpFormatException;
import se.ericsson.cello.mao.Ipv4AddressValidation;
import se.ericsson.cello.mao.Ipv6AddressValidation;
import se.ericsson.cello.mao.MoGenUtil;
import se.ericsson.cello.mao.SetRequestContext;
import se.ericsson.cello.maofro.framework.ArrayParameter;
import se.ericsson.cello.maofro.framework.FroProxy;
import se.ericsson.cello.maofro.framework.Parameter;
import se.ericsson.cello.maofro.framework.SignedIntParameter;
import se.ericsson.cello.maofro.framework.StringParameter;
import se.ericsson.cello.maofro.framework.StructParameter;
import se.ericsson.cello.moframework.AttrList;
import se.ericsson.cello.moframework.FroRequestFailedException;
import se.ericsson.cello.moframework.InitialMaoContext;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoCanNotBeCreatedException;
import se.ericsson.cello.moframework.MoData;
import se.ericsson.cello.moframework.MoNameAlreadyTakenException;
import se.ericsson.cello.moframework.Struct;
import se.ericsson.cello.transaction.Coordinator;

public class IpSecTunnelMoImpl
extends IpSecTunnelMoGen {
    public IpSecTunnelMoImpl(ManagedObject managedObject, AttrList attrList, String string, Coordinator coordinator, InitialMaoContext initialMaoContext, FroProxy froProxy, MaoFroIndicationHandler maoFroIndicationHandler) throws MoAccessException {
        super(coordinator, managedObject, string, froProxy, initialMaoContext, attrList, maoFroIndicationHandler);
        ManagedObject managedObject2 = this.getIkePeerRef(coordinator);
        if (managedObject2 != null) {
            ManagedObject[] managedObjectArray = ((IkePeerMo)managedObject2).getReservedBy(coordinator);
            ManagedObject managedObject3 = null;
            ManagedObject managedObject4 = null;
            ManagedObject managedObject5 = null;
            for (int i = 0; i < managedObjectArray.length; ++i) {
                managedObject5 = (ManagedObject)managedObjectArray[i].getAttribute("vpnInterfaceRef", coordinator);
                if (i == 0) {
                    managedObject3 = (ManagedObject)managedObject5.getAttribute("ipAccessHostEtRef", coordinator);
                    continue;
                }
                managedObject4 = (ManagedObject)managedObject5.getAttribute("ipAccessHostEtRef", coordinator);
                if (managedObject3.equals(managedObject4)) continue;
                throw new IllegalAttributeValueException("All IpSecTunnel MOs referring to the same IkePeer MO must refer to VpnInterface MOs that refer to the same IpAccessHostEt MO", "IpSecTunnel");
            }
        }
    }

    public IpSecTunnelMoImpl(MoData moData, InitialMaoContext initialMaoContext, FroProxy froProxy, MaoFroIndicationHandler maoFroIndicationHandler) throws MoNameAlreadyTakenException {
        super(moData, initialMaoContext, froProxy, maoFroIndicationHandler);
    }

    protected void onCreate(SetRequestContext setRequestContext) throws MoAccessException {
        int n;
        int n2;
        Coordinator coordinator = setRequestContext.getCoordinator();
        ManagedObject managedObject = (ManagedObject)setRequestContext.getAttributeFromRequest("vpnInterfaceRef");
        ManagedObject managedObject2 = (ManagedObject)setRequestContext.getAttributeFromRequest("ikePeerRef");
        IpAccessHostEtMo ipAccessHostEtMo = (IpAccessHostEtMo)((VpnInterfaceMo)managedObject).getIpAccessHostEtRef(coordinator);
        ManagedObject managedObject3 = ipAccessHostEtMo.getIpInterfaceMoRef(coordinator);
        String string = ((IkePeerMo)managedObject2).getPeerIpAddress(coordinator);
        if (Ipv4AddressValidation.isIpv4((String)string) && managedObject3 instanceof Ipv6InterfaceMo) {
            throw new MoCanNotBeCreatedException("IpSecTunnelMO cannot be created, if peerIpAddress in IkePeer MO is IPv4 address and outer IpAccessHostEt refers to Ipv6Interface ");
        }
        if (Ipv6AddressValidation.isIpv6((String)string) && managedObject3 instanceof IpInterfaceMo) {
            throw new MoCanNotBeCreatedException("IpSecTunnelMO cannot be created, if peerIpAddress in IkePeer MO is IPv6 address and outer IpAccessHostEt refers to IpInterface ");
        }
        if (managedObject3 instanceof IpInterfaceMo) {
            n2 = PiuUtils.findPiuParentFroId((ManagedObject)managedObject3);
            setRequestContext.addParameter(this.froProxy, (Parameter)new SignedIntParameter("piuRef", new Integer(n2)));
            setRequestContext.addParameter(this.froProxy, (Parameter)new SignedIntParameter("ipInterfaceRef", new Integer(((IpInterfaceMo)managedObject3).getFroId(coordinator))));
            setRequestContext.addParameter(this.froProxy, (Parameter)new SignedIntParameter("outerHostRef", new Integer(ipAccessHostEtMo.getFroId(coordinator))));
        } else if (managedObject3 instanceof Ipv6InterfaceMo) {
            ManagedObject managedObject4 = (ManagedObject)managedObject3.getAttribute("ethernetRef", coordinator);
            n = PiuUtils.findPiuParentFroId((ManagedObject)managedObject4);
            setRequestContext.addParameter(this.froProxy, (Parameter)new SignedIntParameter("piuRef", new Integer(n)));
            setRequestContext.addParameter(this.froProxy, (Parameter)new SignedIntParameter("ipInterfaceRef", new Integer(((Ipv6InterfaceMo)managedObject3).getFroId(coordinator))));
            setRequestContext.addParameter(this.froProxy, (Parameter)new SignedIntParameter("outerHostRef", new Integer(ipAccessHostEtMo.getFroId(coordinator))));
        } else {
            throw new MoCanNotBeCreatedException("IpSecTunnel");
        }
        n2 = ((IpSecMo)this.getParent()).getFroId(coordinator);
        setRequestContext.addParameter(this.froProxy, (Parameter)new SignedIntParameter("ipSecRef", new Integer(n2)));
        n2 = ((VpnInterfaceMo)managedObject).getFroId(coordinator);
        setRequestContext.addParameter(this.froProxy, (Parameter)new SignedIntParameter("vpnInterfaceRef", new Integer(n2)));
        setRequestContext.addParameter(this.froProxy, (Parameter)new StringParameter("ipSecTunnelId", this.getFullDistinguishedName()));
        n = ((VpnInterfaceMo)managedObject).getConfigurationMode(coordinator);
        setRequestContext.addParameter(this.froProxy, (Parameter)new SignedIntParameter("configurationMethod", new Integer(n)));
        int n3 = ((VpnInterfaceMo)managedObject).getIpVersion(coordinator);
        setRequestContext.addParameter(this.froProxy, (Parameter)new SignedIntParameter("ipVersion", new Integer(n3)));
        int n4 = ((VpnInterfaceMo)managedObject).getAutoDetectIpVersion(coordinator);
        setRequestContext.addParameter(this.froProxy, (Parameter)new SignedIntParameter("autoDetectIpVersion", new Integer(n4)));
    }

    protected void validateTsProtocols(int[] nArray, SetRequestContext setRequestContext) throws MoAccessException {
        super.validateTsProtocols(nArray, setRequestContext);
        MoGenUtil.checkArrayWithLength((Object)nArray, (String)"tsProtocols", (int)1, (int)1, (String)"IpSecTunnel");
    }

    protected void validateTsLocalIpAddressRanges(Struct[] structArray, SetRequestContext setRequestContext) throws MoAccessException {
        super.validateTsLocalIpAddressRanges(structArray, setRequestContext);
        Coordinator coordinator = setRequestContext.getCoordinator();
        ManagedObject managedObject = null;
        if (setRequestContext.isIncludedInRequest("vpnInterfaceRef")) {
            managedObject = (ManagedObject)setRequestContext.getAttributeFromRequest("vpnInterfaceRef");
            this.validateVpnInterfaceRef(managedObject, setRequestContext);
        } else {
            managedObject = this.getVpnInterfaceRef(coordinator);
        }
        int n = ((VpnInterfaceMo)managedObject).getAutoDetectIpVersion(coordinator);
        if (n == 0) {
            int n2 = ((VpnInterfaceMo)managedObject).getIpVersion(coordinator);
            this.validateIpVersionForTsRanges(structArray, n2);
        } else {
            this.validateIpAddressesForTsRanges(structArray);
        }
    }

    protected void validateTsRemoteIpAddressRanges(Struct[] structArray, SetRequestContext setRequestContext) throws MoAccessException {
        super.validateTsRemoteIpAddressRanges(structArray, setRequestContext);
        Coordinator coordinator = setRequestContext.getCoordinator();
        ManagedObject managedObject = null;
        if (setRequestContext.isIncludedInRequest("vpnInterfaceRef")) {
            managedObject = (ManagedObject)setRequestContext.getAttributeFromRequest("vpnInterfaceRef");
            this.validateVpnInterfaceRef(managedObject, setRequestContext);
        } else {
            managedObject = this.getVpnInterfaceRef(coordinator);
        }
        int n = ((VpnInterfaceMo)managedObject).getAutoDetectIpVersion(coordinator);
        if (n == 0) {
            int n2 = ((VpnInterfaceMo)managedObject).getIpVersion(coordinator);
            this.validateIpVersionForTsRanges(structArray, n2);
        } else {
            this.validateIpAddressesForTsRanges(structArray);
        }
    }

    private void validateIpAddressesForTsRanges(Struct[] structArray) throws MoAccessException {
        for (int i = 0; i < structArray.length; ++i) {
            Struct struct = structArray[i];
            String string = (String)struct.getValue("ipAddress");
            try {
                if (string.equals("")) {
                    throw new IllegalAttributeValueException("parameter ipAddress has illegal value=" + string, "IpSecTunnel");
                }
                IpAddressValidation.validate((String)string);
                continue;
            }
            catch (IpFormatException ipFormatException) {
                throw new IllegalAttributeValueException("parameter ipAddress has illegal value=" + string, "IpSecTunnel");
            }
        }
    }

    private void validateIpVersionForTsRanges(Struct[] structArray, int n) throws MoAccessException {
        boolean bl = false;
        for (int i = 0; i < structArray.length; ++i) {
            Struct struct = structArray[i];
            String string = (String)struct.getValue("ipAddress");
            if (!string.equals("")) {
                if (n == 1) {
                    if (!Ipv6AddressValidation.isValidIpv6Addres((String)string)) {
                        bl = true;
                    }
                } else if (!Ipv4AddressValidation.isValidIpv4Address((String)string)) {
                    bl = true;
                }
                if (!bl) continue;
                throw new IllegalAttributeValueException("The ipVersion of VpnInterface must match the ip version (ipv4/ipv6) for remote/local tsIpAddressRange and be a valid ip address", "IpSecTunnel");
            }
            throw new IllegalAttributeValueException("parameter ipAddress has illegal value=" + string, "IpSecTunnel");
        }
    }

    protected void handleSetAllowedTransforms(Struct[] structArray, SetRequestContext setRequestContext) throws MoAccessException {
        setRequestContext.addParameter(this.froProxy, (Parameter)StructChildSaTransformImpl.toArrayParameter(structArray, "IpSecTunnel", "allowedTransforms", 10));
    }

    protected Object handleGetAllowedTransforms(GetRequestContext getRequestContext) throws MoAccessException {
        ArrayParameter arrayParameter = (ArrayParameter)getRequestContext.getParameter("allowedTransforms");
        if (arrayParameter == null) {
            throw new FroRequestFailedException("IpSecTunnel", "Missing parameter from FRO: allowedTransforms", "getAttributes", -1);
        }
        ArrayParameter arrayParameter2 = new ArrayParameter("allowedTransforms");
        for (int i = 0; i < arrayParameter.size(); ++i) {
            StructParameter structParameter = new StructParameter("securityAssociationsElement");
            StructParameter structParameter2 = (StructParameter)arrayParameter.get(i);
            for (int j = 0; j < structParameter2.size(); ++j) {
                structParameter.add(structParameter2.get(j));
            }
            arrayParameter2.add((Parameter)structParameter);
        }
        return StructChildSaTransformImpl.toStructArray(arrayParameter2);
    }

    protected Object handleGetTsRemoteIpAddressRanges(GetRequestContext getRequestContext) throws MoAccessException {
        ArrayParameter arrayParameter = (ArrayParameter)getRequestContext.getParameter("tsRemoteIpAddressRanges");
        if (arrayParameter == null) {
            throw new FroRequestFailedException("IpSecTunnel", "Missing parameter from FRO: tsRemoteIpAddressRanges", "getAttributes", -1);
        }
        ArrayParameter arrayParameter2 = new ArrayParameter("tsRemoteIpAddressRanges");
        for (int i = 0; i < arrayParameter.size(); ++i) {
            StructParameter structParameter = new StructParameter("tsLocalIpAddressRangesElement");
            StructParameter structParameter2 = (StructParameter)arrayParameter.get(i);
            for (int j = 0; j < structParameter2.size(); ++j) {
                structParameter.add(structParameter2.get(j));
            }
            arrayParameter2.add((Parameter)structParameter);
        }
        return StructTsIpAddressRangeImpl.toStructArray(arrayParameter2);
    }

    protected void handleSetTsRemoteIpAddressRanges(Struct[] structArray, SetRequestContext setRequestContext) throws MoAccessException {
        if (structArray.length > 25) {
            throw new ConfigurationMismatchException("tsRemoteIpAddressRanges", "IpSecTunnel");
        }
        ArrayParameter arrayParameter = new ArrayParameter("tsRemoteIpAddressRanges");
        for (int i = 0; i < structArray.length; ++i) {
            arrayParameter.add((Parameter)StructTsIpAddressRangeImpl.toStructParameter(structArray[i], "IpSecTunnel", "tsLocalIpAddressRangesElement"));
        }
        setRequestContext.addParameter(this.froProxy, (Parameter)arrayParameter);
    }
}

