/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9.bluez.crypto;

import com.ibm.j9.bluez.crypto.BigInteger;
import com.ibm.j9.bluez.crypto.CL3Exception;

public class ASN1 {
    public static final int BIGINT = 1;
    public static final int BOOLEAN = 2;
    public static final int OIDSTR = 3;
    public static final int B8STR = 4;
    public static final int B16STR = 5;
    public static final int UTF8STR = 6;
    private static final int ANYSTR = 7;
    public static final int INTEGER = 8;
    public static final int APPSPEC = 100;
    public int mode;
    public byte[] data;
    public int tag;
    public int beg;
    public int len;
    public Object obj;

    public Object decodeObject() {
        if (this.mode == 7) {
            this.mode = this.tag == 30 ? 5 : (this.tag == 12 ? 6 : 4);
        }
        return ASN1.decodeObject(this.mode, this.data, this.beg, this.len);
    }

    /*
     * Unable to fully structure code
     */
    public static Object decodeObject(int mode, byte[] data, int off, int len) {
        obj = null;
        switch (mode) {
            case 3: {
                b = new StringBuffer(4 * len);
                if (len > 0) {
                    v = data[off] & 255;
                    b.append(v / 40L);
                    b.append('.');
                    b.append(v % 40L);
                    i = 1;
                    while (i < len) {
                        v = 0L;
                        do {
                            c = data[++off];
                            v = v << 7 | (long)(c & 127);
                        } while (++i < len && c < 0);
                        b.append('.');
                        b.append(v);
                    }
                }
                obj = b.toString();
                break;
            }
            case 2: {
                obj = data[off] == 0 ? new Boolean(true) : new Boolean(false);
                break;
            }
            case 8: {
                v = 0;
                len += off;
                while (off < len) {
                    v = (v << 8) + (data[off++] & 255);
                }
                obj = new Integer(v);
                break;
            }
            case 1: {
                b = new byte[len];
                System.arraycopy((Object)data, off, (Object)b, 0, len);
                obj = new BigInteger(1, b);
                break;
            }
            case 6: {
                b = new StringBuffer(len);
                len += off;
                while (off < len) {
                    c = data[off];
                    if (c >= 224) {
                        c = (c & 15) << 12 | (data[off + 1] & 63) << 6 | data[off + 2] & 63;
                        off += 3;
                    } else if (c >= 192 && c <= 240) {
                        c = (c & 31) << 6 | data[off + 1] & 63;
                        off += 2;
                    } else {
                        ++off;
                    }
                    b.append((char)c);
                }
                obj = b.toString();
                break;
            }
            case 4: 
            case 5: {
                b = new StringBuffer(len);
                len += off;
                if (mode != 4) ** GOTO lbl74
                while (off < len) {
                    b.append((char)(data[off++] & 255));
                }
                ** GOTO lbl75
lbl-1000:
                // 1 sources

                {
                    b.append((char)((data[off] & 255) << 8 | data[off + 1] & 255));
                    off += 2;
lbl74:
                    // 2 sources

                    ** while (off < len)
                }
lbl75:
                // 2 sources

                obj = b.toString();
            }
        }
        return obj;
    }

    public int encodeObject(byte[] data, int off) {
        return ASN1.encodeObject(this.mode, this.obj, data, off);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static int encodeObject(int mode, Object obj, byte[] data, int off) {
        switch (mode) {
            case 8: {
                int v = (Integer)obj;
                int end = off;
                while (v != 0) {
                    if (--off >= 0) {
                        data[off] = (byte)v;
                    }
                    v >>>= 8;
                }
                if (off != end && data[off] >= 0 || --off < 0) return off;
                data[off] = 0;
                return off;
            }
            case 1: {
                byte[] b = ((BigInteger)obj).toByteArray();
                if ((off -= b.length) < 0) return off;
                System.arraycopy((Object)b, 0, (Object)data, off, b.length);
                return off;
            }
            case 2: {
                if (--off < 0) return off;
                data[off] = (Boolean)obj != false ? -1 : 0;
                return off;
            }
            case 3: {
                String s = (String)obj;
                int b = 1;
                int v = 0;
                int l = s.length();
                while (--l >= 0) {
                    char c = s.charAt(l);
                    if (c == '.') {
                        if (b == 1) throw new CL3Exception(-2147483645);
                        b = 0;
                        while (v > 0) {
                            if (--off >= 0) {
                                data[off] = (byte)(v & 0x7F | b);
                            }
                            v >>= 7;
                            b = 128;
                        }
                        b = 1;
                        continue;
                    }
                    if (c < '0' || c > '9') throw new CL3Exception(-2147483645);
                    v += b * (c - 48);
                    b *= 10;
                }
                int n = off;
                data[n] = (byte)(data[n] + v * 40);
                return off;
            }
            case 6: {
                String s = (String)obj;
                int n = s.length();
                while (--n >= 0) {
                    int c = s.charAt(n) & 0xFFFF;
                    if (c <= 127) {
                        if (--off < 0) continue;
                        data[off] = (byte)c;
                        continue;
                    }
                    if (c <= 2047) {
                        if ((off -= 2) >= 0) {
                            data[off] = (byte)(0xC0 | c >> 6);
                        }
                        data[off + 1] = (byte)(0x80 | c & 0x3F);
                        continue;
                    }
                    if (c > 65535) continue;
                    if ((off -= 3) >= 0) {
                        data[off] = (byte)(0xE0 | c >> 12);
                    }
                    data[off + 1] = (byte)(0x80 | c >> 6 & 0x3F);
                    data[off + 2] = (byte)(0x80 | c & 0x3F);
                }
                return off;
            }
            case 4: 
            case 5: {
                String s = (String)obj;
                int n = s.length();
                while (--n >= 0) {
                    char c = s.charAt(n);
                    if (mode == 5 && --off >= 0) {
                        data[off] = (byte)(c >> 8);
                    }
                    if (--off < 0) continue;
                    data[off] = (byte)c;
                }
                return off;
            }
        }
        return off;
    }

    public void setData(byte[] data, int beg, int len) {
        this.data = data;
        this.beg = beg;
        this.len = len;
    }

    public ASN1(byte[] data) {
        this(data, 0, data.length);
    }

    public ASN1(byte[] data, int beg, int len) {
        this.setData(data, beg, len);
    }

    public ASN1(int mode, Object obj) {
        this.mode = mode;
        this.obj = obj;
    }

    public ASN1(int mode) {
        this.mode = mode;
    }

    public ASN1() {
        this.mode = 0;
    }

    public static String toHex(byte[] buf, int beg, int len) {
        len = len < 0 ? buf.length : len + beg;
        StringBuffer b = new StringBuffer(len * 2);
        while (beg < len) {
            b.append("0123456789ABCDEF".charAt(buf[beg] >> 4 & 0xF));
            b.append("0123456789ABCDEF".charAt(buf[beg++] & 0xF));
        }
        return b.toString();
    }

    public static byte[] toByteArray(String s) {
        byte[] b = new byte[s.length() / 2];
        int i = 0;
        while (i < b.length) {
            b[i] = (byte)(ASN1.hexDigit(s.charAt(2 * i)) << 4 | ASN1.hexDigit(s.charAt(2 * i + 1)));
            ++i;
        }
        return b;
    }

    private static int hexDigit(int c) {
        if (c >= 48 && c <= 57) {
            return c - 48;
        }
        if (c >= 65 && c <= 70) {
            return c - 55;
        }
        if (c >= 97 && c <= 102) {
            return c - 87;
        }
        return -1;
    }

    private static int rdLen(byte[] data, int off, int end, int[] poff) throws CL3Exception {
        if (end == 0) {
            end = data.length;
        }
        if ((off += 2) <= end) {
            int l = data[off - 1] & 0xFF;
            if (l == 128) {
                l = -off - 1;
            }
            if (l > 128) {
                int n = off;
                if ((off += l & 0x7F) <= end) {
                    l = 0;
                    while (n < off) {
                        l = l << 8 | data[n++] & 0xFF;
                    }
                }
            } else if (off + l <= end) {
                if (poff != null) {
                    poff[0] = off;
                }
                return off + l;
            }
        }
        throw new CL3Exception(-2147483627);
    }

    public static int cntElements(byte[] data, int off, int len) {
        int n = 0;
        int end = off + len;
        while (off < end) {
            off = ASN1.rdLen(data, off, end, null);
            ++n;
        }
        return n;
    }

    private static int format0(String format, int fbeg, int pos, byte[] buf, int off, ASN1[] args) {
        block44: {
            while (pos >= fbeg) {
                int n;
                int modifiers;
                int tag;
                block46: {
                    block47: {
                        ASN1 a;
                        block48: {
                            int mode;
                            int argIndex;
                            block45: {
                                int posNestEnd = -1;
                                int posNestBeg = -1;
                                argIndex = -1;
                                mode = 0;
                                tag = 0;
                                modifiers = 0;
                                char c = format.charAt(pos);
                                if (c == ')') {
                                    posNestEnd = pos - 1;
                                    n = 0;
                                    do {
                                        if ((c = format.charAt(pos--)) == ')') {
                                            ++n;
                                        } else if (c == '(') {
                                            --n;
                                        }
                                        if (pos <= fbeg) break block44;
                                    } while (n > 0);
                                    posNestBeg = pos + 2;
                                    c = format.charAt(pos);
                                } else {
                                    posNestEnd = -1;
                                }
                                if (c == ']') {
                                    while (pos >= fbeg) {
                                        c = format.charAt(pos - 1);
                                        if (c == '+') {
                                            modifiers |= 1;
                                        } else if (c == '&') {
                                            modifiers |= 8;
                                        } else if (c == 'b') {
                                            mode = 2;
                                        } else if (c == 'j') {
                                            mode = 8;
                                        } else if (c == 'i') {
                                            mode = 1;
                                        } else if (c == 'o') {
                                            mode = 3;
                                        } else if (c == 'a') {
                                            mode = 4;
                                        } else if (c == 'w') {
                                            mode = 5;
                                        } else {
                                            if (c != 'u') break;
                                            mode = 6;
                                        }
                                        --pos;
                                    }
                                    n = 1;
                                    while (--pos >= fbeg && (c = format.charAt(pos)) >= '0' && c <= '9') {
                                        argIndex = n * (c - 48);
                                        n *= 10;
                                    }
                                    if (pos <= fbeg || c != '[') break block44;
                                    c = format.charAt(--pos);
                                }
                                while (true) {
                                    if (c == '?') {
                                        modifiers |= 4;
                                    } else if (c == '@') {
                                        modifiers |= 2;
                                    } else if (c != ':') break;
                                    if (--pos > fbeg) {
                                        c = format.charAt(pos);
                                        continue;
                                    }
                                    break block44;
                                    break;
                                }
                                if (c == '*') {
                                    if (argIndex < 0) break block44;
                                    modifiers |= 0x10;
                                } else if (c == 'X') {
                                    if (argIndex < 0) break block44;
                                    tag = args[argIndex] == null ? -1 : args[argIndex].tag;
                                } else if (pos <= fbeg || (tag = ASN1.hexDigit(c) | ASN1.hexDigit(format.charAt(--pos)) << 4) < 0) break block44;
                                while (--pos >= fbeg && format.charAt(pos) == ' ') {
                                }
                                if ((modifiers & 4) != 0 && (argIndex < 0 || args[argIndex] == null || ((modifiers & 8) != 0 ? args[argIndex].obj : (Object)args[argIndex].data) == null)) continue;
                                n = off--;
                                if (posNestBeg < 0) break block45;
                                argIndex = -1;
                                off = ASN1.format0(format, posNestBeg, posNestEnd, buf, off, args);
                                break block46;
                            }
                            if (argIndex < 0) break block47;
                            a = args[argIndex];
                            if ((modifiers & 8) == 0) break block48;
                            if (mode != 0) {
                                a.mode = mode;
                            } else if (a.mode == 0) continue;
                            off = a.encodeObject(buf, off);
                            break block46;
                        }
                        if (a == null || a.data == null) continue;
                        if ((modifiers & 1) != 0) {
                            a.len = ASN1.rdLen(a.data, a.beg, 0, null) - a.beg;
                        }
                        if ((off -= a.len) < 0 || buf == a.data && off == a.beg) break block46;
                        System.arraycopy((Object)a.data, a.beg, (Object)buf, off, a.len);
                        break block46;
                    }
                    if (modifiers != 0 || off < 0) continue;
                    buf[off] = (byte)tag;
                    continue;
                }
                if ((modifiers & 0x11) != 0) continue;
                if ((n -= off) >= 128) {
                    int k = 128;
                    while (n > 0) {
                        if (--off >= 0) {
                            buf[off] = (byte)n;
                        }
                        n >>= 8;
                        ++k;
                    }
                    n = k;
                }
                if (--off >= 0) {
                    buf[off] = (byte)n;
                }
                if (--off < 0) continue;
                buf[off] = (byte)tag;
            }
            return off;
        }
        throw new CL3Exception(-2147483643);
    }

    public static int format(String format, byte[] buf, int off, ASN1[] args) {
        return ASN1.format0(format, 0, format.length() - 1, buf, off < 0 ? buf.length : off, args);
    }

    private static int scanIndefinite(byte[] to, int toOff, byte[] data, int[] pbeg, int end) {
        int i = 1;
        int j = pbeg[0];
        while (i > 0) {
            if (j + 2 > end) {
                throw new CL3Exception(-2147483627);
            }
            if (data[j] == 0 && data[j + 1] == 0) {
                --i;
                j += 2;
                continue;
            }
            if ((j = ASN1.rdLen(data, j, end, pbeg)) < 0) {
                j = pbeg[0];
                ++i;
                continue;
            }
            if (to == null) continue;
            System.arraycopy((Object)data, pbeg[0], (Object)to, toOff, j - pbeg[0]);
            toOff += j - pbeg[0];
        }
        pbeg[0] = j;
        return to == null ? j : toOff;
    }

    private static char getChar(String s, int pos) {
        return pos >= s.length() ? (char)'\u0000' : s.charAt(pos);
    }

    private static int scan0(char endChar, String fmt, int fpos, byte[] data, int dpos, int end, ASN1[] args, int[] pp) {
        block56: {
            block0: while (true) {
                char c;
                int argIndex = -1;
                int modifiers = 0;
                ASN1 arg = null;
                while ((c = ASN1.getChar(fmt, fpos++)) == ' ') {
                }
                if (c == '\u0000' || c == ')') {
                    if ((c ^ endChar) != 0) break;
                    if (dpos == end) {
                        return fpos;
                    }
                } else {
                    int i;
                    int tag;
                    if (c == '*') {
                        tag = -2;
                    } else if (c == 'X') {
                        tag = -1;
                    } else {
                        tag = ASN1.hexDigit(c) << 4 | ASN1.hexDigit(ASN1.getChar(fmt, fpos++));
                        if (tag < 0) break;
                    }
                    while (true) {
                        if ((c = ASN1.getChar(fmt, fpos++)) == '?') {
                            modifiers |= 4;
                            continue;
                        }
                        if (c == '@') {
                            modifiers |= 2;
                            continue;
                        }
                        if (c != ':') break;
                        modifiers |= 0x20;
                    }
                    if (c == '[') {
                        argIndex = 0;
                        while ((c = ASN1.getChar(fmt, fpos++)) >= '0' && c <= '9') {
                            argIndex = argIndex * 10 + c - 48;
                        }
                        arg = args[argIndex];
                        if (arg == null) {
                            arg = args[argIndex] = new ASN1();
                        }
                        args[argIndex].data = data;
                        while (true) {
                            if (c == '&') {
                                modifiers |= 8;
                            } else if (c == '+') {
                                modifiers |= 1;
                            } else {
                                if (c == ']') break;
                                if (c == 'b') {
                                    arg.mode = 2;
                                } else if (c == 'j') {
                                    arg.mode = 8;
                                } else if (c == 'i') {
                                    arg.mode = 1;
                                } else if (c == 'o') {
                                    arg.mode = 3;
                                } else if (c == 'a') {
                                    arg.mode = 4;
                                } else if (c == 'w') {
                                    arg.mode = 5;
                                } else if (c == 'u') {
                                    arg.mode = 6;
                                } else {
                                    if (c != 's') break block0;
                                    arg.mode = 7;
                                }
                            }
                            c = ASN1.getChar(fmt, fpos++);
                        }
                        c = ASN1.getChar(fmt, fpos++);
                    }
                    if (tag == -2) {
                        if (c != endChar) break;
                        if (arg != null) {
                            arg.beg = dpos;
                            arg.len = end - arg.beg;
                        }
                        return fpos;
                    }
                    if (c != '(') {
                        --fpos;
                    }
                    if (end != 0 && dpos + 1 > end || tag != -1 && tag != (data[dpos] & 0xFF)) {
                        if ((modifiers & 4) != 0) {
                            if (arg != null) {
                                arg.data = null;
                                arg.beg = -1;
                                arg.len = -1;
                                arg.tag = -1;
                            }
                            if (c != '(') continue;
                            i = 0;
                            while (true) {
                                if (i < 0) continue block0;
                                if ((c = ASN1.getChar(fmt, fpos++)) == ')') {
                                    --i;
                                    continue;
                                }
                                if (c == '(') {
                                    ++i;
                                    continue;
                                }
                                if (c == '\u0000') break block0;
                            }
                        }
                    } else {
                        if (tag == -1) {
                            tag = data[dpos] & 0xFF;
                        }
                        if ((modifiers & 0x26) == 0 && arg == null && c != '(') {
                            ++dpos;
                            continue;
                        }
                        int elem = dpos;
                        if ((dpos = ASN1.rdLen(data, dpos, end, pp)) < 0) {
                            if ((modifiers & 2) != 0) {
                                if (c != '(') {
                                    dpos = ASN1.scanIndefinite(null, 0, data, pp, end);
                                    if (arg == null) continue;
                                    arg.tag = tag;
                                    arg.beg = (modifiers & 1) != 0 ? elem : pp[0];
                                    arg.len = dpos - arg.beg - 2;
                                    continue;
                                }
                                i = ASN1.scanIndefinite(data, elem, data, pp, end);
                                if (arg != null) {
                                    arg.tag = tag;
                                    arg.beg = elem;
                                    arg.len = i - elem;
                                }
                                dpos = pp[0];
                                fpos = ASN1.scan0(')', fmt, fpos, data, elem, i, args, pp);
                                continue;
                            }
                        } else if (dpos <= end) {
                            if (arg != null) {
                                arg.tag = tag;
                                if ((modifiers & 1) != 0) {
                                    arg.beg = elem;
                                    arg.len = dpos - arg.beg;
                                } else {
                                    arg.beg = pp[0];
                                    arg.len = dpos - arg.beg;
                                }
                                if ((modifiers & 8) != 0 && arg.mode != 0) {
                                    arg.obj = arg.decodeObject();
                                }
                            }
                            if (c != '(') continue;
                            fpos = ASN1.scan0(')', fmt, fpos, data, pp[0], dpos, args, pp);
                            continue;
                        }
                    }
                }
                break block56;
                break;
            }
            throw new CL3Exception(-2147483643);
        }
        throw new CL3Exception(-2147483627);
    }

    public static int scan(String format, byte[] data, int beg, int len, ASN1[] args) {
        len = len < 0 ? ASN1.rdLen(data, beg, 0, null) : (len += beg);
        ASN1.scan0('\u0000', format, 0, data, beg, len, args, new int[1]);
        return len;
    }

    public int oidCRC() {
        int crc = 0;
        int i = this.beg;
        int e = i + this.len;
        while (i < e) {
            crc = (crc >>> 16) + crc * 61 + (this.data[i++] & 0xFF);
        }
        return crc;
    }
}

