/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.oti.connection.https;

import com.ibm.j9.ssl.Util;
import com.ibm.oti.security.provider.X500Principal;
import com.ibm.oti.security.provider.X509Certificate;
import com.ibm.oti.util.ASN1Decoder;
import com.ibm.oti.util.ASN1Exception;
import com.ibm.oti.util.Msg;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import javax.microedition.io.HttpsConnection;
import javax.microedition.io.SecurityInfo;
import javax.microedition.io.StreamConnection;

public class Connection
extends com.ibm.oti.connection.http.Connection
implements HttpsConnection {
    private com.ibm.oti.connection.ssl.Connection sslConnection = null;

    public SecurityInfo getSecurityInfo() throws IOException {
        if (this.isClosed()) {
            throw new IOException();
        }
        if (this.sslConnection == null) {
            super.connect();
        }
        return this.sslConnection.getSecurityInfo();
    }

    public String getProtocol() {
        return "https";
    }

    protected int getDefaultPort() {
        return 443;
    }

    protected StreamConnection openSocket(boolean timeout, String socketOptions) throws IOException {
        if (this.sslConnection != null) {
            return this.sslConnection;
        }
        String spec = "//" + this.getHostName() + ":" + this.getHostPort() + socketOptions;
        com.ibm.oti.connection.socket.Connection connection = new com.ibm.oti.connection.socket.Connection();
        connection.setParameters2(spec, 3, timeout);
        try {
            this.sslConnection = new com.ibm.oti.connection.ssl.Connection(connection, this.getHostName());
            this.verifyHostname();
        }
        catch (IOException e) {
            connection.close();
            throw e;
        }
        return this.sslConnection;
    }

    protected void verifyHostname() throws IOException {
        String boundHostname = this.getSubjectCN(this.sslConnection.getServerCertSubject());
        if (boundHostname == null) {
            throw new IOException(Msg.getString("K0201", null, null));
        }
        String host = this.getHost();
        int idxHostEnd = host.length();
        int idxBoundEnd = boundHostname.length();
        while (true) {
            String boundSegment;
            String hostSegment;
            int idxBoundStart;
            int idxHostStart;
            if ((idxHostStart = host.lastIndexOf(46, idxHostEnd - 1)) == -1) {
                idxHostStart = 0;
            }
            if ((idxBoundStart = boundHostname.lastIndexOf(46, idxBoundEnd - 1)) == -1) {
                idxBoundStart = 0;
            }
            if (!Util.matchesPattern(hostSegment = host.substring(idxHostStart, idxHostEnd).toLowerCase(), boundSegment = boundHostname.substring(idxBoundStart, idxBoundEnd).toLowerCase())) {
                throw new IOException(Msg.getString("K0201", boundHostname, host));
            }
            if (idxHostStart == 0 || idxBoundStart == 0) {
                if (idxHostStart == idxBoundStart) break;
                throw new IOException(Msg.getString("K0201", boundHostname, host));
            }
            idxHostEnd = idxHostStart;
            idxBoundEnd = idxBoundStart;
        }
    }

    protected String getSubjectAltName(X509Certificate cert) {
        try {
            byte[] subjectAltNameBytes = cert.getExtensionValue("2.5.29.17");
            if (subjectAltNameBytes == null) {
                return null;
            }
            ASN1Decoder decoder = new ASN1Decoder(new ByteArrayInputStream(subjectAltNameBytes));
            ASN1Decoder.Node subjectAltName = decoder.readContents();
            if (subjectAltName.type != 4) {
                return null;
            }
            decoder = new ASN1Decoder(new ByteArrayInputStream((byte[])subjectAltName.data));
            ASN1Decoder.Node generalNamesSequence = decoder.readContents();
            if (generalNamesSequence.type != 16) {
                return null;
            }
            ASN1Decoder.Node[] generalNames = (ASN1Decoder.Node[])generalNamesSequence.data;
            int i = 0;
            while (i < generalNames.length) {
                if (generalNames[i].type == 2) {
                    ByteArrayInputStream bis = new ByteArrayInputStream((byte[])subjectAltName.data, generalNames[i].startPosition, generalNames[i].endPosition);
                    decoder = new ASN1Decoder(bis);
                    decoder.configureTypeRedirection(0, new ASN1Decoder.TypeMapper(){

                        public int map(int originalType, int nesting, int sequenceItem) {
                            if (originalType == 2) {
                                return 22;
                            }
                            return originalType;
                        }
                    });
                    ASN1Decoder.Node dNSNameNode = decoder.readContents();
                    if (dNSNameNode.type != 22) {
                        return null;
                    }
                    return (String)dNSNameNode.data;
                }
                ++i;
            }
            return null;
        }
        catch (ASN1Exception aSN1Exception) {
            return null;
        }
    }

    protected String getSubjectCN(String hostName) {
        X500Principal subject = new X500Principal(hostName);
        return subject.getValueForKey("CN");
    }
}

