/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.oti.connection.serversocket;

import com.ibm.oti.connection.ConnectionUtil;
import com.ibm.oti.connection.CreateConnection;
import com.ibm.oti.connection.socket.SocketHelper;
import com.ibm.oti.util.Msg;
import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import javax.microedition.io.ServerSocketConnection;
import javax.microedition.io.StreamConnection;

public class Connection
implements CreateConnection,
ServerSocketConnection {
    static final int DEFAULT_TIMEOUT = 8000;
    private boolean closed = false;
    private int timeout = 0;
    private int backlog = -1;
    private ServerSocket socket;

    public javax.microedition.io.Connection setParameters2(String spec, int access, boolean timeout) throws IOException {
        String[][] equates = ConnectionUtil.NO_PARAMETERS;
        int index = spec.indexOf(59);
        if (index != -1) {
            equates = ConnectionUtil.getParameters(spec.substring(index + 1));
            spec = spec.substring(0, index);
        }
        this.setParameters(spec, equates, access, timeout);
        return this;
    }

    private void setParameters(String spec, String[][] equates, int access, boolean throwTimeout) throws IOException {
        int[] result = new int[1];
        int i = 0;
        while (i < equates.length) {
            String key = equates[i][0];
            equates[i][0] = equates[i][0].toLowerCase();
            if (ConnectionUtil.intParam("so_timeout", equates[i], 1, result)) {
                this.timeout = result[0];
            } else if (ConnectionUtil.intParam("backlog", equates[i], 1, result)) {
                this.backlog = result[0];
            } else {
                throw new IllegalArgumentException(Msg.getString("K00a5", key));
            }
            ++i;
        }
        if (throwTimeout && this.timeout == 0) {
            this.timeout = 8000;
        }
        result[0] = 0;
        SocketHelper.parseURL(spec, result, false, true);
        try {
            this.socket = this.backlog == -1 ? new ServerSocket(result[0]) : new ServerSocket(result[0], this.backlog);
            if (this.timeout > 0) {
                this.socket.setSoTimeout(this.timeout);
            }
        }
        catch (SocketException e) {
            throw new IOException(e.getMessage());
        }
    }

    public void close() throws IOException {
        this.closed = true;
        this.socket.close();
    }

    public StreamConnection acceptAndOpen() throws IOException {
        if (this.closed) {
            throw new IOException(Msg.getString("K00ac"));
        }
        try {
            Socket acceptSocket = this.socket.accept();
            com.ibm.oti.connection.socket.Connection connection = new com.ibm.oti.connection.socket.Connection(acceptSocket);
            return connection;
        }
        catch (SocketException e) {
            throw new IOException(e.getMessage());
        }
    }

    public String getLocalAddress() throws IOException {
        if (this.closed) {
            throw new IOException(Msg.getString("K00ac"));
        }
        InetAddress inet = this.socket.getInetAddress();
        String result = inet.getHostAddress();
        if (inet.isAnyLocalAddress()) {
            return InetAddress.getLocalHost().getHostAddress();
        }
        return result;
    }

    public int getLocalPort() throws IOException {
        if (this.closed) {
            throw new IOException(Msg.getString("K00ac"));
        }
        return this.socket.getLocalPort();
    }
}

