/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.oti.io;

import com.ibm.oti.io.CharacterConverter;

class CharacterConverter_UTF8
extends CharacterConverter {
    CharacterConverter_UTF8() {
    }

    /*
     * Enabled aggressive block sorting
     */
    public int countChars(byte[] value, int offset, int count, int countLimit) {
        if (count < 0) {
            throw new StringIndexOutOfBoundsException();
        }
        int length = offset + count;
        int total = 0;
        int o = offset;
        while (o < length) {
            block18: {
                if (total == countLimit) {
                    return total;
                }
                byte tag = value[o];
                if (tag >= 0) {
                    ++o;
                } else {
                    if ((tag & 0xE0) == 192) {
                        if (o + 1 >= length) return total;
                        if ((value[o + 1] & 0xC0) == 128) {
                            o += 2;
                            break block18;
                        } else {
                            if (total == 0) {
                                return -1;
                            }
                            int n = total;
                            return n;
                        }
                    }
                    if ((tag & 0xF0) == 224) {
                        if (o + 2 >= length) return total;
                        if ((value[o + 1] & 0xC0) == 128 && (value[o + 2] & 0xC0) == 128) {
                            o += 3;
                            break block18;
                        } else {
                            if (total == 0) {
                                return -1;
                            }
                            int n = total;
                            return n;
                        }
                    }
                    if ((tag & 0xF8) == 240) {
                        if (o + 3 >= length) return total;
                        if ((value[o + 1] & 0xC0) == 128 && (value[o + 2] & 0xC0) == 128 && (value[o + 3] & 0xC0) == 128 && (((tag & 7) << 2 | value[o + 1] >> 4 & 3) - 1 & 0x1F) < 16) {
                            o += 4;
                            ++total;
                            break block18;
                        } else {
                            if (total == 0) {
                                return -1;
                            }
                            int n = total;
                            return n;
                        }
                    }
                    if (total == 0) {
                        return -1;
                    }
                    int n = total;
                    return n;
                }
            }
            ++total;
        }
        return total;
    }

    public int convert(byte[] value, int offset, char[] result, int charOffset, int total) {
        int end = charOffset + total;
        while (charOffset < end) {
            byte b;
            if ((b = value[offset++]) >= 0) {
                result[charOffset++] = (char)b;
                continue;
            }
            if ((b & 0xE0) == 192) {
                result[charOffset++] = (char)(((b & 0x1F) << 6) + (value[offset++] & 0x3F));
                continue;
            }
            if ((b & 0xF0) == 224) {
                result[charOffset++] = (char)(((b & 0xF) << 12) + ((value[offset++] & 0x3F) << 6) + (value[offset++] & 0x3F));
                continue;
            }
            result[charOffset++] = (char)((((b & 7) << 2) + (value[offset] >> 4 & 3) - 1 << 6) + ((value[offset++] & 0xF) << 2) + (value[offset] >> 4 & 3) + 55296);
            result[charOffset++] = (char)(((value[offset++] & 0xF) << 6) + (value[offset++] & 0x3F) + 56320);
        }
        return offset;
    }

    public byte[] convert(char[] value, int offset, int count) {
        int total = 0;
        int i = offset + count;
        while (--i >= offset) {
            char ch = value[i];
            if (ch < '\u0080') {
                ++total;
                continue;
            }
            if (ch < '\u0800') {
                total += 2;
                continue;
            }
            if (ch >= '\udc00' && ch < '\ue000' && i > 0 && value[i - 1] >= '\ud800' && value[i - 1] < '\udc00') {
                --i;
                total += 4;
                continue;
            }
            total += 3;
        }
        byte[] result = new byte[total];
        int pos = result.length;
        int i2 = offset + count;
        while (--i2 >= offset) {
            char ch = value[i2];
            if (ch < '\u0080') {
                result[--pos] = (byte)ch;
                continue;
            }
            if (ch < '\u0800') {
                result[--pos] = (byte)(0x80 | ch & 0x3F);
                result[--pos] = (byte)(0xC0 | ch >> 6);
                continue;
            }
            if (ch >= '\udc00' && ch < '\ue000' && i2 > 0 && value[i2 - 1] >= '\ud800' && value[i2 - 1] < '\udc00') {
                int temp = (value[i2 - 1] & 0x3C0) + 64;
                result[--pos] = (byte)(0x80 | ch & 0x3F);
                result[--pos] = (byte)(0x80 | ch >> 6 & 0xF | (value[i2 - 1] & 3) << 4);
                result[--pos] = (byte)(0x80 | value[i2 - 1] >> 2 & 0xF | temp >> 2 & 0x30);
                result[--pos] = (byte)(0xF0 | temp >> 8);
                --i2;
                continue;
            }
            result[--pos] = (byte)(0x80 | ch & 0x3F);
            result[--pos] = (byte)(0x80 | ch >> 6 & 0x3F);
            result[--pos] = (byte)(0xE0 | ch >> 12);
        }
        return result;
    }
}

