/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.oti.io;

import com.ibm.oti.io.CharBuffer;
import com.ibm.oti.io.CharacterConverter;

public class NativeCharacterConverter
extends CharacterConverter {
    private String javaEncoding;
    private long osCodePage = -1L;
    private static boolean supportsNativeConv = NativeCharacterConverter.supportsNativeCharConv();

    public void setJavaEncoding(String encoding) {
        this.javaEncoding = encoding;
    }

    public String getJavaEncoding() {
        return this.javaEncoding;
    }

    private static native boolean supportsNativeCharConv();

    native boolean supportsCodePage(String var1);

    public static boolean supportsNativeConversion() {
        return supportsNativeConv;
    }

    public byte[] convert(char[] value, int offset, int count) {
        if (offset >= 0 && offset <= value.length && count >= 0 && count <= value.length - offset) {
            if (count == 0) {
                return new byte[0];
            }
            return this.convertCharsToBytesImpl(value, offset, count, this.javaEncoding, this.osCodePage);
        }
        throw new IndexOutOfBoundsException();
    }

    private native byte[] convertCharsToBytesImpl(char[] var1, int var2, int var3, String var4, long var5);

    public char[] convert(byte[] value, int offset, int count) {
        if (offset >= 0 && offset <= value.length && count >= 0 && count <= value.length - offset) {
            if (count == 0) {
                return new char[0];
            }
            return this.convertBytesToCharsImpl(value, offset, count, this.javaEncoding, this.osCodePage);
        }
        throw new IndexOutOfBoundsException();
    }

    private native char[] convertBytesToCharsImpl(byte[] var1, int var2, int var3, String var4, long var5);

    public int convert(byte[] value, int offset, int count, CharBuffer buffer) {
        int bytePos = 0;
        int[] charPos = new int[]{buffer.getPos()};
        if (offset >= 0 && offset <= value.length && count >= 0 && count <= value.length - offset) {
            bytePos = this.convertStreamBytesToCharsImpl(value, offset, count, buffer.getChars(), buffer.getOffset(), buffer.getSize(), charPos, this.javaEncoding, this.osCodePage);
            buffer.setPos(charPos[0]);
            return bytePos;
        }
        throw new IndexOutOfBoundsException();
    }

    private native int convertStreamBytesToCharsImpl(byte[] var1, int var2, int var3, char[] var4, int var5, int var6, int[] var7, String var8, long var9);
}

