/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.oti.lang;

import com.ibm.oti.lang.ProcessInputStream;
import com.ibm.oti.lang.ProcessOutputStream;
import com.ibm.oti.util.Util;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class SystemProcess
extends Process {
    InputStream err;
    InputStream out;
    OutputStream in;
    long handle = -1L;
    boolean exitCodeAvailable = false;
    int exitCode;
    Object lock;
    boolean waiterStarted = false;
    Throwable exception = null;

    static {
        SystemProcess.oneTimeInitialization();
    }

    private static native void oneTimeInitialization();

    private SystemProcess() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Process create(String[] progArray, String[] envp, final File directory) throws IOException {
        final byte[][] progBytes = new byte[progArray.length][];
        int i = 0;
        while (i < progArray.length) {
            progBytes[i] = Util.getBytes(progArray[i]);
            ++i;
        }
        final byte[][] envBytes = new byte[envp.length][];
        i = 0;
        while (i < envp.length) {
            envBytes[i] = Util.getBytes(envp[i]);
            ++i;
        }
        SystemProcess p = new SystemProcess();
        p.lock = new Object();
        Runnable waitingThread = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                long[] procVals = null;
                try {
                    procVals = SystemProcess.createImpl(SystemProcess.this, progBytes, envBytes, directory == null ? null : Util.getBytes(directory.getPath()));
                }
                catch (Throwable e) {
                    Object object = SystemProcess.this.lock;
                    synchronized (object) {
                        SystemProcess.this.exception = e;
                        SystemProcess.this.waiterStarted = true;
                        SystemProcess.this.lock.notifyAll();
                    }
                    return;
                }
                SystemProcess.this.handle = procVals[0];
                SystemProcess.this.in = new ProcessOutputStream(procVals[1]);
                SystemProcess.this.out = new ProcessInputStream(procVals[2]);
                SystemProcess.this.err = new ProcessInputStream(procVals[3]);
                Object object = SystemProcess.this.lock;
                synchronized (object) {
                    SystemProcess.this.waiterStarted = true;
                    SystemProcess.this.lock.notifyAll();
                }
                SystemProcess.this.exitCode = SystemProcess.this.waitForCompletionImpl();
                object = SystemProcess.this.lock;
                synchronized (object) {
                    SystemProcess.this.closeImpl();
                    SystemProcess.this.handle = -1L;
                    SystemProcess.this.exitCodeAvailable = true;
                    try {
                        SystemProcess.this.in.close();
                    }
                    catch (IOException iOException) {}
                    SystemProcess.this.lock.notifyAll();
                }
            }
        };
        Thread wait = new Thread(waitingThread);
        wait.setDaemon(true);
        wait.start();
        Object object = p.lock;
        synchronized (object) {
            boolean interrupted = false;
            while (!p.waiterStarted) {
                try {
                    p.lock.wait();
                }
                catch (InterruptedException interruptedException) {
                    interrupted = true;
                }
            }
            if (interrupted) {
                Thread.currentThread().interrupt();
            }
            if (p.exception != null) {
                p.exception.fillInStackTrace();
                if (p.exception instanceof IOException) {
                    throw (IOException)p.exception;
                }
                if (p.exception instanceof Error) {
                    throw (Error)p.exception;
                }
                throw (RuntimeException)p.exception;
            }
        }
        return p;
    }

    protected static synchronized native long[] createImpl(Process var0, byte[][] var1, byte[][] var2, byte[] var3) throws IOException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        Object object = this.lock;
        synchronized (object) {
            if (this.handle != -1L) {
                this.destroyImpl();
            }
        }
    }

    private native void destroyImpl();

    native void closeImpl();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int exitValue() {
        Object object = this.lock;
        synchronized (object) {
            if (!this.exitCodeAvailable) {
                throw new IllegalThreadStateException();
            }
            return this.exitCode;
        }
    }

    public InputStream getErrorStream() {
        return this.err;
    }

    public InputStream getInputStream() {
        return this.out;
    }

    public OutputStream getOutputStream() {
        return this.in;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int waitFor() throws InterruptedException {
        Object object = this.lock;
        synchronized (object) {
            while (!this.exitCodeAvailable) {
                this.lock.wait();
            }
            return this.exitCode;
        }
    }

    native int waitForCompletionImpl();
}

