/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.oti.net.www.protocol.http;

import com.ibm.oti.net.www.protocol.http.AuthCredential;
import com.ibm.oti.net.www.protocol.http.ConnectionInfo;
import com.ibm.oti.security.provider.MD5OutputStream;
import java.io.IOException;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;

public class DigestRequestHeader
extends AuthCredential {
    private static final String PARAM_NONCE = "nonce";
    private static final String PARAM_OPAQUE = "opaque";
    private static final String PARAM_STALE = "stale";
    private static final String PARAM_ALGORITHM = "algorithm";
    private static final String PARAM_QOP = "qop";
    private String uri;
    private String nonce;
    private String opaque;
    private boolean stale;
    private String algorithm;
    private List qop;
    private String cnonce;
    private static Random random = new Random();

    public DigestRequestHeader(int type, String challenge, ConnectionInfo connectionInfo) {
        super(type, challenge, connectionInfo);
        this.uri = connectionInfo.getURI();
    }

    protected void parse(String challenge) {
        int start = 0;
        int end = 0;
        String[] csvValues = this.split(challenge, ',');
        this.realm = this.parseRealm(csvValues);
        int i = 1;
        while (i < csvValues.length) {
            end = csvValues[i].indexOf(61);
            if (start == -1 || start == csvValues[i].length() - 1) {
                throw new IllegalArgumentException();
            }
            String key = csvValues[i].substring(0, end);
            start = end + 1;
            if (csvValues[i].charAt(start) == '\"') {
                if ((end = csvValues[i].indexOf(34, ++start)) == -1) {
                    throw new IllegalArgumentException();
                }
            } else {
                end = csvValues[i].indexOf(44);
                if (end == -1) {
                    end = csvValues[i].length();
                }
            }
            String value = csvValues[i].substring(start, end);
            String normalizedKey = key.toLowerCase();
            if (normalizedKey.equals(PARAM_NONCE)) {
                this.nonce = value;
            } else if (normalizedKey.equals(PARAM_OPAQUE)) {
                this.opaque = value;
            } else if (normalizedKey.equals(PARAM_STALE)) {
                this.stale = value.equalsIgnoreCase("true");
            } else if (normalizedKey.equals(PARAM_ALGORITHM)) {
                this.algorithm = value;
            } else if (normalizedKey.equals(PARAM_QOP)) {
                this.qop = this.parseQOPs(value);
            }
            ++i;
        }
    }

    private List parseQOPs(String value) {
        String[] qops = this.split(value, ',');
        ArrayList result = new ArrayList(qops.length);
        int i = 0;
        while (i < qops.length) {
            if (qops[i].equals("auth")) {
                result.add(qops[i]);
            }
            ++i;
        }
        return result;
    }

    protected String generateAuthorizationResponse() {
        StringBuffer buf = new StringBuffer();
        buf.append("username=\"");
        buf.append(this.getUserName());
        buf.append("\", ");
        buf.append("realm=\"");
        buf.append(this.realm);
        buf.append("\", ");
        buf.append("nonce=\"");
        buf.append(this.getNonce());
        buf.append("\", ");
        buf.append("uri=\"");
        buf.append(this.uri);
        buf.append('\"');
        if (this.getQOP().length() != 0) {
            buf.append(", ");
            buf.append("cnonce=\"");
            buf.append(this.getcNonce());
            buf.append("\", ");
            buf.append("qop=\"");
            buf.append(this.getQOP());
            buf.append("\", ");
            buf.append("nc=");
            buf.append(this.getNonceCount());
        }
        buf.append(", ");
        buf.append("response=\"");
        buf.append(this.getRequestDigest());
        buf.append('\"');
        if (this.opaque != null) {
            buf.append(", ");
            buf.append("opaque=\"");
            buf.append(this.opaque);
            buf.append("\"");
        }
        return buf.toString();
    }

    private String getNonce() {
        return this.nonce;
    }

    private String getcNonce() {
        if (this.cnonce == null) {
            byte[] buffer = new byte[16];
            random.nextBytes(buffer);
            this.cnonce = this.getByteArrayHexString(buffer);
        }
        return this.cnonce;
    }

    private String getRequestDigest() {
        String qop = this.getQOP();
        if (qop == null) {
            return this.getKD(this.getH(this.getA1()), String.valueOf(this.getNonce()) + ":" + this.getH(this.getA2()));
        }
        if (qop.equals("auth") || qop.equals("auth-int")) {
            return this.getKD(this.getH(this.getA1()), String.valueOf(this.getNonce()) + ":" + this.getNonceCount() + ":" + this.getcNonce() + ":" + qop + ":" + this.getH(this.getA2()));
        }
        throw new IllegalArgumentException("Unsupported qop");
    }

    private String getKD(String secret, String data) {
        return this.getH(String.valueOf(secret) + ":" + data);
    }

    private String getNonceCount() {
        String result = "00000000";
        String hexString = Integer.toHexString(this.nonceCount);
        return String.valueOf(result.substring(0, 8 - hexString.length())) + hexString;
    }

    private String getQOP() {
        if (this.qop == null || this.qop.size() == 0) {
            return null;
        }
        return (String)this.qop.get(0);
    }

    private String getA1() {
        if (this.algorithm == null || this.algorithm.equals("MD5")) {
            return String.valueOf(this.getUserName()) + ":" + this.realm + ":" + new String(this.getPassword());
        }
        if (this.algorithm.equals("MD5-sess")) {
            return this.getH(String.valueOf(this.getUserName()) + ":" + this.realm + ":" + new String(this.getPassword()) + ":" + this.getNonce() + ":" + this.getcNonce());
        }
        throw new IllegalArgumentException();
    }

    private String getA2() {
        String qop = this.getQOP();
        if (qop == null || qop.equals("auth")) {
            return String.valueOf(this.connectionInfo.getRequestMethod()) + ":" + this.uri;
        }
        if (qop.equals("auth-int")) {
            return String.valueOf(this.connectionInfo.getRequestMethod()) + ":" + this.uri + ":" + this.getH(this.getEntityBody());
        }
        throw new IllegalArgumentException("qop " + qop + "not supported");
    }

    private String getByteArrayHexString(byte[] digest) {
        StringWriter result = new StringWriter();
        int i = 0;
        while (i < digest.length) {
            String hexByte = Integer.toHexString(256 + digest[i] & 0xFF);
            if (hexByte.length() == 1) {
                result.write(48);
            }
            result.write(hexByte);
            ++i;
        }
        return result.toString();
    }

    private String getH(String data) {
        MD5OutputStream digestStream = new MD5OutputStream(data.getBytes());
        byte[] digest = digestStream.getHashAsBytes();
        try {
            digestStream.close();
        }
        catch (IOException iOException) {}
        return this.getByteArrayHexString(digest);
    }

    private String getEntityBody() {
        return null;
    }

    public String getScheme() {
        return "Digest";
    }

    protected int getMinChallengeParts() {
        return 2;
    }

    protected boolean isStale() {
        String connectionURI = this.connectionInfo.getURI();
        if (!this.uri.equals(connectionURI)) {
            this.uri = connectionURI;
            return true;
        }
        return this.stale;
    }
}

