/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.oti.net.www.protocol.http;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;

public class Header
implements Cloneable {
    private static final int incCapacity = 20;
    private ArrayList props = new ArrayList(20);
    private HashMap keyTable = new HashMap(20);
    private String statusLine;

    public Object clone() {
        try {
            Header clone = (Header)super.clone();
            clone.props = (ArrayList)this.props.clone();
            HashMap cloneTable = clone.keyTable = new HashMap(20);
            Iterator entries = this.keyTable.entrySet().iterator();
            while (entries.hasNext()) {
                Map.Entry next = (Map.Entry)entries.next();
                cloneTable.put(next.getKey(), ((LinkedList)next.getValue()).clone());
            }
            return clone;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    public void add(String key, String value) {
        if (key == null) {
            throw new NullPointerException();
        }
        String lowerKey = key.toLowerCase();
        LinkedList list = (LinkedList)this.keyTable.get(lowerKey);
        if (list == null) {
            list = new LinkedList();
            this.keyTable.put(lowerKey, list);
        }
        list.add(value);
        this.props.add(key);
        this.props.add(value);
    }

    public void set(String key, String value) {
        if (key == null) {
            throw new NullPointerException();
        }
        String lowerKey = key.toLowerCase();
        LinkedList list = (LinkedList)this.keyTable.get(lowerKey);
        if (list == null) {
            this.add(key, value);
        } else {
            list.clear();
            list.add(value);
            int i = 0;
            while (i < this.props.size()) {
                String propKey = (String)this.props.get(i);
                if (propKey != null && key.equalsIgnoreCase(propKey)) {
                    this.props.set(i + 1, value);
                }
                i += 2;
            }
        }
    }

    public void remove(String key) {
        if (key == null) {
            throw new NullPointerException();
        }
        String lowerKey = key.toLowerCase();
        Object removedElement = this.keyTable.remove(lowerKey);
        if (removedElement != null) {
            Iterator iter = this.props.iterator();
            while (iter.hasNext()) {
                String propKey = (String)iter.next();
                if (key.equalsIgnoreCase(propKey)) {
                    iter.remove();
                    iter.next();
                    iter.remove();
                    continue;
                }
                iter.next();
            }
        }
    }

    public Map getFieldMap() {
        HashMap result = new HashMap(this.keyTable.size());
        Iterator iterator = this.keyTable.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry next = (Map.Entry)iterator.next();
            result.put(next.getKey(), Collections.unmodifiableList((LinkedList)next.getValue()));
        }
        return Collections.unmodifiableMap(result);
    }

    public String get(int pos) {
        if (pos >= 0 && pos < this.props.size() / 2) {
            return (String)this.props.get(pos * 2 + 1);
        }
        return null;
    }

    public String getKey(int pos) {
        if (pos >= 0 && pos < this.props.size() / 2) {
            return (String)this.props.get(pos * 2);
        }
        return null;
    }

    public String get(String key) {
        LinkedList result = (LinkedList)this.keyTable.get(key.toLowerCase());
        if (result == null) {
            return null;
        }
        return (String)result.getLast();
    }

    public int length() {
        return this.props.size() / 2;
    }

    public void setStatusLine(String statusLine) {
        this.statusLine = statusLine;
        this.props.add(0, null);
        this.props.add(1, statusLine);
    }

    public String getStatusLine() {
        return this.statusLine;
    }
}

